
fn main() {

    let rect1 = Rectangle { width: 5, height: 7 };
    let rect2 = Rectangle{ width: 6, height: 5 };

    println!("{:?}", Rectangle::square(2, 6));
    println!("{:#?}", rect1.check_holding_capacity_for(&rect2));
}

#[derive(Debug)]
struct Rectangle {
    width: u32,
    height: u32,
}

impl Rectangle {
    fn check_holding_capacity_for(&self, other: &Rectangle) -> bool {
        self.width > other.width && self.height > other.height
    }

    fn square(w: u32, h: u32) -> Rectangle{
        Rectangle{
            width: w,
            height: h
        }
    }
}












































