use std::{env, fs};

fn main() {
    let args: Vec<String> = env::args().collect();

    let query = &args[1];
    let filename = &args[2];

    println!("Searching for {}", query);
    println!("{} found at  {}", query, filename);

    let contents = fs::read_to_string("poem.txt")
        .expect("Something went wrong reading the file");

    println!("Here is the poem: \n{}", contents);
}

// Refactored implementation of above code

// fn main(){
//
//     let args: Vec<String> = env::args().collect();
//
//     let config = parse_options(&args);
//
//     println!("Searching for {}", &config.query);
//     println!("In file {}", &config.filename);
//
//     let contents = fs::read_to_string(config.filename)
//         .expect("Something went wrong reading the file");
//
//     println!("Found:\n{}", contents)
//
// }
//
// pub struct Config{
//     query: String,
//     filename: String
// }
//
//
// fn parse_options(a: &[String]) -> Config  {
//
//     let query = a[1].clone();
//     let filename = a[2].clone();
//
//     Config{ query , filename }
//
// }


// With impl block

// fn main() {
//     let args: Vec<String> = env::args().collect();
//
//     let config = Config::new(&args);
//
//     println!("Searching for {}", &config.query);
//     println!("In file {}", &config.filename);
//
//     let contents = fs::read_to_string(config.filename)
//         .expect("Something went wrong reading the file");
//
//     println!("Found:\n{}", contents)
// }
//
// pub struct Config {
//     query: String,
//     filename: String,
// }
//
// impl Config{
//
//     fn new(a: &[String]) -> Config {
//         let query = a[1].clone();
//         let filename = a[2].clone();
//
//         Config { query, filename }
//     }
//
// }

// With errors handled

// fn main() {
//     let args: Vec<String> = env::args().collect();
//
//     let config = Config::new(&args);
//
//     println!("Searching for {}", &config.query);
//     println!("In file {}", &config.filename);
//
//     let contents = fs::read_to_string(config.filename)
//         .expect("Something went wrong reading the file");
//
//     println!("Found:\n{}", contents)
// }
//
// pub struct Config {
//     query: String,
//     filename: String,
// }
//
// impl Config{
//
//     fn new(a: &[String]) -> Config {
//
//         if a.len() < 3 {
//             panic!("Not enough arguments")
//         }
//
//         else { let query = a[1].clone();
//             let filename = a[2].clone();
//
//             Config { query, filename } }
//
//     }
// }


// Better error handling

// fn main() {
//     let args: Vec<String> = env::args().collect();
//
//     let config = Config::new(&args).
//         unwrap_or_else(|err| {
//             println!("Problem parsing arguments: {}", err);
//             process::exit(1);
//         });
//
//     println!("Searching for {}", &config.query);
//     println!("In file {}", &config.filename);
//
//     let contents = fs::read_to_string(config.filename)
//         .expect("Something went wrong reading the file");
//
//     println!("Found:\n{}", contents)
// }
//
// pub struct Config {
//     query: String,
//     filename: String,
// }
//
// impl Config {
//     fn new(a: &[String]) -> Result<Config, &str> {
//         if a.len() < 3 {
//             return Err("Not enough arguments");
//         }
//
//         let query = a[1].clone();
//         let filename = a[2].clone();
//
//         Ok(Config { query, filename })
//     }
// }

// A separate run function

// fn main() {
//     let args: Vec<String> = env::args().collect();
//
//     let config = Config::new(&args).
//         unwrap_or_else(|err| {
//             println!("Problem parsing arguments: {}", err);
//             process::exit(1);
//         });
//
//     println!("Searching for {}", &config.query);
//     println!("In file {}", &config.filename);
//
//     if let Err(e) = run(config) {
//         println!("Application error: {}", e);
//
//         process::exit(1);
//     }
// }
//
// pub struct Config {
//     query: String,
//     filename: String,
// }
//
// impl Config {
//     fn new(a: &[String]) -> Result<Config, &str> {
//         if a.len() < 3 {
//             return Err("Not enough arguments");
//         }
//
//         let query = a[1].clone();
//         let filename = a[2].clone();
//
//         Ok(Config { query, filename })
//     }
// }
//
// fn run(config: Config) -> Result<(), Box<dyn Error>> {
//     let contents = fs::read_to_string(config.filename)?;
//     println!("With text:\n{}", contents);
//
//     Ok(())
// }


// Put this in main while using it with lib.rs

// fn main() {
//     let args: Vec<String> = env::args().collect();
//
//     let config = Config::new(&args).unwrap_or_else(|err| {
//         println!("Problem parsing arguments: {}", err);
//         process::exit(1);
//     });
//
//     println!("Searching for {}", config.query);
//     println!("In file {}", config.filename);
//
//     if let Err(e) = rust_sample::run(config) {
//         println!("Application error: {}", e);
//
//         process::exit(1);
//     }
// }