

use std::*;
use std::ops::{Add, Mul};

fn main(){

    let add = Numbers{ one: (2), two: (5) };
    println!("{}", add.calc() )

}


struct Numbers <T>{
    one: T,
    two: T
}

trait Calculable<T>{
    fn calc(&self) -> T;
}

impl <T> Calculable<T> for Numbers<T> where T: Copy+Add<Output=T>
{
    fn calc(&self) -> T {
        self.two + self.one
    }
}
