#!/usr/bin/env python3
import subprocess
MESSAGE_FLAG = "BOT MESSAGE: AUTO BUMP VERSION"


def shell_call(cmd:str):
    s = subprocess.run(cmd, shell=True, capture_output=True).stdout
    return s.decode("utf-8").strip()


def bump_version():
    def extract_ver(s)->str:
        with_quotes = s.split("=")[1].strip()
        wo_q = with_quotes.replace('"', '')
        return wo_q

    shell_call("cargo bump patch")
    diff = shell_call("git diff Cargo.toml| grep version | egrep ^[+-]").split("\n")
    assert(len(diff) == 2)
    versions = [extract_ver(v) for v in diff]
    return versions[0], versions[1]


def install_cargo_bump():
    # This step is very slow. Put it here to avoid triggering in non-master branches
    subprocess.run("cargo install cargo-bump", shell=True)


def main():
    # Check if we need to create a new commit
    branch_name = shell_call("git branch --show-current")
    if branch_name not in ['master']:
        print("Current branch  ({})  is not for release. Exiting".format(branch_name))
        return
    commit_log = shell_call("git log --name-status -1")
    if MESSAGE_FLAG in commit_log:
        print("Last commit is generated by bot. Exiting")
        return

    install_cargo_bump()

    # Create a commit
    (old_ver, new_ver) = bump_version()
    version_change_info = " From {} To {}".format(old_ver, new_ver)
    print(version_change_info)

    new_commit_message = MESSAGE_FLAG + version_change_info
    git_commit_cmd = "git add Cargo.toml && git commit  -m '{}'".format(new_commit_message)
    subprocess.run(git_commit_cmd, shell=True)

    commit_log = shell_call("git log --name-status -1")
    print("Created new commit: \n" + commit_log)

    with open("created_new_commit.success", "w") as fout:
        fout.write(commit_log)


main()
