use std::collections::HashMap;

const ATOM_NAMES: [&'static str; 82] = [
    "_NET_SUPPORTED",
    "_NET_CLIENT_LIST",
    "_NET_CLIENT_LIST_STACKING",
    "_NET_NUMBER_OF_DESKTOPS",
    "_NET_DESKTOP_GEOMETRY",
    "_NET_DESKTOP_VIEWPORT",
    "_NET_CURRENT_DESKTOP",
    "_NET_DESKTOP_NAMES",
    "_NET_ACTIVE_WINDOW",
    "_NET_WORKAREA",
    "_NET_SUPPORTING_WM_CHECK",
    "_NET_VIRTUAL_ROOTS",
    "_NET_DESKTOP_LAYOUT",
    "_NET_SHOWING_DESKTOP",
    "_NET_CLOSE_WINDOW",
    "_NET_MOVERESIZE_WINDOW",
    "_NET_WM_MOVERESIZE",
    "_NET_RESTACK_WINDOW",
    "_NET_REQUEST_FRAME_EXTENTS",
    "_NET_WM_NAME",
    "_NET_WM_VISIBLE_NAME",
    "_NET_WM_ICON_NAME",
    "_NET_WM_VISIBLE_ICON_NAME",
    "_NET_WM_DESKTOP",
    "_NET_WM_WINDOW_TYPE",
    "_NET_WM_STATE",
    "_NET_WM_ALLOWED_ACTIONS",
    "_NET_WM_STRUT",
    "_NET_WM_STRUT_PARTIAL",
    "_NET_WM_ICON_GEOMETRY",
    "_NET_WM_ICON",
    "_NET_WM_PID",
    "_NET_WM_HANDLED_ICONS",
    "_NET_WM_USER_TIME",
    "_NET_WM_USER_TIME_WINDOW",
    "_NET_FRAME_EXTENTS",
    "_NET_WM_PING",
    "_NET_WM_SYNC_REQUEST",
    "_NET_WM_SYNC_REQUEST_COUNTER",
    "_NET_WM_FULLSCREEN_MONITORS",
    "_NET_WM_FULL_PLACEMENT",
    "UTF8_STRING",
    "WM_PROTOCOLS",
    "MANAGER",
    "_NET_WM_WINDOW_TYPE_DESKTOP",
    "_NET_WM_WINDOW_TYPE_DOCK",
    "_NET_WM_WINDOW_TYPE_TOOLBAR",
    "_NET_WM_WINDOW_TYPE_MENU",
    "_NET_WM_WINDOW_TYPE_UTILITY",
    "_NET_WM_WINDOW_TYPE_SPLASH",
    "_NET_WM_WINDOW_TYPE_DIALOG",
    "_NET_WM_WINDOW_TYPE_DROPDOWN_MENU",
    "_NET_WM_WINDOW_TYPE_POPUP_MENU",
    "_NET_WM_WINDOW_TYPE_TOOLTIP",
    "_NET_WM_WINDOW_TYPE_NOTIFICATION",
    "_NET_WM_WINDOW_TYPE_COMBO",
    "_NET_WM_WINDOW_TYPE_DND",
    "_NET_WM_WINDOW_TYPE_NORMAL",
    "_NET_WM_STATE_MODAL",
    "_NET_WM_STATE_STICKY",
    "_NET_WM_STATE_MAXIMIZED_VERT",
    "_NET_WM_STATE_MAXIMIZED_HORZ",
    "_NET_WM_STATE_SHADED",
    "_NET_WM_STATE_SKIP_TASKBAR",
    "_NET_WM_STATE_SKIP_PAGER",
    "_NET_WM_STATE_HIDDEN",
    "_NET_WM_STATE_FULLSCREEN",
    "_NET_WM_STATE_ABOVE",
    "_NET_WM_STATE_BELOW",
    "_NET_WM_STATE_DEMANDS_ATTENTION",
    "_NET_WM_ACTION_MOVE",
    "_NET_WM_ACTION_RESIZE",
    "_NET_WM_ACTION_MINIMIZE",
    "_NET_WM_ACTION_SHADE",
    "_NET_WM_ACTION_STICK",
    "_NET_WM_ACTION_MAXIMIZE_HORZ",
    "_NET_WM_ACTION_MAXIMIZE_VERT",
    "_NET_WM_ACTION_FULLSCREEN",
    "_NET_WM_ACTION_CHANGE_DESKTOP",
    "_NET_WM_ACTION_CLOSE",
    "_NET_WM_ACTION_ABOVE",
    "_NET_WM_ACTION_BELOW"
];

pub struct Atoms {
    // TODO _NET_WM_CM_Sn atoms
    pub _NET_SUPPORTED: xcb::x::Atom,
    pub _NET_CLIENT_LIST: xcb::x::Atom,
    pub _NET_CLIENT_LIST_STACKING: xcb::x::Atom,
    pub _NET_NUMBER_OF_DESKTOPS: xcb::x::Atom,
    pub _NET_DESKTOP_GEOMETRY: xcb::x::Atom,
    pub _NET_DESKTOP_VIEWPORT: xcb::x::Atom,
    pub _NET_CURRENT_DESKTOP: xcb::x::Atom,
    pub _NET_DESKTOP_NAMES: xcb::x::Atom,
    pub _NET_ACTIVE_WINDOW: xcb::x::Atom,
    pub _NET_WORKAREA: xcb::x::Atom,
    pub _NET_SUPPORTING_WM_CHECK: xcb::x::Atom,
    pub _NET_VIRTUAL_ROOTS: xcb::x::Atom,
    pub _NET_DESKTOP_LAYOUT: xcb::x::Atom,
    pub _NET_SHOWING_DESKTOP: xcb::x::Atom,
    pub _NET_CLOSE_WINDOW: xcb::x::Atom,
    pub _NET_MOVERESIZE_WINDOW: xcb::x::Atom,
    pub _NET_WM_MOVERESIZE: xcb::x::Atom,
    pub _NET_RESTACK_WINDOW: xcb::x::Atom,
    pub _NET_REQUEST_FRAME_EXTENTS: xcb::x::Atom,
    pub _NET_WM_NAME: xcb::x::Atom,
    pub _NET_WM_VISIBLE_NAME: xcb::x::Atom,
    pub _NET_WM_ICON_NAME: xcb::x::Atom,
    pub _NET_WM_VISIBLE_ICON_NAME: xcb::x::Atom,
    pub _NET_WM_DESKTOP: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE: xcb::x::Atom,
    pub _NET_WM_STATE: xcb::x::Atom,
    pub _NET_WM_ALLOWED_ACTIONS: xcb::x::Atom,
    pub _NET_WM_STRUT: xcb::x::Atom,
    pub _NET_WM_STRUT_PARTIAL: xcb::x::Atom,
    pub _NET_WM_ICON_GEOMETRY: xcb::x::Atom,
    pub _NET_WM_ICON: xcb::x::Atom,
    pub _NET_WM_PID: xcb::x::Atom,
    pub _NET_WM_HANDLED_ICONS: xcb::x::Atom,
    pub _NET_WM_USER_TIME: xcb::x::Atom,
    pub _NET_WM_USER_TIME_WINDOW: xcb::x::Atom,
    pub _NET_FRAME_EXTENTS: xcb::x::Atom,
    pub _NET_WM_PING: xcb::x::Atom,
    pub _NET_WM_SYNC_REQUEST: xcb::x::Atom,
    pub _NET_WM_SYNC_REQUEST_COUNTER: xcb::x::Atom,
    pub _NET_WM_FULLSCREEN_MONITORS: xcb::x::Atom,
    pub _NET_WM_FULL_PLACEMENT: xcb::x::Atom,
    pub UTF8_STRING: xcb::x::Atom,
    pub WM_PROTOCOLS: xcb::x::Atom,
    pub MANAGER: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_DESKTOP: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_DOCK: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_TOOLBAR: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_MENU: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_UTILITY: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_SPLASH: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_DIALOG: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_DROPDOWN_MENU: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_POPUP_MENU: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_TOOLTIP: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_NOTIFICATION: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_COMBO: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_DND: xcb::x::Atom,
    pub _NET_WM_WINDOW_TYPE_NORMAL: xcb::x::Atom,
    pub _NET_WM_STATE_MODAL: xcb::x::Atom,
    pub _NET_WM_STATE_STICKY: xcb::x::Atom,
    pub _NET_WM_STATE_MAXIMIZED_VERT: xcb::x::Atom,
    pub _NET_WM_STATE_MAXIMIZED_HORZ: xcb::x::Atom,
    pub _NET_WM_STATE_SHADED: xcb::x::Atom,
    pub _NET_WM_STATE_SKIP_TASKBAR: xcb::x::Atom,
    pub _NET_WM_STATE_SKIP_PAGER: xcb::x::Atom,
    pub _NET_WM_STATE_HIDDEN: xcb::x::Atom,
    pub _NET_WM_STATE_FULLSCREEN: xcb::x::Atom,
    pub _NET_WM_STATE_ABOVE: xcb::x::Atom,
    pub _NET_WM_STATE_BELOW: xcb::x::Atom,
    pub _NET_WM_STATE_DEMANDS_ATTENTION: xcb::x::Atom,
    pub _NET_WM_ACTION_MOVE: xcb::x::Atom,
    pub _NET_WM_ACTION_RESIZE: xcb::x::Atom,
    pub _NET_WM_ACTION_MINIMIZE: xcb::x::Atom,
    pub _NET_WM_ACTION_SHADE: xcb::x::Atom,
    pub _NET_WM_ACTION_STICK: xcb::x::Atom,
    pub _NET_WM_ACTION_MAXIMIZE_HORZ: xcb::x::Atom,
    pub _NET_WM_ACTION_MAXIMIZE_VERT: xcb::x::Atom,
    pub _NET_WM_ACTION_FULLSCREEN: xcb::x::Atom,
    pub _NET_WM_ACTION_CHANGE_DESKTOP: xcb::x::Atom,
    pub _NET_WM_ACTION_CLOSE: xcb::x::Atom,
    pub _NET_WM_ACTION_ABOVE: xcb::x::Atom,
    pub _NET_WM_ACTION_BELOW: xcb::x::Atom
}


impl Atoms {
    pub (crate) fn intern(con: &xcb::Connection) -> Atoms {
        let mut cookies: HashMap<&'static str, xcb::x::InternAtomCookie> = HashMap::new();

        for atom in ATOM_NAMES {
            let intern_atom = xcb::x::InternAtom {
                only_if_exists: false,
                name: atom.as_bytes(),
            };

            cookies.insert(atom, con.send_request(&intern_atom));
        }

        let interned_atoms: HashMap<&'static str, xcb::x::Atom> = cookies.into_iter()
            .map(|(atom_name, cookie)| (atom_name, con.wait_for_reply(cookie).unwrap()))
            .map(|(atom_name, reply)| (atom_name, reply.atom()))
            .collect();

        Atoms::from_interned_atoms(interned_atoms)
    }

    fn from_interned_atoms(mut atoms: HashMap<&'static str, xcb::x::Atom>) -> Atoms {
        Atoms {
            _NET_SUPPORTED: atoms.remove("_NET_SUPPORTED").unwrap(),
            _NET_CLIENT_LIST: atoms.remove("_NET_CLIENT_LIST").unwrap(),
            _NET_CLIENT_LIST_STACKING: atoms.remove("_NET_CLIENT_LIST_STACKING").unwrap(),
            _NET_NUMBER_OF_DESKTOPS: atoms.remove("_NET_NUMBER_OF_DESKTOPS").unwrap(),
            _NET_DESKTOP_GEOMETRY: atoms.remove("_NET_DESKTOP_GEOMETRY").unwrap(),
            _NET_DESKTOP_VIEWPORT: atoms.remove("_NET_DESKTOP_VIEWPORT").unwrap(),
            _NET_CURRENT_DESKTOP: atoms.remove("_NET_CURRENT_DESKTOP").unwrap(),
            _NET_DESKTOP_NAMES: atoms.remove("_NET_DESKTOP_NAMES").unwrap(),
            _NET_ACTIVE_WINDOW: atoms.remove("_NET_ACTIVE_WINDOW").unwrap(),
            _NET_WORKAREA: atoms.remove("_NET_WORKAREA").unwrap(),
            _NET_SUPPORTING_WM_CHECK: atoms.remove("_NET_SUPPORTING_WM_CHECK").unwrap(),
            _NET_VIRTUAL_ROOTS: atoms.remove("_NET_VIRTUAL_ROOTS").unwrap(),
            _NET_DESKTOP_LAYOUT: atoms.remove("_NET_DESKTOP_LAYOUT").unwrap(),
            _NET_SHOWING_DESKTOP: atoms.remove("_NET_SHOWING_DESKTOP").unwrap(),
            _NET_CLOSE_WINDOW: atoms.remove("_NET_CLOSE_WINDOW").unwrap(),
            _NET_MOVERESIZE_WINDOW: atoms.remove("_NET_MOVERESIZE_WINDOW").unwrap(),
            _NET_WM_MOVERESIZE: atoms.remove("_NET_WM_MOVERESIZE").unwrap(),
            _NET_RESTACK_WINDOW: atoms.remove("_NET_RESTACK_WINDOW").unwrap(),
            _NET_REQUEST_FRAME_EXTENTS: atoms.remove("_NET_REQUEST_FRAME_EXTENTS").unwrap(),
            _NET_WM_NAME: atoms.remove("_NET_WM_NAME").unwrap(),
            _NET_WM_VISIBLE_NAME: atoms.remove("_NET_WM_VISIBLE_NAME").unwrap(),
            _NET_WM_ICON_NAME: atoms.remove("_NET_WM_ICON_NAME").unwrap(),
            _NET_WM_VISIBLE_ICON_NAME: atoms.remove("_NET_WM_VISIBLE_ICON_NAME").unwrap(),
            _NET_WM_DESKTOP: atoms.remove("_NET_WM_DESKTOP").unwrap(),
            _NET_WM_WINDOW_TYPE: atoms.remove("_NET_WM_WINDOW_TYPE").unwrap(),
            _NET_WM_STATE: atoms.remove("_NET_WM_STATE").unwrap(),
            _NET_WM_ALLOWED_ACTIONS: atoms.remove("_NET_WM_ALLOWED_ACTIONS").unwrap(),
            _NET_WM_STRUT: atoms.remove("_NET_WM_STRUT").unwrap(),
            _NET_WM_STRUT_PARTIAL: atoms.remove("_NET_WM_STRUT_PARTIAL").unwrap(),
            _NET_WM_ICON_GEOMETRY: atoms.remove("_NET_WM_ICON_GEOMETRY").unwrap(),
            _NET_WM_ICON: atoms.remove("_NET_WM_ICON").unwrap(),
            _NET_WM_PID: atoms.remove("_NET_WM_PID").unwrap(),
            _NET_WM_HANDLED_ICONS: atoms.remove("_NET_WM_HANDLED_ICONS").unwrap(),
            _NET_WM_USER_TIME: atoms.remove("_NET_WM_USER_TIME").unwrap(),
            _NET_WM_USER_TIME_WINDOW: atoms.remove("_NET_WM_USER_TIME_WINDOW").unwrap(),
            _NET_FRAME_EXTENTS: atoms.remove("_NET_FRAME_EXTENTS").unwrap(),
            _NET_WM_PING: atoms.remove("_NET_WM_PING").unwrap(),
            _NET_WM_SYNC_REQUEST: atoms.remove("_NET_WM_SYNC_REQUEST").unwrap(),
            _NET_WM_SYNC_REQUEST_COUNTER: atoms.remove("_NET_WM_SYNC_REQUEST_COUNTER").unwrap(),
            _NET_WM_FULLSCREEN_MONITORS: atoms.remove("_NET_WM_FULLSCREEN_MONITORS").unwrap(),
            _NET_WM_FULL_PLACEMENT: atoms.remove("_NET_WM_FULL_PLACEMENT").unwrap(),
            UTF8_STRING: atoms.remove("UTF8_STRING").unwrap(),
            WM_PROTOCOLS: atoms.remove("WM_PROTOCOLS").unwrap(),
            MANAGER: atoms.remove("MANAGER").unwrap(),
            _NET_WM_WINDOW_TYPE_DESKTOP: atoms.remove("_NET_WM_WINDOW_TYPE_DESKTOP").unwrap(),
            _NET_WM_WINDOW_TYPE_DOCK: atoms.remove("_NET_WM_WINDOW_TYPE_DOCK").unwrap(),
            _NET_WM_WINDOW_TYPE_TOOLBAR: atoms.remove("_NET_WM_WINDOW_TYPE_TOOLBAR").unwrap(),
            _NET_WM_WINDOW_TYPE_MENU: atoms.remove("_NET_WM_WINDOW_TYPE_MENU").unwrap(),
            _NET_WM_WINDOW_TYPE_UTILITY: atoms.remove("_NET_WM_WINDOW_TYPE_UTILITY").unwrap(),
            _NET_WM_WINDOW_TYPE_SPLASH: atoms.remove("_NET_WM_WINDOW_TYPE_SPLASH").unwrap(),
            _NET_WM_WINDOW_TYPE_DIALOG: atoms.remove("_NET_WM_WINDOW_TYPE_DIALOG").unwrap(),
            _NET_WM_WINDOW_TYPE_DROPDOWN_MENU: atoms.remove("_NET_WM_WINDOW_TYPE_DROPDOWN_MENU").unwrap(),
            _NET_WM_WINDOW_TYPE_POPUP_MENU: atoms.remove("_NET_WM_WINDOW_TYPE_POPUP_MENU").unwrap(),
            _NET_WM_WINDOW_TYPE_TOOLTIP: atoms.remove("_NET_WM_WINDOW_TYPE_TOOLTIP").unwrap(),
            _NET_WM_WINDOW_TYPE_NOTIFICATION: atoms.remove("_NET_WM_WINDOW_TYPE_NOTIFICATION").unwrap(),
            _NET_WM_WINDOW_TYPE_COMBO: atoms.remove("_NET_WM_WINDOW_TYPE_COMBO").unwrap(),
            _NET_WM_WINDOW_TYPE_DND: atoms.remove("_NET_WM_WINDOW_TYPE_DND").unwrap(),
            _NET_WM_WINDOW_TYPE_NORMAL: atoms.remove("_NET_WM_WINDOW_TYPE_NORMAL").unwrap(),
            _NET_WM_STATE_MODAL: atoms.remove("_NET_WM_STATE_MODAL").unwrap(),
            _NET_WM_STATE_STICKY: atoms.remove("_NET_WM_STATE_STICKY").unwrap(),
            _NET_WM_STATE_MAXIMIZED_VERT: atoms.remove("_NET_WM_STATE_MAXIMIZED_VERT").unwrap(),
            _NET_WM_STATE_MAXIMIZED_HORZ: atoms.remove("_NET_WM_STATE_MAXIMIZED_HORZ").unwrap(),
            _NET_WM_STATE_SHADED: atoms.remove("_NET_WM_STATE_SHADED").unwrap(),
            _NET_WM_STATE_SKIP_TASKBAR: atoms.remove("_NET_WM_STATE_SKIP_TASKBAR").unwrap(),
            _NET_WM_STATE_SKIP_PAGER: atoms.remove("_NET_WM_STATE_SKIP_PAGER").unwrap(),
            _NET_WM_STATE_HIDDEN: atoms.remove("_NET_WM_STATE_HIDDEN").unwrap(),
            _NET_WM_STATE_FULLSCREEN: atoms.remove("_NET_WM_STATE_FULLSCREEN").unwrap(),
            _NET_WM_STATE_ABOVE: atoms.remove("_NET_WM_STATE_ABOVE").unwrap(),
            _NET_WM_STATE_BELOW: atoms.remove("_NET_WM_STATE_BELOW").unwrap(),
            _NET_WM_STATE_DEMANDS_ATTENTION: atoms.remove("_NET_WM_STATE_DEMANDS_ATTENTION").unwrap(),
            _NET_WM_ACTION_MOVE: atoms.remove("_NET_WM_ACTION_MOVE").unwrap(),
            _NET_WM_ACTION_RESIZE: atoms.remove("_NET_WM_ACTION_RESIZE").unwrap(),
            _NET_WM_ACTION_MINIMIZE: atoms.remove("_NET_WM_ACTION_MINIMIZE").unwrap(),
            _NET_WM_ACTION_SHADE: atoms.remove("_NET_WM_ACTION_SHADE").unwrap(),
            _NET_WM_ACTION_STICK: atoms.remove("_NET_WM_ACTION_STICK").unwrap(),
            _NET_WM_ACTION_MAXIMIZE_HORZ: atoms.remove("_NET_WM_ACTION_MAXIMIZE_HORZ").unwrap(),
            _NET_WM_ACTION_MAXIMIZE_VERT: atoms.remove("_NET_WM_ACTION_MAXIMIZE_VERT").unwrap(),
            _NET_WM_ACTION_FULLSCREEN: atoms.remove("_NET_WM_ACTION_FULLSCREEN").unwrap(),
            _NET_WM_ACTION_CHANGE_DESKTOP: atoms.remove("_NET_WM_ACTION_CHANGE_DESKTOP").unwrap(),
            _NET_WM_ACTION_CLOSE: atoms.remove("_NET_WM_ACTION_CLOSE").unwrap(),
            _NET_WM_ACTION_ABOVE: atoms.remove("_NET_WM_ACTION_ABOVE").unwrap(),
            _NET_WM_ACTION_BELOW: atoms.remove("_NET_WM_ACTION_BELOW").unwrap(),
        }
    }
}
