## Crates.io
> https://crates.io/
>
> https://doc.rust-lang.org/cargo/getting-started/

## 创建并登录Crates.io账号
发布crate前, 需要在 crates.io 创建账号(使用github授权登录)并获得API token

![](readme-assets/00.png)

运行命令: `cargo login [你的API token]`
- 通知cargo, 你的 API token 存储在本地 `~/.cargo/credentials` 文件中

![](readme-assets/01.png)
- revoke 撤销之前设置的token

![](readme-assets/02.png)

![](readme-assets/03.png)

## 为新的 crate 添加元数据
在发布 crate 之前, 需要在 `Cargo.toml` 的 `[package]` 区域为 crate 添加一些元数据:
- crate 需要唯一的名称(name)
  - 在 Crates.io 上搜一下, 看是否已被占用
- description: 一两句话即可, 会出现在 crate 搜索的结果里
- license: 需要提高许可证标识值 (可到 http://spdx.org/licenses/ 查找)
 - 可指定多个 license, 用 OR 隔开
- version
- author

## cargo publish发布
```shell
cargo publish
```

### 一旦发布, 就是永久性的
crate 一旦发布, 就是永久性的
- 版本无法覆盖
- 代码无法删除

这是因为 Crates.io 希望成为一个永久的代码文档服务器, 并保证所有依赖于 Crates.io 的包都能一直正常构建

如果允许开发者删除已经发布的版本, 那就根本无法达到这个目的。

### 发布已存在 crate 的新版本
修改 crate 后, 需要先修改 Cargo.toml 里面的 version 值, 再进行重新发布

参照 http://semver.org/ 来更新你的语义版本

### 报错汇总
![](readme-assets/04.png)
+ 登入 Crates.io 的账号必须要验证邮箱

Cargo.toml 内必须包含的`[package]`元信息如本次提交所示

## cargo yank撤回
`cargo yank`命令可以从 `Crates.io` 撤回版本

```shell
cargo yank --vers 1.0.0
```

这里的撤回 并不是指 删除之前发布的版本,

而只是防止其它新的项目把它作为新的依赖

并不会影响已经存在的项目继续将其（这个版本）作为依赖和下载
- 即那些已经记录在 Cargo.lock 中的项目并不会中断对该版本的使用
- 但任何在我们撤回动作之后项目 都无法使用这个被 yank 的版本

### 取消撤回
我们还能取消我们的撤回

```shell
cargo yank --vers 1.0.0 --undo
```
