/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const _FEATURES_H: u32 = 1;
pub const __USE_ANSI: u32 = 1;
pub const _BSD_SOURCE: u32 = 1;
pub const _SVID_SOURCE: u32 = 1;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_BSD: u32 = 1;
pub const __USE_SVID: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201103;
pub const __STDC_NO_THREADS__: u32 = 1;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 17;
pub const __GLIBC_HAVE_LONG_LONG: u32 = 1;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const _ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const _SIGSET_H_types: u32 = 1;
pub const __timespec_defined: u32 = 1;
pub const _STRUCT_TIMEVAL: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _SYS_SYSMACROS_H: u32 = 1;
pub const _BITS_PTHREADTYPES_H: u32 = 1;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const __have_pthread_attr_t: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __PTHREAD_RWLOCK_INT_FLAGS_SHARED: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STDIO_H: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const _G_config_h: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _G_HAVE_MMAP: u32 = 1;
pub const _G_HAVE_MREMAP: u32 = 1;
pub const _G_IO_IO_FILE_VERSION: u32 = 131073;
pub const _G_BUFSIZ: u32 = 8192;
pub const _IO_BUFSIZ: u32 = 8192;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _IO_UNIFIED_JUMPTABLES: u32 = 1;
pub const EOF: i32 = -1;
pub const _IOS_INPUT: u32 = 1;
pub const _IOS_OUTPUT: u32 = 2;
pub const _IOS_ATEND: u32 = 4;
pub const _IOS_APPEND: u32 = 8;
pub const _IOS_TRUNC: u32 = 16;
pub const _IOS_NOCREATE: u32 = 32;
pub const _IOS_NOREPLACE: u32 = 64;
pub const _IOS_BIN: u32 = 128;
pub const _IO_MAGIC: u32 = 4222418944;
pub const _OLD_STDIO_MAGIC: u32 = 4206624768;
pub const _IO_MAGIC_MASK: u32 = 4294901760;
pub const _IO_USER_BUF: u32 = 1;
pub const _IO_UNBUFFERED: u32 = 2;
pub const _IO_NO_READS: u32 = 4;
pub const _IO_NO_WRITES: u32 = 8;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_DELETE_DONT_CLOSE: u32 = 64;
pub const _IO_LINKED: u32 = 128;
pub const _IO_IN_BACKUP: u32 = 256;
pub const _IO_LINE_BUF: u32 = 512;
pub const _IO_TIED_PUT_GET: u32 = 1024;
pub const _IO_CURRENTLY_PUTTING: u32 = 2048;
pub const _IO_IS_APPENDING: u32 = 4096;
pub const _IO_IS_FILEBUF: u32 = 8192;
pub const _IO_BAD_SEEN: u32 = 16384;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IO_FLAGS2_MMAP: u32 = 1;
pub const _IO_FLAGS2_NOTCANCEL: u32 = 2;
pub const _IO_FLAGS2_USER_WBUF: u32 = 8;
pub const _IO_SKIPWS: u32 = 1;
pub const _IO_LEFT: u32 = 2;
pub const _IO_RIGHT: u32 = 4;
pub const _IO_INTERNAL: u32 = 8;
pub const _IO_DEC: u32 = 16;
pub const _IO_OCT: u32 = 32;
pub const _IO_HEX: u32 = 64;
pub const _IO_SHOWBASE: u32 = 128;
pub const _IO_SHOWPOINT: u32 = 256;
pub const _IO_UPPERCASE: u32 = 512;
pub const _IO_SHOWPOS: u32 = 1024;
pub const _IO_SCIENTIFIC: u32 = 2048;
pub const _IO_FIXED: u32 = 4096;
pub const _IO_UNITBUF: u32 = 8192;
pub const _IO_STDIO: u32 = 16384;
pub const _IO_DONT_CLOSE: u32 = 32768;
pub const _IO_BOOLALPHA: u32 = 65536;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const __WCHAR_MIN: i32 = -2147483648;
pub const __WCHAR_MAX: u32 = 2147483647;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WCHAR_MIN: i32 = -2147483648;
pub const WCHAR_MAX: u32 = 2147483647;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const _INTTYPES_H: u32 = 1;
pub const ____gwchar_t_defined: u32 = 1;
pub const __PRI64_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const __PRIPTR_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const PRId8: &'static [u8; 2usize] = b"d\0";
pub const PRId16: &'static [u8; 2usize] = b"d\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRId64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdLEAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST16: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIi8: &'static [u8; 2usize] = b"i\0";
pub const PRIi16: &'static [u8; 2usize] = b"i\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIi64: &'static [u8; 3usize] = b"li\0";
pub const PRIiLEAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST16: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST32: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIo8: &'static [u8; 2usize] = b"o\0";
pub const PRIo16: &'static [u8; 2usize] = b"o\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIo64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoLEAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST16: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIu8: &'static [u8; 2usize] = b"u\0";
pub const PRIu16: &'static [u8; 2usize] = b"u\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIu64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuLEAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST16: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIx8: &'static [u8; 2usize] = b"x\0";
pub const PRIx16: &'static [u8; 2usize] = b"x\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIx64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxLEAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST16: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIX8: &'static [u8; 2usize] = b"X\0";
pub const PRIX16: &'static [u8; 2usize] = b"X\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRIX64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXLEAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST16: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST32: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"ld\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"li\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"lo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"lu\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"lx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"lX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNd64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNi64: &'static [u8; 3usize] = b"li\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST32: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNu64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNo64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNx64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"ld\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"li\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"lo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"lu\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"lx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const U128X_F: &'static [u8; 8usize] = b"%lx:%lx\0";
pub const U128D_F: &'static [u8; 8usize] = b"%ld:%ld\0";
pub const U128I_F: &'static [u8; 8usize] = b"%li:%li\0";
pub const U128X_F_SAFE: &'static [u8; 10usize] = b"%s%lx:%lx\0";
pub const BUF_F: &'static [u8; 10usize] = b"[%p,%llu]\0";
pub const M0_ASSERT_OFF: u32 = 0;
pub const M0_ASSERT_EX_ON: u32 = 0;
pub const _STRING_H: u32 = 1;
pub const _XLOCALE_H: u32 = 1;
pub const TIME_F: &'static [u8; 12usize] = b"[%lu:%09lu]\0";
pub const _TIME_H: u32 = 1;
pub const _BITS_TIME_H: u32 = 1;
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const TIME_UTC: u32 = 1;
pub const _PTHREAD_H: u32 = 1;
pub const _SCHED_H: u32 = 1;
pub const SCHED_OTHER: u32 = 0;
pub const SCHED_FIFO: u32 = 1;
pub const SCHED_RR: u32 = 2;
pub const __defined_schedparam: u32 = 1;
pub const __CPU_SETSIZE: u32 = 1024;
pub const _BITS_SETJMP_H: u32 = 1;
pub const PTHREAD_ONCE_INIT: u32 = 0;
pub const PTHREAD_BARRIER_SERIAL_THREAD: i32 = -1;
pub const _SETJMP_H: u32 = 1;
pub const _SIGSET_H_fns: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGBUS: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGUSR1: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGUSR2: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGSTKFLT: u32 = 16;
pub const SIGCHLD: u32 = 17;
pub const SIGCONT: u32 = 18;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGURG: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGPWR: u32 = 30;
pub const SIGSYS: u32 = 31;
pub const SIGUNUSED: u32 = 31;
pub const _NSIG: u32 = 65;
pub const __SIGRTMIN: u32 = 32;
pub const __SIGRTMAX: u32 = 64;
pub const __have_sigval_t: u32 = 1;
pub const __have_siginfo_t: u32 = 1;
pub const __SI_MAX_SIZE: u32 = 128;
pub const __have_sigevent_t: u32 = 1;
pub const __SIGEV_MAX_SIZE: u32 = 64;
pub const NSIG: u32 = 65;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_INTERRUPT: u32 = 536870912;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SA_STACK: u32 = 134217728;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const _BITS_SIGCONTEXT_H: u32 = 1;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const _SYS_UCONTEXT_H: u32 = 1;
pub const NGREG: u32 = 23;
pub const _BITS_SIGTHREAD_H: u32 = 1;
pub const _SEMAPHORE_H: u32 = 1;
pub const __SIZEOF_SEM_T: u32 = 32;
pub const FID_F: &'static [u8; 10usize] = b"<%lx:%lx>\0";
pub const FID_SF: &'static [u8; 16usize] = b" < %lx : %lx > \0";
pub const M0_COMPOSITE_EXTENT_INF: i32 = -1;
pub const M0_DEBUG_BE_CREDITS: u32 = 1;
pub const BETXCR_F: &'static [u8; 10usize] = b"(%lu,%lu)\0";
pub const M0_BE_SEG_PG_PRESENT: i64 = -9223372036854775808;
pub const M0_BE_SEG_PG_PIN_CNT_MASK: u64 = 9223372036854775807;
pub const M0_BE_MUTEX_PAD: u32 = 168;
pub const M0_BE_RWLOCK_PAD: u32 = 144;
pub const EXT_F: &'static [u8; 11usize] = b"[%lx, %lx)\0";
pub const MAXPATHLEN: u32 = 1024;
pub const STOB_ID_F: &'static [u8; 22usize] = b"{<%lx:%lx>,<%lx:%lx>}\0";
pub const FOM_PHASE_DEBUG: u32 = 1;
pub const _CTYPE_H: u32 = 1;
pub const DTS0_F: &'static [u8; 5usize] = b"@%lu\0";
pub const DTID0_F: &'static [u8; 17usize] = b"{@%lu,<%lx:%lx>}\0";
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __qaddr_t = *mut __quad_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub __wait_terminated: wait__bindgen_ty_1,
    pub __wait_stopped: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn __w_termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set___w_termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___w_coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_termsig: ::std::os::raw::c_uint,
        __w_coredump: ::std::os::raw::c_uint,
        __w_retcode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let __w_termsig: u32 = unsafe { ::std::mem::transmute(__w_termsig) };
            __w_termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __w_coredump: u32 = unsafe { ::std::mem::transmute(__w_coredump) };
            __w_coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_retcode: u32 = unsafe { ::std::mem::transmute(__w_retcode) };
            __w_retcode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn __w_stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn __w_stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set___w_stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __w_stopval: ::std::os::raw::c_uint,
        __w_stopsig: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let __w_stopval: u32 = unsafe { ::std::mem::transmute(__w_stopval) };
            __w_stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let __w_stopsig: u32 = unsafe { ::std::mem::transmute(__w_stopsig) };
            __w_stopsig as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_terminated as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_terminated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).__wait_stopped as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(__wait_stopped)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __WAIT_STATUS {
    pub __uptr: *mut wait,
    pub __iptr: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___WAIT_STATUS() {
    assert_eq!(
        ::std::mem::size_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Size of: ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        ::std::mem::align_of::<__WAIT_STATUS>(),
        8usize,
        concat!("Alignment of ", stringify!(__WAIT_STATUS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__uptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__uptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__WAIT_STATUS>())).__iptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__WAIT_STATUS),
            "::",
            stringify!(__iptr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type ssize_t = __ssize_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type time_t = __time_t;
pub type clockid_t = __clockid_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type register_t = ::std::os::raw::c_long;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gnu_dev_major(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_minor(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_makedev(
        __major: ::std::os::raw::c_uint,
        __minor: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: pthread_mutex_t___pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_mutex_t___pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t___pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t___pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t___pthread_mutex_s>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pthread_mutex_t___pthread_mutex_s)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__lock as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__owner as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__nusers as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__kind as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__spins as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__elision as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_mutex_t___pthread_mutex_s>())).__list as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: pthread_cond_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_cond_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __futex: ::std::os::raw::c_uint,
    pub __total_seq: ::std::os::raw::c_ulonglong,
    pub __wakeup_seq: ::std::os::raw::c_ulonglong,
    pub __woken_seq: ::std::os::raw::c_ulonglong,
    pub __mutex: *mut ::std::os::raw::c_void,
    pub __nwaiters: ::std::os::raw::c_uint,
    pub __broadcast_seq: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__futex as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__total_seq as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__total_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__wakeup_seq as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__wakeup_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__woken_seq as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__woken_seq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__mutex as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__nwaiters as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__nwaiters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_cond_t__bindgen_ty_1>())).__broadcast_seq as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__broadcast_seq)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: pthread_rwlock_t__bindgen_ty_1,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_rwlock_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __nr_readers: ::std::os::raw::c_uint,
    pub __readers_wakeup: ::std::os::raw::c_uint,
    pub __writer_wakeup: ::std::os::raw::c_uint,
    pub __nr_readers_queued: ::std::os::raw::c_uint,
    pub __nr_writers_queued: ::std::os::raw::c_uint,
    pub __writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __pad1: ::std::os::raw::c_ulong,
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__lock as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__readers_wakeup as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__readers_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer_wakeup as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_readers_queued
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__nr_writers_queued
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_writers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad1 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__pad2 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<pthread_rwlock_t__bindgen_ty_1>())).__flags as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__flags)
        )
    );
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
#[test]
fn bindgen_test_layout_random_data() {
    assert_eq!(
        ::std::mem::size_of::<random_data>(),
        48usize,
        concat!("Size of: ", stringify!(random_data))
    );
    assert_eq!(
        ::std::mem::align_of::<random_data>(),
        8usize,
        concat!("Alignment of ", stringify!(random_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).state as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_deg as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_deg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).rand_sep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(rand_sep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<random_data>())).end_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(random_data),
            "::",
            stringify!(end_ptr)
        )
    );
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[test]
fn bindgen_test_layout_drand48_data() {
    assert_eq!(
        ::std::mem::size_of::<drand48_data>(),
        24usize,
        concat!("Size of: ", stringify!(drand48_data))
    );
    assert_eq!(
        ::std::mem::align_of::<drand48_data>(),
        8usize,
        concat!("Alignment of ", stringify!(drand48_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__old_x as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__old_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__c as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__init as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<drand48_data>())).__a as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(drand48_data),
            "::",
            stringify!(__a)
        )
    );
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn cfree(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        __pwcs: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        __s: *mut ::std::os::raw::c_char,
        __pwcs: *const wchar_t,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
pub type FILE = _IO_FILE;
pub type __FILE = _IO_FILE;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_jump_t {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    pub _next: *mut _IO_marker,
    pub _sbuf: *mut _IO_FILE,
    pub _pos: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__IO_marker() {
    assert_eq!(
        ::std::mem::size_of::<_IO_marker>(),
        24usize,
        concat!("Size of: ", stringify!(_IO_marker))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_marker>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_marker))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_marker>()))._next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_marker),
            "::",
            stringify!(_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_marker>()))._sbuf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_marker),
            "::",
            stringify!(_sbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_marker>()))._pos as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_marker),
            "::",
            stringify!(_pos)
        )
    );
}
pub const __codecvt_result___codecvt_ok: __codecvt_result = 0;
pub const __codecvt_result___codecvt_partial: __codecvt_result = 1;
pub const __codecvt_result___codecvt_error: __codecvt_result = 2;
pub const __codecvt_result___codecvt_noconv: __codecvt_result = 3;
pub type __codecvt_result = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub __pad1: *mut ::std::os::raw::c_void,
    pub __pad2: *mut ::std::os::raw::c_void,
    pub __pad3: *mut ::std::os::raw::c_void,
    pub __pad4: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad1 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad2 as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad3 as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad4 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE_plus {
    _unused: [u8; 0],
}
extern "C" {
    pub static mut _IO_2_1_stdin_: _IO_FILE_plus;
}
extern "C" {
    pub static mut _IO_2_1_stdout_: _IO_FILE_plus;
}
extern "C" {
    pub static mut _IO_2_1_stderr_: _IO_FILE_plus;
}
pub type __io_read_fn = ::std::option::Option<
    unsafe extern "C" fn(
        __cookie: *mut ::std::os::raw::c_void,
        __buf: *mut ::std::os::raw::c_char,
        __nbytes: size_t,
    ) -> __ssize_t,
>;
pub type __io_write_fn = ::std::option::Option<
    unsafe extern "C" fn(
        __cookie: *mut ::std::os::raw::c_void,
        __buf: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> __ssize_t,
>;
pub type __io_seek_fn = ::std::option::Option<
    unsafe extern "C" fn(
        __cookie: *mut ::std::os::raw::c_void,
        __pos: *mut __off64_t,
        __w: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type __io_close_fn = ::std::option::Option<
    unsafe extern "C" fn(__cookie: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn __underflow(arg1: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __uflow(arg1: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut _IO_FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_getc(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_putc(__c: ::std::os::raw::c_int, __fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_feof(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_ferror(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_peekc_locked(__fp: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_flockfile(arg1: *mut _IO_FILE);
}
extern "C" {
    pub fn _IO_funlockfile(arg1: *mut _IO_FILE);
}
extern "C" {
    pub fn _IO_ftrylockfile(arg1: *mut _IO_FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_vfscanf(
        arg1: *mut _IO_FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_vfprintf(
        arg1: *mut _IO_FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _IO_padn(arg1: *mut _IO_FILE, arg2: ::std::os::raw::c_int, arg3: __ssize_t)
        -> __ssize_t;
}
extern "C" {
    pub fn _IO_sgetn(
        arg1: *mut _IO_FILE,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn _IO_seekoff(
        arg1: *mut _IO_FILE,
        arg2: __off64_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> __off64_t;
}
extern "C" {
    pub fn _IO_seekpos(
        arg1: *mut _IO_FILE,
        arg2: __off64_t,
        arg3: ::std::os::raw::c_int,
    ) -> __off64_t;
}
extern "C" {
    pub fn _IO_free_backup_area(arg1: *mut _IO_FILE);
}
pub type fpos_t = _G_fpos_t;
extern "C" {
    pub static mut stdin: *mut _IO_FILE;
}
extern "C" {
    pub static mut stdout: *mut _IO_FILE;
}
extern "C" {
    pub static mut stderr: *mut _IO_FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __s: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
pub type int_least8_t = ::std::os::raw::c_schar;
pub type int_least16_t = ::std::os::raw::c_short;
pub type int_least32_t = ::std::os::raw::c_int;
pub type int_least64_t = ::std::os::raw::c_long;
pub type uint_least8_t = ::std::os::raw::c_uchar;
pub type uint_least16_t = ::std::os::raw::c_ushort;
pub type uint_least32_t = ::std::os::raw::c_uint;
pub type uint_least64_t = ::std::os::raw::c_ulong;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type __gwchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxabs(__n: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_uint128 {
    pub u_hi: u64,
    pub u_lo: u64,
}
#[test]
fn bindgen_test_layout_m0_uint128() {
    assert_eq!(
        ::std::mem::size_of::<m0_uint128>(),
        16usize,
        concat!("Size of: ", stringify!(m0_uint128))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_uint128>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_uint128))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_uint128>())).u_hi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_uint128),
            "::",
            stringify!(u_hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_uint128>())).u_lo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_uint128),
            "::",
            stringify!(u_lo)
        )
    );
}
extern "C" {
    pub fn m0_uint128_eq(u0: *const m0_uint128, u1: *const m0_uint128) -> bool;
}
extern "C" {
    pub fn m0_uint128_cmp(u0: *const m0_uint128, u1: *const m0_uint128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_uint128_init(u128_: *mut m0_uint128, magic: *const ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " res = a + b;"]
    pub fn m0_uint128_add(res: *mut m0_uint128, a: *const m0_uint128, b: *const m0_uint128);
}
extern "C" {
    #[doc = " res = a * b;"]
    pub fn m0_uint128_mul64(res: *mut m0_uint128, a: u64, b: u64);
}
extern "C" {
    pub fn m0_uint128_sscanf(
        s: *const ::std::os::raw::c_char,
        u128_: *mut m0_uint128,
    ) -> ::std::os::raw::c_int;
}
#[doc = " count of bytes (in extent, IO operation, etc.)"]
pub type m0_bcount_t = u64;
#[doc = " an index (offset) in a linear name-space (e.g., in a file, storage object,"]
#[doc = "storage device, memory buffer) measured in bytes"]
pub type m0_bindex_t = u64;
pub const M0_BCOUNT_MAX: ::std::os::raw::c_ulong = 18446744073709551615;
pub const M0_BINDEX_MAX: ::std::os::raw::c_ulong = 18446744073709551614;
pub const M0_BSIGNED_MAX: ::std::os::raw::c_ulong = 9223372036854775807;
pub type _bindgen_ty_1 = ::std::os::raw::c_ulong;
#[doc = " Memory buffer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_buf {
    pub b_nob: m0_bcount_t,
    pub b_addr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_m0_buf() {
    assert_eq!(
        ::std::mem::size_of::<m0_buf>(),
        16usize,
        concat!("Size of: ", stringify!(m0_buf))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_buf>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_buf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_buf>())).b_nob as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_buf),
            "::",
            stringify!(b_nob)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_buf>())).b_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_buf),
            "::",
            stringify!(b_addr)
        )
    );
}
#[doc = " Sequence of memory buffers."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_bufs {
    pub ab_count: u32,
    pub ab_elems: *mut m0_buf,
}
#[test]
fn bindgen_test_layout_m0_bufs() {
    assert_eq!(
        ::std::mem::size_of::<m0_bufs>(),
        16usize,
        concat!("Size of: ", stringify!(m0_bufs))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_bufs>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_bufs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bufs>())).ab_count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bufs),
            "::",
            stringify!(ab_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bufs>())).ab_elems as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bufs),
            "::",
            stringify!(ab_elems)
        )
    );
}
extern "C" {
    #[doc = " Initialises struct m0_buf."]
    pub fn m0_buf_init(buf: *mut m0_buf, data: *mut ::std::os::raw::c_void, nob: u32);
}
extern "C" {
    #[doc = " Allocates memory pointed to by @buf->b_addr of size @size."]
    pub fn m0_buf_alloc(buf: *mut m0_buf, size: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Frees memory pointed to by buf->b_addr and zeroes buffer's fields."]
    pub fn m0_buf_free(buf: *mut m0_buf);
}
extern "C" {
    #[doc = " Compares memory of two buffers."]
    #[doc = ""]
    #[doc = " Returns zero if buffers are equal (including their sizes). Otherwise, returns"]
    #[doc = " difference between the first pair of bytes that differ in `x' and `y'."]
    #[doc = " If buffers have different sizes and one is a prefix of the second,"]
    #[doc = " the sign of the expression (x->b_nob - y->b_nob) is returned."]
    #[doc = ""]
    #[doc = " Therefore, sign of the return value can be used to determine lexicographical"]
    #[doc = " order of the buffers."]
    #[doc = ""]
    #[doc = " m0_buf_cmp() can be treated as an analogue of strcmp(3) for m0_buf strings"]
    #[doc = " that may contain '\\0'."]
    pub fn m0_buf_cmp(x: *const m0_buf, y: *const m0_buf) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns true iff two buffers are equal."]
    pub fn m0_buf_eq(x: *const m0_buf, y: *const m0_buf) -> bool;
}
extern "C" {
    #[doc = " Copies a buffer without allocation."]
    #[doc = " Destination buffer must point to a valid memory location and it has to have"]
    #[doc = " the same size as the source buffer."]
    #[doc = ""]
    #[doc = " @pre dst->b_nob == src->b_nob"]
    pub fn m0_buf_memcpy(dst: *mut m0_buf, src: *const m0_buf);
}
extern "C" {
    #[doc = " Copies a buffer."]
    #[doc = ""]
    #[doc = " User is responsible for m0_buf_free()ing `dest'."]
    #[doc = ""]
    #[doc = " @pre   dest->b_nob == 0 && dest->b_addr == NULL"]
    #[doc = " @post  ergo(result == 0, m0_buf_eq(dest, src))"]
    pub fn m0_buf_copy(dest: *mut m0_buf, src: *const m0_buf) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocates 'buf' aligned on (2^shift)-byte boundary and copies 'data'"]
    #[doc = " into it."]
    pub fn m0_buf_new_aligned(
        buf: *mut m0_buf,
        data: *const ::std::os::raw::c_void,
        nob: u32,
        shift: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocates 'dst' buffer aligned on (2^shift)-byte boundary and copies 'src'"]
    #[doc = " into it."]
    #[doc = ""]
    #[doc = " @pre   dst->b_nob == 0 && dst->b_addr == NULL"]
    pub fn m0_buf_copy_aligned(
        dst: *mut m0_buf,
        src: *const m0_buf,
        shift: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Does the buffer point at anything?"]
    pub fn m0_buf_is_set(buf: *const m0_buf) -> bool;
}
extern "C" {
    #[doc = " Do `buf' and `str' contain equal sequences of non-'\\0' characters?"]
    #[doc = ""]
    #[doc = " @pre  str != NULL"]
    pub fn m0_buf_streq(buf: *const m0_buf, str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    #[doc = " Duplicates a string pointed to by buf->b_addr."]
    #[doc = ""]
    #[doc = " Maximum length of the resulting string, including null character,"]
    #[doc = " is buf->b_nob."]
    pub fn m0_buf_strdup(buf: *const m0_buf) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Constructs a sequence of memory buffers, copying data from"]
    #[doc = " NULL-terminated array of C strings."]
    #[doc = ""]
    #[doc = " User is responsible for m0_bufs_free()ing `dest'."]
    pub fn m0_bufs_from_strings(
        dest: *mut m0_bufs,
        src: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Constructs a NULL-terminated array of C strings, copying data from a"]
    #[doc = " sequence of memory buffers."]
    #[doc = ""]
    #[doc = " The elements of `*dest' should be freed eventually."]
    #[doc = " @see  m0_strings_free()"]
    pub fn m0_bufs_to_strings(
        dest: *mut *mut *const ::std::os::raw::c_char,
        src: *const m0_bufs,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Checks equality of given sequences."]
    #[doc = ""]
    #[doc = " @see  m0_buf_streq()"]
    pub fn m0_bufs_streq(bufs: *const m0_bufs, strs: *mut *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    #[doc = " Frees memory buffers."]
    pub fn m0_bufs_free(bufs: *mut m0_bufs);
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
#[doc = " Panic context"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_panic_ctx {
    #[doc = " Panic message, usually it's a failed condition, which \"triggers\""]
    #[doc = " panic."]
    pub pc_expr: *const ::std::os::raw::c_char,
    #[doc = " Name of a function, which calls m0_panic(), i.e. __func__"]
    pub pc_func: *const ::std::os::raw::c_char,
    #[doc = " Name of a file, i.e. __FILE__"]
    pub pc_file: *const ::std::os::raw::c_char,
    #[doc = " Line number, i.e. __LINE__"]
    pub pc_lineno: ::std::os::raw::c_int,
    #[doc = " Additional informational message with printf(3) like formatting,"]
    #[doc = " which will be displayed after the failed condition and can be used as"]
    #[doc = " an explanation of why condition has failed"]
    pub pc_fmt: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_m0_panic_ctx() {
    assert_eq!(
        ::std::mem::size_of::<m0_panic_ctx>(),
        40usize,
        concat!("Size of: ", stringify!(m0_panic_ctx))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_panic_ctx>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_panic_ctx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_panic_ctx>())).pc_expr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_panic_ctx),
            "::",
            stringify!(pc_expr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_panic_ctx>())).pc_func as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_panic_ctx),
            "::",
            stringify!(pc_func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_panic_ctx>())).pc_file as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_panic_ctx),
            "::",
            stringify!(pc_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_panic_ctx>())).pc_lineno as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_panic_ctx),
            "::",
            stringify!(pc_lineno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_panic_ctx>())).pc_fmt as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_panic_ctx),
            "::",
            stringify!(pc_fmt)
        )
    );
}
extern "C" {
    #[doc = " Display panic message and abort program execution."]
    #[doc = ""]
    #[doc = " @param ctx     panic context"]
    #[doc = " @param ...     arguments for printf format string m0_panic_ctx::pc_fmt"]
    pub fn m0_panic(ctx: *const m0_panic_ctx, ...);
}
extern "C" {
    #[doc = " Abort program execution."]
    #[doc = ""]
    #[doc = " This function is similar to m0_panic(), but doesn't call M0_LOG() nor"]
    #[doc = " checks for a double panic. Therefore, it can be called on early stages"]
    #[doc = " of initialisation."]
    pub fn m0_panic_only(ctx: *const m0_panic_ctx, ...);
}
extern "C" {
    pub fn m0_arch_panic(ctx: *const m0_panic_ctx, ap: *mut __va_list_tag);
}
extern "C" {
    pub fn m0_backtrace();
}
extern "C" {
    pub fn m0_arch_backtrace();
}
extern "C" {
    #[doc = "Location where _0C() macro stores the name of failed asserted expression."]
    pub static mut m0_failed_condition: *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = "Called by _0C() when invariant conjunct fails."]
    #[doc = ""]
    #[doc = "Useful thing to put a breakpoint at."]
    pub fn m0__assertion_hook();
}
extern "C" {
    #[doc = " Invokes a debugger, if possible."]
    #[doc = ""]
    #[doc = " This can be used for debugging purposes. Note that this function can return."]
    #[doc = ""]
    #[doc = " In user space, this function invokes the debugger specified in M0_DEBUGGER"]
    #[doc = " environment variable."]
    #[doc = ""]
    #[doc = " In Linux kernel this breaks in kgdb, if configured."]
    pub fn m0_debugger_invoke();
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
#[test]
fn bindgen_test_layout___locale_struct() {
    assert_eq!(
        ::std::mem::size_of::<__locale_struct>(),
        232usize,
        concat!("Size of: ", stringify!(__locale_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<__locale_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(__locale_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__locales as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__locales)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_b as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_tolower as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_tolower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__ctype_toupper as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__ctype_toupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__locale_struct>())).__names as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__locale_struct),
            "::",
            stringify!(__names)
        )
    );
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: __locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
        __l: __locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: size_t) -> size_t;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: __locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __bzero(__s: *mut ::std::os::raw::c_void, __n: size_t);
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: size_t,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Resolve hostname."]
    pub fn m0_host_resolve(
        name: *const ::std::os::raw::c_char,
        buf: *mut ::std::os::raw::c_char,
        bufsiz: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Print performance counters: getrusage(), /proc/self/io."]
    #[doc = ""]
    #[doc = " All errors (can't open file etc.) are silently ignored."]
    pub fn m0_performance_counters(buf: *mut ::std::os::raw::c_char, buf_len: size_t);
}
extern "C" {
    #[doc = " Returns rounded up value of @val in chunks of @size."]
    #[doc = " @pre m0_is_po2(size)"]
    pub fn m0_round_up(val: u64, size: u64) -> u64;
}
extern "C" {
    #[doc = " Returns rounded down value of @val in chunks of @size."]
    #[doc = " @pre m0_is_po2(size)"]
    pub fn m0_round_down(val: u64, size: u64) -> u64;
}
extern "C" {
    pub fn m0_bool_to_str(b: bool) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Extracts the file name, relative to a motr sources directory, from a"]
    #[doc = " full-path file name. A motr source directory is detected by a name"]
    #[doc = " \"motr/\"."]
    #[doc = ""]
    #[doc = " For example, given the following full-path file name:"]
    #[doc = ""]
    #[doc = "     /path/to/motr/lib/ut/finject.c"]
    #[doc = ""]
    #[doc = " A short file name, relative to the \"motr/\" directory, is:"]
    #[doc = ""]
    #[doc = "     lib/ut/finject.c"]
    #[doc = ""]
    #[doc = " @bug {"]
    #[doc = "     This function doesn't search for the rightmost occurrence of \"motr/\""]
    #[doc = "     in a file path, if \"motr/\" encounters several times in the path the first"]
    #[doc = "     one will be picked up:"]
    #[doc = ""]
    #[doc = "       /path/to/motr/fs/motr/lib/misc.h => fs/motr/lib/misc.h"]
    #[doc = " }"]
    #[doc = ""]
    #[doc = " @param   fname  full path"]
    #[doc = ""]
    #[doc = " @return  short file name - a pointer inside fname string to the remaining"]
    #[doc = "          file path, after motr source directory;"]
    #[doc = "          if short file name cannot be found, then full fname is returned."]
    pub fn m0_short_file_name(
        fname: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn m0_strtou64(
        str_: *const ::std::os::raw::c_char,
        endptr: *mut *mut ::std::os::raw::c_char,
        base: ::std::os::raw::c_int,
    ) -> u64;
}
extern "C" {
    pub fn m0_strtou32(
        str_: *const ::std::os::raw::c_char,
        endptr: *mut *mut ::std::os::raw::c_char,
        base: ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    pub fn __dummy_function();
}
extern "C" {
    pub fn m0_elems_are_unique(
        array: *const ::std::os::raw::c_void,
        nr_elems: ::std::os::raw::c_uint,
        elem_size: size_t,
    ) -> bool;
}
extern "C" {
    pub fn m0_no_of_bits_set(val: u64) -> u32;
}
extern "C" {
    pub fn m0_full_name_hash(
        name: *const ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Converts Motr function pointer in a form that can be stored somewhere (e.g.,"]
    #[doc = " in a trace log or addb2 record) and later decoded back into original pointer."]
    #[doc = ""]
    #[doc = " Such transformation is needed, because function pointers depend on the"]
    #[doc = " address at which Motr library is loaded."]
    #[doc = ""]
    #[doc = " @pre \"p\" must be a pointer to Motr executable code or NULL."]
    pub fn m0_ptr_wrap(p: *const ::std::os::raw::c_void) -> u64;
}
extern "C" {
    pub fn m0_ptr_unwrap(val: u64) -> *const ::std::os::raw::c_void;
}
pub const UINT32_STR_LEN: ::std::os::raw::c_uint = 64;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[doc = " An object representing a key value pair."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_key_val {
    pub kv_key: m0_buf,
    pub kv_val: m0_buf,
}
#[test]
fn bindgen_test_layout_m0_key_val() {
    assert_eq!(
        ::std::mem::size_of::<m0_key_val>(),
        32usize,
        concat!("Size of: ", stringify!(m0_key_val))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_key_val>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_key_val))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_key_val>())).kv_key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_key_val),
            "::",
            stringify!(kv_key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_key_val>())).kv_val as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_key_val),
            "::",
            stringify!(kv_val)
        )
    );
}
extern "C" {
    #[doc = " Apply a permutation given by its Lehmer code in k[] to a set s[] of n"]
    #[doc = " elements and build inverse permutation in r[]."]
    #[doc = ""]
    #[doc = " @param n - number of elements in k[], s[] and r[]"]
    #[doc = " @param k - Lehmer code of the permutation"]
    #[doc = " @param s - an array to permute"]
    #[doc = " @param r - an array to build inverse permutation in"]
    #[doc = ""]
    #[doc = " @pre  m0_forall(i, n, k[i] + i < n)"]
    #[doc = " @pre  m0_forall(i, n, s[i] < n && ergo(s[i] == s[j], i == j))"]
    #[doc = " @post m0_forall(i, n, s[i] < n && ergo(s[i] == s[j], i == j))"]
    #[doc = " @post m0_forall(i, n, s[r[i]] == i && r[s[i]] == i)"]
    pub fn m0_permute(n: u64, k: *mut u64, s: *mut u64, r: *mut u64);
}
extern "C" {
    #[doc = " Sorts an array of integers in ascending order."]
    pub fn m0_array_sort(arr: *mut u64, arr_len: u64);
}
extern "C" {
    #[doc = " Get i-th bit value from the buffer."]
    pub fn m0_bit_get(buffer: *mut ::std::os::raw::c_void, i: m0_bcount_t) -> bool;
}
extern "C" {
    #[doc = "Set i-th bit value in the buffer."]
    pub fn m0_bit_set(buffer: *mut ::std::os::raw::c_void, i: m0_bcount_t, val: bool);
}
extern "C" {
    #[doc = " Initialises a key value pair."]
    pub fn m0_key_val_init(kv: *mut m0_key_val, key: *const m0_buf, val: *const m0_buf);
}
extern "C" {
    #[doc = " This API implements Boyer-Moore Voting Algorithm."]
    #[doc = " Returns the majority element present in an input array. The majority element"]
    #[doc = " of an array, if present, is the element that occurs more than n/2 times in"]
    #[doc = " the array of length n. It has been assumed that members of the array can be"]
    #[doc = " compared for equality and method for the same needs to be provided by the"]
    #[doc = " user of the API."]
    #[doc = " Returns null if there is no majority element."]
    pub fn m0_vote_majority_get(
        arr: *mut m0_key_val,
        len: u32,
        cmp: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const m0_buf, arg2: *const m0_buf) -> bool,
        >,
        vote_nr: *mut u32,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Returns true iff it's M0_KEY_VAL_NULL."]
    pub fn m0_key_val_is_null(kv: *mut m0_key_val) -> bool;
}
extern "C" {
    #[doc = " Initialises a key to M0_KEY_VAL_NULL."]
    pub fn m0_key_val_null_set(kv: *mut m0_key_val);
}
extern "C" {
    pub static M0_KEY_VAL_NULL: m0_key_val;
}
extern "C" {
    #[doc = " Generates process-uinque identifier. WARN: Atomic based."]
    pub fn m0_dummy_id_generate() -> u64;
}
#[doc = " Number of nodes which originate from root of radix tree."]
pub const m0_varr_tree_char_M0_VA_TNODE_NR: m0_varr_tree_char = 64;
#[doc = " Size of pointer to a tree node."]
pub const m0_varr_tree_char_M0_VA_TNODEPTR_SIZE: m0_varr_tree_char = 8;
#[doc = " Log (M0_VA_TNODE_NR) to base 2."]
pub const m0_varr_tree_char_M0_VA_TNODE_NR_SHIFT: m0_varr_tree_char = 6;
#[doc = " Maximum allowable depth of a tree."]
pub const m0_varr_tree_char_M0_VA_DEPTH_MAX: m0_varr_tree_char = 16;
#[doc = " @defgroup varr Virtual array"]
#[doc = " A virtual array represents a data structure which can be used at places"]
#[doc = " where big contiguous memory allocations are not possible."]
#[doc = ""]
#[doc = " Virtual array can be used for big arrays or pointers which would potentially"]
#[doc = " hold large memory areas. Virtual array library provides interface for"]
#[doc = " read, write, and iterate over an array."]
#[doc = ""]
#[doc = " Using such structures can be especially helpful in kernel where contiguity"]
#[doc = " of pages is not guaranteed, and any memory allocation growing beyond page"]
#[doc = " size can essentially fail. Current implementation supports both user-space"]
#[doc = " as well as kernel versions."]
#[doc = ""]
#[doc = " The structure of virtual array is kept something similar to a block map"]
#[doc = " from an on-disk inode with multiple indirections."]
#[doc = ""]
#[doc = " Using pointer arithmetic on virtual array is strongly discouraged since"]
#[doc = " it does not guarantee contiguity of buffers."]
#[doc = ""]
#[doc = " A virtual array uses a radix-tree like structure whose height is"]
#[doc = " dependent on number of objects to be accommodated in the array."]
#[doc = ""]
#[doc = " Following example illustrates the usage of various interfaces"]
#[doc = " that are provided by virtual array library."]
#[doc = ""]
#[doc = " Consider an array consisting of OBJ_NR number of objects, of the type"]
#[doc = " unsigned long. Library leaves it to its user what shall be the size of a"]
#[doc = " buffer holding objects. Following example uses M0_0VEC_ALIGN as buffer size."]
#[doc = ""]
#[doc = " @code"]
#[doc = ""]
#[doc = " struct m0_varr varr;"]
#[doc = ""]
#[doc = " enum {"]
#[doc = "         OBJ_NR = 10203040,"]
#[doc = " };"]
#[doc = ""]
#[doc = " rc = m0_varr_init(&varr, OBJ_NR, sizeof(unsigned long), M0_0VEC_ALIGN);"]
#[doc = ""]
#[doc = " m0_varr_iter(&varr, unsigned long, id, obj, 0, m0_varr_size(&varr), 1) {"]
#[doc = "\t*obj = id;"]
#[doc = " } m0_varr_enditer;"]
#[doc = ""]
#[doc = " m0_varr_iter(&varr, unsigned long, id, obj, 0, m0_varr_size(&varr), 1) {"]
#[doc = "         ptr = m0_varr_ele_get(&varr, id);"]
#[doc = "         M0_ASSERT(*ptr == *obj);"]
#[doc = " } m0_varr_enditer;"]
#[doc = ""]
#[doc = " m0_varr_fini(&varr);"]
#[doc = ""]
#[doc = " @endcode"]
#[doc = " @{"]
pub type m0_varr_tree_char = ::std::os::raw::c_uint;
extern "C" {
    pub static mut __static_assertion: [::std::os::raw::c_char; 1usize];
}
#[doc = " An object that holds address of a node, and its index within a buffer of"]
#[doc = " width vp_width."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_varr_path_element {
    pub vp_idx: u32,
    pub vp_width: u32,
    pub vp_buf: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_m0_varr_path_element() {
    assert_eq!(
        ::std::mem::size_of::<m0_varr_path_element>(),
        16usize,
        concat!("Size of: ", stringify!(m0_varr_path_element))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_varr_path_element>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_varr_path_element))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_path_element>())).vp_idx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_path_element),
            "::",
            stringify!(vp_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_path_element>())).vp_width as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_path_element),
            "::",
            stringify!(vp_width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_path_element>())).vp_buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_path_element),
            "::",
            stringify!(vp_buf)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_varr_cursor {
    pub vc_arr: *mut m0_varr,
    pub vc_depth: u32,
    #[doc = " Number of leaf level nodes behind cursor's current position."]
    pub vc_done: u64,
    #[doc = " Holds addresses of those nodes which form a path between the root"]
    #[doc = " node and current cursor position. Address of a node at level 'i'"]
    #[doc = " on a path is stored in vc_path[i]."]
    pub vc_path: [m0_varr_path_element; 16usize],
}
#[test]
fn bindgen_test_layout_m0_varr_cursor() {
    assert_eq!(
        ::std::mem::size_of::<m0_varr_cursor>(),
        280usize,
        concat!("Size of: ", stringify!(m0_varr_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_varr_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_varr_cursor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_cursor>())).vc_arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_cursor),
            "::",
            stringify!(vc_arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_cursor>())).vc_depth as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_cursor),
            "::",
            stringify!(vc_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_cursor>())).vc_done as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_cursor),
            "::",
            stringify!(vc_done)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr_cursor>())).vc_path as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr_cursor),
            "::",
            stringify!(vc_path)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_varr {
    #[doc = " Number of elements in array."]
    pub va_nr: u64,
    #[doc = " Number of leaf buffers."]
    pub va_buff_nr: u64,
    pub va_obj_size: size_t,
    #[doc = " Log of object-size to the base two."]
    pub va_obj_shift: u8,
    #[doc = " Size of buffer which is used to store objects and buffer-pointers"]
    #[doc = " from a tree."]
    pub va_bufsize: size_t,
    #[doc = " Log of va_bufsize to the base two."]
    pub va_buf_shift: u8,
    #[doc = " Depth of tree proportional to number of objects stored."]
    pub va_depth: u32,
    #[doc = " Number of pointers that can be accommodated in one"]
    #[doc = " meta buffer. This number is easy to calculate and need not be stored"]
    #[doc = " as a member of structure. However, during tree traversal, this"]
    #[doc = " number is calculated multiple times in each trail, owing to"]
    #[doc = " significant and _exactly same_ compute operations which can be"]
    #[doc = " easily avoided by maintaining it as a member."]
    pub va_bufptr_nr: u64,
    pub va_bufptr_nr_shift: u8,
    #[doc = " Array of radix tree nodes, each of which represents an abstraction"]
    #[doc = " of buffer containing multitude of objects."]
    #[doc = " The arrangement is such that there could be n levels within any"]
    #[doc = " tree node before a leaf node is reached."]
    pub va_tree: [*mut ::std::os::raw::c_void; 64usize],
    #[doc = " Holds address of a buffer holding recently accessed object."]
    pub va_cache: *mut varr_cache,
    #[doc = " Holds the cursor depth in case of a failure."]
    pub va_failure_depth: u32,
    #[doc = " Magic field to cross check sanity of structure."]
    pub va_magic: u64,
}
#[test]
fn bindgen_test_layout_m0_varr() {
    assert_eq!(
        ::std::mem::size_of::<m0_varr>(),
        600usize,
        concat!("Size of: ", stringify!(m0_varr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_varr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_varr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_buff_nr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_buff_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_obj_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_obj_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_obj_shift as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_obj_shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_bufsize as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_bufsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_buf_shift as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_buf_shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_depth as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_bufptr_nr as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_bufptr_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_bufptr_nr_shift as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_bufptr_nr_shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_tree as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_tree)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_cache as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_failure_depth as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_failure_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_varr>())).va_magic as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_varr),
            "::",
            stringify!(va_magic)
        )
    );
}
extern "C" {
    #[doc = " Initialises a virtual array."]
    #[doc = " @param  nr[in]      Length of array."]
    #[doc = " @param  size[in]    Size of object to be stored in array."]
    #[doc = " @param  bufsize[in] Size of each buffer which stores the objects."]
    #[doc = " @retval 0\t       On success."]
    #[doc = " @retval -ENOMEM     On failure."]
    #[doc = " @pre   arr != NULL && nr > 0."]
    #[doc = " @post  varr_invariant(arr)."]
    pub fn m0_varr_init(
        arr: *mut m0_varr,
        nr: u64,
        size: size_t,
        bufsize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalises a virtual array."]
    #[doc = " @pre varr_invariant(arr)"]
    pub fn m0_varr_fini(arr: *mut m0_varr);
}
extern "C" {
    #[doc = " Returns address of an object having index as 'index'. Updates an internal"]
    #[doc = " cache if required. Since concurrent access to the cache may result in"]
    #[doc = " spurious outcome, calls to m0_varr_ele_get() should be protected under a"]
    #[doc = " lock."]
    #[doc = " @pre  arr != NULL && index < arr->va_nr."]
    #[doc = " @post varr_invariant(arr)."]
    pub fn m0_varr_ele_get(arr: *mut m0_varr, index: u64) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Returns the number of elements stored in an array."]
    pub fn m0_varr_size(arr: *const m0_varr) -> u64;
}
extern "C" {
    #[doc = " Initializes a cursor to the address of the first node at given depth."]
    #[doc = " @param arr    [in]    An array to which a cursor gets associated."]
    #[doc = " @param depth  [in]    Depth to which cursor is initialized."]
    #[doc = " @param cursor [out]"]
    #[doc = " @retval\t  0      On success."]
    #[doc = " @retval\t -EINVAL On failure."]
    #[doc = " @pre\tarr != NULL"]
    #[doc = " @pre depth <= arr->va_depth"]
    pub fn m0_varr_cursor_init(
        cursor: *mut m0_varr_cursor,
        arr: *const m0_varr,
        depth: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns a pointer corresponding to the current location of a cursor."]
    #[doc = " @pre\tm0_varr_cursor_init()"]
    pub fn m0_varr_cursor_get(cursor: *mut m0_varr_cursor) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Moves cursor to the next node at the same level as m0_varr_cursor::vc_depth."]
    #[doc = " @retval 1 On success."]
    #[doc = " @retval 0 On completion of all nodes at level m0_varr_cursor::vc_depth."]
    pub fn m0_varr_cursor_next(cursor: *mut m0_varr_cursor) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Moves the cursor location by 'inc', along the same level as"]
    #[doc = " m0_varr_cursor::vc_depth."]
    #[doc = " @retval 1 On success."]
    #[doc = " @retval 0 On completion of all nodes at level m0_varr_cursor::vc_depth."]
    #[doc = " @pre\tm0_varr_cursor_init()"]
    pub fn m0_varr_cursor_move(cursor: *mut m0_varr_cursor, inc: u64) -> ::std::os::raw::c_int;
}
#[doc = "A vector of \"segments\" where each segment is something having a \"count\"."]
#[doc = ""]
#[doc = "m0_vec is used to implement functionality common to various \"scatter-gather\""]
#[doc = "data-structures, like m0_indexvec, m0_bufvec."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_vec {
    #[doc = " number of segments in the vector"]
    pub v_nr: u32,
    #[doc = " array of segment counts"]
    pub v_count: *mut m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_vec() {
    assert_eq!(
        ::std::mem::size_of::<m0_vec>(),
        16usize,
        concat!("Size of: ", stringify!(m0_vec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_vec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_vec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_vec>())).v_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_vec),
            "::",
            stringify!(v_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_vec>())).v_count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_vec),
            "::",
            stringify!(v_count)
        )
    );
}
extern "C" {
    #[doc = " Returns total count of vector"]
    pub fn m0_vec_count(vec: *const m0_vec) -> m0_bcount_t;
}
extern "C" {
    pub fn m0_vec_is_empty(vec: *const m0_vec) -> bool;
}
#[doc = "Position within a vector."]
#[doc = ""]
#[doc = "m0_vec_cursor is a cursor associated with a m0_vec instance. A cursor can be"]
#[doc = "moved in the forward direction."]
#[doc = ""]
#[doc = "A cursor can be in one of the two exclusive states:"]
#[doc = ""]
#[doc = "@li it is positioned within one of the vector segments. In this state"]
#[doc = ""]
#[doc = "@code"]
#[doc = "cur->vc_seg < cur->vc_vec->v_nr &&"]
#[doc = "cur->vc_offset < cur->vc_vec->v_count[cur->vc_seg]"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "invariant is maintained. This is called a \"normal\" state."]
#[doc = ""]
#[doc = "@li or a cursor is in an \"end of the vector\" state. In this state"]
#[doc = ""]
#[doc = "@code"]
#[doc = "cur->vc_seg == cur->vc_vec->v_nr && cur->vc_offset == 0"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "Note that a cursor over an empty vector (one with vec::v_nr == 0) is always"]
#[doc = "in the end of the vector state."]
#[doc = ""]
#[doc = "Also note, that according to the normal state invariant, a cursor cannot be"]
#[doc = "positioned in an empty segment (one with zero count). Empty segments are"]
#[doc = "skipped over by all cursor manipulating functions, including constructor."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_vec_cursor {
    pub vc_vec: *const m0_vec,
    #[doc = " Segment that the cursor is currently in."]
    pub vc_seg: u32,
    #[doc = " Offset within the segment that the cursor is positioned at."]
    pub vc_offset: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_vec_cursor() {
    assert_eq!(
        ::std::mem::size_of::<m0_vec_cursor>(),
        24usize,
        concat!("Size of: ", stringify!(m0_vec_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_vec_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_vec_cursor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_vec_cursor>())).vc_vec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_vec_cursor),
            "::",
            stringify!(vc_vec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_vec_cursor>())).vc_seg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_vec_cursor),
            "::",
            stringify!(vc_seg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_vec_cursor>())).vc_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_vec_cursor),
            "::",
            stringify!(vc_offset)
        )
    );
}
extern "C" {
    #[doc = "Initialise a cursor."]
    #[doc = ""]
    #[doc = "Cursor requires no special finalisation."]
    pub fn m0_vec_cursor_init(cur: *mut m0_vec_cursor, vec: *const m0_vec);
}
extern "C" {
    #[doc = "Move cursor count bytes further through the vector."]
    #[doc = ""]
    #[doc = "m0_vec_cursor_move(cur, 0) is guaranteed to return true iff cursor is in end"]
    #[doc = "of the vector position without modifying cursor in any way."]
    #[doc = ""]
    #[doc = "@return true, iff the end of the vector has been reached while moving. The"]
    #[doc = "cursor is in end of the vector position in this case."]
    pub fn m0_vec_cursor_move(cur: *mut m0_vec_cursor, count: m0_bcount_t) -> bool;
}
extern "C" {
    #[doc = "Return number of bytes that the cursor have to be moved to reach the next"]
    #[doc = "segment in its vector (or to move into end of the vector position, when the"]
    #[doc = "cursor is already at the last segment)."]
    #[doc = ""]
    #[doc = "@pre cur->vc_seg < cur->vc_vec->v_nr"]
    pub fn m0_vec_cursor_step(cur: *const m0_vec_cursor) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Return number of bytes that the cursor have to be moved to reach the"]
    #[doc = "end of the vector position."]
    #[doc = ""]
    #[doc = "@pre cur->vc_seg < cur->vc_vec->v_nr"]
    pub fn m0_vec_cursor_end(cur: *const m0_vec_cursor) -> m0_bcount_t;
}
#[doc = " Vector of extents in a linear name-space"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_indexvec {
    #[doc = " Number of extents and their sizes."]
    pub iv_vec: m0_vec,
    #[doc = " Array of starting extent indices."]
    pub iv_index: *mut m0_bindex_t,
}
#[test]
fn bindgen_test_layout_m0_indexvec() {
    assert_eq!(
        ::std::mem::size_of::<m0_indexvec>(),
        24usize,
        concat!("Size of: ", stringify!(m0_indexvec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_indexvec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_indexvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_indexvec>())).iv_vec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_indexvec),
            "::",
            stringify!(iv_vec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_indexvec>())).iv_index as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_indexvec),
            "::",
            stringify!(iv_index)
        )
    );
}
#[doc = " Vector of memory buffers"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_bufvec {
    #[doc = " Number of buffers and their sizes."]
    pub ov_vec: m0_vec,
    #[doc = " Array of buffer addresses."]
    pub ov_buf: *mut *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_m0_bufvec() {
    assert_eq!(
        ::std::mem::size_of::<m0_bufvec>(),
        24usize,
        concat!("Size of: ", stringify!(m0_bufvec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_bufvec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_bufvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bufvec>())).ov_vec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bufvec),
            "::",
            stringify!(ov_vec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bufvec>())).ov_buf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bufvec),
            "::",
            stringify!(ov_buf)
        )
    );
}
extern "C" {
    #[doc = "Allocates memory for a struct m0_bufvec.  All segments are of equal"]
    #[doc = "size."]
    #[doc = "The internal struct m0_vec is also allocated by this routine."]
    #[doc = "@pre num_segs > 0 && seg_size > 0"]
    #[doc = ""]
    #[doc = "@param bufvec Pointer to buffer vector to be initialized."]
    #[doc = "@param num_segs Number of memory segments."]
    #[doc = "@param seg_size Size of each segment."]
    #[doc = "@retval 0 On success."]
    #[doc = "@retval -errno On failure."]
    #[doc = "@see m0_bufvec_free()"]
    pub fn m0_bufvec_alloc(
        bufvec: *mut m0_bufvec,
        num_segs: u32,
        seg_size: m0_bcount_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " The same as m0_bufvec_alloc(), but doesn't allocate memory for segments."]
    pub fn m0_bufvec_empty_alloc(bufvec: *mut m0_bufvec, num_segs: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Assumes that all segments are of equal size. All additional"]
    #[doc = "segments are of the size of the initial segment in bufvec."]
    #[doc = "The internal struct m0_vec is also allocated by this routine."]
    #[doc = "@pre num_segs > 0"]
    #[doc = "@pre bufvec != NULL"]
    #[doc = "@pre bufvec->ov_buf != NULL"]
    #[doc = "@pre bufvec->ov_vec.v_nr > 0"]
    #[doc = ""]
    #[doc = "@param bufvec Pointer to buffer vector to be extended."]
    #[doc = "@param num_segs Number of memory segments by which bufvec is to"]
    #[doc = "be extended."]
    pub fn m0_bufvec_extend(bufvec: *mut m0_bufvec, num_segs: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Merges the source bufvec to the destination bufvec."]
    #[doc = " Assumes that all segments are of equal size."]
    #[doc = " Does not allocate bufvec->ov_buf, but does pointer manipulation"]
    #[doc = " such that src_bufvec's ov_bufs are appended to dst_bufvec's ov_bufs."]
    #[doc = " @pre num_segs > 0 for both source and destination bufvecs"]
    #[doc = " @pre seg_size > 0 for both source and destination bufvecs"]
    #[doc = " @pre ov_buf != NULL for both source and destination bufvecs"]
    #[doc = " @pre src_bufvec != NULL, dst_bufvec != NULL"]
    #[doc = ""]
    #[doc = " @param dst_bufvec Pointer to the destination buffer in which the new bufvec"]
    #[doc = "                   is to be merged."]
    #[doc = " @param src_bufvec Pointer to the source buffer which is to be merged."]
    pub fn m0_bufvec_merge(
        dst_bufvec: *mut m0_bufvec,
        src_bufvec: *mut m0_bufvec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Allocates aligned memory as specified by shift value for a struct m0_bufvec."]
    #[doc = "Currently in kernel mode it supports PAGE_SIZE alignment only."]
    pub fn m0_bufvec_alloc_aligned(
        bufvec: *mut m0_bufvec,
        num_segs: u32,
        seg_size: m0_bcount_t,
        shift: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Allocates aligned memory as specified by shift value for a struct m0_bufvec."]
    #[doc = "In userspace mode used for allocation of large buffers contigously."]
    pub fn m0_bufvec_alloc_aligned_packed(
        bufvec: *mut m0_bufvec,
        num_segs: u32,
        seg_size: m0_bcount_t,
        shift: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Make all its memory excluded from core dump."]
    pub fn m0__bufvec_dont_dump(bufvec: *mut m0_bufvec) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Frees the buffers pointed to by m0_bufvec.ov_buf and"]
    #[doc = "the m0_bufvec.ov_vec vector, using m0_free()."]
    #[doc = "@param bufvec Pointer to the m0_bufvec."]
    #[doc = "@see m0_bufvec_alloc()"]
    pub fn m0_bufvec_free(bufvec: *mut m0_bufvec);
}
extern "C" {
    #[doc = " The same as m0_bufvec_free(), but doesn't free the buffers pointed by"]
    #[doc = " m0_bufvec->ov_buf[]. Only m0_bufvec structure is freed."]
    pub fn m0_bufvec_free2(bufvec: *mut m0_bufvec);
}
extern "C" {
    #[doc = "Frees the buffers pointed to by m0_bufvec.ov_buf and"]
    #[doc = "the m0_bufvec.ov_vec vector, using m0_free_aligned()."]
    #[doc = "@param bufvec Pointer to the m0_bufvec."]
    #[doc = "@see m0_bufvec_alloc_aligned()"]
    pub fn m0_bufvec_free_aligned(bufvec: *mut m0_bufvec, shift: ::std::os::raw::c_uint);
}
extern "C" {
    #[doc = "@see m0_bufvec_free_aligned()."]
    #[doc = "in userspace mode used for allocation of large buffers contigously."]
    pub fn m0_bufvec_free_aligned_packed(bufvec: *mut m0_bufvec, shift: ::std::os::raw::c_uint);
}
extern "C" {
    #[doc = " Packs buffers vector by squashing its contiguous or overlapping chunks."]
    #[doc = " @pre bufvec->ov_vec.v_nr > 0."]
    #[doc = " @return the number of squashed chunks."]
    pub fn m0_bufvec_pack(bufvec: *mut m0_bufvec) -> u32;
}
extern "C" {
    #[doc = " Flattens first nr bytes of a buffer vector into one buffer."]
    pub fn m0_bufvec_splice(
        bvec: *const m0_bufvec,
        nr: m0_bcount_t,
        buf: *mut m0_buf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocate memory for index array and counts array in index vector."]
    #[doc = " @param len Number of elements to allocate memory for."]
    #[doc = " @pre   ivec != NULL && len > 0."]
    #[doc = " @post  ivec->iv_index != NULL && ivec->iv_vec.v_count != NULL &&"]
    #[doc = "        ivec->iv_vec.v_nr == len."]
    #[doc = " @post  ergo(retval == -ENOMEM, ivec->iv_index == NULL)"]
    pub fn m0_indexvec_alloc(ivec: *mut m0_indexvec, len: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Deallocates the memory buffers pointed to by index array and counts array."]
    #[doc = " Also sets the array count to zero."]
    #[doc = " If ivec->iv_index == NULL - does nothing."]
    #[doc = " @pre  ivec != NULL."]
    #[doc = " @post ivec->iv_index == NULL && ivec->iv_vec.v_count == NULL &&"]
    #[doc = "       ivec->iv_vec.v_nr == 0."]
    pub fn m0_indexvec_free(ivec: *mut m0_indexvec);
}
extern "C" {
    #[doc = " Packs index vector by squashing its contiguous or overlapping chunks."]
    #[doc = " @pre ivec->iv_vec.v_nr > 0."]
    #[doc = " @return the number of squashed chunks."]
    pub fn m0_indexvec_pack(ivec: *mut m0_indexvec) -> u32;
}
#[doc = " Cursor to traverse a bufvec"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_bufvec_cursor {
    #[doc = " Vector cursor used to track position in the vector"]
    #[doc = "embedded in the associated bufvec."]
    pub bc_vc: m0_vec_cursor,
}
#[test]
fn bindgen_test_layout_m0_bufvec_cursor() {
    assert_eq!(
        ::std::mem::size_of::<m0_bufvec_cursor>(),
        24usize,
        concat!("Size of: ", stringify!(m0_bufvec_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_bufvec_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_bufvec_cursor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bufvec_cursor>())).bc_vc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bufvec_cursor),
            "::",
            stringify!(bc_vc)
        )
    );
}
extern "C" {
    #[doc = "Initialize a struct m0_bufvec cursor."]
    #[doc = "@param cur Pointer to the struct m0_bufvec_cursor."]
    #[doc = "@param bvec Pointer to the struct m0_bufvec."]
    pub fn m0_bufvec_cursor_init(cur: *mut m0_bufvec_cursor, bvec: *const m0_bufvec);
}
extern "C" {
    #[doc = "Advance the cursor \"count\" bytes further through the buffer vector."]
    #[doc = "@see m0_vec_cursor_move()"]
    #[doc = "@param cur Pointer to the struct m0_bufvec_cursor."]
    #[doc = "@return true, iff the end of the vector has been reached while moving. The"]
    #[doc = "cursor is in end of the vector position in this case."]
    #[doc = "@return false otherwise"]
    pub fn m0_bufvec_cursor_move(cur: *mut m0_bufvec_cursor, count: m0_bcount_t) -> bool;
}
extern "C" {
    #[doc = "Advances the cursor with some count such that cursor will be aligned to"]
    #[doc = "\"alignment\"."]
    #[doc = "Return convention is same as m0_bufvec_cursor_move()."]
    pub fn m0_bufvec_cursor_align(cur: *mut m0_bufvec_cursor, alignment: u64) -> bool;
}
extern "C" {
    #[doc = "Return number of bytes that the cursor have to be moved to reach the next"]
    #[doc = "segment in its vector (or to move into end of the vector position, when the"]
    #[doc = "cursor is already at the last segment)."]
    #[doc = ""]
    #[doc = "@pre !m0_bufvec_cursor_move(cur, 0)"]
    #[doc = "@see m0_vec_cursor_step()"]
    #[doc = "@param cur Pointer to the struct m0_bufvec_cursor."]
    #[doc = "@retval Count"]
    pub fn m0_bufvec_cursor_step(cur: *const m0_bufvec_cursor) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Return the buffer address at the cursor's current position."]
    #[doc = "@pre !m0_bufvec_cursor_move(cur, 0)"]
    #[doc = "@see m0_bufvec_cursor_copy()"]
    #[doc = "@param cur Pointer to the struct m0_bufvec_cursor."]
    #[doc = "@retval Pointer into buffer."]
    pub fn m0_bufvec_cursor_addr(cur: *mut m0_bufvec_cursor) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "Copy bytes from one buffer to another using cursors."]
    #[doc = "Both cursors are advanced by the number of bytes copied."]
    #[doc = "@param dcur Pointer to the destination buffer cursor positioned"]
    #[doc = "appropriately."]
    #[doc = "@param scur Pointer to the source buffer cursor positioned appropriately."]
    #[doc = "@param num_bytes The number of bytes to copy."]
    #[doc = "@retval bytes_copied The number of bytes actually copied. This will be equal"]
    #[doc = "to num_bytes only if there was adequate space in the buffers."]
    pub fn m0_bufvec_cursor_copy(
        dcur: *mut m0_bufvec_cursor,
        scur: *mut m0_bufvec_cursor,
        num_bytes: m0_bcount_t,
    ) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Copy data with specified size to a cursor."]
    #[doc = "@param dcur Pointer to the destination buffer cursor positioned"]
    #[doc = "appropriately."]
    #[doc = "@param sdata Pointer to area where the data is to be copied from."]
    #[doc = "@param num_bytes The number of bytes to copy."]
    pub fn m0_bufvec_cursor_copyto(
        dcur: *mut m0_bufvec_cursor,
        sdata: *mut ::std::os::raw::c_void,
        num_bytes: m0_bcount_t,
    ) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Copy data with specified size from a cursor."]
    #[doc = "@param scur Pointer to the source buffer cursor positioned appropriately."]
    #[doc = "@param ddata Pointer to area where the data is to be copied to."]
    #[doc = "@param num_bytes The number of bytes to copy."]
    pub fn m0_bufvec_cursor_copyfrom(
        scur: *mut m0_bufvec_cursor,
        ddata: *mut ::std::os::raw::c_void,
        num_bytes: m0_bcount_t,
    ) -> m0_bcount_t;
}
extern "C" {
    #[doc = " Compares contents of cursors. Return value the same as in memcmp(3)."]
    #[doc = ""]
    #[doc = " The positions of the cursors after the call are undefined."]
    pub fn m0_bufvec_cursor_cmp(
        c0: *mut m0_bufvec_cursor,
        c1: *mut m0_bufvec_cursor,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the length of the common prefix of 2 cursors."]
    #[doc = ""]
    #[doc = " The positions of the cursors after the call are undefined."]
    pub fn m0_bufvec_cursor_prefix(
        c0: *mut m0_bufvec_cursor,
        c1: *mut m0_bufvec_cursor,
    ) -> m0_bcount_t;
}
#[doc = "Mechanism to traverse given index vector (m0_indexvec)"]
#[doc = "keeping track of segment counts and vector boundary."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_ivec_cursor {
    pub ic_cur: m0_vec_cursor,
}
#[test]
fn bindgen_test_layout_m0_ivec_cursor() {
    assert_eq!(
        ::std::mem::size_of::<m0_ivec_cursor>(),
        24usize,
        concat!("Size of: ", stringify!(m0_ivec_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_ivec_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_ivec_cursor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ivec_cursor>())).ic_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ivec_cursor),
            "::",
            stringify!(ic_cur)
        )
    );
}
extern "C" {
    #[doc = "Initialize given index vector cursor."]
    #[doc = "@param cur  Given index vector cursor."]
    #[doc = "@param ivec Given index vector to be associated with cursor."]
    pub fn m0_ivec_cursor_init(cur: *mut m0_ivec_cursor, ivec: *const m0_indexvec);
}
extern "C" {
    #[doc = "Moves the index vector cursor forward by @count."]
    #[doc = "@param cur   Given index vector cursor."]
    #[doc = "@param count Count by which cursor has to be moved."]
    #[doc = "@ret   true  iff end of vector has been reached while"]
    #[doc = "moving cursor by @count. Returns false otherwise."]
    pub fn m0_ivec_cursor_move(cur: *mut m0_ivec_cursor, count: m0_bcount_t) -> bool;
}
extern "C" {
    #[doc = " Moves index vector cursor forward until it reaches index @dest."]
    #[doc = " @pre   dest >= m0_ivec_cursor_index(cursor)."]
    #[doc = " @param dest Index uptil which cursor has to be moved."]
    #[doc = " @ret   true iff end of vector has been reached while"]
    #[doc = "             moving cursor. Returns false otherwise."]
    pub fn m0_ivec_cursor_move_to(cursor: *mut m0_ivec_cursor, dest: m0_bindex_t) -> bool;
}
extern "C" {
    #[doc = " Returns the number of bytes needed to move cursor to next segment in given"]
    #[doc = " index vector."]
    #[doc = " @param cur Index vector to be moved."]
    pub fn m0_ivec_cursor_step(cur: *const m0_ivec_cursor) -> m0_bcount_t;
}
extern "C" {
    #[doc = " Returns index at current cursor position."]
    #[doc = " @param cur Given index vector cursor."]
    pub fn m0_ivec_cursor_index(cur: *const m0_ivec_cursor) -> m0_bindex_t;
}
extern "C" {
    #[doc = " Returns the latest index through the contiguous segments up to @dest."]
    #[doc = " @pre   dest >= m0_ivec_cursor_index(cur)."]
    #[doc = " @param cur cursor to start from."]
    #[doc = " @param dest uptil where to check."]
    pub fn m0_ivec_cursor_conti(cur: *const m0_ivec_cursor, dest: m0_bindex_t) -> m0_bindex_t;
}
#[doc = "Zero vector is a full fledged IO vector containing IO extents"]
#[doc = "as well as the IO buffers."]
#[doc = "An invariant (m0_0vec_invariant) is maintained for m0_0vec. It"]
#[doc = "always checks sanity of zero vector and keeps a bound check on"]
#[doc = "array of IO buffers by checking buffer alignment and count check."]
#[doc = ""]
#[doc = "Zero vector is typically allocated by upper layer by following"]
#[doc = "the bounds of network layer (max buffer size, max segments,"]
#[doc = "max seg size) and adds buffers/pages later as and when needed."]
#[doc = "Size of z_index array is same as array of buffer addresses and"]
#[doc = "array of segment counts."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_0vec {
    #[doc = " Bufvec representing extent of IO vector and array of buffers."]
    pub z_bvec: m0_bufvec,
    #[doc = " Array of indices of target object to start IO from."]
    pub z_index: *mut m0_bindex_t,
    #[doc = " Stores last buffer index."]
    pub z_last_buf_idx: m0_bindex_t,
    #[doc = " Count of data buffers added to the zero vec."]
    pub z_count: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_0vec() {
    assert_eq!(
        ::std::mem::size_of::<m0_0vec>(),
        48usize,
        concat!("Size of: ", stringify!(m0_0vec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_0vec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_0vec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_0vec>())).z_bvec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_0vec),
            "::",
            stringify!(z_bvec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_0vec>())).z_index as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_0vec),
            "::",
            stringify!(z_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_0vec>())).z_last_buf_idx as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_0vec),
            "::",
            stringify!(z_last_buf_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_0vec>())).z_count as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_0vec),
            "::",
            stringify!(z_count)
        )
    );
}
pub const M0_0VEC_SHIFT: ::std::os::raw::c_uint = 12;
pub const M0_0VEC_ALIGN: ::std::os::raw::c_uint = 4096;
pub const M0_0VEC_MASK: ::std::os::raw::c_uint = 4095;
pub const M0_SEG_SHIFT: ::std::os::raw::c_uint = 12;
pub const M0_SEG_SIZE: ::std::os::raw::c_uint = 4096;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
extern "C" {
    #[doc = "Initialize a pre-allocated m0_0vec structure."]
    #[doc = "@pre zvec != NULL."]
    #[doc = "@param zvec The m0_0vec structure to be initialized."]
    #[doc = "@param segs_nr Number of segments in zero vector."]
    #[doc = "@post zvec->z_bvec.ov_buf != NULL &&"]
    #[doc = "zvec->z_bvec.ov_vec.v_nr != 0 &&"]
    #[doc = "zvec->z_bvec.ov_vec.v_count != NULL &&"]
    #[doc = "zvec->z_index != NULL"]
    pub fn m0_0vec_init(zvec: *mut m0_0vec, segs_nr: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Finalize a m0_0vec structure."]
    #[doc = "@param The m0_0vec structure to be deallocated."]
    #[doc = "@see m0_0vec_init()."]
    pub fn m0_0vec_fini(zvec: *mut m0_0vec);
}
extern "C" {
    #[doc = "Init the m0_0vec structure from given m0_bufvec structure and"]
    #[doc = "array of indices."]
    #[doc = "This API does not copy data. Only pointers are copied."]
    #[doc = "@pre zvec != NULL && bufvec != NULL && indices != NULL."]
    #[doc = "@param zvec The m0_0vec structure to be initialized."]
    #[doc = "@param bufvec The m0_bufvec containing buffer starting addresses and"]
    #[doc = "with number of buffers and their byte counts."]
    #[doc = "@param indices Target object indices to start the IO from."]
    #[doc = "@post m0_0vec_invariant(zvec)."]
    pub fn m0_0vec_bvec_init(
        zvec: *mut m0_0vec,
        bufvec: *const m0_bufvec,
        indices: *const m0_bindex_t,
    );
}
extern "C" {
    #[doc = "Init the m0_0vec structure from array of buffers with indices and counts."]
    #[doc = "This API does not copy data. Just pointers are copied."]
    #[doc = "@note The m0_0vec struct should be allocated by user."]
    #[doc = ""]
    #[doc = "@param zvec The m0_0vec structure to be initialized."]
    #[doc = "@param bufs Array of IO buffers."]
    #[doc = "@param indices Array of target object indices."]
    #[doc = "@param counts Array of buffer counts."]
    #[doc = "@param segs_nr Number of segments contained in the buf array."]
    #[doc = "@post m0_0vec_invariant(zvec)."]
    pub fn m0_0vec_bufs_init(
        zvec: *mut m0_0vec,
        bufs: *mut *mut ::std::os::raw::c_void,
        indices: *const m0_bindex_t,
        counts: *const m0_bcount_t,
        segs_nr: u32,
    );
}
extern "C" {
    #[doc = "Add a m0_buf structure at given target index to m0_0vec structure."]
    #[doc = "@note The m0_0vec struct should be allocated by user."]
    #[doc = ""]
    #[doc = "@param zvec The m0_0vec structure to be initialized."]
    #[doc = "@param buf The m0_buf structure containing starting address of buffer"]
    #[doc = "and number of bytes in buffer."]
    #[doc = "@param index Index of target object to start IO from."]
    #[doc = "@post m0_0vec_invariant(zvec)."]
    pub fn m0_0vec_cbuf_add(
        zvec: *mut m0_0vec,
        buf: *const m0_buf,
        index: *const m0_bindex_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Helper functions to copy opaque data with specified size to and from a"]
    #[doc = " m0_bufvec"]
    pub fn m0_data_to_bufvec_copy(
        cur: *mut m0_bufvec_cursor,
        data: *mut ::std::os::raw::c_void,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_bufvec_to_data_copy(
        cur: *mut m0_bufvec_cursor,
        data: *mut ::std::os::raw::c_void,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_bufvec_copy(
        dst: *mut m0_bufvec,
        src: *mut m0_bufvec,
        num_bytes: m0_bcount_t,
    ) -> m0_bcount_t;
}
#[doc = " Represents the extent information for an io segment. m0_ioseg typically"]
#[doc = " represents a user space data buffer or a kernel page."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_ioseg {
    pub ci_index: u64,
    pub ci_count: u64,
}
#[test]
fn bindgen_test_layout_m0_ioseg() {
    assert_eq!(
        ::std::mem::size_of::<m0_ioseg>(),
        16usize,
        concat!("Size of: ", stringify!(m0_ioseg))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_ioseg>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_ioseg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ioseg>())).ci_index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ioseg),
            "::",
            stringify!(ci_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ioseg>())).ci_count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ioseg),
            "::",
            stringify!(ci_count)
        )
    );
}
#[doc = " Represents an index vector with {index, count}  tuples for a target"]
#[doc = " device (typically a cob)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_io_indexvec {
    pub ci_nr: u32,
    pub ci_iosegs: *mut m0_ioseg,
}
#[test]
fn bindgen_test_layout_m0_io_indexvec() {
    assert_eq!(
        ::std::mem::size_of::<m0_io_indexvec>(),
        16usize,
        concat!("Size of: ", stringify!(m0_io_indexvec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_io_indexvec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_io_indexvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_io_indexvec>())).ci_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_io_indexvec),
            "::",
            stringify!(ci_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_io_indexvec>())).ci_iosegs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_io_indexvec),
            "::",
            stringify!(ci_iosegs)
        )
    );
}
#[doc = " Represents sequence of index vector, one per network buffer."]
#[doc = " As a result of io coalescing, there could be multiple network"]
#[doc = " buffers associated with an io fop. Hence a SEQUENCE of m0_io_indexvec"]
#[doc = " is needed, one per network buffer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_io_indexvec_seq {
    pub cis_nr: u32,
    pub cis_ivecs: *mut m0_io_indexvec,
}
#[test]
fn bindgen_test_layout_m0_io_indexvec_seq() {
    assert_eq!(
        ::std::mem::size_of::<m0_io_indexvec_seq>(),
        16usize,
        concat!("Size of: ", stringify!(m0_io_indexvec_seq))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_io_indexvec_seq>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_io_indexvec_seq))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_io_indexvec_seq>())).cis_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_io_indexvec_seq),
            "::",
            stringify!(cis_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_io_indexvec_seq>())).cis_ivecs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_io_indexvec_seq),
            "::",
            stringify!(cis_ivecs)
        )
    );
}
extern "C" {
    pub fn m0_io_count(io_info: *const m0_io_indexvec) -> m0_bcount_t;
}
extern "C" {
    #[doc = " Function to split the indexvec from the given offset to the lenth specified."]
    #[doc = ""]
    #[doc = " @param mem_ivec Indexvec memory format."]
    #[doc = " @param curr_pos Start position for new indexvec."]
    #[doc = " @param nb_len Size of the data for new indexvec."]
    #[doc = " @param bshift Shift value for the data to align index vecs."]
    #[doc = ""]
    #[doc = " @pre in != NULL"]
    #[doc = " @pre out != NULL"]
    pub fn m0_indexvec_split(
        in_: *mut m0_indexvec,
        curr_pos: m0_bcount_t,
        nb_len: m0_bcount_t,
        bshift: u32,
        out: *mut m0_indexvec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Function to convert the on-wire indexvec to in-memory indexvec format.  Since"]
    #[doc = " m0_io_indexvec (on-wire structure) and m0_indexvec (in-memory structures are"]
    #[doc = " different, conversion is needed."]
    #[doc = ""]
    #[doc = " @param wire_ivec Indexvec wire format."]
    #[doc = " @param mem_ivec Indexvec memory format."]
    #[doc = " @param max_frags_nr Number of fragments from the wire_ivec."]
    #[doc = ""]
    #[doc = " @pre wire_ive != NULL"]
    #[doc = " @pre mem_ivec != NULL"]
    pub fn m0_indexvec_wire2mem(
        wire_ivec: *mut m0_io_indexvec,
        max_frags_nr: ::std::os::raw::c_int,
        bshift: u32,
        mem_ivec: *mut m0_indexvec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_indexvec_mem2wire(
        mem_ivec: *mut m0_indexvec,
        max_frags_nr: ::std::os::raw::c_int,
        bshift: u32,
        wire_ivec: *mut m0_io_indexvec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Creates an indexvec with a single extent, which spans the range [0. ~0)."]
    #[doc = " Since the range spanned by this indexvec represents union of all possible"]
    #[doc = " ranges that any indexvec can hold, it is referred as a universal indexvec."]
    #[doc = " @param iv  Input indexvec."]
    pub fn m0_indexvec_universal_set(iv: *mut m0_indexvec) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns true if the input indexvec is universal."]
    pub fn m0_indexvec_is_universal(iv: *const m0_indexvec) -> bool;
}
#[doc = " Vector of extents stored in m0_varr"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_indexvec_varr {
    #[doc = " Number of extents and their sizes."]
    pub iv_count: m0_varr,
    #[doc = " Array of starting extent indices, with the same size of iv_count."]
    pub iv_index: m0_varr,
    #[doc = " number of used elements, set by users"]
    pub iv_nr: u32,
}
#[test]
fn bindgen_test_layout_m0_indexvec_varr() {
    assert_eq!(
        ::std::mem::size_of::<m0_indexvec_varr>(),
        1208usize,
        concat!("Size of: ", stringify!(m0_indexvec_varr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_indexvec_varr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_indexvec_varr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_indexvec_varr>())).iv_count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_indexvec_varr),
            "::",
            stringify!(iv_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_indexvec_varr>())).iv_index as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_indexvec_varr),
            "::",
            stringify!(iv_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_indexvec_varr>())).iv_nr as *const _ as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_indexvec_varr),
            "::",
            stringify!(iv_nr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_ivec_varr_cursor {
    pub vc_ivv: *mut m0_indexvec_varr,
    #[doc = " Segment that the cursor is currently in."]
    pub vc_seg: u32,
    #[doc = " Offset within the segment that the cursor is positioned at."]
    pub vc_offset: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_ivec_varr_cursor() {
    assert_eq!(
        ::std::mem::size_of::<m0_ivec_varr_cursor>(),
        24usize,
        concat!("Size of: ", stringify!(m0_ivec_varr_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_ivec_varr_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_ivec_varr_cursor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ivec_varr_cursor>())).vc_ivv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ivec_varr_cursor),
            "::",
            stringify!(vc_ivv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ivec_varr_cursor>())).vc_seg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ivec_varr_cursor),
            "::",
            stringify!(vc_seg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ivec_varr_cursor>())).vc_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ivec_varr_cursor),
            "::",
            stringify!(vc_offset)
        )
    );
}
extern "C" {
    #[doc = " Allocates memory in m0_varr for index array and counts array in index vector."]
    #[doc = " @param len Number of elements to allocate memory for."]
    #[doc = " @pre   ivec != NULL && len > 0."]
    #[doc = " @ret   return 0 iff memory allocation succeeds. -ENOMEM on failure."]
    pub fn m0_indexvec_varr_alloc(ivec: *mut m0_indexvec_varr, len: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Deallocates the memory buffers in m0_varr."]
    #[doc = " @pre  ivec != NULL."]
    pub fn m0_indexvec_varr_free(ivec: *mut m0_indexvec_varr);
}
extern "C" {
    #[doc = " Initializes given index vector cursor."]
    #[doc = " @param cur  Given index vector cursor."]
    #[doc = " @param ivec Given index vector to be associated with cursor."]
    pub fn m0_ivec_varr_cursor_init(cur: *mut m0_ivec_varr_cursor, ivec: *mut m0_indexvec_varr);
}
extern "C" {
    #[doc = " Moves the index vector cursor forward by @count."]
    #[doc = " @param cur   Given index vector cursor."]
    #[doc = " @param count Count by which cursor has to be moved."]
    #[doc = " @ret   true  iff end of vector has been reached while"]
    #[doc = "              moving cursor by @count. Returns false otherwise."]
    pub fn m0_ivec_varr_cursor_move(cur: *mut m0_ivec_varr_cursor, count: m0_bcount_t) -> bool;
}
extern "C" {
    #[doc = " Moves index vector cursor forward until it reaches index @dest."]
    #[doc = " @pre   dest >= m0_ivec_cursor_index(cursor)."]
    #[doc = " @param dest Index uptil which cursor has to be moved."]
    #[doc = " @ret   true iff end of vector has been reached while"]
    #[doc = "             moving cursor. Returns false otherwise."]
    #[doc = " @post  m0_ivec_varr_cursor_index(cursor) == to."]
    pub fn m0_ivec_varr_cursor_move_to(cur: *mut m0_ivec_varr_cursor, dest: m0_bindex_t) -> bool;
}
extern "C" {
    #[doc = " Returns the number of bytes needed to move cursor to next segment in given"]
    #[doc = " index vector."]
    #[doc = " @param cur Index vector to be moved."]
    #[doc = " @ret   Number of bytes needed to move the cursor to next segment."]
    pub fn m0_ivec_varr_cursor_step(cur: *const m0_ivec_varr_cursor) -> m0_bcount_t;
}
extern "C" {
    #[doc = " Returns index at current cursor position."]
    #[doc = " @param cur Given index vector cursor."]
    #[doc = " @ret   Index at current cursor position."]
    pub fn m0_ivec_varr_cursor_index(cur: *const m0_ivec_varr_cursor) -> m0_bindex_t;
}
extern "C" {
    #[doc = " Returns the latest index through the contiguous segments up to @dest."]
    #[doc = " @pre   dest >= m0_ivec_varr_cursor_index(cur)."]
    #[doc = " @param cur cursor to start from."]
    #[doc = " @param dest uptil where to check."]
    pub fn m0_ivec_varr_cursor_conti(
        cur: *const m0_ivec_varr_cursor,
        dest: m0_bindex_t,
    ) -> m0_bindex_t;
}
#[doc = "@addtogroup atomic"]
#[doc = ""]
#[doc = "Implementation of atomic operations for Linux user space uses x86_64 assembly"]
#[doc = "language instructions (with gcc syntax). \"Lock\" prefix is used"]
#[doc = "everywhere---no optimisation for non-SMP configurations in present."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_atomic64 {
    pub a_value: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_m0_atomic64() {
    assert_eq!(
        ::std::mem::size_of::<m0_atomic64>(),
        8usize,
        concat!("Size of: ", stringify!(m0_atomic64))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_atomic64>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_atomic64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_atomic64>())).a_value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_atomic64),
            "::",
            stringify!(a_value)
        )
    );
}
#[doc = "@defgroup time Generic time manipulation"]
#[doc = ""]
#[doc = "M0 time delivers resolution in nanoseconds. It is an unsigned 64-bit integer."]
#[doc = "@{"]
pub type m0_time_t = u64;
pub const M0_TIME_ONE_SECOND: ::std::os::raw::c_uint = 1000000000;
pub const M0_TIME_ONE_MSEC: ::std::os::raw::c_uint = 1000000;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
extern "C" {
    #[doc = "Special value of abs_timeout indicates that action should be performed"]
    #[doc = "immediately"]
    pub static M0_TIME_IMMEDIATELY: m0_time_t;
}
extern "C" {
    #[doc = " The largest time that is never reached in system life."]
    pub static M0_TIME_NEVER: m0_time_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
#[test]
fn bindgen_test_layout_itimerspec() {
    assert_eq!(
        ::std::mem::size_of::<itimerspec>(),
        32usize,
        concat!("Size of: ", stringify!(itimerspec))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerspec>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerspec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerspec>())).it_interval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<itimerspec>())).it_value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerspec),
            "::",
            stringify!(it_value)
        )
    );
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn time(__timer: *mut time_t) -> time_t;
}
extern "C" {
    pub fn difftime(__time1: time_t, __time0: time_t) -> f64;
}
extern "C" {
    pub fn mktime(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strftime_l(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
        __loc: __locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn gmtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn gmtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn asctime(__tp: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime(__timer: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn asctime_r(
        __tp: *const tm,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        __timer: *const time_t,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut __tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub static mut __daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub fn stime(__when: *const time_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timegm(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn timelocal(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn dysize(__year: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nanosleep(
        __requested_time: *const timespec,
        __remaining: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_nanosleep(
        __clock_id: clockid_t,
        __flags: ::std::os::raw::c_int,
        __req: *const timespec,
        __rem: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getcpuclockid(__pid: pid_t, __clock_id: *mut clockid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_create(
        __clock_id: clockid_t,
        __evp: *mut sigevent,
        __timerid: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_delete(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_settime(
        __timerid: timer_t,
        __flags: ::std::os::raw::c_int,
        __value: *const itimerspec,
        __ovalue: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_gettime(__timerid: timer_t, __value: *mut itimerspec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_getoverrun(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(
        __ts: *mut timespec,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const CLOCK_SOURCES_M0_CLOCK_SOURCE_REALTIME: CLOCK_SOURCES = 0;
pub const CLOCK_SOURCES_M0_CLOCK_SOURCE_MONOTONIC: CLOCK_SOURCES = 1;
#[doc = " @note POSIX timers on Linux don't support this clock source"]
pub const CLOCK_SOURCES_M0_CLOCK_SOURCE_MONOTONIC_RAW: CLOCK_SOURCES = 4;
#[doc = " gettimeofday(). All others clock sources use clock_gettime()"]
pub const CLOCK_SOURCES_M0_CLOCK_SOURCE_GTOD: CLOCK_SOURCES = 5;
#[doc = " CLOCK_REALTIME + CLOCK_MONOTONIC combination."]
#[doc = "  @see m0_utime_init()"]
pub const CLOCK_SOURCES_M0_CLOCK_SOURCE_REALTIME_MONOTONIC: CLOCK_SOURCES = 6;
#[doc = " Clock sources for m0_time_now(). @see m0_time_now()"]
#[doc = " @note Be sure to change m0_semaphore and m0_timer implementations"]
#[doc = " after changing CLOCK_SOURCES list."]
#[doc = " @see man 3p clock_gettime"]
#[doc = " @see timer_posix_set(), m0_semaphore_timeddown(), m0_time_now(),"]
#[doc = "\tm0_time_to_realtime()."]
pub type CLOCK_SOURCES = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Clock source for m0_time_now()"]
    pub static M0_CLOCK_SOURCE: CLOCK_SOURCES;
}
extern "C" {
    #[doc = " Offset for M0_CLOCK_SOURCE_REALTIME_MONOTONIC clock source."]
    #[doc = "  @see m0_utime_init()"]
    pub static mut m0_time_monotonic_offset: m0_time_t;
}
extern "C" {
    #[doc = " Useful for mutex/semaphore implementation. This function will translate"]
    #[doc = " time from value obtained from m0_time_now() to value that can be used"]
    #[doc = " with CLOCK_REALTIME-only functions such as sem_timedwait() and"]
    #[doc = " pthread_mutex_timedlock()."]
    #[doc = " @param time Time obtained from m0_time_now() and adjusted somehow if needed."]
    #[doc = " @return Converted time value."]
    #[doc = " @note In some cases this function will have 2 calls to clock_gettime()."]
    pub fn m0_time_to_realtime(abs_time: m0_time_t) -> m0_time_t;
}
extern "C" {
    #[doc = " Create and return a m0_time_t from seconds and nanoseconds."]
    pub fn m0_time(secs: u64, ns: ::std::os::raw::c_long) -> m0_time_t;
}
extern "C" {
    #[doc = " Get the current time.  This may or may not relate to wall time."]
    pub fn m0_time_now() -> m0_time_t;
}
extern "C" {
    #[doc = "Create a m0_time_t initialised with seconds + nanosecond in the future."]
    #[doc = ""]
    #[doc = "@param secs seconds from now"]
    #[doc = "@param ns nanoseconds from now"]
    #[doc = ""]
    #[doc = "@return The result time."]
    pub fn m0_time_from_now(secs: u64, ns: ::std::os::raw::c_long) -> m0_time_t;
}
extern "C" {
    #[doc = "Add t2 to t1 and return that result."]
    #[doc = ""]
    #[doc = "@return The result time. If either t1 or t2 is M0_TIME_NEVER, the result"]
    #[doc = "is M0_TIME_NEVER."]
    pub fn m0_time_add(t1: m0_time_t, t2: m0_time_t) -> m0_time_t;
}
extern "C" {
    #[doc = "Subtract t2 from t1 and return that result."]
    #[doc = ""]
    #[doc = "@return The result time. If t1 == M0_TIME_NEVER, M0_TIME_NEVER is returned."]
    #[doc = "@pre t2 < M0_TIME_NEVER && t1 >= t2"]
    pub fn m0_time_sub(t1: m0_time_t, t2: m0_time_t) -> m0_time_t;
}
extern "C" {
    #[doc = "Sleep for requested time. If interrupted, remaining time returned."]
    #[doc = ""]
    #[doc = "@param req requested time to sleep"]
    #[doc = "@param rem [OUT] remaining time, NULL causes remaining time to be ignored."]
    #[doc = "@return 0 means success. -1 means error. Remaining time is stored in rem."]
    pub fn m0_nanosleep(req: m0_time_t, rem: *mut m0_time_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get \"second\" part from the time."]
    pub fn m0_time_seconds(time: m0_time_t) -> u64;
}
extern "C" {
    #[doc = " Get \"nanosecond\" part from the time."]
    pub fn m0_time_nanoseconds(time: m0_time_t) -> u64;
}
extern "C" {
    pub fn m0_time_is_in_past(time: m0_time_t) -> bool;
}
#[doc = "List entry."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_list_link {
    #[doc = " Next entry in the list"]
    pub ll_next: *mut m0_list_link,
    #[doc = " Previous entry in the list"]
    pub ll_prev: *mut m0_list_link,
}
#[test]
fn bindgen_test_layout_m0_list_link() {
    assert_eq!(
        ::std::mem::size_of::<m0_list_link>(),
        16usize,
        concat!("Size of: ", stringify!(m0_list_link))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_list_link>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_list_link))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_list_link>())).ll_next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_list_link),
            "::",
            stringify!(ll_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_list_link>())).ll_prev as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_list_link),
            "::",
            stringify!(ll_prev)
        )
    );
}
extern "C" {
    #[doc = "initialize list link entry"]
    #[doc = ""]
    #[doc = "It is not necessary to call this function if the first operation on the link is"]
    #[doc = "any of m0_list_add*() functions."]
    #[doc = ""]
    #[doc = "@param link - pointer to link enty"]
    pub fn m0_list_link_init(link: *mut m0_list_link);
}
extern "C" {
    #[doc = "free resources associated with link entry"]
    #[doc = ""]
    #[doc = "@param link - pointer to link enty"]
    pub fn m0_list_link_fini(link: *mut m0_list_link);
}
extern "C" {
    pub fn m0_list_link_invariant(link: *const m0_list_link) -> bool;
}
#[doc = "List head."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_list {
    #[doc = " Pointer to the first entry in the list."]
    pub l_head: *mut m0_list_link,
    #[doc = " Pointer to the last entry in the list."]
    pub l_tail: *mut m0_list_link,
}
#[test]
fn bindgen_test_layout_m0_list() {
    assert_eq!(
        ::std::mem::size_of::<m0_list>(),
        16usize,
        concat!("Size of: ", stringify!(m0_list))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_list>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_list>())).l_head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_list),
            "::",
            stringify!(l_head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_list>())).l_tail as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_list),
            "::",
            stringify!(l_tail)
        )
    );
}
extern "C" {
    #[doc = "Initializes list head."]
    pub fn m0_list_init(head: *mut m0_list);
}
extern "C" {
    #[doc = "Finalizes the list."]
    pub fn m0_list_fini(head: *mut m0_list);
}
extern "C" {
    #[doc = "check list is empty"]
    #[doc = ""]
    #[doc = "@param head pointer to list head"]
    pub fn m0_list_is_empty(head: *const m0_list) -> bool;
}
extern "C" {
    #[doc = "Returns true iff @link is in @list."]
    pub fn m0_list_contains(list: *const m0_list, link: *const m0_list_link) -> bool;
}
extern "C" {
    #[doc = "This function iterate over the argument list checking that double-linked"]
    #[doc = "list invariant holds (x->ll_prev->ll_next == x && x->ll_next->ll_prev == x)."]
    #[doc = ""]
    #[doc = "@return true iff @list isn't corrupted"]
    pub fn m0_list_invariant(list: *const m0_list) -> bool;
}
extern "C" {
    pub fn m0_list_length(list: *const m0_list) -> size_t;
}
extern "C" {
    #[doc = "add list to top on the list"]
    #[doc = ""]
    #[doc = "This function can be called on an uninitialised @next link. All @next fields are"]
    #[doc = "overwritten."]
    #[doc = ""]
    #[doc = "@param head pointer to list head"]
    #[doc = "@param next  pointer to list entry"]
    #[doc = ""]
    pub fn m0_list_add(head: *mut m0_list, next: *mut m0_list_link);
}
extern "C" {
    #[doc = "add list to tail on the list"]
    #[doc = ""]
    #[doc = "This function can be called on an uninitialised @next link. All @next fields are"]
    #[doc = "overwritten."]
    #[doc = ""]
    #[doc = "@param head pointer to list head"]
    #[doc = "@param next  pointer to list entry"]
    pub fn m0_list_add_tail(head: *mut m0_list, next: *mut m0_list_link);
}
extern "C" {
    #[doc = "Adds an element to the list right after the specified element."]
    #[doc = ""]
    #[doc = "This function can be called on an uninitialised @next link. All @next fields"]
    #[doc = "are overwritten."]
    pub fn m0_list_add_after(anchor: *mut m0_list_link, next: *mut m0_list_link);
}
extern "C" {
    #[doc = "Adds an element to the list right before the specified element."]
    #[doc = ""]
    #[doc = "This function can be called on an uninitialised @next link. All @next fields"]
    #[doc = "are overwritten."]
    pub fn m0_list_add_before(anchor: *mut m0_list_link, next: *mut m0_list_link);
}
extern "C" {
    #[doc = "Deletes an entry from the list and re-initializes the entry."]
    pub fn m0_list_del(old: *mut m0_list_link);
}
extern "C" {
    #[doc = "Moves an entry to head of the list."]
    pub fn m0_list_move(head: *mut m0_list, next: *mut m0_list_link);
}
extern "C" {
    #[doc = "Moves an entry to tail of the list."]
    pub fn m0_list_move_tail(head: *mut m0_list, next: *mut m0_list_link);
}
extern "C" {
    #[doc = "is link entry connected to the list"]
    #[doc = ""]
    #[doc = "@param link - pointer to link entry"]
    #[doc = ""]
    #[doc = "@retval true - entry connected to a list"]
    #[doc = "@retval false - entry disconnected from a list"]
    pub fn m0_list_link_is_in(link: *const m0_list_link) -> bool;
}
extern "C" {
    pub fn m0_list_link_is_last(link: *const m0_list_link, head: *const m0_list) -> bool;
}
#[doc = " Enum descriptor."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_enum {
    #[doc = " Name of the enum type."]
    pub xe_name: *const ::std::os::raw::c_char,
    #[doc = " Number of constants in the type."]
    pub xe_nr: u32,
    #[doc = " Array of constant descriptors."]
    #[doc = ""]
    #[doc = " This array contains (self->xe_nr + 1) element. The last element is"]
    #[doc = " a sentinel, see xcode/enum.c:valget()."]
    pub xe_val: *const m0_xcode_enum_val,
    #[doc = " Maximal among constant name (m0_xcode_enum_val::xev_name) lengths for"]
    #[doc = " this type."]
    #[doc = ""]
    #[doc = " This is useful for formatting."]
    pub xe_maxlen: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_m0_xcode_enum() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_enum>(),
        32usize,
        concat!("Size of: ", stringify!(m0_xcode_enum))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_enum>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_enum))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum>())).xe_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum),
            "::",
            stringify!(xe_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum>())).xe_nr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum),
            "::",
            stringify!(xe_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum>())).xe_val as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum),
            "::",
            stringify!(xe_val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum>())).xe_maxlen as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum),
            "::",
            stringify!(xe_maxlen)
        )
    );
}
#[doc = " @defgroup xcode"]
#[doc = ""]
#[doc = " Enumeration support in xcode"]
#[doc = " ----------------------------"]
#[doc = ""]
#[doc = " xcode provides a rudimentary support for enumeration (enum) reflection."]
#[doc = ""]
#[doc = " A enumeration type is represented by an instance of m0_xcode_enum structure,"]
#[doc = " which contains an array (m0_xcode_enum::xe_val[]) of m0_xcode_enum_val"]
#[doc = " structures describing all valid enumeration constants for the type."]
#[doc = ""]
#[doc = " xcode provides functions to convert enums between binary and symbolic form"]
#[doc = " (m0_xcode_enum_read() and m0_xcode_print()). In addition, a enum can be"]
#[doc = " interpreted as a set of bit-flags, OR-ed to construct bit-masks. Resulting"]
#[doc = " bit-masks can be parsed and printed by m0_xcode_bitmask_read() and"]
#[doc = " m0_xcode_bitmask_print()."]
#[doc = ""]
#[doc = " m0_xcode_enum representation is constructed automatically by the build"]
#[doc = " process for each enum declaration tagged with the M0_XCA_ENUM. This only"]
#[doc = " works for named enums."]
#[doc = ""]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_enum_val {
    #[doc = " The index, starting with 0, of the constant in the enum declaration."]
    #[doc = ""]
    #[doc = " The literally first constant within \"enum { ... }\" declaration gets"]
    #[doc = " index 0, the second---1 and so on."]
    #[doc = ""]
    #[doc = " The last element in the m0_xcode_enum::xe_val[] array is a sentinel"]
    #[doc = " with index -1."]
    pub xev_idx: ::std::os::raw::c_int,
    #[doc = " Constant value."]
    pub xev_val: u64,
    #[doc = " Symbolic constant name."]
    #[doc = ""]
    #[doc = " The sentinel element contains \"Invalid value of enum 'NAME'.\" string"]
    #[doc = " here, where NAME is m0_xcode_enum::xe_name."]
    pub xev_name: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_m0_xcode_enum_val() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_enum_val>(),
        24usize,
        concat!("Size of: ", stringify!(m0_xcode_enum_val))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_enum_val>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_enum_val))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum_val>())).xev_idx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum_val),
            "::",
            stringify!(xev_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum_val>())).xev_val as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum_val),
            "::",
            stringify!(xev_val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_enum_val>())).xev_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_enum_val),
            "::",
            stringify!(xev_name)
        )
    );
}
extern "C" {
    pub fn m0_xcode_enum_is_valid(en: *const m0_xcode_enum, val: u64) -> bool;
}
extern "C" {
    #[doc = " Returns symbolic name for a enum constant."]
    #[doc = ""]
    #[doc = " If \"buf\" is NULL:"]
    #[doc = ""]
    #[doc = "     - this function always returns a static string;"]
    #[doc = ""]
    #[doc = "     - for an invalid value, a fixed (per enum type) string is returned (see"]
    #[doc = "       m0_xcode_enum_val::xev_name). This string does not depend on the value"]
    #[doc = "       and hence, cannot be parsed back by m0_xcode_enum_read()."]
    #[doc = ""]
    #[doc = " If \"buf\" is not NULL:"]
    #[doc = ""]
    #[doc = "     - valid values are processed as in (buf == NULL) case, that is, a static"]
    #[doc = "       string is returned;"]
    #[doc = ""]
    #[doc = "     - invalid value is snprintf-ed into buf in the sexadecimal form. The"]
    #[doc = "       buffer should be sufficiently large."]
    pub fn m0_xcode_enum_print(
        en: *const m0_xcode_enum,
        val: u64,
        buf: *mut ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Parses a symbolic enum constant name into the binary value."]
    #[doc = ""]
    #[doc = " \"buf\" should be a usual zero-terminated string. The function first tries to"]
    #[doc = " interpret first \"nr\" bytes as a symbolic name of a constant in the given"]
    #[doc = " enum. Failing that, the function tries to interpret first \"nr\" bytes of \"buf\""]
    #[doc = " as a sexadecimal representation of a value (potentially looking beyond \"nr\""]
    #[doc = " bytes in this case)."]
    pub fn m0_xcode_enum_read(
        en: *const m0_xcode_enum,
        buf: *const ::std::os::raw::c_char,
        nr: ::std::os::raw::c_int,
        val: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_xcode_bitmask_is_valid(en: *const m0_xcode_enum, val: u64) -> bool;
}
extern "C" {
    #[doc = " Outputs the symbolic name of a bitmask."]
    #[doc = ""]
    #[doc = " The general forms of the output, constructed in the first \"nr\" bytes of \"buf\""]
    #[doc = " are:"]
    #[doc = ""]
    #[doc = " @verbatim"]
    #[doc = "     CONST_0|CONST_1|...|CONST_N|REST"]
    #[doc = " @endverbatim"]
    #[doc = ""]
    #[doc = " @verbatim"]
    #[doc = "     CONST_0|CONST_1|...|CONST_N"]
    #[doc = " @endverbatim"]
    #[doc = ""]
    #[doc = " where CONST-s are symbolic names of set bits in the bitmask and REST is the"]
    #[doc = " sexadecimal representation of the remaining invalid bits that have no"]
    #[doc = " matching constants. The second form is used when m0_xcode_bitmask_is_valid()"]
    #[doc = " holds."]
    pub fn m0_xcode_bitmask_print(
        en: *const m0_xcode_enum,
        val: u64,
        buf: *mut ::std::os::raw::c_char,
        nr: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Parses the symbolic representation of the bitmask."]
    #[doc = ""]
    #[doc = " This function can parse the output of m0_xcode_bitmask_print(). And maybe"]
    #[doc = " more, but do not rely on it."]
    pub fn m0_xcode_bitmask_read(
        en: *const m0_xcode_enum,
        buf: *const ::std::os::raw::c_char,
        nr: ::std::os::raw::c_int,
        val: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Custom field reader for enums."]
    #[doc = ""]
    #[doc = " The pointer to this function is installed into m0_xcode_field::xf_read by"]
    #[doc = " m0gccxml2xcode for fields tagged with the M0_XCA_FENUM macro."]
    pub fn m0_xcode_enum_field_read(
        it: *const m0_xcode_cursor,
        obj: *mut m0_xcode_obj,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Custom field reader for bitmasks."]
    #[doc = ""]
    #[doc = " The pointer to this function is installed into m0_xcode_field::xf_read by"]
    #[doc = " m0gccxml2xcode for fields tagged with the M0_XCA_FBITMASK macro."]
    pub fn m0_xcode_bitmask_field_read(
        it: *const m0_xcode_cursor,
        obj: *mut m0_xcode_obj,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_field_ops {
    _unused: [u8; 0],
}
#[doc = "RECORD corresponds to C struct. Fields of RECORD type are located one"]
#[doc = "after another in memory."]
pub const m0_xcode_aggr_M0_XA_RECORD: m0_xcode_aggr = 0;
#[doc = "UNION corresponds to discriminated union. Its first field is referred"]
#[doc = "to as a \"discriminator\" and has an atomic type. Other fields of union"]
#[doc = "are tagged (m0_xcode_field::xf_tag) and the value of the"]
#[doc = "discriminator field determines which of the following fields is"]
#[doc = "actually used."]
#[doc = ""]
#[doc = "@note that, similarly to M0_XA_SEQUENCE, the discriminator field can"]
#[doc = "have M0_XAT_VOID type. In this case its tag is used instead of its"]
#[doc = "value (use cases are not clear)."]
pub const m0_xcode_aggr_M0_XA_UNION: m0_xcode_aggr = 1;
#[doc = "SEQUENCE corresponds to counted array. Sequence always has two"]
#[doc = "fields: a scalar \"counter\" field and a field denoting the element of"]
#[doc = "the array."]
#[doc = ""]
#[doc = "@note if counter has type M0_XAT_VOID, its tag used as a"]
#[doc = "counter. This is used to represent fixed size arrays without an"]
#[doc = "explicit counter field."]
pub const m0_xcode_aggr_M0_XA_SEQUENCE: m0_xcode_aggr = 2;
#[doc = "Array is a fixed size array. It always has a single field. The number"]
#[doc = "of elements in the array is recorded as the tag is this field."]
pub const m0_xcode_aggr_M0_XA_ARRAY: m0_xcode_aggr = 3;
#[doc = "TYPEDEF is an alias for another type. It always has a single field."]
pub const m0_xcode_aggr_M0_XA_TYPEDEF: m0_xcode_aggr = 4;
#[doc = "OPAQUE represents a pointer."]
#[doc = ""]
#[doc = "A field of OPAQUE type must have m0_xcode_field::xf_opaque() function"]
#[doc = "pointer set to a function which determines the actual type of the"]
#[doc = "object pointed to."]
pub const m0_xcode_aggr_M0_XA_OPAQUE: m0_xcode_aggr = 5;
#[doc = "ATOM represents \"atomic\" data-types having no internal"]
#[doc = "structure. m0_xcode_type-s with m0_xcode_type::xct_aggr set to"]
#[doc = "M0_XA_ATOM have m0_xcode_type::xct_nr == 0 and no fields."]
#[doc = ""]
#[doc = "Atomic types are enumerated in m0_xode_atom_type."]
pub const m0_xcode_aggr_M0_XA_ATOM: m0_xcode_aggr = 6;
#[doc = "ATOM represents \"atomic\" data-types having no internal"]
#[doc = "structure. m0_xcode_type-s with m0_xcode_type::xct_aggr set to"]
#[doc = "M0_XA_ATOM have m0_xcode_type::xct_nr == 0 and no fields."]
#[doc = ""]
#[doc = "Atomic types are enumerated in m0_xode_atom_type."]
pub const m0_xcode_aggr_M0_XA_NR: m0_xcode_aggr = 7;
#[doc = "Type of aggregation for a data-type."]
#[doc = ""]
#[doc = "A value of this enum, stored in m0_code_type::xct_aggr determines how fields"]
#[doc = "of the type are interpreted."]
pub type m0_xcode_aggr = ::std::os::raw::c_uint;
extern "C" {
    #[doc = "Human-readable names of m0_xcode_aggr values."]
    pub static mut m0_xcode_aggr_name: [*const ::std::os::raw::c_char; 7usize];
}
pub const m0_xode_atom_type_M0_XAT_VOID: m0_xode_atom_type = 0;
pub const m0_xode_atom_type_M0_XAT_U8: m0_xode_atom_type = 1;
pub const m0_xode_atom_type_M0_XAT_U32: m0_xode_atom_type = 2;
pub const m0_xode_atom_type_M0_XAT_U64: m0_xode_atom_type = 3;
pub const m0_xode_atom_type_M0_XAT_NR: m0_xode_atom_type = 4;
#[doc = "Atomic types."]
#[doc = ""]
#[doc = "To each value of this enumeration, except for M0_XAT_NR, a separate"]
#[doc = "m0_xcode_type (M0_XT_VOID, M0_XT_U8, &c.)."]
pub type m0_xode_atom_type = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Human-readable names of elements of m0_xcode_atom_type"]
    pub static mut m0_xcode_atom_type_name: [*const ::std::os::raw::c_char; 4usize];
}
pub const M0_XCODE_DECOR_READ: ::std::os::raw::c_uint = 0;
pub const M0_XCODE_DECOR_MAX: ::std::os::raw::c_uint = 10;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
#[doc = " Field of data-type."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_field {
    #[doc = " Field name."]
    pub xf_name: *const ::std::os::raw::c_char,
    #[doc = " Field type."]
    pub xf_type: *const m0_xcode_type,
    #[doc = " Tag, associated with this field."]
    #[doc = ""]
    #[doc = "Tag is used in the following ways:"]
    #[doc = ""]
    #[doc = "- if first field of a SEQUENCE type has type VOID, its tag is"]
    #[doc = "used as a count of element in the sequence;"]
    #[doc = ""]
    #[doc = "- tag of the only field of ARRAY type is the number of elements"]
    #[doc = "in the array;"]
    #[doc = ""]
    #[doc = "- tag of non-first field of a UNION type is used to determine"]
    #[doc = "when the field is actually present in the object: the field is"]
    #[doc = "present iff its tag equals the discriminator of the union."]
    #[doc = ""]
    #[doc = "The discriminator is the value of the first field of the"]
    #[doc = "union."]
    pub xf_tag: u64,
    #[doc = "Fields with m0_xcode_type::xf_type == &M0_XT_OPAQUE are \"opaque\""]
    #[doc = "fields. An opaque field corresponds to a"]
    #[doc = "pointer. m0_xcode_type::xf_opaque() is called by the xcode to follow"]
    #[doc = "the pointer. This function returns (in its \"out\" parameter) a type of"]
    #[doc = "the object pointed to. \"par\" parameter refers to the parent object to"]
    #[doc = "which the field belongs."]
    pub xf_opaque: ::std::option::Option<
        unsafe extern "C" fn(
            par: *const m0_xcode_obj,
            out: *mut *const m0_xcode_type,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Byte offset of this field from the beginning of the object."]
    pub xf_offset: u32,
    #[doc = "\"Decorations\" are used by xcode users to associate additional"]
    #[doc = "information with introspection elements."]
    #[doc = ""]
    #[doc = "@see m0_xcode_decor_register()"]
    #[doc = "@see m0_xcode_type::xct_decor[]"]
    pub xf_decor: [*mut ::std::os::raw::c_void; 10usize],
    pub xf_read: ::std::option::Option<
        unsafe extern "C" fn(
            it: *const m0_xcode_cursor,
            obj: *mut m0_xcode_obj,
            str_: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_m0_xcode_field() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_field>(),
        128usize,
        concat!("Size of: ", stringify!(m0_xcode_field))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_field>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_field))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_type as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_tag as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_opaque as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_opaque)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_offset as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_decor as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_decor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_field>())).xf_read as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_field),
            "::",
            stringify!(xf_read)
        )
    );
}
#[doc = " Type belongs to BE xcode domain, @see M0_XCA_DOMAIN"]
pub const m0_xcode_type_flags_M0_XCODE_TYPE_FLAG_DOM_BE: m0_xcode_type_flags = 1;
#[doc = " Type belongs to RPC xcode domain, @see M0_XCA_DOMAIN"]
pub const m0_xcode_type_flags_M0_XCODE_TYPE_FLAG_DOM_RPC: m0_xcode_type_flags = 2;
#[doc = " Type belongs to CONF xcode domain, @see M0_XCA_DOMAIN"]
pub const m0_xcode_type_flags_M0_XCODE_TYPE_FLAG_DOM_CONF: m0_xcode_type_flags = 4;
pub type m0_xcode_type_flags = ::std::os::raw::c_uint;
#[doc = "This struct represents a data-type."]
#[repr(C)]
#[derive(Debug)]
pub struct m0_xcode_type {
    #[doc = " What sub-objects instances of this type have and how they are"]
    #[doc = "organized?"]
    pub xct_aggr: m0_xcode_aggr,
    #[doc = " Type name."]
    pub xct_name: *const ::std::os::raw::c_char,
    #[doc = " Custom operations."]
    pub xct_ops: *const m0_xcode_type_ops,
    #[doc = "Which atomic type this is?"]
    #[doc = ""]
    #[doc = "This field is valid only when xt->xct_aggr == M0_XA_ATOM."]
    pub xct_atype: m0_xode_atom_type,
    #[doc = "Flags, associated with this type (if any)."]
    #[doc = "For possible values @see m0_xcode_type_flags enum."]
    pub xct_flags: u32,
    #[doc = "\"Decorations\" are used by xcode users to associate additional"]
    #[doc = "information with introspection elements."]
    #[doc = ""]
    #[doc = "@see m0_xcode_decor_register()"]
    #[doc = "@see m0_xcode_field::xf_decor[]"]
    pub xct_decor: [*mut ::std::os::raw::c_void; 10usize],
    #[doc = " Size in bytes of in-memory instances of this type."]
    pub xct_sizeof: size_t,
    #[doc = " Number of fields."]
    pub xct_nr: size_t,
    #[doc = " Array of fields."]
    pub xct_child: __IncompleteArrayField<m0_xcode_field>,
}
#[test]
fn bindgen_test_layout_m0_xcode_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_type>(),
        128usize,
        concat!("Size of: ", stringify!(m0_xcode_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_aggr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_aggr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_ops as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_atype as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_atype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_flags as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_decor as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_decor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_sizeof as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_sizeof)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_nr as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type>())).xct_child as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type),
            "::",
            stringify!(xct_child)
        )
    );
}
#[doc = " \"Typed\" xcode object."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_obj {
    #[doc = " Object's type."]
    pub xo_type: *const m0_xcode_type,
    #[doc = " Pointer to object in memory."]
    pub xo_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_m0_xcode_obj() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_obj>(),
        16usize,
        concat!("Size of: ", stringify!(m0_xcode_obj))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_obj>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_obj))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_obj>())).xo_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_obj),
            "::",
            stringify!(xo_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_obj>())).xo_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_obj),
            "::",
            stringify!(xo_ptr)
        )
    );
}
#[doc = "Custom xcoding functions."]
#[doc = ""]
#[doc = "User provides these functions (which are all optional) to use non-standard"]
#[doc = "xcoding."]
#[doc = ""]
#[doc = "@see m0_xcode_decode()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_type_ops {
    pub xto_length: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut m0_xcode_ctx,
            obj: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub xto_encode: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut m0_xcode_ctx,
            obj: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub xto_decode: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut m0_xcode_ctx,
            obj: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Call-back invoked by m0_xcode_read() to read custom object"]
    #[doc = " representation."]
    #[doc = ""]
    #[doc = " Returns number of bytes consumed from the string, or negative error"]
    #[doc = " code. obj->xo_ptr of suitable size is allocated by m0_xcode_read(),"]
    #[doc = " obj->xo_type is assigned. The call-back should fill obj->xo_ptr"]
    #[doc = " fields."]
    #[doc = ""]
    #[doc = " @see string_literal()."]
    pub xto_read: ::std::option::Option<
        unsafe extern "C" fn(
            it: *const m0_xcode_cursor,
            obj: *mut m0_xcode_obj,
            str_: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_m0_xcode_type_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_type_ops>(),
        32usize,
        concat!("Size of: ", stringify!(m0_xcode_type_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_type_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_type_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type_ops>())).xto_length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type_ops),
            "::",
            stringify!(xto_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type_ops>())).xto_encode as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type_ops),
            "::",
            stringify!(xto_encode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type_ops>())).xto_decode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type_ops),
            "::",
            stringify!(xto_decode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_type_ops>())).xto_read as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_type_ops),
            "::",
            stringify!(xto_read)
        )
    );
}
pub const M0_XCODE_DEPTH_MAX: ::std::os::raw::c_uint = 10;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
#[doc = " This value is never returned by m0_xcode_next(). It is set by the"]
#[doc = "user to indicate the beginning of iteration."]
pub const m0_xcode_cursor_flag_M0_XCODE_CURSOR_NONE: m0_xcode_cursor_flag = 0;
#[doc = " Tree element is visited for the first time."]
pub const m0_xcode_cursor_flag_M0_XCODE_CURSOR_PRE: m0_xcode_cursor_flag = 1;
#[doc = " The sub-tree, rooted at an element's field has been processed"]
#[doc = "fully."]
pub const m0_xcode_cursor_flag_M0_XCODE_CURSOR_IN: m0_xcode_cursor_flag = 2;
#[doc = " All fields have been processed fully, this is the last time the"]
#[doc = "element is visited."]
pub const m0_xcode_cursor_flag_M0_XCODE_CURSOR_POST: m0_xcode_cursor_flag = 3;
#[doc = " All fields have been processed fully, this is the last time the"]
#[doc = "element is visited."]
pub const m0_xcode_cursor_flag_M0_XCODE_CURSOR_NR: m0_xcode_cursor_flag = 4;
#[doc = "Traversal order."]
pub type m0_xcode_cursor_flag = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Human-readable names of values in m0_xcode_cursor_flag"]
    pub static mut m0_xcode_cursor_flag_name: [*const ::std::os::raw::c_char; 4usize];
}
#[doc = "Cursor that captures the state of iteration."]
#[doc = ""]
#[doc = "The cursor contains a stack of \"frames\". A frame describes the iteration at"]
#[doc = "a particular level."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_cursor {
    #[doc = " Depth of the iteration."]
    pub xcu_depth: ::std::os::raw::c_int,
    pub xcu_stack: [m0_xcode_cursor_m0_xcode_cursor_frame; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_cursor_m0_xcode_cursor_frame {
    #[doc = " An object that the iteration is currently in."]
    pub s_obj: m0_xcode_obj,
    #[doc = " A field within the object that the iteration is currently"]
    #[doc = "at."]
    pub s_fieldno: ::std::os::raw::c_int,
    #[doc = " A sequence element within the field that the iteration is"]
    #[doc = "currently at."]
    #[doc = ""]
    #[doc = "This is valid iff ->s_obj->xo_type->xcf_aggr =="]
    #[doc = "M0_XA_SEQUENCE."]
    pub s_elno: u64,
    #[doc = " Flag, indicating visiting order."]
    pub s_flag: m0_xcode_cursor_flag,
    #[doc = " Datum reserved for cursor users."]
    pub s_datum: u64,
}
#[test]
fn bindgen_test_layout_m0_xcode_cursor_m0_xcode_cursor_frame() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_cursor_m0_xcode_cursor_frame>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_cursor_m0_xcode_cursor_frame>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_xcode_cursor_m0_xcode_cursor_frame>())).s_obj as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame),
            "::",
            stringify!(s_obj)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_xcode_cursor_m0_xcode_cursor_frame>())).s_fieldno as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame),
            "::",
            stringify!(s_fieldno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_xcode_cursor_m0_xcode_cursor_frame>())).s_elno as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame),
            "::",
            stringify!(s_elno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_xcode_cursor_m0_xcode_cursor_frame>())).s_flag as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame),
            "::",
            stringify!(s_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_xcode_cursor_m0_xcode_cursor_frame>())).s_datum as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor_m0_xcode_cursor_frame),
            "::",
            stringify!(s_datum)
        )
    );
}
#[test]
fn bindgen_test_layout_m0_xcode_cursor() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_cursor>(),
        488usize,
        concat!("Size of: ", stringify!(m0_xcode_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_cursor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_cursor>())).xcu_depth as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor),
            "::",
            stringify!(xcu_depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_cursor>())).xcu_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_cursor),
            "::",
            stringify!(xcu_stack)
        )
    );
}
extern "C" {
    pub fn m0_xcode_cursor_init(it: *mut m0_xcode_cursor, obj: *const m0_xcode_obj);
}
extern "C" {
    #[doc = "Iterates over tree of xcode types."]
    #[doc = ""]
    #[doc = "To start the iteration, call this with the cursor where"]
    #[doc = "m0_xcode_cursor_frame::s_obj field of the 0th stack frame is set to the"]
    #[doc = "desired object and the rest of the cursor is zeroed (see"]
    #[doc = "m0_xcode_ctx_init())."]
    #[doc = ""]
    #[doc = "m0_xcode_next() returns a positive value when iteration can be continued, 0"]
    #[doc = "when the iteration is complete and negative error code on error. The intended"]
    #[doc = "usage pattern is"]
    #[doc = ""]
    #[doc = "@code"]
    #[doc = "while ((result = m0_xcode_next(it)) > 0) {"]
    #[doc = "... process next tree node ..."]
    #[doc = "}"]
    #[doc = "@endcode"]
    #[doc = ""]
    #[doc = "On each return, m0_xcode_next() sets the cursor to point to the next element"]
    #[doc = "reached in iteration. The information about the element is stored in the"]
    #[doc = "topmost element of the cursor's stack and can be extracted with"]
    #[doc = "m0_xcode_cursor_top()."]
    #[doc = ""]
    #[doc = "An element with N children is reached 1 + N + 1 times: once in preorder, once"]
    #[doc = "in inorder after each child is processed and once in postorder. Here N equals"]
    #[doc = ""]
    #[doc = "- number of fields in a RECORD object;"]
    #[doc = ""]
    #[doc = "- 1 or 2 in a UNION object: one for discriminator and one for an actually"]
    #[doc = "present field, if any;"]
    #[doc = ""]
    #[doc = "- 1 + (number of elements in array) in a SEQUENCE object. Additional 1 is"]
    #[doc = "for count field;"]
    #[doc = ""]
    #[doc = "- number of elements in array in an ARRAY object;"]
    #[doc = ""]
    #[doc = "- 0 for an ATOMIC object."]
    #[doc = ""]
    #[doc = "For example, to traverse the tree in preorder, one does something like"]
    #[doc = ""]
    #[doc = "@code"]
    #[doc = "while ((result = m0_xcode_next(it)) > 0) {"]
    #[doc = "if (m0_xcode_cursor_top(it)->s_flag == M0_XCODE_CURSOR_PRE) {"]
    #[doc = "... process the element ..."]
    #[doc = "}"]
    #[doc = "}"]
    #[doc = "@endcode"]
    pub fn m0_xcode_next(it: *mut m0_xcode_cursor) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Abandons the iteration at the current level and returns one level up."]
    pub fn m0_xcode_skip(it: *mut m0_xcode_cursor);
}
extern "C" {
    #[doc = " Returns the topmost frame in the cursor's stack."]
    pub fn m0_xcode_cursor_top(
        it: *mut m0_xcode_cursor,
    ) -> *mut m0_xcode_cursor_m0_xcode_cursor_frame;
}
extern "C" {
    #[doc = " Returns the field currently being processed."]
    pub fn m0_xcode_cursor_field(it: *const m0_xcode_cursor) -> *const m0_xcode_field;
}
#[doc = " Little-endian."]
pub const m0_xcode_endianness_M0_XEND_LE: m0_xcode_endianness = 0;
#[doc = " Big-endian."]
pub const m0_xcode_endianness_M0_XEND_BE: m0_xcode_endianness = 1;
#[doc = " Big-endian."]
pub const m0_xcode_endianness_M0_XEND_NR: m0_xcode_endianness = 2;
#[doc = " Endianness (http://en.wikipedia.org/wiki/Endianness)"]
pub type m0_xcode_endianness = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Human-readable names of values in m0_xcode_endianness"]
    pub static mut m0_xcode_endianness_name: [*const ::std::os::raw::c_char; 2usize];
}
#[doc = " xcoding context."]
#[doc = ""]
#[doc = "The context contains information about attributes of xcoding operation and"]
#[doc = "its progress."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_xcode_ctx {
    #[doc = " Endianness of serialized representation."]
    pub xcx_end: m0_xcode_endianness,
    #[doc = "Current point in the buffer vector."]
    #[doc = ""]
    #[doc = "The cursor points to the where encoding will write the next byte and"]
    #[doc = "from where decoding will read the next byte."]
    #[doc = ""]
    #[doc = "It should be initialised with m0_bufvec_cursor_init() prior to"]
    #[doc = "m0_xcode_encode() or m0_xcode_decode() call. The size of the cursors"]
    #[doc = "buffer should be not less than the size of serialised structure"]
    #[doc = "representation."]
    pub xcx_buf: m0_bufvec_cursor,
    #[doc = "State of the iteration through object tree."]
    pub xcx_it: m0_xcode_cursor,
    #[doc = "Allocation function used by decoding to allocate the topmost object"]
    #[doc = "and all its non-inline sub-objects (arrays and opaque sub-objects)."]
    pub xcx_alloc: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut m0_xcode_cursor,
            arg2: size_t,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub xcx_free: ::std::option::Option<unsafe extern "C" fn(ctx: *mut m0_xcode_cursor)>,
    #[doc = "This function is called every time type is traversed with"]
    #[doc = "m0_xcode_next()."]
    pub xcx_iter: ::std::option::Option<
        unsafe extern "C" fn(it: *const m0_xcode_cursor) -> ::std::os::raw::c_int,
    >,
    #[doc = "This function is called when xcode.c:ctx_walk() function called from"]
    #[doc = "m0_xcode_encode(), m0_xcode_decode(), m0_xcode_length() ends"]
    #[doc = "processing of given xcode context and xcode object embeded into it."]
    pub xcx_iter_end: ::std::option::Option<unsafe extern "C" fn(it: *const m0_xcode_cursor)>,
}
#[test]
fn bindgen_test_layout_m0_xcode_ctx() {
    assert_eq!(
        ::std::mem::size_of::<m0_xcode_ctx>(),
        552usize,
        concat!("Size of: ", stringify!(m0_xcode_ctx))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_xcode_ctx>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_xcode_ctx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_end as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_buf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_it as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_it)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_alloc as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_alloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_free as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_free)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_iter as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_iter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_xcode_ctx>())).xcx_iter_end as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_xcode_ctx),
            "::",
            stringify!(xcx_iter_end)
        )
    );
}
extern "C" {
    #[doc = "Sets up the context to start xcoding of a given object."]
    pub fn m0_xcode_ctx_init(ctx: *mut m0_xcode_ctx, obj: *const m0_xcode_obj);
}
extern "C" {
    #[doc = "@see m0_xcode_ctx::xcx_buf"]
    pub fn m0_xcode_decode(ctx: *mut m0_xcode_ctx) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "@see m0_xcode_ctx::xcx_buf"]
    pub fn m0_xcode_encode(ctx: *mut m0_xcode_ctx) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Calculates the length of serialized representation."]
    pub fn m0_xcode_length(ctx: *mut m0_xcode_ctx) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Iterates (recurses) over fields of the given type and their types."]
    #[doc = ""]
    #[doc = " \"t\" is invoked for each type embedded in \"xt\" (including \"xt\" itself)."]
    #[doc = ""]
    #[doc = " \"f\" is invoked for each field embedded in \"xt\"."]
    pub fn m0_xcode_type_iterate(
        xt: *mut m0_xcode_type,
        t: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut m0_xcode_type, arg2: *mut ::std::os::raw::c_void),
        >,
        f: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut m0_xcode_type,
                arg2: *mut m0_xcode_field,
                arg3: *mut ::std::os::raw::c_void,
            ),
        >,
        datum: *mut ::std::os::raw::c_void,
    );
}
pub const m0_xcode_what_M0_XCODE_ENCODE: m0_xcode_what = 0;
pub const m0_xcode_what_M0_XCODE_DECODE: m0_xcode_what = 1;
pub type m0_xcode_what = ::std::os::raw::c_uint;
extern "C" {
    #[doc = "Initializes xcode context and encodes or decodes the xcode"]
    #[doc = "object in the cursor based on @what value."]
    pub fn m0_xcode_encdec(
        obj: *mut m0_xcode_obj,
        cur: *mut m0_bufvec_cursor,
        what: m0_xcode_what,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Allocates buffer and places there encoded object."]
    pub fn m0_xcode_obj_enc_to_buf(
        obj: *mut m0_xcode_obj,
        buf: *mut *mut ::std::os::raw::c_void,
        len: *mut m0_bcount_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Takes buffer with encoded object and builds original object."]
    pub fn m0_xcode_obj_dec_from_buf(
        obj: *mut m0_xcode_obj,
        buf: *mut ::std::os::raw::c_void,
        len: m0_bcount_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initializes xcode context and returns the length of xcode object."]
    pub fn m0_xcode_data_size(
        ctx: *mut m0_xcode_ctx,
        obj: *const m0_xcode_obj,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_xcode_alloc(it: *mut m0_xcode_cursor, nob: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "True iff \"xt\" is an array of bytes."]
    pub fn m0_xcode_is_byte_array(xt: *const m0_xcode_type) -> bool;
}
extern "C" {
    #[doc = "Handles memory allocation during decoding."]
    #[doc = ""]
    #[doc = "This function takes an xcode iteration cursor and, if necessary, allocates"]
    #[doc = "memory where the object currently being decoded will reside."]
    #[doc = ""]
    #[doc = "The pointer to the allocated memory is returned in m0_xcode_obj::xo_ptr. In"]
    #[doc = "addition, this pointer is stored at the appropriate offset in the parent"]
    #[doc = "object."]
    pub fn m0_xcode_alloc_obj(
        it: *mut m0_xcode_cursor,
        alloc: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut m0_xcode_cursor,
                arg2: size_t,
            ) -> *mut ::std::os::raw::c_void,
        >,
    ) -> ssize_t;
}
extern "C" {
    #[doc = " Reads an object from a human-readable string representation."]
    #[doc = ""]
    #[doc = " String has the following EBNF grammar:"]
    #[doc = ""]
    #[doc = "     S           ::= RECORD | UNION | SEQUENCE | ARRAY | ATOM | CUSTOM"]
    #[doc = "     RECORD      ::= '(' [S-LIST] ')'"]
    #[doc = "     S-LIST      ::= S | S-LIST ',' S"]
    #[doc = "     UNION       ::= '{' TAG '|' [S] '}'"]
    #[doc = "     SEQUENCE    ::= STRING | COUNTED"]
    #[doc = "     ARRAY       ::= '<' [S-LIST] '>'"]
    #[doc = "     STRING      ::= '\"' CHAR* '\"'"]
    #[doc = "     COUNTED     ::= '[' COUNT ':' [S-LIST] ']'"]
    #[doc = "     ATOM        ::= EMPTY | NUMBER"]
    #[doc = "     TAG         ::= ATOM"]
    #[doc = "     COUNT       ::= ATOM"]
    #[doc = "     CUSTOM      ::= '^' CHAR* | '@' CHAR*"]
    #[doc = ""]
    #[doc = " Where CHAR is any non-NUL character, NUMBER is anything recognizable by"]
    #[doc = " sscanf(3) as a number and EMPTY is the empty string. Blank-spaces (\\n, \\t,"]
    #[doc = " \\v, \\r, space and comments) between tokens are ignored. Comments start with a"]
    #[doc = " hash symbol and run to the end of line."]
    #[doc = ""]
    #[doc = " Custom type representations start with a caret (^) and are recognised by"]
    #[doc = " m0_xcode_type_ops::xto_read() call-backs."]
    #[doc = ""]
    #[doc = " Custom field representations start with with '@' and are recognised by a"]
    #[doc = " call-back stored in m0_xcode_field::xf_read()"]
    #[doc = ""]
    #[doc = " Examples:"]
    #[doc = " @verbatim"]
    #[doc = " (0, 1)"]
    #[doc = " (0, (1, 2))"]
    #[doc = " ()"]
    #[doc = " {1| (1, 2)}"]
    #[doc = " {2| 6}"]
    #[doc = " {3|}               # a union with invalid discriminant or with a void value"]
    #[doc = " [0]                # 0 sized array"]
    #[doc = " [3: 6, 5, 4]"]
    #[doc = " [: 1, 2, 3]        # fixed size sequence"]
    #[doc = " <7, 12, 0>         # fixed size array"]
    #[doc = " \"incomprehensible\" # a byte (U8) sequence with 16 elements"]
    #[doc = " 10                 # number 10"]
    #[doc = " 0xa                # number 10"]
    #[doc = " 012                # number 10"]
    #[doc = " (0, \"katavothron\", {42| [3: (\"x\"), (\"y\"), (\"z\")]}, \"paradiorthosis\")"]
    #[doc = " @endverbatim"]
    #[doc = ""]
    #[doc = " Typedefs and opaque types require no special syntax."]
    #[doc = ""]
    #[doc = " @retval 0 success"]
    #[doc = " @retval -EPROTO syntax error"]
    #[doc = " @retval -EINVAL invalid data in string after end of representation"]
    #[doc = " @retval -ve other error (-ENOMEM, &c.)"]
    #[doc = ""]
    #[doc = " Error or not, the caller should free the (partially) constructed object with"]
    #[doc = " m0_xcode_free()."]
    pub fn m0_xcode_read(
        obj: *mut m0_xcode_obj,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Prints an xcode object to a string."]
    #[doc = ""]
    #[doc = " This function is (almost) the inverse of m0_xcode_read()."]
    #[doc = ""]
    #[doc = " @note No attempt at pretty-printing is done. All atomic values are output in"]
    #[doc = " hexadecimal, etc. Its main intended use is logging and debugging. Byte arrays"]
    #[doc = " that contain only printable ASCII values are printed in the \"string literal\""]
    #[doc = " format."]
    pub fn m0_xcode_print(
        obj: *const m0_xcode_obj,
        str_: *mut ::std::os::raw::c_char,
        nr: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_xcode_free_obj(obj: *mut m0_xcode_obj);
}
extern "C" {
    pub fn m0_xcode_free(ctx: *mut m0_xcode_ctx);
}
extern "C" {
    pub fn m0_xcode_cmp(o0: *const m0_xcode_obj, o1: *const m0_xcode_obj) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_xcode_dup(dest: *mut m0_xcode_ctx, src: *mut m0_xcode_ctx) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns true iff the type has all \"on\" and none of \"off\" bits in"]
    #[doc = " m0_xcode_type::xct_flags and the same holds recursively for types of all its"]
    #[doc = " fields."]
    #[doc = " Doesn't check xcode types with aggregation type specified by aggr_umask."]
    pub fn m0_xcode_type_flags(xt: *mut m0_xcode_type, on: u32, off: u32, aggr_umask: u64) -> bool;
}
extern "C" {
    #[doc = "Returns the address of a sub-object within an object."]
    #[doc = ""]
    #[doc = "@param obj     - typed object"]
    #[doc = "@param fieldno - ordinal number of field"]
    #[doc = "@param elno    - for a SEQUENCE or ARRAY field, index of the element to"]
    #[doc = "return the address of."]
    #[doc = ""]
    #[doc = "The behaviour of this function for SEQUENCE objects depends on \"elno\""]
    #[doc = "value. SEQUENCE objects have the following structure:"]
    #[doc = ""]
    #[doc = "@code"]
    #[doc = "struct x_seq {"]
    #[doc = "scalar_t  xs_nr;"]
    #[doc = "struct y *xs_body;"]
    #[doc = "};"]
    #[doc = "@endcode"]
    #[doc = ""]
    #[doc = "where xs_nr stores a number of elements in the sequence and xs_body points to"]
    #[doc = "an array of the elements."]
    #[doc = ""]
    #[doc = "With fieldno == 1, m0_xcode_addr() returns"]
    #[doc = ""]
    #[doc = "- &xseq->xs_body when (elno == ~0ULL) and"]
    #[doc = ""]
    #[doc = "- &xseq->xs_body[elno] otherwise."]
    pub fn m0_xcode_addr(
        obj: *const m0_xcode_obj,
        fieldno: ::std::os::raw::c_int,
        elno: u64,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Returns the value of the given atomic field."]
    pub fn m0_xcode_atom(obj: *const m0_xcode_obj) -> u64;
}
extern "C" {
    #[doc = "Constructs a m0_xcode_obj instance representing a sub-object of a given"]
    #[doc = "object."]
    #[doc = ""]
    #[doc = "Address of sub-object (subobj->xo_ptr) is obtained by calling"]
    #[doc = "m0_xcode_addr()."]
    #[doc = ""]
    #[doc = "Type of sub-object (subobj->xo_type) is usually the type stored in the parent"]
    #[doc = "object's field (m0_xcode_field::xf_type), but for opaque fields it is"]
    #[doc = "obtained by calling m0_xcode_field::xf_opaque()."]
    pub fn m0_xcode_subobj(
        subobj: *mut m0_xcode_obj,
        obj: *const m0_xcode_obj,
        fieldno: ::std::os::raw::c_int,
        elno: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Returns the value of first field in a given object, assuming this field is"]
    #[doc = "atomic."]
    #[doc = ""]
    #[doc = "This function is suitable to return discriminator of a UNION object or"]
    #[doc = "element count of a SEQUENCE object."]
    #[doc = ""]
    #[doc = "@note when the first field has M0_XT_VOID type, the tag"]
    #[doc = "(m0_xcode_field::xf_tag) of this field is returned."]
    pub fn m0_xcode_tag(obj: *const m0_xcode_obj) -> u64;
}
extern "C" {
    #[doc = " Finds and returns (in *place) first (in m0_xcode_next() order) field of type"]
    #[doc = " xt in the given object."]
    #[doc = ""]
    #[doc = " Returns -ENOENT if no field is found."]
    pub fn m0_xcode_find(
        obj: *mut m0_xcode_obj,
        xt: *const m0_xcode_type,
        place: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_xcode_type_invariant(xt: *const m0_xcode_type) -> bool;
}
extern "C" {
    #[doc = " Starts construction of a \"dynamic union\"."]
    #[doc = ""]
    #[doc = " With the help of m0_xcode_union_init(), m0_xcode_union_add() and"]
    #[doc = " m0_xcode_union_close() a discriminated union type (M0_XA_UNION) can be"]
    #[doc = " constructed at run-time. A use case is a situation where branches of the"]
    #[doc = " union are defined in separate modules. With dynamic union, new branches can"]
    #[doc = " be added without modifying central code."]
    #[doc = ""]
    #[doc = " After a call to m0_xcode_union_init(), new branches are added with"]
    #[doc = " m0_xcode_union_add(). When all branches are added, m0_xcode_union_close()"]
    #[doc = " completes the construction of union xcode type. The result can be used as a"]
    #[doc = " usual xcode type."]
    #[doc = ""]
    #[doc = " The implementation is deliberately simplistic to avoid issues with sizeof and"]
    #[doc = " alignment calculations. Union discriminator is always M0_XT_U64."]
    #[doc = ""]
    #[doc = " @param un - xcode type to be initialised. The user has to allocate this"]
    #[doc = "             together with at least @maxbranches m0_xcode_field instances. See"]
    #[doc = "             conf/db.c:conx_obj for example."]
    #[doc = ""]
    #[doc = " @praam name - xcode type name, assigned to un->xct_name"]
    #[doc = " @param discriminator - the name of the first field"]
    #[doc = " @param maxbranch - maximal number of branches that can be added"]
    #[doc = ""]
    #[doc = " @see m0_xcode_union_add(), m0_xcode_union_close()"]
    pub fn m0_xcode_union_init(
        un: *mut m0_xcode_type,
        name: *const ::std::os::raw::c_char,
        discriminator: *const ::std::os::raw::c_char,
        maxbranches: size_t,
    );
}
extern "C" {
    #[doc = " Finalises a \"dynamic union\"."]
    #[doc = ""]
    #[doc = " @see m0_xcode_union_init(), m0_xcode_union_close()"]
    pub fn m0_xcode_union_fini(un: *mut m0_xcode_type);
}
extern "C" {
    #[doc = " Adds another branch to the dynamic union."]
    #[doc = ""]
    #[doc = " @see m0_xcode_union_init(), m0_xcode_union_close()"]
    pub fn m0_xcode_union_add(
        un: *mut m0_xcode_type,
        name: *const ::std::os::raw::c_char,
        xt: *const m0_xcode_type,
        tag: u64,
    );
}
extern "C" {
    #[doc = " Completes construction of dynamic union, calculates sizeof."]
    #[doc = ""]
    #[doc = " @see m0_xcode_union_init(), m0_xcode_union_add()"]
    pub fn m0_xcode_union_close(un: *mut m0_xcode_type);
}
extern "C" {
    pub static M0_XT_VOID: m0_xcode_type;
}
extern "C" {
    pub static M0_XT_U8: m0_xcode_type;
}
extern "C" {
    pub static M0_XT_U32: m0_xcode_type;
}
extern "C" {
    pub static M0_XT_U64: m0_xcode_type;
}
extern "C" {
    pub static M0_XT_OPAQUE: m0_xcode_type;
}
#[doc = "Void type used by ff2c in places where C syntax requires a type name."]
pub type m0_void_t = [::std::os::raw::c_char; 0usize];
extern "C" {
    #[doc = "Returns a previously unused \"decoration number\", which can be used as an"]
    #[doc = "index in m0_xcode_field::xf_decor[] and m0_xcode_type::xct_decor[] arrays."]
    #[doc = ""]
    #[doc = "This number can be used to associate additional state with xcode"]
    #[doc = "introspection elements:"]
    #[doc = ""]
    #[doc = "@code"]
    #[doc = "foo_decor_num = m0_xcode_decor_register();"]
    #[doc = ""]
    #[doc = "..."]
    #[doc = ""]
    #[doc = "struct m0_xcode_type  *xt;"]
    #[doc = "struct m0_xcode_field *f;"]
    #[doc = ""]
    #[doc = "xt->xct_decor[foo_decor_num] = m0_alloc(sizeof(struct foo_type_decor));"]
    #[doc = "f->xf_decor[foo_decor_num] = m0_alloc(sizeof(struct foo_field_decor));"]
    #[doc = "@endcode"]
    pub fn m0_xcode_decor_register() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Partially initializes a branded object type from a xcode type descriptor."]
    #[doc = ""]
    #[doc = " @see bob.h"]
    pub fn m0_xcode_bob_type_init(
        bt: *mut m0_bob_type,
        xt: *const m0_xcode_type,
        magix_field: size_t,
        magix: u64,
    );
}
extern "C" {
    pub fn m0_xcode_ctx_top(ctx: *const m0_xcode_ctx) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn m0_xc_u8_init();
}
extern "C" {
    pub fn m0_xc_u16_init();
}
extern "C" {
    pub fn m0_xc_u32_init();
}
extern "C" {
    pub fn m0_xc_u64_init();
}
extern "C" {
    pub fn m0_xc_void_init();
}
extern "C" {
    pub fn m0_xc_opaque_init();
}
extern "C" {
    pub static mut m0_list_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_list_link_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_list_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_list_link_struct_init();
}
extern "C" {
    pub fn m0_xc_lib_list_init();
}
extern "C" {
    pub fn m0_xc_lib_list_fini();
}
#[doc = "@defgroup tlist Typed lists."]
#[doc = ""]
#[doc = "Typed list module provides a double-linked list implementation that"]
#[doc = "eliminates some chores and sources of errors typical for the \"raw\" m0_list"]
#[doc = "interface."]
#[doc = ""]
#[doc = "Typed list is implemented on top of m0_list and adds the following features:"]
#[doc = ""]
#[doc = "- a \"list descriptor\" (m0_tl_descr) object holding information about this"]
#[doc = "list type, including its human readable name;"]
#[doc = ""]
#[doc = "- \"magic\" numbers embedded in list header and list links and checked by"]
#[doc = "the code to catch corruptions;"]
#[doc = ""]
#[doc = "- automatic conversion to and from list links and ambient objects they"]
#[doc = "are embedded to, obviating the need in container_of() and"]
#[doc = "m0_list_entry() calls. In fact, links (m0_tlink) are not mentioned in"]
#[doc = "tlist interface at all;"]
#[doc = ""]
#[doc = "- gdb (7.0) pretty-printer for lists (not yet implemented)."]
#[doc = ""]
#[doc = "tlist is a safe and more convenient alternative to m0_list. As a general"]
#[doc = "rule, m0_list should be used only when performance is critical or some"]
#[doc = "flexibility beyond what tlist provides (e.g., a cyclic list without a head"]
#[doc = "object) is necessary."]
#[doc = ""]
#[doc = "Similarly to m0_list, tlist is a purely algorithmic module: it deals with"]
#[doc = "neither concurrency nor liveness nor with any similar issues that its callers"]
#[doc = "are supposed to handle."]
#[doc = ""]
#[doc = "To describe a typical tlist usage pattern, suppose that one wants a list of"]
#[doc = "objects of type foo hanging off every object of type bar."]
#[doc = ""]
#[doc = "First, two things have to be done:"]
#[doc = ""]
#[doc = "- \"list link\" has to be embedded in foo:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct foo {"]
#[doc = "..."]
#[doc = "struct m0_tlink f_linkage;"]
#[doc = "..."]
#[doc = "};"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "- then, a \"list head\" has to be embedded in bar:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct bar {"]
#[doc = "..."]
#[doc = "struct m0_tl b_list;"]
#[doc = "..."]
#[doc = "};"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "- now, define a tlist type:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "static const struct m0_tl_descr foobar_list = {"]
#[doc = ".td_name        = \"foo-s of bar\","]
#[doc = ".td_link_offset = offsetof(struct foo, f_linkage),"]
#[doc = ".td_head_magic  = 0x666f6f6261726865 // \"foobarhe\""]
#[doc = "};"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "This defines the simplest form of tlist without magic checking in list links"]
#[doc = "(the magic embedded in a list head is checked anyway). To add magic checking,"]
#[doc = "place a magic field in foo:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct foo {"]
#[doc = "..."]
#[doc = "uint64_t f_magic;"]
#[doc = "..."]
#[doc = "};"]
#[doc = ""]
#[doc = "static const struct m0_tl_descr foobar_list = {"]
#[doc = "..."]
#[doc = ".td_link_magic_offset = offsetof(struct foo, f_magic),"]
#[doc = ".td_link_magic        = 0x666f6f6261726c69 // \"foobarli\""]
#[doc = "};"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "Magic field can be shared by multiple tlist links embedded in the same object"]
#[doc = "and can be used for other sanity checking. An \"outermost\" finaliser function"]
#[doc = "must clear the magic as its last step to catch use-after-fini errors."]
#[doc = ""]
#[doc = "Now, one can populate and manipulate foo-bar lists:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct bar  B;"]
#[doc = "struct foo  F;"]
#[doc = "struct foo *scan;"]
#[doc = ""]
#[doc = "m0_tlist_init(&B.b_list);"]
#[doc = "m0_tlink_init(&F.f_linkage);"]
#[doc = ""]
#[doc = "m0_tlist_add(&foobar_list, &B.b_list, &F);"]
#[doc = "M0_ASSERT(m0_tl_contains(&foobar_list, &B.b_list, &F));"]
#[doc = ""]
#[doc = "m0_tlist_for(&foobar_list, &B.b_list, scan)"]
#[doc = "M0_ASSERT(scan == &F);"]
#[doc = "m0_tlist_endfor;"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "@note Differently from m0_list, tlist heads and links must be initialised"]
#[doc = "before use, even when first usage overwrites the entity completely. This"]
#[doc = "allows stronger checking in tlist manipulation functions."]
#[doc = ""]
#[doc = "<b>Type-safe macros.</b>"]
#[doc = ""]
#[doc = "M0_TL_DESCR_DECLARE(), M0_TL_DECLARE(), M0_TL_DESCR_DEFINE() and"]
#[doc = "M0_TL_DEFINE() macros generate versions of tlist interface tailored for a"]
#[doc = "particular use case."]
#[doc = ""]
#[doc = "4 separate macros are necessary for flexibility. They should be used in"]
#[doc = "exactly one of the following ways for any given typed list:"]
#[doc = ""]
#[doc = "- static tlist, used in a single module only: M0_TL_DEFINE() and"]
#[doc = "M0_TL_DESCR_DEFINE() with scope \"static\" in the module .c file;"]
#[doc = ""]
#[doc = "- tlist exported from a module: M0_TL_DEFINE() and M0_TL_DESCR_DEFINE()"]
#[doc = "with scope \"\" in .c file and M0_TL_DESCR_DECLARE(), M0_TL_DECLARE()"]
#[doc = "with scope \"extern\" in .h file;"]
#[doc = ""]
#[doc = "- tlist exported from a module as a collection of inline functions:"]
#[doc = "M0_TL_DESCR_DEFINE() in .c file and M0_TL_DESCR_DECLARE() with scope"]
#[doc = "\"extern\" followed by M0_TL_DEFINE() with scope \"static inline\" in .h"]
#[doc = "file."]
#[doc = ""]
#[doc = "Use m0_tl_for() and m0_tl_endfor() to iterate over lists generated by"]
#[doc = "M0_TL_DECLARE() and M0_TL_DEFINE()."]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_tl_descr {
    #[doc = " Human-readable list name, used for error messages."]
    pub td_name: *const ::std::os::raw::c_char,
    #[doc = " Offset of list link (m0_tlink) in the ambient object."]
    pub td_link_offset: ::std::os::raw::c_int,
    #[doc = "Offset of magic field in the ambient object."]
    #[doc = "This is used only when link magic checking is on."]
    #[doc = ""]
    #[doc = "@see m0_tl_descr::td_link_magic"]
    pub td_link_magic_offset: ::std::os::raw::c_int,
    #[doc = "Magic stored in an ambient object."]
    #[doc = ""]
    #[doc = "If this field is 0, link magic checking is disabled."]
    pub td_link_magic: u64,
    #[doc = "Magic stored in m0_tl::t_magic and checked on all tlist"]
    #[doc = "operations."]
    pub td_head_magic: u64,
    #[doc = " Size of the ambient object."]
    pub td_container_size: size_t,
}
#[test]
fn bindgen_test_layout_m0_tl_descr() {
    assert_eq!(
        ::std::mem::size_of::<m0_tl_descr>(),
        40usize,
        concat!("Size of: ", stringify!(m0_tl_descr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_tl_descr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_tl_descr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl_descr>())).td_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl_descr),
            "::",
            stringify!(td_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl_descr>())).td_link_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl_descr),
            "::",
            stringify!(td_link_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_tl_descr>())).td_link_magic_offset as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl_descr),
            "::",
            stringify!(td_link_magic_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl_descr>())).td_link_magic as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl_descr),
            "::",
            stringify!(td_link_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl_descr>())).td_head_magic as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl_descr),
            "::",
            stringify!(td_head_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl_descr>())).td_container_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl_descr),
            "::",
            stringify!(td_container_size)
        )
    );
}
#[doc = "tlist head."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_tl {
    #[doc = "Head magic. This is set to m0_tl::td_head_magic and verified by the"]
    #[doc = "list invariant."]
    pub t_magic: u64,
    #[doc = " Underlying m0_list."]
    pub t_head: m0_list,
}
#[test]
fn bindgen_test_layout_m0_tl() {
    assert_eq!(
        ::std::mem::size_of::<m0_tl>(),
        24usize,
        concat!("Size of: ", stringify!(m0_tl))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_tl>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_tl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl>())).t_magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl),
            "::",
            stringify!(t_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tl>())).t_head as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tl),
            "::",
            stringify!(t_head)
        )
    );
}
#[doc = "tlist link."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_tlink {
    #[doc = " Underlying m0_list link."]
    pub t_link: m0_list_link,
}
#[test]
fn bindgen_test_layout_m0_tlink() {
    assert_eq!(
        ::std::mem::size_of::<m0_tlink>(),
        16usize,
        concat!("Size of: ", stringify!(m0_tlink))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_tlink>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_tlink))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_tlink>())).t_link as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_tlink),
            "::",
            stringify!(t_link)
        )
    );
}
extern "C" {
    pub fn m0_tlist_init(d: *const m0_tl_descr, list: *mut m0_tl);
}
extern "C" {
    pub fn m0_tlist_fini(d: *const m0_tl_descr, list: *mut m0_tl);
}
extern "C" {
    pub fn m0_tlink_init(d: *const m0_tl_descr, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn m0_tlink_fini(d: *const m0_tl_descr, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn m0_tlink_init_at(
        d: *const m0_tl_descr,
        obj: *mut ::std::os::raw::c_void,
        list: *mut m0_tl,
    );
}
extern "C" {
    pub fn m0_tlink_init_at_tail(
        d: *const m0_tl_descr,
        obj: *mut ::std::os::raw::c_void,
        list: *mut m0_tl,
    );
}
extern "C" {
    pub fn m0_tlink_del_fini(d: *const m0_tl_descr, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn m0_tlist_invariant(d: *const m0_tl_descr, list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_tlist_invariant_ext(
        d: *const m0_tl_descr,
        list: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        datum: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn m0_tlink_invariant(d: *const m0_tl_descr, obj: *const ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn m0_tlist_is_empty(d: *const m0_tl_descr, list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_tlink_is_in(d: *const m0_tl_descr, obj: *const ::std::os::raw::c_void) -> bool;
}
extern "C" {
    pub fn m0_tlist_contains(
        d: *const m0_tl_descr,
        list: *const m0_tl,
        obj: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn m0_tlist_length(d: *const m0_tl_descr, list: *const m0_tl) -> size_t;
}
extern "C" {
    #[doc = "Adds an element to the beginning of a list."]
    #[doc = ""]
    #[doc = "@pre !m0_tlink_is_in(d, obj)"]
    #[doc = "@post m0_tlink_is_in(d, obj)"]
    pub fn m0_tlist_add(d: *const m0_tl_descr, list: *mut m0_tl, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = "Adds an element to the end of a list."]
    #[doc = ""]
    #[doc = "@pre !m0_tlink_is_in(d, obj)"]
    #[doc = "@post m0_tlink_is_in(d, obj)"]
    pub fn m0_tlist_add_tail(
        d: *const m0_tl_descr,
        list: *mut m0_tl,
        obj: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = "Adds an element after another element of the list."]
    #[doc = ""]
    #[doc = "@pre !m0_tlink_is_in(d, next)"]
    #[doc = "@post m0_tlink_is_in(d, next)"]
    pub fn m0_tlist_add_after(
        d: *const m0_tl_descr,
        obj: *mut ::std::os::raw::c_void,
        next: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = "Adds an element before another element of the list."]
    #[doc = ""]
    #[doc = "@pre !m0_tlink_is_in(d, next)"]
    #[doc = "@post m0_tlink_is_in(d, next)"]
    pub fn m0_tlist_add_before(
        d: *const m0_tl_descr,
        obj: *mut ::std::os::raw::c_void,
        next: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = "Deletes an element from the list."]
    #[doc = ""]
    #[doc = "@pre   m0_tlink_is_in(d, obj)"]
    #[doc = "@post !m0_tlink_is_in(d, obj)"]
    pub fn m0_tlist_del(d: *const m0_tl_descr, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = "Deletes at element from the list, if it was there."]
    #[doc = ""]
    #[doc = "@post !m0_tlink_is_in(d, obj)"]
    pub fn m0_tlist_remove(d: *const m0_tl_descr, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = "Moves an element from a list to the head of (possibly the same) list."]
    #[doc = ""]
    #[doc = "@pre  m0_tlink_is_in(d, obj)"]
    #[doc = "@post m0_tlink_is_in(d, obj)"]
    pub fn m0_tlist_move(d: *const m0_tl_descr, list: *mut m0_tl, obj: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = "Moves an element from a list to the tail of (possibly the same) list."]
    #[doc = ""]
    #[doc = "@pre  m0_tlink_is_in(d, obj)"]
    #[doc = "@post m0_tlink_is_in(d, obj)"]
    pub fn m0_tlist_move_tail(
        d: *const m0_tl_descr,
        list: *mut m0_tl,
        obj: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = "Returns the first element of a list or NULL if the list is empty."]
    pub fn m0_tlist_head(d: *const m0_tl_descr, list: *const m0_tl) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "Removes and returns the head the list or NULL."]
    pub fn m0_tlist_pop(d: *const m0_tl_descr, list: *const m0_tl) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "Returns the last element of a list or NULL if the list is empty."]
    pub fn m0_tlist_tail(d: *const m0_tl_descr, list: *const m0_tl) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "Returns the next element of a list or NULL if @obj is the last element."]
    #[doc = ""]
    #[doc = "@pre m0_tlist_contains(d, list, obj)"]
    pub fn m0_tlist_next(
        d: *const m0_tl_descr,
        list: *const m0_tl,
        obj: *const ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "Returns the previous element of a list or NULL if @obj is the first element."]
    #[doc = ""]
    #[doc = "@pre m0_tlist_contains(d, list, obj)"]
    pub fn m0_tlist_prev(
        d: *const m0_tl_descr,
        list: *const m0_tl,
        obj: *const ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_mach {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Adds a label to the current context."]
    #[doc = ""]
    #[doc = " @param id    - label identifier"]
    #[doc = " @param n     - number of 64-bit values in label payload"]
    #[doc = " @param value - payload"]
    #[doc = ""]
    #[doc = " Possible uses:"]
    #[doc = ""]
    #[doc = " @code"]
    #[doc = " m0_addb2_add(FOP_FID, 2, fid);"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @pre (id & 0xff00000000000000ull) == 0"]
    pub fn m0_addb2_push(id: u64, n: ::std::os::raw::c_int, value: *const u64);
}
extern "C" {
    #[doc = " Removes the top-most label in the current context stack."]
    #[doc = ""]
    #[doc = " @param id - label identifier"]
    #[doc = ""]
    #[doc = " @pre \"id\" must the identifier of the top-most label."]
    #[doc = " @pre (id & 0xff00000000000000ull) == 0"]
    pub fn m0_addb2_pop(id: u64);
}
extern "C" {
    #[doc = " Adds one-time measurement in the current context."]
    #[doc = ""]
    #[doc = " @param id    - measurement identifier"]
    #[doc = " @param n     - number of 64-bit values in measurement payload"]
    #[doc = " @param value - payload"]
    #[doc = ""]
    #[doc = " @pre (id & 0xff00000000000000ull) == 0"]
    pub fn m0_addb2_add(id: u64, n: ::std::os::raw::c_int, value: *const u64);
}
#[doc = " Sensor operations invoked by IMPLEMENTATION."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_sensor_ops {
    #[doc = " IMPLEMENTATION calls this periodically to read sensor measurements."]
    #[doc = ""]
    #[doc = " \"area\" points to a buffer, where ->so_snapshot() should write out its"]
    #[doc = " payload, no more than m0_addb2_sensor::s_nr elements."]
    pub so_snapshot:
        ::std::option::Option<unsafe extern "C" fn(s: *mut m0_addb2_sensor, area: *mut u64)>,
    #[doc = " Invoked by IMPLEMENTATION when the sensor goes out of context, i.e.,"]
    #[doc = " when the label, which was top-most when the sensor was added, is"]
    #[doc = " popped."]
    pub so_fini: ::std::option::Option<unsafe extern "C" fn(s: *mut m0_addb2_sensor)>,
}
#[test]
fn bindgen_test_layout_m0_addb2_sensor_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_sensor_ops>(),
        16usize,
        concat!("Size of: ", stringify!(m0_addb2_sensor_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_sensor_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_sensor_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor_ops>())).so_snapshot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor_ops),
            "::",
            stringify!(so_snapshot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor_ops>())).so_fini as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor_ops),
            "::",
            stringify!(so_fini)
        )
    );
}
#[doc = " A sensor is \"always ready\" measurement that IMPLEMENTATION periodically reads"]
#[doc = " out to produce records for CONSUMERS."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_sensor {
    pub s_ops: *const m0_addb2_sensor_ops,
    #[doc = " Linkage in a list of all sensors associated with a given label."]
    pub s_linkage: m0_tlink,
    #[doc = " Sensor identifier."]
    pub s_id: u64,
    #[doc = " Number of 64-bit elements in sensor payload."]
    pub s_nr: ::std::os::raw::c_uint,
    pub s_magix: u64,
}
#[test]
fn bindgen_test_layout_m0_addb2_sensor() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_sensor>(),
        48usize,
        concat!("Size of: ", stringify!(m0_addb2_sensor))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_sensor>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_sensor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor>())).s_ops as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor),
            "::",
            stringify!(s_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor>())).s_linkage as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor),
            "::",
            stringify!(s_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor>())).s_id as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor),
            "::",
            stringify!(s_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor>())).s_nr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor),
            "::",
            stringify!(s_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_sensor>())).s_magix as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_sensor),
            "::",
            stringify!(s_magix)
        )
    );
}
extern "C" {
    #[doc = " Adds a sensor to the current context. This sensor will be periodically"]
    #[doc = " queried (at the IMPLEMENTATION discretion) until it goes out of context."]
    #[doc = ""]
    #[doc = " \"idx\" is used to specify to which label in the context to add the sensor. -1"]
    #[doc = " means the topmost label, otherwise it is the level of label in the context"]
    #[doc = " (starting from 0)."]
    #[doc = ""]
    #[doc = " @pre context stack must be non-empty."]
    pub fn m0_addb2_sensor_add(
        s: *mut m0_addb2_sensor,
        id: u64,
        nr: ::std::os::raw::c_uint,
        idx: ::std::os::raw::c_int,
        ops: *const m0_addb2_sensor_ops,
    );
}
extern "C" {
    #[doc = " Deletes a sensor."]
    pub fn m0_addb2_sensor_del(s: *mut m0_addb2_sensor);
}
extern "C" {
    #[doc = " Forces current addb2 machine to send its collection of records for"]
    #[doc = " processing (to storage or network), iff it was last sent packing more than"]
    #[doc = " given delay ago."]
    pub fn m0_addb2_force(delay: m0_time_t);
}
extern "C" {
    pub fn m0_addb2_force_all();
}
#[doc = " Machine operations vector provided by SYSTEM."]
#[doc = ""]
#[doc = " @see fop/fom.c:addb2_ops."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_mach_ops {
    #[doc = " Invoked by IMPLEMENTATION to send a collection of records to network"]
    #[doc = " or storage (at SYSTEM discretion)."]
    #[doc = ""]
    #[doc = " @retval +ve - the trace was accepted for"]
    #[doc = " processing. m0_addb2_trace_done() must be called against this trace"]
    #[doc = " eventually."]
    #[doc = ""]
    #[doc = " @retval 0 - the trace was \"processed instantly\", IMPLEMENTATION is"]
    #[doc = " free to re-use trace after return. Submission errors are included in"]
    #[doc = " this case."]
    #[doc = ""]
    #[doc = " see fop/fom.c:loc_addb2_submit()."]
    pub apo_submit: ::std::option::Option<
        unsafe extern "C" fn(
            mach: *mut m0_addb2_mach,
            tobj: *mut m0_addb2_trace_obj,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = " Invoked by IMPLEMENTATION to notify SYSTEM that stopped machine"]
    #[doc = " completed its operation and can be finalised."]
    pub apo_idle: ::std::option::Option<unsafe extern "C" fn(mach: *mut m0_addb2_mach)>,
}
#[test]
fn bindgen_test_layout_m0_addb2_mach_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_mach_ops>(),
        16usize,
        concat!("Size of: ", stringify!(m0_addb2_mach_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_mach_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_mach_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_mach_ops>())).apo_submit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_mach_ops),
            "::",
            stringify!(apo_submit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_mach_ops>())).apo_idle as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_mach_ops),
            "::",
            stringify!(apo_idle)
        )
    );
}
extern "C" {
    #[doc = " Notifies the IMPLEMENTATION that the trace has been processed (i.e., sent"]
    #[doc = " across network or stored on storage)."]
    #[doc = ""]
    #[doc = " This is invoked internally from addb2 network and storage components."]
    pub fn m0_addb2_trace_done(trace: *const m0_addb2_trace);
}
extern "C" {
    #[doc = " Allocates and initialises an addb2 machine."]
    #[doc = ""]
    #[doc = " The machine initially has an empty context stack and is immediately ready to"]
    #[doc = " accept m0_addb2_push() and m0_addb2_add() calls. Whenever new record is added"]
    #[doc = " to the machine it is immediately delivered to online CONSUMERS."]
    #[doc = ""]
    #[doc = " The machine accumulates context state and records internally. When amount of"]
    #[doc = " accumulated data reaches some threshold, the machine invokes"]
    #[doc = " m0_addb2_mach_ops::apo_submit() to submit record data to network or storage"]
    #[doc = " (as defined by SYSTEM)."]
    #[doc = ""]
    #[doc = " @param cookie - an opaque pointer, returned by m0_addb2_mach_cookie()."]
    pub fn m0_addb2_mach_init(
        ops: *const m0_addb2_mach_ops,
        cookie: *mut ::std::os::raw::c_void,
    ) -> *mut m0_addb2_mach;
}
extern "C" {
    #[doc = " Finalises a machine."]
    #[doc = ""]
    #[doc = " @pre The machine must be idle."]
    pub fn m0_addb2_mach_fini(mach: *mut m0_addb2_mach);
}
extern "C" {
    #[doc = " Notifies IMPLEMENTATION that SYSTEM wants to shut the machine down."]
    #[doc = ""]
    #[doc = " Once stopped, the machine stops accepting new records and context changes"]
    #[doc = " (appropriate functions become no-ops) and submits all pending record data."]
    #[doc = ""]
    #[doc = " When all pending record data have been processed, the machine becomes idle"]
    #[doc = " and m0_addb2_mach_ops::apo_idle() is invoked. An idle machine can be"]
    #[doc = " finalised."]
    pub fn m0_addb2_mach_stop(mach: *mut m0_addb2_mach);
}
extern "C" {
    #[doc = " Waits until stopped machine becomes idle."]
    pub fn m0_addb2_mach_wait(mach: *mut m0_addb2_mach);
}
extern "C" {
    #[doc = " Returns cookie passed to m0_addb2_mach_init()."]
    #[doc = ""]
    #[doc = " This can be used to associate a machine with some ambient SYSTEM object."]
    pub fn m0_addb2_mach_cookie(mach: *const m0_addb2_mach) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn m0_addb2_module_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_addb2_module_fini();
}
#[doc = " A trace is a representation of a sequence of addb2 records produced in the"]
#[doc = " same machine."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_trace {
    pub tr_nr: u64,
    pub tr_body: *mut u64,
}
#[test]
fn bindgen_test_layout_m0_addb2_trace() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_trace>(),
        16usize,
        concat!("Size of: ", stringify!(m0_addb2_trace))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_trace>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_trace))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace>())).tr_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace),
            "::",
            stringify!(tr_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace>())).tr_body as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace),
            "::",
            stringify!(tr_body)
        )
    );
}
#[doc = " A wrapper object used to pass traces to network and storage components."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_trace_obj {
    #[doc = " Trace itself."]
    pub o_tr: m0_addb2_trace,
    #[doc = " Linkage into networking or storage queues."]
    pub o_linkage: m0_tlink,
    #[doc = " Pointer to the machine in which the trace was generated."]
    pub o_mach: *mut m0_addb2_mach,
    #[doc = " Completion call-back."]
    #[doc = ""]
    #[doc = " This is called by the processing (storage or network) after the trace"]
    #[doc = " has been processed (see frame_done())."]
    #[doc = ""]
    #[doc = " @note If this is not defined, the standard call-back"]
    #[doc = " m0_addb2_trace_done() is invoked."]
    pub o_done: ::std::option::Option<unsafe extern "C" fn(obj: *mut m0_addb2_trace_obj)>,
    #[doc = " Push this trace through to the consumers as soon as possible,"]
    #[doc = "bypassing caches."]
    pub o_force: bool,
    pub o_magix: u64,
}
#[test]
fn bindgen_test_layout_m0_addb2_trace_obj() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_trace_obj>(),
        64usize,
        concat!("Size of: ", stringify!(m0_addb2_trace_obj))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_trace_obj>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_trace_obj))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace_obj>())).o_tr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace_obj),
            "::",
            stringify!(o_tr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace_obj>())).o_linkage as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace_obj),
            "::",
            stringify!(o_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace_obj>())).o_mach as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace_obj),
            "::",
            stringify!(o_mach)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace_obj>())).o_done as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace_obj),
            "::",
            stringify!(o_done)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace_obj>())).o_force as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace_obj),
            "::",
            stringify!(o_force)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_trace_obj>())).o_magix as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_trace_obj),
            "::",
            stringify!(o_magix)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_counter_data {
    pub cod_nr: u64,
    pub cod_min: i64,
    pub cod_max: i64,
    pub cod_sum: i64,
    pub cod_ssq: u64,
    pub cod_datum: u64,
}
#[test]
fn bindgen_test_layout_m0_addb2_counter_data() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_counter_data>(),
        48usize,
        concat!("Size of: ", stringify!(m0_addb2_counter_data))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_counter_data>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_counter_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter_data>())).cod_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter_data),
            "::",
            stringify!(cod_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter_data>())).cod_min as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter_data),
            "::",
            stringify!(cod_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter_data>())).cod_max as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter_data),
            "::",
            stringify!(cod_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter_data>())).cod_sum as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter_data),
            "::",
            stringify!(cod_sum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter_data>())).cod_ssq as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter_data),
            "::",
            stringify!(cod_ssq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter_data>())).cod_datum as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter_data),
            "::",
            stringify!(cod_datum)
        )
    );
}
pub const M0_ADDB2_COUNTER_VALS: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_counter {
    pub co_sensor: m0_addb2_sensor,
    pub co_val: m0_addb2_counter_data,
}
#[test]
fn bindgen_test_layout_m0_addb2_counter() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_counter>(),
        96usize,
        concat!("Size of: ", stringify!(m0_addb2_counter))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_counter>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_counter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter>())).co_sensor as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter),
            "::",
            stringify!(co_sensor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_counter>())).co_val as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_counter),
            "::",
            stringify!(co_val)
        )
    );
}
extern "C" {
    pub fn m0_addb2_counter_add(
        counter: *mut m0_addb2_counter,
        label: u64,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn m0_addb2_counter_del(counter: *mut m0_addb2_counter);
}
extern "C" {
    pub fn m0_addb2_counter_mod(counter: *mut m0_addb2_counter, val: i64);
}
extern "C" {
    pub fn m0_addb2_counter_mod_with(counter: *mut m0_addb2_counter, val: i64, datum: u64);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_list_counter {
    pub lc_sensor: m0_addb2_sensor,
    pub lc_list: *mut m0_tl,
}
#[test]
fn bindgen_test_layout_m0_addb2_list_counter() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_list_counter>(),
        56usize,
        concat!("Size of: ", stringify!(m0_addb2_list_counter))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_list_counter>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_list_counter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_list_counter>())).lc_sensor as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_list_counter),
            "::",
            stringify!(lc_sensor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_list_counter>())).lc_list as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_list_counter),
            "::",
            stringify!(lc_list)
        )
    );
}
extern "C" {
    pub fn m0_addb2_list_counter_add(
        counter: *mut m0_addb2_list_counter,
        list: *mut m0_tl,
        label: u64,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn m0_addb2_list_counter_del(counter: *mut m0_addb2_list_counter);
}
extern "C" {
    pub fn m0_addb2_clock_add(clock: *mut m0_addb2_sensor, label: u64, idx: ::std::os::raw::c_int);
}
extern "C" {
    pub fn m0_addb2_clock_del(clock: *mut m0_addb2_sensor);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_local_counter {
    pub lc_id: u64,
    pub lc_key: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_m0_addb2_local_counter() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_local_counter>(),
        16usize,
        concat!("Size of: ", stringify!(m0_addb2_local_counter))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_local_counter>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_local_counter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_local_counter>())).lc_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_local_counter),
            "::",
            stringify!(lc_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_local_counter>())).lc_key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_local_counter),
            "::",
            stringify!(lc_key)
        )
    );
}
extern "C" {
    pub fn m0_addb2_local_counter_init(
        lc: *mut m0_addb2_local_counter,
        id: u64,
        counter: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_addb2_local_counter_mod(lc: *mut m0_addb2_local_counter, val: u64, datum: u64);
}
#[doc = " Maximal number of 64-bit values in a payload."]
#[doc = ""]
#[doc = " @note this constant cannot really be increased. Trace buffer format"]
#[doc = " assumes that this is less than 0x10."]
pub const VALUE_MAX_NR: ::std::os::raw::c_uint = 15;
#[doc = " Maximal number of 64-bit values in a payload."]
#[doc = ""]
#[doc = " @note this constant cannot really be increased. Trace buffer format"]
#[doc = " assumes that this is less than 0x10."]
pub const FRAME_TRACE_MAX: ::std::os::raw::c_uint = 128;
#[doc = " Maximal number of 64-bit values in a payload."]
#[doc = ""]
#[doc = " @note this constant cannot really be increased. Trace buffer format"]
#[doc = " assumes that this is less than 0x10."]
pub const FRAME_SIZE_MAX: ::std::os::raw::c_uint = 4194304;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
extern "C" {
    pub fn m0_addb2_trace_size(trace: *const m0_addb2_trace) -> m0_bcount_t;
}
extern "C" {
    pub static mut m0_addb2__dummy_payload: [u64; 0usize];
}
extern "C" {
    pub static mut m0_addb2__dummy_payload_size: u64;
}
extern "C" {
    pub static tr_tl: m0_tl_descr;
}
extern "C" {
    pub fn tr_tlist_init(head: *mut m0_tl);
}
extern "C" {
    pub fn tr_tlist_fini(head: *mut m0_tl);
}
extern "C" {
    pub fn tr_tlink_init(amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_invariant(head: *const m0_tl) -> bool;
}
extern "C" {
    pub fn tr_tlist_invariant_ext(
        head: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const m0_addb2_trace_obj,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        arg1: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn tr_tlist_is_empty(list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn tr_tlink_init_at(amb: *mut m0_addb2_trace_obj, head: *mut m0_tl);
}
extern "C" {
    pub fn tr_tlink_init_at_tail(amb: *mut m0_addb2_trace_obj, head: *mut m0_tl);
}
extern "C" {
    pub fn tr_tlink_fini(amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlink_del_fini(amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlink_is_in(amb: *const m0_addb2_trace_obj) -> bool;
}
extern "C" {
    pub fn tr_tlist_contains(list: *const m0_tl, amb: *const m0_addb2_trace_obj) -> bool;
}
extern "C" {
    pub fn tr_tlist_length(list: *const m0_tl) -> size_t;
}
extern "C" {
    pub fn tr_tlist_add(list: *mut m0_tl, amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_add_tail(list: *mut m0_tl, amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_add_after(amb: *mut m0_addb2_trace_obj, next: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_add_before(amb: *mut m0_addb2_trace_obj, next: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_del(amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_remove(amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_move(list: *mut m0_tl, amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_move_tail(list: *mut m0_tl, amb: *mut m0_addb2_trace_obj);
}
extern "C" {
    pub fn tr_tlist_head(list: *const m0_tl) -> *mut m0_addb2_trace_obj;
}
extern "C" {
    pub fn tr_tlist_pop(list: *const m0_tl) -> *mut m0_addb2_trace_obj;
}
extern "C" {
    pub fn tr_tlist_tail(list: *const m0_tl) -> *mut m0_addb2_trace_obj;
}
extern "C" {
    pub fn tr_tlist_next(
        list: *const m0_tl,
        amb: *const m0_addb2_trace_obj,
    ) -> *mut m0_addb2_trace_obj;
}
extern "C" {
    pub fn tr_tlist_prev(
        list: *const m0_tl,
        amb: *const m0_addb2_trace_obj,
    ) -> *mut m0_addb2_trace_obj;
}
extern "C" {
    pub static mach_tl: m0_tl_descr;
}
extern "C" {
    pub fn mach_tlist_init(head: *mut m0_tl);
}
extern "C" {
    pub fn mach_tlist_fini(head: *mut m0_tl);
}
extern "C" {
    pub fn mach_tlink_init(amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_invariant(head: *const m0_tl) -> bool;
}
extern "C" {
    pub fn mach_tlist_invariant_ext(
        head: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const m0_addb2_mach,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        arg1: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn mach_tlist_is_empty(list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn mach_tlink_init_at(amb: *mut m0_addb2_mach, head: *mut m0_tl);
}
extern "C" {
    pub fn mach_tlink_init_at_tail(amb: *mut m0_addb2_mach, head: *mut m0_tl);
}
extern "C" {
    pub fn mach_tlink_fini(amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlink_del_fini(amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlink_is_in(amb: *const m0_addb2_mach) -> bool;
}
extern "C" {
    pub fn mach_tlist_contains(list: *const m0_tl, amb: *const m0_addb2_mach) -> bool;
}
extern "C" {
    pub fn mach_tlist_length(list: *const m0_tl) -> size_t;
}
extern "C" {
    pub fn mach_tlist_add(list: *mut m0_tl, amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_add_tail(list: *mut m0_tl, amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_add_after(amb: *mut m0_addb2_mach, next: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_add_before(amb: *mut m0_addb2_mach, next: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_del(amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_remove(amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_move(list: *mut m0_tl, amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_move_tail(list: *mut m0_tl, amb: *mut m0_addb2_mach);
}
extern "C" {
    pub fn mach_tlist_head(list: *const m0_tl) -> *mut m0_addb2_mach;
}
extern "C" {
    pub fn mach_tlist_pop(list: *const m0_tl) -> *mut m0_addb2_mach;
}
extern "C" {
    pub fn mach_tlist_tail(list: *const m0_tl) -> *mut m0_addb2_mach;
}
extern "C" {
    pub fn mach_tlist_next(list: *const m0_tl, amb: *const m0_addb2_mach) -> *mut m0_addb2_mach;
}
extern "C" {
    pub fn mach_tlist_prev(list: *const m0_tl, amb: *const m0_addb2_mach) -> *mut m0_addb2_mach;
}
extern "C" {
    pub fn m0_addb2__mach_print(m: *const m0_addb2_mach);
}
#[doc = " Fom type operation vector."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fom_type_ops {
    #[doc = " Create a new fom for the given fop."]
    pub fto_create: ::std::option::Option<
        unsafe extern "C" fn(
            fop: *mut m0_fop,
            out: *mut *mut m0_fom,
            reqh: *mut m0_reqh,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_m0_fom_type_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_fom_type_ops>(),
        8usize,
        concat!("Size of: ", stringify!(m0_fom_type_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fom_type_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fom_type_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fom_type_ops>())).fto_create as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fom_type_ops),
            "::",
            stringify!(fto_create)
        )
    );
}
extern "C" {
    pub static m0_addb2__fom_type_ops: m0_fom_type_ops;
}
#[doc = " @defgroup cas_dfspec CAS service"]
#[doc = " @brief Detailed functional specification."]
#[doc = ""]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_conf {
    pub scf_magic: u64,
    pub scf_name: *const ::std::os::raw::c_char,
    #[doc = " Number of states in this state machine."]
    pub scf_nr_states: u32,
    #[doc = " Array of state descriptions."]
    pub scf_state: *mut m0_sm_state_descr,
    #[doc = " Number of state transitions in this state machine."]
    pub scf_trans_nr: u32,
    #[doc = " Array of state transitions descriptions."]
    pub scf_trans: *mut m0_sm_trans_descr,
    pub scf_addb2_key: u64,
    pub scf_addb2_id: u64,
    pub scf_addb2_counter: u64,
}
#[test]
fn bindgen_test_layout_m0_sm_conf() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_conf>(),
        72usize,
        concat!("Size of: ", stringify!(m0_sm_conf))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_conf>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_conf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_nr_states as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_nr_states)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_state as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_trans_nr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_trans_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_trans as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_trans)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_addb2_key as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_addb2_key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_addb2_id as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_addb2_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_conf>())).scf_addb2_counter as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_conf),
            "::",
            stringify!(scf_addb2_counter)
        )
    );
}
extern "C" {
    pub static m0_addb2__sm_conf: m0_sm_conf;
}
#[doc = " Use logical block size 2^16 independently of stob block size. This"]
#[doc = " simplifies IO and makes format more portable."]
pub const storage_constants_BSHIFT: storage_constants = 16;
#[doc = " Use logical block size 2^16 independently of stob block size. This"]
#[doc = " simplifies IO and makes format more portable."]
pub const storage_constants_BSIZE: storage_constants = 65536;
pub type storage_constants = ::std::os::raw::c_uint;
extern "C" {
    pub fn m0_addb2__counter_snapshot(s: *mut m0_addb2_sensor, area: *mut u64);
}
extern "C" {
    pub fn m0_addb2__counter_data_init(d: *mut m0_addb2_counter_data);
}
#[doc = " Maximal number of global philters. Arbitrary."]
pub const M0_ADDB2_GLOBAL_PHILTERS: ::std::os::raw::c_uint = 512;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
#[doc = " Global addb2 state (per m0 instance)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_module {
    #[doc = " Sys instance used by global.c."]
    pub am_sys: *mut m0_addb2_sys,
    #[doc = " Array of global philters."]
    pub am_philter: [*mut m0_addb2_philter; 512usize],
}
#[test]
fn bindgen_test_layout_m0_addb2_module() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_module>(),
        4104usize,
        concat!("Size of: ", stringify!(m0_addb2_module))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_module>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_module))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_module>())).am_sys as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_module),
            "::",
            stringify!(am_sys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_module>())).am_philter as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_module),
            "::",
            stringify!(am_philter)
        )
    );
}
extern "C" {
    pub fn m0_addb2_module_get() -> *mut m0_addb2_module;
}
#[doc = " Addb2 sensor can produce a maximum of VALUE_MAX_NR 64-bit values."]
#[doc = ""]
#[doc = " The counter, embedded in each histogram produces"]
#[doc = " M0_ADDB2_COUNTER_VALS values. Two more are needed to record minimum"]
#[doc = " and maximum. The rest can be used for 32-bit buckets."]
pub const M0_ADDB2_HIST_BUCKETS: ::std::os::raw::c_uint = 14;
pub type _bindgen_ty_10 = ::std::os::raw::c_uint;
#[doc = " Data (in addition to counter data, m0_addb2_counter_data), produced by the"]
#[doc = " histogram."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_hist_data {
    #[doc = " Minimum. Once set this is never changed."]
    #[doc = ""]
    #[doc = " This is set either when histogram is initialised or at the end of"]
    #[doc = " auto-tuning period."]
    pub hd_min: i64,
    #[doc = " Maximum. Once set this is never changed."]
    pub hd_max: i64,
    #[doc = " Array of buckets."]
    pub hd_bucket: [u32; 14usize],
}
#[test]
fn bindgen_test_layout_m0_addb2_hist_data() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_hist_data>(),
        72usize,
        concat!("Size of: ", stringify!(m0_addb2_hist_data))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_hist_data>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_hist_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_hist_data>())).hd_min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_hist_data),
            "::",
            stringify!(hd_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_hist_data>())).hd_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_hist_data),
            "::",
            stringify!(hd_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_hist_data>())).hd_bucket as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_hist_data),
            "::",
            stringify!(hd_bucket)
        )
    );
}
#[doc = " Addb2 histogram."]
#[doc = ""]
#[doc = " Accumulates the same statistics as addb2 counter (m0_addb2_counter), plus an"]
#[doc = " array of value buckets."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_addb2_hist {
    pub hi_counter: m0_addb2_counter,
    #[doc = " Remaining updates in the auto-tuning period."]
    pub hi_skip: ::std::os::raw::c_int,
    pub hi_data: m0_addb2_hist_data,
}
#[test]
fn bindgen_test_layout_m0_addb2_hist() {
    assert_eq!(
        ::std::mem::size_of::<m0_addb2_hist>(),
        176usize,
        concat!("Size of: ", stringify!(m0_addb2_hist))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_addb2_hist>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_addb2_hist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_hist>())).hi_counter as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_hist),
            "::",
            stringify!(hi_counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_hist>())).hi_skip as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_hist),
            "::",
            stringify!(hi_skip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_addb2_hist>())).hi_data as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_addb2_hist),
            "::",
            stringify!(hi_data)
        )
    );
}
extern "C" {
    pub fn m0_addb2_hist_add(
        hist: *mut m0_addb2_hist,
        min: i64,
        max: i64,
        label: u64,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn m0_addb2_hist_add_auto(
        hist: *mut m0_addb2_hist,
        skip: ::std::os::raw::c_int,
        label: u64,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn m0_addb2_hist_del(hist: *mut m0_addb2_hist);
}
extern "C" {
    pub fn m0_addb2_hist_mod(hist: *mut m0_addb2_hist, val: i64);
}
extern "C" {
    pub fn m0_addb2_hist_mod_with(hist: *mut m0_addb2_hist, val: i64, datum: u64);
}
extern "C" {
    pub fn m0_addb2_hist_bucket(hist: *const m0_addb2_hist, val: i64) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sched_param {
    pub __sched_priority: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sched_param() {
    assert_eq!(
        ::std::mem::size_of::<sched_param>(),
        4usize,
        concat!("Size of: ", stringify!(sched_param))
    );
    assert_eq!(
        ::std::mem::align_of::<sched_param>(),
        4usize,
        concat!("Alignment of ", stringify!(sched_param))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).__sched_priority as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(__sched_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sched_param {
    pub __sched_priority: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sched_param() {
    assert_eq!(
        ::std::mem::size_of::<__sched_param>(),
        4usize,
        concat!("Size of: ", stringify!(__sched_param))
    );
    assert_eq!(
        ::std::mem::align_of::<__sched_param>(),
        4usize,
        concat!("Alignment of ", stringify!(__sched_param))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sched_param>())).__sched_priority as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sched_param),
            "::",
            stringify!(__sched_priority)
        )
    );
}
pub type __cpu_mask = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_set_t {
    pub __bits: [__cpu_mask; 16usize],
}
#[test]
fn bindgen_test_layout_cpu_set_t() {
    assert_eq!(
        ::std::mem::size_of::<cpu_set_t>(),
        128usize,
        concat!("Size of: ", stringify!(cpu_set_t))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_set_t>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_set_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_set_t>())).__bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_set_t),
            "::",
            stringify!(__bits)
        )
    );
}
extern "C" {
    pub fn __sched_cpucount(__setsize: size_t, __setp: *const cpu_set_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __sched_cpualloc(__count: size_t) -> *mut cpu_set_t;
}
extern "C" {
    pub fn __sched_cpufree(__set: *mut cpu_set_t);
}
extern "C" {
    pub fn sched_setparam(__pid: __pid_t, __param: *const sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getparam(__pid: __pid_t, __param: *mut sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_setscheduler(
        __pid: __pid_t,
        __policy: ::std::os::raw::c_int,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getscheduler(__pid: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_yield() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_max(__algorithm: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_min(__algorithm: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_rr_get_interval(__pid: __pid_t, __t: *mut timespec) -> ::std::os::raw::c_int;
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
pub const PTHREAD_CREATE_JOINABLE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_CREATE_DETACHED: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
pub const PTHREAD_MUTEX_TIMED_NP: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_RECURSIVE_NP: ::std::os::raw::c_uint = 1;
pub const PTHREAD_MUTEX_ERRORCHECK_NP: ::std::os::raw::c_uint = 2;
pub const PTHREAD_MUTEX_ADAPTIVE_NP: ::std::os::raw::c_uint = 3;
pub const PTHREAD_MUTEX_NORMAL: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_RECURSIVE: ::std::os::raw::c_uint = 1;
pub const PTHREAD_MUTEX_ERRORCHECK: ::std::os::raw::c_uint = 2;
pub const PTHREAD_MUTEX_DEFAULT: ::std::os::raw::c_uint = 0;
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
pub const PTHREAD_MUTEX_STALLED: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_STALLED_NP: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_ROBUST: ::std::os::raw::c_uint = 1;
pub const PTHREAD_MUTEX_ROBUST_NP: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
pub const PTHREAD_PRIO_NONE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_PRIO_INHERIT: ::std::os::raw::c_uint = 1;
pub const PTHREAD_PRIO_PROTECT: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
pub const PTHREAD_RWLOCK_PREFER_READER_NP: ::std::os::raw::c_uint = 0;
pub const PTHREAD_RWLOCK_PREFER_WRITER_NP: ::std::os::raw::c_uint = 1;
pub const PTHREAD_RWLOCK_PREFER_WRITER_NONRECURSIVE_NP: ::std::os::raw::c_uint = 2;
pub const PTHREAD_RWLOCK_DEFAULT_NP: ::std::os::raw::c_uint = 0;
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
pub const PTHREAD_INHERIT_SCHED: ::std::os::raw::c_uint = 0;
pub const PTHREAD_EXPLICIT_SCHED: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
pub const PTHREAD_SCOPE_SYSTEM: ::std::os::raw::c_uint = 0;
pub const PTHREAD_SCOPE_PROCESS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_17 = ::std::os::raw::c_uint;
pub const PTHREAD_PROCESS_PRIVATE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_PROCESS_SHARED: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_18 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _pthread_cleanup_buffer {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __canceltype: ::std::os::raw::c_int,
    pub __prev: *mut _pthread_cleanup_buffer,
}
#[test]
fn bindgen_test_layout__pthread_cleanup_buffer() {
    assert_eq!(
        ::std::mem::size_of::<_pthread_cleanup_buffer>(),
        32usize,
        concat!("Size of: ", stringify!(_pthread_cleanup_buffer))
    );
    assert_eq!(
        ::std::mem::align_of::<_pthread_cleanup_buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(_pthread_cleanup_buffer))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_pthread_cleanup_buffer>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_pthread_cleanup_buffer),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_pthread_cleanup_buffer>())).__arg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_pthread_cleanup_buffer),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_pthread_cleanup_buffer>())).__canceltype as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_pthread_cleanup_buffer),
            "::",
            stringify!(__canceltype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_pthread_cleanup_buffer>())).__prev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_pthread_cleanup_buffer),
            "::",
            stringify!(__prev)
        )
    );
}
pub const PTHREAD_CANCEL_ENABLE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_CANCEL_DISABLE: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_19 = ::std::os::raw::c_uint;
pub const PTHREAD_CANCEL_DEFERRED: ::std::os::raw::c_uint = 0;
pub const PTHREAD_CANCEL_ASYNCHRONOUS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_20 = ::std::os::raw::c_uint;
extern "C" {
    pub fn pthread_create(
        __newthread: *mut pthread_t,
        __attr: *const pthread_attr_t,
        __start_routine: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_exit(__retval: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn pthread_join(
        __th: pthread_t,
        __thread_return: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_detach(__th: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_self() -> pthread_t;
}
extern "C" {
    pub fn pthread_equal(__thread1: pthread_t, __thread2: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_init(__attr: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_destroy(__attr: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getdetachstate(
        __attr: *const pthread_attr_t,
        __detachstate: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setdetachstate(
        __attr: *mut pthread_attr_t,
        __detachstate: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getguardsize(
        __attr: *const pthread_attr_t,
        __guardsize: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setguardsize(
        __attr: *mut pthread_attr_t,
        __guardsize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedparam(
        __attr: *const pthread_attr_t,
        __param: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedparam(
        __attr: *mut pthread_attr_t,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedpolicy(
        __attr: *const pthread_attr_t,
        __policy: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedpolicy(
        __attr: *mut pthread_attr_t,
        __policy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getinheritsched(
        __attr: *const pthread_attr_t,
        __inherit: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setinheritsched(
        __attr: *mut pthread_attr_t,
        __inherit: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getscope(
        __attr: *const pthread_attr_t,
        __scope: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setscope(
        __attr: *mut pthread_attr_t,
        __scope: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstackaddr(
        __attr: *const pthread_attr_t,
        __stackaddr: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstackaddr(
        __attr: *mut pthread_attr_t,
        __stackaddr: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstacksize(
        __attr: *const pthread_attr_t,
        __stacksize: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstacksize(
        __attr: *mut pthread_attr_t,
        __stacksize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstack(
        __attr: *const pthread_attr_t,
        __stackaddr: *mut *mut ::std::os::raw::c_void,
        __stacksize: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstack(
        __attr: *mut pthread_attr_t,
        __stackaddr: *mut ::std::os::raw::c_void,
        __stacksize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedparam(
        __target_thread: pthread_t,
        __policy: ::std::os::raw::c_int,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getschedparam(
        __target_thread: pthread_t,
        __policy: *mut ::std::os::raw::c_int,
        __param: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedprio(
        __target_thread: pthread_t,
        __prio: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_once(
        __once_control: *mut pthread_once_t,
        __init_routine: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcancelstate(
        __state: ::std::os::raw::c_int,
        __oldstate: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcanceltype(
        __type: ::std::os::raw::c_int,
        __oldtype: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cancel(__th: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_testcancel();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_unwind_buf_t {
    pub __cancel_jmp_buf: [__pthread_unwind_buf_t__bindgen_ty_1; 1usize],
    pub __pad: [*mut ::std::os::raw::c_void; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_unwind_buf_t__bindgen_ty_1 {
    pub __cancel_jmp_buf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___pthread_unwind_buf_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_unwind_buf_t__bindgen_ty_1>(),
        72usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_unwind_buf_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_unwind_buf_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_unwind_buf_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_unwind_buf_t__bindgen_ty_1>())).__cancel_jmp_buf
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_unwind_buf_t__bindgen_ty_1),
            "::",
            stringify!(__cancel_jmp_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_unwind_buf_t__bindgen_ty_1>())).__mask_was_saved
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_unwind_buf_t__bindgen_ty_1),
            "::",
            stringify!(__mask_was_saved)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_unwind_buf_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_unwind_buf_t>(),
        104usize,
        concat!("Size of: ", stringify!(__pthread_unwind_buf_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_unwind_buf_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_unwind_buf_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_unwind_buf_t>())).__cancel_jmp_buf as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_unwind_buf_t),
            "::",
            stringify!(__cancel_jmp_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_unwind_buf_t>())).__pad as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_unwind_buf_t),
            "::",
            stringify!(__pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cleanup_frame {
    pub __cancel_routine:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __cancel_arg: *mut ::std::os::raw::c_void,
    pub __do_it: ::std::os::raw::c_int,
    pub __cancel_type: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___pthread_cleanup_frame() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cleanup_frame>(),
        24usize,
        concat!("Size of: ", stringify!(__pthread_cleanup_frame))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cleanup_frame>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cleanup_frame))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cleanup_frame>())).__cancel_routine as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_frame),
            "::",
            stringify!(__cancel_routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cleanup_frame>())).__cancel_arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_frame),
            "::",
            stringify!(__cancel_arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cleanup_frame>())).__do_it as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_frame),
            "::",
            stringify!(__do_it)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cleanup_frame>())).__cancel_type as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cleanup_frame),
            "::",
            stringify!(__cancel_type)
        )
    );
}
extern "C" {
    pub fn __pthread_register_cancel(__buf: *mut __pthread_unwind_buf_t);
}
extern "C" {
    pub fn __pthread_unregister_cancel(__buf: *mut __pthread_unwind_buf_t);
}
extern "C" {
    pub fn __pthread_unwind_next(__buf: *mut __pthread_unwind_buf_t);
}
extern "C" {
    pub fn __sigsetjmp(
        __env: *mut __jmp_buf_tag,
        __savemask: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_init(
        __mutex: *mut pthread_mutex_t,
        __mutexattr: *const pthread_mutexattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_destroy(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_trylock(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_lock(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_timedlock(
        __mutex: *mut pthread_mutex_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_unlock(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_getprioceiling(
        __mutex: *const pthread_mutex_t,
        __prioceiling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_setprioceiling(
        __mutex: *mut pthread_mutex_t,
        __prioceiling: ::std::os::raw::c_int,
        __old_ceiling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_consistent(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_init(__attr: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_destroy(__attr: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getpshared(
        __attr: *const pthread_mutexattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setpshared(
        __attr: *mut pthread_mutexattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_gettype(
        __attr: *const pthread_mutexattr_t,
        __kind: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_settype(
        __attr: *mut pthread_mutexattr_t,
        __kind: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprotocol(
        __attr: *const pthread_mutexattr_t,
        __protocol: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprotocol(
        __attr: *mut pthread_mutexattr_t,
        __protocol: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprioceiling(
        __attr: *const pthread_mutexattr_t,
        __prioceiling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprioceiling(
        __attr: *mut pthread_mutexattr_t,
        __prioceiling: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getrobust(
        __attr: *const pthread_mutexattr_t,
        __robustness: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setrobust(
        __attr: *mut pthread_mutexattr_t,
        __robustness: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_init(
        __rwlock: *mut pthread_rwlock_t,
        __attr: *const pthread_rwlockattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_destroy(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_rdlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_tryrdlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_timedrdlock(
        __rwlock: *mut pthread_rwlock_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_wrlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_trywrlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_timedwrlock(
        __rwlock: *mut pthread_rwlock_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_unlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_init(__attr: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_destroy(__attr: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_getpshared(
        __attr: *const pthread_rwlockattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_setpshared(
        __attr: *mut pthread_rwlockattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_getkind_np(
        __attr: *const pthread_rwlockattr_t,
        __pref: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_setkind_np(
        __attr: *mut pthread_rwlockattr_t,
        __pref: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_init(
        __cond: *mut pthread_cond_t,
        __cond_attr: *const pthread_condattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_destroy(__cond: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_signal(__cond: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_broadcast(__cond: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_wait(
        __cond: *mut pthread_cond_t,
        __mutex: *mut pthread_mutex_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_timedwait(
        __cond: *mut pthread_cond_t,
        __mutex: *mut pthread_mutex_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_init(__attr: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_destroy(__attr: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getpshared(
        __attr: *const pthread_condattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setpshared(
        __attr: *mut pthread_condattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getclock(
        __attr: *const pthread_condattr_t,
        __clock_id: *mut __clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setclock(
        __attr: *mut pthread_condattr_t,
        __clock_id: __clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_init(
        __lock: *mut pthread_spinlock_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_destroy(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_lock(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_trylock(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_unlock(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_init(
        __barrier: *mut pthread_barrier_t,
        __attr: *const pthread_barrierattr_t,
        __count: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_destroy(__barrier: *mut pthread_barrier_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_wait(__barrier: *mut pthread_barrier_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_init(__attr: *mut pthread_barrierattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_destroy(__attr: *mut pthread_barrierattr_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_getpshared(
        __attr: *const pthread_barrierattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_setpshared(
        __attr: *mut pthread_barrierattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_create(
        __key: *mut pthread_key_t,
        __destr_function: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_delete(__key: pthread_key_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getspecific(__key: pthread_key_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn pthread_setspecific(
        __key: pthread_key_t,
        __pointer: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getcpuclockid(
        __thread_id: pthread_t,
        __clock_id: *mut __clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_atfork(
        __prepare: ::std::option::Option<unsafe extern "C" fn()>,
        __parent: ::std::option::Option<unsafe extern "C" fn()>,
        __child: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
#[doc = "@addtogroup mutex"]
#[doc = ""]
#[doc = "<b>User space mutex.</b>"]
#[doc = "@{"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_arch_mutex {
    pub m_impl: pthread_mutex_t,
}
#[test]
fn bindgen_test_layout_m0_arch_mutex() {
    assert_eq!(
        ::std::mem::size_of::<m0_arch_mutex>(),
        40usize,
        concat!("Size of: ", stringify!(m0_arch_mutex))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_arch_mutex>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_arch_mutex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_arch_mutex>())).m_impl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_arch_mutex),
            "::",
            stringify!(m_impl)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_mutex {
    pub m_arch: m0_arch_mutex,
    pub m_owner: *mut m0_thread,
    pub m_addb2: *mut m0_mutex_addb2,
}
#[test]
fn bindgen_test_layout_m0_mutex() {
    assert_eq!(
        ::std::mem::size_of::<m0_mutex>(),
        56usize,
        concat!("Size of: ", stringify!(m0_mutex))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_mutex>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_mutex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex>())).m_arch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex),
            "::",
            stringify!(m_arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex>())).m_owner as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex),
            "::",
            stringify!(m_owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex>())).m_addb2 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex),
            "::",
            stringify!(m_addb2)
        )
    );
}
extern "C" {
    pub fn m0_mutex_init(mutex: *mut m0_mutex);
}
extern "C" {
    pub fn m0_mutex_fini(mutex: *mut m0_mutex);
}
extern "C" {
    #[doc = "Returns with the mutex locked."]
    #[doc = ""]
    #[doc = "@pre  m0_mutex_is_not_locked(mutex)"]
    #[doc = "@post m0_mutex_is_locked(mutex)"]
    pub fn m0_mutex_lock(mutex: *mut m0_mutex);
}
extern "C" {
    #[doc = "Unlocks the mutex."]
    #[doc = ""]
    #[doc = "@pre  m0_mutex_is_locked(mutex)"]
    #[doc = "@post m0_mutex_is_not_locked(mutex)"]
    pub fn m0_mutex_unlock(mutex: *mut m0_mutex);
}
extern "C" {
    #[doc = "Try to take a mutex lock."]
    #[doc = "Returns 0 with the mutex locked,"]
    #[doc = "or non-zero if lock is already hold by others."]
    pub fn m0_mutex_trylock(mutex: *mut m0_mutex) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "True iff mutex is locked by the calling thread."]
    #[doc = ""]
    #[doc = "@note this function can be used only in assertions."]
    pub fn m0_mutex_is_locked(mutex: *const m0_mutex) -> bool;
}
extern "C" {
    #[doc = "True iff mutex is not locked by the calling thread."]
    #[doc = ""]
    #[doc = "@note this function can be used only in assertions."]
    pub fn m0_mutex_is_not_locked(mutex: *const m0_mutex) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_mutex_addb2 {
    pub ma_taken: m0_time_t,
    pub ma_hold: m0_addb2_hist,
    pub ma_wait: m0_addb2_hist,
    pub ma_id: u64,
}
#[test]
fn bindgen_test_layout_m0_mutex_addb2() {
    assert_eq!(
        ::std::mem::size_of::<m0_mutex_addb2>(),
        368usize,
        concat!("Size of: ", stringify!(m0_mutex_addb2))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_mutex_addb2>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_mutex_addb2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex_addb2>())).ma_taken as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex_addb2),
            "::",
            stringify!(ma_taken)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex_addb2>())).ma_hold as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex_addb2),
            "::",
            stringify!(ma_hold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex_addb2>())).ma_wait as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex_addb2),
            "::",
            stringify!(ma_wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_mutex_addb2>())).ma_id as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_mutex_addb2),
            "::",
            stringify!(ma_id)
        )
    );
}
extern "C" {
    pub fn m0_arch_mutex_init(mutex: *mut m0_arch_mutex);
}
extern "C" {
    pub fn m0_arch_mutex_fini(mutex: *mut m0_arch_mutex);
}
extern "C" {
    pub fn m0_arch_mutex_lock(mutex: *mut m0_arch_mutex);
}
extern "C" {
    pub fn m0_arch_mutex_unlock(mutex: *mut m0_arch_mutex);
}
extern "C" {
    pub fn m0_arch_mutex_trylock(mutex: *mut m0_arch_mutex) -> ::std::os::raw::c_int;
}
#[doc = "@defgroup timer Generic timer manipulation"]
#[doc = ""]
#[doc = "Any timer should call m0_timer_init() function before any function. That"]
#[doc = "init function does all initialization for this timer. After that, the"]
#[doc = "m0_timer_start() function is called to start the timer. The timer callback"]
#[doc = "function will be called repeatedly, if this is a repeatable timer. Function"]
#[doc = "m0_timer_stop() is used to stop the timer, and m0_timer_fini() to destroy"]
#[doc = "the timer after usage."]
#[doc = ""]
#[doc = "User supplied callback function should be small, run and complete quickly."]
#[doc = ""]
#[doc = "There are two types of timer: soft timer and hard timer. For Linux kernel"]
#[doc = "implementation, all timers are hard timer. For userspace implementation,"]
#[doc = "soft timer and hard timer have different mechanism:"]
#[doc = ""]
#[doc = "- Hard timer has better resolution and is driven by signal. The"]
#[doc = "user-defined callback should take short time, should never block"]
#[doc = "at any time. Also in user space it should be async-signal-safe"]
#[doc = "(see signal(7)), in kernel space it can only take _irq spin-locks."]
#[doc = "- Soft timer creates separate thread to execute the user-defined"]
#[doc = "callback for each timer. So the overhead is bigger than hard timer."]
#[doc = "The user-defined callback execution may take longer time and it will"]
#[doc = "not impact other timers."]
#[doc = ""]
#[doc = "State machine"]
#[doc = "@verbatim"]
#[doc = ""]
#[doc = "+------------+     m0_timer_start()     +-------------+"]
#[doc = "|   INITED   |------------------------->|   RUNNING   |"]
#[doc = "+------------+                          +-------------+"]
#[doc = "^  |                                    |  ^"]
#[doc = "m0_timer_init() |  | m0_timer_fini()    m0_timer_stop() |  | m0_timer_start()"]
#[doc = "|  v                                    v  |"]
#[doc = "+============+                          +-------------+"]
#[doc = "|   UNINIT   |<-------------------------|   STOPPED   |"]
#[doc = "+============+      m0_timer_fini()     +-------------+"]
#[doc = ""]
#[doc = "@endverbatim"]
#[doc = ""]
#[doc = "Error handling"]
#[doc = "- m0_timer_init() can fail;"]
#[doc = "- m0_timer_fini() can't fail;"]
#[doc = "- m0_timer_start(), m0_timer_stop() is guaranteed to succeed after"]
#[doc = "successful m0_timer_init() call."]
#[doc = ""]
#[doc = "Implementation details"]
#[doc = "- POSIX timer is used in hard timer implementation;"]
#[doc = "- POSIX timer is created in m0_timer_init() and is deleted in"]
#[doc = "m0_timer_fini();"]
#[doc = "- m0_thread is used in soft timer implementation;"]
#[doc = "- m0_thread is started in m0_timer_init() and is finalised in"]
#[doc = "m0_timer_fini();"]
#[doc = "- add_timer() is used in kernel timer implementation."]
#[doc = ""]
#[doc = "Limitations"]
#[doc = "- Number of hard timers is limited by maximum number of pending signals,"]
#[doc = "see `ulimit -i`."]
#[doc = "- Number of soft timers is limited by maximum number of threads."]
#[doc = ""]
#[doc = "@note m0_timer_* functions should not be used in the timer callbacks."]
#[doc = "@{"]
pub type m0_timer_callback_t = ::std::option::Option<
    unsafe extern "C" fn(data: ::std::os::raw::c_ulong) -> ::std::os::raw::c_ulong,
>;
pub const m0_timer_type_M0_TIMER_SOFT: m0_timer_type = 0;
pub const m0_timer_type_M0_TIMER_HARD: m0_timer_type = 1;
pub const m0_timer_type_M0_TIMER_TYPE_NR: m0_timer_type = 2;
#[doc = "Timer type."]
pub type m0_timer_type = ::std::os::raw::c_uint;
#[doc = " Not initialized."]
pub const m0_timer_state_M0_TIMER_UNINIT: m0_timer_state = 0;
#[doc = " Initialized."]
pub const m0_timer_state_M0_TIMER_INITED: m0_timer_state = 1;
#[doc = " Timer is running."]
pub const m0_timer_state_M0_TIMER_RUNNING: m0_timer_state = 2;
#[doc = " Timer is stopped"]
pub const m0_timer_state_M0_TIMER_STOPPED: m0_timer_state = 3;
#[doc = " Number of timer states"]
pub const m0_timer_state_M0_TIMER_STATE_NR: m0_timer_state = 4;
#[doc = "Timer state."]
#[doc = "@see timer_state_change()"]
pub type m0_timer_state = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_timer_operations {
    pub tmr_init: ::std::option::Option<
        unsafe extern "C" fn(
            timer: *mut m0_timer,
            loc: *mut m0_timer_locality,
        ) -> ::std::os::raw::c_int,
    >,
    pub tmr_fini: ::std::option::Option<unsafe extern "C" fn(timer: *mut m0_timer)>,
    pub tmr_start: ::std::option::Option<unsafe extern "C" fn(timer: *mut m0_timer)>,
    pub tmr_stop: ::std::option::Option<unsafe extern "C" fn(timer: *mut m0_timer)>,
}
#[test]
fn bindgen_test_layout_m0_timer_operations() {
    assert_eq!(
        ::std::mem::size_of::<m0_timer_operations>(),
        32usize,
        concat!("Size of: ", stringify!(m0_timer_operations))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_timer_operations>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_timer_operations))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_operations>())).tmr_init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_operations),
            "::",
            stringify!(tmr_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_operations>())).tmr_fini as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_operations),
            "::",
            stringify!(tmr_fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_operations>())).tmr_start as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_operations),
            "::",
            stringify!(tmr_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_operations>())).tmr_stop as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_operations),
            "::",
            stringify!(tmr_stop)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
#[test]
fn bindgen_test_layout___jmp_buf_tag() {
    assert_eq!(
        ::std::mem::size_of::<__jmp_buf_tag>(),
        200usize,
        concat!("Size of: ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__jmp_buf_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__jmpbuf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__jmpbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__mask_was_saved as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__mask_was_saved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__saved_mask as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__saved_mask)
        )
    );
}
pub type jmp_buf = [__jmp_buf_tag; 1usize];
extern "C" {
    pub fn setjmp(__env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _setjmp(__env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn longjmp(__env: *mut __jmp_buf_tag, __val: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _longjmp(__env: *mut __jmp_buf_tag, __val: ::std::os::raw::c_int);
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
extern "C" {
    pub fn siglongjmp(__env: *mut __jmp_buf_tag, __val: ::std::os::raw::c_int);
}
extern "C" {
    pub fn __sigismember(
        arg1: *const __sigset_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __sigaddset(arg1: *mut __sigset_t, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __sigdelset(arg1: *mut __sigset_t, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
pub type sig_atomic_t = __sig_atomic_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
pub type sigval_t = sigval;
pub type __sigchld_clock_t = __clock_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub _sifields: siginfo_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 28usize],
    pub _kill: siginfo_t__bindgen_ty_1__bindgen_ty_1,
    pub _timer: siginfo_t__bindgen_ty_1__bindgen_ty_2,
    pub _rt: siginfo_t__bindgen_ty_1__bindgen_ty_3,
    pub _sigchld: siginfo_t__bindgen_ty_1__bindgen_ty_4,
    pub _sigfault: siginfo_t__bindgen_ty_1__bindgen_ty_5,
    pub _sigpoll: siginfo_t__bindgen_ty_1__bindgen_ty_6,
    pub _sigsys: siginfo_t__bindgen_ty_1__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1>())).si_pid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1>())).si_uid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_uid)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    pub si_tid: ::std::os::raw::c_int,
    pub si_overrun: ::std::os::raw::c_int,
    pub si_sigval: sigval_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_tid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_tid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_overrun as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_overrun)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_sigval as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_sigval)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_3 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_sigval: sigval_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_3>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_pid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_uid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_sigval as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_sigval)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_4 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_utime: __sigchld_clock_t,
    pub si_stime: __sigchld_clock_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_4>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_pid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_uid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_status as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_utime as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_utime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_stime as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_stime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5 {
    pub si_addr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_5>())).si_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(si_addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_6 {
    pub si_band: ::std::os::raw::c_long,
    pub si_fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_6>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_6>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_6>())).si_band as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_6>())).si_fd as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(si_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_7 {
    pub _call_addr: *mut ::std::os::raw::c_void,
    pub _syscall: ::std::os::raw::c_int,
    pub _arch: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_7>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_7>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_7>()))._call_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(_call_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_7>()))._syscall as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(_syscall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_7>()))._arch as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(_arch)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1>(),
        112usize,
        concat!("Size of: ", stringify!(siginfo_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(siginfo_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._pad as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._kill as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_kill)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._timer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_timer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._rt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_rt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigchld as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigchld)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigfault as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigfault)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigpoll as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigpoll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigsys as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigsys)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t>(),
        128usize,
        concat!("Size of: ", stringify!(siginfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(siginfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>()))._sifields as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(_sifields)
        )
    );
}
pub const SI_ASYNCNL: ::std::os::raw::c_int = -60;
pub const SI_TKILL: ::std::os::raw::c_int = -6;
pub const SI_SIGIO: ::std::os::raw::c_int = -5;
pub const SI_ASYNCIO: ::std::os::raw::c_int = -4;
pub const SI_MESGQ: ::std::os::raw::c_int = -3;
pub const SI_TIMER: ::std::os::raw::c_int = -2;
pub const SI_QUEUE: ::std::os::raw::c_int = -1;
pub const SI_USER: ::std::os::raw::c_int = 0;
pub const SI_KERNEL: ::std::os::raw::c_int = 128;
pub type _bindgen_ty_21 = ::std::os::raw::c_int;
pub const ILL_ILLOPC: ::std::os::raw::c_uint = 1;
pub const ILL_ILLOPN: ::std::os::raw::c_uint = 2;
pub const ILL_ILLADR: ::std::os::raw::c_uint = 3;
pub const ILL_ILLTRP: ::std::os::raw::c_uint = 4;
pub const ILL_PRVOPC: ::std::os::raw::c_uint = 5;
pub const ILL_PRVREG: ::std::os::raw::c_uint = 6;
pub const ILL_COPROC: ::std::os::raw::c_uint = 7;
pub const ILL_BADSTK: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_22 = ::std::os::raw::c_uint;
pub const FPE_INTDIV: ::std::os::raw::c_uint = 1;
pub const FPE_INTOVF: ::std::os::raw::c_uint = 2;
pub const FPE_FLTDIV: ::std::os::raw::c_uint = 3;
pub const FPE_FLTOVF: ::std::os::raw::c_uint = 4;
pub const FPE_FLTUND: ::std::os::raw::c_uint = 5;
pub const FPE_FLTRES: ::std::os::raw::c_uint = 6;
pub const FPE_FLTINV: ::std::os::raw::c_uint = 7;
pub const FPE_FLTSUB: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_23 = ::std::os::raw::c_uint;
pub const SEGV_MAPERR: ::std::os::raw::c_uint = 1;
pub const SEGV_ACCERR: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_24 = ::std::os::raw::c_uint;
pub const BUS_ADRALN: ::std::os::raw::c_uint = 1;
pub const BUS_ADRERR: ::std::os::raw::c_uint = 2;
pub const BUS_OBJERR: ::std::os::raw::c_uint = 3;
pub type _bindgen_ty_25 = ::std::os::raw::c_uint;
pub const TRAP_BRKPT: ::std::os::raw::c_uint = 1;
pub const TRAP_TRACE: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_26 = ::std::os::raw::c_uint;
pub const CLD_EXITED: ::std::os::raw::c_uint = 1;
pub const CLD_KILLED: ::std::os::raw::c_uint = 2;
pub const CLD_DUMPED: ::std::os::raw::c_uint = 3;
pub const CLD_TRAPPED: ::std::os::raw::c_uint = 4;
pub const CLD_STOPPED: ::std::os::raw::c_uint = 5;
pub const CLD_CONTINUED: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_27 = ::std::os::raw::c_uint;
pub const POLL_IN: ::std::os::raw::c_uint = 1;
pub const POLL_OUT: ::std::os::raw::c_uint = 2;
pub const POLL_MSG: ::std::os::raw::c_uint = 3;
pub const POLL_ERR: ::std::os::raw::c_uint = 4;
pub const POLL_PRI: ::std::os::raw::c_uint = 5;
pub const POLL_HUP: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_28 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_value: sigval_t,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_notify: ::std::os::raw::c_int,
    pub _sigev_un: sigevent__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigevent__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 12usize],
    pub _tid: __pid_t,
    pub _sigev_thread: sigevent__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent__bindgen_ty_1__bindgen_ty_1 {
    pub _function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval_t)>,
    pub _attribute: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigevent__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent__bindgen_ty_1__bindgen_ty_1>()))._function as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent__bindgen_ty_1__bindgen_ty_1>()))._attribute as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_attribute)
        )
    );
}
#[test]
fn bindgen_test_layout_sigevent__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigevent__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(sigevent__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent__bindgen_ty_1>()))._pad as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent__bindgen_ty_1>()))._tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_tid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent__bindgen_ty_1>()))._sigev_thread as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_sigev_thread)
        )
    );
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        64usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>()))._sigev_un as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(_sigev_un)
        )
    );
}
pub type sigevent_t = sigevent;
pub const SIGEV_SIGNAL: ::std::os::raw::c_uint = 0;
pub const SIGEV_NONE: ::std::os::raw::c_uint = 1;
pub const SIGEV_THREAD: ::std::os::raw::c_uint = 2;
pub const SIGEV_THREAD_ID: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_29 = ::std::os::raw::c_uint;
pub type __sighandler_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
extern "C" {
    pub fn __sysv_signal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t)
        -> __sighandler_t;
}
extern "C" {
    pub fn signal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t) -> __sighandler_t;
}
extern "C" {
    pub fn kill(__pid: __pid_t, __sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn killpg(__pgrp: __pid_t, __sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn raise(__sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ssignal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t) -> __sighandler_t;
}
extern "C" {
    pub fn gsignal(__sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psignal(__sig: ::std::os::raw::c_int, __s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn psiginfo(__pinfo: *const siginfo_t, __s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn __sigpause(
        __sig_or_mask: ::std::os::raw::c_int,
        __is_sig: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigblock(__mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsetmask(__mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siggetmask() -> ::std::os::raw::c_int;
}
pub type sig_t = __sighandler_t;
extern "C" {
    pub fn sigemptyset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset(__set: *mut sigset_t, __signo: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(__set: *mut sigset_t, __signo: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(
        __set: *const sigset_t,
        __signo: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_handler: sigaction__bindgen_ty_1,
    pub sa_mask: __sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub sa_handler: __sighandler_t,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo_t,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_sigaction__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigaction__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigaction__bindgen_ty_1>())).sa_handler as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigaction__bindgen_ty_1>())).sa_sigaction as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_sigaction)
        )
    );
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        152usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_restorer as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_restorer)
        )
    );
}
extern "C" {
    pub fn sigprocmask(
        __how: ::std::os::raw::c_int,
        __set: *const sigset_t,
        __oset: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsuspend(__set: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction(
        __sig: ::std::os::raw::c_int,
        __act: *const sigaction,
        __oact: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        __set: *const sigset_t,
        __sig: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwaitinfo(__set: *const sigset_t, __info: *mut siginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigtimedwait(
        __set: *const sigset_t,
        __info: *mut siginfo_t,
        __timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigqueue(
        __pid: __pid_t,
        __sig: ::std::os::raw::c_int,
        __val: sigval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static _sys_siglist: [*const ::std::os::raw::c_char; 65usize];
}
extern "C" {
    pub static sys_siglist: [*const ::std::os::raw::c_char; 65usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: __sighandler_t,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
extern "C" {
    pub fn sigvec(
        __sig: ::std::os::raw::c_int,
        __vec: *const sigvec,
        __ovec: *mut sigvec,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpx_sw_bytes {
    pub magic1: __uint32_t,
    pub extended_size: __uint32_t,
    pub xstate_bv: __uint64_t,
    pub xstate_size: __uint32_t,
    pub padding: [__uint32_t; 7usize],
}
#[test]
fn bindgen_test_layout__fpx_sw_bytes() {
    assert_eq!(
        ::std::mem::size_of::<_fpx_sw_bytes>(),
        48usize,
        concat!("Size of: ", stringify!(_fpx_sw_bytes))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpx_sw_bytes>(),
        8usize,
        concat!("Alignment of ", stringify!(_fpx_sw_bytes))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).magic1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(magic1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).extended_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(extended_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).xstate_bv as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(xstate_bv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).xstate_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(xstate_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).padding as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout__fpreg() {
    assert_eq!(
        ::std::mem::size_of::<_fpreg>(),
        10usize,
        concat!("Size of: ", stringify!(_fpreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpreg>(),
        2usize,
        concat!("Alignment of ", stringify!(_fpreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpreg>())).significand as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpreg),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpreg>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpreg),
            "::",
            stringify!(exponent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub padding: [::std::os::raw::c_ushort; 3usize],
}
#[test]
fn bindgen_test_layout__fpxreg() {
    assert_eq!(
        ::std::mem::size_of::<_fpxreg>(),
        16usize,
        concat!("Size of: ", stringify!(_fpxreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpxreg>(),
        2usize,
        concat!("Alignment of ", stringify!(_fpxreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpxreg>())).significand as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpxreg),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpxreg>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpxreg),
            "::",
            stringify!(exponent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpxreg>())).padding as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpxreg),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[test]
fn bindgen_test_layout__xmmreg() {
    assert_eq!(
        ::std::mem::size_of::<_xmmreg>(),
        16usize,
        concat!("Size of: ", stringify!(_xmmreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_xmmreg>(),
        4usize,
        concat!("Alignment of ", stringify!(_xmmreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xmmreg>())).element as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_xmmreg),
            "::",
            stringify!(element)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_fpxreg; 8usize],
    pub _xmm: [_xmmreg; 16usize],
    pub padding: [__uint32_t; 24usize],
}
#[test]
fn bindgen_test_layout__fpstate() {
    assert_eq!(
        ::std::mem::size_of::<_fpstate>(),
        512usize,
        concat!("Size of: ", stringify!(_fpstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_fpstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).cwd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).swd as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(swd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).ftw as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(ftw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).fop as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(fop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).rip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).rdp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(rdp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).mxcsr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).mxcr_mask as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(mxcr_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>()))._st as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(_st)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>()))._xmm as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(_xmm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).padding as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigcontext {
    pub r8: __uint64_t,
    pub r9: __uint64_t,
    pub r10: __uint64_t,
    pub r11: __uint64_t,
    pub r12: __uint64_t,
    pub r13: __uint64_t,
    pub r14: __uint64_t,
    pub r15: __uint64_t,
    pub rdi: __uint64_t,
    pub rsi: __uint64_t,
    pub rbp: __uint64_t,
    pub rbx: __uint64_t,
    pub rdx: __uint64_t,
    pub rax: __uint64_t,
    pub rcx: __uint64_t,
    pub rsp: __uint64_t,
    pub rip: __uint64_t,
    pub eflags: __uint64_t,
    pub cs: ::std::os::raw::c_ushort,
    pub gs: ::std::os::raw::c_ushort,
    pub fs: ::std::os::raw::c_ushort,
    pub __pad0: ::std::os::raw::c_ushort,
    pub err: __uint64_t,
    pub trapno: __uint64_t,
    pub oldmask: __uint64_t,
    pub cr2: __uint64_t,
    pub __bindgen_anon_1: sigcontext__bindgen_ty_1,
    pub __reserved1: [__uint64_t; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigcontext__bindgen_ty_1 {
    pub fpstate: *mut _fpstate,
    pub __fpstate_word: __uint64_t,
}
#[test]
fn bindgen_test_layout_sigcontext__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigcontext__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sigcontext__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigcontext__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigcontext__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigcontext__bindgen_ty_1>())).fpstate as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext__bindgen_ty_1),
            "::",
            stringify!(fpstate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigcontext__bindgen_ty_1>())).__fpstate_word as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext__bindgen_ty_1),
            "::",
            stringify!(__fpstate_word)
        )
    );
}
#[test]
fn bindgen_test_layout_sigcontext() {
    assert_eq!(
        ::std::mem::size_of::<sigcontext>(),
        256usize,
        concat!("Size of: ", stringify!(sigcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<sigcontext>(),
        8usize,
        concat!("Alignment of ", stringify!(sigcontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r9 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r10 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r11 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r12 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r13 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r14 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r15 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rdi as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rsi as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rbp as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rbx as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rdx as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rax as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rcx as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rsp as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rip as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).eflags as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(eflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).cs as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).gs as *const _ as usize },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).fs as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).__pad0 as *const _ as usize },
        150usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(__pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).err as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).trapno as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(trapno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).oldmask as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(oldmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).cr2 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).__reserved1 as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(__reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xsave_hdr {
    pub xstate_bv: __uint64_t,
    pub reserved1: [__uint64_t; 2usize],
    pub reserved2: [__uint64_t; 5usize],
}
#[test]
fn bindgen_test_layout__xsave_hdr() {
    assert_eq!(
        ::std::mem::size_of::<_xsave_hdr>(),
        64usize,
        concat!("Size of: ", stringify!(_xsave_hdr))
    );
    assert_eq!(
        ::std::mem::align_of::<_xsave_hdr>(),
        8usize,
        concat!("Alignment of ", stringify!(_xsave_hdr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xsave_hdr>())).xstate_bv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_xsave_hdr),
            "::",
            stringify!(xstate_bv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xsave_hdr>())).reserved1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_xsave_hdr),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xsave_hdr>())).reserved2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_xsave_hdr),
            "::",
            stringify!(reserved2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ymmh_state {
    pub ymmh_space: [__uint32_t; 64usize],
}
#[test]
fn bindgen_test_layout__ymmh_state() {
    assert_eq!(
        ::std::mem::size_of::<_ymmh_state>(),
        256usize,
        concat!("Size of: ", stringify!(_ymmh_state))
    );
    assert_eq!(
        ::std::mem::align_of::<_ymmh_state>(),
        4usize,
        concat!("Alignment of ", stringify!(_ymmh_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ymmh_state>())).ymmh_space as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ymmh_state),
            "::",
            stringify!(ymmh_space)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xstate {
    pub fpstate: _fpstate,
    pub xstate_hdr: _xsave_hdr,
    pub ymmh: _ymmh_state,
}
#[test]
fn bindgen_test_layout__xstate() {
    assert_eq!(
        ::std::mem::size_of::<_xstate>(),
        832usize,
        concat!("Size of: ", stringify!(_xstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_xstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_xstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xstate>())).fpstate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_xstate),
            "::",
            stringify!(fpstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xstate>())).xstate_hdr as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(_xstate),
            "::",
            stringify!(xstate_hdr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xstate>())).ymmh as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(_xstate),
            "::",
            stringify!(ymmh)
        )
    );
}
extern "C" {
    pub fn sigreturn(__scp: *mut sigcontext) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siginterrupt(
        __sig: ::std::os::raw::c_int,
        __interrupt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
pub const SS_ONSTACK: ::std::os::raw::c_uint = 1;
pub const SS_DISABLE: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_30 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_flags: ::std::os::raw::c_int,
    pub ss_size: size_t,
}
#[test]
fn bindgen_test_layout_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaltstack>())).ss_flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaltstack>())).ss_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
}
pub type stack_t = sigaltstack;
pub type greg_t = ::std::os::raw::c_longlong;
pub type gregset_t = [greg_t; 23usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub padding: [::std::os::raw::c_ushort; 3usize],
}
#[test]
fn bindgen_test_layout__libc_fpxreg() {
    assert_eq!(
        ::std::mem::size_of::<_libc_fpxreg>(),
        16usize,
        concat!("Size of: ", stringify!(_libc_fpxreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_libc_fpxreg>(),
        2usize,
        concat!("Alignment of ", stringify!(_libc_fpxreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpxreg>())).significand as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpxreg),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpxreg>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpxreg),
            "::",
            stringify!(exponent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpxreg>())).padding as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpxreg),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[test]
fn bindgen_test_layout__libc_xmmreg() {
    assert_eq!(
        ::std::mem::size_of::<_libc_xmmreg>(),
        16usize,
        concat!("Size of: ", stringify!(_libc_xmmreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_libc_xmmreg>(),
        4usize,
        concat!("Alignment of ", stringify!(_libc_xmmreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_xmmreg>())).element as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_xmmreg),
            "::",
            stringify!(element)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_libc_fpxreg; 8usize],
    pub _xmm: [_libc_xmmreg; 16usize],
    pub padding: [__uint32_t; 24usize],
}
#[test]
fn bindgen_test_layout__libc_fpstate() {
    assert_eq!(
        ::std::mem::size_of::<_libc_fpstate>(),
        512usize,
        concat!("Size of: ", stringify!(_libc_fpstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_libc_fpstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_libc_fpstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).cwd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).swd as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(swd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).ftw as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(ftw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).fop as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(fop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).rip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).rdp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(rdp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).mxcsr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).mxcr_mask as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(mxcr_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>()))._st as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(_st)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>()))._xmm as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(_xmm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).padding as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(padding)
        )
    );
}
pub type fpregset_t = *mut _libc_fpstate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mcontext_t {
    pub gregs: gregset_t,
    pub fpregs: fpregset_t,
    pub __reserved1: [::std::os::raw::c_ulonglong; 8usize],
}
#[test]
fn bindgen_test_layout_mcontext_t() {
    assert_eq!(
        ::std::mem::size_of::<mcontext_t>(),
        256usize,
        concat!("Size of: ", stringify!(mcontext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mcontext_t>(),
        8usize,
        concat!("Alignment of ", stringify!(mcontext_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).gregs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(gregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).fpregs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(fpregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).__reserved1 as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(__reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucontext {
    pub uc_flags: ::std::os::raw::c_ulong,
    pub uc_link: *mut ucontext,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
    pub uc_sigmask: __sigset_t,
    pub __fpregs_mem: _libc_fpstate,
}
#[test]
fn bindgen_test_layout_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<ucontext>(),
        936usize,
        concat!("Size of: ", stringify!(ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext>())).uc_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext>())).uc_link as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext>())).uc_stack as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext>())).uc_mcontext as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext>())).uc_sigmask as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext>())).__fpregs_mem as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext),
            "::",
            stringify!(__fpregs_mem)
        )
    );
}
pub type ucontext_t = ucontext;
extern "C" {
    pub fn sigstack(__ss: *mut sigstack, __oss: *mut sigstack) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaltstack(__ss: *const sigaltstack, __oss: *mut sigaltstack) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_sigmask(
        __how: ::std::os::raw::c_int,
        __newmask: *const __sigset_t,
        __oldmask: *mut __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_kill(
        __threadid: pthread_t,
        __signo: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmin() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmax() -> ::std::os::raw::c_int;
}
pub const M0_THREAD_NAME_LEN: ::std::os::raw::c_uint = 16;
#[doc = "@addtogroup thread Thread"]
#[doc = ""]
#[doc = "<b>User space m0_thread implementation</b>"]
#[doc = ""]
#[doc = "User space implementation is straight-forwardly based on POSIX thread"]
#[doc = "interface."]
#[doc = ""]
#[doc = "@see m0_thread"]
#[doc = ""]
#[doc = "@{"]
pub type _bindgen_ty_31 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_thread_handle {
    pub h_id: pthread_t,
}
#[test]
fn bindgen_test_layout_m0_thread_handle() {
    assert_eq!(
        ::std::mem::size_of::<m0_thread_handle>(),
        8usize,
        concat!("Size of: ", stringify!(m0_thread_handle))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_thread_handle>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_thread_handle))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_handle>())).h_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_handle),
            "::",
            stringify!(h_id)
        )
    );
}
#[doc = " User space thread-local storage."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_thread_arch_tls {
    #[doc = " Non-zero iff the thread is in awkward context."]
    pub tat_awkward: u32,
    #[doc = " Stack context/environment, saved with setjmp(3)."]
    pub tat_jmp: *mut jmp_buf,
}
#[test]
fn bindgen_test_layout_m0_thread_arch_tls() {
    assert_eq!(
        ::std::mem::size_of::<m0_thread_arch_tls>(),
        16usize,
        concat!("Size of: ", stringify!(m0_thread_arch_tls))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_thread_arch_tls>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_thread_arch_tls))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_arch_tls>())).tat_awkward as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_arch_tls),
            "::",
            stringify!(tat_awkward)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_arch_tls>())).tat_jmp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_arch_tls),
            "::",
            stringify!(tat_jmp)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sem_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_sem_t() {
    assert_eq!(
        ::std::mem::size_of::<sem_t>(),
        32usize,
        concat!("Size of: ", stringify!(sem_t))
    );
    assert_eq!(
        ::std::mem::align_of::<sem_t>(),
        8usize,
        concat!("Alignment of ", stringify!(sem_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sem_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sem_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sem_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sem_t),
            "::",
            stringify!(__align)
        )
    );
}
extern "C" {
    pub fn sem_init(
        __sem: *mut sem_t,
        __pshared: ::std::os::raw::c_int,
        __value: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_destroy(__sem: *mut sem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_open(
        __name: *const ::std::os::raw::c_char,
        __oflag: ::std::os::raw::c_int,
        ...
    ) -> *mut sem_t;
}
extern "C" {
    pub fn sem_close(__sem: *mut sem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_unlink(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_wait(__sem: *mut sem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_timedwait(__sem: *mut sem_t, __abstime: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_trywait(__sem: *mut sem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_post(__sem: *mut sem_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sem_getvalue(
        __sem: *mut sem_t,
        __sval: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[doc = "@addtogroup semaphore"]
#[doc = ""]
#[doc = "<b>User space semaphore.</b>"]
#[doc = "@{"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_semaphore {
    pub s_sem: sem_t,
}
#[test]
fn bindgen_test_layout_m0_semaphore() {
    assert_eq!(
        ::std::mem::size_of::<m0_semaphore>(),
        32usize,
        concat!("Size of: ", stringify!(m0_semaphore))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_semaphore>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_semaphore))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_semaphore>())).s_sem as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_semaphore),
            "::",
            stringify!(s_sem)
        )
    );
}
extern "C" {
    pub fn m0_semaphore_init(
        semaphore: *mut m0_semaphore,
        value: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_semaphore_fini(semaphore: *mut m0_semaphore);
}
extern "C" {
    #[doc = " Downs the semaphore (P-operation)."]
    pub fn m0_semaphore_down(semaphore: *mut m0_semaphore);
}
extern "C" {
    #[doc = " Ups the semaphore (V-operation)."]
    pub fn m0_semaphore_up(semaphore: *mut m0_semaphore);
}
extern "C" {
    #[doc = "Tries to down a semaphore without blocking."]
    #[doc = ""]
    #[doc = "Returns true iff the P-operation succeeded without blocking."]
    pub fn m0_semaphore_trydown(semaphore: *mut m0_semaphore) -> bool;
}
extern "C" {
    #[doc = " Brings down the semaphore to 0."]
    pub fn m0_semaphore_drain(semaphore: *mut m0_semaphore);
}
extern "C" {
    #[doc = "Returns the number of times a P-operation could be executed without blocking."]
    #[doc = ""]
    #[doc = "@note the return value might, generally, be invalid by the time"]
    #[doc = "m0_semaphore_value() returns."]
    #[doc = ""]
    #[doc = "@note that the parameter is not const. This is because of POSIX"]
    #[doc = "sem_getvalue() prototype."]
    pub fn m0_semaphore_value(semaphore: *mut m0_semaphore) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = "Downs the semaphore, blocking for not longer than the (absolute) timeout"]
    #[doc = "given."]
    #[doc = ""]
    #[doc = "@note this call with cause the thread to wait on semaphore in"]
    #[doc = "non-interruptable state: signals won't preempt it."]
    #[doc = "Use it to wait for events that are expected to arrive in a"]
    #[doc = "\"short time\"."]
    #[doc = ""]
    #[doc = "@param abs_timeout absolute time since Epoch (00:00:00, 1 January 1970)"]
    #[doc = "@return true if P-operation succeed immediately or before timeout;"]
    #[doc = "@return false otherwise."]
    #[doc = ""]
    pub fn m0_semaphore_timeddown(semaphore: *mut m0_semaphore, abs_timeout: m0_time_t) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0 {
    _unused: [u8; 0],
}
#[doc = " Thread-local storage."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_thread_tls {
    #[doc = " m0 instance this thread belong to."]
    pub tls_m0_instance: *mut m0,
    #[doc = " Platform specific part of tls. Defined in lib/PLATFORM/thread.h."]
    pub tls_arch: m0_thread_arch_tls,
    pub tls_addb2_mach: *mut m0_addb2_mach,
    pub tls_self: *mut m0_thread,
    pub tls_clock: m0_addb2_sensor,
}
#[test]
fn bindgen_test_layout_m0_thread_tls() {
    assert_eq!(
        ::std::mem::size_of::<m0_thread_tls>(),
        88usize,
        concat!("Size of: ", stringify!(m0_thread_tls))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_thread_tls>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_thread_tls))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_tls>())).tls_m0_instance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_tls),
            "::",
            stringify!(tls_m0_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_tls>())).tls_arch as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_tls),
            "::",
            stringify!(tls_arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_tls>())).tls_addb2_mach as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_tls),
            "::",
            stringify!(tls_addb2_mach)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_tls>())).tls_self as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_tls),
            "::",
            stringify!(tls_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread_tls>())).tls_clock as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread_tls),
            "::",
            stringify!(tls_clock)
        )
    );
}
pub const m0_thread_state_TS_PARKED: m0_thread_state = 0;
pub const m0_thread_state_TS_RUNNING: m0_thread_state = 1;
#[doc = "Thread states used to validate thread interface usage."]
#[doc = ""]
#[doc = "@see m0_thread"]
pub type m0_thread_state = ::std::os::raw::c_uint;
#[doc = "Control block for a thread."]
#[doc = ""]
#[doc = "<b>States</b>"]
#[doc = ""]
#[doc = "A thread control block can be in one of the following states:"]
#[doc = ""]
#[doc = "@li PARKED: thread is not yet started or has been joined already. In this"]
#[doc = "state m0_thread::t_func is NULL;"]
#[doc = ""]
#[doc = "@li RUNNING: the thread started execution of m0_thread::t_func function, but"]
#[doc = "hasn't yet been joined. Note that the thread can be in this state after"]
#[doc = "return from m0_thread::t_func."]
#[doc = ""]
#[doc = "<b>Concurrency control</b>"]
#[doc = ""]
#[doc = "A user is responsible for serialising access to a control block. For example,"]
#[doc = "there should be no concurrent calls to m0_thread_init() or m0_thread_join()"]
#[doc = "for the same m0_thread."]
#[doc = ""]
#[doc = "<b>Liveness</b>"]
#[doc = ""]
#[doc = "Implementation only accesses control block as part of explicit calls to"]
#[doc = "m0_thread interface functions. A user is free to destroy the control block at"]
#[doc = "any moment, except for the possible resource leak in the case of running (and"]
#[doc = "not yet joined) thread."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_thread {
    pub t_state: m0_thread_state,
    pub t_h: m0_thread_handle,
    pub t_init: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub t_func: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub t_arg: *mut ::std::os::raw::c_void,
    pub t_wait: m0_semaphore,
    pub t_initrc: ::std::os::raw::c_int,
    pub t_tls: m0_thread_tls,
    pub t_namebuf: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_m0_thread() {
    assert_eq!(
        ::std::mem::size_of::<m0_thread>(),
        184usize,
        concat!("Size of: ", stringify!(m0_thread))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_thread>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_thread))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_h as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_init as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_func as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_arg as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_wait as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_initrc as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_initrc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_tls as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_tls)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_thread>())).t_namebuf as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_thread),
            "::",
            stringify!(t_namebuf)
        )
    );
}
extern "C" {
    #[doc = "Internal helper for m0_thread_init() that creates the user or kernel thread"]
    #[doc = "after the m0_thread q has been initialised."]
    #[doc = "@pre q->t_state == TS_RUNNING"]
    #[doc = "@retval 0 thread created"]
    #[doc = "@retval -errno failed"]
    pub fn m0_thread_init_impl(
        q: *mut m0_thread,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Threads created by m0_thread_init_impl execute this function to"]
    #[doc = "perform common bookkeeping, executing t->t_init if appropriate,"]
    #[doc = "and then executing t->t_func."]
    #[doc = "@pre t->t_state == TS_RUNNING && t->t_initrc == 0"]
    #[doc = "@param t a m0_thread*, passed as void* to be compatible with"]
    #[doc = "pthread_create function argument."]
    #[doc = "@retval NULL"]
    pub fn m0_thread_trampoline(t: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = "Creates a new thread."]
    #[doc = ""]
    #[doc = "If \"init\" is not NULL, the created thread starts execution by calling"]
    #[doc = "(*init)(arg). If this call returns non-zero, thread exits and"]
    #[doc = "m0_thread_init() returns the value returned by \"init\"."]
    #[doc = ""]
    #[doc = "Otherwise (or in the case where \"init\" is NULL), m0_thread_init() returns 0"]
    #[doc = "and the thread calls (*func)(arg) and exits when this call completes."]
    #[doc = ""]
    #[doc = "The namefmt and its arguments are used to name the thread.  The formatted"]
    #[doc = "name is truncated to M0_THREAD_NAME_LEN characters (based on TASK_COMM_LEN)."]
    #[doc = ""]
    #[doc = "@note it is possible that after successful return from m0_thread_init() the"]
    #[doc = "thread hasn't yet entered \"func\" code, it is also possible that the thread"]
    #[doc = "has finished its execution."]
    #[doc = ""]
    #[doc = "@pre q->t_state == TS_PARKED"]
    #[doc = "@post (result != 0) == (q->t_state == TS_PARKED)"]
    #[doc = "@post (result == 0) == (q->t_state == TS_RUNNING)"]
    pub fn m0_thread_init(
        q: *mut m0_thread,
        init: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
        func: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        arg: *mut ::std::os::raw::c_void,
        namefmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Releases resources associated with the thread."]
    #[doc = ""]
    #[doc = "@pre q->t_state == TS_PARKED"]
    pub fn m0_thread_fini(q: *mut m0_thread);
}
extern "C" {
    #[doc = "Waits until the thread exits."]
    #[doc = ""]
    #[doc = "After this calls returns successfully it is guaranteed that no code would be"]
    #[doc = "ever executed by the \"q\", including instructions that touch stack or code"]
    #[doc = "pages. Note that the same effect can not be reliably achieved by the explicit"]
    #[doc = "synchronization (e.g., by signalling a condition variable at the end of a"]
    #[doc = "thread function), because the thread might be still executing instructions"]
    #[doc = "after it returns from m0_thread::t_func."]
    #[doc = ""]
    #[doc = "@pre q->t_state == TS_RUNNING"]
    #[doc = "@pre q is different from the calling thread"]
    #[doc = "@post (result == 0) == (q->t_state == TS_PARKED)"]
    #[doc = "@retval 0 thread joined (thread is terminated)"]
    #[doc = "@retval -errno failed to join, not exit status of thread"]
    pub fn m0_thread_join(q: *mut m0_thread) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Send specified signal to this thread."]
    pub fn m0_thread_signal(q: *mut m0_thread, sig: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Sets thread affinity to a given processor bitmap."]
    #[doc = ""]
    #[doc = "The user space implementation calls pthread_setaffinity_np and the kernel"]
    #[doc = "implementation modifies fields of the task_struct directly."]
    #[doc = ""]
    #[doc = "@see http://www.kernel.org/doc/man-pages/online/pages/man3/pthread_setaffinity_np.3.html"]
    #[doc = "@see lib/processor.h"]
    #[doc = "@see kthread"]
    #[doc = ""]
    #[doc = "@param q thread whose affinity is to be set (confined)"]
    #[doc = "@param processors bitmap of processors, true values are those on which the"]
    #[doc = "thread can run"]
    #[doc = "@retval 0 success"]
    #[doc = "@retval !0 failed to set affinity, -errno"]
    pub fn m0_thread_confine(
        q: *mut m0_thread,
        processors: *const m0_bitmap,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the current thread."]
    pub fn m0_thread_self() -> *mut m0_thread;
}
extern "C" {
    #[doc = " Returns thread-local storage."]
    #[doc = " @note The returned value is never NULL."]
    pub fn m0_thread_tls() -> *mut m0_thread_tls;
}
extern "C" {
    #[doc = " Initialises thread system."]
    #[doc = ""]
    #[doc = " m0_threads_init() is usually called at the early stages of Motr"]
    #[doc = " initialisation, i.e., early in m0_init()."]
    #[doc = ""]
    #[doc = " @param instance  Initial m0 instance."]
    pub fn m0_threads_init(instance: *mut m0) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_threads_fini();
}
extern "C" {
    pub fn m0_threads_once_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_threads_once_fini();
}
extern "C" {
    #[doc = " Sets the thread in awkward context."]
    pub fn m0_enter_awkward();
}
extern "C" {
    #[doc = " Resets thread from awkward context."]
    pub fn m0_exit_awkward();
}
extern "C" {
    #[doc = " Tells if executing thread is in awkward context."]
    pub fn m0_is_awkward() -> bool;
}
extern "C" {
    #[doc = " Returns \"process identifier\", depending on the architecture."]
    pub fn m0_pid() -> u64;
}
extern "C" {
    #[doc = " Returns \"process identifier\" for userspace process and 0 in the kernel."]
    #[doc = " @see m0_pid()."]
    pub fn m0_process() -> u64;
}
extern "C" {
    #[doc = " Accepts a thread as a Motr thread."]
    #[doc = ""]
    #[doc = " Motr maintains a per-thread context needed for any Motr operation. A thread"]
    #[doc = " with such a context is \"Motr thread\". A thread that calls m0_init() is a Motr"]
    #[doc = " thread. A thread created by a call to m0_thread_init() (necessarily made by a"]
    #[doc = " Motr thread) is a Motr thread."]
    #[doc = ""]
    #[doc = " To turn any other thread into a Motr thread call m0_thread_adopt() before any"]
    #[doc = " Motr call is made in the thread. m0_thread_shun() must be called before the"]
    #[doc = " thread exits."]
    #[doc = ""]
    #[doc = " \"thread\" object must be owned by the calling thread (not accessed"]
    #[doc = " concurrently by multiple threads). It must exist at least until the matching"]
    #[doc = " m0_thread_shun() call returns."]
    #[doc = ""]
    #[doc = " \"instance\" is m0 instance to which the thread belongs."]
    pub fn m0_thread_adopt(thread: *mut m0_thread, instance: *mut m0) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Discards Motr per-thread context. This is dual to m0_thread_adopt()."]
    pub fn m0_thread_shun();
}
extern "C" {
    pub fn m0_thread_arch_adopt(
        thread: *mut m0_thread,
        instance: *mut m0,
        full: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_thread_arch_shun();
}
#[doc = "@addtogroup timer"]
#[doc = ""]
#[doc = "<b>User space timer.</b>"]
#[doc = "@{"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_timer {
    #[doc = " Timer type: M0_TIMER_SOFT or M0_TIMER_HARD."]
    pub t_type: m0_timer_type,
    #[doc = " Timer triggers this callback."]
    pub t_callback: m0_timer_callback_t,
    #[doc = " User data. It is passed to m0_timer::t_callback()."]
    pub t_data: ::std::os::raw::c_ulong,
    #[doc = " Expire time in future of this timer."]
    pub t_expire: m0_time_t,
    #[doc = " Timer state.  Used in state changes checking."]
    pub t_state: m0_timer_state,
    #[doc = " Semaphore for m0_timer_stop() and user callback synchronisation."]
    pub t_cb_sync_sem: m0_semaphore,
    #[doc = " Soft timer working thread."]
    pub t_thread: m0_thread,
    #[doc = " Soft timer working thread sleeping semaphore."]
    pub t_sleep_sem: m0_semaphore,
    #[doc = " Thread is stopped by m0_timer_fini()."]
    pub t_thread_stop: bool,
    #[doc = " POSIX timer ID, returned by timer_create()."]
    pub t_ptimer: timer_t,
    #[doc = "Target thread ID for hard timer callback."]
    #[doc = "If it is 0 then signal will be sent to the process"]
    #[doc = "but not to any specific thread."]
    pub t_tid: pid_t,
}
#[test]
fn bindgen_test_layout_m0_timer() {
    assert_eq!(
        ::std::mem::size_of::<m0_timer>(),
        312usize,
        concat!("Size of: ", stringify!(m0_timer))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_timer>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_timer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_callback as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_callback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_expire as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_expire)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_state as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_cb_sync_sem as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_cb_sync_sem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_thread as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_thread)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_sleep_sem as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_sleep_sem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_thread_stop as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_thread_stop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_ptimer as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_ptimer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer>())).t_tid as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer),
            "::",
            stringify!(t_tid)
        )
    );
}
#[doc = "Item of threads ID list in locality."]
#[doc = "Used in the implementation of userspace hard timer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_timer_tid {
    pub tt_tid: pid_t,
    pub tt_linkage: m0_tlink,
    pub tt_magic: u64,
}
#[test]
fn bindgen_test_layout_m0_timer_tid() {
    assert_eq!(
        ::std::mem::size_of::<m0_timer_tid>(),
        32usize,
        concat!("Size of: ", stringify!(m0_timer_tid))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_timer_tid>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_timer_tid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_tid>())).tt_tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_tid),
            "::",
            stringify!(tt_tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_tid>())).tt_linkage as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_tid),
            "::",
            stringify!(tt_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_tid>())).tt_magic as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_tid),
            "::",
            stringify!(tt_magic)
        )
    );
}
#[doc = "Timer locality."]
#[doc = ""]
#[doc = "The signal for M0_TIMER_HARD timers will be delivered to a thread"]
#[doc = "from the locality."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_timer_locality {
    #[doc = " Lock for tlo_tids"]
    pub tlo_lock: m0_mutex,
    #[doc = " List of thread ID's, associated with this locality"]
    pub tlo_tids: m0_tl,
    #[doc = " ThreadID of next thread for round-robin timer thread selection"]
    pub tlo_rrtid: *mut m0_timer_tid,
}
#[test]
fn bindgen_test_layout_m0_timer_locality() {
    assert_eq!(
        ::std::mem::size_of::<m0_timer_locality>(),
        88usize,
        concat!("Size of: ", stringify!(m0_timer_locality))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_timer_locality>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_timer_locality))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_locality>())).tlo_lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_locality),
            "::",
            stringify!(tlo_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_locality>())).tlo_tids as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_locality),
            "::",
            stringify!(tlo_tids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_timer_locality>())).tlo_rrtid as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_timer_locality),
            "::",
            stringify!(tlo_rrtid)
        )
    );
}
extern "C" {
    pub static mut m0_timer_ops: [m0_timer_operations; 0usize];
}
extern "C" {
    pub fn m0_timers_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_timers_fini();
}
extern "C" {
    #[doc = "Init the timer data structure."]
    #[doc = ""]
    #[doc = "@param timer m0_timer structure"]
    #[doc = "@param type timer type (M0_TIMER_SOFT or M0_TIMER_HARD)"]
    #[doc = "@param loc timer locality, ignored for M0_TIMER_SOFT timers."]
    #[doc = "Can be NULL - in this case hard timer signal will be delivered"]
    #[doc = "to the process. This parameter is ignored in kernel implementation."]
    #[doc = "@param callback this callback will be triggered when timer alarms."]
    #[doc = "@param data data for the callback."]
    #[doc = "@pre callback != NULL"]
    #[doc = "@pre loc have at least one thread attached"]
    #[doc = "@post timer is not running"]
    #[doc = "@see m0_timer_locality"]
    pub fn m0_timer_init(
        timer: *mut m0_timer,
        type_: m0_timer_type,
        loc: *mut m0_timer_locality,
        callback: m0_timer_callback_t,
        data: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Start a timer."]
    #[doc = ""]
    #[doc = "@param expire absolute expiration time for timer. If this time is already"]
    #[doc = "passed, then the timer callback will be executed ASAP."]
    #[doc = "@pre m0_timer_init() successfully called."]
    #[doc = "@pre timer is not running"]
    pub fn m0_timer_start(timer: *mut m0_timer, expire: m0_time_t);
}
extern "C" {
    #[doc = "Stop a timer."]
    #[doc = ""]
    #[doc = "@pre m0_timer_init() successfully called."]
    #[doc = "@pre timer is running"]
    #[doc = "@post timer is not running"]
    #[doc = "@post callback isn't running"]
    pub fn m0_timer_stop(timer: *mut m0_timer);
}
extern "C" {
    #[doc = "Returns true iff the timer is running."]
    pub fn m0_timer_is_started(timer: *const m0_timer) -> bool;
}
extern "C" {
    #[doc = "Destroy the timer."]
    #[doc = ""]
    #[doc = "@pre m0_timer_init() for this timer was successfully called."]
    #[doc = "@pre timer is not running."]
    pub fn m0_timer_fini(timer: *mut m0_timer);
}
extern "C" {
    #[doc = "Execute timer callback."]
    #[doc = ""]
    #[doc = "It is used in timer implementation."]
    pub fn m0_timer_callback_execute(timer: *mut m0_timer);
}
extern "C" {
    #[doc = "Init timer locality."]
    #[doc = "@post timer locality is empty"]
    pub fn m0_timer_locality_init(loc: *mut m0_timer_locality);
}
extern "C" {
    #[doc = "Fini timer locality."]
    #[doc = ""]
    #[doc = "@pre m0_timer_locality_init() successfully called."]
    #[doc = "@pre timer locality is empty"]
    pub fn m0_timer_locality_fini(loc: *mut m0_timer_locality);
}
extern "C" {
    #[doc = "Add current thread to the list of threads in locality."]
    #[doc = ""]
    #[doc = "@pre m0_timer_locality_init() successfully called."]
    #[doc = "@pre current thread is not attached to locality."]
    #[doc = "@post current thread is attached to locality."]
    pub fn m0_timer_thread_attach(loc: *mut m0_timer_locality) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Remove current thread from the list of threads in locality."]
    #[doc = "Current thread must be in this list."]
    #[doc = ""]
    #[doc = "@pre m0_timer_locality_init() successfully called."]
    #[doc = "@pre current thread is attached to locality."]
    #[doc = "@post current thread is not attached to locality."]
    pub fn m0_timer_thread_detach(loc: *mut m0_timer_locality);
}
#[doc = "Clink call-back called when event is delivered to the clink. The call-back"]
#[doc = "returns true iff the event has been \"consumed\". Otherwise, the event will"]
#[doc = "remain pending on the clink for future consumption by the waiting"]
#[doc = "interfaces."]
pub type m0_chan_cb_t = ::std::option::Option<unsafe extern "C" fn(link: *mut m0_clink) -> bool>;
#[doc = "@defgroup chan Waiting channels"]
#[doc = ""]
#[doc = "Waiting channel."]
#[doc = ""]
#[doc = "A channel (m0_chan) is a stream of asynchronous events that a channel user"]
#[doc = "can wait or register a call-back for."]
#[doc = ""]
#[doc = "A clink (m0_clink) is a record of interest in events on a particular"]
#[doc = "channel. A user adds a clink to a channel and appearance of new events in"]
#[doc = "the stream is recorded in the clink."]
#[doc = ""]
#[doc = "There are two interfaces related to channels:"]
#[doc = ""]
#[doc = "- producer interface. It consists of m0_chan_signal(), m0_clink_signal()"]
#[doc = "and m0_chan_broadcast() functions. These functions are called to"]
#[doc = "declare that new asynchronous event happened in the stream."]
#[doc = ""]
#[doc = "- consumer interface. It consists of m0_clink_add(), m0_clink_del(),"]
#[doc = "m0_chan_wait() and m0_chan_trywait() functions."]
#[doc = ""]
#[doc = "When a producer declares an event on a channel, this event is delivered. If"]
#[doc = "event is a broadcast (m0_chan_broadcast()) it is delivered to all clinks"]
#[doc = "registered with the channel. If event is a signal (m0_chan_signal()) it is"]
#[doc = "delivered to a single clink (if any) registered with the channel. Clinks for"]
#[doc = "delivery of consecutive signals are selected in a round-robin manner."]
#[doc = ""]
#[doc = "A special m0_clink_signal() function is provided to signal a particular"]
#[doc = "clink. m0_clink_signal() delivers a signal to its argument clink. This"]
#[doc = "function does not take any locks and is designed to be used in \"awkward\""]
#[doc = "contexts, like interrupt handler or timer call-backs, where blocking on a"]
#[doc = "lock is not allowed. Use sparingly."]
#[doc = ""]
#[doc = "The method of delivery depends on the clink interface used (m0_clink). If"]
#[doc = "clink has a call-back, the delivery starts with calling this call-back. If a"]
#[doc = "clink has no call-back or the call-back returns false, the delivered event"]
#[doc = "becomes pending on the clink. Pending events can be consumed by calls to"]
#[doc = "m0_chan_wait(), m0_chan_timedwait() and m0_chan_trywait()."]
#[doc = ""]
#[doc = "<b>Filtered wake-ups.</b>"]
#[doc = ""]
#[doc = "By returning true from a call-back, it is possible to \"filter\" some events"]
#[doc = "out and avoid potentially expensive thread wake-up. A typical use case for"]
#[doc = "this is the following:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct wait_state {"]
#[doc = "struct m0_clink f_clink;"]
#[doc = "..."]
#[doc = "};"]
#[doc = ""]
#[doc = "static bool callback(struct m0_clink *clink)"]
#[doc = "{"]
#[doc = "struct wait_state *f ="]
#[doc = "container_of(clink, struct wait_state, f_clink);"]
#[doc = "return !condition_is_right(f);"]
#[doc = "}"]
#[doc = ""]
#[doc = "{"]
#[doc = "struct wait_state g;"]
#[doc = ""]
#[doc = "m0_clink_init(&g.f_clink, &callback);"]
#[doc = "m0_clink_add(chan, &g.f_clink);"]
#[doc = "..."]
#[doc = "while (!condition_is_right(&g)) {"]
#[doc = "m0_chan_wait(&g.f_clink);"]
#[doc = "}"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "The idea behind this idiom is that the call-back is called in the same"]
#[doc = "context where the event is declared and it is much cheaper to test whether a"]
#[doc = "condition is right than to wake up a waiting thread that would check this"]
#[doc = "and go back to sleep if it is not."]
#[doc = ""]
#[doc = "<b>Multiple channels.</b>"]
#[doc = ""]
#[doc = "It is possible to wait for an event to be announced on a channel from a"]
#[doc = "set. To this end, first a clink is created as usual. Then, additional"]
#[doc = "(unintialised) clinks are attached to the first by a call to"]
#[doc = "m0_clink_attach(), forming a \"clink group\" consisting of the original clink"]
#[doc = "and all clinks attached. Clinks from the group can be registered with"]
#[doc = "multiple (or the same) channels. Events announced on any channel are"]
#[doc = "delivered to all clinks in the group."]
#[doc = ""]
#[doc = "Groups are used as following:"]
#[doc = ""]
#[doc = "- initialise a \"group head\" clink;"]
#[doc = ""]
#[doc = "- attach other clinks to the group, without initialising them;"]
#[doc = ""]
#[doc = "- register the group clinks with their channels, starting with the head;"]
#[doc = ""]
#[doc = "- to wait for an event on any channel, wait on the group head."]
#[doc = ""]
#[doc = "- call-backs can be used for event filtering on any channel as usual;"]
#[doc = ""]
#[doc = "- de-register the clinks, head last."]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct m0_clink cl0;"]
#[doc = "struct m0_clink cl1;"]
#[doc = ""]
#[doc = "m0_clink_init(&cl0, call_back0);"]
#[doc = "m0_clink_attach(&cl1, &cl0, call_back1);"]
#[doc = ""]
#[doc = "m0_clink_add(chan0, &cl0);"]
#[doc = "m0_clink_add(chan1, &cl1);"]
#[doc = ""]
#[doc = "m0_chan_wait(&cl0);"]
#[doc = ""]
#[doc = "m0_clink_del(&cl1);"]
#[doc = "m0_clink_del(&cl0);"]
#[doc = ""]
#[doc = "m0_clink_fini(&cl0);"]
#[doc = "m0_clink_fini(&cl1);"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "@note An interface similar to m0_chan was a part of historical UNIX kernel"]
#[doc = "implementations. It is where \"CHAN\" field in ps(1) output comes from."]
#[doc = ""]
#[doc = "@todo The next scalability improvement is to allow m0_chan to use an"]
#[doc = "externally specified mutex instead of a built-in one. This would allow"]
#[doc = "larger state machines with multiple channels to operate under fewer locks,"]
#[doc = "reducing coherency bus traffic."]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_chan {
    #[doc = " Protecting lock, should be provided by user."]
    pub ch_guard: *mut m0_mutex,
    #[doc = " List of registered clinks."]
    pub ch_links: m0_tl,
    #[doc = " Number of clinks in m0_chan::ch_links. This is used to speed up"]
    #[doc = "m0_chan_broadcast()."]
    pub ch_waiters: u32,
    pub ch_addb2: *mut m0_chan_addb2,
}
#[test]
fn bindgen_test_layout_m0_chan() {
    assert_eq!(
        ::std::mem::size_of::<m0_chan>(),
        48usize,
        concat!("Size of: ", stringify!(m0_chan))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_chan>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_chan))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan>())).ch_guard as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan),
            "::",
            stringify!(ch_guard)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan>())).ch_links as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan),
            "::",
            stringify!(ch_links)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan>())).ch_waiters as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan),
            "::",
            stringify!(ch_waiters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan>())).ch_addb2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan),
            "::",
            stringify!(ch_addb2)
        )
    );
}
#[doc = "A record of interest in events on a stream."]
#[doc = ""]
#[doc = "A clink records the appearance of events in the stream."]
#[doc = ""]
#[doc = "There are two ways to use a clink:"]
#[doc = ""]
#[doc = "@li an asynchronous call-back can be specified as an argument to clink"]
#[doc = "constructor m0_clink_init(). This call-back is called when an event happens"]
#[doc = "in the channel the clink is registered with. It is guaranteed that"]
#[doc = "a call-back is executed in the same context where event producer declared"]
#[doc = "new event. A per-channel mutex m0_chan::ch_guard is held while call-backs"]
#[doc = "are executed (except the case when m0_clink_signal() is used by producer)."]
#[doc = ""]
#[doc = "@li once a clink is registered with a channel, it is possible to wait until"]
#[doc = "an event happens by calling m0_chan_wait()."]
#[doc = ""]
#[doc = "See the \"Filtered wake-ups\" section in the top-level comment on how to"]
#[doc = "combine call-backs with waiting."]
#[doc = ""]
#[doc = "<b>Concurrency control</b>"]
#[doc = ""]
#[doc = "A user must guarantee that at most one thread waits on a"]
#[doc = "clink. Synchronization between call-backs, waits and clink destruction is"]
#[doc = "also up to user."]
#[doc = ""]
#[doc = "A user owns a clink before call to m0_clink_add() and after return from the"]
#[doc = "m0_clink_del() call. At any other time clink can be concurrently accessed by"]
#[doc = "the implementation."]
#[doc = ""]
#[doc = "<b>Liveness</b>"]
#[doc = ""]
#[doc = "A user is free to dispose a clink whenever it owns the latter."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_clink {
    #[doc = " Channel this clink is registered with."]
    pub cl_chan: *mut m0_chan,
    #[doc = " Call-back to be called when event is declared."]
    pub cl_cb: m0_chan_cb_t,
    #[doc = " The head of the clink group."]
    pub cl_group: *mut m0_clink,
    #[doc = " Linkage into m0_chan::ch_links"]
    pub cl_linkage: m0_tlink,
    pub cl_wait: m0_semaphore,
    pub cl_is_oneshot: bool,
    pub cl_magic: u64,
}
#[test]
fn bindgen_test_layout_m0_clink() {
    assert_eq!(
        ::std::mem::size_of::<m0_clink>(),
        88usize,
        concat!("Size of: ", stringify!(m0_clink))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_clink>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_clink))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_chan as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_chan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_cb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_group as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_group)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_linkage as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_wait as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_is_oneshot as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_is_oneshot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_clink>())).cl_magic as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_clink),
            "::",
            stringify!(cl_magic)
        )
    );
}
extern "C" {
    pub fn m0_chan_init(chan: *mut m0_chan, ch_guard: *mut m0_mutex);
}
extern "C" {
    pub fn m0_chan_fini(chan: *mut m0_chan);
}
extern "C" {
    pub fn m0_chan_fini_lock(chan: *mut m0_chan);
}
extern "C" {
    #[doc = "Notifies a clink currently registered with the channel that a new event"]
    #[doc = "happened."]
    #[doc = ""]
    #[doc = "@pre m0_chan_is_locked(chan)"]
    #[doc = "@see m0_chan_broadcast()"]
    pub fn m0_chan_signal(chan: *mut m0_chan);
}
extern "C" {
    #[doc = "Calls m0_chan_signal() with ch_guard locked."]
    pub fn m0_chan_signal_lock(chan: *mut m0_chan);
}
extern "C" {
    #[doc = "Notifies all clinks currently registered with the channel that a new event"]
    #[doc = "happened."]
    #[doc = ""]
    #[doc = "No guarantees about behaviour in the case when clinks are added or removed"]
    #[doc = "while m0_chan_broadcast() is running."]
    #[doc = ""]
    #[doc = "If clinks with call-backs (m0_clink::cl_cb) are registered with the channel"]
    #[doc = "at the time of this call, the call-backs are run to completion as part of"]
    #[doc = "broadcast."]
    #[doc = ""]
    #[doc = "@pre m0_chan_is_locked(chan)"]
    #[doc = "@see m0_chan_signal()"]
    pub fn m0_chan_broadcast(chan: *mut m0_chan);
}
extern "C" {
    #[doc = "Calls m0_chan_broadcast() with ch_guard locked."]
    pub fn m0_chan_broadcast_lock(chan: *mut m0_chan);
}
extern "C" {
    #[doc = "Notifies a given clink that a new event happened."]
    #[doc = ""]
    #[doc = "This function takes no locks."]
    #[doc = ""]
    #[doc = "m0_chan_signal() should be used instead, unless the event is announced in a"]
    #[doc = "context where blocking is not allowed."]
    #[doc = ""]
    #[doc = "@see m0_chan_signal()"]
    #[doc = "@see m0_chan_broadcast()"]
    pub fn m0_clink_signal(clink: *mut m0_clink);
}
extern "C" {
    #[doc = "True iff there are clinks registered with the chan."]
    #[doc = ""]
    #[doc = "@note the return value of this function can, in general, be obsolete by the"]
    #[doc = "time it returns. It is up to the user to provide concurrency control"]
    #[doc = "mechanisms that would make this function useful."]
    pub fn m0_chan_has_waiters(chan: *mut m0_chan) -> bool;
}
extern "C" {
    pub fn m0_clink_init(link: *mut m0_clink, cb: m0_chan_cb_t);
}
extern "C" {
    pub fn m0_clink_fini(link: *mut m0_clink);
}
extern "C" {
    #[doc = "Attaches @link to a clink group. @group is the original clink in the group."]
    pub fn m0_clink_attach(link: *mut m0_clink, group: *mut m0_clink, cb: m0_chan_cb_t);
}
extern "C" {
    #[doc = "Registers the clink with the channel."]
    #[doc = ""]
    #[doc = "@pre m0_chan_is_locked(chan)"]
    #[doc = "@pre !m0_clink_is_armed(link)"]
    #[doc = "@post m0_clink_is_armed(link)"]
    pub fn m0_clink_add(chan: *mut m0_chan, link: *mut m0_clink);
}
extern "C" {
    #[doc = "Un-registers the clink from the channel."]
    #[doc = ""]
    #[doc = "@pre m0_chan_is_locked(chan)"]
    #[doc = "@pre   m0_clink_is_armed(link)"]
    #[doc = "@post !m0_clink_is_armed(link)"]
    pub fn m0_clink_del(link: *mut m0_clink);
}
extern "C" {
    #[doc = "Calls m0_clink_add() with ch_guard locked."]
    pub fn m0_clink_add_lock(chan: *mut m0_chan, link: *mut m0_clink);
}
extern "C" {
    #[doc = "Calls m0_clink_del() with ch_guard locked."]
    pub fn m0_clink_del_lock(link: *mut m0_clink);
}
extern "C" {
    #[doc = "True iff the clink is registered with a channel."]
    pub fn m0_clink_is_armed(link: *const m0_clink) -> bool;
}
extern "C" {
    #[doc = "If clink armed, deletes the one from its channel. Otherwise, does nothing."]
    #[doc = ""]
    #[doc = "@pre !m0_chan_is_locked(link->cl_chan)"]
    pub fn m0_clink_cleanup(link: *mut m0_clink);
}
extern "C" {
    #[doc = "If clink armed, deletes the one from its channel. Otherwise, does nothing."]
    #[doc = ""]
    #[doc = "@pre m0_chan_is_locked(link->cl_chan)"]
    pub fn m0_clink_cleanup_locked(link: *mut m0_clink);
}
extern "C" {
    #[doc = "Returns when there is an event pending in the clink. The event is consumed"]
    #[doc = "before the call returns."]
    #[doc = ""]
    #[doc = "Note that this implies that if an event happened after the clink has been"]
    #[doc = "registered (by a call to m0_clink_add()) and before call to m0_chan_wait(),"]
    #[doc = "the latter returns immediately."]
    #[doc = ""]
    #[doc = "User must guarantee that no more than one thread waits on the clink."]
    pub fn m0_chan_wait(link: *mut m0_clink);
}
extern "C" {
    #[doc = "True there is an event pending in the clink. When this function returns true,"]
    #[doc = "the event is consumed, exactly like if m0_chan_wait() were called instead."]
    pub fn m0_chan_trywait(link: *mut m0_clink) -> bool;
}
extern "C" {
    #[doc = "This is the same as m0_chan_wait, except that it has an expire time. If the"]
    #[doc = "time expires before event is pending, this function will return false."]
    #[doc = ""]
    #[doc = "@param abs_timeout absolute time since Epoch (00:00:00, 1 January 1970)"]
    #[doc = "@return true if the there is an event pending before timeout;"]
    #[doc = "@return false if there is no events pending and timeout expires;"]
    pub fn m0_chan_timedwait(link: *mut m0_clink, abs_timeout: m0_time_t) -> bool;
}
extern "C" {
    #[doc = "Locks ch_guard."]
    pub fn m0_chan_lock(ch: *mut m0_chan);
}
extern "C" {
    #[doc = "Unlocks ch_guard."]
    pub fn m0_chan_unlock(ch: *mut m0_chan);
}
extern "C" {
    #[doc = "Tests ch_guard for being locked."]
    pub fn m0_chan_is_locked(ch: *const m0_chan) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_chan_addb2 {
    pub ca_wait: u64,
    pub ca_cb: u64,
    pub ca_wait_hist: m0_addb2_hist,
    pub ca_cb_hist: m0_addb2_hist,
    pub ca_queue_hist: m0_addb2_hist,
}
#[test]
fn bindgen_test_layout_m0_chan_addb2() {
    assert_eq!(
        ::std::mem::size_of::<m0_chan_addb2>(),
        544usize,
        concat!("Size of: ", stringify!(m0_chan_addb2))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_chan_addb2>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_chan_addb2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan_addb2>())).ca_wait as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan_addb2),
            "::",
            stringify!(ca_wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan_addb2>())).ca_cb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan_addb2),
            "::",
            stringify!(ca_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan_addb2>())).ca_wait_hist as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan_addb2),
            "::",
            stringify!(ca_wait_hist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan_addb2>())).ca_cb_hist as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan_addb2),
            "::",
            stringify!(ca_cb_hist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_chan_addb2>())).ca_queue_hist as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_chan_addb2),
            "::",
            stringify!(ca_queue_hist)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_state_stats {
    _unused: [u8; 0],
}
#[doc = "@defgroup sm State machine"]
#[doc = ""]
#[doc = "This modules defines interfaces to functionality common to typical"]
#[doc = "non-blocking state machines extensively used by Motr."]
#[doc = ""]
#[doc = "The main difference between \"state machine\" (non-blocking) code and"]
#[doc = "\"threaded\" (blocking) code is that the latter blocks waiting for some events"]
#[doc = "while having some computational state stored in the \"native\" C language stack"]
#[doc = "(in the form of automatic variables allocated across the call-chain). Because"]
#[doc = "of this the thread must remain dedicated to the same threaded activity not"]
#[doc = "only during actual \"computation\", when processor is actively used, but also"]
#[doc = "for the duration of wait. In many circumstances this is too expensive,"]
#[doc = "because threads are heavy objects."]
#[doc = ""]
#[doc = "Non-blocking code, on the other hand, packs all its state into a special"]
#[doc = "data-structures before some potential blocking points and unpacks it after"]
#[doc = "the event of interest occurs. This allows the same thread to be re-used for"]
#[doc = "multiple non-blocking computations."]
#[doc = ""]
#[doc = "Which blocking points deserve packing-unpacking depends on"]
#[doc = "circumstances. Long-term waits for network or storage communication are prime"]
#[doc = "candidates for non-blocking handling. Memory accesses, which can incur"]
#[doc = "blocking page faults in a user space process are probably too ubiquitous for"]
#[doc = "this. Memory allocations and data-structure locks fall into an intermediate"]
#[doc = "group."]
#[doc = ""]
#[doc = "This module defines data-structures and interfaces to handle common"]
#[doc = "non-blocking state-machine functionality:"]
#[doc = ""]
#[doc = "- state tracking and state transitions;"]
#[doc = ""]
#[doc = "- concurrency;"]
#[doc = ""]
#[doc = "- interaction between a state machine and external world (both"]
#[doc = "non-blocking and threaded);"]
#[doc = ""]
#[doc = "- accounting and statistics collection."]
#[doc = ""]
#[doc = "<b>State and transitions.</b>"]
#[doc = ""]
#[doc = "State machine state is recorded in m0_sm::sm_state. This is supposed to be a"]
#[doc = "relatively coarse-grained high level state, broadly determining state machine"]
#[doc = "behaviour. An instance of m0_sm will typically be embedded into a larger"]
#[doc = "structure containing fields fully determining state machine behaviour. Each"]
#[doc = "state comes with a description. All descriptions for a particular state"]
#[doc = "machine are packed into a m0_sm_conf::scf_state[] array."]
#[doc = ""]
#[doc = "State machine is transferred from one state to another by a call to"]
#[doc = "m0_sm_state_set() (or its variant m0_sm_fail()) or via \"chained\" transitions,"]
#[doc = "see below."]
#[doc = ""]
#[doc = "<b>Concurrency.</b>"]
#[doc = ""]
#[doc = "State machine is a part of a state machine group (m0_sm_group). All state"]
#[doc = "machines in a group use group's mutex to serialise their state"]
#[doc = "transitions. One possible scenario is to have a group for all state machines"]
#[doc = "associated with a given locality (m0_fom_locality). Alternatively a"]
#[doc = "group-per-machine can be used."]
#[doc = ""]
#[doc = "<b>Interaction.</b>"]
#[doc = ""]
#[doc = "The only \"output\" event that a state machine communicates to the external"]
#[doc = "world is (from this module's point of view) its state transition. State"]
#[doc = "transitions are announced on a per-machine channel (m0_sm::sm_chan). This"]
#[doc = "mechanism works both for threaded and non-blocking event consumers. The"]
#[doc = "formers use m0_sm_timedwait() to wait until the state machine reaches"]
#[doc = "desirable state, the latter register a clink with m0_sm::sm_chan."]
#[doc = ""]
#[doc = "\"Input\" events cause state transitions. Typical examples of such events are:"]
#[doc = "completion of a network or storage communication, timeout or a state"]
#[doc = "transition in a different state machine. Such events often happen in"]
#[doc = "\"awkward\" context: signal and interrupt handlers, timer call-backs and"]
#[doc = "similar. Acquiring the group's mutex, necessary for state transition in such"]
#[doc = "places is undesirable for multiple reasons:"]
#[doc = ""]
#[doc = "- to avoid self-deadlock in a case where an interrupt or signal is"]
#[doc = "serviced by a thread that already holds the mutex, the latter must be"]
#[doc = "made \"async-safe\", which is quite expensive;"]
#[doc = ""]
#[doc = "- implementation of a module that provides a call-back must take into"]
#[doc = "account the possibility of the call-back blocking waiting for a"]
#[doc = "mutex. This is also quite expensive;"]
#[doc = ""]
#[doc = "- locking order dependencies arise between otherwise unrelated"]
#[doc = "components;"]
#[doc = ""]
#[doc = "- all these issues are exasperated in a situation where state transition"]
#[doc = "must take additional locks, which it often does."]
#[doc = ""]
#[doc = "The solution to these problems comes from operating system kernels design,"]
#[doc = "see the AST section below."]
#[doc = ""]
#[doc = "There are 2 ways to implement state machine input event processing:"]
#[doc = ""]
#[doc = "- \"external\" state transition, where input event processing is done"]
#[doc = "outside of state machine, and m0_sm_state_set() is called to record"]
#[doc = "state change:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct foo {"]
#[doc = "struct m0_sm f_sm;"]
#[doc = "..."]
#[doc = "};"]
#[doc = ""]
#[doc = "void event_X(struct foo *f)"]
#[doc = "{"]
#[doc = "m0_sm_group_lock(f->f_sm.sm_grp);"]
#[doc = "process_X(f);"]
#[doc = "m0_sm_state_set(&f->f_sm, NEXT_STATE);"]
#[doc = "m0_sm_group_unlock(f->f_sm.sm_grp);"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "- \"chained\" state transition, where event processing logic is encoded in"]
#[doc = "m0_sm_state_descr::sd_in() methods and a call to m0_sm_state_set() causes"]
#[doc = "actual event processing to happen:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "int X_in(struct m0_sm *mach)"]
#[doc = "{"]
#[doc = "struct foo *f = container_of(mach, struct foo, f_sm);"]
#[doc = "process_X(f);"]
#[doc = "return NEXT_STATE;"]
#[doc = "}"]
#[doc = ""]
#[doc = "const struct m0_sm_conf foo_sm_conf = {"]
#[doc = "..."]
#[doc = ".scf_state = foo_sm_states"]
#[doc = "};"]
#[doc = ""]
#[doc = "struct m0_sm_state_descr foo_sm_states[] = {"]
#[doc = "..."]
#[doc = "[STATE_X] = {"]
#[doc = "..."]
#[doc = ".sd_in = X_in"]
#[doc = "},"]
#[doc = "..."]
#[doc = "};"]
#[doc = ""]
#[doc = "void event_X(struct foo *f)"]
#[doc = "{"]
#[doc = "m0_sm_group_lock(f->f_sm.sm_grp);"]
#[doc = "m0_sm_state_set(&f->f_sm, STATE_X);"]
#[doc = "m0_sm_group_unlock(f->f_sm.sm_grp);"]
#[doc = "}"]
#[doc = ""]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "<b>Accounting and statistics.</b>"]
#[doc = ""]
#[doc = "This module accumulates statistics about state transitions and time spent in"]
#[doc = "particular states. Statistics are reported through m0_sm_addb2_stats"]
#[doc = "structure, associated with the state machine."]
#[doc = ""]
#[doc = "<b>AST.</b>"]
#[doc = ""]
#[doc = "Asynchronous System Trap (AST) is a mechanism that allows a code running in"]
#[doc = "an \"awkward context\" (see above) to post a call-back to be executed at the"]
#[doc = "\"base level\" under a group mutex. UNIX kernels traditionally used a similar"]
#[doc = "mechanism, where an interrupt handler does little more than setting a flag"]
#[doc = "and returning. This flag is checked when the kernel is just about to return"]
#[doc = "to the user space. If the flag is set, the rest of interrupt processing"]
#[doc = "happens. In Linux a similar mechanism is called a \"top-half\" and"]
#[doc = "\"bottom-half\" of interrupt processing. In Windows it is a DPC"]
#[doc = "(http://en.wikipedia.org/wiki/Deferred_Procedure_Call) mechanism, in older"]
#[doc = "DEC kernels it was called a \"fork queue\"."]
#[doc = ""]
#[doc = "m0_sm_ast structure represents a call-back to be invoked under group"]
#[doc = "mutex. An ast is \"posted\" to a state machine group by a call to"]
#[doc = "m0_sm_ast_post(), which can be done in any context, in the sense that it"]
#[doc = "doesn't take any locks. Posted asts are executed"]
#[doc = ""]
#[doc = "- just after group mutex is taken;"]
#[doc = ""]
#[doc = "- just before group mutex is released;"]
#[doc = ""]
#[doc = "- whenever m0_sm_asts_run() is called."]
#[doc = ""]
#[doc = "Ast mechanism solves the problems with input events mentioned above at the"]
#[doc = "expense of"]
#[doc = ""]
#[doc = "- an increased latency: the call-back is not executed immediately;"]
#[doc = ""]
#[doc = "- an additional burden of ast-related book-keeping: it is up to the ast"]
#[doc = "user to free ast structure when it is safe to do so (i.e., after the"]
#[doc = "ast completed execution)."]
#[doc = ""]
#[doc = "To deal with the latency problem, a user must arrange m0_sm_asts_run() to be"]
#[doc = "called during long state transitions (typically within loops)."]
#[doc = ""]
#[doc = "There are a few ways to deal with the ast book-keeping problem:"]
#[doc = ""]
#[doc = "- majority of asts will be embedded in some longer living data-structures"]
#[doc = "like foms and won't need separate allocation of freeing;"]
#[doc = ""]
#[doc = "- some ast users might allocate asts dynamically;"]
#[doc = ""]
#[doc = "- the users which have neither a long-living data-structure to embed ast"]
#[doc = "in nor can call dynamic allocator, have to pre-allocate a pool of asts"]
#[doc = "and to guarantee somehow that it is never exhausted."]
#[doc = ""]
#[doc = "If an ast is posted a m0_sm_group::s_clink clink is signalled. A user"]
#[doc = "managing a state machine group might arrange a special \"ast\" thread (or a"]
#[doc = "group of threads) to wait on this channel and to call m0_sm_asts_run() when"]
#[doc = "the channel is signalled:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "while (1) {"]
#[doc = "m0_chan_wait(&G->s_clink);"]
#[doc = "m0_sm_group_lock(G);"]
#[doc = "m0_sm_asts_run(G);"]
#[doc = "m0_sm_group_unlock(G);"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "A special \"ast\" thread is not needed if there is an always running \"worker\""]
#[doc = "thread or pool of threads associated with the state machine group. In the"]
#[doc = "latter case, the worker thread can wait on m0_sm_group::s_clink in addition"]
#[doc = "to other channels it waits on (see m0_clink_attach())."]
#[doc = ""]
#[doc = "m0_sm_group_init() initialises m0_sm_group::s_clink with a NULL call-back. If"]
#[doc = "a user wants to re-initialise it with a different call-back or to attach it"]
#[doc = "to a clink group, it should call m0_clink_fini() followed by m0_clink_init()"]
#[doc = "or m0_link_attach() before any state machine is created in the group."]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm {
    #[doc = "Current state."]
    #[doc = ""]
    #[doc = "@invariant mach->sm_state < mach->sm_conf->scf_nr_states"]
    pub sm_state: u32,
    #[doc = "State machine identifier"]
    pub sm_id: u64,
    #[doc = "State machine configuration."]
    #[doc = ""]
    #[doc = "The configuration enumerates valid state machine states and"]
    #[doc = "associates with every state some attributes that are used by m0_sm"]
    #[doc = "code to check state transition correctness and to do some generic"]
    #[doc = "book-keeping, including addb-based accounting."]
    pub sm_conf: *const m0_sm_conf,
    pub sm_grp: *mut m0_sm_group,
    #[doc = "The time entered to current state. Used to calculate how long"]
    #[doc = "we were in a state (counted at m0_sm_state_stats::smss_times)."]
    pub sm_state_epoch: m0_time_t,
    pub sm_addb2_stats: *mut m0_sm_addb2_stats,
    #[doc = "Channel on which state transitions are announced."]
    pub sm_chan: m0_chan,
    #[doc = "State machine \"return code\". This is set to a non-zero value when"]
    #[doc = "state machine transitions to an M0_SDF_FAILURE state."]
    pub sm_rc: i32,
    #[doc = "Sm invariant check could be expensive for some state machines."]
    pub sm_invariant_chk_off: bool,
}
#[test]
fn bindgen_test_layout_m0_sm() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm>(),
        104usize,
        concat!("Size of: ", stringify!(m0_sm))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_conf as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_conf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_grp as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_grp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_state_epoch as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_state_epoch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_addb2_stats as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_addb2_stats)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_chan as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_chan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_rc as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_rc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm>())).sm_invariant_chk_off as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm),
            "::",
            stringify!(sm_invariant_chk_off)
        )
    );
}
pub const M0_SM_MAX_STATES: ::std::os::raw::c_uint = 64;
pub type _bindgen_ty_32 = ::std::os::raw::c_uint;
#[doc = "Description of some state machine state."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_state_descr {
    #[doc = "Flags, broadly classifying the state, taken from"]
    #[doc = "m0_sm_state_descr_flags."]
    pub sd_flags: u32,
    #[doc = "Human readable state name for debugging. This field is NULL for"]
    #[doc = "\"invalid\" states, which state machine may never enter."]
    pub sd_name: *const ::std::os::raw::c_char,
    #[doc = "This function (if non-NULL) is called by m0_sm_state_set() when the"]
    #[doc = "state is entered."]
    #[doc = ""]
    #[doc = "If this function returns a non-negative number, the state machine"]
    #[doc = "immediately transits to the returned state (this transition includes"]
    #[doc = "all usual side-effects, like machine channel broadcast and invocation"]
    #[doc = "of the target state ->sd_in() method). This process repeats until"]
    #[doc = "->sd_in() returns negative number. Such state transitions are called"]
    #[doc = "\"chained\", see \"chain\" UT for examples. To fail the state machine,"]
    #[doc = "set m0_sm::sm_rc manually and return one of M0_SDF_FAILURE states,"]
    #[doc = "see C_OVER -> C_LOSE transition in the \"chain\" UT."]
    pub sd_in:
        ::std::option::Option<unsafe extern "C" fn(mach: *mut m0_sm) -> ::std::os::raw::c_int>,
    #[doc = "This function (if non-NULL) is called by m0_sm_state_set() when the"]
    #[doc = "state is left."]
    pub sd_ex: ::std::option::Option<unsafe extern "C" fn(mach: *mut m0_sm)>,
    #[doc = "Invariant that must hold while in this state. Specifically, this"]
    #[doc = "invariant is checked under the state machine lock once transition to"]
    #[doc = "this state completed, checked under the same lock just before a"]
    #[doc = "transition out of the state is about to happen and is checked (under"]
    #[doc = "the lock) whenever a m0_sm call finds the target state machine in"]
    #[doc = "this state."]
    #[doc = ""]
    #[doc = "If this field is NULL, no invariant checks are done."]
    pub sd_invariant: ::std::option::Option<unsafe extern "C" fn(mach: *const m0_sm) -> bool>,
    #[doc = "A bitmap of states to which transitions from this state are allowed."]
    #[doc = ""]
    #[doc = "@note this limits the number of states to 64, which should be more"]
    #[doc = "than enough. Should a need in extra complicated machines arise, this"]
    #[doc = "can be replaced with m0_bitmap, as the expense of making static"]
    #[doc = "m0_sm_state_descr more complicated."]
    pub sd_allowed: u64,
    #[doc = "An index map of allowed transitions from this state."]
    #[doc = "The index here is the state to which transition is allowed."]
    #[doc = "The value maps to the index in transitions array"]
    #[doc = "(m0_sm_conf::scf_trans). The value of ~0 means that"]
    #[doc = "transition is not allowed.  This field is constructed"]
    #[doc = "at run-time in m0_sm_conf_init() routine, which must"]
    #[doc = "be called before state machine with this configuration"]
    #[doc = "can be constructed."]
    pub sd_trans: [i8; 64usize],
}
#[test]
fn bindgen_test_layout_m0_sm_state_descr() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_state_descr>(),
        112usize,
        concat!("Size of: ", stringify!(m0_sm_state_descr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_state_descr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_state_descr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_in as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_in)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_ex as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_ex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_invariant as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_invariant)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_allowed as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_allowed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_state_descr>())).sd_trans as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_state_descr),
            "::",
            stringify!(sd_trans)
        )
    );
}
#[doc = "An initial state."]
#[doc = ""]
#[doc = "State machine, must start execution in a state marked with this"]
#[doc = "flag. Multiple states can be marked with this flag, for example, to"]
#[doc = "share a code between similar state machines, that only differ in"]
#[doc = "initial conditions."]
#[doc = ""]
#[doc = "@see m0_sm_init()"]
pub const m0_sm_state_descr_flags_M0_SDF_INITIAL: m0_sm_state_descr_flags = 1;
#[doc = "A state marked with this flag is a failure state. m0_sm::sm_rc is set"]
#[doc = "to a non-zero value on entering this state."]
#[doc = ""]
#[doc = "In a such state, state machine is supposed to handle or report the"]
#[doc = "error indicated by m0_sm::sm_rc. Typically (but not necessary), the"]
#[doc = "state machine will transit into am M0_SDF_TERMINAL state immediately"]
#[doc = "after a failure state."]
#[doc = ""]
#[doc = "@see m0_sm_fail()"]
pub const m0_sm_state_descr_flags_M0_SDF_FAILURE: m0_sm_state_descr_flags = 2;
#[doc = "A state marked with this flag is a terminal state. No transitions out"]
#[doc = "of this state are allowed (checked by m0_sm_conf_invariant()) and an"]
#[doc = "attempt to wait for a state transition, while the state machine is in"]
#[doc = "a terminal state, immediately returns -ESRCH."]
#[doc = ""]
#[doc = "@see m0_sm_timedwait()"]
pub const m0_sm_state_descr_flags_M0_SDF_TERMINAL: m0_sm_state_descr_flags = 4;
#[doc = "A state marked with this flag is a \"final\" state. State machine can"]
#[doc = "be finalised iff it is in state marked as M0_SDF_FINAL or"]
#[doc = "M0_SDF_TERMINAL. There can be multiple states marked as"]
#[doc = "M0_SDF_FINAL. M0_SDF_FINAL differs from M0_SDF_TERMINAL in that,"]
#[doc = "state machine can transition out of a final state."]
pub const m0_sm_state_descr_flags_M0_SDF_FINAL: m0_sm_state_descr_flags = 8;
#[doc = "Flags for state classification, used in m0_sm_state_descr::sd_flags."]
pub type m0_sm_state_descr_flags = ::std::os::raw::c_uint;
#[doc = "State transition description"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_trans_descr {
    #[doc = "< Cause of transition"]
    pub td_cause: *const ::std::os::raw::c_char,
    #[doc = "< Source state index"]
    pub td_src: u32,
    #[doc = "< Target state index"]
    pub td_tgt: u32,
}
#[test]
fn bindgen_test_layout_m0_sm_trans_descr() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_trans_descr>(),
        16usize,
        concat!("Size of: ", stringify!(m0_sm_trans_descr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_trans_descr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_trans_descr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_trans_descr>())).td_cause as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_trans_descr),
            "::",
            stringify!(td_cause)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_trans_descr>())).td_src as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_trans_descr),
            "::",
            stringify!(td_src)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_trans_descr>())).td_tgt as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_trans_descr),
            "::",
            stringify!(td_tgt)
        )
    );
}
#[doc = "Asynchronous system trap."]
#[doc = ""]
#[doc = "A request to execute a call-back under group mutex. An ast can be posted by a"]
#[doc = "call to m0_sm_ast_post() in any context."]
#[doc = ""]
#[doc = "It will be executed later, see AST section of the comment at the top of this"]
#[doc = "file."]
#[doc = ""]
#[doc = "Only m0_sm_ast::sa_cb and m0_sm_ast::sa_datum fields are public. The rest of"]
#[doc = "this structure is for internal use by sm code."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_ast {
    #[doc = " Call-back to be executed."]
    pub sa_cb:
        ::std::option::Option<unsafe extern "C" fn(grp: *mut m0_sm_group, arg1: *mut m0_sm_ast)>,
    #[doc = " This field is reserved for the user and not used by the sm code."]
    pub sa_datum: *mut ::std::os::raw::c_void,
    pub sa_next: *mut m0_sm_ast,
    pub sa_mach: *mut m0_sm,
}
#[test]
fn bindgen_test_layout_m0_sm_ast() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_ast>(),
        32usize,
        concat!("Size of: ", stringify!(m0_sm_ast))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_ast>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_ast))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast>())).sa_cb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast),
            "::",
            stringify!(sa_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast>())).sa_datum as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast),
            "::",
            stringify!(sa_datum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast>())).sa_next as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast),
            "::",
            stringify!(sa_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast>())).sa_mach as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast),
            "::",
            stringify!(sa_mach)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_sm_group {
    pub s_lock: m0_mutex,
    pub s_nesting: ::std::os::raw::c_uint,
    pub s_clink: m0_clink,
    pub s_forkq: *mut m0_sm_ast,
    pub s_chan: m0_chan,
    pub s_addb2: *mut m0_sm_group_addb2,
}
#[test]
fn bindgen_test_layout_m0_sm_group() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_group>(),
        216usize,
        concat!("Size of: ", stringify!(m0_sm_group))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_group>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_group))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group>())).s_lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group),
            "::",
            stringify!(s_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group>())).s_nesting as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group),
            "::",
            stringify!(s_nesting)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group>())).s_clink as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group),
            "::",
            stringify!(s_clink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group>())).s_forkq as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group),
            "::",
            stringify!(s_forkq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group>())).s_chan as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group),
            "::",
            stringify!(s_chan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group>())).s_addb2 as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group),
            "::",
            stringify!(s_addb2)
        )
    );
}
extern "C" {
    #[doc = "Initialises a state machine."]
    #[doc = ""]
    #[doc = "@pre conf->scf_state[state].sd_flags & M0_SDF_INITIAL"]
    pub fn m0_sm_init(mach: *mut m0_sm, conf: *const m0_sm_conf, state: u32, grp: *mut m0_sm_group);
}
extern "C" {
    #[doc = "Finalises a state machine."]
    #[doc = ""]
    #[doc = "@pre conf->scf_state[state].sd_flags & (M0_SDF_TERMINAL | M0_SDF_FINAL)"]
    pub fn m0_sm_fini(mach: *mut m0_sm);
}
extern "C" {
    pub fn m0_sm_group_init(grp: *mut m0_sm_group);
}
extern "C" {
    pub fn m0_sm_group_fini(grp: *mut m0_sm_group);
}
extern "C" {
    pub fn m0_sm_group_lock(grp: *mut m0_sm_group);
}
extern "C" {
    pub fn m0_sm_group_unlock(grp: *mut m0_sm_group);
}
extern "C" {
    pub fn m0_sm_group_is_locked(grp: *const m0_sm_group) -> bool;
}
extern "C" {
    pub fn m0_sm_group_lock_rec(grp: *mut m0_sm_group, runast: bool);
}
extern "C" {
    pub fn m0_sm_group_unlock_rec(grp: *mut m0_sm_group, runast: bool);
}
extern "C" {
    #[doc = "Waits until a given state machine enters any of states enumerated by a given"]
    #[doc = "bit-mask."]
    #[doc = ""]
    #[doc = "@retval 0          - one of the states reached"]
    #[doc = ""]
    #[doc = "@retval -ESRCH     - terminal state reached,"]
    #[doc = "see m0_sm_state_descr_flags::M0_SDF_TERMINAL"]
    #[doc = ""]
    #[doc = "@retval -ETIMEDOUT - deadline passed"]
    #[doc = ""]
    #[doc = "In case where multiple wait termination conditions hold simultaneously (e.g.,"]
    #[doc = "@states includes a terminal state), the result is implementation dependent."]
    #[doc = ""]
    #[doc = "@note this interface assumes that states are numbered by numbers less than"]
    #[doc = "64."]
    pub fn m0_sm_timedwait(
        mach: *mut m0_sm,
        states: u64,
        deadline: m0_time_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Moves a state machine into fail_state state atomically with setting rc code."]
    #[doc = ""]
    #[doc = "@pre rc != 0"]
    #[doc = "@pre m0_mutex_is_locked(&mach->sm_grp->s_lock)"]
    #[doc = "@pre mach->sm_rc == 0"]
    #[doc = "@pre mach->sm_conf->scf_state[fail_state].sd_flags & M0_SDF_FAILURE"]
    #[doc = "@post mach->sm_rc == rc"]
    #[doc = "@post mach->sm_state == fail_state"]
    #[doc = "@post m0_mutex_is_locked(&mach->sm_grp->s_lock)"]
    pub fn m0_sm_fail(mach: *mut m0_sm, fail_state: ::std::os::raw::c_int, rc: i32);
}
extern "C" {
    #[doc = " Moves a state machine into the next state, calling either m0_sm_state_set()"]
    #[doc = " or m0_sm_fail() depending on \"rc\"."]
    pub fn m0_sm_move(mach: *mut m0_sm, rc: i32, state: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = "Transits a state machine into the indicated state."]
    #[doc = ""]
    #[doc = "Calls ex- and in- methods of the corresponding states (even if the state"]
    #[doc = "doesn't change after all)."]
    #[doc = ""]
    #[doc = "The (mach->sm_state == state) post-condition cannot be asserted, because of"]
    #[doc = "chained state transitions."]
    #[doc = ""]
    #[doc = "Updates m0_sm_state_stats::smss_times statistics for the current state and"]
    #[doc = "sets the m0_sm::sm_state_epoch for the next state."]
    #[doc = ""]
    #[doc = "@pre m0_mutex_is_locked(&mach->sm_grp->s_lock)"]
    #[doc = "@post m0_mutex_is_locked(&mach->sm_grp->s_lock)"]
    pub fn m0_sm_state_set(mach: *mut m0_sm, state: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Get human readable name (m0_sm_state_descr::sd_name) for the given state"]
    pub fn m0_sm_state_name(
        mach: *const m0_sm,
        state: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn m0_sm_conf_state_name(
        conf: *const m0_sm_conf,
        state: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
#[doc = " State machine timer."]
#[doc = ""]
#[doc = " A state machine timer is associated with a state machine group and executes"]
#[doc = " a specified call-back after a specified deadline and under the group lock."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_sm_timer {
    pub tr_grp: *mut m0_sm_group,
    pub tr_timer: m0_timer,
    pub tr_ast: m0_sm_ast,
    #[doc = " Call-back to be executed after timer expiration."]
    pub tr_cb: ::std::option::Option<unsafe extern "C" fn(arg1: *mut m0_sm_timer)>,
    #[doc = " Timer state from enum timer_state (sm.c)."]
    pub tr_state: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_m0_sm_timer() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_timer>(),
        368usize,
        concat!("Size of: ", stringify!(m0_sm_timer))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_timer>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_timer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timer>())).tr_grp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timer),
            "::",
            stringify!(tr_grp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timer>())).tr_timer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timer),
            "::",
            stringify!(tr_timer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timer>())).tr_ast as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timer),
            "::",
            stringify!(tr_ast)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timer>())).tr_cb as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timer),
            "::",
            stringify!(tr_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timer>())).tr_state as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timer),
            "::",
            stringify!(tr_state)
        )
    );
}
extern "C" {
    pub fn m0_sm_timer_init(timer: *mut m0_sm_timer);
}
extern "C" {
    pub fn m0_sm_timer_fini(timer: *mut m0_sm_timer);
}
extern "C" {
    #[doc = " Starts the timer."]
    #[doc = ""]
    #[doc = " When the specified (absolute) deadline expires, an AST is posted in the"]
    #[doc = " specified state machine group. When this AST is executed, it calls the"]
    #[doc = " user-supplied call-back."]
    #[doc = ""]
    #[doc = " If the deadline is already in the past by the time this is called, the AST is"]
    #[doc = " posted as soon as possible."]
    pub fn m0_sm_timer_start(
        timer: *mut m0_sm_timer,
        group: *mut m0_sm_group,
        cb: ::std::option::Option<unsafe extern "C" fn(arg1: *mut m0_sm_timer)>,
        deadline: m0_time_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_sm_timer_cancel(timer: *mut m0_sm_timer);
}
extern "C" {
    pub fn m0_sm_timer_is_armed(timer: *const m0_sm_timer) -> bool;
}
#[doc = "Structure used by m0_sm_timeout_arm() to record timeout state."]
#[doc = ""]
#[doc = "This structure is owned by the sm code, user should not access it. The user"]
#[doc = "provides initialised (by m0_sm_timeout_init()) instance of m0_sm_timeout to"]
#[doc = "m0_sm_timeout_arm(). After the timer expiration, the instance must be"]
#[doc = "finalised (with m0_sm_timeout_fini()) and re-initialised before it can be"]
#[doc = "used again."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_sm_timeout {
    #[doc = " Timer used to implement delayed state transition."]
    pub st_timer: m0_sm_timer,
    #[doc = " Clink to watch for state transitions that might cancel the"]
    #[doc = "timeout."]
    pub st_clink: m0_clink,
    #[doc = " Target state."]
    pub st_state: ::std::os::raw::c_int,
    #[doc = " Transitions to states in this bit-mask won't cancel the timeout."]
    pub st_bitmask: u64,
}
#[test]
fn bindgen_test_layout_m0_sm_timeout() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_timeout>(),
        472usize,
        concat!("Size of: ", stringify!(m0_sm_timeout))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_timeout>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_timeout))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timeout>())).st_timer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timeout),
            "::",
            stringify!(st_timer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timeout>())).st_clink as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timeout),
            "::",
            stringify!(st_clink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timeout>())).st_state as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timeout),
            "::",
            stringify!(st_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_timeout>())).st_bitmask as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_timeout),
            "::",
            stringify!(st_bitmask)
        )
    );
}
extern "C" {
    #[doc = "Initialises a timer structure with a given timeout."]
    pub fn m0_sm_timeout_init(to: *mut m0_sm_timeout);
}
extern "C" {
    #[doc = "Arms a timer to move a machine into a given state after a given timeout."]
    #[doc = ""]
    #[doc = "If a state transition happens before the timeout expires, the timeout is"]
    #[doc = "cancelled, unless the transition is to a state from \"bitmask\" parameter."]
    #[doc = ""]
    #[doc = "It is possible to arm multiple timeouts against the same state machine."]
    #[doc = ""]
    #[doc = "The m0_sm_timeout instance, supplied to this call can be freed after timeout"]
    #[doc = "expires or is cancelled."]
    #[doc = ""]
    #[doc = "@param timeout absolute time at which the state transition will take place"]
    #[doc = "@param state the state to which the state machine will transition after the"]
    #[doc = "timeout."]
    #[doc = "@param bitmask a mask of state machine states, transitions which won't cancel"]
    #[doc = "the timeout."]
    #[doc = ""]
    #[doc = "@pre m0_mutex_is_locked(&mach->sm_grp->s_lock)"]
    #[doc = "@pre sm_state(mach)->sd_allowed & M0_BITS(state)"]
    #[doc = "@pre m0_forall(i, mach->sm_conf->scf_nr_states,"]
    #[doc = "ergo(M0_BITS(i) & bitmask,"]
    #[doc = "state_get(mach, i)->sd_allowed & M0_BITS(state)))"]
    #[doc = "@post m0_mutex_is_locked(&mach->sm_grp->s_lock)"]
    pub fn m0_sm_timeout_arm(
        mach: *mut m0_sm,
        to: *mut m0_sm_timeout,
        timeout: m0_time_t,
        state: ::std::os::raw::c_int,
        bitmask: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Finaliser that must be called before @to can be freed."]
    pub fn m0_sm_timeout_fini(to: *mut m0_sm_timeout);
}
extern "C" {
    #[doc = "Returns true iff timer associated with the timeout is running."]
    pub fn m0_sm_timeout_is_armed(to: *const m0_sm_timeout) -> bool;
}
extern "C" {
    #[doc = " Posts an AST to a group."]
    #[doc = ""]
    #[doc = " An AST must not be re-posted until its previous (already posted) execution"]
    #[doc = " completes."]
    pub fn m0_sm_ast_post(grp: *mut m0_sm_group, ast: *mut m0_sm_ast);
}
extern "C" {
    #[doc = " Cancels a posted AST."]
    #[doc = ""]
    #[doc = " If the AST has already been executed, nothing is done."]
    #[doc = ""]
    #[doc = " @post ast->sa_next == NULL"]
    pub fn m0_sm_ast_cancel(grp: *mut m0_sm_group, ast: *mut m0_sm_ast);
}
extern "C" {
    #[doc = "Runs posted, but not yet executed ASTs."]
    #[doc = ""]
    #[doc = "@pre m0_mutex_is_locked(&grp->s_lock)"]
    #[doc = "@post m0_mutex_is_locked(&grp->s_lock)"]
    pub fn m0_sm_asts_run(grp: *mut m0_sm_group);
}
#[doc = " Negative mumbers are used to return from state function without"]
#[doc = " transitioning to next state."]
pub const m0_sm_return_M0_SM_BREAK: m0_sm_return = -1;
pub type m0_sm_return = ::std::os::raw::c_int;
extern "C" {
    #[doc = " Extends transition table of \"base\" with new transitions from \"sub\"."]
    #[doc = ""]
    #[doc = " Resulting table is stored in \"sub\", which should be of sufficient size."]
    #[doc = " Transitions in \"sub\" override matching transitions in \"base\"."]
    #[doc = ""]
    #[doc = " sub->scf_trans[] reserves array elements for base. Empty slots in"]
    #[doc = " sub->scf_trans[] could be in arbitrary places."]
    pub fn m0_sm_conf_trans_extend(base: *const m0_sm_conf, sub: *mut m0_sm_conf);
}
extern "C" {
    #[doc = " \"Extends\" base state descriptions with the given sub descriptions."]
    #[doc = ""]
    #[doc = " Updates sub in place to become a merged state machine descriptions array that"]
    #[doc = " uses base state descriptors, unless overridden by sub."]
    pub fn m0_sm_conf_extend(base: *const m0_sm_state_descr, sub: *mut m0_sm_state_descr, nr: u32);
}
extern "C" {
    pub fn m0_sm_invariant(mach: *const m0_sm) -> bool;
}
extern "C" {
    #[doc = " Initialises state machine configuration."]
    #[doc = ""]
    #[doc = " Traverses transitions description array and constructs"]
    #[doc = " m0_sm_state_descr::sd_trans transitions map array for each state."]
    #[doc = " It also makes sure (asserts) that transitions configuration in"]
    #[doc = " transitions description array matches with the same at states"]
    #[doc = " description array according to m0_sm_state_descr::sd_allowed flags."]
    #[doc = ""]
    #[doc = " @pre !m0_sm_conf_is_initialized(conf)"]
    #[doc = " @pre conf->scf_trans_nr > 0"]
    pub fn m0_sm_conf_init(conf: *mut m0_sm_conf);
}
extern "C" {
    #[doc = " Finalises state machine configuration."]
    #[doc = ""]
    #[doc = " @see m0_addb_rec_type_umregister()"]
    #[doc = ""]
    #[doc = " @pre conf->scf_magic == M0_SM_CONF_MAGIC"]
    pub fn m0_sm_conf_fini(conf: *mut m0_sm_conf);
}
extern "C" {
    #[doc = " Returns true if sm configuration was initialized already."]
    pub fn m0_sm_conf_is_initialized(conf: *const m0_sm_conf) -> bool;
}
extern "C" {
    pub fn m0_sm_group_call(
        group: *mut m0_sm_group,
        cb: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug)]
pub struct m0_sm_addb2_stats {
    pub as_id: u64,
    pub as_nr: ::std::os::raw::c_int,
    pub as_hist: __IncompleteArrayField<m0_addb2_hist>,
}
#[test]
fn bindgen_test_layout_m0_sm_addb2_stats() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_addb2_stats>(),
        16usize,
        concat!("Size of: ", stringify!(m0_sm_addb2_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_addb2_stats>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_addb2_stats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_addb2_stats>())).as_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_addb2_stats),
            "::",
            stringify!(as_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_addb2_stats>())).as_nr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_addb2_stats),
            "::",
            stringify!(as_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_addb2_stats>())).as_hist as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_addb2_stats),
            "::",
            stringify!(as_hist)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_group_addb2 {
    pub ga_forq: u64,
    pub ga_forq_hist: m0_addb2_hist,
}
#[test]
fn bindgen_test_layout_m0_sm_group_addb2() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_group_addb2>(),
        184usize,
        concat!("Size of: ", stringify!(m0_sm_group_addb2))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_group_addb2>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_group_addb2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group_addb2>())).ga_forq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group_addb2),
            "::",
            stringify!(ga_forq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_group_addb2>())).ga_forq_hist as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_group_addb2),
            "::",
            stringify!(ga_forq_hist)
        )
    );
}
extern "C" {
    pub fn m0_sm_addb2_init(conf: *mut m0_sm_conf, id: u64, counter: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_sm_addb2_fini(conf: *mut m0_sm_conf);
}
extern "C" {
    pub fn m0_sm_addb2_counter_init(sm: *mut m0_sm) -> bool;
}
#[doc = " API of waiting for AST completion."]
#[doc = ""]
#[doc = " Use example:"]
#[doc = ""]
#[doc = " @code"]
#[doc = " struct m0_sm_ast_wait *wait  = ...;"]
#[doc = " struct m0_mutex       *guard = ...; // m0_sm_group::s_lock, when possible."]
#[doc = ""]
#[doc = " m0_sm_ast_wait_init(wait, guard);"]
#[doc = ""]
#[doc = " // Thread A:"]
#[doc = " ast->sa_cb = ast_cb; // Must call m0_sm_ast_wait_signal() at the end."]
#[doc = " m0_mutex_lock(guard);"]
#[doc = " m0_sm_ast_wait_post(wait, grp, ast);"]
#[doc = " m0_mutex_unlock(guard);"]
#[doc = ""]
#[doc = " // Thread B:"]
#[doc = " m0_mutex_lock(guard);"]
#[doc = " m0_sm_ast_wait(wait);"]
#[doc = " m0_mutex_unlock(guard);"]
#[doc = " @endcode"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_sm_ast_wait {
    #[doc = " Whether posting of ASTs is allowed."]
    pub aw_allowed: bool,
    #[doc = " Number of posted, still not completed ASTs."]
    pub aw_active: m0_atomic64,
    #[doc = " Channel on which AST completion is signalled."]
    pub aw_chan: m0_chan,
}
#[test]
fn bindgen_test_layout_m0_sm_ast_wait() {
    assert_eq!(
        ::std::mem::size_of::<m0_sm_ast_wait>(),
        64usize,
        concat!("Size of: ", stringify!(m0_sm_ast_wait))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_sm_ast_wait>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_sm_ast_wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast_wait>())).aw_allowed as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast_wait),
            "::",
            stringify!(aw_allowed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast_wait>())).aw_active as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast_wait),
            "::",
            stringify!(aw_active)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_sm_ast_wait>())).aw_chan as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_sm_ast_wait),
            "::",
            stringify!(aw_chan)
        )
    );
}
extern "C" {
    pub fn m0_sm_ast_wait_init(wait: *mut m0_sm_ast_wait, ch_guard: *mut m0_mutex);
}
extern "C" {
    pub fn m0_sm_ast_wait_fini(wait: *mut m0_sm_ast_wait);
}
extern "C" {
    #[doc = " Waits until all m0_sm_ast_wait_post()ed ASTs are executed."]
    #[doc = ""]
    #[doc = " @pre  m0_chan_is_locked(&wait->aw_chan)"]
    pub fn m0_sm_ast_wait(wait: *mut m0_sm_ast_wait);
}
extern "C" {
    #[doc = " Posts an AST that might be waited for."]
    #[doc = ""]
    #[doc = " @note ast->sa_cb must call m0_sm_ast_wait_signal() as its last action."]
    pub fn m0_sm_ast_wait_post(
        wait: *mut m0_sm_ast_wait,
        grp: *mut m0_sm_group,
        ast: *mut m0_sm_ast,
    );
}
extern "C" {
    #[doc = " Signifies completion of an AST, posted with m0_sm_ast_wait_post()."]
    #[doc = ""]
    #[doc = " @pre  m0_chan_is_locked(&wait->aw_chan)"]
    pub fn m0_sm_ast_wait_signal(wait: *mut m0_sm_ast_wait);
}
extern "C" {
    pub fn m0_sm_ast_wait_prepare(wait: *mut m0_sm_ast_wait, clink: *mut m0_clink);
}
extern "C" {
    pub fn m0_sm_ast_wait_complete(wait: *mut m0_sm_ast_wait, clink: *mut m0_clink);
}
extern "C" {
    pub fn m0_sm_ast_wait_loop(wait: *mut m0_sm_ast_wait, clink: *mut m0_clink);
}
extern "C" {
    #[doc = " Outputs the dot-language description of the configuration to the console."]
    pub fn m0_sm_conf_print(conf: *const m0_sm_conf);
}
extern "C" {
    #[doc = " @return given SM identifier."]
    pub fn m0_sm_id_get(sm: *const m0_sm) -> u64;
}
#[doc = " Branded object type specifies how run-time identification is made."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_bob_type {
    #[doc = " Human-readable name used in error messages."]
    pub bt_name: *const ::std::os::raw::c_char,
    #[doc = " Offset to the magic field."]
    pub bt_magix_offset: ::std::os::raw::c_int,
    #[doc = " Magic value. Must be non zero."]
    pub bt_magix: u64,
    #[doc = "  Optional check function. If provided, this function is called by"]
    #[doc = "  m0_bob_check()."]
    pub bt_check:
        ::std::option::Option<unsafe extern "C" fn(bob: *const ::std::os::raw::c_void) -> bool>,
}
#[test]
fn bindgen_test_layout_m0_bob_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_bob_type>(),
        32usize,
        concat!("Size of: ", stringify!(m0_bob_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_bob_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_bob_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bob_type>())).bt_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bob_type),
            "::",
            stringify!(bt_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bob_type>())).bt_magix_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bob_type),
            "::",
            stringify!(bt_magix_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bob_type>())).bt_magix as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bob_type),
            "::",
            stringify!(bt_magix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bob_type>())).bt_check as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bob_type),
            "::",
            stringify!(bt_check)
        )
    );
}
extern "C" {
    #[doc = " Partially initializes a branded object type from a typed list descriptor."]
    pub fn m0_bob_type_tlist_init(bt: *mut m0_bob_type, td: *const m0_tl_descr);
}
extern "C" {
    #[doc = "  Initializes a branded object, by setting the magic field."]
    pub fn m0_bob_init(bt: *const m0_bob_type, bob: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = "  Finalizes a branded object, by re-setting the magic field to 0."]
    pub fn m0_bob_fini(bt: *const m0_bob_type, bob: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Returns true iff a branded object has the required magic value and check"]
    #[doc = " function, if any, returns true."]
    pub fn m0_bob_check(bt: *const m0_bob_type, bob: *const ::std::os::raw::c_void) -> bool;
}
#[doc = "Blocking read-write lock."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_rwlock {
    pub rw_lock: pthread_rwlock_t,
}
#[test]
fn bindgen_test_layout_m0_rwlock() {
    assert_eq!(
        ::std::mem::size_of::<m0_rwlock>(),
        56usize,
        concat!("Size of: ", stringify!(m0_rwlock))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rwlock>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rwlock))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rwlock>())).rw_lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rwlock),
            "::",
            stringify!(rw_lock)
        )
    );
}
extern "C" {
    #[doc = "read-write lock constructor"]
    pub fn m0_rwlock_init(lock: *mut m0_rwlock);
}
extern "C" {
    #[doc = "read-write lock destructor"]
    pub fn m0_rwlock_fini(lock: *mut m0_rwlock);
}
extern "C" {
    #[doc = "take exclusive lock"]
    pub fn m0_rwlock_write_lock(lock: *mut m0_rwlock);
}
extern "C" {
    #[doc = "release exclusive lock"]
    pub fn m0_rwlock_write_unlock(lock: *mut m0_rwlock);
}
extern "C" {
    #[doc = "take shared lock"]
    pub fn m0_rwlock_read_lock(lock: *mut m0_rwlock);
}
extern "C" {
    #[doc = "release shared lock"]
    pub fn m0_rwlock_read_unlock(lock: *mut m0_rwlock);
}
#[doc = "A queue of elements."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_queue {
    #[doc = " Oldest element in the queue (first to be returned)."]
    pub q_head: *mut m0_queue_link,
    #[doc = " Youngest (last added) element in the queue."]
    pub q_tail: *mut m0_queue_link,
}
#[test]
fn bindgen_test_layout_m0_queue() {
    assert_eq!(
        ::std::mem::size_of::<m0_queue>(),
        16usize,
        concat!("Size of: ", stringify!(m0_queue))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_queue>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_queue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_queue>())).q_head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_queue),
            "::",
            stringify!(q_head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_queue>())).q_tail as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_queue),
            "::",
            stringify!(q_tail)
        )
    );
}
#[doc = "@defgroup queue Queue"]
#[doc = ""]
#[doc = "FIFO queue. Should be pretty self-explanatory."]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_queue_link {
    pub ql_next: *mut m0_queue_link,
}
#[test]
fn bindgen_test_layout_m0_queue_link() {
    assert_eq!(
        ::std::mem::size_of::<m0_queue_link>(),
        8usize,
        concat!("Size of: ", stringify!(m0_queue_link))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_queue_link>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_queue_link))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_queue_link>())).ql_next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_queue_link),
            "::",
            stringify!(ql_next)
        )
    );
}
extern "C" {
    #[doc = "Static queue initializer. Assign this to a variable of type struct m0_queue"]
    #[doc = "to initialize empty queue."]
    pub static M0_QUEUE_INIT: m0_queue;
}
extern "C" {
    pub fn m0_queue_init(q: *mut m0_queue);
}
extern "C" {
    pub fn m0_queue_fini(q: *mut m0_queue);
}
extern "C" {
    pub fn m0_queue_is_empty(q: *const m0_queue) -> bool;
}
extern "C" {
    pub fn m0_queue_link_init(ql: *mut m0_queue_link);
}
extern "C" {
    pub fn m0_queue_link_fini(ql: *mut m0_queue_link);
}
extern "C" {
    pub fn m0_queue_link_is_in(ql: *const m0_queue_link) -> bool;
}
extern "C" {
    pub fn m0_queue_contains(q: *const m0_queue, ql: *const m0_queue_link) -> bool;
}
extern "C" {
    pub fn m0_queue_length(q: *const m0_queue) -> size_t;
}
extern "C" {
    #[doc = "Returns queue head or NULL if queue is empty."]
    pub fn m0_queue_get(q: *mut m0_queue) -> *mut m0_queue_link;
}
extern "C" {
    pub fn m0_queue_put(q: *mut m0_queue, ql: *mut m0_queue_link);
}
extern "C" {
    pub fn m0_queue_invariant(q: *const m0_queue) -> bool;
}
#[doc = "routines for handling generic reference counted objects"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_ref {
    #[doc = "number references to object"]
    pub ref_cnt: m0_atomic64,
    #[doc = "ponter to destructor"]
    #[doc = "@param ref pointer to reference object"]
    pub release: ::std::option::Option<unsafe extern "C" fn(ref_: *mut m0_ref)>,
}
#[test]
fn bindgen_test_layout_m0_ref() {
    assert_eq!(
        ::std::mem::size_of::<m0_ref>(),
        16usize,
        concat!("Size of: ", stringify!(m0_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_ref>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_ref))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ref>())).ref_cnt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ref),
            "::",
            stringify!(ref_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_ref>())).release as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_ref),
            "::",
            stringify!(release)
        )
    );
}
extern "C" {
    #[doc = "constructor for init reference counted protection"]
    #[doc = ""]
    #[doc = "@param ref pointer to m0_ref object"]
    #[doc = "@param init_num initial references on object"]
    #[doc = "@param release destructor function for the object"]
    pub fn m0_ref_init(
        ref_: *mut m0_ref,
        init_num: ::std::os::raw::c_int,
        release: ::std::option::Option<unsafe extern "C" fn(ref_: *mut m0_ref)>,
    );
}
extern "C" {
    #[doc = "take one reference to the object"]
    #[doc = ""]
    #[doc = "@param ref pointer to m0_ref object"]
    #[doc = ""]
    #[doc = "@return none"]
    pub fn m0_ref_get(ref_: *mut m0_ref);
}
extern "C" {
    #[doc = "Release one reference from the object."]
    #[doc = "If function will release last reference, destructor will called."]
    #[doc = ""]
    #[doc = "@param ref pointer to m0_ref object"]
    #[doc = ""]
    #[doc = "@return none"]
    pub fn m0_ref_put(ref_: *mut m0_ref);
}
extern "C" {
    #[doc = "Read the current value of the reference count from the m0_ref object"]
    #[doc = ""]
    #[doc = "@param ref pointer to m0_ref object"]
    #[doc = ""]
    #[doc = "@return current value of the reference count"]
    pub fn m0_ref_read(ref_: *const m0_ref) -> i64;
}
#[doc = "@defgroup cond Conditional variable."]
#[doc = ""]
#[doc = "Condition variable is a widely known and convenient synchronization"]
#[doc = "mechanism."]
#[doc = ""]
#[doc = "Notionally, a condition variable packages two things: a predicate (\"a"]
#[doc = "condition\", hence the name) on computation state, e.g., \"a free buffer is"]
#[doc = "available\", \"an incoming request waits for processing\" or \"all worker threads"]
#[doc = "have finished\", and a mutex (m0_mutex) protecting changes to the state"]
#[doc = "affecting the predicate."]
#[doc = ""]
#[doc = "There are two parts in using condition variable:"]
#[doc = ""]
#[doc = "@li in all places where state is changed in a way that affects the predicate,"]
#[doc = "the condition variable associated with the predicate has to be signalled. For"]
#[doc = "example:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "void buffer_put(struct m0_buffer *buf) {"]
#[doc = "m0_mutex_lock(&buffer_pool_lock);"]
#[doc = "buf_tlist_add(&buffer_pool_free, buf);"]
#[doc = "m0_cond_signal(&buffer_pool_hasfree);"]
#[doc = "m0_mutex_unlock(&buffer_pool_lock);"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "@li to wait for predicate to change, one takes the lock, checks the predicate"]
#[doc = "and calls m0_cond_wait() until the predicate becomes true:"]
#[doc = ""]
#[doc = "@code"]
#[doc = "struct m0_buffer *buffer_get(void) {"]
#[doc = "struct m0_buffer *buf;"]
#[doc = ""]
#[doc = "m0_mutex_lock(&buffer_pool_lock);"]
#[doc = "while (buf_tlist_is_empty(&buffer_pool_free))"]
#[doc = "m0_cond_wait(&buffer_pool_hasfree);"]
#[doc = "buf = buf_tlist_head(&buffer_pool_free);"]
#[doc = "buf_tlist_del(buf);"]
#[doc = "m0_mutex_unlock(&buffer_pool_lock);"]
#[doc = "return buf;"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "Note that one has to re-check the predicate after m0_cond_wait() returns,"]
#[doc = "because it might, generally, be false if multiple threads are waiting for"]
#[doc = "predicate change (in the above example, if there are multiple concurrent"]
#[doc = "calls to buffer_get()). This introduces one of the nicer features of"]
#[doc = "condition variables: de-coupling of producers and consumers."]
#[doc = ""]
#[doc = "Condition variables are more reliable and structured synchronization"]
#[doc = "primitive than channels (m0_chan), because the lock, protecting the predicate"]
#[doc = "is part of the interface and locking state can be checked. On the other hand,"]
#[doc = "channels can be used with predicates protected by read-write locks, atomic"]
#[doc = "variables, etc.---where condition variables are not applicable."]
#[doc = ""]
#[doc = "@see m0_chan"]
#[doc = "@see http://opengroup.org/onlinepubs/007908799/xsh/pthread_cond_wait.html"]
#[doc = ""]
#[doc = "@todo Consider supporting other types of locks in addition to m0_mutex."]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_cond {
    pub c_chan: m0_chan,
}
#[test]
fn bindgen_test_layout_m0_cond() {
    assert_eq!(
        ::std::mem::size_of::<m0_cond>(),
        48usize,
        concat!("Size of: ", stringify!(m0_cond))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_cond>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_cond))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_cond>())).c_chan as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_cond),
            "::",
            stringify!(c_chan)
        )
    );
}
extern "C" {
    pub fn m0_cond_init(cond: *mut m0_cond, mutex: *mut m0_mutex);
}
extern "C" {
    pub fn m0_cond_fini(cond: *mut m0_cond);
}
extern "C" {
    #[doc = "Atomically unlocks the mutex, waits on the condition variable and locks the"]
    #[doc = "mutex again before returning."]
    #[doc = ""]
    #[doc = "@pre  m0_mutex_is_locked(mutex)"]
    #[doc = "@post m0_mutex_is_locked(mutex)"]
    pub fn m0_cond_wait(cond: *mut m0_cond);
}
extern "C" {
    #[doc = "This is the same as m0_cond_wait, except that it has a timeout value. If the"]
    #[doc = "time expires before event is pending, this function will return false."]
    #[doc = ""]
    #[doc = "@note Unlike pthread_cond_timedwait, m0_cond_timedwait can succeed if the"]
    #[doc = "event is immediately pending, even if the abs_timeout is in the past.  If"]
    #[doc = "blocking occurs and abs_timeout is in the past, m0_cond_timedwait will return"]
    #[doc = "false.  pthread_cond_timedwait always fails when abs_timeout is in the past."]
    #[doc = ""]
    #[doc = "@param abs_timeout this is the time since Epoch (00:00:00, 1 January 1970)."]
    #[doc = "@return true if condition is signaled before timeout."]
    #[doc = "@return false if condition variable is not signaled but timeout expires."]
    #[doc = "errno is ETIMEDOUT;"]
    pub fn m0_cond_timedwait(cond: *mut m0_cond, abs_timeout: m0_time_t) -> bool;
}
extern "C" {
    #[doc = "Wakes up no more than one thread waiting on the condition variable."]
    #[doc = ""]
    #[doc = "@pre m0_mutex_is_locked(mutex)"]
    pub fn m0_cond_signal(cond: *mut m0_cond);
}
extern "C" {
    #[doc = "Wakes up all threads waiting on the condition variable."]
    #[doc = ""]
    #[doc = "@pre m0_mutex_is_locked(mutex)"]
    pub fn m0_cond_broadcast(cond: *mut m0_cond);
}
#[doc = "@addtogroup net"]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_buf_desc {
    pub nbd_len: u32,
    pub nbd_data: *mut u8,
}
#[test]
fn bindgen_test_layout_m0_net_buf_desc() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_buf_desc>(),
        16usize,
        concat!("Size of: ", stringify!(m0_net_buf_desc))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_buf_desc>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_buf_desc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buf_desc>())).nbd_len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buf_desc),
            "::",
            stringify!(nbd_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buf_desc>())).nbd_data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buf_desc),
            "::",
            stringify!(nbd_data)
        )
    );
}
#[doc = " In order to provide support for partially filled network buffers this"]
#[doc = " structure can be used. bdd_used stores how much data a network buffer"]
#[doc = " contains. rpc bulk fills this value."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_buf_desc_data {
    pub bdd_desc: m0_net_buf_desc,
    pub bdd_used: u64,
}
#[test]
fn bindgen_test_layout_m0_net_buf_desc_data() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_buf_desc_data>(),
        24usize,
        concat!("Size of: ", stringify!(m0_net_buf_desc_data))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_buf_desc_data>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_buf_desc_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buf_desc_data>())).bdd_desc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buf_desc_data),
            "::",
            stringify!(bdd_desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buf_desc_data>())).bdd_used as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buf_desc_data),
            "::",
            stringify!(bdd_used)
        )
    );
}
extern "C" {
    pub static mut m0_net_buf_desc_data_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_net_buf_desc_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_net_buf_desc_data_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_net_buf_desc_struct_init();
}
extern "C" {
    pub fn m0_xc_net_net_otw_types_init();
}
extern "C" {
    pub fn m0_xc_net_net_otw_types_fini();
}
extern "C" {
    #[doc = "Constructor for the network library"]
    pub fn m0_net_init() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Destructor for the network library."]
    #[doc = "Releases all allocated resources."]
    pub fn m0_net_fini();
}
#[doc = "Default minimum number of receive queue buffers for automatic"]
#[doc = "provisioning."]
pub const M0_NET_TM_RECV_QUEUE_DEF_LEN: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_33 = ::std::os::raw::c_uint;
#[doc = "Network transport (e.g. lnet)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_xprt {
    pub nx_name: *const ::std::os::raw::c_char,
    pub nx_ops: *const m0_net_xprt_ops,
}
#[test]
fn bindgen_test_layout_m0_net_xprt() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_xprt>(),
        16usize,
        concat!("Size of: ", stringify!(m0_net_xprt))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_xprt>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_xprt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt>())).nx_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt),
            "::",
            stringify!(nx_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt>())).nx_ops as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt),
            "::",
            stringify!(nx_ops)
        )
    );
}
#[doc = "Network transport operations. The network domain mutex must be"]
#[doc = "held to invoke these methods, unless explicitly stated otherwise."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_xprt_ops {
    #[doc = "Initialises transport specific part of a domain (e.g., start threads,"]
    #[doc = "initialise portals)."]
    #[doc = "Only the m0_net_mutex is held across this call."]
    pub xo_dom_init: ::std::option::Option<
        unsafe extern "C" fn(
            xprt: *const m0_net_xprt,
            dom: *mut m0_net_domain,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Finalises transport resources in a domain."]
    #[doc = "Only the m0_net_mutex is held across this call."]
    pub xo_dom_fini: ::std::option::Option<unsafe extern "C" fn(dom: *mut m0_net_domain)>,
    #[doc = "Performs transport level initialization of the transfer machine."]
    #[doc = ""]
    #[doc = "All fields will be initialized at this time, specifically:"]
    #[doc = ""]
    #[doc = "- ntm_dom"]
    #[doc = "- ntm_xprt_private - Initialized to NULL. The method can"]
    #[doc = "set its own value in the structure."]
    #[doc = ""]
    #[doc = "@retval 0 (success)"]
    #[doc = "@retval -errno (failure)"]
    #[doc = "@see m0_net_tm_init()"]
    pub xo_tm_init: ::std::option::Option<
        unsafe extern "C" fn(tm: *mut m0_net_transfer_mc) -> ::std::os::raw::c_int,
    >,
    #[doc = "Optional method to set the processor affinity for the threads of"]
    #[doc = "a transfer machine."]
    #[doc = "The transfer machine must be initialized but not yet started."]
    #[doc = "@param processors Processor bitmap."]
    #[doc = "@retval -ENOSYS  No affinity support available. Implied by a"]
    #[doc = "missing method."]
    pub xo_tm_confine: ::std::option::Option<
        unsafe extern "C" fn(
            tm: *mut m0_net_transfer_mc,
            processors: *const m0_bitmap,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Initiates the startup of the (initialized) transfer machine."]
    #[doc = "A completion event should be posted when started, using a different"]
    #[doc = "thread."]
    #[doc = "<b>Serialized using the transfer machine mutex.</b>"]
    #[doc = ""]
    #[doc = "The following fields are of special interest to this method:"]
    #[doc = "- ntm_dom"]
    #[doc = "- ntm_xprt_private"]
    #[doc = ""]
    #[doc = "@param addr Address (network end-point string representation) of the"]
    #[doc = "transfer machine. The method should not reference this string"]
    #[doc = "after it returns."]
    #[doc = ""]
    #[doc = "@see m0_net_tm_start()"]
    pub xo_tm_start: ::std::option::Option<
        unsafe extern "C" fn(
            tm: *mut m0_net_transfer_mc,
            addr: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Initiates the shutdown of a transfer machine, cancelling any"]
    #[doc = "pending startup."]
    #[doc = "No incoming messages should be accepted.  Pending operations should"]
    #[doc = "drain or be cancelled if requested."]
    #[doc = "A completion event should be posted when stopped, using a different"]
    #[doc = "thread."]
    #[doc = "<b>Serialized using the transfer machine mutex.</b>"]
    #[doc = "@param tm   Transfer machine pointer."]
    #[doc = "@param cancel Pending outbound operations should be cancelled"]
    #[doc = "immediately."]
    #[doc = "@retval 0 (success)"]
    #[doc = "@retval -errno (failure)"]
    #[doc = "@see m0_net_tm_stop()"]
    pub xo_tm_stop: ::std::option::Option<
        unsafe extern "C" fn(tm: *mut m0_net_transfer_mc, cancel: bool) -> ::std::os::raw::c_int,
    >,
    #[doc = "Releases resources associated with a transfer machine."]
    #[doc = "The transfer machine will be in the stopped state."]
    #[doc = ""]
    #[doc = "The following fields are of special interest to this method:"]
    #[doc = ""]
    #[doc = "- ntm_dom"]
    #[doc = "- ntm_xprt_private - The method should free any"]
    #[doc = "allocated memory tracked by this pointer."]
    #[doc = "@see m0_net_tm_fini()"]
    pub xo_tm_fini: ::std::option::Option<unsafe extern "C" fn(tm: *mut m0_net_transfer_mc)>,
    #[doc = "Creates an end point with a specific address."]
    #[doc = "@param epp     Returned end point data structure."]
    #[doc = "@param addr    Address string.  Could be NULL to"]
    #[doc = "indicate dynamic addressing."]
    #[doc = "Do not reference the string after return."]
    #[doc = ""]
    #[doc = "@see m0_net_end_point_create()"]
    pub xo_end_point_create: ::std::option::Option<
        unsafe extern "C" fn(
            epp: *mut *mut m0_net_end_point,
            tm: *mut m0_net_transfer_mc,
            addr: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Registers the buffer for use with a transfer machine in"]
    #[doc = "the manner indicated by the m0_net_buffer.nb_qtype value."]
    #[doc = "@see m0_net_buffer_register()"]
    pub xo_buf_register: ::std::option::Option<
        unsafe extern "C" fn(nb: *mut m0_net_buffer) -> ::std::os::raw::c_int,
    >,
    #[doc = "Deregisters the buffer from the transfer machine."]
    #[doc = "@see m0_net_buffer_deregister()"]
    pub xo_buf_deregister: ::std::option::Option<unsafe extern "C" fn(nb: *mut m0_net_buffer)>,
    #[doc = "Initiates an operation on a buffer on the transfer machine's"]
    #[doc = "queues."]
    #[doc = ""]
    #[doc = "In the case of buffers added to the M0_NET_QT_ACTIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND queues, the method should validate that"]
    #[doc = "the buffer size or data length meet the size requirements encoded"]
    #[doc = "within the network buffer descriptor m0_net_buffer::nb_desc."]
    #[doc = ""]
    #[doc = "In the case of the buffers added to the M0_NET_QT_PASSIVE_BULK_RECV"]
    #[doc = "or M0_NET_QT_PASSIVE_BULK_SEND queues, the method should set the"]
    #[doc = "network buffer descriptor in the specified buffer"]
    #[doc = "(m0_net_buffer::nb_desc)."]
    #[doc = ""]
    #[doc = "The M0_NET_BUF_IN_USE flag will be cleared before invoking the"]
    #[doc = "method. This allows the transport to use this flag to defer"]
    #[doc = "operations until later, which is useful if buffers are added during"]
    #[doc = "transfer machine state transitions."]
    #[doc = ""]
    #[doc = "The M0_NET_BUF_QUEUED flag and the nb_add_time field"]
    #[doc = "will be set prior to calling the method."]
    #[doc = ""]
    #[doc = "<b>Serialized using the transfer machine mutex.</b>"]
    #[doc = ""]
    #[doc = "@pre nb->nb_tm != NULL"]
    #[doc = "@see m0_net_buffer_add(), struct m0_net_buffer"]
    pub xo_buf_add: ::std::option::Option<
        unsafe extern "C" fn(nb: *mut m0_net_buffer) -> ::std::os::raw::c_int,
    >,
    #[doc = "Cancels an operation involving a buffer."]
    #[doc = "The method should cancel the operation involving use of the"]
    #[doc = "buffer, as described by the value of the m0_net_buffer.nb_qtype"]
    #[doc = "field."]
    #[doc = "The M0_NET_BUF_CANCELLED flag should be set in buffers whose"]
    #[doc = "operations get cancelled, so m0_net_buffer_event_post() can"]
    #[doc = "enforce the right error status."]
    #[doc = "<b>Serialized using the transfer machine mutex.</b>"]
    #[doc = ""]
    #[doc = "@pre nb->nb_tm != NULL"]
    #[doc = "@pre m0_net__qtype_is_valid(nb->nb_qtype)"]
    #[doc = "@see m0_net_buffer_del()"]
    pub xo_buf_del: ::std::option::Option<unsafe extern "C" fn(nb: *mut m0_net_buffer)>,
    #[doc = "Invoked by the m0_net_buffer_event_deliver_synchronously()"]
    #[doc = "subroutine to request the transport to disable automatic delivery"]
    #[doc = "of buffer events. The method is optional and need not be specified"]
    #[doc = "if this support is not available."]
    #[doc = "If supported, then the xo_bev_deliver_all() and the xo_bev_pending()"]
    #[doc = "operations must be provided."]
    #[doc = "@see m0_net_buffer_event_deliver_synchronously()"]
    pub xo_bev_deliver_sync: ::std::option::Option<
        unsafe extern "C" fn(tm: *mut m0_net_transfer_mc) -> ::std::os::raw::c_int,
    >,
    #[doc = "Invokes m0_net_buffer_event_post() for all pending events."]
    #[doc = ""]
    #[doc = "Invoked by the m0_net_buffer_event_deliver_all()"]
    #[doc = "subroutine. Optional if the synchronous buffer event delivery"]
    #[doc = "feature is not supported."]
    #[doc = ""]
    #[doc = "As buffer event delivery takes place without holding the transfer"]
    #[doc = "machine mutex, the transport should protect the invocation of this"]
    #[doc = "subroutine from synchronous termination of the transfer machine."]
    pub xo_bev_deliver_all:
        ::std::option::Option<unsafe extern "C" fn(tm: *mut m0_net_transfer_mc)>,
    #[doc = "Returns true, iff there are pending events."]
    #[doc = ""]
    #[doc = "Invoked by the m0_net_buffer_event_pending() subroutine.  Optional"]
    #[doc = "if the synchronous buffer event delivery feature is not supported."]
    pub xo_bev_pending:
        ::std::option::Option<unsafe extern "C" fn(tm: *mut m0_net_transfer_mc) -> bool>,
    #[doc = "Arranges for the given channel to be signalled when new event"]
    #[doc = "arrives."]
    #[doc = ""]
    #[doc = "Invoked by the m0_net_buffer_event_notify() subroutine. Optional if"]
    #[doc = "the synchronous buffer event delivery feature is not supported."]
    pub xo_bev_notify: ::std::option::Option<
        unsafe extern "C" fn(tm: *mut m0_net_transfer_mc, chan: *mut m0_chan),
    >,
    #[doc = "Retrieves the maximum buffer size (includes all segments)."]
    #[doc = "@retval size    Returns the maximum buffer size."]
    #[doc = "@see m0_net_domain_get_max_buffer_size()"]
    pub xo_get_max_buffer_size:
        ::std::option::Option<unsafe extern "C" fn(dom: *const m0_net_domain) -> m0_bcount_t>,
    #[doc = "Retrieves the maximum buffer segment size."]
    #[doc = "@retval size    Returns the maximum segment size."]
    #[doc = "@see m0_net_domain_get_max_buffer_segment_size()"]
    pub xo_get_max_buffer_segment_size:
        ::std::option::Option<unsafe extern "C" fn(dom: *const m0_net_domain) -> m0_bcount_t>,
    #[doc = "Retrieves the maximum number of buffer segments."]
    #[doc = "@retval num_segs Returns the maximum number of buffer segments."]
    #[doc = "@see m0_net_domain_get_max_buffer_segments()"]
    pub xo_get_max_buffer_segments:
        ::std::option::Option<unsafe extern "C" fn(dom: *const m0_net_domain) -> i32>,
    #[doc = "Retrieves the buffer descriptor size."]
    pub xo_get_max_buffer_desc_size:
        ::std::option::Option<unsafe extern "C" fn(dom: *const m0_net_domain) -> m0_bcount_t>,
    pub xo_rpc_max_seg_size:
        ::std::option::Option<unsafe extern "C" fn(ndom: *mut m0_net_domain) -> m0_bcount_t>,
    pub xo_rpc_max_segs_nr:
        ::std::option::Option<unsafe extern "C" fn(ndom: *mut m0_net_domain) -> u32>,
    pub xo_rpc_max_msg_size: ::std::option::Option<
        unsafe extern "C" fn(ndom: *mut m0_net_domain, rpc_size: m0_bcount_t) -> m0_bcount_t,
    >,
    pub xo_rpc_max_recv_msgs: ::std::option::Option<
        unsafe extern "C" fn(ndom: *mut m0_net_domain, rpc_size: m0_bcount_t) -> u32,
    >,
}
#[test]
fn bindgen_test_layout_m0_net_xprt_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_xprt_ops>(),
        192usize,
        concat!("Size of: ", stringify!(m0_net_xprt_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_xprt_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_xprt_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_dom_init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_dom_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_dom_fini as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_dom_fini)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_tm_init as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_tm_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_tm_confine as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_tm_confine)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_tm_start as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_tm_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_tm_stop as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_tm_stop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_tm_fini as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_tm_fini)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_end_point_create as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_end_point_create)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_buf_register as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_buf_register)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_buf_deregister as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_buf_deregister)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_buf_add as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_buf_add)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_buf_del as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_buf_del)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_bev_deliver_sync as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_bev_deliver_sync)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_bev_deliver_all as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_bev_deliver_all)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_bev_pending as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_bev_pending)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_bev_notify as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_bev_notify)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_get_max_buffer_size as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_get_max_buffer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_get_max_buffer_segment_size as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_get_max_buffer_segment_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_get_max_buffer_segments as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_get_max_buffer_segments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_get_max_buffer_desc_size as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_get_max_buffer_desc_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_rpc_max_seg_size as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_rpc_max_seg_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_rpc_max_segs_nr as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_rpc_max_segs_nr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_rpc_max_msg_size as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_rpc_max_msg_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_xprt_ops>())).xo_rpc_max_recv_msgs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_xprt_ops),
            "::",
            stringify!(xo_rpc_max_recv_msgs)
        )
    );
}
#[doc = "A collection of network resources."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_net_domain {
    #[doc = "This mutex is used to protect the resources associated with"]
    #[doc = "a network domain."]
    pub nd_mutex: m0_mutex,
    #[doc = " List of m0_net_buffer structures registered with the domain."]
    pub nd_registered_bufs: m0_list,
    #[doc = "List of m0_net_transfer_mc structures. Machines are linked here"]
    #[doc = "through ntm_dom_linkage::ntm_dom_linkage."]
    pub nd_tms: m0_list,
    #[doc = " Transport private domain data."]
    pub nd_xprt_private: *mut ::std::os::raw::c_void,
    #[doc = " This domain's transport."]
    pub nd_xprt: *const m0_net_xprt,
    #[doc = " Linkage for invoking application."]
    pub nd_app_linkage: m0_tlink,
    #[doc = " Maximum number of segments in a net buffer."]
    #[doc = " This value is retrieved from xo_get_max_buffer_segments() via"]
    #[doc = " m0_net_domain_get_max_buffer_segments()"]
    pub nd_get_max_buffer_segments: u32,
    #[doc = " Maximum segment size in a net buffer."]
    #[doc = " This value is retrieved from xo_get_max_buffer_segment_size() via"]
    #[doc = " m0_net_domain_get_max_buffer_segment_size()"]
    pub nd_get_max_buffer_segment_size: m0_bcount_t,
    #[doc = " Maximum size of a net buffer."]
    #[doc = " This value is retrieved from xo_get_max_buffer_size() via"]
    #[doc = " m0_net_domain_get_max_buffer_size()"]
    pub nd_get_max_buffer_size: m0_bcount_t,
    #[doc = " Maximum net buffer descriptor size."]
    #[doc = " This value is retrieved from xo_get_max_buffer_desc_size() via"]
    #[doc = " m0_net_domain_get_max_buffer_desc_size()"]
    pub nd_get_max_buffer_desc_size: m0_bcount_t,
    pub nd_magix: u64,
}
#[test]
fn bindgen_test_layout_m0_net_domain() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_domain>(),
        160usize,
        concat!("Size of: ", stringify!(m0_net_domain))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_domain>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_domain))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_domain>())).nd_mutex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_mutex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_domain>())).nd_registered_bufs as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_registered_bufs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_domain>())).nd_tms as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_tms)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_domain>())).nd_xprt_private as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_xprt_private)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_domain>())).nd_xprt as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_xprt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_domain>())).nd_app_linkage as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_app_linkage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_domain>())).nd_get_max_buffer_segments as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_get_max_buffer_segments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_domain>())).nd_get_max_buffer_segment_size as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_get_max_buffer_segment_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_domain>())).nd_get_max_buffer_size as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_get_max_buffer_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_domain>())).nd_get_max_buffer_desc_size as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_get_max_buffer_desc_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_domain>())).nd_magix as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_domain),
            "::",
            stringify!(nd_magix)
        )
    );
}
extern "C" {
    #[doc = "Initialises a domain."]
    #[doc = "@pre dom->nd_xprt == NULL"]
    pub fn m0_net_domain_init(
        dom: *mut m0_net_domain,
        xprt: *const m0_net_xprt,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Releases resources related to a domain."]
    #[doc = "@pre All end points, registered buffers and transfer machines released."]
    #[doc = "@param dom Domain pointer."]
    pub fn m0_net_domain_fini(dom: *mut m0_net_domain);
}
extern "C" {
    #[doc = "Returns the the maximum buffer size allowed for the domain."]
    #[doc = "This includes all segments."]
    pub fn m0_net_domain_get_max_buffer_size(dom: *mut m0_net_domain) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Returns the maximum buffer segment size allowed for the domain."]
    pub fn m0_net_domain_get_max_buffer_segment_size(dom: *mut m0_net_domain) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Returns the size of m0_net_buf_desc for a given net domain."]
    #[doc = ""]
    #[doc = "@retval size Size of m0_net_buf_desc for the transport associated"]
    #[doc = "with given net domain."]
    pub fn m0_net_domain_get_max_buffer_desc_size(dom: *mut m0_net_domain) -> m0_bcount_t;
}
extern "C" {
    #[doc = "Returns the maximum number of buffer segments for the domain."]
    pub fn m0_net_domain_get_max_buffer_segments(dom: *mut m0_net_domain) -> i32;
}
#[doc = "This represents an addressable network end point. Memory for this data"]
#[doc = "structure is managed by the network transport component and is associated"]
#[doc = "with the transfer machine that created the structure."]
#[doc = ""]
#[doc = "Multiple entities may reference and use the data structure at the same time,"]
#[doc = "so a reference count is maintained within it to determine when it is safe to"]
#[doc = "release the structure."]
#[doc = ""]
#[doc = "Transports should embed this data structure in their private end point"]
#[doc = "structures, and provide the release() method required to free them."]
#[doc = "The release() method, which is called with the transfer machine mutex"]
#[doc = "locked, should remove the data structure from the transfer machine"]
#[doc = "ntm_end_points list."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_end_point {
    #[doc = " Magic number."]
    pub nep_magix: u64,
    #[doc = " Keeps track of usage."]
    pub nep_ref: m0_ref,
    #[doc = " Pointer to transfer machine."]
    pub nep_tm: *mut m0_net_transfer_mc,
    #[doc = "Linkage in the transfer machine list,"]
    #[doc = "m0_net_transfer_mc::ntm_end_points."]
    pub nep_tm_linkage: m0_tlink,
    #[doc = "Transport specific printable representation of the"]
    #[doc = "end point address."]
    pub nep_addr: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_m0_net_end_point() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_end_point>(),
        56usize,
        concat!("Size of: ", stringify!(m0_net_end_point))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_end_point>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_end_point))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_end_point>())).nep_magix as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_end_point),
            "::",
            stringify!(nep_magix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_end_point>())).nep_ref as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_end_point),
            "::",
            stringify!(nep_ref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_end_point>())).nep_tm as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_end_point),
            "::",
            stringify!(nep_tm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_end_point>())).nep_tm_linkage as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_end_point),
            "::",
            stringify!(nep_tm_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_end_point>())).nep_addr as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_end_point),
            "::",
            stringify!(nep_addr)
        )
    );
}
extern "C" {
    pub static m0_nep_tl: m0_tl_descr;
}
extern "C" {
    pub fn m0_nep_tlist_init(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_nep_tlist_fini(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_nep_tlink_init(amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_invariant(head: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_nep_tlist_invariant_ext(
        head: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const m0_net_end_point,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        arg1: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn m0_nep_tlist_is_empty(list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_nep_tlink_init_at(amb: *mut m0_net_end_point, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_nep_tlink_init_at_tail(amb: *mut m0_net_end_point, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_nep_tlink_fini(amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlink_del_fini(amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlink_is_in(amb: *const m0_net_end_point) -> bool;
}
extern "C" {
    pub fn m0_nep_tlist_contains(list: *const m0_tl, amb: *const m0_net_end_point) -> bool;
}
extern "C" {
    pub fn m0_nep_tlist_length(list: *const m0_tl) -> size_t;
}
extern "C" {
    pub fn m0_nep_tlist_add(list: *mut m0_tl, amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_add_tail(list: *mut m0_tl, amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_add_after(amb: *mut m0_net_end_point, next: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_add_before(amb: *mut m0_net_end_point, next: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_del(amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_remove(amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_move(list: *mut m0_tl, amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_move_tail(list: *mut m0_tl, amb: *mut m0_net_end_point);
}
extern "C" {
    pub fn m0_nep_tlist_head(list: *const m0_tl) -> *mut m0_net_end_point;
}
extern "C" {
    pub fn m0_nep_tlist_pop(list: *const m0_tl) -> *mut m0_net_end_point;
}
extern "C" {
    pub fn m0_nep_tlist_tail(list: *const m0_tl) -> *mut m0_net_end_point;
}
extern "C" {
    pub fn m0_nep_tlist_next(
        list: *const m0_tl,
        amb: *const m0_net_end_point,
    ) -> *mut m0_net_end_point;
}
extern "C" {
    pub fn m0_nep_tlist_prev(
        list: *const m0_tl,
        amb: *const m0_net_end_point,
    ) -> *mut m0_net_end_point;
}
extern "C" {
    #[doc = "Allocates an end point data structure representing the desired"]
    #[doc = "end point and sets its reference count to 1,"]
    #[doc = "or increments the reference count of an existing matching data structure."]
    #[doc = "The data structure is linked to the transfer machine."]
    #[doc = "The invoker should call the m0_net_end_point_put() when the"]
    #[doc = "data structure is no longer needed."]
    #[doc = "@param epp Pointer to a pointer to the data structure which will be"]
    #[doc = "set upon return.  The reference count of the returned data structure"]
    #[doc = "will be at least 1."]
    #[doc = "@param tm  Transfer machine pointer.  The transfer machine must be in"]
    #[doc = "the started state."]
    #[doc = "@param addr String describing the end point address in a transport specific"]
    #[doc = "manner.  The format of this address string is the same as the printable"]
    #[doc = "representation form stored in the end point nep_addr field.  It is optional,"]
    #[doc = "and if NULL, the transport may support assignment of an end point with a"]
    #[doc = "dynamic address; however this is not guaranteed."]
    #[doc = "The address string, if specified, is not referenced again after return from"]
    #[doc = "this subroutine (i.e., the allocated end point gets the copy)."]
    #[doc = ""]
    #[doc = "@see m0_net_end_point_get(), m0_net_end_point_put()"]
    #[doc = "@pre tm->ntm_state == M0_NET_TM_STARTED"]
    #[doc = "@post (*epp)->nep_ref->ref_cnt >= 1 && (*epp)->nep_addr != NULL &&"]
    #[doc = "(*epp)->nep_tm == tm"]
    pub fn m0_net_end_point_create(
        epp: *mut *mut m0_net_end_point,
        tm: *mut m0_net_transfer_mc,
        addr: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Increments the reference count of an end point data structure."]
    #[doc = "This is used to safely point to the structure in a different context -"]
    #[doc = "when done, the reference count should be decremented by a call to"]
    #[doc = "m0_net_end_point_put()."]
    #[doc = ""]
    #[doc = "@pre ep->nep_ref->ref_cnt > 0"]
    pub fn m0_net_end_point_get(ep: *mut m0_net_end_point);
}
extern "C" {
    #[doc = "Decrements the reference count of an end point data structure."]
    #[doc = "The structure will be released when the count goes to 0."]
    #[doc = "@param ep End point data structure pointer."]
    #[doc = "Do not dereference this pointer after this call."]
    #[doc = "@pre ep->nep_ref->ref_cnt >= 1"]
    #[doc = "@note The transfer machine mutex will be obtained internally to synchronize"]
    #[doc = "the transport provided release() method in case the end point gets released."]
    pub fn m0_net_end_point_put(ep: *mut m0_net_end_point);
}
#[doc = " Queue with buffers to receive messages."]
pub const m0_net_queue_type_M0_NET_QT_MSG_RECV: m0_net_queue_type = 0;
#[doc = " Queue with buffers with messages to send."]
pub const m0_net_queue_type_M0_NET_QT_MSG_SEND: m0_net_queue_type = 1;
#[doc = "Queue with buffers awaiting completion of"]
#[doc = "remotely initiated bulk data send operations"]
#[doc = "that will read from these buffers."]
pub const m0_net_queue_type_M0_NET_QT_PASSIVE_BULK_RECV: m0_net_queue_type = 2;
#[doc = "Queue with buffers awaiting completion of"]
#[doc = "remotely initiated bulk data receive operations"]
#[doc = "that will write to these buffers."]
pub const m0_net_queue_type_M0_NET_QT_PASSIVE_BULK_SEND: m0_net_queue_type = 3;
#[doc = "Queue with buffers awaiting completion of"]
#[doc = "locally initiated bulk data receive operations"]
#[doc = "that will read from passive buffers."]
pub const m0_net_queue_type_M0_NET_QT_ACTIVE_BULK_RECV: m0_net_queue_type = 4;
#[doc = "Queue with buffers awaiting completion of"]
#[doc = "locally initiated bulk data send operations"]
#[doc = "to passive buffers."]
pub const m0_net_queue_type_M0_NET_QT_ACTIVE_BULK_SEND: m0_net_queue_type = 5;
#[doc = "Queue with buffers awaiting completion of"]
#[doc = "locally initiated bulk data send operations"]
#[doc = "to passive buffers."]
pub const m0_net_queue_type_M0_NET_QT_NR: m0_net_queue_type = 6;
#[doc = "This enumeration describes the types of logical queues in a transfer"]
#[doc = "machine."]
#[doc = ""]
#[doc = "@note We use the term \"queue\" here to imply that the order of addition"]
#[doc = "matters; in reality, while it *may* matter, external factors"]
#[doc = "have a *much* larger influence on the actual order in which"]
#[doc = "buffer operations complete; we're not implying FIFO semantics here!"]
#[doc = ""]
#[doc = "Consider:"]
#[doc = ""]
#[doc = "- The underlying transport manages message buffers. Since there is a great"]
#[doc = "deal of concurrency and latency involved with network communication, and"]
#[doc = "message sizes can vary, a completed (sent or received) message buffer is"]
#[doc = "not necessarily the first that was added to its \"queue\" for that purpose."]
#[doc = ""]
#[doc = "- The upper protocol layers of the <i>remote</i> end points are responsible"]
#[doc = "for initiating bulk data transfer operations, which ultimately determines"]
#[doc = "when passive buffers complete in <i>this</i> process.  The remote upper"]
#[doc = "protocol layers can, and probably will, reorder requests into an optimal"]
#[doc = "order for themselves, which does not necessarily correspond to the order"]
#[doc = "in which the passive bulk data buffers were added."]
#[doc = ""]
#[doc = "The fact of the matter is that the transfer machine itself"]
#[doc = "is really only interested in tracking buffer existence and uses"]
#[doc = "lists and not queues internally."]
pub type m0_net_queue_type = ::std::os::raw::c_uint;
#[doc = "< Undefined, prior to initialization"]
pub const m0_net_tm_state_M0_NET_TM_UNDEFINED: m0_net_tm_state = 0;
#[doc = "< Initialized"]
pub const m0_net_tm_state_M0_NET_TM_INITIALIZED: m0_net_tm_state = 1;
#[doc = "< Startup in progress"]
pub const m0_net_tm_state_M0_NET_TM_STARTING: m0_net_tm_state = 2;
#[doc = "< Active"]
pub const m0_net_tm_state_M0_NET_TM_STARTED: m0_net_tm_state = 3;
#[doc = "< Shutdown in progress"]
pub const m0_net_tm_state_M0_NET_TM_STOPPING: m0_net_tm_state = 4;
#[doc = "< Stopped"]
pub const m0_net_tm_state_M0_NET_TM_STOPPED: m0_net_tm_state = 5;
#[doc = "< Failed TM, must be fini'd"]
pub const m0_net_tm_state_M0_NET_TM_FAILED: m0_net_tm_state = 6;
#[doc = " A transfer machine can be in one of the following states."]
pub type m0_net_tm_state = ::std::os::raw::c_uint;
#[doc = "< General error"]
pub const m0_net_tm_ev_type_M0_NET_TEV_ERROR: m0_net_tm_ev_type = 0;
#[doc = "< Transfer machine state change event"]
pub const m0_net_tm_ev_type_M0_NET_TEV_STATE_CHANGE: m0_net_tm_ev_type = 1;
#[doc = "< Diagnostic event"]
pub const m0_net_tm_ev_type_M0_NET_TEV_DIAGNOSTIC: m0_net_tm_ev_type = 2;
pub const m0_net_tm_ev_type_M0_NET_TEV_NR: m0_net_tm_ev_type = 3;
#[doc = " Transfer machine event types."]
pub type m0_net_tm_ev_type = ::std::os::raw::c_uint;
#[doc = "Data structure used to provide asynchronous notification of"]
#[doc = "significant events, such as the completion of buffer operations,"]
#[doc = "transfer machine state changes and general errors."]
#[doc = ""]
#[doc = "All events have the following fields set:"]
#[doc = "- nte_type"]
#[doc = "- nte_tm"]
#[doc = "- nte_time"]
#[doc = "- nte_status"]
#[doc = ""]
#[doc = "The nte_type field should be referenced to determine the type of"]
#[doc = "event, and which other fields of this structure get set:"]
#[doc = ""]
#[doc = "- M0_NET_TEV_ERROR provides error notification, out of the context of"]
#[doc = "any buffer operation completion, or a transfer machine state change."]
#[doc = "No additional fields are set."]
#[doc = ""]
#[doc = "- M0_NET_TEV_STATE_CHANGE provides notification of a transfer machine"]
#[doc = "state change."]
#[doc = "The nte_next_state field describes the destination state."]
#[doc = "Refer to the nte_status field to determine if the operation succeeded."]
#[doc = "The nte_ep field is set if the next state is M0_NET_TM_STARTED; the"]
#[doc = "value is used to set the ntm_ep field of the transfer machine."]
#[doc = ""]
#[doc = "- M0_NET_TEV_DIAGNOSTIC provides diagnostic information."]
#[doc = "The nte_payload field may point to transport specific data."]
#[doc = "The API does not require nor specify how a transport produces"]
#[doc = "diagnostic information, but does require that diagnostic events"]
#[doc = "not be produced unless explicitly requested."]
#[doc = ""]
#[doc = "This data structure is typically allocated on the stack of the thread"]
#[doc = "that invokes the m0_net_tm_event_post() subroutine.  Applications"]
#[doc = "should not attempt to save a reference to it from their callback"]
#[doc = "functions."]
#[doc = ""]
#[doc = "@see m0_net_tm_event_post() for details on event delivery concurrency."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_tm_event {
    #[doc = "Indicates the type of event."]
    #[doc = "Other fields get set depending on the value of this field."]
    pub nte_type: m0_net_tm_ev_type,
    #[doc = "Transfer machine pointer."]
    pub nte_tm: *mut m0_net_transfer_mc,
    #[doc = "Time the event is posted."]
    pub nte_time: m0_time_t,
    #[doc = "Status or error code associated with the event."]
    #[doc = ""]
    #[doc = "In all event types other than M0_NET_TEV_DIAGNOSTIC, a 0 in this"]
    #[doc = "field implies successful completion, and a negative error number"]
    #[doc = "is used to indicate the reasons for failure."]
    #[doc = "The following errors are well defined:"]
    #[doc = "- <b>-ENOBUFS</b> This indicates that the transfer machine"]
    #[doc = "lost messages due to a lack of receive buffers."]
    #[doc = ""]
    #[doc = "Diagnostic events are free to make any use of this field."]
    pub nte_status: i32,
    #[doc = "Valid only if the nte_type is M0_NET_TEV_STATE_CHANGE."]
    #[doc = ""]
    #[doc = "The next state of the transfer machine is set in this field."]
    #[doc = "Any associated error condition defined by the nte_status field."]
    pub nte_next_state: m0_net_tm_state,
    #[doc = "End point pointer to be used to set the value of the ntm_ep"]
    #[doc = "field when the state changes to M0_NET_TM_STARTED."]
    pub nte_ep: *mut m0_net_end_point,
    #[doc = "Valid only if the nte_type is M0_NET_TEV_STATE_DIAGNOSTIC."]
    #[doc = ""]
    #[doc = "Transports may use this to point to internal data; they"]
    #[doc = "could also choose to embed the event data structure"]
    #[doc = "in a transport specific structure appropriate to the event."]
    #[doc = "Either approach would be of use to a diagnostic application."]
    pub nte_payload: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_m0_net_tm_event() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_tm_event>(),
        48usize,
        concat!("Size of: ", stringify!(m0_net_tm_event))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_tm_event>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_tm_event))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_tm as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_tm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_status as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_next_state as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_next_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_ep as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_ep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_tm_event>())).nte_payload as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_event),
            "::",
            stringify!(nte_payload)
        )
    );
}
#[doc = "Callbacks associated with a transfer machine."]
#[doc = "Multiple transfer machines can reference an instance of this structure."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_tm_callbacks {
    #[doc = "Event callback."]
    #[doc = "@param ev Pointer to the transfer machine event. The pointer"]
    #[doc = "is not valid after return from the subroutine."]
    pub ntc_event_cb: ::std::option::Option<unsafe extern "C" fn(ev: *const m0_net_tm_event)>,
}
#[test]
fn bindgen_test_layout_m0_net_tm_callbacks() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_tm_callbacks>(),
        8usize,
        concat!("Size of: ", stringify!(m0_net_tm_callbacks))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_tm_callbacks>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_tm_callbacks))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_tm_callbacks>())).ntc_event_cb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_tm_callbacks),
            "::",
            stringify!(ntc_event_cb)
        )
    );
}
#[doc = "Statistical data maintained for each transfer machine queue."]
#[doc = "It is up to the higher level layers to retrieve the data and"]
#[doc = "reset the statistical counters."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_qstats {
    #[doc = "The number of add operations performed."]
    pub nqs_num_adds: u64,
    #[doc = "The number of del operations performed."]
    pub nqs_num_dels: u64,
    #[doc = "The number of successful events posted on buffers in the queue."]
    pub nqs_num_s_events: u64,
    #[doc = "The number of failure events posted on buffers in the queue."]
    #[doc = ""]
    #[doc = "In the case of the M0_NET_QT_MSG_RECV queue the failure"]
    #[doc = "counter is also incremented when auto-provisioning fails, with an"]
    #[doc = "increment equal to the number of buffers required to fill the"]
    #[doc = "queue to its minimal level."]
    pub nqs_num_f_events: u64,
    #[doc = "The total of time spent in the queue by all buffers"]
    #[doc = "measured from when they were added to the queue"]
    #[doc = "to the time their completion event got posted."]
    pub nqs_time_in_queue: m0_time_t,
    #[doc = "The total number of bytes processed by buffers in the queue."]
    #[doc = "Computed at completion."]
    pub nqs_total_bytes: u64,
    #[doc = "The maximum number of bytes processed in a single"]
    #[doc = "buffer in the queue."]
    #[doc = "Computed at completion."]
    pub nqs_max_bytes: u64,
}
#[test]
fn bindgen_test_layout_m0_net_qstats() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_qstats>(),
        56usize,
        concat!("Size of: ", stringify!(m0_net_qstats))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_qstats>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_qstats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_num_adds as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_num_adds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_num_dels as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_num_dels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_num_s_events as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_num_s_events)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_num_f_events as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_num_f_events)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_time_in_queue as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_time_in_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_total_bytes as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_total_bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_qstats>())).nqs_max_bytes as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_qstats),
            "::",
            stringify!(nqs_max_bytes)
        )
    );
}
#[doc = "This data structure tracks message buffers and supports callbacks to notify"]
#[doc = "the application of changes in state associated with these buffers."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_net_transfer_mc {
    #[doc = "Pointer to application callbacks. Should be set before"]
    #[doc = "initialization."]
    pub ntm_callbacks: *const m0_net_tm_callbacks,
    #[doc = " Specifies the transfer machine state."]
    pub ntm_state: m0_net_tm_state,
    pub ntm_group: m0_sm_group,
    #[doc = "Callback activity is tracked by this counter."]
    #[doc = "It is incremented by m0_net_tm_post_event() before invoking"]
    #[doc = "a callback, and decremented when it returns."]
    #[doc = ""]
    #[doc = "This counter is used to guarantee that a transfer machine is not"]
    #[doc = "finalised while callbacks for it are executing."]
    pub ntm_callback_counter: u32,
    #[doc = " Network domain pointer"]
    pub ntm_dom: *mut m0_net_domain,
    #[doc = " List of m0_net_end_point structures. Managed by the transport."]
    pub ntm_end_points: m0_tl,
    #[doc = "End point associated with this transfer machine."]
    #[doc = ""]
    #[doc = "Messages sent from this transfer machine appear to have originated"]
    #[doc = "from this end point."]
    #[doc = ""]
    #[doc = "It is created internally with the address provided in the call to"]
    #[doc = "m0_net_tm_start(). The field is set only upon successful start of"]
    #[doc = "the transfer machine. The field is cleared during fini."]
    pub ntm_ep: *mut m0_net_end_point,
    #[doc = "Waiters for event notifications. They do not get copies"]
    #[doc = "of the event."]
    pub ntm_chan: m0_chan,
    #[doc = " Lists of m0_net_buffer structures by queue type."]
    pub ntm_q: [m0_tl; 6usize],
    #[doc = " Statistics maintained per logical queue."]
    pub ntm_qstats: [m0_net_qstats; 6usize],
    #[doc = " Domain linkage (m0_net_domain::nd_tms)."]
    pub ntm_dom_linkage: m0_list_link,
    #[doc = " Transport private data."]
    pub ntm_xprt_private: *mut ::std::os::raw::c_void,
    #[doc = "True iff automatic delivery of buffer events will take place."]
    pub ntm_bev_auto_deliver: bool,
    #[doc = "The buffer pool to use for automatic receive queue provisioning."]
    pub ntm_recv_pool: *mut m0_net_buffer_pool,
    #[doc = "Callbacks structure for automatically allocated receive queue"]
    #[doc = "buffers."]
    pub ntm_recv_pool_callbacks: *const m0_net_buffer_callbacks,
    #[doc = "Minimum queue length for the receive queue when provisioning"]
    #[doc = "automatically.  The default value is ::M0_NET_TM_RECV_QUEUE_DEF_LEN."]
    pub ntm_recv_queue_min_length: u32,
    #[doc = "Atomic variable tracking the number of buffers needed for the"]
    #[doc = "receive queue when automatically provisioning and out of buffers."]
    pub ntm_recv_queue_deficit: m0_atomic64,
    #[doc = "The color assigned to the transfer machine for locality"]
    #[doc = "support when provisioning from a buffer pool."]
    #[doc = "The value is initialized to @c ~0."]
    pub ntm_pool_colour: u32,
    #[doc = "Minimum remaining size in a buffer in TM receive queue to allow reuse"]
    #[doc = "for multiple messages."]
    pub ntm_recv_queue_min_recv_size: m0_bcount_t,
    #[doc = "Maximum number of messages that may be received in the buffer in"]
    #[doc = "TM Receive queue."]
    pub ntm_recv_queue_max_recv_msgs: u32,
}
#[test]
fn bindgen_test_layout_m0_net_transfer_mc() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_transfer_mc>(),
        896usize,
        concat!("Size of: ", stringify!(m0_net_transfer_mc))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_transfer_mc>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_transfer_mc))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_callbacks as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_group as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_group)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_callback_counter as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_callback_counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_dom as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_dom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_end_points as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_end_points)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_ep as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_ep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_chan as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_chan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_q as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_q)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_qstats as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_qstats)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_dom_linkage as *const _ as usize
        },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_dom_linkage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_xprt_private as *const _ as usize
        },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_xprt_private)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_bev_auto_deliver as *const _ as usize
        },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_bev_auto_deliver)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_recv_pool as *const _ as usize
        },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_recv_pool)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_recv_pool_callbacks as *const _
                as usize
        },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_recv_pool_callbacks)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_recv_queue_min_length as *const _
                as usize
        },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_recv_queue_min_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_recv_queue_deficit as *const _
                as usize
        },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_recv_queue_deficit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_pool_colour as *const _ as usize
        },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_pool_colour)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_recv_queue_min_recv_size as *const _
                as usize
        },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_recv_queue_min_recv_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_transfer_mc>())).ntm_recv_queue_max_recv_msgs as *const _
                as usize
        },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_transfer_mc),
            "::",
            stringify!(ntm_recv_queue_max_recv_msgs)
        )
    );
}
extern "C" {
    #[doc = "Initializes a transfer machine."]
    #[doc = ""]
    #[doc = "Prior to invocation the following fields should be set:"]
    #[doc = ""]
    #[doc = "- m0_net_transfer_mc.ntm_state should be set to M0_NET_TM_UNDEFINED."]
    #[doc = "Zeroing the entire structure has the side effect of setting this value."]
    #[doc = ""]
    #[doc = "- m0_net_transfer_mc.ntm_callbacks should point to a properly initialized"]
    #[doc = "struct m0_net_tm_callbacks data structure."]
    #[doc = ""]
    #[doc = "All fields in the structure other then the above will be set to their"]
    #[doc = "appropriate initial values."]
    #[doc = ""]
    #[doc = "@param dom     Network domain pointer."]
    #[doc = ""]
    #[doc = "@post tm->ntm_bev_auto_deliver is set."]
    #[doc = "@post (tm->ntm_pool_colour == M0_NET_BUFFER_POOL_ANY_COLOR &&"]
    #[doc = "tm->ntm_recv_pool_queue_min_length == M0_NET_TM_RECV_QUEUE_DEF_LEN)"]
    pub fn m0_net_tm_init(
        tm: *mut m0_net_transfer_mc,
        dom: *mut m0_net_domain,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Finalizes a transfer machine, releasing any associated"]
    #[doc = "transport specific resources."]
    #[doc = ""]
    #[doc = "All application references to end points associated with this transfer"]
    #[doc = "machine should be released prior to this call."]
    #[doc = ""]
    #[doc = "@pre"]
    #[doc = "M0_IN(tm->ntm_state, (M0_NET_TM_STOPPED,"]
    #[doc = "M0_NET_TM_FAILED, M0_NET_TM_INITIALIZED)) &&"]
    #[doc = "((m0_nep_tlist_is_empty(&tm->ntm_end_points) && tm->ntm_ep == NULL) ||"]
    #[doc = "(m0_nep_tlist_length(&tm->ntm_end_points) == 1 &&"]
    #[doc = "m0_nep_tlist_contains(&tm->ntm_end_points, tm->ntm_ep) &&"]
    #[doc = "m0_atomic64_get(tm->ntm_ep->nep_ref.ref_cnt) == 1))"]
    pub fn m0_net_tm_fini(tm: *mut m0_net_transfer_mc);
}
extern "C" {
    #[doc = "Sets the processor affinity of the threads of a transfer machine."]
    #[doc = "The transfer machine must be initialized but not yet started."]
    #[doc = ""]
    #[doc = "Support for this operation is transport specific."]
    #[doc = "@param processors Processor bitmap.  The bit map is not referenced"]
    #[doc = "internally after the subroutine returns."]
    #[doc = ""]
    #[doc = "@retval -ENOSYS  No affinity support available in the transport."]
    #[doc = ""]
    #[doc = "@pre tm->ntm_state == M0_NET_TM_INITIALIZED"]
    #[doc = ""]
    #[doc = "@see @ref Processor \"Processor API\""]
    #[doc = "@see @ref bitmap \"Bitmap API\""]
    pub fn m0_net_tm_confine(
        tm: *mut m0_net_transfer_mc,
        processors: *const m0_bitmap,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Starts a transfer machine."]
    #[doc = ""]
    #[doc = "The subroutine does not block the invoker. Instead the state is"]
    #[doc = "immediately changed to M0_NET_TM_STARTING, and an event will be"]
    #[doc = "posted to indicate when the transfer machine has transitioned to"]
    #[doc = "the M0_NET_TM_STARTED state."]
    #[doc = ""]
    #[doc = "@note It is possible that the state change event be posted before this"]
    #[doc = "subroutine returns."]
    #[doc = "It is guaranteed that the event will be posted on a different thread."]
    #[doc = ""]
    #[doc = "@param tm  Transfer machine pointer."]
    #[doc = ""]
    #[doc = "@param addr End point address to associate with the transfer machine.  May"]
    #[doc = "be null if dynamic addressing is supported by the transport.  The end"]
    #[doc = "point is created internally and made visible by the ntm_ep field only"]
    #[doc = "if the start operation succeeds."]
    #[doc = ""]
    #[doc = "@pre tm->ntm_state == M0_NET_TM_INITIALIZED"]
    #[doc = ""]
    #[doc = "@see m0_net_end_point_create()"]
    pub fn m0_net_tm_start(
        tm: *mut m0_net_transfer_mc,
        addr: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Initiates the shutdown of a transfer machine.  New messages will"]
    #[doc = "not be accepted and new end points cannot be created."]
    #[doc = "Pending operations will be completed or aborted as desired."]
    #[doc = ""]
    #[doc = "All end point references must be released by the application prior"]
    #[doc = "to invocation. The only end point reference that may exist is that of"]
    #[doc = "this transfer machine itself, and that will be released during fini."]
    #[doc = ""]
    #[doc = "The subroutine does not block the invoker.  Instead the state is"]
    #[doc = "immediately changed to M0_NET_TM_STOPPING, and an event will be"]
    #[doc = "posted to indicate when the transfer machine has transitioned to"]
    #[doc = "the M0_NET_TM_STOPPED state."]
    #[doc = ""]
    #[doc = "@note It is possible that the state change event be posted before this"]
    #[doc = "subroutine returns."]
    #[doc = "It is guaranteed that the event will be posted on a different thread."]
    #[doc = ""]
    #[doc = "@pre M0_IN(tm->ntm_state, (M0_NET_TM_INITIALIZED,"]
    #[doc = "M0_NET_TM_STARTING, M0_NET_TM_STARTED))"]
    #[doc = ""]
    #[doc = "@param abort Cancel pending operations. Support for this option is"]
    #[doc = "transport specific."]
    pub fn m0_net_tm_stop(tm: *mut m0_net_transfer_mc, abort: bool) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Retrieves transfer machine statistics for all or for a single logical queue,"]
    #[doc = "optionally resetting the data.  The operation is performed atomically"]
    #[doc = "with respect to on-going transfer machine activity."]
    #[doc = ""]
    #[doc = "@param qtype Logical queue identifier of the queue concerned. Specify"]
    #[doc = "M0_NET_QT_NR instead if all the queues are to be considered."]
    #[doc = ""]
    #[doc = "@param qs Returned statistical data. May be NULL if only a reset operation"]
    #[doc = "is desired.  Otherwise should point to a single m0_net_qstats data"]
    #[doc = "structure if the value of <b>qtype</b> is not M0_NET_QT_NR, or else"]
    #[doc = "should point to an array of M0_NET_QT_NR such structures in which to"]
    #[doc = "return the statistical data on all the queues."]
    #[doc = ""]
    #[doc = "@param reset Ttrue iff the associated statistics data should be reset at the"]
    #[doc = "same time."]
    #[doc = ""]
    #[doc = "@pre tm->ntm_state >= M0_NET_TM_INITIALIZED"]
    pub fn m0_net_tm_stats_get(
        tm: *mut m0_net_transfer_mc,
        qtype: m0_net_queue_type,
        qs: *mut m0_net_qstats,
        reset: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "A transfer machine is notified of non-buffer related events of interest"]
    #[doc = "with this subroutine."]
    #[doc = "Typically, the subroutine is invoked by the transport associated with"]
    #[doc = "the transfer machine."]
    #[doc = ""]
    #[doc = "The event data structure is not referenced from elsewhere after this"]
    #[doc = "subroutine returns, so may be allocated on the stack of the calling thread."]
    #[doc = ""]
    #[doc = "Multiple concurrent events may be delivered for a given transfer machine."]
    #[doc = ""]
    #[doc = "The subroutine will also signal to all waiters on the"]
    #[doc = "m0_net_transfer_mc::ntm_chan field after delivery of the callback."]
    #[doc = ""]
    #[doc = "The invoking process should be aware that the callback subroutine could"]
    #[doc = "end up making re-entrant calls to the transport layer."]
    #[doc = ""]
    #[doc = "@param ev Event pointer. The m0_net_tm_event::nte_tm field identifies the"]
    #[doc = "transfer machine."]
    #[doc = ""]
    #[doc = "@see m0_net_tm_buffer_post()"]
    pub fn m0_net_tm_event_post(ev: *const m0_net_tm_event);
}
extern "C" {
    #[doc = "Associates a buffer pool color with a transfer machine. This helps"]
    #[doc = "establish an association between a network buffer and the transfer machine"]
    #[doc = "when provisioning from a buffer pool, which can considerably improve the"]
    #[doc = "spatial and temporal locality of future provisioning calls from the buffer"]
    #[doc = "pool."]
    #[doc = ""]
    #[doc = "Automatically provisioned receive queue network buffers will be allocated"]
    #[doc = "with the specified color. The application can also use this color when"]
    #[doc = "provisioning buffers for this transfer machine in other network buffer pool"]
    #[doc = "use cases."]
    #[doc = ""]
    #[doc = "If this function is not called, the transfer machine's color is initialized"]
    #[doc = "to @c ~0."]
    #[doc = ""]
    #[doc = "@pre M0_IN(tm->ntm_state, (M0_NET_TM_INITIALIZED, M0_NET_TM_STARTED))"]
    #[doc = ""]
    #[doc = "@see m0_net_tm_colour_get(), m0_net_tm_pool_attach()"]
    pub fn m0_net_tm_colour_set(tm: *mut m0_net_transfer_mc, colour: u32);
}
extern "C" {
    #[doc = "Returns the buffer pool color associated with a transfer machine."]
    #[doc = "@see m0_net_tm_colour_set()"]
    pub fn m0_net_tm_colour_get(tm: *mut m0_net_transfer_mc) -> u32;
}
extern "C" {
    #[doc = "Enables the automatic provisioning of network buffers to the receive"]
    #[doc = "queue of the transfer machine from the specified network buffer pool."]
    #[doc = ""]
    #[doc = "Provisioning takes place at the following times:"]
    #[doc = "- Upon transfer machine startup"]
    #[doc = "- Prior to delivery of a de-queueud receive message buffer"]
    #[doc = "- When buffers are returned to an exhausted network buffer pool and there"]
    #[doc = "are transfer machines that can be re-provisioned from that pool. This"]
    #[doc = "requires that the application invoke the"]
    #[doc = "m0_net_domain_buffer_pool_not_empty() subroutine from the pool's not-empty"]
    #[doc = "callback."]
    #[doc = "- When the minimum length of the receive buffer queue is modified."]
    #[doc = "@param bufpool Pointer to a network buffer pool."]
    #[doc = "@param callbacks Pointer to the callbacks to be set in the provisioned"]
    #[doc = "network buffer."]
    #[doc = "@param min_recv_size Minimum remaining size in a buffer in TM receive queue"]
    #[doc = "to allow reuse for multiple messages."]
    #[doc = "@param max_recv_msgs Maximum number of messages that may be received in the"]
    #[doc = "buffer in TM receive queue."]
    #[doc = "@param min_recv_queue_len Minimum nuber of buffers in TM receive queue."]
    #[doc = ""]
    #[doc = "@pre tm != NULL"]
    #[doc = "@pre tm->ntm_state == M0_NET_TM_INITIALIZED"]
    #[doc = "@pre bufpool != NULL"]
    #[doc = "@pre callbacks != NULL"]
    #[doc = "@pre callbacks->nbc_cb[M0_NET_QT_MSG_RECV] != NULL"]
    #[doc = "@pre min_recv_size > 0"]
    #[doc = "@pre max_recv_msgs > 0"]
    #[doc = ""]
    #[doc = "@see m0_net_tm_colour_set(), m0_net_domain_buffer_pool_not_empty(),"]
    #[doc = "m0_net_tm_pool_length_set()"]
    pub fn m0_net_tm_pool_attach(
        tm: *mut m0_net_transfer_mc,
        bufpool: *mut m0_net_buffer_pool,
        callbacks: *const m0_net_buffer_callbacks,
        min_recv_size: m0_bcount_t,
        max_recv_msgs: u32,
        min_recv_queue_len: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Sets the minimum number of network buffers that should be present on the"]
    #[doc = "receive queue of the transfer machine. If the number falls below this"]
    #[doc = "value and automatic provisioning is enabled, then additional buffers are"]
    #[doc = "provisioned as needed."]
    #[doc = "Invoking this subroutine may trigger provisioning."]
    #[doc = "@param len Minimum receive queue length. The default value is"]
    #[doc = "M0_NET_TM_RECV_QUEUE_DEF_LEN."]
    #[doc = "@see m0_net_tm_pool_attach()"]
    pub fn m0_net_tm_pool_length_set(tm: *mut m0_net_transfer_mc, len: u32);
}
extern "C" {
    #[doc = "Reprovisions all transfer machines in the network domain of this buffer"]
    #[doc = "pool, that are associated with the pool."]
    #[doc = ""]
    #[doc = "The application typically arranges for this subroutine to be called from the"]
    #[doc = "pool's not-empty callback operation."]
    #[doc = ""]
    #[doc = "The subroutine should be invoked while holding the pool lock, which is"]
    #[doc = "normally the case in the pool not-empty callback,"]
    #[doc = "m0_net_buffer_pool_ops::nbpo_not_empty()."]
    #[doc = ""]
    #[doc = "@param pool A network buffer pool."]
    #[doc = "@see m0_net_tm_pool_attach()"]
    pub fn m0_net_domain_buffer_pool_not_empty(pool: *mut m0_net_buffer_pool);
}
#[doc = " Buffer completion events are described by this data structure."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_buffer_event {
    #[doc = " Pointer to the buffer"]
    pub nbe_buffer: *mut m0_net_buffer,
    #[doc = " Time the event is posted."]
    pub nbe_time: m0_time_t,
    #[doc = "Status or error code associated with the event."]
    #[doc = ""]
    #[doc = "A 0 in this field implies successful completion, and a negative"]
    #[doc = "error number is used to indicate the reasons for failure."]
    #[doc = ""]
    #[doc = "The following errors are well defined:"]
    #[doc = ""]
    #[doc = "- -ECANCELED. This is used in buffer release events to indicate"]
    #[doc = "that the associated buffer operation was cancelled by a call to"]
    #[doc = "m0_net_buffer_del()."]
    #[doc = ""]
    #[doc = "- -ETIMEDOUT. This is used in buffer release events to indicate"]
    #[doc = "that the associated buffer operation did not complete before"]
    #[doc = "the current time exceeded the nb_timeout value.  The support"]
    #[doc = "for this feature is transport specific.  The nb_timeout value"]
    #[doc = "is always reset to M0_TIME_NEVER by the time the buffer"]
    #[doc = "callback is invoked."]
    pub nbe_status: i32,
    #[doc = "Length of the buffer data associated with this event."]
    #[doc = "The field is valid only if the event is posted"]
    #[doc = "for the M0_NET_QT_MSG_RECV, M0_NET_QT_PASSIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_RECV queues."]
    pub nbe_length: m0_bcount_t,
    #[doc = "Starting offset of the buffer data associated with this event,"]
    #[doc = "if the event is posted for the"]
    #[doc = "M0_NET_QT_MSG_RECV, M0_NET_QT_PASSIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_RECV queues."]
    #[doc = ""]
    #[doc = "Provided for future support of multi-delivery buffer transports."]
    #[doc = "Applications should take it into consideration when determining the"]
    #[doc = "starting location of the event data in the buffer."]
    pub nbe_offset: m0_bindex_t,
    #[doc = "This field is used only in successful completion of buffers"]
    #[doc = "in the received message queue (M0_NET_QT_MSG_RECV)."]
    #[doc = "The transport will set the end point to identify the sender"]
    #[doc = "of the message before invoking the completion callback on the buffer."]
    #[doc = ""]
    #[doc = "The end point will be released when the callback returns, so"]
    #[doc = "applications should increment the reference count on the end"]
    #[doc = "point with m0_net_end_point_get(), if they wish to dereference"]
    #[doc = "the pointer in a different context."]
    pub nbe_ep: *mut m0_net_end_point,
}
#[test]
fn bindgen_test_layout_m0_net_buffer_event() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_buffer_event>(),
        48usize,
        concat!("Size of: ", stringify!(m0_net_buffer_event))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_buffer_event>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_buffer_event))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_event>())).nbe_buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_event),
            "::",
            stringify!(nbe_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_event>())).nbe_time as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_event),
            "::",
            stringify!(nbe_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_event>())).nbe_status as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_event),
            "::",
            stringify!(nbe_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_event>())).nbe_length as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_event),
            "::",
            stringify!(nbe_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_event>())).nbe_offset as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_event),
            "::",
            stringify!(nbe_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_event>())).nbe_ep as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_event),
            "::",
            stringify!(nbe_ep)
        )
    );
}
#[doc = "Buffer callback function pointer type."]
#[doc = "@param ev Pointer to the buffer event. The pointer is not valid after"]
#[doc = "the callback returns."]
pub type m0_net_buffer_cb_proc_t =
    ::std::option::Option<unsafe extern "C" fn(ev: *const m0_net_buffer_event)>;
#[doc = "This data structure contains application callback function pointers"]
#[doc = "for buffer completion callbacks, one function per type of buffer queue."]
#[doc = ""]
#[doc = "Applications should provide a pointer to an instance of such a"]
#[doc = "structure in the nb_callbacks field of the struct m0_net_buffer."]
#[doc = "Multiple objects can point to a single instance of such a structure."]
#[doc = ""]
#[doc = "@see m0_net_buffer_event_post() for the concurrency semantics."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_buffer_callbacks {
    pub nbc_cb: [m0_net_buffer_cb_proc_t; 6usize],
}
#[test]
fn bindgen_test_layout_m0_net_buffer_callbacks() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_buffer_callbacks>(),
        48usize,
        concat!("Size of: ", stringify!(m0_net_buffer_callbacks))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_buffer_callbacks>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_buffer_callbacks))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer_callbacks>())).nbc_cb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer_callbacks),
            "::",
            stringify!(nbc_cb)
        )
    );
}
#[doc = " The buffer is registered with the domain."]
pub const m0_net_buf_flags_M0_NET_BUF_REGISTERED: m0_net_buf_flags = 1;
#[doc = " The buffer is added to a transfer machine logical queue."]
pub const m0_net_buf_flags_M0_NET_BUF_QUEUED: m0_net_buf_flags = 2;
#[doc = " Set when the transport starts using the buffer."]
pub const m0_net_buf_flags_M0_NET_BUF_IN_USE: m0_net_buf_flags = 4;
#[doc = " Indicates that the buffer operation has been cancelled."]
pub const m0_net_buf_flags_M0_NET_BUF_CANCELLED: m0_net_buf_flags = 8;
#[doc = " Indicates that the buffer operation has timed out."]
pub const m0_net_buf_flags_M0_NET_BUF_TIMED_OUT: m0_net_buf_flags = 16;
#[doc = "Set by the transport to indicate that a buffer should not be"]
#[doc = "dequeued in a m0_net_buffer_event_post() call."]
pub const m0_net_buf_flags_M0_NET_BUF_RETAIN: m0_net_buf_flags = 32;
#[doc = " Buffer state is tracked using these bitmap flags."]
pub type m0_net_buf_flags = ::std::os::raw::c_uint;
#[doc = "This data structure is used to track the memory used for message passing or"]
#[doc = "bulk data transfer over the network."]
#[doc = ""]
#[doc = "Support for scatter-gather buffers is provided by use of a m0_bufvec; upper"]
#[doc = "layer protocols may impose limitations on the use of scatter-gather,"]
#[doc = "especially for message passing.  The transport will impose limitations on"]
#[doc = "the number of vector elements and the overall maximum buffer size."]
#[doc = ""]
#[doc = "The invoking application is responsible for the creation of these data"]
#[doc = "structures, registering them with the network domain, and providing them to"]
#[doc = "a transfer machine for specific operations. As such, memory alignment"]
#[doc = "considerations of the encapsulated m0_bufvec are handled by the invoking"]
#[doc = "application."]
#[doc = ""]
#[doc = "Once the application initiates an operation on a buffer, it should refrain"]
#[doc = "from modifying the buffer until the callback signifying operation"]
#[doc = "completion."]
#[doc = ""]
#[doc = "Applications must register buffers with the transport before use, and"]
#[doc = "deregister them before shutting down."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_net_buffer {
    #[doc = "Vector pointing to memory associated with this data structure."]
    #[doc = "Initialized by the application prior to registration."]
    #[doc = "It should not be modified until after registration."]
    pub nb_buffer: m0_bufvec,
    #[doc = "The actual amount of data to be transferred in the case of adding"]
    #[doc = "the buffer to the M0_NET_QT_MSG_SEND, M0_NET_QT_PASSIVE_BULK_SEND or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND queues."]
    #[doc = ""]
    #[doc = "The actual amount of valid data received, upon completion of"]
    #[doc = "M0_NET_QT_MSG_RECV, M0_NET_QT_PASSIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_RECV queue operations, is not set here, but in"]
    #[doc = "the nbe_length field of the m0_net_buffer_event instead."]
    pub nb_length: m0_bcount_t,
    #[doc = "The starting offset in the buffer from which the data should"]
    #[doc = "be read, in the case of adding a buffer to the"]
    #[doc = "M0_NET_QT_MSG_SEND, M0_NET_QT_PASSIVE_BULK_SEND or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND queues."]
    #[doc = ""]
    #[doc = "It is transport specific if a non-zero value is supported."]
    pub nb_offset: m0_bindex_t,
    #[doc = "Domain pointer. It is set automatically when the buffer"]
    #[doc = "is registered with m0_net_buffer_register()."]
    #[doc = "The application should not modify this field."]
    pub nb_dom: *mut m0_net_domain,
    #[doc = "Transfer machine pointer. It is set automatically with"]
    #[doc = "every call to m0_net_buffer_add()."]
    pub nb_tm: *mut m0_net_transfer_mc,
    #[doc = "The application should set this value to identify the logical"]
    #[doc = "transfer machine queue before calling m0_net_buffer_add()."]
    pub nb_qtype: m0_net_queue_type,
    #[doc = "Pointer to application callbacks. Should be set"]
    #[doc = "prior to adding the buffer to a transfer machine queue."]
    pub nb_callbacks: *const m0_net_buffer_callbacks,
    #[doc = "Absolute time by which an operation involving the buffer should"]
    #[doc = "stop with failure if not completed."]
    #[doc = "The application should set this field prior to adding the"]
    #[doc = "buffer to a transfer machine logical queue."]
    #[doc = ""]
    #[doc = "<b>Support for this is transport specific.</b>"]
    #[doc = "A value of M0_TIME_NEVER disables the timeout."]
    #[doc = "The value is forced to M0_TIME_NEVER during buffer registration,"]
    #[doc = "and reset to the same prior to the invocation of the buffer"]
    #[doc = "callback so applications need not bother with this field unless"]
    #[doc = "they intend to set a timeout value."]
    #[doc = ""]
    #[doc = "Adding a buffer to a logical queue will fail with a -ETIME"]
    #[doc = "error code if the specified nb_timeout value is in the past."]
    pub nb_timeout: m0_time_t,
    #[doc = "Time at which the buffer was added to its logical queue."]
    #[doc = "Set by the m0_net_buffer_add() subroutine and used to"]
    #[doc = "compute the time spent in the queue."]
    pub nb_add_time: m0_time_t,
    #[doc = "Network transport descriptor."]
    #[doc = ""]
    #[doc = "The value is set upon return from m0_net_buffer_add() when the"]
    #[doc = "buffer is added to the M0_NET_QT_PASSIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_PASSIVE_BULK_SEND queues."]
    #[doc = ""]
    #[doc = "Applications should convey the descriptor to the active side to"]
    #[doc = "perform the bulk data transfer. The active side application code"]
    #[doc = "should set this value when adding the buffer to the"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_RECV or M0_NET_QT_ACTIVE_BULK_SEND queues,"]
    #[doc = "using the m0_net_desc_copy() subroutine."]
    #[doc = ""]
    #[doc = "In both cases, applications are responsible for freeing the memory"]
    #[doc = "used by this descriptor with the m0_net_desc_free() subroutine."]
    pub nb_desc: m0_net_buf_desc,
    #[doc = "This field identifies an end point in the associated transfer"]
    #[doc = "machine."]
    #[doc = ""]
    #[doc = "When sending messages the application should specify the end point"]
    #[doc = "of the destination before adding the buffer to the"]
    #[doc = "M0_NET_QT_MSG_SEND queue."]
    #[doc = ""]
    #[doc = "The field is not used for the bulk cases nor for received messages."]
    pub nb_ep: *mut m0_net_end_point,
    #[doc = "Linkage into one of the transfer machine lists that implement the"]
    #[doc = "logical queues."]
    #[doc = "There is only one linkage for all of the queues, as a buffer"]
    #[doc = "can only be used for one type of operation at a time."]
    #[doc = ""]
    #[doc = "For free pool buffers, it is also used for linkage into"]
    #[doc = "m0_net_buffer_pool::nbp_colours[]."]
    #[doc = ""]
    #[doc = "The application should not modify this field."]
    pub nb_tm_linkage: m0_tlink,
    #[doc = " Linkage into a network buffer pool LRU list."]
    pub nb_lru: m0_tlink,
    #[doc = " Application-specific buffer linkage."]
    pub nb_extern_linkage: m0_tlink,
    #[doc = " Magic for network buffer list."]
    pub nb_magic: u64,
    #[doc = "Linkage into one of the domain list that tracks registered buffers."]
    #[doc = ""]
    #[doc = "The application should not modify this field."]
    pub nb_dom_linkage: m0_list_link,
    #[doc = "Transport private data associated with the buffer."]
    #[doc = "Will be freed when the buffer is deregistered, if not earlier."]
    #[doc = ""]
    #[doc = "The application should not modify this field."]
    pub nb_xprt_private: *mut ::std::os::raw::c_void,
    #[doc = "Application specific private data associated with the buffer."]
    #[doc = "It is populated and used by the end user."]
    #[doc = "It is end user's responsibility to use this field to allocate"]
    #[doc = "or deallocate any memory regions stored in this field."]
    #[doc = ""]
    #[doc = "It is neither verified by net code nor do the net layer"]
    #[doc = "invariants touch it."]
    #[doc = ""]
    #[doc = "Current users:"]
    #[doc = ""]
    #[doc = "- rpc/bulk uses this for a pointer to m0_rpc_bulk_buf;"]
    #[doc = "- net/test uses this for a pointer to m0_net_test_network_ctx."]
    pub nb_app_private: *mut ::std::os::raw::c_void,
    #[doc = "Buffer state is tracked with bitmap flags from"]
    #[doc = "enum m0_net_buf_flags."]
    #[doc = ""]
    #[doc = "The application should initialize this field to 0 prior"]
    #[doc = "to registering the buffer with the domain."]
    #[doc = ""]
    #[doc = "The application should not modify these flags again until"]
    #[doc = "after de-registration."]
    pub nb_flags: u64,
    #[doc = "Minimum remaining size in a receive buffer to allow reuse"]
    #[doc = "for multiple messages."]
    #[doc = "The value may not be 0 for buffers in the M0_NET_QT_MSG_RECV queue."]
    pub nb_min_receive_size: m0_bcount_t,
    #[doc = "Maximum number of messages that may be received in the buffer."]
    #[doc = "The value may not be 0 for buffers in the M0_NET_QT_MSG_RECV queue."]
    pub nb_max_receive_msgs: u32,
    #[doc = "Set when a buffer is provisioned from a pool using the"]
    #[doc = "m0_net_buffer_pool_get() subroutine call."]
    pub nb_pool: *mut m0_net_buffer_pool,
    #[doc = " Counts the number of messages received when on the receive queue."]
    pub nb_msgs_received: u32,
}
#[test]
fn bindgen_test_layout_m0_net_buffer() {
    assert_eq!(
        ::std::mem::size_of::<m0_net_buffer>(),
        240usize,
        concat!("Size of: ", stringify!(m0_net_buffer))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_net_buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_net_buffer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_length as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_offset as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_dom as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_tm as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_tm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_qtype as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_qtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_callbacks as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_timeout as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_timeout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_add_time as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_add_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_desc as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_ep as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_ep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_tm_linkage as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_tm_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_lru as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_lru)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_extern_linkage as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_extern_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_magic as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_dom_linkage as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_dom_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_xprt_private as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_xprt_private)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_app_private as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_app_private)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_flags as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_buffer>())).nb_min_receive_size as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_min_receive_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_net_buffer>())).nb_max_receive_msgs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_max_receive_msgs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_pool as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_pool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_net_buffer>())).nb_msgs_received as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_net_buffer),
            "::",
            stringify!(nb_msgs_received)
        )
    );
}
extern "C" {
    #[doc = "Registers a buffer with the domain. The domain could perform some"]
    #[doc = "optimizations under the covers."]
    #[doc = ""]
    #[doc = "@param buf Pointer to a buffer. The buffer should have the following fields"]
    #[doc = "initialized:"]
    #[doc = "- m0_net_buffer.nb_buffer should be initialized to point to the buffer"]
    #[doc = "memory regions."]
    #[doc = "The buffer's timeout value is initialized to M0_TIME_NEVER upon return."]
    #[doc = ""]
    #[doc = "@pre buf->nb_flags == 0"]
    #[doc = "@pre buf->nb_buffer.ov_buf != NULL"]
    #[doc = "@pre m0_vec_count(&buf->nb_buffer.ov_vec) > 0"]
    #[doc = "@post ergo(result == 0, buf->nb_flags & M0_NET_BUF_REGISTERED)"]
    #[doc = "@post ergo(result == 0, buf->nb_timeout == M0_TIME_NEVER)"]
    #[doc = ""]
    #[doc = "@param dom Pointer to the domain."]
    pub fn m0_net_buffer_register(
        buf: *mut m0_net_buffer,
        dom: *mut m0_net_domain,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Deregisters a previously registered buffer and releases any transport"]
    #[doc = "specific resources associated with it. The buffer should not be in use, nor"]
    #[doc = "should this subroutine be invoked from a callback."]
    #[doc = ""]
    #[doc = "@pre buf->nb_flags == M0_NET_BUF_REGISTERED"]
    #[doc = "@pre buf->nb_dom == dom"]
    pub fn m0_net_buffer_deregister(buf: *mut m0_net_buffer, dom: *mut m0_net_domain);
}
extern "C" {
    #[doc = "Adds a registered buffer to a transfer machine's logical queue specified"]
    #[doc = "by the m0_net_buffer.nb_qtype value."]
    #[doc = ""]
    #[doc = "- Buffers added to the M0_NET_QT_MSG_RECV queue are used to receive"]
    #[doc = "messages."]
    #[doc = ""]
    #[doc = "- When data is contained in the buffer, as in the case of the"]
    #[doc = "M0_NET_QT_MSG_SEND, M0_NET_QT_PASSIVE_BULK_SEND and"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND queues, the application must set the"]
    #[doc = "m0_net_buffer.nb_length field to the actual length of the data to be"]
    #[doc = "transferred."]
    #[doc = ""]
    #[doc = "- Buffers added to the M0_NET_QT_MSG_SEND queue must identify the"]
    #[doc = "message destination end point with the m0_net_buffer.nb_ep field."]
    #[doc = ""]
    #[doc = "- Buffers added to the M0_NET_QT_PASSIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_PASSIVE_BULK_SEND queues must have their m0_net_buffer.nb_ep"]
    #[doc = "field set to identify the end point that will initiate the bulk data"]
    #[doc = "transfer.  Upon return from this subroutine the m0_net_buffer.nb_desc"]
    #[doc = "field will be set to the network buffer descriptor to be conveyed to said"]
    #[doc = "end point."]
    #[doc = ""]
    #[doc = "- Buffers added to the M0_NET_QT_ACTIVE_BULK_RECV or"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND queues must have their m0_net_buffer.nb_desc"]
    #[doc = "field set to the network buffer descriptor associated with the passive"]
    #[doc = "buffer."]
    #[doc = ""]
    #[doc = "- The callback function pointer for the appropriate queue type"]
    #[doc = "must be set in nb_callbacks."]
    #[doc = ""]
    #[doc = "The buffer should not be modified until the operation completion"]
    #[doc = "callback is invoked for the buffer."]
    #[doc = ""]
    #[doc = "The buffer completion callback is guaranteed to be invoked on a"]
    #[doc = "different thread."]
    #[doc = ""]
    #[doc = "@pre buf->nb_dom == tm->ntm_dom"]
    #[doc = "@pre tm->ntm_state == M0_NET_TM_STARTED"]
    #[doc = "@pre m0_net__qtype_is_valid(buf->nb_qtype)"]
    #[doc = "@pre buf->nb_flags == M0_NET_BUF_REGISTERED"]
    #[doc = "@pre buf->nb_callbacks->nbc_cb[buf->nb_qtype] != NULL"]
    #[doc = "@pre ergo(buf->nb_qtype == M0_NET_QT_MSG_RECV,"]
    #[doc = "buf->nb_min_receive_size != 0 && buf->nb_max_receive_msgs != 0)"]
    #[doc = "@pre ergo(buf->nb_qtype == M0_NET_QT_MSG_SEND, buf->nb_ep != NULL)"]
    #[doc = "@pre ergo(M0_IN(buf->nb_qtype, (M0_NET_QT_ACTIVE_BULK_RECV,"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND)),"]
    #[doc = "buf->nb_desc.nbd_len != 0)"]
    #[doc = "@pre ergo(M0_IN(buf->nb_qtype, (M0_NET_QT_MSG_SEND ||"]
    #[doc = "M0_NET_QT_PASSIVE_BULK_SEND,"]
    #[doc = "M0_NET_QT_ACTIVE_BULK_SEND)),"]
    #[doc = "buf->nb_length > 0)"]
    #[doc = ""]
    #[doc = "@retval -ETIME nb_timeout is set to other than M0_TIME_NEVER, and occurs in"]
    #[doc = "the past. Note that this differs from them buffer timeout error code"]
    #[doc = "of -ETIMEDOUT."]
    #[doc = ""]
    #[doc = "@note Receiving a successful buffer completion callback is not a guarantee"]
    #[doc = "that a data transfer actually took place, but merely an indication that the"]
    #[doc = "transport reported the operation was successfully executed. See the"]
    #[doc = "transport documentation for details."]
    pub fn m0_net_buffer_add(
        buf: *mut m0_net_buffer,
        tm: *mut m0_net_transfer_mc,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Removes a registered buffer from a logical queue, if possible,"]
    #[doc = "cancelling any operation in progress."]
    #[doc = ""]
    #[doc = "<b>Cancellation support is provided by the underlying transport.</b> It is"]
    #[doc = "not guaranteed that actual cancellation of the operation in progress will"]
    #[doc = "always be supported, and even if it is, there are race conditions in the"]
    #[doc = "execution of this request and the concurrent invocation of the completion"]
    #[doc = "callback on the buffer."]
    #[doc = ""]
    #[doc = "The transport should set the M0_NET_BUF_CANCELLED flag in the buffer if"]
    #[doc = "the operation has not yet started.  The flag will be cleared by"]
    #[doc = "m0_net_buffer_event_post()."]
    #[doc = ""]
    #[doc = "The buffer completion callback is guaranteed to be invoked on a"]
    #[doc = "different thread."]
    #[doc = ""]
    #[doc = "@pre buf->nb_flags & M0_NET_BUF_REGISTERED"]
    #[doc = ""]
    #[doc = "@retval true (success)"]
    #[doc = "@retval false (failure, the buffer is not queued)"]
    pub fn m0_net_buffer_del(buf: *mut m0_net_buffer, tm: *mut m0_net_transfer_mc) -> bool;
}
extern "C" {
    #[doc = "A transfer machine is notified of buffer related events with this"]
    #[doc = "subroutine."]
    #[doc = ""]
    #[doc = "Typically, the subroutine is invoked by the transport associated with the"]
    #[doc = "transfer machine."]
    #[doc = ""]
    #[doc = "The event data structure is not referenced from elsewhere after this"]
    #[doc = "subroutine returns, so may be allocated on the stack of the calling thread."]
    #[doc = ""]
    #[doc = "Multiple concurrent events may be delivered for a given buffer, depending"]
    #[doc = "upon the transport."]
    #[doc = ""]
    #[doc = "The subroutine will remove a buffer from its queue if the M0_NET_BUF_RETAIN"]
    #[doc = "flag is @em not set.  It will clear the M0_NET_BUF_QUEUED and"]
    #[doc = "M0_NET_BUF_IN_USE flags and set the nb_timeout field to M0_TIME_NEVER if the"]
    #[doc = "buffer is dequeued.  It will always clear the M0_NET_BUF_RETAIN,"]
    #[doc = "M0_NET_BUF_CANCELLED and M0_NET_BUF_TIMED_OUT flags prior to invoking the"]
    #[doc = "callback. The M0_NET_BUF_RETAIN flag must not be set if the status indicates"]
    #[doc = "error."]
    #[doc = ""]
    #[doc = "If the M0_NET_BUF_CANCELLED flag was set, then the status must be"]
    #[doc = "-ECANCELED."]
    #[doc = ""]
    #[doc = "If the M0_NET_BUF_TIMED_OUT flag was set, then the status must be"]
    #[doc = "-ETIMEDOUT."]
    #[doc = ""]
    #[doc = "The subroutine will perform a m0_end_point_put() on the ev->nbe_ep, if the"]
    #[doc = "queue type is M0_NET_QT_MSG_RECV and the nbe_status value is 0, and for the"]
    #[doc = "M0_NET_QT_MSG_SEND queue to match the m0_end_point_get() made in the"]
    #[doc = "m0_net_buffer_add() call. Care should be taken by the transport to"]
    #[doc = "accomodate these adjustments when invoking the subroutine with the"]
    #[doc = "M0_NET_BUF_RETAIN flag set."]
    #[doc = ""]
    #[doc = "The subroutine will also signal to all waiters on the"]
    #[doc = "m0_net_transfer_mc.ntm_chan field after delivery of the callback."]
    #[doc = ""]
    #[doc = "The invoking process should be aware that the callback subroutine could end"]
    #[doc = "up making re-entrant calls to the transport layer."]
    #[doc = ""]
    #[doc = "@param ev Event pointer. The nbe_buffer field identifies the buffer,"]
    #[doc = "and the buffer's nb_tm field identifies the associated transfer machine."]
    #[doc = ""]
    #[doc = "@see m0_net_tm_event_post()"]
    pub fn m0_net_buffer_event_post(ev: *const m0_net_buffer_event);
}
extern "C" {
    #[doc = "Deliver all pending network buffer events, by calling"]
    #[doc = "m0_net_buffer_event_post() every pending event. Should be called"]
    #[doc = "periodically by the application if synchronous network buffer event"]
    #[doc = "processing is enabled."]
    #[doc = ""]
    #[doc = "@param tm Pointer to a transfer machine which has been set up for"]
    #[doc = "synchronous network buffer event processing."]
    #[doc = ""]
    #[doc = "@pre !tm->ntm_bev_auto_deliver"]
    #[doc = ""]
    #[doc = "@see m0_net_buffer_event_deliver_synchronously(),"]
    #[doc = "m0_net_buffer_event_pending(), m0_net_buffer_event_notify()"]
    pub fn m0_net_buffer_event_deliver_all(tm: *mut m0_net_transfer_mc);
}
extern "C" {
    #[doc = "This subroutine disables the automatic delivery of network buffer events."]
    #[doc = "Instead, the application should use the m0_net_buffer_event_pending()"]
    #[doc = "subroutine to check for the presence of events, and the"]
    #[doc = "m0_net_buffer_event_deliver_all() subroutine to cause pending events to"]
    #[doc = "be delivered.  The m0_net_buffer_event_notify() subroutine can be used"]
    #[doc = "to get notified on a wait channel when buffer events arrive."]
    #[doc = ""]
    #[doc = "Support for this mode of operation is transport specific."]
    #[doc = ""]
    #[doc = "The subroutine must be invoked before the transfer machine is started."]
    #[doc = ""]
    #[doc = "@pre tm->ntm_bev_auto_deliver"]
    #[doc = "@post !tm->ntm_bev_auto_deliver"]
    #[doc = ""]
    #[doc = "@see m0_net_buffer_event_pending(), m0_net_buffer_event_deliver_all(),"]
    #[doc = "m0_net_buffer_event_notify()"]
    pub fn m0_net_buffer_event_deliver_synchronously(
        tm: *mut m0_net_transfer_mc,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "This subroutine determines if there are pending network buffer events that"]
    #[doc = "can be delivered with the m0_net_buffer_event_deliver_all() subroutine."]
    #[doc = ""]
    #[doc = "@pre !tm->ntm_bev_auto_deliver"]
    #[doc = ""]
    #[doc = "@see m0_net_buffer_event_deliver_synchronously()"]
    pub fn m0_net_buffer_event_pending(tm: *mut m0_net_transfer_mc) -> bool;
}
extern "C" {
    #[doc = "This subroutine arranges for notification of the arrival of the next network"]
    #[doc = "buffer event to be signalled on the specified channel. Typically, this"]
    #[doc = "subroutine is called only when the the m0_net_buffer_event_pending()"]
    #[doc = "subroutine indicates that there are no events pending. The subroutine does"]
    #[doc = "not block the invoker."]
    #[doc = ""]
    #[doc = "@note The subroutine exhibits \"monoshot\" behavior - it only signals once"]
    #[doc = "on the specified wait channel."]
    #[doc = ""]
    #[doc = "@pre !tm->ntm_bev_auto_deliver"]
    #[doc = ""]
    #[doc = "@see m0_net_buffer_event_deliver_synchronously()"]
    pub fn m0_net_buffer_event_notify(tm: *mut m0_net_transfer_mc, chan: *mut m0_chan);
}
extern "C" {
    #[doc = " Copies a network buffer descriptor."]
    pub fn m0_net_desc_copy(
        from_desc: *const m0_net_buf_desc,
        to_desc: *mut m0_net_buf_desc,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Frees a network buffer descriptor."]
    #[doc = "@param desc Specify the network buffer descriptor. Its fields will be"]
    #[doc = "cleared after this operation."]
    pub fn m0_net_desc_free(desc: *mut m0_net_buf_desc);
}
extern "C" {
    pub static m0_net_pool_tl: m0_tl_descr;
}
extern "C" {
    pub static m0_net_tm_tl: m0_tl_descr;
}
extern "C" {
    pub fn m0_net_pool_tlist_init(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_pool_tlist_fini(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_pool_tlink_init(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_invariant(head: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_net_pool_tlist_invariant_ext(
        head: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const m0_net_buffer,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        arg1: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn m0_net_pool_tlist_is_empty(list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_net_pool_tlink_init_at(amb: *mut m0_net_buffer, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_pool_tlink_init_at_tail(amb: *mut m0_net_buffer, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_pool_tlink_fini(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlink_del_fini(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlink_is_in(amb: *const m0_net_buffer) -> bool;
}
extern "C" {
    pub fn m0_net_pool_tlist_contains(list: *const m0_tl, amb: *const m0_net_buffer) -> bool;
}
extern "C" {
    pub fn m0_net_pool_tlist_length(list: *const m0_tl) -> size_t;
}
extern "C" {
    pub fn m0_net_pool_tlist_add(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_add_tail(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_add_after(amb: *mut m0_net_buffer, next: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_add_before(amb: *mut m0_net_buffer, next: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_del(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_remove(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_move(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_move_tail(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_pool_tlist_head(list: *const m0_tl) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_pool_tlist_pop(list: *const m0_tl) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_pool_tlist_tail(list: *const m0_tl) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_pool_tlist_next(
        list: *const m0_tl,
        amb: *const m0_net_buffer,
    ) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_pool_tlist_prev(
        list: *const m0_tl,
        amb: *const m0_net_buffer,
    ) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_tm_tlist_init(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_tm_tlist_fini(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_tm_tlink_init(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_invariant(head: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_net_tm_tlist_invariant_ext(
        head: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const m0_net_buffer,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        arg1: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn m0_net_tm_tlist_is_empty(list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_net_tm_tlink_init_at(amb: *mut m0_net_buffer, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_tm_tlink_init_at_tail(amb: *mut m0_net_buffer, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_net_tm_tlink_fini(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlink_del_fini(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlink_is_in(amb: *const m0_net_buffer) -> bool;
}
extern "C" {
    pub fn m0_net_tm_tlist_contains(list: *const m0_tl, amb: *const m0_net_buffer) -> bool;
}
extern "C" {
    pub fn m0_net_tm_tlist_length(list: *const m0_tl) -> size_t;
}
extern "C" {
    pub fn m0_net_tm_tlist_add(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_add_tail(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_add_after(amb: *mut m0_net_buffer, next: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_add_before(amb: *mut m0_net_buffer, next: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_del(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_remove(amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_move(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_move_tail(list: *mut m0_tl, amb: *mut m0_net_buffer);
}
extern "C" {
    pub fn m0_net_tm_tlist_head(list: *const m0_tl) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_tm_tlist_pop(list: *const m0_tl) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_tm_tlist_tail(list: *const m0_tl) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_tm_tlist_next(
        list: *const m0_tl,
        amb: *const m0_net_buffer,
    ) -> *mut m0_net_buffer;
}
extern "C" {
    pub fn m0_net_tm_tlist_prev(
        list: *const m0_tl,
        amb: *const m0_net_buffer,
    ) -> *mut m0_net_buffer;
}
extern "C" {
    #[doc = " Checks whether endpoint address is properly formatted."]
    #[doc = ""]
    #[doc = " Endpoint address format (ABNF):"]
    #[doc = ""]
    #[doc = "     endpoint = nid \":12345:\" DIGIT+ \":\" DIGIT+"]
    #[doc = "     ; <network id>:<process id>:<portal number>:<transfer machine id>"]
    #[doc = "     ;"]
    #[doc = "     nid      = \"0@lo\" / (ipv4addr  \"@\" (\"tcp\" / \"o2ib\") [DIGIT])"]
    #[doc = "     ipv4addr = 1*3DIGIT \".\" 1*3DIGIT \".\" 1*3DIGIT \".\" 1*3DIGIT ; 0..255"]
    pub fn m0_net_endpoint_is_valid(endpoint: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    #[doc = " Set the specified network transport as the default one."]
    pub fn m0_net_xprt_default_set(xprt: *const m0_net_xprt);
}
extern "C" {
    #[doc = " Register network transport."]
    pub fn m0_net_xprt_register(xprt: *const m0_net_xprt);
}
extern "C" {
    #[doc = " Deregister network transport."]
    pub fn m0_net_xprt_deregister(xprt: *const m0_net_xprt);
}
extern "C" {
    #[doc = " Return the default network transport."]
    pub fn m0_net_xprt_default_get() -> *mut m0_net_xprt;
}
extern "C" {
    #[doc = " Get all network transport ."]
    pub fn m0_net_all_xprt_get() -> *mut *mut m0_net_xprt;
}
extern "C" {
    #[doc = " Returns number of network transport."]
    pub fn m0_net_xprt_nr() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Print the list of registered xprt."]
    #[doc = "  This function is only for UT."]
    pub fn m0_net_print_xprt();
}
extern "C" {
    #[doc = " Search xprt in arrey of availabe transport."]
    #[doc = "  This function is only for UT."]
    pub fn m0_net_check_xprt(xprt: *const m0_net_xprt) -> bool;
}
extern "C" {
    pub fn default_xo_rpc_max_seg_size(ndom: *mut m0_net_domain) -> m0_bcount_t;
}
extern "C" {
    pub fn default_xo_rpc_max_segs_nr(ndom: *mut m0_net_domain) -> u32;
}
extern "C" {
    pub fn default_xo_rpc_max_msg_size(
        ndom: *mut m0_net_domain,
        rpc_size: m0_bcount_t,
    ) -> m0_bcount_t;
}
extern "C" {
    pub fn default_xo_rpc_max_recv_msgs(ndom: *mut m0_net_domain, rpc_size: m0_bcount_t) -> u32;
}
#[doc = "@addtogroup rpc"]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_cob_domain {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rpc_conn {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rpc_session {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_reqh {
    _unused: [u8; 0],
}
#[doc = " Default Maximum RPC message size is taken as 128k"]
pub const M0_RPC_DEF_MAX_RPC_MSG_SIZE: ::std::os::raw::c_uint = 131072;
pub type _bindgen_ty_34 = ::std::os::raw::c_uint;
#[doc = " Collection of statistics per rpc machine"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rpc_stats {
    pub rs_nr_rcvd_items: u64,
    pub rs_nr_sent_items: u64,
    pub rs_nr_failed_items: u64,
    pub rs_nr_dropped_items: u64,
    pub rs_nr_timedout_items: u64,
    pub rs_nr_sent_items_uniq: u64,
    pub rs_nr_resent_items: u64,
    pub rs_nr_resend_attempts: u64,
    pub rs_nr_ha_timedout_items: u64,
    pub rs_nr_ha_noted_conns: u64,
    pub rs_nr_rcvd_packets: u64,
    pub rs_nr_sent_packets: u64,
    pub rs_nr_failed_packets: u64,
    pub rs_nr_sent_bytes: u64,
    pub rs_nr_rcvd_bytes: u64,
}
#[test]
fn bindgen_test_layout_m0_rpc_stats() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_stats>(),
        120usize,
        concat!("Size of: ", stringify!(m0_rpc_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_stats>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_stats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_rcvd_items as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_rcvd_items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_sent_items as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_sent_items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_failed_items as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_failed_items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_dropped_items as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_dropped_items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_timedout_items as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_timedout_items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_sent_items_uniq as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_sent_items_uniq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_resent_items as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_resent_items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_resend_attempts as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_resend_attempts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_ha_timedout_items as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_ha_timedout_items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_ha_noted_conns as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_ha_noted_conns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_rcvd_packets as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_rcvd_packets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_sent_packets as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_sent_packets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_failed_packets as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_failed_packets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_sent_bytes as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_sent_bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_stats>())).rs_nr_rcvd_bytes as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_stats),
            "::",
            stringify!(rs_nr_rcvd_bytes)
        )
    );
}
#[doc = "RPC machine is an instance of RPC item (FOP/ADDB) processing context."]
#[doc = "Several such contexts might be existing simultaneously."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_rpc_machine {
    pub rm_sm_grp: m0_sm_group,
    #[doc = " List of m0_rpc_chan objects, linked using rc_linkage."]
    #[doc = "List descriptor: rpc_chan"]
    pub rm_chans: m0_tl,
    #[doc = " Transfer machine associated with this endpoint."]
    pub rm_tm: m0_net_transfer_mc,
    #[doc = " List of m0_rpc_conn objects, linked using c_link."]
    #[doc = "List descriptor: rpc_conn"]
    #[doc = "conn is in list if connection is not in {CONN_UNINITIALISED,"]
    #[doc = "CONN_FAILED, CONN_TERMINATED} states."]
    pub rm_incoming_conns: m0_tl,
    pub rm_outgoing_conns: m0_tl,
    pub rm_stats: m0_rpc_stats,
    #[doc = "Request handler this rpc_machine belongs to."]
    #[doc = "@todo There needs to be  generic mechanism to register a"]
    #[doc = "request handler (or any other handler for future use)"]
    #[doc = "with the rpc machine and a ops vector specifying a"]
    #[doc = "method to be invoked for futher processing,"]
    #[doc = "e.g. m0_reqh_fop_handle(), in case of reqh."]
    pub rm_reqh: *mut m0_reqh,
    pub rm_dtm: *mut m0_dtm,
    #[doc = "Linkage into request handler's list of rpc machines."]
    #[doc = "m0_reqh::rh_rpc_machines"]
    pub rm_rh_linkage: m0_tlink,
    #[doc = "List of m0_rpc_service instances placed using svc_tlink."]
    #[doc = "tl_descr: m0_rpc_services_tl"]
    pub rm_services: m0_tl,
    #[doc = "List of m0_rpc_machine_watch instances."]
    #[doc = "tlink: m0_rpc_machine_watch::mw_linkage"]
    #[doc = "tlist descr: rmach_watch"]
    pub rm_watch: m0_tl,
    #[doc = "Executes ASTs in rm_sm_grp."]
    pub rm_worker: m0_thread,
    pub rm_service: *mut m0_reqh_service,
    #[doc = "Flag asking rm_worker thread to stop."]
    pub rm_stopping: bool,
    #[doc = " Active (i.e., queued) network buffers."]
    pub rm_active_nb: u64,
    #[doc = " Signalled when rm_active_nb drops to 0."]
    pub rm_nb_idle: m0_chan,
    pub rm_magix: u64,
    #[doc = " @see m0_net_transfer_mc:ntm_recv_queue_min_recv_size"]
    #[doc = " The default value is m0_net_domain_get_max_buffer_size()"]
    pub rm_min_recv_size: u32,
    pub rm_lock_stats: m0_mutex_addb2,
    #[doc = " RPC bulk cut-off value. If AT buffer size equals or bigger than"]
    #[doc = " cut-off value, then it's transmitted via RPC bulk mechanism."]
    #[doc = " @see m0_rpc_at_buf"]
    pub rm_bulk_cutoff: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_rpc_machine() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_machine>(),
        2032usize,
        concat!("Size of: ", stringify!(m0_rpc_machine))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_machine>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_machine))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_sm_grp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_sm_grp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_chans as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_chans)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_tm as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_tm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_machine>())).rm_incoming_conns as *const _ as usize
        },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_incoming_conns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_machine>())).rm_outgoing_conns as *const _ as usize
        },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_outgoing_conns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_stats as *const _ as usize },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_stats)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_reqh as *const _ as usize },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_reqh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_dtm as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_dtm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_rh_linkage as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_rh_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_services as *const _ as usize },
        1336usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_services)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_watch as *const _ as usize },
        1360usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_watch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_worker as *const _ as usize },
        1384usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_worker)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_service as *const _ as usize },
        1568usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_service)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_stopping as *const _ as usize },
        1576usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_stopping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_active_nb as *const _ as usize },
        1584usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_active_nb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_nb_idle as *const _ as usize },
        1592usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_nb_idle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_magix as *const _ as usize },
        1640usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_magix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_min_recv_size as *const _ as usize },
        1648usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_min_recv_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_lock_stats as *const _ as usize },
        1656usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_lock_stats)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine>())).rm_bulk_cutoff as *const _ as usize },
        2024usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine),
            "::",
            stringify!(rm_bulk_cutoff)
        )
    );
}
extern "C" {
    #[doc = "Rpc machine is a running instance of rpc layer. A number of rpc machine"]
    #[doc = "structures can co-exist in rpc layer. With every rpc machine, a sessions"]
    #[doc = "module, a formation module, sending/receiving logic and statistics"]
    #[doc = "components are associated."]
    #[doc = ""]
    #[doc = "@param machine Input rpc_machine object."]
    #[doc = "@param net_dom Network domain, this rpc_machine is associated with."]
    #[doc = "@param ep_addr Source end point address to associate with the transfer mc."]
    #[doc = "@param receive_pool Buffer pool to be attached to TM for provisioning it."]
    #[doc = "@param colour Unique colour of each transfer machine."]
    #[doc = "Locality optimized buffer selection during provisioning is"]
    #[doc = "enabled by specifying a colour to be assigned to the internal"]
    #[doc = "network transfer machine; the invoker should assign each"]
    #[doc = "transfer machine in this network domain a unique colour."]
    #[doc = "Specify the M0_BUFFER_ANY_COLOUR constant if locality"]
    #[doc = "optimizations are not required."]
    #[doc = "@param msg_size Maximum RPC message size."]
    #[doc = "The M0_RPC_DEF_MAX_RPC_MSG_SIZE constant provides a"]
    #[doc = "suitable default value."]
    #[doc = "@param queue_len Minimum TM receive queue length."]
    #[doc = "The M0_NET_TM_RECV_QUEUE_DEF_LEN constant provides a"]
    #[doc = "suitable default value."]
    #[doc = ""]
    #[doc = "@note machine->rm_bulk_cutoff value is initialised to the half of message"]
    #[doc = "size aligned to the next page boundary. User is allowed to change this value"]
    #[doc = "after initialisation by direct field assignment."]
    #[doc = ""]
    #[doc = "@see m0_rpc_max_msg_size()"]
    pub fn m0_rpc_machine_init(
        machine: *mut m0_rpc_machine,
        net_dom: *mut m0_net_domain,
        ep_addr: *const ::std::os::raw::c_char,
        reqh: *mut m0_reqh,
        receive_pool: *mut m0_net_buffer_pool,
        colour: u32,
        msg_size: m0_bcount_t,
        queue_len: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_rpc_machine_fini(machine: *mut m0_rpc_machine);
}
extern "C" {
    pub fn m0_rpc_machine_get_stats(
        machine: *mut m0_rpc_machine,
        stats: *mut m0_rpc_stats,
        reset: bool,
    );
}
extern "C" {
    pub fn m0_rpc_machine_drain_item_sources(machine: *mut m0_rpc_machine, max_per_source: u32);
}
extern "C" {
    pub fn m0_rpc_machine_ep(rmach: *const m0_rpc_machine) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn m0_rpc_machine_lock(machine: *mut m0_rpc_machine);
}
extern "C" {
    pub fn m0_rpc_machine_unlock(machine: *mut m0_rpc_machine);
}
extern "C" {
    pub fn m0_rpc_machine_is_locked(machine: *const m0_rpc_machine) -> bool;
}
extern "C" {
    pub fn m0_rpc_machine_is_not_locked(machine: *const m0_rpc_machine) -> bool;
}
extern "C" {
    pub fn m0_rpc_machine_bob_init(bob: *mut m0_rpc_machine);
}
extern "C" {
    pub fn m0_rpc_machine_bob_fini(bob: *mut m0_rpc_machine);
}
extern "C" {
    pub fn m0_rpc_machine_bob_check(bob: *const m0_rpc_machine) -> bool;
}
#[doc = " RPC machine watch is a suite of call-backs invoked by the rpc code when new"]
#[doc = " connection or session is created within the rpc machine the watch is"]
#[doc = " attached to."]
#[doc = ""]
#[doc = " Call-backs are invoked under the rpc machine lock."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rpc_machine_watch {
    #[doc = " Datum that can be used to associate additional state to the watcher."]
    pub mw_datum: *mut ::std::os::raw::c_void,
    #[doc = " RPC machine this watcher is attached to. This field must be set"]
    #[doc = " before calling m0_rpc_machine_watch_attach()."]
    pub mw_mach: *mut m0_rpc_machine,
    #[doc = " Linkage into m0_rpc_machine::rm_watch list of all watches for this"]
    #[doc = " machine."]
    pub mw_linkage: m0_tlink,
    #[doc = " This is invoked when a connection is added to one of the rpc machine"]
    #[doc = " connection lists. The connection is in M0_RPC_CONN_INITIALISED state."]
    pub mw_conn_added: ::std::option::Option<
        unsafe extern "C" fn(w: *mut m0_rpc_machine_watch, conn: *mut m0_rpc_conn),
    >,
    #[doc = " This is called when a session is added to the connection list of"]
    #[doc = " sessions (m0_rpc_conn::c_sessions). The session is in"]
    #[doc = " M0_RPC_SESSION_INITIALISED state."]
    pub mw_session_added: ::std::option::Option<
        unsafe extern "C" fn(w: *mut m0_rpc_machine_watch, session: *mut m0_rpc_session),
    >,
    #[doc = " This call-back is called when the rpc machine is terminated, while"]
    #[doc = " still having attached watches. The watch is removed from the watch"]
    #[doc = " list before this call-back is invoked. There is neither need nor harm"]
    #[doc = " in calling m0_rpc_machine_watch_detach() once this call-back was"]
    #[doc = " invoked."]
    pub mw_mach_terminated:
        ::std::option::Option<unsafe extern "C" fn(w: *mut m0_rpc_machine_watch)>,
    #[doc = " @see M0_RPC_MACHINE_WATCH_MAGIC"]
    pub mw_magic: u64,
}
#[test]
fn bindgen_test_layout_m0_rpc_machine_watch() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_machine_watch>(),
        64usize,
        concat!("Size of: ", stringify!(m0_rpc_machine_watch))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_machine_watch>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_machine_watch))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_datum as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_datum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_mach as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_mach)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_linkage as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_linkage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_conn_added as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_conn_added)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_session_added as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_session_added)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_mach_terminated as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_mach_terminated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_machine_watch>())).mw_magic as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_machine_watch),
            "::",
            stringify!(mw_magic)
        )
    );
}
extern "C" {
    #[doc = " Attaches a watch to its rpc machine."]
    #[doc = ""]
    #[doc = " @pre watch->mw_mach != NULL"]
    #[doc = " @pre m0_rpc_machine_is_not_locked(watch->mw_mach)"]
    pub fn m0_rpc_machine_watch_attach(watch: *mut m0_rpc_machine_watch);
}
extern "C" {
    #[doc = " Detaches a watch from its rpc machine, if still attached."]
    #[doc = ""]
    #[doc = " @pre watch->mw_mach != NULL"]
    #[doc = " @pre m0_rpc_machine_is_not_locked(watch->mw_mach)"]
    pub fn m0_rpc_machine_watch_detach(watch: *mut m0_rpc_machine_watch);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fid {
    pub f_container: u64,
    pub f_key: u64,
}
#[test]
fn bindgen_test_layout_m0_fid() {
    assert_eq!(
        ::std::mem::size_of::<m0_fid>(),
        16usize,
        concat!("Size of: ", stringify!(m0_fid))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fid>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid>())).f_container as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid),
            "::",
            stringify!(f_container)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid>())).f_key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid),
            "::",
            stringify!(f_key)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fid_arr {
    pub af_count: u32,
    pub af_elems: *mut m0_fid,
}
#[test]
fn bindgen_test_layout_m0_fid_arr() {
    assert_eq!(
        ::std::mem::size_of::<m0_fid_arr>(),
        16usize,
        concat!("Size of: ", stringify!(m0_fid_arr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fid_arr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fid_arr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid_arr>())).af_count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid_arr),
            "::",
            stringify!(af_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid_arr>())).af_elems as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid_arr),
            "::",
            stringify!(af_elems)
        )
    );
}
extern "C" {
    pub fn m0_fid_is_set(fid: *const m0_fid) -> bool;
}
extern "C" {
    pub fn m0_fid_is_valid(fid: *const m0_fid) -> bool;
}
extern "C" {
    pub fn m0_fid_eq(fid0: *const m0_fid, fid1: *const m0_fid) -> bool;
}
extern "C" {
    pub fn m0_fid_cmp(fid0: *const m0_fid, fid1: *const m0_fid) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fid_set(fid: *mut m0_fid, container: u64, key: u64);
}
extern "C" {
    pub fn m0_fid_tset(fid: *mut m0_fid, tid: u8, container: u64, key: u64);
}
extern "C" {
    pub fn m0_fid_tget(fid: *const m0_fid) -> u8;
}
extern "C" {
    pub fn m0_fid_tchange(fid: *mut m0_fid, tid: u8);
}
extern "C" {
    pub fn m0_fid_sscanf(
        s: *const ::std::os::raw::c_char,
        fid: *mut m0_fid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fid_print(
        s: *mut ::std::os::raw::c_char,
        s_len: size_t,
        fid: *const m0_fid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fid_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fid_fini();
}
#[doc = " Clears high 8 bits off."]
pub const M0_FID_TYPE_MASK: ::std::os::raw::c_ulong = 72057594037927935;
#[doc = " Clears high 8 bits off."]
pub const M0_FID_STR_LEN: ::std::os::raw::c_ulong = 64;
pub type _bindgen_ty_35 = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fid_type {
    pub ft_id: u8,
    pub ft_name: *const ::std::os::raw::c_char,
    pub ft_is_valid: ::std::option::Option<unsafe extern "C" fn(fid: *const m0_fid) -> bool>,
}
#[test]
fn bindgen_test_layout_m0_fid_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_fid_type>(),
        24usize,
        concat!("Size of: ", stringify!(m0_fid_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fid_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fid_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid_type>())).ft_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid_type),
            "::",
            stringify!(ft_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid_type>())).ft_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid_type),
            "::",
            stringify!(ft_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fid_type>())).ft_is_valid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fid_type),
            "::",
            stringify!(ft_is_valid)
        )
    );
}
extern "C" {
    pub fn m0_fid_type_register(fidt: *const m0_fid_type);
}
extern "C" {
    pub fn m0_fid_type_unregister(fidt: *const m0_fid_type);
}
extern "C" {
    pub fn m0_fid_type_get(id: u8) -> *const m0_fid_type;
}
extern "C" {
    pub fn m0_fid_type_gethi(id: u64) -> *const m0_fid_type;
}
extern "C" {
    pub fn m0_fid_type_getfid(fid: *const m0_fid) -> *const m0_fid_type;
}
extern "C" {
    pub fn m0_fid_type_getname(name: *const ::std::os::raw::c_char) -> *const m0_fid_type;
}
extern "C" {
    pub fn m0_fid_tassume(fid: *mut m0_fid, ft: *const m0_fid_type);
}
extern "C" {
    pub fn m0_fid_tgenerate(fid: *mut m0_fid, tid: u8);
}
extern "C" {
    pub fn m0_fid_hash(fid: *const m0_fid) -> u64;
}
extern "C" {
    pub fn m0_fid_arr_copy(to: *mut m0_fid_arr, from: *const m0_fid_arr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fid_arr_eq(a: *const m0_fid_arr, b: *const m0_fid_arr) -> bool;
}
extern "C" {
    pub fn m0_fid_arr_all_unique(a: *const m0_fid_arr) -> bool;
}
#[doc = " Holds an address of a remote object and its generation count."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_cookie {
    pub co_addr: u64,
    pub co_generation: u64,
}
#[test]
fn bindgen_test_layout_m0_cookie() {
    assert_eq!(
        ::std::mem::size_of::<m0_cookie>(),
        16usize,
        concat!("Size of: ", stringify!(m0_cookie))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_cookie>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_cookie))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_cookie>())).co_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_cookie),
            "::",
            stringify!(co_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_cookie>())).co_generation as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_cookie),
            "::",
            stringify!(co_generation)
        )
    );
}
extern "C" {
    #[doc = " Initializes the gencount. Gets called during motr initialization."]
    pub fn m0_cookie_global_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_cookie_global_fini();
}
extern "C" {
    #[doc = " Increments generation-count by one and assigns the same to *gen."]
    pub fn m0_cookie_new(gen: *mut u64);
}
extern "C" {
    #[doc = " Embeds address of an object along with a generation-count in a cookie."]
    #[doc = ""]
    #[doc = " @param cookie (out)   address of a cookie in which obj gets embedded"]
    #[doc = " @param obj (in)\t address of an object"]
    pub fn m0_cookie_init(cookie: *mut m0_cookie, obj: *const u64);
}
extern "C" {
    #[doc = " Retrieves address of an object from a cookie."]
    #[doc = ""]
    #[doc = " @param cookie (in)   address of a cookie that holds the address of an object"]
    #[doc = " @param addr (out)    pointer to a memory location which holds retrieved"]
    #[doc = "                      address"]
    pub fn m0_cookie_dereference(
        cookie: *const m0_cookie,
        addr: *mut *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Checks if address is pointing to a valid memory location."]
    #[doc = " @see m0_addr_is_sane_and_aligned()"]
    pub fn m0_addr_is_sane(addr: *const u64) -> bool;
}
extern "C" {
    #[doc = " Checks if address is aligned to 8-byte address and is pointing to a valid"]
    #[doc = " memory location."]
    #[doc = " @see m0_addr_is_sane()"]
    pub fn m0_addr_is_sane_and_aligned(addr: *const u64) -> bool;
}
extern "C" {
    #[doc = " Returns 'true' when cookie is NULL."]
    pub fn m0_cookie_is_null(cookie: *const m0_cookie) -> bool;
}
extern "C" {
    #[doc = " Compares two cookies."]
    pub fn m0_cookie_is_eq(cookie1: *const m0_cookie, cookie2: *const m0_cookie) -> bool;
}
extern "C" {
    pub static M0_COOKIE_NULL: m0_cookie;
}
pub const m0_entity_opcode_M0_EO_INVALID: m0_entity_opcode = 0;
pub const m0_entity_opcode_M0_EO_CREATE: m0_entity_opcode = 1;
pub const m0_entity_opcode_M0_EO_DELETE: m0_entity_opcode = 2;
pub const m0_entity_opcode_M0_EO_SYNC: m0_entity_opcode = 3;
pub const m0_entity_opcode_M0_EO_OPEN: m0_entity_opcode = 4;
pub const m0_entity_opcode_M0_EO_GETATTR: m0_entity_opcode = 5;
pub const m0_entity_opcode_M0_EO_SETATTR: m0_entity_opcode = 6;
pub const m0_entity_opcode_M0_EO_LAYOUT_GET: m0_entity_opcode = 7;
pub const m0_entity_opcode_M0_EO_LAYOUT_SET: m0_entity_opcode = 8;
pub const m0_entity_opcode_M0_EO_NR: m0_entity_opcode = 9;
#[doc = " Operation codes for entity, object and index."]
pub type m0_entity_opcode = ::std::os::raw::c_uint;
#[doc = " Read object data."]
pub const m0_obj_opcode_M0_OC_READ: m0_obj_opcode = 10;
#[doc = " Write object data."]
pub const m0_obj_opcode_M0_OC_WRITE: m0_obj_opcode = 11;
#[doc = " Pre-allocate space."]
pub const m0_obj_opcode_M0_OC_ALLOC: m0_obj_opcode = 12;
#[doc = " De-allocate space, consecutive reads will return 0s."]
pub const m0_obj_opcode_M0_OC_FREE: m0_obj_opcode = 13;
#[doc = " De-allocate space, consecutive reads will return 0s."]
pub const m0_obj_opcode_M0_OC_NR: m0_obj_opcode = 14;
#[doc = " Object operation codes."]
pub type m0_obj_opcode = ::std::os::raw::c_uint;
#[doc = " Lookup a value with the given key."]
pub const m0_idx_opcode_M0_IC_GET: m0_idx_opcode = 15;
#[doc = " Insert or update the value, given a key."]
pub const m0_idx_opcode_M0_IC_PUT: m0_idx_opcode = 16;
#[doc = " Delete the value, if any, for the given key."]
pub const m0_idx_opcode_M0_IC_DEL: m0_idx_opcode = 17;
#[doc = " Given a key, return the next key and its value."]
pub const m0_idx_opcode_M0_IC_NEXT: m0_idx_opcode = 18;
#[doc = " Check an index for an existence."]
pub const m0_idx_opcode_M0_IC_LOOKUP: m0_idx_opcode = 19;
#[doc = " Given an index id, get the list of next indices."]
pub const m0_idx_opcode_M0_IC_LIST: m0_idx_opcode = 20;
#[doc = " Given an index id, get the list of next indices."]
pub const m0_idx_opcode_M0_IC_NR: m0_idx_opcode = 21;
pub type m0_idx_opcode = ::std::os::raw::c_uint;
#[doc = " Read operation should not see any holes. If a hole is met during"]
#[doc = " read, return error instead."]
pub const m0_op_obj_flags_M0_OOF_NOHOLE: m0_op_obj_flags = 1;
#[doc = " Write, alloc and free operations wait for the transaction to become"]
#[doc = " persistent before returning."]
pub const m0_op_obj_flags_M0_OOF_SYNC: m0_op_obj_flags = 2;
#[doc = " Flags passed to m0_obj_op() to specify object IO operation behaviour."]
pub type m0_op_obj_flags = ::std::os::raw::c_uint;
pub const m0_entity_type_M0_ET_REALM: m0_entity_type = 0;
pub const m0_entity_type_M0_ET_OBJ: m0_entity_type = 1;
pub const m0_entity_type_M0_ET_IDX: m0_entity_type = 2;
#[doc = " Types of entities supported by client."]
pub type m0_entity_type = ::std::os::raw::c_uint;
#[doc = " During create if this flag is set in entity->en_flags, that means"]
#[doc = " application has capability to store meta-data and hence pver and"]
#[doc = " lid can be stored in  application's meta-data."]
#[doc = " Before calling to m0_entity_create/open(), application is"]
#[doc = " expected to set obj>ob_entity->en_flags |= M0_ENF_META, so when"]
#[doc = " m0_entity_create() returns to application, pool version and layout id"]
#[doc = " will be available to application into obj->ob_attr.oa_pver and"]
#[doc = " obj->ob_attr.oa_lid respectively and can be stored into application's"]
#[doc = " meta-data."]
#[doc = ""]
#[doc = " For example:"]
#[doc = " Create workflow would be like:"]
#[doc = "   obj->ob_entity.en_flags |= M0_ENF_META;"]
#[doc = "   m0_entity_create((NULL, &obj.ob_entity, &ops[0]);"]
#[doc = "   //  Save the returned pool version and lid into app_meta_data"]
#[doc = "   app_meta_data.pver = obj->ob_attr.oa_pver;"]
#[doc = "   app_meta_data.lid = obj->ob_attr.oa_lid;"]
#[doc = ""]
#[doc = " Read workflow:"]
#[doc = "   obj->ob_attr.oa_pver = app_meta_data.pver;"]
#[doc = "   obj->ob_attr.oa_lid =  app_meta_data.lid;"]
#[doc = "   m0_entity_open(NULL, &obj.ob_entity, &ops[0]);"]
pub const m0_entity_flags_M0_ENF_META: m0_entity_flags = 1;
#[doc = " If this flags is set during entity_create() that means application"]
#[doc = " do not support update operation. This flag is not in use yet."]
pub const m0_entity_flags_M0_ENF_NO_RMW: m0_entity_flags = 2;
#[doc = " Flags passed to m0_entitiy_create(), m0_entity_open() to specify"]
#[doc = " application's behaviour."]
pub type m0_entity_flags = ::std::os::raw::c_uint;
#[doc = " Generic client operation structure."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_op {
    pub op_magic: u64,
    #[doc = " Operation code."]
    #[doc = ""]
    #[doc = " @see m0_entity_opcode, m0_realm_opcode"]
    #[doc = " @see m0_obj_opcode, m0_idx_opcode,"]
    pub op_code: ::std::os::raw::c_uint,
    #[doc = " Operation result code"]
    pub op_rc: i32,
    #[doc = " Each op has its own sm group."]
    pub op_sm_group: m0_sm_group,
    #[doc = " Operation state machine."]
    pub op_sm: m0_sm,
    #[doc = " Application-supplied call-backs."]
    pub op_cbs: *const m0_op_ops,
    #[doc = " The entity this operation is on."]
    pub op_entity: *mut m0_entity,
    #[doc = " Caching dead-line."]
    pub op_linger: m0_time_t,
    #[doc = " Size of the ambient operation structure."]
    pub op_size: size_t,
    #[doc = " Part of a cookie (m0_cookie) used to identify this operation."]
    pub op_gen: u64,
    #[doc = " Back pointer to parent op and it is used to form an execution plan"]
    #[doc = " for a group of ops. An example: an composite layout IO op is divided"]
    #[doc = " into a few IO ops to sub-objects. Each sub-object IO op has an"]
    #[doc = " pointer to the composite IO op."]
    pub op_parent: *mut m0_op,
    pub op_parent_ast: m0_sm_ast,
    #[doc = " list of pending transactions."]
    pub op_pending_tx: m0_tl,
    pub op_pending_tx_lock: m0_mutex,
    pub op_datum: *mut ::std::os::raw::c_void,
    pub op_count: u64,
    #[doc = " Private field, to be used by internal implementation."]
    pub op_priv: *mut ::std::os::raw::c_void,
    pub op_priv_lock: m0_mutex,
}
#[test]
fn bindgen_test_layout_m0_op() {
    assert_eq!(
        ::std::mem::size_of::<m0_op>(),
        576usize,
        concat!("Size of: ", stringify!(m0_op))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_op>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_rc as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_rc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_sm_group as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_sm_group)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_sm as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_sm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_cbs as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_cbs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_entity as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_entity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_linger as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_linger)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_size as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_gen as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_parent as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_parent_ast as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_parent_ast)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_pending_tx as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_pending_tx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_pending_tx_lock as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_pending_tx_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_datum as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_datum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_count as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_priv as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_priv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op>())).op_priv_lock as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op),
            "::",
            stringify!(op_priv_lock)
        )
    );
}
pub const m0_op_state_M0_OS_UNINITIALISED: m0_op_state = 0;
pub const m0_op_state_M0_OS_INITIALISED: m0_op_state = 1;
pub const m0_op_state_M0_OS_LAUNCHED: m0_op_state = 2;
pub const m0_op_state_M0_OS_EXECUTED: m0_op_state = 3;
pub const m0_op_state_M0_OS_STABLE: m0_op_state = 4;
pub const m0_op_state_M0_OS_FAILED: m0_op_state = 5;
pub const m0_op_state_M0_OS_NR: m0_op_state = 6;
#[doc = " Operation state, stored in m0_op::op_sm::sm_state."]
pub type m0_op_state = ::std::os::raw::c_uint;
#[doc = " Common structure shared by objects, indices and realms."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_entity {
    #[doc = " Entity type."]
    pub en_type: m0_entity_type,
    #[doc = " Globally unique, not re-usable entity identifier."]
    pub en_id: m0_uint128,
    #[doc = " Parent realm, this entity lives in."]
    pub en_realm: *mut m0_realm,
    #[doc = " Entity state machine. Used internally by the implementation. For the"]
    #[doc = " reference, the state diagram is:"]
    #[doc = ""]
    #[doc = " @verbatim"]
    #[doc = "                  create"]
    #[doc = "        CREATING<--------+"]
    #[doc = "            |            |"]
    #[doc = "            |            |"]
    #[doc = "            |            |"]
    #[doc = "            |            |"]
    #[doc = "            +---------->INIT<----------------------CLOSING"]
    #[doc = "            |            | |                           ^"]
    #[doc = "            |            | |                           |"]
    #[doc = "            |            | |                           | close"]
    #[doc = "            |            | |                           |"]
    #[doc = "        DELETING<--------+ +-------->OPENING-------->OPEN"]
    #[doc = "                  delete      open"]
    #[doc = " @endverbatim"]
    #[doc = ""]
    pub en_sm: m0_sm,
    #[doc = " Each entity has its own sm group."]
    pub en_sm_group: m0_sm_group,
    #[doc = " list of pending transactions."]
    pub en_pending_tx: m0_tl,
    pub en_pending_tx_lock: m0_mutex,
    pub en_flags: u32,
}
#[test]
fn bindgen_test_layout_m0_entity() {
    assert_eq!(
        ::std::mem::size_of::<m0_entity>(),
        440usize,
        concat!("Size of: ", stringify!(m0_entity))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_entity>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_entity))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_realm as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_realm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_sm as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_sm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_sm_group as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_sm_group)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_pending_tx as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_pending_tx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_pending_tx_lock as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_pending_tx_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_entity>())).en_flags as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_entity),
            "::",
            stringify!(en_flags)
        )
    );
}
#[doc = " Object attributes."]
#[doc = ""]
#[doc = " This is supplied by an application when an object is created and returned by"]
#[doc = " the implementation when an object is opened."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_obj_attr {
    #[doc = " Binary logarithm (bit-shift) of object minimal block size."]
    pub oa_bshift: m0_bcount_t,
    #[doc = " Layout ID for an object."]
    pub oa_layout_id: u64,
    #[doc = " The pool this object stores data to. A pool can be selected when"]
    #[doc = " creating an object by specifying this field. A pool version matching"]
    #[doc = " the specified pool fid is then chosen for the object. The pool"]
    #[doc = " version is then stored as one of its attributes in service's backend."]
    pub oa_pool: m0_fid,
    #[doc = " Pool version fid"]
    pub oa_pver: m0_fid,
    #[doc = " Buffer size for object IO. Set this before m0_obj_init() to generate"]
    #[doc = " optimal layout id during m0_entity_create()."]
    pub oa_buf_size: size_t,
}
#[test]
fn bindgen_test_layout_m0_obj_attr() {
    assert_eq!(
        ::std::mem::size_of::<m0_obj_attr>(),
        56usize,
        concat!("Size of: ", stringify!(m0_obj_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_obj_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_obj_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj_attr>())).oa_bshift as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj_attr),
            "::",
            stringify!(oa_bshift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj_attr>())).oa_layout_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj_attr),
            "::",
            stringify!(oa_layout_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj_attr>())).oa_pool as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj_attr),
            "::",
            stringify!(oa_pool)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj_attr>())).oa_pver as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj_attr),
            "::",
            stringify!(oa_pver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj_attr>())).oa_buf_size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj_attr),
            "::",
            stringify!(oa_buf_size)
        )
    );
}
pub const m0_client_layout_type_M0_LT_PDCLUST: m0_client_layout_type = 0;
pub const m0_client_layout_type_M0_LT_COMPOSITE: m0_client_layout_type = 1;
pub const m0_client_layout_type_M0_LT_CAPTURE: m0_client_layout_type = 2;
pub const m0_client_layout_type_M0_LT_NR: m0_client_layout_type = 3;
#[doc = " Layout is of an entity containing information to locate data"]
#[doc = " (node, service, device). TODO: rewrite the definition."]
pub type m0_client_layout_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_obj {
    pub ob_entity: m0_entity,
    pub ob_attr: m0_obj_attr,
    pub ob_layout: *mut m0_client_layout,
    #[doc = " Cookie associated with a RM context"]
    pub ob_cookie: m0_cookie,
}
#[test]
fn bindgen_test_layout_m0_obj() {
    assert_eq!(
        ::std::mem::size_of::<m0_obj>(),
        520usize,
        concat!("Size of: ", stringify!(m0_obj))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_obj>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_obj))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj>())).ob_entity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj),
            "::",
            stringify!(ob_entity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj>())).ob_attr as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj),
            "::",
            stringify!(ob_attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj>())).ob_layout as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj),
            "::",
            stringify!(ob_layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_obj>())).ob_cookie as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_obj),
            "::",
            stringify!(ob_cookie)
        )
    );
}
#[doc = " Object is an array of blocks. Each block has 64-bit index and a block"]
#[doc = " attributes."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_client_layout {
    pub ml_entity: m0_entity,
    pub ml_type: m0_client_layout_type,
    pub ml_obj: *mut m0_obj,
    pub ml_ops: *mut m0_client_layout_ops,
}
#[test]
fn bindgen_test_layout_m0_client_layout() {
    assert_eq!(
        ::std::mem::size_of::<m0_client_layout>(),
        464usize,
        concat!("Size of: ", stringify!(m0_client_layout))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_client_layout>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_client_layout))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_client_layout>())).ml_entity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_client_layout),
            "::",
            stringify!(ml_entity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_client_layout>())).ml_type as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_client_layout),
            "::",
            stringify!(ml_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_client_layout>())).ml_obj as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_client_layout),
            "::",
            stringify!(ml_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_client_layout>())).ml_ops as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_client_layout),
            "::",
            stringify!(ml_ops)
        )
    );
}
#[doc = " Index attributes."]
#[doc = ""]
#[doc = " This is supplied by an application and return by the implementation"]
#[doc = " when an index is created."]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_attr {
    #[doc = " DIX pool layout type. Please refer to enum dix_layout_type."]
    pub idx_layout_type: u32,
    #[doc = " DIX pool version."]
    pub idx_pver: m0_fid,
}
#[test]
fn bindgen_test_layout_m0_idx_attr() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_attr>(),
        24usize,
        concat!("Size of: ", stringify!(m0_idx_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_attr>())).idx_layout_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_attr),
            "::",
            stringify!(idx_layout_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_attr>())).idx_pver as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_attr),
            "::",
            stringify!(idx_pver)
        )
    );
}
#[doc = " Index is an ordered key-value store."]
#[doc = ""]
#[doc = " A record is a key-value pair. A new record can be inserted in an index,"]
#[doc = " record with a given key can be looked for, updated or deleted."]
#[doc = ""]
#[doc = " An index can be iterated starting from a given key. Keys are ordered in the"]
#[doc = " lexicographical order of their bit-representations."]
#[doc = ""]
#[doc = " Entity identifier in_entity::en_id format depends on index service type."]
#[doc = " M0_IDX_MOCK and M0_IDX_CASS services accept arbitrary"]
#[doc = " identifiers. M0_IDX_DIX service supports two types of indices:"]
#[doc = " - distributed index, which is identified by well-formed motr fid having"]
#[doc = "   m0_dix_fid_type type."]
#[doc = " - non-distributed index, which is identified by well-formed motr fid having"]
#[doc = "   m0_cas_index_fid_type type."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_idx {
    pub in_entity: m0_entity,
    pub in_attr: m0_idx_attr,
}
#[test]
fn bindgen_test_layout_m0_idx() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx>(),
        464usize,
        concat!("Size of: ", stringify!(m0_idx))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx>())).in_entity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx),
            "::",
            stringify!(in_entity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx>())).in_attr as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx),
            "::",
            stringify!(in_attr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_composite_layer_idx_key {
    pub cek_layer_id: m0_uint128,
    pub cek_off: m0_bindex_t,
}
#[test]
fn bindgen_test_layout_m0_composite_layer_idx_key() {
    assert_eq!(
        ::std::mem::size_of::<m0_composite_layer_idx_key>(),
        24usize,
        concat!("Size of: ", stringify!(m0_composite_layer_idx_key))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_composite_layer_idx_key>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_composite_layer_idx_key))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_composite_layer_idx_key>())).cek_layer_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_composite_layer_idx_key),
            "::",
            stringify!(cek_layer_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_composite_layer_idx_key>())).cek_off as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_composite_layer_idx_key),
            "::",
            stringify!(cek_off)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_composite_layer_idx_val {
    pub cev_len: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_composite_layer_idx_val() {
    assert_eq!(
        ::std::mem::size_of::<m0_composite_layer_idx_val>(),
        8usize,
        concat!("Size of: ", stringify!(m0_composite_layer_idx_val))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_composite_layer_idx_val>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_composite_layer_idx_val))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_composite_layer_idx_val>())).cev_len as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_composite_layer_idx_val),
            "::",
            stringify!(cev_len)
        )
    );
}
pub const m0_realm_type_M0_ST_CONTAINER: m0_realm_type = 0;
pub const m0_realm_type_M0_ST_EPOCH: m0_realm_type = 1;
pub const m0_realm_type_M0_ST_DTX: m0_realm_type = 2;
pub const m0_realm_type_M0_ST_NR: m0_realm_type = 3;
pub type m0_realm_type = ::std::os::raw::c_uint;
#[doc = " Forward declaration: m0_client represents a client instance, a connection"]
#[doc = " to a motr cluster."]
#[doc = ""]
#[doc = " Defined in motr/client_internal.h"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_client {
    _unused: [u8; 0],
}
#[doc = " Realm is where entities (including other realms) live."]
#[doc = ""]
#[doc = " @see m0_container, m0_epoch, m0__dtx."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_realm {
    pub re_entity: m0_entity,
    pub re_type: m0_realm_type,
    pub re_instance: *mut m0_client,
}
#[test]
fn bindgen_test_layout_m0_realm() {
    assert_eq!(
        ::std::mem::size_of::<m0_realm>(),
        456usize,
        concat!("Size of: ", stringify!(m0_realm))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_realm>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_realm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_realm>())).re_entity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_realm),
            "::",
            stringify!(re_entity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_realm>())).re_type as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_realm),
            "::",
            stringify!(re_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_realm>())).re_instance as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_realm),
            "::",
            stringify!(re_instance)
        )
    );
}
#[doc = " Container is a special type of realm, used to partition storage system among"]
#[doc = " applications."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_container {
    pub co_realm: m0_realm,
}
#[test]
fn bindgen_test_layout_m0_container() {
    assert_eq!(
        ::std::mem::size_of::<m0_container>(),
        456usize,
        concat!("Size of: ", stringify!(m0_container))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_container>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_container))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_container>())).co_realm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_container),
            "::",
            stringify!(co_realm)
        )
    );
}
#[doc = " Epoch is a special type of realm, used by an application (or a"]
#[doc = " collaborative set of applications) to partition their work in consistent"]
#[doc = " portions."]
#[doc = ""]
#[doc = " Epoch boundary should be a consistent (from application point of view) state"]
#[doc = " of storage. By resuming from a given epoch, applications can implement a"]
#[doc = " scalable failure recovery mechanism."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_epoch {
    pub ep_realm: m0_realm,
}
#[test]
fn bindgen_test_layout_m0_epoch() {
    assert_eq!(
        ::std::mem::size_of::<m0_epoch>(),
        456usize,
        concat!("Size of: ", stringify!(m0_epoch))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_epoch>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_epoch))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_epoch>())).ep_realm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_epoch),
            "::",
            stringify!(ep_realm)
        )
    );
}
#[doc = " Distributed transaction is a special type of realm, which is a group of"]
#[doc = " operations atomic w.r.t. certain failures."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0__dtx {
    pub dt_realm: m0_realm,
}
#[test]
fn bindgen_test_layout_m0__dtx() {
    assert_eq!(
        ::std::mem::size_of::<m0__dtx>(),
        456usize,
        concat!("Size of: ", stringify!(m0__dtx))
    );
    assert_eq!(
        ::std::mem::align_of::<m0__dtx>(),
        8usize,
        concat!("Alignment of ", stringify!(m0__dtx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0__dtx>())).dt_realm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0__dtx),
            "::",
            stringify!(dt_realm)
        )
    );
}
#[doc = " Operation callbacks."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_op_ops {
    pub oop_executed: ::std::option::Option<unsafe extern "C" fn(op: *mut m0_op)>,
    pub oop_failed: ::std::option::Option<unsafe extern "C" fn(op: *mut m0_op)>,
    pub oop_stable: ::std::option::Option<unsafe extern "C" fn(op: *mut m0_op)>,
}
#[test]
fn bindgen_test_layout_m0_op_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_op_ops>(),
        24usize,
        concat!("Size of: ", stringify!(m0_op_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_op_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_op_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op_ops>())).oop_executed as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op_ops),
            "::",
            stringify!(oop_executed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op_ops>())).oop_failed as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op_ops),
            "::",
            stringify!(oop_failed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_op_ops>())).oop_stable as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_op_ops),
            "::",
            stringify!(oop_stable)
        )
    );
}
#[doc = " m0_config contains configuration parameters to setup an"]
#[doc = " client instance."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_config {
    #[doc = " oostore mode is set when 'is_oostore' is TRUE."]
    pub mc_is_oostore: bool,
    #[doc = " Flag for verify-on-read. Parity is checked when doing"]
    #[doc = " READ's if this flag is set."]
    pub mc_is_read_verify: bool,
    #[doc = " Flag to enable/disable addb2 initialization"]
    pub mc_is_addb_init: bool,
    #[doc = " Local endpoint."]
    pub mc_local_addr: *const ::std::os::raw::c_char,
    #[doc = " HA service's endpoint."]
    pub mc_ha_addr: *const ::std::os::raw::c_char,
    #[doc = " Process fid for rmservice@client."]
    pub mc_process_fid: *const ::std::os::raw::c_char,
    pub mc_profile: *const ::std::os::raw::c_char,
    #[doc = " The minimum length of the 'tm' receive queue,"]
    #[doc = " use M0_NET_TM_RECV_QUEUE_DEF_LEN if unsure."]
    pub mc_tm_recv_queue_min_len: u32,
    #[doc = " The maximum rpc message size, use M0_RPC_DEF_MAX_RPC_MSG_SIZE"]
    #[doc = " if unsure."]
    pub mc_max_rpc_msg_size: u32,
    pub mc_layout_id: u32,
    pub mc_idx_service_id: ::std::os::raw::c_int,
    pub mc_idx_service_conf: *mut ::std::os::raw::c_void,
    #[doc = " ADDB size"]
    pub mc_addb_size: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_config() {
    assert_eq!(
        ::std::mem::size_of::<m0_config>(),
        72usize,
        concat!("Size of: ", stringify!(m0_config))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_config>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_config))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_is_oostore as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_is_oostore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_is_read_verify as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_is_read_verify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_is_addb_init as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_is_addb_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_local_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_local_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_ha_addr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_ha_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_process_fid as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_process_fid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_profile as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_profile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_config>())).mc_tm_recv_queue_min_len as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_tm_recv_queue_min_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_max_rpc_msg_size as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_max_rpc_msg_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_layout_id as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_layout_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_idx_service_id as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_idx_service_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_idx_service_conf as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_idx_service_conf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_config>())).mc_addb_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_config),
            "::",
            stringify!(mc_addb_size)
        )
    );
}
extern "C" {
    #[doc = " The identifier of the root of realm hierarchy."]
    pub static M0_UBER_REALM: m0_uint128;
}
extern "C" {
    #[doc = " First identifier that applications are free to use."]
    #[doc = ""]
    #[doc = " It is guaranteed that M0_UBER_REALM falls into reserved extent."]
    #[doc = " @invariant m0_uint128_cmp(&M0_UBER_REALM, &M0_ID_APP) < 0"]
    pub static M0_ID_APP: m0_uint128;
}
#[doc = " Forward declaration: m0_rm_lock_req represents a request to"]
#[doc = " borrow/relinquish rights to use a resource form remote RM creditor"]
#[doc = " and lock/unlock the object."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rm_lock_req {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Initializes the RM object lock for this object and attaches a RM context"]
    #[doc = " with this object."]
    #[doc = ""]
    #[doc = " @pre     m0_obj_init()"]
    #[doc = " @param   obj an instance of object."]
    #[doc = " @param   group group_id for the object."]
    #[doc = " @retval  0 On success."]
    #[doc = " @retval -ENOMEM when there is no memory for ctx or fid."]
    pub fn m0_obj_lock_init(obj: *mut m0_obj) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalizes the object lock and decreased the rm_ctx::rmc_ref::ref_cnt."]
    #[doc = " If the rm_ctx::rmc_ref::ref_cnt becomes 0, then finalize the"]
    #[doc = " cached RM context."]
    #[doc = ""]
    #[doc = " @pre   m0_obj_init()"]
    #[doc = " @pre   m0_obj_lock_init()"]
    #[doc = " @param obj an instance of object."]
    pub fn m0_obj_lock_fini(obj: *mut m0_obj);
}
extern "C" {
    #[doc = " Acquires the write lock for the object asynchronously."]
    #[doc = " Recursive locking is not supported."]
    #[doc = ""]
    #[doc = " This is a wrapper over m0_obj_lock_get();"]
    #[doc = ""]
    #[doc = " @pre    m0_obj_init()"]
    #[doc = " @pre    m0_obj_lock_init()"]
    #[doc = " @param  obj a pointer to m0_obj."]
    #[doc = " @param  req representing a request to RM."]
    #[doc = " @param  clink a link which will listen on a channel for the signal of"]
    #[doc = "         completion."]
    #[doc = " @retval 0 On success."]
    pub fn m0_obj_write_lock_get(
        obj: *mut m0_obj,
        req: *mut m0_rm_lock_req,
        clink: *mut m0_clink,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Acquires the write lock for the object."]
    #[doc = " Recursive locking is not supported."]
    #[doc = " This is a blocking function."]
    #[doc = ""]
    #[doc = " This is a wrapper over m0_obj_lock_get_sync();"]
    #[doc = ""]
    #[doc = " @pre    m0_obj_init()"]
    #[doc = " @pre    m0_obj_lock_init()"]
    #[doc = " @param  obj A pointer to m0_obj."]
    #[doc = " @param  req Representing a request to RM."]
    #[doc = " @retval 0 On success."]
    pub fn m0_obj_write_lock_get_sync(
        obj: *mut m0_obj,
        req: *mut m0_rm_lock_req,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Acquires the read lock for the object asynchronously."]
    #[doc = " Recursive locking is not supported."]
    #[doc = " Locks don't conflict among requests for read lock."]
    #[doc = ""]
    #[doc = " This is a wrapper over m0_obj_lock_get();"]
    #[doc = ""]
    #[doc = " @pre    m0_obj_init()"]
    #[doc = " @pre    m0_obj_lock_init()"]
    #[doc = " @param  obj   A pointer to m0_obj."]
    #[doc = " @param  req   Representing a request to RM."]
    #[doc = " @param  clink A link which will listen on m0_rm_lock_req::rlr_chan"]
    #[doc = "               channel for the signal of completion."]
    #[doc = " @retval 0 On success."]
    pub fn m0_obj_read_lock_get(
        obj: *mut m0_obj,
        req: *mut m0_rm_lock_req,
        clink: *mut m0_clink,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Acquires the read lock for the object."]
    #[doc = " Recursive locking is not supported."]
    #[doc = " This is a blocking function."]
    #[doc = " Locks don't conflict among requests for read lock."]
    #[doc = ""]
    #[doc = " This is a wrapper over m0_obj_read_lock_get_sync();"]
    #[doc = ""]
    #[doc = " @pre    m0_obj_init()"]
    #[doc = " @pre    m0_obj_lock_init()"]
    #[doc = " @param  obj A pointer to m0_obj."]
    #[doc = " @param  req Representing a request to RM."]
    #[doc = " @retval 0 On success."]
    pub fn m0_obj_read_lock_get_sync(
        obj: *mut m0_obj,
        req: *mut m0_rm_lock_req,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Releases the RM lock for the object."]
    #[doc = ""]
    #[doc = " @param req Representing a request to RM."]
    pub fn m0_obj_lock_put(req: *mut m0_rm_lock_req);
}
extern "C" {
    #[doc = " Sets application-manipulable operation parameters."]
    #[doc = ""]
    #[doc = " @param op Operation to be setup with callback functions."]
    #[doc = " @param cbs Callback functions."]
    #[doc = " @param linger The absolute time by which delays should be limited."]
    #[doc = " If linger < m0_time_now(), the op is executed as soon as possible."]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    #[doc = " @pre op->op_sm.sm_state == M0_OS_INITIALISED"]
    pub fn m0_op_setup(op: *mut m0_op, cbs: *const m0_op_ops, linger: m0_time_t);
}
extern "C" {
    #[doc = " Launches a collection of operations. Operations must belong to the same"]
    #[doc = " m0_ instances."]
    #[doc = ""]
    #[doc = " @note the launched operations may be in other states than"]
    #[doc = " M0_OS_LAUNCHED by the time this call returns."]
    #[doc = ""]
    #[doc = " @param op Array of operations to be launched."]
    #[doc = " @param nr Number of operations."]
    #[doc = ""]
    #[doc = " @pre ergo(op != NULL)"]
    #[doc = " @pre m0_forall(i, nr, op[i] != NULL)"]
    #[doc = " @pre m0_forall(i, nr, op[i]->op_sm.sm_state == M0_OS_INITIALISED)"]
    #[doc = " @pre m0_forall(i, nr, m0_entity_type_is_valid(op[i]->op_entity))"]
    #[doc = " @post m0_forall(i, nr, op[i]->op_sm.sm_state >= M0_OS_LAUNCHED)"]
    pub fn m0_op_launch(op: *mut *mut m0_op, nr: u32);
}
extern "C" {
    #[doc = " Waits until the operation reaches a desired state."]
    #[doc = ""]
    #[doc = " @param bits Bitmask of states based on m0_op_state. M0_BITS() macro"]
    #[doc = " should be used to build a bitmask. *"]
    #[doc = " @param op Single operation to wait on."]
    #[doc = " @param to Absolute timeout for the wait."]
    #[doc = ""]
    #[doc = " @code"]
    #[doc = " // Wait until the operation completes, 10 seconds max."]
    #[doc = " result = m0_op_wait(op, M0_BITS(M0_OS_STABLE,"]
    #[doc = "                                 M0_OS_FAILED),"]
    #[doc = "                     m0_time_from_now(10, 0));"]
    #[doc = " if (result == -ETIMEDOUT)"]
    #[doc = "          // Timed out."]
    #[doc = " else if (result == 0) {"]
    #[doc = "         // Wait completed in time."]
    #[doc = "         if (op->op_sm.sm_state == M0_OS_STABLE) {"]
    #[doc = "                 ..."]
    #[doc = "         } else {"]
    #[doc = "                 M0_ASSERT(op->op_sm.sm_state == M0_OS_FAILED);"]
    #[doc = "                 ..."]
    #[doc = "         }"]
    #[doc = " } else {"]
    #[doc = "         // Some other error."]
    #[doc = " }"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    #[doc = " @pre bits != 0"]
    #[doc = " @pre (bits & ~M0_BITS(M0_OS_LAUNCHED, M0_OS_EXECUTED,"]
    #[doc = "                      M0_OS_STABLE, M0_OS_FAILED)) == 0"]
    pub fn m0_op_wait(op: *mut m0_op, bits: u64, to: m0_time_t) -> i32;
}
extern "C" {
    #[doc = " Cancels client operations. Caller is expected to wait"]
    #[doc = " for operation to move to one of the terminal states. The process of"]
    #[doc = " cancellation does not guarantee restoring an object to any consistent"]
    #[doc = " state and is left to application. Eg. cancellation of \"create\" operation"]
    #[doc = " does not invoke \"unlink\" operation internally, and application shall"]
    #[doc = " restore the consistency by either \"unlinking\" the object or trying"]
    #[doc = " to recreate the same."]
    #[doc = " @TODO: Revisit the logic once DTM0 lands into dev."]
    #[doc = ""]
    #[doc = " @param op collection of operations to cancel."]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    #[doc = " @pre cancellation callback is defined for every operation."]
    pub fn m0_op_cancel(op: *mut *mut m0_op, nr: u32);
}
extern "C" {
    #[doc = " Asks the implementation to speed up progress of this operation toward"]
    #[doc = " stability."]
    #[doc = ""]
    #[doc = " The implementation is free to either honour this call by modifying various"]
    #[doc = " internal caching and queuing policies to process the operation with less"]
    #[doc = " delays, or to ignore this call altogether. This call may incur resource"]
    #[doc = " under-utilisation and other overheads."]
    #[doc = ""]
    #[doc = " @param op Operation to be kicked."]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    #[doc = " @pre op->op_sm.sm_state >= M0_OS_INITIALISED"]
    pub fn m0_op_kick(op: *mut m0_op);
}
extern "C" {
    #[doc = " An API to return the return code from an op."]
    #[doc = ""]
    #[doc = " This is basically a function that abstracts the return code member access"]
    #[doc = " for applications using client."]
    #[doc = ""]
    #[doc = " @param op Operation whose return code is to be accessed."]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    pub fn m0_rc(op: *const m0_op) -> i32;
}
extern "C" {
    #[doc = " Finalises a complete operation. The state machine will be moved to"]
    #[doc = " M0_OS_UNINITIALISED."]
    #[doc = ""]
    #[doc = " @param op Operation being finalised."]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    #[doc = " @pre M0_IN(op->op_sm.sm_state, (M0_OS_INITIALISED,"]
    #[doc = "                                 M0_OS_STABLE, M0_OS_FAILED))"]
    pub fn m0_op_fini(op: *mut m0_op);
}
extern "C" {
    #[doc = " Frees a complete operation, allocated by the implementation."]
    #[doc = ""]
    #[doc = " @param op Operation being freed."]
    #[doc = ""]
    #[doc = " @pre op != NULL"]
    #[doc = " pre op->op_sm.sm_state == M0_OS_UNINITIALISED"]
    pub fn m0_op_free(op: *mut m0_op);
}
extern "C" {
    pub fn m0_container_init(
        con: *mut m0_container,
        parent: *mut m0_realm,
        id: *const m0_uint128,
        instance: *mut m0_client,
    );
}
extern "C" {
    pub fn m0_epoch_init(epoch: *mut m0_epoch, parent: *mut m0_realm, id: *const m0_uint128);
}
extern "C" {
    pub fn m0__dtx_init(dtx: *mut m0__dtx, parent: *mut m0_realm, id: *const m0_uint128);
}
extern "C" {
    #[doc = " Initialises a client object so that it can be created or deleted, or have"]
    #[doc = " read, write, alloc and free operations executed on it."]
    #[doc = ""]
    #[doc = " The size of data and parity buffer (m0_obj::ob_attr::oa_bshift) is"]
    #[doc = " set to default value 'M0_DEFAULT_BUF_SHIFT'."]
    #[doc = ""]
    #[doc = " If layout_id == 0, then this object will be set with optimal layout id"]
    #[doc = " according to the object size set in m0_obj::ob_attr::oa_buf_size."]
    #[doc = " If Object size is not set, then this object will be set with"]
    #[doc = " default layout id (See struct m0_obj_attr)."]
    #[doc = ""]
    #[doc = " @param obj The object to initialise."]
    #[doc = " @param parent The realm operations on this object will be part of."]
    #[doc = " @param id The identifier assigned by the application to this object."]
    #[doc = " @param layout_id The layout id assigned by the application to this object."]
    #[doc = ""]
    #[doc = " @pre obj != NULL"]
    #[doc = " @pre parent != NULL"]
    #[doc = " @pre id != NULL && m0_uint128_cmp(&M0_ID_APP, id) < 0"]
    pub fn m0_obj_init(
        obj: *mut m0_obj,
        parent: *mut m0_realm,
        id: *const m0_uint128,
        layout_id: u64,
    );
}
extern "C" {
    #[doc = " Finalises an obj, leading to finilise entity and to free any additiona"]
    #[doc = "  memory allocated to represent it."]
    #[doc = ""]
    #[doc = " @param obj Pointer to the object to finalise."]
    #[doc = ""]
    #[doc = " @pre obj != NULL"]
    pub fn m0_obj_fini(obj: *mut m0_obj);
}
extern "C" {
    #[doc = " Initialises the index corresponding to a given object."]
    #[doc = ""]
    #[doc = " Keys in this index are 64-bit block offsets (in BE representation, with"]
    #[doc = " lexicographic ordering) and the values are battrs (and maybe data?) for the"]
    #[doc = " block."]
    #[doc = ""]
    #[doc = " The index structure, initialised by this function, provides access to object"]
    #[doc = " data through client index interface."]
    #[doc = ""]
    #[doc = " @post m0_uint128_eq(&idx->in_entity.en_id, &obj->ob_entity.en_id)"]
    pub fn m0_obj_idx_init(idx: *mut m0_idx, obj: *const m0_obj);
}
extern "C" {
    #[doc = " Initialises object operation."]
    #[doc = ""]
    #[doc = " @param obj Object the operation is targeted to."]
    #[doc = " @param opcode Operation code for the operation."]
    #[doc = " @param ext  Extents in the object, measured in blocks."]
    #[doc = " @param data Application buffers for the operation."]
    #[doc = " @param attr Application buffers for block attributes."]
    #[doc = " @param mask Attribute mask."]
    #[doc = " @param[in, out] op Pointer to the operation pointer. If the operation pointer"]
    #[doc = "                 is NULL, client will allocate one. Otherwise, client will"]
    #[doc = "                 check the operation and make sure it is reusable for this"]
    #[doc = "                 operation."]
    #[doc = ""]
    #[doc = " @return 0 for successful initialisation of operation. Otherwise"]
    #[doc = "         standard linux system error code."]
    #[doc = ""]
    #[doc = " @remarks \"data\" defines buffers from which data are read on WRITE and"]
    #[doc = " written to on READ."]
    #[doc = ""]
    #[doc = " @remarks \"attr\" and \"mask\" together define which block attributes are read"]
    #[doc = " or written."]
    #[doc = ""]
    #[doc = " @remarks The application can provide a pre-allocated operation. Otherwise,"]
    #[doc = " a new operation is allocated by this entry point, which eventually must be"]
    #[doc = " explicitely freed by the app."]
    #[doc = ""]
    #[doc = " @pre obj != NULL"]
    #[doc = " @pre M0_IN(opcode, (M0_OC_READ, M0_OC_WRITE,"]
    #[doc = "                     M0_OC_ALLOC, M0_OC_FREE))"]
    #[doc = " @pre ext != NULL"]
    #[doc = " @pre obj->ob_attr.oa_bshift >= M0_MIN_BUF_SHIFT"]
    #[doc = " @pre m0_vec_count(&ext->iv_vec) % (1ULL << obj->ob_attr.oa_bshift) == 0"]
    #[doc = " @pre op != NULL"]
    #[doc = " @pre ergo(M0_IN(opcode, (M0_OC_READ, M0_OC_WRITE)),"]
    #[doc = "           data != NULL && attr != NULL &&"]
    #[doc = "           m0_vec_count(&ext->iv_vec) == m0_vec_count(&data->ov_vec) &&"]
    #[doc = "           m0_vec_count(&attr->ov_vec) == 8 * m0_no_of_bits_set(mask) *"]
    #[doc = "                       (m0_vec_count(&ext->iv_vec) >> obj->ob_attr.oa_bshift)"]
    #[doc = " @pre ergo(M0_IN(opcode, (M0_OC_ALLOC, M0_OC_FREE)),"]
    #[doc = "           data == NULL && attr == NULL && mask == 0)"]
    #[doc = " @pre ergo(opcode == M0_OC_READ, M0_IN(flags, (0, M0_OOF_NOHOLE)))"]
    #[doc = " @pre ergo(opcode != M0_OC_READ, M0_IN(flags, (0, M0_OOF_SYNC)))"]
    #[doc = ""]
    #[doc = " @post ergo(*op != NULL, *op->op_code == opcode &&"]
    #[doc = "            *op->op_sm.sm_state == M0_OS_INITIALISED)"]
    pub fn m0_obj_op(
        obj: *mut m0_obj,
        opcode: m0_obj_opcode,
        ext: *mut m0_indexvec,
        data: *mut m0_bufvec,
        attr: *mut m0_bufvec,
        mask: u64,
        flags: u32,
        op: *mut *mut m0_op,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initialises client index in a given realm."]
    #[doc = ""]
    #[doc = " Notes for M0_IDX_DIX index service type:"]
    #[doc = " 'id' should be a valid motr fid of type 'x' (see m0_dix_fid_type). Zero fid"]
    #[doc = " container is reserved for distributed meta-indices and shouldn't be used for"]
    #[doc = " user indices, i.e. indices with M0_FID_TINIT('x', 0, *) fids are reserved."]
    #[doc = ""]
    #[doc = " @code"]
    #[doc = " struct m0_fid fid = M0_FID_TINIT('x', 1, 1);"]
    #[doc = ""]
    #[doc = " m0_idx_init(&idx, &realm, (struct m0_uint128 *)&fid);"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " Non-distributed indices (having fid type 'i') are going to be supported in"]
    #[doc = " future."]
    pub fn m0_idx_init(idx: *mut m0_idx, parent: *mut m0_realm, id: *const m0_uint128);
}
extern "C" {
    pub fn m0_idx_fini(idx: *mut m0_idx);
}
extern "C" {
    #[doc = " Initialises an index operation."]
    #[doc = ""]
    #[doc = " For M0_IC_NEXT operation arguments should be as follows:"]
    #[doc = " - 'keys' buffer vector first element should contain a starting key and other"]
    #[doc = "   elements should be set to NULL. Buffer vector size indicates number of"]
    #[doc = "   records to return."]
    #[doc = "   Starting key can be NULL. In this case starting key is treated as the"]
    #[doc = "   smallest possible key of the index. If starting key doesn't exist in the"]
    #[doc = "   index, then retrieved records will start with the smallest key following"]
    #[doc = "   the starting key. Otherwise, a record corresponding to the starting key"]
    #[doc = "   will be included in a result."]
    #[doc = " - 'vals' vector should be at least of the same size as 'keys' and should"]
    #[doc = "   contain NULLs. After successful operation completion retrieved index"]
    #[doc = "   records are stored in 'keys' and 'vals' buffer vectors. If some error"]
    #[doc = "   occurred during i-th index record retrieval then rcs[i] != 0. -ENOENT error"]
    #[doc = "   means that there are no more records to return."]
    #[doc = ""]
    #[doc = " For M0_IC_GET operation arguments should be as follows:"]
    #[doc = " - 'keys' buffer vector should contain keys for records being requested."]
    #[doc = "   At least one key should be specified and no NULL keys are allowed."]
    #[doc = " - 'vals' vector should be at least of the same size as 'keys' and should"]
    #[doc = "   contain NULLs. After successful operation completion retrieved record"]
    #[doc = "   values are stored in 'vals' buffer vector. If some value retrieval has"]
    #[doc = "   failed, then corresponding element in 'rcs' array != 0."]
    #[doc = ""]
    #[doc = " 'rcs' holds array of per-item return codes for the operation. It should be"]
    #[doc = " allocated by user with a size of at least 'keys->ov_vec.v_nr' elements. For"]
    #[doc = " example, 6 records with keys k0...k5 were requested through GET request with"]
    #[doc = " k3 being absent in the index. After operation completion rcs[3] will be"]
    #[doc = " -ENOENT and rcs[0,1,2,4,5] will be 0."]
    #[doc = ""]
    #[doc = " Per-item return codes are more fine-grained than global operation return"]
    #[doc = " code (op->op_sm.sm_rc). On operation completion the global return code"]
    #[doc = " is set to negative value if it's impossible to process any item (invalid"]
    #[doc = " index fid, lost RPC connection, etc.)."]
    #[doc = " - If the operation global return code is 0, then user should check per-item"]
    #[doc = "   return codes."]
    #[doc = " - If the operation global return code is not 0, then per-item return codes"]
    #[doc = "   are undefined."]
    #[doc = ""]
    #[doc = " 'rcs' argument is mandatory for all operations except M0_IC_LOOKUP."]
    #[doc = ""]
    #[doc = " For M0_CLOVIC_IC_PUT flags argument may be set."]
    #[doc = " - 'flags' is a bit-mask of m0_op_idx_flags enum. M0_OIF_OVERWRITE and"]
    #[doc = "   M0_OIF_SYNC_WAIT are supported for now."]
    #[doc = "   If M0_OIF_OVERWRITE flag is set then records with existing keys are"]
    #[doc = "   overwritten, otherwise operation returns -EEXIST for existing keys."]
    #[doc = "   If M0_OIF_SYNC_WAIT flag is set then it ensures that reply would be sent"]
    #[doc = "   only when transaction is persisted. This flag can only be used"]
    #[doc = "   with M0_IC_PUT or M0_IC_DEL."]
    #[doc = ""]
    #[doc = " @pre idx != NULL"]
    #[doc = " @pre M0_IN(opcode, (M0_IC_LOOKUP, M0_IC_LIST,"]
    #[doc = "                     M0_IC_GET, M0_IC_PUT,"]
    #[doc = "                     M0_IC_DEL, M0_IC_NEXT))"]
    #[doc = " @pre ergo(*op != NULL, *op->op_size >= sizeof **op)"]
    #[doc = " @pre ergo(opcode == M0_IC_LOOKUP, rcs != NULL)"]
    #[doc = " @pre ergo(opcode != M0_IC_LOOKUP, keys != NULL)"]
    #[doc = " @pre M0_IN(opcode, (M0_IC_DEL,"]
    #[doc = "                     M0_IC_LOOKUP,"]
    #[doc = "                     M0_IC_LIST)) == (vals == NULL)"]
    #[doc = " @pre ergo(opcode == M0_IC_LIST,"]
    #[doc = "           m0_forall(i, keys->ov_vec.v_nr,"]
    #[doc = "                     keys->ov_vec.v_count[i] == sizeof(struct m0_uint128)))"]
    #[doc = " @pre ergo(opcode == M0_IC_GET, keys->ov_vec.v_nr != 0)"]
    #[doc = " @pre ergo(opcode == M0_IC_GET,"]
    #[doc = "           m0_forall(i, keys->ov_vec.v_nr, keys->ov_buf[i] != NULL))"]
    #[doc = " @pre ergo(flags == M0_OIF_SYNC_WAIT,"]
    #[doc = "           M0_IN(opcode, (M0_IC_PUT, M0_IC_DEL)))"]
    #[doc = " @pre ergo(vals != NULL, keys->ov_vec.v_nr == vals->ov_vec.v_nr)"]
    #[doc = " @post ergo(result == 0, *op != NULL && *op->op_code == opcode &&"]
    #[doc = "                         *op->op_sm.sm_state == M0_OS_INITIALISED)"]
    #[doc = " @todo For now 'rcs' may be NULL if index backend is not Motr KVS"]
    #[doc = " and operation code is not M0_IC_GET."]
    #[doc = " All backends should be updated to fill 'rcs' for all operation codes."]
    pub fn m0_idx_op(
        idx: *mut m0_idx,
        opcode: m0_idx_opcode,
        keys: *mut m0_bufvec,
        vals: *mut m0_bufvec,
        rcs: *mut i32,
        flags: u32,
        op: *mut *mut m0_op,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_realm_create(realm: *mut m0_realm, wcount: u64, rcount: u64, op: *mut *mut m0_op);
}
extern "C" {
    pub fn m0_realm_open(realm: *mut m0_realm, wcount: u64, rcount: u64, op: *mut *mut m0_op);
}
extern "C" {
    pub fn m0_realm_close(realm: *mut m0_realm, wcount: u64, rcount: u64, op: *mut *mut m0_op);
}
extern "C" {
    #[doc = " Sets an operation to create or delete an entity."]
    #[doc = ""]
    #[doc = " @param pool Specify the pool to store the entity if it is not NULL,"]
    #[doc = " otherwise a pool selected by internal policy is used."]
    #[doc = " @param entity In-memory representation of the entity that is to be created."]
    #[doc = " @param[out] op Pointer to the operation. The operation can be pre-allocated"]
    #[doc = " by the application. Otherwise, this entry point will allocate it if succeed."]
    #[doc = " @return 0 for success, (*op)->op_sm.sm_rc otherwise."]
    #[doc = ""]
    #[doc = " @pre entity != NULL"]
    #[doc = " @pre op != NULL"]
    pub fn m0_entity_create(
        pool: *mut m0_fid,
        entity: *mut m0_entity,
        op: *mut *mut m0_op,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_entity_delete(entity: *mut m0_entity, op: *mut *mut m0_op) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets an operation to open an entity."]
    #[doc = ""]
    #[doc = " @param entity The entity that needs to be opened."]
    #[doc = " @param[out] op Pointer to the operation which can be pre-allocated by the"]
    #[doc = " application. Else, this entry point will allocate it if succeed."]
    #[doc = " @return 0 for success, (*op)->op_sm.sm_rc otherwise"]
    #[doc = ""]
    #[doc = " @pre entity != NULL"]
    #[doc = " @pre op != NULL"]
    pub fn m0_entity_open(entity: *mut m0_entity, op: *mut *mut m0_op) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalises an entity, freeing any additional memory allocated to represent it."]
    #[doc = ""]
    #[doc = " @param entity Pointer to the entity to finalise."]
    #[doc = ""]
    #[doc = " @pre entity != NULL"]
    #[doc = " @pre entity->en_sm.sm_state == M0_ES_INIT"]
    pub fn m0_entity_fini(entity: *mut m0_entity);
}
extern "C" {
    #[doc = " Returns the maximum size a client operation is expected to be."]
    #[doc = " If pre-allocating 'struct m0_op's, allocations smaller than this"]
    #[doc = " size may be rejected with EMSGSIZE"]
    pub fn m0_op_maxsize() -> size_t;
}

#[link(name = "motr", kind = "dylib")]
extern "C" {
    #[doc = " Initialises state machine types et al."]
    #[doc = ""]
    #[doc = " @param m0c Where to store the allocated instance."]
    #[doc = " @param conf client configuration parameters."]
    #[doc = " @param init_m0 Indicate whether or not Motr needs to be initialised."]
    #[doc = " @return 0 for success, anything else for an error."]
    #[doc = ""]
    #[doc = " @pre m0c must point to a NULL struct m0_client *."]
    #[doc = " @pre local_ep must not be NULL or the empty string."]
    pub fn m0_client_init(
        m0c: *mut *mut m0_client,
        conf: *mut m0_config,
        init_m0: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalises client, finalise state machine group et al."]
    #[doc = ""]
    #[doc = " @pre (m0c != NULL)."]
    pub fn m0_client_fini(m0c: *mut m0_client, fini_m0: bool);
}
extern "C" {
    #[doc = " Returns the process fid of the motr instance."]
    #[doc = ""]
    #[doc = " @param m0c The client instance being queried."]
    #[doc = " @param proc_fid The returned process fid."]
    #[doc = " @return 0 for success and valid process fid is stored in proc_fid,"]
    #[doc = " anything else for an error."]
    pub fn m0_process_fid(m0c: *const m0_client, proc_fid: *mut m0_fid);
}
extern "C" {
    #[doc = " Allocates and initialises an SYNC operation."]
    #[doc = ""]
    #[doc = " @param sop A new SYNC op is created, entities and ops can be added"]
    #[doc = "            into this SYNC op once it's initialised."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_sync_op_init(sop: *mut *mut m0_op) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Adds an entity to SYNC op."]
    #[doc = ""]
    #[doc = " @param sop The SYNC op where an entity is added to."]
    #[doc = " @param entity The entity to be SYNC-ed."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_sync_entity_add(sop: *mut m0_op, ent: *mut m0_entity) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Adds an `op` to SYNC op."]
    #[doc = ""]
    #[doc = " @param sop The SYNC op where an entity is added to."]
    #[doc = " @param op The operation to be SYNC-ed."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_sync_op_add(sop: *mut m0_op, op: *mut m0_op) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Blocking version of entity sync API, corresponding to m0t1fs_fsync()"]
    #[doc = " in m0t1fs."]
    #[doc = ""]
    #[doc = " @param ent The object is going to be sync'ed."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_entity_sync(ent: *mut m0_entity) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Motr sync instance entry point, corresponding to m0t1fs_sync_fs()"]
    #[doc = " in m0t1fs."]
    #[doc = ""]
    #[doc = " @param m0c The Motr instance is going to be sync'ed."]
    #[doc = " @param wait Ask client to wait till pending tx's are done if set to"]
    #[doc = "             be \"ture\"."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_sync(m0c: *mut m0_client, wait: bool) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Maps a unit size to a layout id defined in Motr."]
    #[doc = ""]
    #[doc = " @param unit_size Parity group unit size set. Only those unit sizes defined"]
    #[doc = "                  in layout/layout_pver.c are valid."]
    #[doc = " @return 0 for invalid unit sizes and layout id for valid unit sizes."]
    #[doc = ""]
    pub fn m0_obj_unit_size_to_layout_id(unit_size: ::std::os::raw::c_int) -> u64;
}
extern "C" {
    #[doc = " Maps a layout id to unit size."]
    #[doc = ""]
    #[doc = " @param layout_id The layout id to query. The layout_id must be one of the valid"]
    #[doc = "                  layout ids defined in Motr."]
    #[doc = " @return The corresponding unit size of queried layout id."]
    #[doc = ""]
    pub fn m0_obj_layout_id_to_unit_size(layout_id: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_client_layout_id(instance: *const m0_client) -> u64;
}
extern "C" {
    #[doc = " Gets the layout type of an object."]
    #[doc = ""]
    #[doc = " @param obj The object to query."]
    #[doc = " @return The layout type of object in question."]
    pub fn m0_obj_layout_type(obj: *mut m0_obj) -> m0_client_layout_type;
}
extern "C" {
    #[doc = " Add layer to the composite layout."]
    #[doc = ""]
    #[doc = " @param layout   The layout to add to."]
    #[doc = " @param sub_obj  The sub object corresponds to the new layer. The API requires"]
    #[doc = "                 object argument instead of its identifier as Motr"]
    #[doc = "                 internally requires some object attributes to construct"]
    #[doc = "                 the composite layout."]
    #[doc = " @param priority The layer's priority which is used to select which layer an"]
    #[doc = "                 IO request goes to."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_composite_layer_add(
        layout: *mut m0_client_layout,
        sub_obj: *mut m0_obj,
        priority: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Delete layer from the composite layout."]
    #[doc = ""]
    #[doc = " @param layout    The layout to delete from."]
    #[doc = " @param subobj_id The id of the sub-object (layer) to delete."]
    pub fn m0_composite_layer_del(layout: *mut m0_client_layout, subobj_id: m0_uint128);
}
extern "C" {
    #[doc = " Returns an in-memory index representation for extents in a composite layer."]
    #[doc = ""]
    #[doc = " @param layer_id The composite layer in question."]
    #[doc = " @param write    True for extents for WRITE, false for extents for READ."]
    #[doc = " @param idx      The returned index."]
    #[doc = " @return 0 for success, anything else for an error."]
    pub fn m0_composite_layer_idx(
        layer_id: m0_uint128,
        write: bool,
        idx: *mut m0_idx,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Helper APIs to copy and transform a layer key/value to/from buffer."]
    #[doc = " m0_composite_layer_idx_key_to_buf() transforms original key"]
    #[doc = " to a representation in lexicographical order."]
    pub fn m0_composite_layer_idx_key_to_buf(
        key: *mut m0_composite_layer_idx_key,
        out_kbuf: *mut *mut ::std::os::raw::c_void,
        out_klen: *mut m0_bcount_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_composite_layer_idx_key_from_buf(
        key: *mut m0_composite_layer_idx_key,
        kbuf: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn m0_composite_layer_idx_val_to_buf(
        val: *mut m0_composite_layer_idx_val,
        out_vbuf: *mut *mut ::std::os::raw::c_void,
        out_vlen: *mut m0_bcount_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_composite_layer_idx_val_from_buf(
        val: *mut m0_composite_layer_idx_val,
        vbuf: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Initialises layout operation."]
    #[doc = ""]
    #[doc = " @param obj    The object which the layout is belong to."]
    #[doc = " @param layout Layout the operation is targeted to."]
    #[doc = " @param opcode Operation code for the operation."]
    #[doc = " @param[out] op Pointer to the operation pointer. If the operation pointer is"]
    #[doc = "\t       NULL, motr will allocate one. Otherwise, motr will check"]
    #[doc = "\t       the operation and make sure it is reusable for this operation."]
    pub fn m0_client_layout_op(
        obj: *mut m0_obj,
        opcode: m0_entity_opcode,
        layout: *mut m0_client_layout,
        op: *mut *mut m0_op,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Note: current version only support capturing pdclust layout for an object."]
    #[doc = ""]
    #[doc = " To capture the layout for an object, an application has to issue LAYOUT_GET"]
    #[doc = " op first to retrieve the object's layout."]
    pub fn m0_client_layout_capture(
        layout: *mut m0_client_layout,
        obj: *mut m0_obj,
        out: *mut *mut m0_client_layout,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_client_layout_alloc(type_: m0_client_layout_type) -> *mut m0_client_layout;
}
extern "C" {
    pub fn m0_client_layout_free(layout: *mut m0_client_layout);
}
extern "C" {
    pub static mut m0_fid_arr_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_fid_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_fid_arr_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_fid_struct_init();
}
extern "C" {
    pub fn m0_xc_fid_fid_init();
}
extern "C" {
    pub fn m0_xc_fid_fid_fini();
}
extern "C" {
    pub static mut m0_ext_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_ext_struct_init();
}
extern "C" {
    pub fn m0_xc_lib_ext_init();
}
extern "C" {
    pub fn m0_xc_lib_ext_fini();
}
#[doc = " Infinite value as the end of the mask's range."]
pub const IMASK_INF: ::std::os::raw::c_ulong = 18446744073709551615;
#[doc = " @addtogroup dix"]
#[doc = ""]
#[doc = " @{"]
#[doc = ""]
#[doc = " Identity mask is a sequence of ranges of bit positions in bit-string:"]
#[doc = " [S0, E0], [S1, E1], ..., [Sm, Em], where Si and Ei are bit-offsets counted"]
#[doc = " from 0. The ranges can be overlapping and are not necessarily monotone"]
#[doc = " offset-wise. Range of identity mask can be infinite [X, inf] meaning"]
#[doc = " that range includes bit positions from X to the end of a bit-string. Empty"]
#[doc = " identity mask is a mask with 0 ranges defined."]
#[doc = ""]
#[doc = " The mask can be applied to a bit-string. Applying identity mask to a"]
#[doc = " bit-string X produces a new bit-string Y:"]
#[doc = " Y = X[S0, E0] :: X[S1, E1] :: ... :: X[Sm, Em],"]
#[doc = " where :: is is bit-string concatenation."]
#[doc = ""]
#[doc = " For example, given identity mask I = [0, 3], [7, 8] and X = 0xf0, result of"]
#[doc = " mask application is:"]
#[doc = " Y = 0xf0[0, 3] :: 0xf0[7, 8] = 0b0000 :: 0b11 = 0b000011 = 0x03"]
#[doc = ""]
#[doc = " It's totally fine to apply mask with ranges extending the bit-string's"]
#[doc = " length. For example, application of identity mask with a single range"]
#[doc = " [50,100] to a bit-string 0b11 is valid and produces empty bit-string."]
pub type _bindgen_ty_36 = ::std::os::raw::c_ulong;
#[doc = " Identity mask."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_imask {
    #[doc = " Number of ranges."]
    pub im_nr: u64,
    #[doc = " Array of ranges."]
    pub im_range: *mut m0_ext,
}
#[test]
fn bindgen_test_layout_m0_dix_imask() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_imask>(),
        16usize,
        concat!("Size of: ", stringify!(m0_dix_imask))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_imask>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_imask))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_imask>())).im_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_imask),
            "::",
            stringify!(im_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_imask>())).im_range as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_imask),
            "::",
            stringify!(im_range)
        )
    );
}
extern "C" {
    #[doc = " Initialises identity mask. Array of ranges for the mask is allocated"]
    #[doc = " internally, so user can free 'range' array after initialisation."]
    pub fn m0_dix_imask_init(
        mask: *mut m0_dix_imask,
        range: *mut m0_ext,
        nr: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalises identity mask."]
    pub fn m0_dix_imask_fini(mask: *mut m0_dix_imask);
}
extern "C" {
    #[doc = " Applies identity mask to a user-provided bit-string."]
    #[doc = " Value res should be deallocated by user with m0_free()."]
    pub fn m0_dix_imask_apply(
        buffer: *mut ::std::os::raw::c_void,
        buf_len_bytes: m0_bcount_t,
        mask: *mut m0_dix_imask,
        res: *mut *mut ::std::os::raw::c_void,
        res_len_bits: *mut m0_bcount_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Checks whether identity mask is empty (has 0 ranges defined)."]
    pub fn m0_dix_imask_is_empty(mask: *const m0_dix_imask) -> bool;
}
extern "C" {
    #[doc = " Makes a deep copy of identity mask."]
    pub fn m0_dix_imask_copy(
        dst: *mut m0_dix_imask,
        src: *const m0_dix_imask,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Checks whether imasks are equal"]
    pub fn m0_dix_imask_eq(imask1: *const m0_dix_imask, imask2: *const m0_dix_imask) -> bool;
}
extern "C" {
    pub static mut m0_dix_imask_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_dix_imask_struct_init();
}
extern "C" {
    pub fn m0_xc_dix_imask_init();
}
extern "C" {
    pub fn m0_xc_dix_imask_fini();
}
extern "C" {
    pub static mut m0_uint128_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_uint128_struct_init();
}
extern "C" {
    pub fn m0_xc_lib_types_init();
}
extern "C" {
    pub fn m0_xc_lib_types_fini();
}
#[doc = " @addtogroup dix"]
#[doc = ""]
#[doc = " @{"]
#[doc = ""]
#[doc = " Distributed index layout is based on parity de-clustering layout and"]
#[doc = " determines targets (pool disks) for index records."]
#[doc = ""]
#[doc = " Layouts of indices are stored centralised in 'layout' meta-index. Layout can"]
#[doc = " be stored there in two forms: layout id and layout descriptor. Layout"]
#[doc = " descriptor shall be known in order to instantiate layout instance"]
#[doc = " (m0_dix_linst) usable for target disks calculation. Therefore, if layout id"]
#[doc = " is stored in 'layout' meta-index then it shall be resolved to full-fledged"]
#[doc = " layout descriptor. The mapping between layout id and corresponding layout"]
#[doc = " descriptor is stored in 'layout-descr' meta-index."]
#[doc = ""]
#[doc = " For more information about targets calculation for index records please refer"]
#[doc = " to distributed indexing HLD."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_pdclust_layout {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_pdclust_instance {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_pool_version {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_layout_domain {
    _unused: [u8; 0],
}
pub const dix_layout_type_DIX_LTYPE_UNKNOWN: dix_layout_type = 0;
pub const dix_layout_type_DIX_LTYPE_ID: dix_layout_type = 1;
pub const dix_layout_type_DIX_LTYPE_DESCR: dix_layout_type = 2;
pub const dix_layout_type_DIX_LTYPE_COMPOSITE_DESCR: dix_layout_type = 3;
pub const dix_layout_type_DIX_LTYPE_CAPTURE_DESCR: dix_layout_type = 4;
pub type dix_layout_type = ::std::os::raw::c_uint;
pub const m0_dix_hash_fnc_type_HASH_FNC_NONE: m0_dix_hash_fnc_type = 0;
pub const m0_dix_hash_fnc_type_HASH_FNC_FNV1: m0_dix_hash_fnc_type = 1;
pub const m0_dix_hash_fnc_type_HASH_FNC_CITY: m0_dix_hash_fnc_type = 2;
pub type m0_dix_hash_fnc_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_ldesc {
    pub ld_hash_fnc: u32,
    pub ld_pver: m0_fid,
    pub ld_imask: m0_dix_imask,
}
#[test]
fn bindgen_test_layout_m0_dix_ldesc() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_ldesc>(),
        40usize,
        concat!("Size of: ", stringify!(m0_dix_ldesc))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_ldesc>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_ldesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_ldesc>())).ld_hash_fnc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_ldesc),
            "::",
            stringify!(ld_hash_fnc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_ldesc>())).ld_pver as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_ldesc),
            "::",
            stringify!(ld_pver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_ldesc>())).ld_imask as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_ldesc),
            "::",
            stringify!(ld_imask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_capture_ldesc {
    pub ca_orig_id: m0_uint128,
    pub ca_pver: m0_fid,
    pub ca_lid: u64,
}
#[test]
fn bindgen_test_layout_m0_dix_capture_ldesc() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_capture_ldesc>(),
        40usize,
        concat!("Size of: ", stringify!(m0_dix_capture_ldesc))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_capture_ldesc>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_capture_ldesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_capture_ldesc>())).ca_orig_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_capture_ldesc),
            "::",
            stringify!(ca_orig_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_capture_ldesc>())).ca_pver as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_capture_ldesc),
            "::",
            stringify!(ca_pver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_capture_ldesc>())).ca_lid as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_capture_ldesc),
            "::",
            stringify!(ca_lid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_composite_layer {
    pub cr_subobj: m0_uint128,
    pub cr_lid: u64,
    pub cr_priority: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_m0_dix_composite_layer() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_composite_layer>(),
        32usize,
        concat!("Size of: ", stringify!(m0_dix_composite_layer))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_composite_layer>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_composite_layer))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_composite_layer>())).cr_subobj as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_composite_layer),
            "::",
            stringify!(cr_subobj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_composite_layer>())).cr_lid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_composite_layer),
            "::",
            stringify!(cr_lid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_composite_layer>())).cr_priority as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_composite_layer),
            "::",
            stringify!(cr_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_composite_ldesc {
    pub cld_nr_layers: ::std::os::raw::c_int,
    pub cld_layers: *mut m0_dix_composite_layer,
}
#[test]
fn bindgen_test_layout_m0_dix_composite_ldesc() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_composite_ldesc>(),
        16usize,
        concat!("Size of: ", stringify!(m0_dix_composite_ldesc))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_composite_ldesc>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_composite_ldesc))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_composite_ldesc>())).cld_nr_layers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_composite_ldesc),
            "::",
            stringify!(cld_nr_layers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_composite_ldesc>())).cld_layers as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_composite_ldesc),
            "::",
            stringify!(cld_layers)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_dix_layout {
    pub dl_type: u32,
    pub u: m0_dix_layout__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union m0_dix_layout__bindgen_ty_1 {
    pub dl_id: u64,
    pub dl_desc: m0_dix_ldesc,
    pub dl_cap_desc: m0_dix_capture_ldesc,
    pub dl_comp_desc: m0_dix_composite_ldesc,
}
#[test]
fn bindgen_test_layout_m0_dix_layout__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_layout__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(m0_dix_layout__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_layout__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_layout__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_layout__bindgen_ty_1>())).dl_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout__bindgen_ty_1),
            "::",
            stringify!(dl_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_layout__bindgen_ty_1>())).dl_desc as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout__bindgen_ty_1),
            "::",
            stringify!(dl_desc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_layout__bindgen_ty_1>())).dl_cap_desc as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout__bindgen_ty_1),
            "::",
            stringify!(dl_cap_desc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dix_layout__bindgen_ty_1>())).dl_comp_desc as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout__bindgen_ty_1),
            "::",
            stringify!(dl_comp_desc)
        )
    );
}
#[test]
fn bindgen_test_layout_m0_dix_layout() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_layout>(),
        48usize,
        concat!("Size of: ", stringify!(m0_dix_layout))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_layout>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_layout))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_layout>())).dl_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout),
            "::",
            stringify!(dl_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_layout>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout),
            "::",
            stringify!(u)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_linst {
    pub li_ldescr: *mut m0_dix_ldesc,
    pub li_pl: *mut m0_pdclust_layout,
    pub li_pi: *mut m0_pdclust_instance,
}
#[test]
fn bindgen_test_layout_m0_dix_linst() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_linst>(),
        24usize,
        concat!("Size of: ", stringify!(m0_dix_linst))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_linst>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_linst))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_linst>())).li_ldescr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_linst),
            "::",
            stringify!(li_ldescr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_linst>())).li_pl as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_linst),
            "::",
            stringify!(li_pl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_linst>())).li_pi as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_linst),
            "::",
            stringify!(li_pi)
        )
    );
}
#[doc = " Iterator over targets of index record parity group units."]
#[doc = ""]
#[doc = " The order of iteration is:"]
#[doc = " Tn, Tp1 ... Tpk, Ts1, ..., Tsk,"]
#[doc = " where Tn - target for data unit. There is always one data unit;"]
#[doc = "       Tp1 ... Tpk - targets for parity units;"]
#[doc = "       Ts1 ... Tsk - targets for spare units;"]
#[doc = "       'k' is determined by pool version 'K' attribute."]
#[doc = " Iterator constructs distributed index layout internally and uses it to"]
#[doc = " calculate successive target on every iteration."]
#[doc = ""]
#[doc = " Target in this case is a device index in a pool version."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dix_layout_iter {
    #[doc = " Layout instance."]
    pub dit_linst: m0_dix_linst,
    #[doc = " Width of a parity group."]
    pub dit_W: u32,
    #[doc = " Current position."]
    pub dit_unit: u64,
    #[doc = " Key of the record that should be distributed after application of the"]
    #[doc = " identity mask."]
    pub dit_key: m0_buf,
}
#[test]
fn bindgen_test_layout_m0_dix_layout_iter() {
    assert_eq!(
        ::std::mem::size_of::<m0_dix_layout_iter>(),
        56usize,
        concat!("Size of: ", stringify!(m0_dix_layout_iter))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dix_layout_iter>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dix_layout_iter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_layout_iter>())).dit_linst as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout_iter),
            "::",
            stringify!(dit_linst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_layout_iter>())).dit_W as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout_iter),
            "::",
            stringify!(dit_W)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_layout_iter>())).dit_unit as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout_iter),
            "::",
            stringify!(dit_unit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dix_layout_iter>())).dit_key as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dix_layout_iter),
            "::",
            stringify!(dit_key)
        )
    );
}
extern "C" {
    #[doc = " Calculates target for specified 'unit' in parity group of the record with"]
    #[doc = " specified 'key'. Calculated target is stored in 'out_id'."]
    pub fn m0_dix_target(inst: *mut m0_dix_linst, unit: u64, key: *mut m0_buf, out_id: *mut u64);
}
extern "C" {
    #[doc = " Returns total number of devices (targets) accounted by layout instance."]
    pub fn m0_dix_devices_nr(linst: *mut m0_dix_linst) -> u32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_pooldev {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Returns pool device structure by target (e.g. calculated by m0_dix_target())."]
    pub fn m0_dix_tgt2sdev(linst: *mut m0_dix_linst, tgt: u64) -> *mut m0_pooldev;
}
extern "C" {
    #[doc = " Builds DIX layout instance."]
    #[doc = ""]
    #[doc = " Internal function, user should use m0_dix_layout_iter_init() instead."]
    pub fn m0_dix_layout_init(
        dli: *mut m0_dix_linst,
        domain: *mut m0_layout_domain,
        fid: *const m0_fid,
        layout_id: u64,
        pver: *mut m0_pool_version,
        dld: *mut m0_dix_ldesc,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalises DIX layout instance."]
    pub fn m0_dix_layout_fini(dli: *mut m0_dix_linst);
}
extern "C" {
    #[doc = " Initialises layout descriptor."]
    pub fn m0_dix_ldesc_init(
        ld: *mut m0_dix_ldesc,
        range: *mut m0_ext,
        range_nr: m0_bcount_t,
        htype: m0_dix_hash_fnc_type,
        pver: *mut m0_fid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Copies layout descriptor."]
    #[doc = ""]
    #[doc = " Copied layout descriptor 'dst' shall be finalised by user afterwards."]
    pub fn m0_dix_ldesc_copy(
        dst: *mut m0_dix_ldesc,
        src: *const m0_dix_ldesc,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Finalises layout descriptor."]
    pub fn m0_dix_ldesc_fini(ld: *mut m0_dix_ldesc);
}
extern "C" {
    #[doc = " Initialises DIX layout iterator."]
    #[doc = ""]
    #[doc = " After initialisation iterator stay on first unit (data unit) in parity group."]
    #[doc = ""]
    #[doc = " @param iter   Layout iterator."]
    #[doc = " @param index  Fid of distributed index having layout 'ldesc'."]
    #[doc = " @param ldom   Layout domain where layout instance is created."]
    #[doc = " @param pver   Pool version where distributed index is stored."]
    #[doc = " @param ldesc  Distributed index layout descriptor."]
    #[doc = " @param key    Key of the record for which targets are calculated."]
    pub fn m0_dix_layout_iter_init(
        iter: *mut m0_dix_layout_iter,
        index: *const m0_fid,
        ldom: *mut m0_layout_domain,
        pver: *mut m0_pool_version,
        ldesc: *mut m0_dix_ldesc,
        key: *mut m0_buf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Calculates target for the next unit in record parity group."]
    #[doc = ""]
    #[doc = " User is responsible to not overcome parity group boundary. Number of units in"]
    #[doc = " parity group can be obtained via m0_dix_liter_W()."]
    pub fn m0_dix_layout_iter_next(iter: *mut m0_dix_layout_iter, tgt: *mut u64);
}
extern "C" {
    #[doc = " Moves iterator current position to unit with number 'unit_nr'."]
    #[doc = ""]
    #[doc = " Next m0_dix_layout_iter_next() invocation will return target for 'unit_nr'"]
    #[doc = " unit."]
    pub fn m0_dix_layout_iter_goto(iter: *mut m0_dix_layout_iter, unit_nr: u64);
}
extern "C" {
    #[doc = " Resets iterator current position to the beginning."]
    pub fn m0_dix_layout_iter_reset(iter: *mut m0_dix_layout_iter);
}
extern "C" {
    #[doc = " Calculates target for specified 'unit' in a parity group."]
    #[doc = ""]
    #[doc = " It doesn't affect iterator current position."]
    pub fn m0_dix_layout_iter_get_at(iter: *mut m0_dix_layout_iter, unit: u64, tgt: *mut u64);
}
extern "C" {
    #[doc = " Returns number of data units in a parity group."]
    #[doc = ""]
    #[doc = " Shall be always 1 in current implementation."]
    pub fn m0_dix_liter_N(iter: *mut m0_dix_layout_iter) -> u32;
}
extern "C" {
    #[doc = " Returns total number of targets."]
    pub fn m0_dix_liter_P(iter: *mut m0_dix_layout_iter) -> u32;
}
extern "C" {
    #[doc = " Returns number of parity units in a parity group."]
    pub fn m0_dix_liter_K(iter: *mut m0_dix_layout_iter) -> u32;
}
extern "C" {
    #[doc = " Returns number of spare units in a parity group."]
    pub fn m0_dix_liter_S(iter: *mut m0_dix_layout_iter) -> u32;
}
extern "C" {
    #[doc = " Returns total number of units (datai + parity + spare) in a parity group."]
    pub fn m0_dix_liter_W(iter: *mut m0_dix_layout_iter) -> u32;
}
extern "C" {
    #[doc = " Returns number of first spare unit in a parity group."]
    pub fn m0_dix_liter_spare_offset(iter: *mut m0_dix_layout_iter) -> u32;
}
extern "C" {
    #[doc = " Classify specified 'unit' to one of the classes listed in"]
    #[doc = " m0_pdclust_unit_type."]
    pub fn m0_dix_liter_unit_classify(iter: *mut m0_dix_layout_iter, unit: u64) -> u32;
}
extern "C" {
    #[doc = " Finalises DIX layout iterator."]
    pub fn m0_dix_layout_iter_fini(iter: *mut m0_dix_layout_iter);
}
extern "C" {
    #[doc = " Checks whether two distributed index layouts are equal."]
    pub fn m0_dix_layout_eq(layout1: *const m0_dix_layout, layout2: *const m0_dix_layout) -> bool;
}
#[doc = " Imported."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_op_idx {
    _unused: [u8; 0],
}
#[doc = " Simple service without persistent storage."]
pub const m0_idx_service_type_M0_IDX_MOCK: m0_idx_service_type = 0;
#[doc = " Service based on Motr distributed indexing component."]
#[doc = " Two types of indices are supported:"]
#[doc = " - distributed index, which is distributed over multiple storage"]
#[doc = "   devices and network nodes in the cluster for performance,"]
#[doc = "   scalability and fault tolerance."]
#[doc = " - non-distributed index, which is stored on a single node. Client"]
#[doc = "   user can't choose the node, the first CAS service from Motr"]
#[doc = "   configuration is used."]
pub const m0_idx_service_type_M0_IDX_DIX: m0_idx_service_type = 1;
#[doc = " Service using Cassandra database as persistent storage."]
pub const m0_idx_service_type_M0_IDX_CASS: m0_idx_service_type = 2;
#[doc = " Service using Cassandra database as persistent storage."]
pub const m0_idx_service_type_M0_IDX_MAX_SERVICE_ID: m0_idx_service_type = 3;
#[doc = " Types of index services supported by Client."]
pub type m0_idx_service_type = ::std::os::raw::c_uint;
#[doc = " For M0_IC_PUT operation, instructs it to silently overwrite"]
#[doc = " existing record with the same key, if any."]
pub const m0_op_idx_flags_M0_OIF_OVERWRITE: m0_op_idx_flags = 1;
#[doc = " For M0_IC_NEXT operation, instructs it to skip record with the"]
#[doc = " given start key."]
pub const m0_op_idx_flags_M0_OIF_EXCLUDE_START_KEY: m0_op_idx_flags = 2;
#[doc = " For M0_IC_PUT/M0_IC_DEL operation, instructs it to"]
#[doc = " delay the reply until data is persisted."]
pub const m0_op_idx_flags_M0_OIF_SYNC_WAIT: m0_op_idx_flags = 4;
#[doc = " Values of index operation flags supported by Client index operation."]
pub type m0_op_idx_flags = ::std::os::raw::c_uint;
#[doc = " Query operations for an index service. The operations in this data"]
#[doc = " structure can be divided into 2 groups:"]
#[doc = " (a) Operations over indices: iqo_namei_create/delete/lookup/list."]
#[doc = " (b) Queries on a specific index: get/put/del/next, see the comments above for"]
#[doc = "     details."]
#[doc = ""]
#[doc = " Returned value of query operations:"]
#[doc = "     = 0: the query is executed synchronously and returns successfully."]
#[doc = "     < 0: the query fails."]
#[doc = "     = 1: the driver successes in launching the query asynchronously."]
#[doc = ""]
#[doc = " idx_op_ast_complete()/fail() must be called correspondingly when an"]
#[doc = " index operation is completed successfully or fails. This gives Client"]
#[doc = " a chance to take back control and move operation's state forward."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_query_ops {
    pub iqo_namei_create:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_namei_delete:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_namei_lookup:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_namei_list:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_get:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_put:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_del:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
    pub iqo_next:
        ::std::option::Option<unsafe extern "C" fn(oi: *mut m0_op_idx) -> ::std::os::raw::c_int>,
}
#[test]
fn bindgen_test_layout_m0_idx_query_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_query_ops>(),
        64usize,
        concat!("Size of: ", stringify!(m0_idx_query_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_query_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_query_ops))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_namei_create as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_namei_create)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_namei_delete as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_namei_delete)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_namei_lookup as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_namei_lookup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_namei_list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_namei_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_get as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_get)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_put as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_put)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_del as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_del)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_query_ops>())).iqo_next as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_query_ops),
            "::",
            stringify!(iqo_next)
        )
    );
}
#[doc = " Initialisation and finalisation functions for an index service."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_service_ops {
    pub iso_init: ::std::option::Option<
        unsafe extern "C" fn(svc: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub iso_fini: ::std::option::Option<
        unsafe extern "C" fn(svc: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_m0_idx_service_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_service_ops>(),
        16usize,
        concat!("Size of: ", stringify!(m0_idx_service_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_service_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_service_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service_ops>())).iso_init as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service_ops),
            "::",
            stringify!(iso_init)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service_ops>())).iso_fini as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service_ops),
            "::",
            stringify!(iso_fini)
        )
    );
}
#[doc = " Client separates the definitions of index service and its instances(ctx)"]
#[doc = " to allow a Client instance to have its own kind of index service."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_service {
    pub is_svc_ops: *mut m0_idx_service_ops,
    pub is_query_ops: *mut m0_idx_query_ops,
}
#[test]
fn bindgen_test_layout_m0_idx_service() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_service>(),
        16usize,
        concat!("Size of: ", stringify!(m0_idx_service))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_service>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_service))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service>())).is_svc_ops as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service),
            "::",
            stringify!(is_svc_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service>())).is_query_ops as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service),
            "::",
            stringify!(is_query_ops)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_service_ctx {
    pub isc_service: *mut m0_idx_service,
    #[doc = " isc_config: service specific configurations."]
    #[doc = " isc_conn  : connection to the index service"]
    pub isc_svc_conf: *mut ::std::os::raw::c_void,
    pub isc_svc_inst: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_m0_idx_service_ctx() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_service_ctx>(),
        24usize,
        concat!("Size of: ", stringify!(m0_idx_service_ctx))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_service_ctx>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_service_ctx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service_ctx>())).isc_service as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service_ctx),
            "::",
            stringify!(isc_service)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service_ctx>())).isc_svc_conf as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service_ctx),
            "::",
            stringify!(isc_svc_conf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_service_ctx>())).isc_svc_inst as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_service_ctx),
            "::",
            stringify!(isc_svc_inst)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_cass_config {
    pub cc_cluster_ep: *mut ::std::os::raw::c_char,
    pub cc_keyspace: *mut ::std::os::raw::c_char,
    pub cc_max_column_family_num: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_m0_idx_cass_config() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_cass_config>(),
        24usize,
        concat!("Size of: ", stringify!(m0_idx_cass_config))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_cass_config>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_cass_config))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_cass_config>())).cc_cluster_ep as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_cass_config),
            "::",
            stringify!(cc_cluster_ep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_idx_cass_config>())).cc_keyspace as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_cass_config),
            "::",
            stringify!(cc_keyspace)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_cass_config>())).cc_max_column_family_num as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_cass_config),
            "::",
            stringify!(cc_max_column_family_num)
        )
    );
}
#[doc = " Configuration for Motr DIX (distributed indices) index service."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_idx_dix_config {
    #[doc = " Indicates whether distributed index meta-data should be created in"]
    #[doc = " file system during service initialisation. Meta-data is global for"]
    #[doc = " the file system and normally is created during cluster provisioning,"]
    #[doc = " so this flag is unset usually. Layouts of 'layout' and 'layout-descr'"]
    #[doc = " indices are provided by kc_layout_ldesc and kc_ldescr_ldesc fields."]
    #[doc = ""]
    #[doc = " Setting this flag is useful for unit tests."]
    #[doc = ""]
    #[doc = " See dix/client.h for more information."]
    pub kc_create_meta: bool,
    #[doc = " Layout of 'layout' meta-index."]
    #[doc = " Ignored if kc_create_meta is unset."]
    pub kc_layout_ldesc: m0_dix_ldesc,
    #[doc = " Layout of 'layout-descr' meta-index."]
    #[doc = " Ignored if kc_create_meta is unset."]
    pub kc_ldescr_ldesc: m0_dix_ldesc,
}
#[test]
fn bindgen_test_layout_m0_idx_dix_config() {
    assert_eq!(
        ::std::mem::size_of::<m0_idx_dix_config>(),
        88usize,
        concat!("Size of: ", stringify!(m0_idx_dix_config))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_idx_dix_config>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_idx_dix_config))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_dix_config>())).kc_create_meta as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_dix_config),
            "::",
            stringify!(kc_create_meta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_dix_config>())).kc_layout_ldesc as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_dix_config),
            "::",
            stringify!(kc_layout_ldesc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_idx_dix_config>())).kc_ldescr_ldesc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_idx_dix_config),
            "::",
            stringify!(kc_ldescr_ldesc)
        )
    );
}
extern "C" {
    pub static oi_bobtype: m0_bob_type;
}
extern "C" {
    pub fn m0_op_idx_bob_init(bob: *mut m0_op_idx);
}
extern "C" {
    pub fn m0_op_idx_bob_fini(bob: *mut m0_op_idx);
}
extern "C" {
    pub fn m0_op_idx_bob_check(bob: *const m0_op_idx) -> bool;
}
extern "C" {
    pub fn m0__idx_op_invariant(oi: *mut m0_op_idx) -> bool;
}
extern "C" {
    pub fn idx_op_ast_complete(grp: *mut m0_sm_group, ast: *mut m0_sm_ast);
}
extern "C" {
    pub fn idx_op_ast_executed(grp: *mut m0_sm_group, ast: *mut m0_sm_ast);
}
extern "C" {
    pub fn idx_op_ast_stable(grp: *mut m0_sm_group, ast: *mut m0_sm_ast);
}
extern "C" {
    pub fn idx_op_ast_fail(grp: *mut m0_sm_group, ast: *mut m0_sm_ast);
}
extern "C" {
    pub fn m0_idx_op_namei(
        entity: *mut m0_entity,
        op: *mut *mut m0_op,
        opcode: m0_entity_opcode,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_idx_service_config(
        m0c: *mut m0_client,
        svc_id: ::std::os::raw::c_int,
        svc_conf: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn m0_idx_service_register(
        svc_id: ::std::os::raw::c_int,
        sops: *mut m0_idx_service_ops,
        qops: *mut m0_idx_query_ops,
    );
}
extern "C" {
    pub fn m0_idx_services_register();
}
extern "C" {
    pub fn m0_idx_mock_register();
}
extern "C" {
    pub fn m0_idx_dix_register();
}
extern "C" {
    pub static mut m0_buf_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_bufs_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_buf_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_bufs_struct_init();
}
extern "C" {
    pub fn m0_xc_lib_buf_init();
}
extern "C" {
    pub fn m0_xc_lib_buf_fini();
}
extern "C" {
    pub static mut m0_cookie_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_cookie_struct_init();
}
extern "C" {
    pub fn m0_xc_lib_cookie_init();
}
extern "C" {
    pub fn m0_xc_lib_cookie_fini();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rpc_at_bulk {
    _unused: [u8; 0],
}
pub const m0_rpc_at_type_M0_RPC_AT_EMPTY: m0_rpc_at_type = 0;
pub const m0_rpc_at_type_M0_RPC_AT_INLINE: m0_rpc_at_type = 1;
pub const m0_rpc_at_type_M0_RPC_AT_BULK_SEND: m0_rpc_at_type = 2;
pub const m0_rpc_at_type_M0_RPC_AT_BULK_RECV: m0_rpc_at_type = 3;
pub const m0_rpc_at_type_M0_RPC_AT_BULK_REP: m0_rpc_at_type = 4;
pub const m0_rpc_at_type_M0_RPC_AT_TYPE_NR: m0_rpc_at_type = 5;
pub type m0_rpc_at_type = ::std::os::raw::c_uint;
pub const M0_RPC_AT_UNKNOWN_LEN: ::std::os::raw::c_uint = 0;
pub type _bindgen_ty_37 = ::std::os::raw::c_uint;
#[doc = " Sent by server as a reply to client requesting the buffer in case of inbulk."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rpc_at_bulk_rep {
    #[doc = " RPC bulk transfer result."]
    #[doc = " -ENOMSG if inbulk is required, but client requested inline or"]
    #[doc = "  provided net buffer descriptor with insufficient length."]
    pub abr_rc: i32,
    #[doc = " Length of the requested buffer."]
    pub abr_len: u64,
}
#[test]
fn bindgen_test_layout_m0_rpc_at_bulk_rep() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_at_bulk_rep>(),
        16usize,
        concat!("Size of: ", stringify!(m0_rpc_at_bulk_rep))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_at_bulk_rep>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_at_bulk_rep))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_bulk_rep>())).abr_rc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_bulk_rep),
            "::",
            stringify!(abr_rc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_bulk_rep>())).abr_len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_bulk_rep),
            "::",
            stringify!(abr_len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_rpc_at_extra {
    pub abr_desc: m0_net_buf_desc_data,
    pub abr_bulk: *mut rpc_at_bulk,
    pub abr_user_buf: m0_buf,
}
#[test]
fn bindgen_test_layout_m0_rpc_at_extra() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_at_extra>(),
        48usize,
        concat!("Size of: ", stringify!(m0_rpc_at_extra))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_at_extra>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_at_extra))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_extra>())).abr_desc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_extra),
            "::",
            stringify!(abr_desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_extra>())).abr_bulk as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_extra),
            "::",
            stringify!(abr_bulk)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_extra>())).abr_user_buf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_extra),
            "::",
            stringify!(abr_user_buf)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_rpc_at_buf {
    #[doc = " Value from enum m0_rpc_at_type."]
    pub ab_type: u32,
    pub u: m0_rpc_at_buf__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union m0_rpc_at_buf__bindgen_ty_1 {
    pub ab_buf: m0_buf,
    pub ab_send: m0_net_buf_desc_data,
    pub ab_recv: m0_net_buf_desc_data,
    pub ab_rep: m0_rpc_at_bulk_rep,
    #[doc = " That's a workaround to store back reference to RPC bulk structure"]
    #[doc = " serving inbulk transmission of AT buffer. Don't use a"]
    #[doc = " separate field in order to avoid sending it over the network."]
    #[doc = ""]
    #[doc = " Back reference presents in RAM due to union layout, but is"]
    #[doc = " not serialised by xcode."]
    pub ab_extra: m0_rpc_at_extra,
}
#[test]
fn bindgen_test_layout_m0_rpc_at_buf__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_at_buf__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(m0_rpc_at_buf__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_at_buf__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_at_buf__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_at_buf__bindgen_ty_1>())).ab_buf as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf__bindgen_ty_1),
            "::",
            stringify!(ab_buf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_at_buf__bindgen_ty_1>())).ab_send as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf__bindgen_ty_1),
            "::",
            stringify!(ab_send)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_at_buf__bindgen_ty_1>())).ab_recv as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf__bindgen_ty_1),
            "::",
            stringify!(ab_recv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_at_buf__bindgen_ty_1>())).ab_rep as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf__bindgen_ty_1),
            "::",
            stringify!(ab_rep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_rpc_at_buf__bindgen_ty_1>())).ab_extra as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf__bindgen_ty_1),
            "::",
            stringify!(ab_extra)
        )
    );
}
#[test]
fn bindgen_test_layout_m0_rpc_at_buf() {
    assert_eq!(
        ::std::mem::size_of::<m0_rpc_at_buf>(),
        56usize,
        concat!("Size of: ", stringify!(m0_rpc_at_buf))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_rpc_at_buf>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_rpc_at_buf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_buf>())).ab_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf),
            "::",
            stringify!(ab_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_rpc_at_buf>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_rpc_at_buf),
            "::",
            stringify!(u)
        )
    );
}
extern "C" {
    #[doc = " Initialises AT buffer."]
    #[doc = ""]
    #[doc = " Should be called for AT buffer, that is not received from the network, e.g."]
    #[doc = " before m0_rpc_at_add(), m0_rpc_at_recv(), m0_rpc_at_reply() (for out buffer)."]
    pub fn m0_rpc_at_init(ab: *mut m0_rpc_at_buf);
}
extern "C" {
    #[doc = " Finalises AT buffer."]
    #[doc = ""]
    #[doc = " Should be called before container RPC item finalisation, but after RPC item"]
    #[doc = " is sent over network."]
    pub fn m0_rpc_at_fini(ab: *mut m0_rpc_at_buf);
}
extern "C" {
    #[doc = " Called once for an AT buffer. If this returns success, then AT buffer"]
    #[doc = " can be serialised as part of rpc item. On success, buffer content will be"]
    #[doc = " deallocated in m0_rpc_at_fini(), unless m0_rpc_at_detach() is called."]
    #[doc = ""]
    #[doc = " @pre conn != NULL"]
    pub fn m0_rpc_at_add(
        ab: *mut m0_rpc_at_buf,
        buf: *const m0_buf,
        conn: *const m0_rpc_conn,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Loads AT buffer contents."]
    #[doc = ""]
    #[doc = " Fom unconditionally moves to 'next_phase'. Once AT buffer is fully loaded,"]
    #[doc = " fom tick function is called."]
    #[doc = ""]
    #[doc = " If the buffer is transmitted inline, then there is nothing to do and"]
    #[doc = " M0_FSO_AGAIN is returned. Otherwise, asynchronous buffer loading through"]
    #[doc = " RPC bulk is started and M0_FSO_WAIT is returned."]
    #[doc = ""]
    #[doc = " Returns value from @ref m0_fom_phase_outcome."]
    #[doc = " @see m0_rpc_at_get()"]
    pub fn m0_rpc_at_load(
        ab: *mut m0_rpc_at_buf,
        fom: *mut m0_fom,
        next_phase: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initialises user-supplied buffer with AT buffer data."]
    #[doc = ""]
    #[doc = " Should be called after m0_rpc_at_load() finished loading. Function doesn't"]
    #[doc = " actually copy AT buffer data, but assigns 'buf' fields to point to received"]
    #[doc = " data. The data is accessible until 'ab' is not finalised."]
    #[doc = ""]
    #[doc = " Returns result of loading invoked by m0_rpc_at_load()."]
    #[doc = " @see m0_rpc_at_load()"]
    pub fn m0_rpc_at_get(ab: *const m0_rpc_at_buf, buf: *mut m0_buf) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Prepares AT buffer reception request."]
    #[doc = ""]
    #[doc = " @param conn       RPC connection."]
    #[doc = " @param len        Expected length of the buffer, ignored for inline."]
    #[doc = " @param force_bulk Force inbulk transmission method."]
    #[doc = ""]
    #[doc = " @pre conn != NULL"]
    pub fn m0_rpc_at_recv(
        ab: *mut m0_rpc_at_buf,
        conn: *const m0_rpc_conn,
        len: u32,
        force_bulk: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Adds user-supplied buffer to AT buffer embedded in server reply."]
    #[doc = ""]
    #[doc = " Fom unconditionally moves to 'next_phase'. Once buffer is processed (sent via"]
    #[doc = " inbulk or embedded in reply FOP), fom tick function is called."]
    #[doc = ""]
    #[doc = " Returns value from @ref m0_fom_phase_outcome."]
    #[doc = " @see m0_rpc_at_reply_rc()"]
    pub fn m0_rpc_at_reply(
        in_: *mut m0_rpc_at_buf,
        out: *mut m0_rpc_at_buf,
        repbuf: *mut m0_buf,
        fom: *mut m0_fom,
        next_phase: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns execution result of m0_rpc_at_reply()."]
    #[doc = ""]
    #[doc = " @see m0_rpc_at_reply()"]
    pub fn m0_rpc_at_reply_rc(out: *mut m0_rpc_at_buf) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initialises user-supplied buffer with AT buffer data received as reply."]
    #[doc = ""]
    #[doc = " Intended to be called on client side."]
    #[doc = ""]
    #[doc = " @see m0_rpc_at_rep_is_bulk"]
    pub fn m0_rpc_at_rep_get(
        sent: *mut m0_rpc_at_buf,
        rcvd: *mut m0_rpc_at_buf,
        out: *mut m0_buf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Transforms received AT buffer to inline type."]
    #[doc = ""]
    #[doc = " Regardless of actual transmission method used, modify received buffer as it"]
    #[doc = " was received via inline transmission method. Buffer referred by a 'sent'"]
    #[doc = " argument can be safely finalised afterwards."]
    pub fn m0_rpc_at_rep2inline(
        sent: *mut m0_rpc_at_buf,
        rcvd: *mut m0_rpc_at_buf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Checks whether inbulk was used by server to send AT buffer."]
    #[doc = ""]
    #[doc = " Allows client to discover actual buffer length, stored on server."]
    #[doc = " Also, return value 'true' indicates that server requested inbulk method for"]
    #[doc = " buffer transmission."]
    pub fn m0_rpc_at_rep_is_bulk(rcvd: *const m0_rpc_at_buf, len: *mut u64) -> bool;
}
extern "C" {
    #[doc = " Checks whether AT buffer has some associated data."]
    #[doc = ""]
    #[doc = " AT buffer is considered to be empty if:"]
    #[doc = " - Buffer is initialised, but no data is attached (has type M0_RPC_AT_EMPTY)."]
    #[doc = " - Buffer is intented for buffer reception."]
    #[doc = " - Buffer has type M0_RPC_AT_BULK_REP, but no bytes were transmitted via bulk."]
    pub fn m0_rpc_at_is_set(ab: *const m0_rpc_at_buf) -> bool;
}
extern "C" {
    #[doc = " Detaches internal data buffer from AT buffer."]
    #[doc = ""]
    #[doc = " Transfers data buffer ownership to the user, so user is responsible for its"]
    #[doc = " deallocation. For received AT buffer internal data buffer can be obtained via"]
    #[doc = " m0_rpc_at_rep_get(). For sent AT buffer it's the buffer provided in"]
    #[doc = " m0_rpc_at_add()."]
    pub fn m0_rpc_at_detach(ab: *mut m0_rpc_at_buf);
}
extern "C" {
    #[doc = " Returns length of data attached to buffer."]
    #[doc = ""]
    #[doc = " Returned value interpretation depends on buffer type:"]
    #[doc = " - M0_RPC_AT_INLINE, M0_RPC_AT_BULK_SEND: length of the attached buffer;"]
    #[doc = " - M0_RPC_AT_BULK_RECV: total size of RPC bulk buffers reserved by client;"]
    #[doc = " - M0_RPC_AT_BULK_REP: size of buffer set by service regardless of rc."]
    pub fn m0_rpc_at_len(ab: *const m0_rpc_at_buf) -> u64;
}
extern "C" {
    pub static mut m0_rpc_at_buf_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_rpc_at_extra_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_rpc_at_bulk_rep_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_rpc_at_buf_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_rpc_at_extra_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_rpc_at_bulk_rep_struct_init();
}
extern "C" {
    pub fn m0_xc_rpc_at_init();
}
extern "C" {
    pub fn m0_xc_rpc_at_fini();
}
#[doc = "An array of bits (Booleans)."]
#[doc = ""]
#[doc = "The bitmap is stored as an array of 64-bit \"words\""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_bitmap {
    #[doc = " Number of bits in this map."]
    pub b_nr: size_t,
    #[doc = " Words with bits."]
    pub b_words: *mut u64,
}
#[test]
fn bindgen_test_layout_m0_bitmap() {
    assert_eq!(
        ::std::mem::size_of::<m0_bitmap>(),
        16usize,
        concat!("Size of: ", stringify!(m0_bitmap))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_bitmap>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_bitmap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bitmap>())).b_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bitmap),
            "::",
            stringify!(b_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bitmap>())).b_words as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bitmap),
            "::",
            stringify!(b_words)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_bitmap_onwire {
    #[doc = " size of bo_words."]
    pub bo_size: size_t,
    #[doc = " Words with bits."]
    pub bo_words: *mut u64,
}
#[test]
fn bindgen_test_layout_m0_bitmap_onwire() {
    assert_eq!(
        ::std::mem::size_of::<m0_bitmap_onwire>(),
        16usize,
        concat!("Size of: ", stringify!(m0_bitmap_onwire))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_bitmap_onwire>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_bitmap_onwire))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bitmap_onwire>())).bo_size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bitmap_onwire),
            "::",
            stringify!(bo_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_bitmap_onwire>())).bo_words as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_bitmap_onwire),
            "::",
            stringify!(bo_words)
        )
    );
}
extern "C" {
    #[doc = "Initialise a bitmap to hold nr bits. The array to store bits is"]
    #[doc = "allocated internally."]
    #[doc = ""]
    #[doc = "On success, the bitmap is initialised with all bits initially"]
    #[doc = "set to false."]
    #[doc = ""]
    #[doc = "@param map bitmap object to initialize"]
    #[doc = "@param nr  size of the bitmap, in bits"]
    #[doc = "@retval 0 success"]
    #[doc = "@retval !0 failure, -errno"]
    pub fn m0_bitmap_init(map: *mut m0_bitmap, nr: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Finalise the bitmap."]
    #[doc = "All memory associated with the bitmap is released."]
    #[doc = ""]
    #[doc = "@param map bitmap to finalise"]
    pub fn m0_bitmap_fini(map: *mut m0_bitmap);
}
extern "C" {
    #[doc = "Get a bit value from a bitmap."]
    #[doc = ""]
    #[doc = "@pre idx < map->b_br"]
    #[doc = ""]
    #[doc = "@param map bitmap to query"]
    #[doc = "@param idx bit offset in the bitmap to query"]
    #[doc = "@return the bit value, true or false."]
    pub fn m0_bitmap_get(map: *const m0_bitmap, idx: size_t) -> bool;
}
extern "C" {
    #[doc = "Find first zero (a.k.a unset, false) bit from a bitmap."]
    #[doc = ""]
    #[doc = "@param map bitmap to query"]
    #[doc = "@return index of the first zero bit. If no zero bit found, -1 is returned."]
    pub fn m0_bitmap_ffz(map: *const m0_bitmap) -> size_t;
}
extern "C" {
    #[doc = "Set a bit value in a bitmap."]
    #[doc = ""]
    #[doc = "@param map bitmap to modify"]
    #[doc = "@param idx bit offset to modify.  Attempting to set a bit beyond the size"]
    #[doc = "of the bitmap results is not allowed (causes and assert to fail)."]
    #[doc = "@param val new bit value, true or false"]
    pub fn m0_bitmap_set(map: *mut m0_bitmap, idx: size_t, val: bool);
}
extern "C" {
    #[doc = "Reset a bitmap."]
    pub fn m0_bitmap_reset(map: *mut m0_bitmap);
}
extern "C" {
    #[doc = "Copies the bit values from one bitmap to another."]
    #[doc = "@param dst destination bitmap, must already be initialised.  If dst"]
    #[doc = "is larger than src, bits beyond src->b_nr are cleared in dst."]
    #[doc = "@param src source bitmap"]
    #[doc = "@pre dst->b_nr >= src->b_nr"]
    pub fn m0_bitmap_copy(dst: *mut m0_bitmap, src: *const m0_bitmap);
}
extern "C" {
    #[doc = " Returns the number of bits that are 'true'."]
    pub fn m0_bitmap_set_nr(map: *const m0_bitmap) -> size_t;
}
extern "C" {
    #[doc = "Initialise an on-wire bitmap to hold nr bits. The array to store bits is"]
    #[doc = "allocated internally."]
    #[doc = ""]
    #[doc = "On success, the bitmap is initialised with all bits initially set to false."]
    #[doc = ""]
    #[doc = "@param ow_map on-wire bitmap object to initialise"]
    #[doc = "@param nr  size of the bitmap, in bits"]
    #[doc = "@retval 0 success"]
    #[doc = "@retval !0 failure, -errno"]
    pub fn m0_bitmap_onwire_init(
        ow_map: *mut m0_bitmap_onwire,
        nr: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Finalise the on-wire bitmap."]
    #[doc = "All memory associated with the on-wire bitmap is released."]
    #[doc = ""]
    #[doc = "@param ow_map on-wire bitmap to finalise"]
    pub fn m0_bitmap_onwire_fini(ow_map: *mut m0_bitmap_onwire);
}
extern "C" {
    #[doc = "Converts in-memory struct m0_bitmap to on-wire struct m0_bitmap_onwire."]
    #[doc = ""]
    #[doc = "@param im_map in-memory bitmap object to be converted into on-wire bitmap"]
    #[doc = "object."]
    #[doc = "@param ow_map pre-initialised on-wire bitmap object"]
    pub fn m0_bitmap_store(im_map: *const m0_bitmap, ow_map: *mut m0_bitmap_onwire);
}
extern "C" {
    #[doc = "Converts on-wire bitmap to in-memory bitmap."]
    #[doc = ""]
    #[doc = "@param ow_map on-wire bitmap object to be converted into in-memory bitmap."]
    #[doc = "@param im_map pre-initialised in-memory bitmap object"]
    pub fn m0_bitmap_load(ow_map: *const m0_bitmap_onwire, im_map: *mut m0_bitmap);
}
#[doc = " A processor number/identifier."]
pub type m0_processor_nr_t = u32;
extern "C" {
    #[doc = "Initialize processors interface. This will allow the interface"]
    #[doc = "to cache/populate the data, if necessary. The data is cached for"]
    #[doc = "user mode. The data may not be cached for kernel mode as kernel already"]
    #[doc = "has the data."]
    #[doc = ""]
    #[doc = "The calling function should not assume hot-plug CPU facility."]
    #[doc = "If the underlying OS supports the hot-plug CPU facility, the calling"]
    #[doc = "program will have to re-initalize the interface (at least in user-mode)"]
    #[doc = "after registering for platform specific CPU change notification."]
    #[doc = ""]
    #[doc = "To re-initalize the interface, m0_processors_fini() must be called first,"]
    #[doc = "before initializing it again."]
    #[doc = ""]
    #[doc = "@post Interface initialized."]
    #[doc = ""]
    #[doc = "Concurrency: The interface should not be initialized twice or simultaneously."]
    #[doc = "It's not MT-safe and can be called only once. It can be"]
    #[doc = "called again after calling m0_processors_fini()."]
    pub fn m0_processors_init() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Close the processors interface. This function will destroy any cached data."]
    #[doc = "After calling this interface no meaningful data should be assumed."]
    #[doc = ""]
    #[doc = "Concurrency: Not MT-safe. Assumes no threads are using processor interface."]
    pub fn m0_processors_fini();
}
extern "C" {
    #[doc = "Maximum processors this system can handle."]
    pub fn m0_processor_nr_max() -> m0_processor_nr_t;
}
extern "C" {
    #[doc = "Return the bitmap of possible processors."]
    #[doc = ""]
    #[doc = "@pre map->b_nr >= m0_processor_nr_max()"]
    #[doc = "@pre m0_processors_init() must be called before calling this function."]
    #[doc = "@pre The calling function must allocate memory for 'map' and initialize it."]
    #[doc = "@note This function does not take any locks."]
    pub fn m0_processors_possible(map: *mut m0_bitmap);
}
extern "C" {
    #[doc = "Return the bitmap of available processors."]
    #[doc = ""]
    #[doc = "@pre map->b_nr >= m0_processor_nr_max()"]
    #[doc = "@pre m0_processors_init() must be called before calling this function."]
    #[doc = "@pre The calling function must allocate memory for 'map' and initialize it."]
    #[doc = "@note This function does not take any locks."]
    pub fn m0_processors_available(map: *mut m0_bitmap);
}
extern "C" {
    #[doc = "Return the bitmap of online processors."]
    #[doc = ""]
    #[doc = "@pre map->b_nr >= m0_processor_nr_max()"]
    #[doc = "@pre m0_processors_init() must be called before calling this function."]
    #[doc = "@pre The calling function must allocate memory for 'map' and initialize it."]
    #[doc = "@note This function does not take any locks."]
    pub fn m0_processors_online(map: *mut m0_bitmap);
}
extern "C" {
    #[doc = "Return the id of the processor on which the calling thread is running."]
    #[doc = ""]
    #[doc = "@return logical processor id (as supplied by the system) on which the"]
    #[doc = "calling thread is running, if the call is unsupported."]
    #[doc = "It will return M0_PROCESSORS_INVALID_ID, if this call is not"]
    #[doc = "supported."]
    pub fn m0_processor_id_get() -> m0_processor_nr_t;
}
#[doc = "Description of a processor in the system."]
#[doc = "Please note that L1 and L2 cache ids may have to bee generated by the"]
#[doc = "program."]
#[doc = ""]
#[doc = "Example : Id generation on Linux (user-mode)"]
#[doc = "@verbatim"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "| Name          |    Identifier Description                                 |"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "| pd_numa_node  | NumaNode Id as supplied by the system                     |"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "| pd_id         | Logical processor id supplied by the system               |"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "| pd_l1         | 1. If L1 is not shared with any other processor, then     |"]
#[doc = "|               |    it's same as pd_id.                                    |"]
#[doc = "|               | 2. If L1 is shared,                                       |"]
#[doc = "|               |    Physical Package Id (16-31) |  Core Id (0-15)          |"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "| pd_l2         | 1. If L2 is not shared with any other processor, then     |"]
#[doc = "|               |    it's same as pd_id.                                    |"]
#[doc = "|               | 3. If L2 is shared and L3 is present, its                 |"]
#[doc = "|               |    Physical Package Id (16-31) | Core Id (0-15)           |"]
#[doc = "|               | 3. If L2 is shared and L3 is not present, its             |"]
#[doc = "|               |    Physical Package Id                                    |"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "| pd_pipeline   | Same as pd_id                                             |"]
#[doc = "+---------------+-----------------------------------------------------------+"]
#[doc = "@endverbatim"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_processor_descr {
    #[doc = " Processor identifier."]
    pub pd_id: m0_processor_nr_t,
    #[doc = " All processors in the same numa node share this"]
    pub pd_numa_node: u32,
    #[doc = " Id for L1 cache. If multiple processors share L1 cache, all of them"]
    #[doc = "will have same L1 cache id"]
    pub pd_l1: u32,
    #[doc = " Id for L2 cache. If multiple processors share L2 cache, all of them"]
    #[doc = "will have same L2 cache id"]
    pub pd_l2: u32,
    #[doc = " L1 cache size (in bytes) for this processor"]
    pub pd_l1_sz: size_t,
    #[doc = " L2 cache size (in bytes) for this processor"]
    pub pd_l2_sz: size_t,
    #[doc = " All processors sharing the same pipeline have the same value of"]
    #[doc = "this."]
    pub pd_pipeline: u32,
}
#[test]
fn bindgen_test_layout_m0_processor_descr() {
    assert_eq!(
        ::std::mem::size_of::<m0_processor_descr>(),
        40usize,
        concat!("Size of: ", stringify!(m0_processor_descr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_processor_descr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_processor_descr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_numa_node as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_numa_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_l1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_l1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_l2 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_l2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_l1_sz as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_l1_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_l2_sz as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_l2_sz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_processor_descr>())).pd_pipeline as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_processor_descr),
            "::",
            stringify!(pd_pipeline)
        )
    );
}
extern "C" {
    #[doc = "Obtain information on the processor with a given id."]
    #[doc = "@param id -> id of the processor for which information is requested."]
    #[doc = "@param pd -> processor descripto structure. Memory for this should be"]
    #[doc = "allocated by the calling function. Interface does not allocate"]
    #[doc = "memory."]
    #[doc = ""]
    #[doc = "@retval 0 if a matching processor is found"]
    #[doc = "@retval -EINVAL if id does not match with any of the processors or NULL"]
    #[doc = "memory pointer for 'pd' is passed."]
    #[doc = ""]
    #[doc = "@pre  Memory must be allocated for pd. Interface donot allocated memory."]
    #[doc = "@pre m0_processors_init() must be called before calling this function."]
    #[doc = "@post d->pd_id == id or none"]
    #[doc = ""]
    #[doc = "Concurrency: This is read only data. Interface by itself does not do"]
    #[doc = "any locking. When used in kernel-mode, the interface may"]
    #[doc = "call some functions that may use some kind of locks."]
    pub fn m0_processor_describe(
        id: m0_processor_nr_t,
        pd: *mut m0_processor_descr,
    ) -> ::std::os::raw::c_int;
}
#[doc = " @defgroup lockers"]
#[doc = ""]
#[doc = " Lockers module provides an interface to support storage of private pointers"]
#[doc = " in parent structures. This allows not only for efficient sharing of data"]
#[doc = " with others but also removes duplication of such interfaces."]
#[doc = " To describe a typical usage pattern, consider one wants a locker for 32"]
#[doc = " objects in object of type foo."]
#[doc = ""]
#[doc = " Following things have to be done:"]
#[doc = ""]
#[doc = " - Declare a locker type by, M0_LOCKERS_DECLARE(scope, foo, 32)"]
#[doc = "   This will generate a structure of type foo_lockers and declarations for"]
#[doc = "   functions to manipulate foo_lockers."]
#[doc = "   It is required that a structure of type foo must be present in the source."]
#[doc = ""]
#[doc = " - embed foo_lockers in struct foo"]
#[doc = ""]
#[doc = "   @code"]
#[doc = "   struct foo {"]
#[doc = "         ..."]
#[doc = "\t   struct foo_lockers lockers;"]
#[doc = "\t   ..."]
#[doc = "   };"]
#[doc = "   @endcode"]
#[doc = ""]
#[doc = " - Next, define a locker type by M0_LOCKERS_DEFINE(scope, foo, lockers)"]
#[doc = ""]
#[doc = " Now to use this locker following interfaces can be used:"]
#[doc = ""]
#[doc = " - foo_lockers_allot    - Returns new key to access stored data."]
#[doc = " - foo_lockers_set      - Stores provided data against provided key."]
#[doc = " - foo_lockers_get      - Locates and returns data corresponding"]
#[doc = "                          to the provided key."]
#[doc = " - foo_lockers_clear    - Clears the data stored at given key."]
#[doc = " - foo_lockers_is_empty - Checks whether a data is stored at given key."]
#[doc = ""]
#[doc = " Lockers module does not provide any support against concurrency and"]
#[doc = " validation of data stored at a given key, it is the responsibility of the"]
#[doc = " invoker to take care of these aspects."]
#[doc = ""]
#[doc = " Please refer to unit test for understanding the nitty-gritty of lockers."]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_lockers_type {
    pub lot_max: u32,
    pub lot_inuse: *mut bool,
}
#[test]
fn bindgen_test_layout_m0_lockers_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_lockers_type>(),
        16usize,
        concat!("Size of: ", stringify!(m0_lockers_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_lockers_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_lockers_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_lockers_type>())).lot_max as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_lockers_type),
            "::",
            stringify!(lot_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_lockers_type>())).lot_inuse as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_lockers_type),
            "::",
            stringify!(lot_inuse)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct m0_lockers {
    pub loc_slots: __IncompleteArrayField<*mut ::std::os::raw::c_void>,
}
#[test]
fn bindgen_test_layout_m0_lockers() {
    assert_eq!(
        ::std::mem::size_of::<m0_lockers>(),
        0usize,
        concat!("Size of: ", stringify!(m0_lockers))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_lockers>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_lockers))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_lockers>())).loc_slots as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_lockers),
            "::",
            stringify!(loc_slots)
        )
    );
}
extern "C" {
    pub fn m0_lockers_init(lt: *const m0_lockers_type, lockers: *mut m0_lockers);
}
extern "C" {
    pub fn m0_lockers_fini(lt: *mut m0_lockers_type, lockers: *mut m0_lockers);
}
extern "C" {
    #[doc = " Allots a new key of type lt"]
    #[doc = " @pre lt->lot_count < lt->lot_max"]
    pub fn m0_lockers_allot(lt: *mut m0_lockers_type) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Frees a key of type lt"]
    #[doc = " @pre lt->lot_count < lt->lot_max"]
    pub fn m0_lockers_free(lt: *mut m0_lockers_type, key: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " Stores a value in locker"]
    #[doc = ""]
    #[doc = " @post !m0_lockers_is_empty(locker, key) &&"]
    #[doc = "        m0_lockers_get(locker, key) == data"]
    pub fn m0_lockers_set(
        lt: *const m0_lockers_type,
        lockers: *mut m0_lockers,
        key: u32,
        data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Retrieves a value stored in locker"]
    #[doc = ""]
    #[doc = " @pre !m0_lockers_is_empty(locker, key)"]
    pub fn m0_lockers_get(
        lt: *const m0_lockers_type,
        lockers: *const m0_lockers,
        key: u32,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Clears the value stored in a locker"]
    #[doc = ""]
    #[doc = " @post m0_lockers_is_empty(locker, key)"]
    pub fn m0_lockers_clear(lt: *const m0_lockers_type, lockers: *mut m0_lockers, key: u32);
}
extern "C" {
    pub fn m0_lockers_is_empty(
        lt: *const m0_lockers_type,
        lockers: *const m0_lockers,
        key: u32,
    ) -> bool;
}
pub const M0_LOCALITY_LOCKERS_NR: ::std::os::raw::c_uint = 256;
pub type _bindgen_ty_38 = ::std::os::raw::c_uint;
pub const M0_LOCKERS_m0_locality_max: ::std::os::raw::c_uint = 256;
pub type _bindgen_ty_39 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct m0_locality_lockers {
    pub __base: m0_lockers,
    pub __slots: [*mut ::std::os::raw::c_void; 256usize],
}
#[test]
fn bindgen_test_layout_m0_locality_lockers() {
    assert_eq!(
        ::std::mem::size_of::<m0_locality_lockers>(),
        2048usize,
        concat!("Size of: ", stringify!(m0_locality_lockers))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_locality_lockers>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_locality_lockers))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_lockers>())).__base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_lockers),
            "::",
            stringify!(__base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_lockers>())).__slots as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_lockers),
            "::",
            stringify!(__slots)
        )
    );
}
extern "C" {
    pub fn m0_locality_lockers_init(par: *mut m0_locality);
}
extern "C" {
    pub fn m0_locality_lockers_fini(par: *mut m0_locality);
}
extern "C" {
    pub fn m0_locality_lockers_allot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_locality_lockers_free(key: ::std::os::raw::c_int);
}
extern "C" {
    pub fn m0_locality_lockers_set(
        par: *mut m0_locality,
        key: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn m0_locality_lockers_get(
        par: *const m0_locality,
        key: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn m0_locality_lockers_clear(par: *mut m0_locality, key: ::std::os::raw::c_int);
}
extern "C" {
    pub fn m0_locality_lockers_is_empty(
        par: *const m0_locality,
        key: ::std::os::raw::c_int,
    ) -> bool;
}
#[doc = " Per-core state maintained by Motr."]
#[repr(C)]
#[derive(Debug)]
pub struct m0_locality {
    #[doc = " State machine group associated with the core."]
    #[doc = ""]
    #[doc = " This group can be used to post ASTs to be executed on a current or"]
    #[doc = " specified core."]
    #[doc = ""]
    #[doc = " This group comes from request handler locality, so that execution of"]
    #[doc = " ASTs is serialised with state transitions of foms in this locality."]
    pub lo_grp: *mut m0_sm_group,
    pub lo_idx: size_t,
    pub lo_dom: *mut m0_fom_domain,
    #[doc = " Lockers to store locality-specific private data"]
    pub lo_lockers: m0_locality_lockers,
    pub lo_chores: m0_tl,
}
#[test]
fn bindgen_test_layout_m0_locality() {
    assert_eq!(
        ::std::mem::size_of::<m0_locality>(),
        2096usize,
        concat!("Size of: ", stringify!(m0_locality))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_locality>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_locality))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality>())).lo_grp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality),
            "::",
            stringify!(lo_grp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality>())).lo_idx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality),
            "::",
            stringify!(lo_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality>())).lo_dom as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality),
            "::",
            stringify!(lo_dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality>())).lo_lockers as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality),
            "::",
            stringify!(lo_lockers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality>())).lo_chores as *const _ as usize },
        2072usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality),
            "::",
            stringify!(lo_chores)
        )
    );
}
extern "C" {
    pub fn m0_locality_init(
        loc: *mut m0_locality,
        grp: *mut m0_sm_group,
        dom: *mut m0_fom_domain,
        idx: size_t,
    );
}
extern "C" {
    pub fn m0_locality_fini(loc: *mut m0_locality);
}
extern "C" {
    #[doc = " Returns locality corresponding to the core the call is made on."]
    #[doc = ""]
    #[doc = " @post result->lo_grp != NULL"]
    pub fn m0_locality_here() -> *mut m0_locality;
}
extern "C" {
    #[doc = " Returns locality corresponding in some unspecified, but deterministic way to"]
    #[doc = " the supplied value."]
    #[doc = ""]
    #[doc = " @post result->lo_grp != NULL"]
    pub fn m0_locality_get(value: u64) -> *mut m0_locality;
}
extern "C" {
    pub fn m0_locality0_get() -> *mut m0_locality;
}
extern "C" {
    #[doc = " Starts using localities from the specified domain."]
    pub fn m0_locality_dom_set(dom: *mut m0_fom_domain);
}
extern "C" {
    #[doc = " Stops using the domain, falls back to a single locality."]
    pub fn m0_locality_dom_unset(dom: *mut m0_fom_domain);
}
extern "C" {
    pub fn m0_localities_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_localities_fini();
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_locality_chore {
    pub lc_ops: *const m0_locality_chore_ops,
    pub lc_datum: *mut ::std::os::raw::c_void,
    pub lc_interval: m0_time_t,
    pub lc_lock: m0_mutex,
    pub lc_signal: m0_chan,
    pub lc_active: ::std::os::raw::c_int,
    pub lc_linkage: m0_tlink,
    pub lc_ast: m0_sm_ast,
    pub lc_datasize: size_t,
    pub lc_rc: ::std::os::raw::c_int,
    pub lc_magix: u64,
}
#[test]
fn bindgen_test_layout_m0_locality_chore() {
    assert_eq!(
        ::std::mem::size_of::<m0_locality_chore>(),
        208usize,
        concat!("Size of: ", stringify!(m0_locality_chore))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_locality_chore>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_locality_chore))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_ops as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_datum as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_datum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_interval as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_interval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_lock as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_signal as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_active as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_active)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_linkage as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_ast as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_ast)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_datasize as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_datasize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_rc as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_rc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore>())).lc_magix as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore),
            "::",
            stringify!(lc_magix)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_locality_chore_ops {
    pub co_name: *const ::std::os::raw::c_char,
    pub co_enter: ::std::option::Option<
        unsafe extern "C" fn(
            chore: *mut m0_locality_chore,
            loc: *mut m0_locality,
            place: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub co_leave: ::std::option::Option<
        unsafe extern "C" fn(
            chore: *mut m0_locality_chore,
            loc: *mut m0_locality,
            place: *mut ::std::os::raw::c_void,
        ),
    >,
    pub co_tick: ::std::option::Option<
        unsafe extern "C" fn(
            chore: *mut m0_locality_chore,
            loc: *mut m0_locality,
            place: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_m0_locality_chore_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_locality_chore_ops>(),
        32usize,
        concat!("Size of: ", stringify!(m0_locality_chore_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_locality_chore_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_locality_chore_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore_ops>())).co_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore_ops),
            "::",
            stringify!(co_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore_ops>())).co_enter as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore_ops),
            "::",
            stringify!(co_enter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore_ops>())).co_leave as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore_ops),
            "::",
            stringify!(co_leave)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_locality_chore_ops>())).co_tick as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_locality_chore_ops),
            "::",
            stringify!(co_tick)
        )
    );
}
extern "C" {
    pub fn m0_locality_chore_init(
        chore: *mut m0_locality_chore,
        ops: *const m0_locality_chore_ops,
        datum: *mut ::std::os::raw::c_void,
        interval: m0_time_t,
        datasize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_locality_chore_quit(chore: *mut m0_locality_chore);
}
extern "C" {
    pub fn m0_locality_chore_fini(chore: *mut m0_locality_chore);
}
extern "C" {
    pub fn m0_locality_chores_run(locality: *mut m0_locality);
}
extern "C" {
    pub fn m0_locality_data_alloc(
        nob: size_t,
        ctor: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        dtor: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_void,
            ),
        >,
        datum: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_locality_data_free(key: ::std::os::raw::c_int);
}
extern "C" {
    pub fn m0_locality_data(key: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn m0_locality_data_iterate(
        key: ::std::os::raw::c_int,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                idx: ::std::os::raw::c_int,
                data: *mut ::std::os::raw::c_void,
                datum: *mut ::std::os::raw::c_void,
            ),
        >,
        datum: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn m0_locality_call(
        loc: *mut m0_locality,
        cb: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fom_dom() -> *mut m0_fom_domain;
}
extern "C" {
    #[doc = "Compares two 64bit numbers \"modulo overflow\"."]
    #[doc = ""]
    #[doc = "This function returns true iff x0 == x1 + delta, where delta is a positive"]
    #[doc = "signed 64bit number (alternatively speaking, delta is an unsigned 64bit"]
    #[doc = "number less than UINT64_MAX/2)."]
    #[doc = ""]
    #[doc = "This function is useful for comparing rolling counters (like epoch numbers,"]
    #[doc = "times, log sequence numbers, etc.) which can overflow, but only \"close"]
    #[doc = "enough\" values ever get compared."]
    #[doc = ""]
    #[doc = "As a safety measure, function checks that values are close enough."]
    #[doc = ""]
    #[doc = "@see m0_mod_ge()"]
    pub fn m0_mod_gt(x0: u64, x1: u64) -> bool;
}
extern "C" {
    #[doc = "Compares two 64bit numbers \"modulo overflow\"."]
    #[doc = ""]
    #[doc = "@see m0_mod_gt()"]
    pub fn m0_mod_ge(x0: u64, x1: u64) -> bool;
}
extern "C" {
    #[doc = "A very simple and fast re-entrant PRNG from Knuth."]
    #[doc = ""]
    #[doc = "Generates a pseudo-random number using \"seed\" and stores the number back in"]
    #[doc = "seed. Result is no greater than max."]
    #[doc = ""]
    #[doc = "@post result < max"]
    pub fn m0_rnd(max: u64, seed: *mut u64) -> u64;
}
extern "C" {
    pub fn m0_rnd64(seed: *mut u64) -> u64;
}
extern "C" {
    #[doc = "Greatest common divisor."]
    pub fn m0_gcd64(p: u64, q: u64) -> u64;
}
pub const m0_be_credit_users_M0_BE_CU_BTREE_INSERT: m0_be_credit_users = 0;
pub const m0_be_credit_users_M0_BE_CU_BTREE_DELETE: m0_be_credit_users = 1;
pub const m0_be_credit_users_M0_BE_CU_BTREE_UPDATE: m0_be_credit_users = 2;
pub const m0_be_credit_users_M0_BE_CU_EMAP_SPLIT: m0_be_credit_users = 3;
pub const m0_be_credit_users_M0_BE_CU_EMAP_PASTE: m0_be_credit_users = 4;
pub const m0_be_credit_users_M0_BE_CU_NR: m0_be_credit_users = 5;
pub type m0_be_credit_users = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_be_tx_credit {
    #[doc = " The number of regions needed for operation representation in the"]
    #[doc = " transaction."]
    pub tc_reg_nr: m0_bcount_t,
    #[doc = " Total size of memory needed for the same."]
    pub tc_reg_size: m0_bcount_t,
    #[doc = " Used to track who uses the credit and how much."]
    pub tc_balance: [::std::os::raw::c_uint; 5usize],
}
#[test]
fn bindgen_test_layout_m0_be_tx_credit() {
    assert_eq!(
        ::std::mem::size_of::<m0_be_tx_credit>(),
        40usize,
        concat!("Size of: ", stringify!(m0_be_tx_credit))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_be_tx_credit>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_be_tx_credit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_be_tx_credit>())).tc_reg_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_tx_credit),
            "::",
            stringify!(tc_reg_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_be_tx_credit>())).tc_reg_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_tx_credit),
            "::",
            stringify!(tc_reg_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_be_tx_credit>())).tc_balance as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_tx_credit),
            "::",
            stringify!(tc_balance)
        )
    );
}
extern "C" {
    pub static m0_be_tx_credit_invalid: m0_be_tx_credit;
}
extern "C" {
    #[doc = " c0 += c1"]
    pub fn m0_be_tx_credit_add(c0: *mut m0_be_tx_credit, c1: *const m0_be_tx_credit);
}
extern "C" {
    #[doc = " c0 -= c1"]
    pub fn m0_be_tx_credit_sub(c0: *mut m0_be_tx_credit, c1: *const m0_be_tx_credit);
}
extern "C" {
    #[doc = " c *= k"]
    pub fn m0_be_tx_credit_mul(c: *mut m0_be_tx_credit, k: m0_bcount_t);
}
extern "C" {
    #[doc = " c *= bp / 10000.0"]
    #[doc = " @note bp is basis point."]
    pub fn m0_be_tx_credit_mul_bp(c: *mut m0_be_tx_credit, bp: ::std::os::raw::c_uint);
}
extern "C" {
    #[doc = " c += c1 * k"]
    #[doc = " Multiply-accumulate operation."]
    pub fn m0_be_tx_credit_mac(c: *mut m0_be_tx_credit, c1: *const m0_be_tx_credit, k: m0_bcount_t);
}
extern "C" {
    #[doc = " c = smallest credit that meets the following requirement:"]
    #[doc = " m0_be_tx_credit_le(c0, c) && m0_be_tx_credit_le(c1, c)"]
    pub fn m0_be_tx_credit_max(
        c: *mut m0_be_tx_credit,
        c0: *const m0_be_tx_credit,
        c1: *const m0_be_tx_credit,
    );
}
extern "C" {
    pub fn m0_be_tx_credit_add_max(
        c: *mut m0_be_tx_credit,
        c0: *const m0_be_tx_credit,
        c1: *const m0_be_tx_credit,
    );
}
extern "C" {
    pub fn m0_be_tx_credit_le(c0: *const m0_be_tx_credit, c1: *const m0_be_tx_credit) -> bool;
}
extern "C" {
    pub fn m0_be_tx_credit_eq(c0: *const m0_be_tx_credit, c1: *const m0_be_tx_credit) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_epoch_id {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_update_id {
    pub ui_node: u32,
    pub ui_update: u64,
}
#[test]
fn bindgen_test_layout_m0_update_id() {
    assert_eq!(
        ::std::mem::size_of::<m0_update_id>(),
        16usize,
        concat!("Size of: ", stringify!(m0_update_id))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_update_id>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_update_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_update_id>())).ui_node as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_update_id),
            "::",
            stringify!(ui_node)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_update_id>())).ui_update as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_update_id),
            "::",
            stringify!(ui_update)
        )
    );
}
pub const m0_update_state_M0_US_INVALID: m0_update_state = 0;
pub const m0_update_state_M0_US_VOLATILE: m0_update_state = 1;
pub const m0_update_state_M0_US_PERSISTENT: m0_update_state = 2;
pub const m0_update_state_M0_US_NR: m0_update_state = 3;
pub type m0_update_state = ::std::os::raw::c_uint;
extern "C" {
    pub static mut m0_update_id_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_update_id_struct_init();
}
extern "C" {
    pub fn m0_xc_dtm_dtm_update_init();
}
extern "C" {
    pub fn m0_xc_dtm_dtm_update_fini();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fdmi_src {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fdmi_src_ctx {
    _unused: [u8; 0],
}
#[doc = " FDMI source record struct. Used to keep data, associated to FDMI src record."]
#[doc = ""]
#[doc = " Is also used to pass the record over between source and source dock.  On"]
#[doc = " this communication, a pointer to this struct is uniquely identifying the"]
#[doc = " record being processed."]
#[doc = ""]
#[doc = " FDMI source is responsible for allocating it, and filling in the following"]
#[doc = " fields:"]
#[doc = " - fsr_src"]
#[doc = " - fsr_data"]
#[doc = ""]
#[doc = " The rest of fields are populated by source dock.  The key ones are filled"]
#[doc = " in at post_record call, the rest -- during record processing.  FDMI source"]
#[doc = " dock will keeps here all the information on FDMI record that is being"]
#[doc = " processed (or being sent to plugin)."]
#[doc = ""]
#[doc = " FDMI source is also responsible for de-allocating the struct, but only"]
#[doc = " after source dock calls fs_put for the last time."]
#[doc = ""]
#[doc = " One recommended way of using this structure is to incorporate it into"]
#[doc = " whatever struct that keeps actual data/descriptor of the event/object which"]
#[doc = " has caused this FDMI record to come into existence.  Later on, whenever src"]
#[doc = " dock will require actions on the record, the source can easily obtain the"]
#[doc = " ptr to ambient structure and use it, no need for any look-ups."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fdmi_src_rec {
    pub fsr_magic: u64,
    #[doc = " Link to owner FDMI source."]
    pub fsr_src: *mut m0_fdmi_src,
    #[doc = " Source can save record-specifric data handle here."]
    pub fsr_data: *mut ::std::os::raw::c_void,
    #[doc = " FDMI record ID. Should be unique within FDMI source dock instance"]
    pub fsr_rec_id: m0_uint128,
    #[doc = " FDMI record internal reference counter, used by FDMI source dock."]
    #[doc = ""]
    #[doc = " Is only needed during sending of record to plugins.  Once all"]
    #[doc = " plugins confirmed they got the record, this ref is decremented down"]
    #[doc = " to zero and calls its callback (which in turn calls fs_end)."]
    pub fsr_ref: m0_ref,
    #[doc = " Matched filters list."]
    #[doc = ""]
    #[doc = " Links using fdmi_src_matched_filter_item.fsmfi_linkage"]
    pub fsr_filter_list: m0_tl,
    #[doc = " Service field for linked list"]
    pub fsr_linkage: m0_tlink,
    #[doc = " Source that posted this record"]
    pub fsr_src_ctx: *mut m0_fdmi_src_ctx,
    pub fsr_matched: bool,
    #[doc = " Used for UT. Meaning: set to true if this records should not be"]
    #[doc = " set to remote ep after matching."]
    pub fsr_dryrun: bool,
}
#[test]
fn bindgen_test_layout_m0_fdmi_src_rec() {
    assert_eq!(
        ::std::mem::size_of::<m0_fdmi_src_rec>(),
        112usize,
        concat!("Size of: ", stringify!(m0_fdmi_src_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fdmi_src_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fdmi_src_rec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_src as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_src)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_rec_id as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_rec_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_ref as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_ref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_filter_list as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_filter_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_linkage as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_src_ctx as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_src_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_matched as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_matched)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fdmi_src_rec>())).fsr_dryrun as *const _ as usize },
        105usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fdmi_src_rec),
            "::",
            stringify!(fsr_dryrun)
        )
    );
}
extern "C" {
    #[doc = " Validates that the record is valid.  Should be used in M0_ASSERT in every"]
    #[doc = " function that receives src_rec as input parameter."]
    pub fn m0_fdmi__record_is_valid(src_rec: *mut m0_fdmi_src_rec) -> bool;
}
pub const FOL_REC_MAXSIZE: ::std::os::raw::c_uint = 131072;
pub type _bindgen_ty_40 = ::std::os::raw::c_uint;
#[doc = "@defgroup fol File operations log"]
#[doc = ""]
#[doc = "File operations log (fol) is a per-node collection of records, describing"]
#[doc = "updates to file system state carried out on the node. See HLD for the"]
#[doc = "description of requirements, usage patterns and constraints on fol,"]
#[doc = "as well as important terminology (update, operation, etc.):"]
#[doc = ""]
#[doc = "For documentation links, please refer to this file :"]
#[doc = "doc/motr-design-doc-list.rst"]
#[doc = ""]
#[doc = "A fol is represented by an instance of struct m0_fol. A fol record"]
#[doc = "is represented by the m0_fol_rec data type."]
#[doc = ""]
#[doc = "A fol record contains the list of fol record fragments, belonging"]
#[doc = "to fol record fragment types, added during updates. These fol"]
#[doc = "record fragments provide flexibility for modules to participate"]
#[doc = "in a transaction without global knowledge."]
#[doc = ""]
#[doc = "@see m0_fol_frag : FOL record fragment."]
#[doc = "@see m0_fol_frag_type : FOL record fragment type."]
#[doc = ""]
#[doc = "m0_fol_frag_ops structure contains operations for undo and redo of"]
#[doc = "FOL record fragments."]
#[doc = ""]
#[doc = "@see m0_fol_frag_init() : Initializes m0_fol_frag with"]
#[doc = "m0_fol_frag_type_ops."]
#[doc = "@see m0_fol_frag_fini() : Finalizes FOL record fragment."]
#[doc = ""]
#[doc = "@see m0_fol_frag_type_register() : Registers FOL record fragment type."]
#[doc = "@see m0_fol_frag_type_deregister() : Deregisters FOL record fragment"]
#[doc = "type."]
#[doc = ""]
#[doc = "FOL record fragments list is kept in m0_fol_rec::fr_frags which is"]
#[doc = "initialized in m0_fol_rec_init()."]
#[doc = ""]
#[doc = "m0_fol_rec_encode() is used to compose FOL record from FOL record descriptor"]
#[doc = "and fragments. It encodes the FOL record fragments in the list"]
#[doc = "m0_fol_rec:fr_frags in a buffer, which then will be added into the BE log."]
#[doc = ""]
#[doc = "@see m0_fol_rec_encode()"]
#[doc = "@see m0_fol_rec_decode()"]
#[doc = ""]
#[doc = "m0_fol_frag_type_init() and m0_fol_frag_type_fini() are added"]
#[doc = "to initialize and finalize FOL fragment types."]
#[doc = "FOL record fragment types are registered in a global array of FOL record"]
#[doc = "fragments using m0_fol_frag_type::rpt_index."]
#[doc = ""]
#[doc = "After successful execution of updates on server side, in FOM"]
#[doc = "generic phase using m0_fom_fol_rec_encode() FOL record fragments"]
#[doc = "in the list are combined in a FOL record and is made persistent."]
#[doc = "Before this phase all FOL record fragments need to be added in"]
#[doc = "the list after completing their updates."]
#[doc = ""]
#[doc = "After retrieving FOL record from the storage, FOL record fragments"]
#[doc = "are decoded based on fragment type using index and are used in"]
#[doc = "undo or redo operations."]
#[doc = ""]
#[doc = "@{"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_fol {
    #[doc = " Lock, serializing fol access."]
    pub f_lock: m0_mutex,
}
#[test]
fn bindgen_test_layout_m0_fol() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol>(),
        56usize,
        concat!("Size of: ", stringify!(m0_fol))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol>())).f_lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol),
            "::",
            stringify!(f_lock)
        )
    );
}
extern "C" {
    #[doc = "Initialise in-memory fol structure."]
    pub fn m0_fol_init(fol: *mut m0_fol);
}
extern "C" {
    pub fn m0_fol_fini(fol: *mut m0_fol);
}
#[doc = "Fixed part of a fol record."]
#[doc = ""]
#[doc = "@see m0_fol_rec"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_rec_header {
    #[doc = " Number of record fragments added to the record."]
    pub rh_frags_nr: u32,
    #[doc = " Length of the remaining operation type specific data in bytes."]
    #[doc = ""]
    #[doc = " @note XXX Currently this is the length of encoded record."]
    pub rh_data_len: u32,
    #[doc = " Identifier of this update."]
    #[doc = ""]
    #[doc = " @note The update might be for a different node."]
    pub rh_self: m0_update_id,
    pub rh_magic: u64,
}
#[test]
fn bindgen_test_layout_m0_fol_rec_header() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_rec_header>(),
        32usize,
        concat!("Size of: ", stringify!(m0_fol_rec_header))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_rec_header>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_rec_header))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec_header>())).rh_frags_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec_header),
            "::",
            stringify!(rh_frags_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec_header>())).rh_data_len as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec_header),
            "::",
            stringify!(rh_data_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec_header>())).rh_self as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec_header),
            "::",
            stringify!(rh_self)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec_header>())).rh_magic as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec_header),
            "::",
            stringify!(rh_magic)
        )
    );
}
#[doc = "In-memory representation of a fol record."]
#[doc = ""]
#[doc = "m0_fol_rec is bound to a particular fol and remembers its"]
#[doc = "location in the log."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_rec {
    pub fr_fol: *mut m0_fol,
    pub fr_tid: u64,
    pub fr_header: m0_fol_rec_header,
    #[doc = " A DTM epoch this update is a part of."]
    pub fr_epoch: *mut m0_epoch_id,
    #[doc = " Identifiers of sibling updates."]
    pub fr_sibling: *mut m0_fol_update_ref,
    #[doc = "A list of all FOL record fragments in a record."]
    #[doc = "Fragments are linked through m0_fol_frag:rp_link to this list."]
    pub fr_frags: m0_tl,
    #[doc = " FDMI Source Record entry."]
    pub fr_fdmi_rec: m0_fdmi_src_rec,
}
#[test]
fn bindgen_test_layout_m0_fol_rec() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_rec>(),
        200usize,
        concat!("Size of: ", stringify!(m0_fol_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_rec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_fol as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_fol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_tid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_header as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_header)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_epoch as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_epoch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_sibling as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_sibling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_frags as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_frags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_rec>())).fr_fdmi_rec as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_rec),
            "::",
            stringify!(fr_fdmi_rec)
        )
    );
}
extern "C" {
    #[doc = "Initializes fol record fragments list."]
    #[doc = ""]
    #[doc = "The user must call m0_fol_rec_fini() when finished dealing with"]
    #[doc = "the record."]
    pub fn m0_fol_rec_init(rec: *mut m0_fol_rec, fol: *mut m0_fol);
}
extern "C" {
    #[doc = " Finalizes fol record fragments list."]
    pub fn m0_fol_rec_fini(rec: *mut m0_fol_rec);
}
extern "C" {
    #[doc = "Encodes the fol record @rec at the specified buffer @at."]
    #[doc = ""]
    #[doc = "@see m0_fol_rec_put()"]
    pub fn m0_fol_rec_encode(rec: *mut m0_fol_rec, at: *mut m0_buf) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Decodes a record into @rec from the specified buffer @at."]
    #[doc = ""]
    #[doc = "@at is m0_be_tx::t_payload."]
    #[doc = ""]
    #[doc = "@rec must be initialized with m0_fol_rec_init() beforehand."]
    #[doc = "The user must call m0_fol_rec_fini() when finished dealing with"]
    #[doc = "the record."]
    pub fn m0_fol_rec_decode(rec: *mut m0_fol_rec, at: *mut m0_buf) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fol_rec_to_str(
        rec: *mut m0_fol_rec,
        str_: *mut ::std::os::raw::c_char,
        str_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fol_rec_invariant(drec: *const m0_fol_rec) -> bool;
}
extern "C" {
    pub fn m0_fols_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fols_fini();
}
#[doc = " Represents a fragment of FOL record."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_frag {
    pub rp_ops: *const m0_fol_frag_ops,
    #[doc = "Pointer to the data where FOL record fragment is serialised or"]
    #[doc = "will be de-serialised."]
    pub rp_data: *mut ::std::os::raw::c_void,
    #[doc = " Linkage into a fol record fragments."]
    pub rp_link: m0_tlink,
    #[doc = " Magic for fol record fragments list."]
    pub rp_magic: u64,
    #[doc = " As rp_data points to the in-memory record fragment during encoding,"]
    #[doc = " rp_data is freed only when rp_flag is equals to M0_XCODE_DECODE."]
    pub rp_flag: m0_xcode_what,
}
#[test]
fn bindgen_test_layout_m0_fol_frag() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_frag>(),
        48usize,
        concat!("Size of: ", stringify!(m0_fol_frag))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_frag>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_frag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag>())).rp_ops as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag),
            "::",
            stringify!(rp_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag>())).rp_data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag),
            "::",
            stringify!(rp_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag>())).rp_link as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag),
            "::",
            stringify!(rp_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag>())).rp_magic as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag),
            "::",
            stringify!(rp_magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag>())).rp_flag as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag),
            "::",
            stringify!(rp_flag)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_frag_type {
    pub rpt_index: u32,
    pub rpt_name: *const ::std::os::raw::c_char,
    #[doc = "Xcode type representing the FOL record fragment."]
    #[doc = "Used to encode, decode or calculate the length of"]
    #[doc = "FOL record fragments using xcode operations."]
    pub rpt_xt: *const m0_xcode_type,
    pub rpt_ops: *const m0_fol_frag_type_ops,
}
#[test]
fn bindgen_test_layout_m0_fol_frag_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_frag_type>(),
        32usize,
        concat!("Size of: ", stringify!(m0_fol_frag_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_frag_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_frag_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_type>())).rpt_index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_type),
            "::",
            stringify!(rpt_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_type>())).rpt_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_type),
            "::",
            stringify!(rpt_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_type>())).rpt_xt as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_type),
            "::",
            stringify!(rpt_xt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_type>())).rpt_ops as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_type),
            "::",
            stringify!(rpt_ops)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_frag_type_ops {
    #[doc = "  Sets the record fragment operations vector."]
    pub rpto_rec_frag_init: ::std::option::Option<unsafe extern "C" fn(frag: *mut m0_fol_frag)>,
}
#[test]
fn bindgen_test_layout_m0_fol_frag_type_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_frag_type_ops>(),
        8usize,
        concat!("Size of: ", stringify!(m0_fol_frag_type_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_frag_type_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_frag_type_ops))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_fol_frag_type_ops>())).rpto_rec_frag_init as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_type_ops),
            "::",
            stringify!(rpto_rec_frag_init)
        )
    );
}
#[doc = "FOL record fragments are decoded from FOL record and then undo or"]
#[doc = "redo operations are performed on these fragments."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_frag_ops {
    pub rpo_type: *const m0_fol_frag_type,
    pub rpo_undo: ::std::option::Option<
        unsafe extern "C" fn(frag: *mut m0_fol_frag, tx: *mut m0_be_tx) -> ::std::os::raw::c_int,
    >,
    pub rpo_redo: ::std::option::Option<
        unsafe extern "C" fn(frag: *mut m0_fol_frag, tx: *mut m0_be_tx) -> ::std::os::raw::c_int,
    >,
    pub rpo_undo_credit: ::std::option::Option<
        unsafe extern "C" fn(frag: *const m0_fol_frag, accum: *mut m0_be_tx_credit),
    >,
    pub rpo_redo_credit: ::std::option::Option<
        unsafe extern "C" fn(frag: *const m0_fol_frag, accum: *mut m0_be_tx_credit),
    >,
}
#[test]
fn bindgen_test_layout_m0_fol_frag_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_frag_ops>(),
        40usize,
        concat!("Size of: ", stringify!(m0_fol_frag_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_frag_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_frag_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_ops>())).rpo_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_ops),
            "::",
            stringify!(rpo_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_ops>())).rpo_undo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_ops),
            "::",
            stringify!(rpo_undo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_ops>())).rpo_redo as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_ops),
            "::",
            stringify!(rpo_redo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_ops>())).rpo_undo_credit as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_ops),
            "::",
            stringify!(rpo_undo_credit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_ops>())).rpo_redo_credit as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_ops),
            "::",
            stringify!(rpo_redo_credit)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fol_frag_header {
    pub rph_index: u32,
    pub rph_magic: u64,
}
#[test]
fn bindgen_test_layout_m0_fol_frag_header() {
    assert_eq!(
        ::std::mem::size_of::<m0_fol_frag_header>(),
        16usize,
        concat!("Size of: ", stringify!(m0_fol_frag_header))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_fol_frag_header>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_fol_frag_header))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_header>())).rph_index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_header),
            "::",
            stringify!(rph_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_fol_frag_header>())).rph_magic as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_fol_frag_header),
            "::",
            stringify!(rph_magic)
        )
    );
}
extern "C" {
    #[doc = "During encoding of FOL record data points to the in-memory FOL record"]
    #[doc = "fragment object allocated by the calling function."]
    #[doc = "In case if decoding data should be NULL, as it is allocated by xcode."]
    #[doc = "@pre frag != NULL"]
    #[doc = "@pre type != NULL"]
    pub fn m0_fol_frag_init(
        frag: *mut m0_fol_frag,
        data: *mut ::std::os::raw::c_void,
        type_: *const m0_fol_frag_type,
    );
}
extern "C" {
    pub fn m0_fol_frag_fini(frag: *mut m0_fol_frag);
}
extern "C" {
    #[doc = " Register a new fol record fragment type."]
    pub fn m0_fol_frag_type_register(type_: *mut m0_fol_frag_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_fol_frag_type_deregister(type_: *mut m0_fol_frag_type);
}
extern "C" {
    pub static m0_rec_frag_tl: m0_tl_descr;
}
extern "C" {
    pub fn m0_rec_frag_tlist_init(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_rec_frag_tlist_fini(head: *mut m0_tl);
}
extern "C" {
    pub fn m0_rec_frag_tlink_init(amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_invariant(head: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_rec_frag_tlist_invariant_ext(
        head: *const m0_tl,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const m0_fol_frag,
                arg2: *mut ::std::os::raw::c_void,
            ) -> bool,
        >,
        arg1: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn m0_rec_frag_tlist_is_empty(list: *const m0_tl) -> bool;
}
extern "C" {
    pub fn m0_rec_frag_tlink_init_at(amb: *mut m0_fol_frag, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_rec_frag_tlink_init_at_tail(amb: *mut m0_fol_frag, head: *mut m0_tl);
}
extern "C" {
    pub fn m0_rec_frag_tlink_fini(amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlink_del_fini(amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlink_is_in(amb: *const m0_fol_frag) -> bool;
}
extern "C" {
    pub fn m0_rec_frag_tlist_contains(list: *const m0_tl, amb: *const m0_fol_frag) -> bool;
}
extern "C" {
    pub fn m0_rec_frag_tlist_length(list: *const m0_tl) -> size_t;
}
extern "C" {
    pub fn m0_rec_frag_tlist_add(list: *mut m0_tl, amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_add_tail(list: *mut m0_tl, amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_add_after(amb: *mut m0_fol_frag, next: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_add_before(amb: *mut m0_fol_frag, next: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_del(amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_remove(amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_move(list: *mut m0_tl, amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_move_tail(list: *mut m0_tl, amb: *mut m0_fol_frag);
}
extern "C" {
    pub fn m0_rec_frag_tlist_head(list: *const m0_tl) -> *mut m0_fol_frag;
}
extern "C" {
    pub fn m0_rec_frag_tlist_pop(list: *const m0_tl) -> *mut m0_fol_frag;
}
extern "C" {
    pub fn m0_rec_frag_tlist_tail(list: *const m0_tl) -> *mut m0_fol_frag;
}
extern "C" {
    pub fn m0_rec_frag_tlist_next(list: *const m0_tl, amb: *const m0_fol_frag) -> *mut m0_fol_frag;
}
extern "C" {
    pub fn m0_rec_frag_tlist_prev(list: *const m0_tl, amb: *const m0_fol_frag) -> *mut m0_fol_frag;
}
extern "C" {
    pub fn m0_fol_frag_add(rec: *mut m0_fol_rec, frag: *mut m0_fol_frag);
}
pub type m0_dtm_ver_t = u64;
pub const m0_dtm_state_M0_DOS_LIMBO: m0_dtm_state = 0;
pub const m0_dtm_state_M0_DOS_FUTURE: m0_dtm_state = 1;
pub const m0_dtm_state_M0_DOS_PREPARE: m0_dtm_state = 2;
pub const m0_dtm_state_M0_DOS_INPROGRESS: m0_dtm_state = 3;
pub const m0_dtm_state_M0_DOS_VOLATILE: m0_dtm_state = 4;
pub const m0_dtm_state_M0_DOS_PERSISTENT: m0_dtm_state = 5;
pub const m0_dtm_state_M0_DOS_STABLE: m0_dtm_state = 6;
pub const m0_dtm_state_M0_DOS_NR: m0_dtm_state = 7;
pub type m0_dtm_state = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_hi {
    pub hi_nu: *mut m0_dtm_nu,
    pub hi_flags: u64,
    pub hi_ver: m0_dtm_ver_t,
    pub hi_ops: *const m0_dtm_hi_ops,
    pub hi_ups: m0_tl,
}
#[test]
fn bindgen_test_layout_m0_dtm_hi() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_hi>(),
        56usize,
        concat!("Size of: ", stringify!(m0_dtm_hi))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_hi>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_hi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_hi>())).hi_nu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_hi),
            "::",
            stringify!(hi_nu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_hi>())).hi_flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_hi),
            "::",
            stringify!(hi_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_hi>())).hi_ver as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_hi),
            "::",
            stringify!(hi_ver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_hi>())).hi_ops as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_hi),
            "::",
            stringify!(hi_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_hi>())).hi_ups as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_hi),
            "::",
            stringify!(hi_ups)
        )
    );
}
extern "C" {
    pub fn m0_dtm_hi_invariant(hi: *const m0_dtm_hi) -> bool;
}
pub const m0_dtm_hi_flags_M0_DHF_SHARED: m0_dtm_hi_flags = 1;
pub const m0_dtm_hi_flags_M0_DHF_FULL: m0_dtm_hi_flags = 2;
pub const m0_dtm_hi_flags_M0_DHF_OWNED: m0_dtm_hi_flags = 4;
pub const m0_dtm_hi_flags_M0_DHF_BUSY: m0_dtm_hi_flags = 8;
pub const m0_dtm_hi_flags_M0_DHF_LAST: m0_dtm_hi_flags = 16;
pub type m0_dtm_hi_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_hi_ops {
    pub dho_release: ::std::option::Option<unsafe extern "C" fn(hi: *mut m0_dtm_hi)>,
}
#[test]
fn bindgen_test_layout_m0_dtm_hi_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_hi_ops>(),
        8usize,
        concat!("Size of: ", stringify!(m0_dtm_hi_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_hi_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_hi_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_hi_ops>())).dho_release as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_hi_ops),
            "::",
            stringify!(dho_release)
        )
    );
}
pub const m0_dtm_up_rule_M0_DUR_INC: m0_dtm_up_rule = 0;
pub const m0_dtm_up_rule_M0_DUR_SET: m0_dtm_up_rule = 1;
pub const m0_dtm_up_rule_M0_DUR_NOT: m0_dtm_up_rule = 2;
pub const m0_dtm_up_rule_M0_DUR_APP: m0_dtm_up_rule = 3;
pub const m0_dtm_up_rule_M0_DUR_NR: m0_dtm_up_rule = 4;
pub type m0_dtm_up_rule = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_up {
    pub up_magix: u64,
    pub up_state: m0_dtm_state,
    pub up_rule: m0_dtm_up_rule,
    pub up_ver: m0_dtm_ver_t,
    pub up_orig_ver: m0_dtm_ver_t,
    pub up_hi: *mut m0_dtm_hi,
    pub up_hi_linkage: m0_tlink,
    pub up_op: *mut m0_dtm_op,
    pub up_op_linkage: m0_tlink,
}
#[test]
fn bindgen_test_layout_m0_dtm_up() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_up>(),
        80usize,
        concat!("Size of: ", stringify!(m0_dtm_up))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_up>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_up))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_magix as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_magix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_rule as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_rule)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_ver as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_ver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_orig_ver as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_orig_ver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_hi as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_hi_linkage as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_hi_linkage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_op as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_up>())).up_op_linkage as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_up),
            "::",
            stringify!(up_op_linkage)
        )
    );
}
extern "C" {
    pub fn m0_dtm_up_invariant(up: *const m0_dtm_up) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_op {
    pub op_nu: *mut m0_dtm_nu,
    pub op_ups: m0_tl,
    pub op_ops: *const m0_dtm_op_ops,
}
#[test]
fn bindgen_test_layout_m0_dtm_op() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_op>(),
        40usize,
        concat!("Size of: ", stringify!(m0_dtm_op))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_op>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_op>())).op_nu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_op),
            "::",
            stringify!(op_nu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_op>())).op_ups as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_op),
            "::",
            stringify!(op_ups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_op>())).op_ops as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_op),
            "::",
            stringify!(op_ops)
        )
    );
}
extern "C" {
    pub fn m0_dtm_op_invariant(op: *const m0_dtm_op) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_op_ops {
    pub doo_ready: ::std::option::Option<unsafe extern "C" fn(op: *mut m0_dtm_op)>,
    pub doo_late: ::std::option::Option<unsafe extern "C" fn(op: *mut m0_dtm_op)>,
    pub doo_miser: ::std::option::Option<unsafe extern "C" fn(op: *mut m0_dtm_op)>,
}
#[test]
fn bindgen_test_layout_m0_dtm_op_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_op_ops>(),
        24usize,
        concat!("Size of: ", stringify!(m0_dtm_op_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_op_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_op_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_op_ops>())).doo_ready as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_op_ops),
            "::",
            stringify!(doo_ready)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_op_ops>())).doo_late as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_op_ops),
            "::",
            stringify!(doo_late)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_op_ops>())).doo_miser as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_op_ops),
            "::",
            stringify!(doo_miser)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m0_dtm_nu {
    pub nu_lock: m0_mutex,
}
#[test]
fn bindgen_test_layout_m0_dtm_nu() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_nu>(),
        56usize,
        concat!("Size of: ", stringify!(m0_dtm_nu))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_nu>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_nu))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_nu>())).nu_lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_nu),
            "::",
            stringify!(nu_lock)
        )
    );
}
extern "C" {
    pub fn m0_dtm_op_init(op: *mut m0_dtm_op, nu: *mut m0_dtm_nu);
}
extern "C" {
    pub fn m0_dtm_op_prepared(op: *const m0_dtm_op);
}
extern "C" {
    pub fn m0_dtm_op_done(op: *const m0_dtm_op);
}
extern "C" {
    pub fn m0_dtm_op_close(op: *const m0_dtm_op);
}
extern "C" {
    pub fn m0_dtm_op_del(op: *mut m0_dtm_op);
}
extern "C" {
    pub fn m0_dtm_op_fini(op: *mut m0_dtm_op);
}
extern "C" {
    pub fn m0_dtm_hi_init(hi: *mut m0_dtm_hi, nu: *mut m0_dtm_nu);
}
extern "C" {
    pub fn m0_dtm_hi_fini(hi: *mut m0_dtm_hi);
}
extern "C" {
    pub fn m0_dtm_up_init(
        up: *mut m0_dtm_up,
        hi: *mut m0_dtm_hi,
        op: *mut m0_dtm_op,
        rule: m0_dtm_up_rule,
        ver: m0_dtm_ver_t,
        orig_ver: m0_dtm_ver_t,
    );
}
extern "C" {
    pub fn m0_dtm_up_ver_set(up: *mut m0_dtm_up, ver: m0_dtm_ver_t, orig_ver: m0_dtm_ver_t);
}
extern "C" {
    pub fn m0_dtm_nu_init(nu: *mut m0_dtm_nu);
}
extern "C" {
    pub fn m0_dtm_nu_fini(nu: *mut m0_dtm_nu);
}
extern "C" {
    pub fn m0_dtm_up_prior(up: *mut m0_dtm_up) -> *mut m0_dtm_up;
}
extern "C" {
    pub fn m0_dtm_up_later(up: *mut m0_dtm_up) -> *mut m0_dtm_up;
}
extern "C" {
    pub fn m0_dtm_nuclei_init();
}
extern "C" {
    pub fn m0_dtm_nuclei_fini();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_fop {
    _unused: [u8; 0],
}
pub const m0_dtm_update_comm_state_M0_DUX_NEW: m0_dtm_update_comm_state = 0;
pub const m0_dtm_update_comm_state_M0_DUX_INFLIGHT: m0_dtm_update_comm_state = 1;
pub const m0_dtm_update_comm_state_M0_DUX_REPLIED: m0_dtm_update_comm_state = 2;
pub type m0_dtm_update_comm_state = ::std::os::raw::c_uint;
pub const m0_dtm_update_comm_flags_M0_DUCF_REPLIED_CALLED: m0_dtm_update_comm_flags = 1;
pub type m0_dtm_update_comm_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_update_comm {
    pub uc_state: m0_dtm_update_comm_state,
    pub uc_flags: u64,
    pub uc_instance: u64,
    pub uc_body: *mut m0_fop,
}
#[test]
fn bindgen_test_layout_m0_dtm_update_comm() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_update_comm>(),
        32usize,
        concat!("Size of: ", stringify!(m0_dtm_update_comm))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_update_comm>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_update_comm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_comm>())).uc_state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_comm),
            "::",
            stringify!(uc_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_comm>())).uc_flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_comm),
            "::",
            stringify!(uc_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_comm>())).uc_instance as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_comm),
            "::",
            stringify!(uc_instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_comm>())).uc_body as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_comm),
            "::",
            stringify!(uc_body)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_update {
    pub upd_up: m0_dtm_up,
    pub upd_label: u32,
    pub upd_ops: *const m0_dtm_update_ops,
    pub upd_comm: m0_dtm_update_comm,
}
#[test]
fn bindgen_test_layout_m0_dtm_update() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_update>(),
        128usize,
        concat!("Size of: ", stringify!(m0_dtm_update))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_update>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_update))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update>())).upd_up as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update),
            "::",
            stringify!(upd_up)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update>())).upd_label as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update),
            "::",
            stringify!(upd_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update>())).upd_ops as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update),
            "::",
            stringify!(upd_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update>())).upd_comm as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update),
            "::",
            stringify!(upd_comm)
        )
    );
}
extern "C" {
    pub fn m0_dtm_update_invariant(update: *const m0_dtm_update) -> bool;
}
pub const M0_DTM_USER_UPDATE_BASE: ::std::os::raw::c_uint = 1048576;
pub type _bindgen_ty_41 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_update_ops {
    pub updo_redo: ::std::option::Option<
        unsafe extern "C" fn(updt: *mut m0_dtm_update) -> ::std::os::raw::c_int,
    >,
    pub updo_undo: ::std::option::Option<
        unsafe extern "C" fn(updt: *mut m0_dtm_update) -> ::std::os::raw::c_int,
    >,
    pub updto_replied: ::std::option::Option<unsafe extern "C" fn(updt: *mut m0_dtm_update)>,
    pub updo_type: *const m0_dtm_update_type,
}
#[test]
fn bindgen_test_layout_m0_dtm_update_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_update_ops>(),
        32usize,
        concat!("Size of: ", stringify!(m0_dtm_update_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_update_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_update_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_ops>())).updo_redo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_ops),
            "::",
            stringify!(updo_redo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_ops>())).updo_undo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_ops),
            "::",
            stringify!(updo_undo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_ops>())).updto_replied as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_ops),
            "::",
            stringify!(updto_replied)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_ops>())).updo_type as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_ops),
            "::",
            stringify!(updo_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_update_type {
    pub updtt_id: u8,
    pub updtt_name: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_m0_dtm_update_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_update_type>(),
        16usize,
        concat!("Size of: ", stringify!(m0_dtm_update_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_update_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_update_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_type>())).updtt_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_type),
            "::",
            stringify!(updtt_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_type>())).updtt_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_type),
            "::",
            stringify!(updtt_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_update_data {
    pub da_ver: u64,
    pub da_orig_ver: u64,
    pub da_label: u32,
    pub da_rule: u8,
}
#[test]
fn bindgen_test_layout_m0_dtm_update_data() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_update_data>(),
        24usize,
        concat!("Size of: ", stringify!(m0_dtm_update_data))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_update_data>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_update_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_data>())).da_ver as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_data),
            "::",
            stringify!(da_ver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_data>())).da_orig_ver as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_data),
            "::",
            stringify!(da_orig_ver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_data>())).da_label as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_data),
            "::",
            stringify!(da_label)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_data>())).da_rule as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_data),
            "::",
            stringify!(da_rule)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_history_id {
    pub hid_id: m0_uint128,
    pub hid_sender: m0_cookie,
    pub hid_receiver: m0_cookie,
    pub hid_htype: u8,
}
#[test]
fn bindgen_test_layout_m0_dtm_history_id() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_history_id>(),
        56usize,
        concat!("Size of: ", stringify!(m0_dtm_history_id))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_history_id>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_history_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_id>())).hid_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_id),
            "::",
            stringify!(hid_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_id>())).hid_sender as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_id),
            "::",
            stringify!(hid_sender)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_id>())).hid_receiver as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_id),
            "::",
            stringify!(hid_receiver)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_id>())).hid_htype as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_id),
            "::",
            stringify!(hid_htype)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_update_descr {
    pub udd_data: m0_dtm_update_data,
    pub udd_id: m0_dtm_history_id,
    pub udd_utype: u8,
}
#[test]
fn bindgen_test_layout_m0_dtm_update_descr() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_update_descr>(),
        88usize,
        concat!("Size of: ", stringify!(m0_dtm_update_descr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_update_descr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_update_descr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_descr>())).udd_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_descr),
            "::",
            stringify!(udd_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_descr>())).udd_id as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_descr),
            "::",
            stringify!(udd_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_update_descr>())).udd_utype as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_update_descr),
            "::",
            stringify!(udd_utype)
        )
    );
}
extern "C" {
    pub fn m0_dtm_update_init(
        update: *mut m0_dtm_update,
        history: *mut m0_dtm_history,
        oper: *mut m0_dtm_oper,
        data: *const m0_dtm_update_data,
    );
}
extern "C" {
    pub fn m0_dtm_update_is_user(update: *const m0_dtm_update) -> bool;
}
extern "C" {
    pub fn m0_dtm_update_pack(update: *const m0_dtm_update, updd: *mut m0_dtm_update_descr);
}
extern "C" {
    pub fn m0_dtm_update_unpack(update: *mut m0_dtm_update, updd: *const m0_dtm_update_descr);
}
extern "C" {
    pub fn m0_dtm_update_build(
        update: *mut m0_dtm_update,
        oper: *mut m0_dtm_oper,
        updd: *const m0_dtm_update_descr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_update_reint(update: *mut m0_dtm_update);
}
extern "C" {
    pub fn m0_dtm_comm_set(update: *mut m0_dtm_update, fop: *mut m0_fop);
}
extern "C" {
    pub fn m0_dtm_update_matches_descr(
        update: *const m0_dtm_update,
        updd: *const m0_dtm_update_descr,
    ) -> bool;
}
extern "C" {
    pub fn m0_dtm_descr_matches_update(
        update: *const m0_dtm_update,
        updd: *const m0_dtm_update_descr,
    ) -> bool;
}
extern "C" {
    pub fn m0_dtm_update_list_init(list: *mut m0_tl);
}
extern "C" {
    pub fn m0_dtm_update_list_fini(list: *mut m0_tl);
}
extern "C" {
    pub fn m0_dtm_update_link(list: *mut m0_tl, update: *mut m0_dtm_update, nr: u32);
}
extern "C" {
    pub static mut m0_dtm_update_descr_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_dtm_history_id_xc: *mut m0_xcode_type;
}
extern "C" {
    pub static mut m0_dtm_update_data_xc: *mut m0_xcode_type;
}
extern "C" {
    pub fn m0_xc_m0_dtm_update_descr_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_dtm_history_id_struct_init();
}
extern "C" {
    pub fn m0_xc_m0_dtm_update_data_struct_init();
}
extern "C" {
    pub fn m0_xc_dtm_update_init();
}
extern "C" {
    pub fn m0_xc_dtm_update_fini();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_remote {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_oper {
    pub oprt_op: m0_dtm_op,
    pub oprt_uu: m0_tl,
    pub oprt_flags: u64,
}
#[test]
fn bindgen_test_layout_m0_dtm_oper() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_oper>(),
        72usize,
        concat!("Size of: ", stringify!(m0_dtm_oper))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_oper>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_oper))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_oper>())).oprt_op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_oper),
            "::",
            stringify!(oprt_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_oper>())).oprt_uu as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_oper),
            "::",
            stringify!(oprt_uu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_oper>())).oprt_flags as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_oper),
            "::",
            stringify!(oprt_flags)
        )
    );
}
extern "C" {
    pub fn m0_dtm_oper_invariant(oper: *const m0_dtm_oper) -> bool;
}
pub const m0_dtm_oper_flags_M0_DOF_CLOSED: m0_dtm_oper_flags = 1;
pub const m0_dtm_oper_flags_M0_DOF_LAST: m0_dtm_oper_flags = 2;
pub const m0_dtm_oper_flags_M0_DOF_SENT: m0_dtm_oper_flags = 4;
pub type m0_dtm_oper_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_oper_updates {
    pub ou_nr: u32,
    pub ou_update: *mut m0_dtm_update_descr,
}
#[test]
fn bindgen_test_layout_m0_dtm_oper_updates() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_oper_updates>(),
        16usize,
        concat!("Size of: ", stringify!(m0_dtm_oper_updates))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_oper_updates>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_oper_updates))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_oper_updates>())).ou_nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_oper_updates),
            "::",
            stringify!(ou_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_oper_updates>())).ou_update as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_oper_updates),
            "::",
            stringify!(ou_update)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_oper_descr {
    pub od_updates: m0_dtm_oper_updates,
}
#[test]
fn bindgen_test_layout_m0_dtm_oper_descr() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_oper_descr>(),
        16usize,
        concat!("Size of: ", stringify!(m0_dtm_oper_descr))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_oper_descr>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_oper_descr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_oper_descr>())).od_updates as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_oper_descr),
            "::",
            stringify!(od_updates)
        )
    );
}
extern "C" {
    pub fn m0_dtm_oper_init(oper: *mut m0_dtm_oper, dtm: *mut m0_dtm, uu: *mut m0_tl);
}
extern "C" {
    pub fn m0_dtm_oper_fini(oper: *mut m0_dtm_oper);
}
extern "C" {
    pub fn m0_dtm_oper_close(oper: *mut m0_dtm_oper);
}
extern "C" {
    pub fn m0_dtm_oper_prepared(oper: *const m0_dtm_oper, rem: *const m0_dtm_remote);
}
extern "C" {
    pub fn m0_dtm_oper_done(oper: *const m0_dtm_oper, rem: *const m0_dtm_remote);
}
extern "C" {
    pub fn m0_dtm_oper_pack(
        oper: *mut m0_dtm_oper,
        rem: *const m0_dtm_remote,
        ode: *mut m0_dtm_oper_descr,
    );
}
extern "C" {
    pub fn m0_dtm_oper_unpack(oper: *mut m0_dtm_oper, ode: *const m0_dtm_oper_descr);
}
extern "C" {
    pub fn m0_dtm_oper_build(
        oper: *mut m0_dtm_oper,
        uu: *mut m0_tl,
        ode: *const m0_dtm_oper_descr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_reply_pack(
        oper: *const m0_dtm_oper,
        request: *const m0_dtm_oper_descr,
        reply: *mut m0_dtm_oper_descr,
    );
}
extern "C" {
    pub fn m0_dtm_reply_unpack(oper: *mut m0_dtm_oper, reply: *const m0_dtm_oper_descr);
}
extern "C" {
    pub fn m0_dtm_oper_get(oper: *const m0_dtm_oper, label: u32) -> *mut m0_dtm_update;
}
#[doc = " DTM history."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_history {
    pub h_hi: m0_dtm_hi,
    pub h_exclink: m0_tlink,
    pub h_catlink: m0_tlink,
    pub h_rem: *mut m0_dtm_remote,
    pub h_persistent: *mut m0_dtm_update,
    pub h_undo: *mut m0_dtm_update,
    pub h_reint: *mut m0_dtm_update,
    pub h_known: *mut m0_dtm_update,
    pub h_reset: *mut m0_dtm_update,
    pub h_ops: *const m0_dtm_history_ops,
    pub h_gen: u64,
    pub h_epoch: u64,
    pub h_remcookie: m0_cookie,
    pub h_max_ver: m0_dtm_ver_t,
}
#[test]
fn bindgen_test_layout_m0_dtm_history() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_history>(),
        184usize,
        concat!("Size of: ", stringify!(m0_dtm_history))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_history>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_history))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_hi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_exclink as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_exclink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_catlink as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_catlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_rem as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_rem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_persistent as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_persistent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_undo as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_undo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_reint as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_reint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_known as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_known)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_reset as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_reset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_ops as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_ops)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_gen as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_epoch as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_epoch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_remcookie as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_remcookie)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history>())).h_max_ver as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history),
            "::",
            stringify!(h_max_ver)
        )
    );
}
extern "C" {
    pub fn m0_dtm_history_invariant(history: *const m0_dtm_history) -> bool;
}
pub const m0_dtm_history_flags_M0_DHF_CLOSED: m0_dtm_history_flags = 16;
pub const m0_dtm_history_flags_M0_DHF_AMNESIA: m0_dtm_history_flags = 17;
pub type m0_dtm_history_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_history_ops {
    pub hio_type: *const m0_dtm_history_type,
    pub hio_id: ::std::option::Option<
        unsafe extern "C" fn(history: *const m0_dtm_history) -> *const m0_uint128,
    >,
    pub hio_persistent: ::std::option::Option<unsafe extern "C" fn(history: *mut m0_dtm_history)>,
    pub hio_fixed: ::std::option::Option<unsafe extern "C" fn(history: *mut m0_dtm_history)>,
    pub hio_update: ::std::option::Option<
        unsafe extern "C" fn(
            history: *mut m0_dtm_history,
            id: u8,
            update: *mut m0_dtm_update,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_m0_dtm_history_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_history_ops>(),
        40usize,
        concat!("Size of: ", stringify!(m0_dtm_history_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_history_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_history_ops))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_ops>())).hio_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_ops),
            "::",
            stringify!(hio_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_ops>())).hio_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_ops),
            "::",
            stringify!(hio_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dtm_history_ops>())).hio_persistent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_ops),
            "::",
            stringify!(hio_persistent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_ops>())).hio_fixed as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_ops),
            "::",
            stringify!(hio_fixed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_ops>())).hio_update as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_ops),
            "::",
            stringify!(hio_update)
        )
    );
}
#[doc = " @page dtm Distributed transaction manager"]
#[doc = ""]
#[doc = " @section Overview"]
#[doc = ""]
#[doc = " Distributed transaction manager (DTM) is a major Motr"]
#[doc = " component, responsible for dealing with certain types of transient failures."]
#[doc = ""]
#[doc = " Specifically, DTM maintains, as far as possible, consistency of system state"]
#[doc = " in the face of transient network failures (message reordering and"]
#[doc = " duplication) and transient node failures (node failure followed by restart)."]
#[doc = ""]
#[doc = " Consistency is maintained by grouping state updates, represented by fops"]
#[doc = " (@ref m0_fop), in collections called \"distributed transactions\". DTM"]
#[doc = " guarantees that transactions are atomic, in the sense that either all or none"]
#[doc = " of the fops are executed, even should a failure happen in the middle of"]
#[doc = " transaction execution."]
#[doc = ""]
#[doc = " Atomicity is achieved by redoing or undoing some fops after a failure. This"]
#[doc = " is done transparently by DTM, relieving its users from the burden of failure"]
#[doc = " handling."]
#[doc = ""]
#[doc = " Because different transactions can update the same entities, undo and redo of"]
#[doc = " one transaction might require undo or redo of other dependent"]
#[doc = " transactions. To fulfil this requirement, DTM tracks transaction"]
#[doc = " dependencies."]
#[doc = ""]
#[doc = " It might so happen, that too much state was lost in a failure and consistency"]
#[doc = " can not be restored. In this case, DTM determines the subset of system"]
#[doc = " history that is no longer consistent and notifies HA that affected nodes"]
#[doc = " should be anathematised."]
#[doc = ""]
#[doc = " @section hld High level design"]
#[doc = " HLD :"]
#[doc = " For documentation links, please refer to this file :"]
#[doc = " doc/motr-design-doc-list.rst"]
#[doc = ""]
#[doc = " @section Abstractions"]
#[doc = ""]
#[doc = " DTM introduces the following major abstractions:"]
#[doc = ""]
#[doc = "     - dtm instance (m0_dtm, dtm/dtm.c, dtm/dtm.h),"]
#[doc = "     - history (m0_dtm_history, dtm/history.c, dtm/history.h),"]
#[doc = "     - update (m0_dtm_update, dtm/update.c, dtm/update.h),"]
#[doc = "     - operation (m0_dtm_operation, dtm/operation.c, dtm/operation.h),"]
#[doc = "     - distributed transaction (m0_dtm_dtx, dtm/dtx.c, dtm/dtx.h),"]
#[doc = "     - domain (m0_dtm_domain, dtm/domain.c, dtm/domain.h)."]
#[doc = ""]
#[doc = " See the HLD for more details."]
#[doc = ""]
#[doc = " @section Nucleus"]
#[doc = ""]
#[doc = " Nucleus is a sub-module within DTM, which contains core versioning and"]
#[doc = " ordering logic for histories, operations and updates. Nucleus introduces its"]
#[doc = " own types:"]
#[doc = ""]
#[doc = "     - nucleus m0_dtm_nu,"]
#[doc = "     - nucleus operation m0_dtm_op,"]
#[doc = "     - nucleus history m0_dtm_hi and"]
#[doc = "     - nucleus update m0_dtm_up"]
#[doc = ""]
#[doc = " Nuclear types are embedded in the appropriate DTM types. The rest of DTM"]
#[doc = " hides nucleus types and functions from DTM users."]
#[doc = ""]
#[doc = " See dtm/nucleus.c, dtm/nucleus.h."]
#[doc = ""]
#[doc = " @section coding-conventions Coding conventions"]
#[doc = ""]
#[doc = " Throughout the code, names of nuclear types, functions and variables use 2"]
#[doc = " letter abbreviations: @t nu (nucleus), @t hi (history), @t op (operation),"]
#[doc = " @t up (update)."]
#[doc = ""]
#[doc = " In the rest of DTM, longer names \"history\", \"oper\" and \"update\" are"]
#[doc = " used. \"rem\" is used as an abbreviation for \"remote dtm instance\""]
#[doc = " (m0_dtm_remote)."]
#[doc = ""]
#[doc = " dtm_internal.h contains definitions and declarations that are used internally"]
#[doc = " by the DTM code."]
#[doc = ""]
#[doc = " @todo Internal declarations leak in the global name-space. This should be"]
#[doc = " fixed by making them static and including dtm .c files in a single dtm/dtm.c"]
#[doc = " file."]
#[doc = ""]
#[doc = " @section usage Outline of DTM usage patterns"]
#[doc = ""]
#[doc = " A typical interaction with DTM consists of the following steps:"]
#[doc = ""]
#[doc = "     - create a transaction (m0_dtm_dtx_init());"]
#[doc = ""]
#[doc = "     - create an operation (m0_dtm_oper_init());"]
#[doc = ""]
#[doc = "     - for each entity, modified by the operation, locate the history"]
#[doc = "       (m0_dtm_history), representing the entity;"]
#[doc = ""]
#[doc = "     - create an update and add it to the history and the operation"]
#[doc = "       (m0_dtm_update_init());"]
#[doc = ""]
#[doc = "     - when all updates are added to the operation, add the operation to the"]
#[doc = "       transaction (m0_dtm_dtx_add());"]
#[doc = ""]
#[doc = "     - create a fop, representing the update and associate it with the update;"]
#[doc = ""]
#[doc = "     - close the operation (m0_dtm_oper_close());"]
#[doc = ""]
#[doc = "     - repeat for other operations in the transaction;"]
#[doc = ""]
#[doc = "     - close the transaction (m0_dtm_dtx_close());"]
#[doc = ""]
#[doc = " @todo pack, unpack, fop."]
#[doc = ""]
#[doc = " @section TOO Theory of operation"]
#[doc = ""]
#[doc = " First, read the HLD."]
#[doc = ""]
#[doc = " A history (m0_dtm_history) is a piece of system state to which updates are"]
#[doc = " applied sequentially. Some histories correspond to user-visible entities,"]
#[doc = " such as files, keys in meta-data tables, pages with file data; other"]
#[doc = " histories correspond to internal DTM entities, used to express grouping and"]
#[doc = " ordering of state updates. Examples of such internal histories are: fol"]
#[doc = " (m0_dtm_fol), distributed transaction (m0_dtm_dtx), local transaction"]
#[doc = " (m0_dtm_ltx), epoch, domain (m0_dtm_domain)."]
#[doc = ""]
#[doc = " An update to a history is m0_dtm_update. The list of updates is hanging off"]
#[doc = " of a history (@ref m0_dtm_history::h_hi::hi_ups), the latest update at the"]
#[doc = " head. An update is linked in its history list through"]
#[doc = " m0_dtm_update::upd_up::up_hi_linkage."]
#[doc = ""]
#[doc = " Updates are grouped in operations (m0_dtm_oper). Updates of an operation hang"]
#[doc = " off of m0_dtm_oper::oprt_op::op_ups, linked through"]
#[doc = " m0_dtm_update::upd_up::up_op_linkage."]
#[doc = ""]
#[doc = " Thus, updates, histories and operations form a certain gridiron pattern:"]
#[doc = " @anchor gridiron"]
#[doc = " @verbatim"]
#[doc = ""]
#[doc = "        H0        H1        H2        H3        H4        H5        H6  NOW"]
#[doc = "        |         |         |         |         |         |         |    |"]
#[doc = "        |   O0----U---------U         |         |         |         |    |"]
#[doc = "        |         |         |         |         |         |         |    |"]
#[doc = "        |         |   O1----U---------U---------U---------U---------U    |"]
#[doc = "        |         |         |         |         |         |         |    |"]
#[doc = "        |         |         |         |   O2----U         |         |    |"]
#[doc = "        |         |         |         |         |         |         |    |"]
#[doc = "  O3----U---------U---------U---------U---------U---------U---------U    |"]
#[doc = "        |         |         |         |         |         |         |    |"]
#[doc = "  O4----U---------U         |   O5----U---------U---------U---------U    |"]
#[doc = "        |         |         |         |         |         |         |    |"]
#[doc = "        |   O6----U---------U---------U         |         |         |    V"]
#[doc = "        |         |         |         |         |         |         |   PAST"]
#[doc = ""]
#[doc = " @endverbatim"]
#[doc = ""]
#[doc = " Note that operation groups updates for logical purposes, it doesn't imply any"]
#[doc = " kind of atomicity (more on operations below)."]
#[doc = ""]
#[doc = " Each update has 2 version numbers: m0_dtm_update::upd_up::up_ver and"]
#[doc = " m0_dtm_update::upd_up::up_orig_ver."]
#[doc = ""]
#[doc = " Version number specifies a position in history. Version numbers are used to"]
#[doc = " order updates and to determine when an update is"]
#[doc = " applicable. m0_dtm_update::upd_up::up_orig_ver specifies the version the"]
#[doc = " history has before the update was applied and m0_dtm_update::upd_up::up_ver"]
#[doc = " specifies the version the history has after the update is applied. These 2"]
#[doc = " version numbers can coincide, when update doesn't change the entity,"]
#[doc = " represented by the history."]
#[doc = ""]
#[doc = " Version 0 is \"unknown version\", see below. Version 1 is the version of the"]
#[doc = " history before the first (earliest) update in the history has been executed."]
#[doc = ""]
#[doc = " The following 3 complementary sub-sections describe organization of DTM"]
#[doc = " structures from the point of view of update, history and operation"]
#[doc = " respectively."]
#[doc = ""]
#[doc = " @section Update"]
#[doc = ""]
#[doc = " Each update has a state: m0_dtm_update::upd_up::up_state."]
#[doc = ""]
#[doc = " When going through updates of a history pastward (that is, starting from the"]
#[doc = " head of the history update list, downward in the diagram above), version"]
#[doc = " numbers are non-increasing and states are non-decreasing."]
#[doc = ""]
#[doc = " Update state determines the execution status of the update. Update state"]
#[doc = " increases throughout update life. Hence, update states describe update's life"]
#[doc = " stages. Updates states are the following (m0_dtm_state):"]
#[doc = ""]
#[doc = "     - LIMBO: a new update is initialised by m0_dtm_update_init(). From the"]
#[doc = "       very beginning the update is associated with an operation and a"]
#[doc = "       history. m0_dtm_update_init() places the update on the operation's list"]
#[doc = "       updates, but not on the history's list of updates. The update starts in"]
#[doc = "       LIMBO state and remains in this stats until the operation, to which the"]
#[doc = "       update belongs is closed. In other words, LIMBO is the state of updates"]
#[doc = "       belonging to still not closed operations. LIMBO is the only state, in"]
#[doc = "       which the update is not on its history update list. When an operation"]
#[doc = "       is closed, m0_dtm_op_close() places all its updates on the"]
#[doc = "       corresponding history lists."]
#[doc = ""]
#[doc = "     - FUTURE: this is the state of updates from closed operations that are"]
#[doc = "\t not yet executed. Operation can be in FUTURE state for several reasons:"]
#[doc = "           - it is too early, and some previous operations, as determined by"]
#[doc = "             version numbers, are not yet added. This is possible when network"]
#[doc = "             reorders operations arriving to a server;"]
#[doc = "           - histories of some of operation's updates are busy (see PREPARE"]
#[doc = "             state below);"]
#[doc = ""]
#[doc = "     - PREPARE: when all updates of an operation are ready (versionwise) to be"]
#[doc = "       executed, they are moved from FUTURE to PREPARE state and"]
#[doc = "       m0_dtm_op_ops::doo_ready() call-back is called by the DTM. For a given"]
#[doc = "       history, at most one update of the history can be in PREPARE"]
#[doc = "       state. When an update is moved in PREPARE state, its history is marked"]
#[doc = "       busy (M0_DHF_BUSY) preventing other otherwise ready updates of this"]
#[doc = "       history to advance past FUTURE state. The purpose of PREPARE state is"]
#[doc = "       to allow DTM user to serialise operation execution as necessary, e.g.,"]
#[doc = "       take locks. When all the locks necessary for the operation execution"]
#[doc = "       are taken, the user calls m0_dtm_op_prepared(), which moves all"]
#[doc = "       operation updates in INPROGRESS state."]
#[doc = ""]
#[doc = "     - INPROGRESS: an update in INPROGRESS state is being executed. When an"]
#[doc = "       update transitions from PREPARED to INPROGRESS state, history's version"]
#[doc = "       (m0_dtm_hi::hi_ver) is set to update's version, implying that as far as"]
#[doc = "       DTM is concerned, the state of the entity represented by the history"]
#[doc = "       contains the update. Because update execution is never truly"]
#[doc = "       instantaneous, the actual entity state is changed gradually, while the"]
#[doc = "       update is in INPROGRESS state, but thanks to the locks taken by the"]
#[doc = "       user in PREPARE state, this doesn't matter."]
#[doc = ""]
#[doc = "     - VOLATILE: an update moves to VOLATILE state when its execution"]
#[doc = "       completes and modified entity state is present only in volatile store"]
#[doc = "       and can be lost in an allowed failure."]
#[doc = ""]
#[doc = "     - PERSISTENT: an update moves to PERSISTENT state, when modified entity"]
#[doc = "       state makes it to persistent store, which is guaranteed to survive any"]
#[doc = "       allowed failure."]
#[doc = ""]
#[doc = "     - STABLE: finally, an update moves to STABLE state, when DTM guarantees"]
#[doc = "       that it will survive any further allowed failure. STABLE state is"]
#[doc = "       different from PERSISTENT, because even if a particular update U is"]
#[doc = "       persistent, some earlier updates on which U depends can be not yet"]
#[doc = "       persistent. If such earlier updates are lost in a failure, DTM must"]
#[doc = "       undo U to preserve consistency."]
#[doc = ""]
#[doc = " @section History"]
#[doc = ""]
#[doc = " History represents evolution of a storage entity. Storage entity changes as"]
#[doc = " result of update executions. Version number unambiguously identifies a point"]
#[doc = " in the history."]
#[doc = ""]
#[doc = " History lists both already executed updates and still not executed"]
#[doc = " updates. m0_dtm_hi::hi_ver identifies the point in history corresponding to"]
#[doc = " the current state of the entity. All updates with version numbers less than"]
#[doc = " m0_dtm_hi::hi_ver have been executed and none of the updates with version"]
#[doc = " numbers greater than m0_dtm_hi::hi_ver executed. There can be multiple"]
#[doc = " updates with version numbers equal to m0_dtm_hi::hi_ver, all but one of them"]
#[doc = " must be read-only (because they do not change history version, see above), at"]
#[doc = " least one of such updates has been executed."]
#[doc = ""]
#[doc = " History is \"owned\" (M0_DHF_OWNED) when the local DTM instance has the right"]
#[doc = " to assign version numbers in the history. This is possible when, for example,"]
#[doc = " local Motr instance owns an exclusive lock on the entity represented by the"]
#[doc = " history."]
#[doc = ""]
#[doc = " Updates in a history are ordered in 3 ways:"]
#[doc = ""]
#[doc = "     - \"list\" ordering by their location in the history update list"]
#[doc = "       (m0_dtm_history::h_hi::hi_ups);"]
#[doc = ""]
#[doc = "     - \"state\" ordering by update state (m0_dtm_update::upd_up::up_state);"]
#[doc = ""]
#[doc = "     - \"version\" ordering by update version"]
#[doc = "       (m0_dtm_update::upd_up::up_ver). This ordering is partial, because some"]
#[doc = "       updates have \"unknown\" version (0)."]
#[doc = ""]
#[doc = " For updates in states VOLATILE and later, all 3 orderings coincide: for"]
#[doc = " updates X and Y, if X.state >= VOLATILE, then (X.state <= Y.state iff X.ver"]
#[doc = " <= Y.ver iff X is not later than Y in the update list). Moreover, such an"]
#[doc = " update has known (non 0) original version, which coincides with the version"]
#[doc = " of the update next in the list order."]
#[doc = ""]
#[doc = " Updates in FUTURE state are not ordered, they form a set from which updates"]
#[doc = " are selected for execution as described below."]
#[doc = ""]
#[doc = " Finally, updates in INPROGRESS state are only ordered by the list order,"]
#[doc = " which determines the order in which they left PREPARE state and in which they"]
#[doc = " enter VOLATILE state."]
#[doc = ""]
#[doc = " Generally, updates in a history undergo the following process:"]
#[doc = ""]
#[doc = "     - at certain conditions (described below), advance_hi() scans the set of"]
#[doc = "       FUTURE updates, looking for an update ready for execution;"]
#[doc = ""]
#[doc = "     - if such an update is found, the update is moved in PREPARE state, the"]
#[doc = "       history is marked busy and m0_dtm_op_ops::doo_ready() call-back is"]
#[doc = "       called. This call-back belong to the update operation. All updates of"]
#[doc = "       an operation move to PREPARE state together. For owned histories,"]
#[doc = "       update version and original version are assigned at this moment"]
#[doc = "       (up_ready()), if they were unknown;"]
#[doc = ""]
#[doc = "     - when PREPARE state is complete, user calls m0_dtm_oper_prepared()."]
#[doc = "       This moves all updates of the operation in INPROGRESS state. This"]
#[doc = "       signifies that update started execution;"]
#[doc = ""]
#[doc = "     - when update execution is complete, user calls m0_dtm_oper_done(), which"]
#[doc = "       moves operation updates to VOLATILE state;"]
#[doc = ""]
#[doc = "     - later, when an update reaches a persistent store,"]
#[doc = "       m0_dtm_history_persistent() is called, which moves the update from"]
#[doc = "       VOLATILE to PERSISTENT state;"]
#[doc = ""]
#[doc = "     - finally, the update is moved to STABLE state."]
#[doc = ""]
#[doc = " hi_advance() is called in the following cases:"]
#[doc = ""]
#[doc = "     - an operation closes (m0_dtm_op_close()), operation updates are moved to"]
#[doc = "       FUTURE state and added to their histories and"]
#[doc = ""]
#[doc = "     - m0_dtm_op_prepared() un-busies histories."]
#[doc = ""]
#[doc = " Note that while update states are monotonically increasing, while the history"]
#[doc = " update list is traversed, some state-changing events can happen out of"]
#[doc = " order. Specifically, m0_dtm_oper_done() can be called, when some earlier (in"]
#[doc = " the list order) update is still INPROGRESS. In such cases update state"]
#[doc = " transition is postponed to preserve monotonicity."]
#[doc = ""]
#[doc = " @section Operation"]
#[doc = ""]
#[doc = " An operation is a group of updates that change state (mostly) together."]
#[doc = ""]
#[doc = " It's important to understand that operations are not (directly) related to"]
#[doc = " transactions, they are orthogonal. In fact, in the @ref gridiron diagram"]
#[doc = " above, operations (going horizontally) are literally *orthogonal* to"]
#[doc = " transactions, because the latter are implemented as (vertical) histories."]
#[doc = ""]
#[doc = " An operation is initially open. Updates can be added to an open"]
#[doc = " operation. Such updates are in LIMBO state and are not attached to history"]
#[doc = " update lists. When the operation is closed by m0_dtm_oper_close(), all its"]
#[doc = " updates are moved to the FUTURE state. No further updates can be added to a"]
#[doc = " closed operation."]
#[doc = ""]
#[doc = " By the time m0_dtm_oper_close() returns, operation updates might advance past"]
#[doc = " FUTURE state: if they are ready for the execution (see above), they will be"]
#[doc = " transferred to PREPARE state and might reach STABLE state by the time"]
#[doc = " operation is closed."]
#[doc = ""]
#[doc = " The main purpose of operations is to group together updates, that should be"]
#[doc = " simultaneously executed. Roughly speaking, an individual update can be"]
#[doc = " executed when its version allows so and an operation can be executed when all"]
#[doc = " its updates can be executed."]
#[doc = ""]
#[doc = " Executability of an individual update U is defined as following:"]
#[doc = ""]
#[doc = "     - U's version is compared (up_cmp()) with the current version of its"]
#[doc = "       history (m0_dtm_history::h_hi::hi_ver). This comparison can produce one"]
#[doc = "       of the following outcomes:"]
#[doc = ""]
#[doc = "     - U is EARLY: the update cannot be executed at the moment, because some"]
#[doc = "       intermediate updates are still missing;"]
#[doc = ""]
#[doc = "     - U is LATE: the update cannot be executed, because it has already been"]
#[doc = "       executed (update's version is less or equal to the history version);"]
#[doc = ""]
#[doc = "     - U is READY: the update can be executed."]
#[doc = ""]
#[doc = " Executability of an operation is checked by op_cmp() as following:"]
#[doc = ""]
#[doc = "     - if all operation updates are READY, then the operation is READY;"]
#[doc = ""]
#[doc = "     - if all operation updates are LATE, then the operation is LATE;"]
#[doc = ""]
#[doc = "     - if there are EARLY and no LATE updates, then the operation is EARLY;"]
#[doc = ""]
#[doc = "     - otherwise there are both EARLY and LATE updates and the operation is"]
#[doc = "       *misordered*, that is, cannot be consistently recorded in its"]
#[doc = "       constituent histories (op_cmp() returns MISER)."]
#[doc = ""]
#[doc = " Misordering means that DTM user violated serialisability conditions."]
#[doc = ""]
#[doc = " When advance_op() finds late or misordered operation, it signals the user and"]
#[doc = " deletes the operation from DTM (removing all its updates from their"]
#[doc = " histories), see advance_op()."]
#[doc = ""]
#[doc = " An operation typically contains updates from 2 classes:"]
#[doc = ""]
#[doc = "     - user updates, corresponding to storage objects that DTM end-user"]
#[doc = "       modifies (files, directories, etc.). User updates are explicitly added"]
#[doc = "       to the operation by the user (before the operation is closed);"]
#[doc = ""]
#[doc = "     - control updates, used internally by DTM to organize updates in larger"]
#[doc = "       logical ensembles."]
#[doc = ""]
#[doc = " For example, for each local transaction (m0_dtm_ltx) there is a corresponding"]
#[doc = " history (m0_dtm_ltx::lx_ch::ch_history). When an operation is executed in the"]
#[doc = " context of a local transaction, DTM internally adds a special \"noop\" update"]
#[doc = " (ch_noop_utype) to the operation. This noop update belongs to the local"]
#[doc = " transaction history. This way all operations executed in the context of the"]
#[doc = " local transaction are linked together and can be traced by following local"]
#[doc = " transaction history's list of updates. When a local transaction is closed, a"]
#[doc = " special \"close\" control update (ch_close_utype) is added to it."]
#[doc = ""]
#[doc = " Similarly, distributed transaction (m0_dtm_dtx), domain (m0_dtm_domain) and"]
#[doc = " fol (m0_dtm_fol) contain embedded histories."]
#[doc = ""]
#[doc = " An update has a label (m0_dtm_update::upd_label) unique within the update"]
#[doc = " operation. The label is used to identify the update and fetch it from the"]
#[doc = " operation after network transmission. User should assign unique labels to"]
#[doc = " user updates. User updates must have labels not less than"]
#[doc = " M0_DTM_USER_UPDATE_BASE. DTM automatically assigns unique labels to all"]
#[doc = " control updates (in m0_dtm_oper_close())."]
#[doc = ""]
#[doc = " @section client-use Client use cases for DTM"]
#[doc = ""]
#[doc = " There is a DTM instance on each client. For exmaple, in an m0t1fs client,"]
#[doc = " m0_dtm is embedded in the super-block."]
#[doc = ""]
#[doc = " When a client executes an application request that changes system state"]
#[doc = " (e.g., file write or directory creation, as opposed to read-only request like"]
#[doc = " file read or pathname lookup), it creates a distributed transaction for the"]
#[doc = " request (m0_dtm_dtx_init()). The client then creates one or more operations,"]
#[doc = " populates then with updates and adds operations to the transaction. Each"]
#[doc = " operation can include updates to multiple histories corresponding to storage"]
#[doc = " entities, potentially on different remote nodes. Internally, DTM adds control"]
#[doc = " histories and control updates to the operations."]
#[doc = ""]
#[doc = " Updates can belong to owned or not-owned histories:"]
#[doc = ""]
#[doc = "     - when a client has an exclusive lock on some storage entity, the entity"]
#[doc = "       history is owned by the client DTM instance. In this case, client DTM"]
#[doc = "       assigns version and original version to every update to the history;"]
#[doc = ""]
#[doc = "     - when a client has no lock on an entity, it still can execute an"]
#[doc = "       operation on this entity. In this case, entity's history is not owned"]
#[doc = "       by the client and client DTM uses \"unknown\" (0) version number for"]
#[doc = "       updates to the history. When remote DTM executes the update, it assigns"]
#[doc = "       the version number to the update (which it can do, because it owns the"]
#[doc = "       history) and returns it to the client;"]
#[doc = ""]
#[doc = "     - a control history on a client can be owned. Examples are:"]
#[doc = "         - application domain (m0_dtm_domain), exclusively owned by the"]
#[doc = "           client;"]
#[doc = "         - \"slot\" shared between a client and server;"]
#[doc = "         - distributed transaction initiated by the client."]
#[doc = "       In all these cases, the client assigns version numbers to the updates;"]
#[doc = ""]
#[doc = "     - a control history on a client can be non-owned. An example of this is"]
#[doc = "       the fol of a remote DTM instance. For an operation that has an update"]
#[doc = "       to be executed by a remote DTM instance, local client DTM adds (in"]
#[doc = "       m0_dtm_oper_close()) a no-op update to the remote DTM's fol"]
#[doc = "       (m0_dtm_fol_remote). This update has unknown version. When the"]
#[doc = "       operation is executed by the remote DTM, actual version number is"]
#[doc = "       assigned to this update and this version number is returned to the"]
#[doc = "       client."]
#[doc = ""]
#[doc = " After the user added all user updates to the operation, it adds the operation"]
#[doc = " to the distributed transaction and closes the operation."]
#[doc = ""]
#[doc = ""]
#[doc = ""]
#[doc = ""]
#[doc = ""]
#[doc = " @section Concurrency"]
#[doc = ""]
#[doc = " @section Ownership"]
#[doc = " @defgroup dtm"]
#[doc = ""]
#[doc = " @{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_history_type {
    pub hit_id: u8,
    pub hit_rem_id: u8,
    pub hit_name: *const ::std::os::raw::c_char,
    pub hit_ops: *const m0_dtm_history_type_ops,
}
#[test]
fn bindgen_test_layout_m0_dtm_history_type() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_history_type>(),
        24usize,
        concat!("Size of: ", stringify!(m0_dtm_history_type))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_history_type>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_history_type))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_type>())).hit_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_type),
            "::",
            stringify!(hit_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_type>())).hit_rem_id as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_type),
            "::",
            stringify!(hit_rem_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_type>())).hit_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_type),
            "::",
            stringify!(hit_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_history_type>())).hit_ops as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_type),
            "::",
            stringify!(hit_ops)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_history_type_ops {
    pub hito_find: ::std::option::Option<
        unsafe extern "C" fn(
            dtm: *mut m0_dtm,
            ht: *const m0_dtm_history_type,
            id: *const m0_uint128,
            out: *mut *mut m0_dtm_history,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_m0_dtm_history_type_ops() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_history_type_ops>(),
        8usize,
        concat!("Size of: ", stringify!(m0_dtm_history_type_ops))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_history_type_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_history_type_ops))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_dtm_history_type_ops>())).hito_find as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_history_type_ops),
            "::",
            stringify!(hito_find)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_controlh {
    pub ch_history: m0_dtm_history,
    pub ch_clop: m0_dtm_oper,
    pub ch_clup: m0_dtm_update,
    pub ch_clup_rem: m0_dtm_update,
}
#[test]
fn bindgen_test_layout_m0_dtm_controlh() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_controlh>(),
        512usize,
        concat!("Size of: ", stringify!(m0_dtm_controlh))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_controlh>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_controlh))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_controlh>())).ch_history as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_controlh),
            "::",
            stringify!(ch_history)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_controlh>())).ch_clop as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_controlh),
            "::",
            stringify!(ch_clop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_controlh>())).ch_clup as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_controlh),
            "::",
            stringify!(ch_clup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_controlh>())).ch_clup_rem as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_controlh),
            "::",
            stringify!(ch_clup_rem)
        )
    );
}
extern "C" {
    pub fn m0_dtm_history_init(history: *mut m0_dtm_history, dtm: *mut m0_dtm);
}
extern "C" {
    pub fn m0_dtm_history_fini(history: *mut m0_dtm_history);
}
extern "C" {
    pub fn m0_dtm_history_persistent(history: *mut m0_dtm_history, upto: m0_dtm_ver_t);
}
extern "C" {
    pub fn m0_dtm_history_reset(history: *mut m0_dtm_history, since: m0_dtm_ver_t);
}
extern "C" {
    pub fn m0_dtm_history_undo(history: *mut m0_dtm_history, upto: m0_dtm_ver_t);
}
extern "C" {
    pub fn m0_dtm_history_close(history: *mut m0_dtm_history);
}
extern "C" {
    pub fn m0_dtm_history_update_get(
        history: *const m0_dtm_history,
        rule: m0_dtm_up_rule,
        data: *mut m0_dtm_update_data,
    );
}
extern "C" {
    pub fn m0_dtm_history_type_register(dtm: *mut m0_dtm, ht: *const m0_dtm_history_type);
}
extern "C" {
    pub fn m0_dtm_history_type_deregister(dtm: *mut m0_dtm, ht: *const m0_dtm_history_type);
}
extern "C" {
    pub fn m0_dtm_history_type_find(dtm: *mut m0_dtm, id: u8) -> *const m0_dtm_history_type;
}
extern "C" {
    pub fn m0_dtm_history_pack(history: *const m0_dtm_history, id: *mut m0_dtm_history_id);
}
extern "C" {
    pub fn m0_dtm_history_unpack(
        dtm: *mut m0_dtm,
        id: *const m0_dtm_history_id,
        out: *mut *mut m0_dtm_history,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_history_add_nop(
        history: *mut m0_dtm_history,
        oper: *mut m0_dtm_oper,
        cupdate: *mut m0_dtm_update,
    );
}
extern "C" {
    pub fn m0_dtm_history_add_close(
        history: *mut m0_dtm_history,
        oper: *mut m0_dtm_oper,
        cupdate: *mut m0_dtm_update,
    );
}
extern "C" {
    pub fn m0_dtm_controlh_init(ch: *mut m0_dtm_controlh, dtm: *mut m0_dtm);
}
extern "C" {
    pub fn m0_dtm_controlh_fini(ch: *mut m0_dtm_controlh);
}
extern "C" {
    pub fn m0_dtm_controlh_add(ch: *mut m0_dtm_controlh, oper: *mut m0_dtm_oper);
}
extern "C" {
    pub fn m0_dtm_controlh_close(ch: *mut m0_dtm_controlh);
}
extern "C" {
    pub fn m0_dtm_controlh_update(
        history: *mut m0_dtm_history,
        id: u8,
        update: *mut m0_dtm_update,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_controlh_update_is_close(update: *const m0_dtm_update) -> bool;
}
extern "C" {
    pub fn m0_dtm_controlh_fuse_close(update: *mut m0_dtm_update);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_catalogue {
    pub ca_el: m0_tl,
}
#[test]
fn bindgen_test_layout_m0_dtm_catalogue() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_catalogue>(),
        24usize,
        concat!("Size of: ", stringify!(m0_dtm_catalogue))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_catalogue>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_catalogue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_catalogue>())).ca_el as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_catalogue),
            "::",
            stringify!(ca_el)
        )
    );
}
extern "C" {
    pub fn m0_dtm_catalogue_init(cat: *mut m0_dtm_catalogue);
}
extern "C" {
    pub fn m0_dtm_catalogue_fini(cat: *mut m0_dtm_catalogue);
}
extern "C" {
    pub fn m0_dtm_catalogue_create(cat: *mut m0_dtm_catalogue) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_catalogue_delete(cat: *mut m0_dtm_catalogue) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_catalogue_lookup(
        cat: *mut m0_dtm_catalogue,
        id: *const m0_uint128,
        out: *mut *mut m0_dtm_history,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_catalogue_add(
        cat: *mut m0_dtm_catalogue,
        history: *mut m0_dtm_history,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn m0_dtm_catalogue_del(
        cat: *mut m0_dtm_catalogue,
        history: *mut m0_dtm_history,
    ) -> ::std::os::raw::c_int;
}
pub type m0_dtm_catalogue_alloc_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut m0_dtm,
        arg2: *const m0_uint128,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut m0_dtm_history,
>;
extern "C" {
    pub fn m0_dtm_catalogue_find(
        cat: *mut m0_dtm_catalogue,
        dtm: *mut m0_dtm,
        id: *const m0_uint128,
        alloc: m0_dtm_catalogue_alloc_t,
        datum: *mut ::std::os::raw::c_void,
        out: *mut *mut m0_dtm_history,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_fol {
    pub fo_ch: m0_dtm_controlh,
}
#[test]
fn bindgen_test_layout_m0_dtm_fol() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_fol>(),
        512usize,
        concat!("Size of: ", stringify!(m0_dtm_fol))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_fol>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_fol))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_fol>())).fo_ch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_fol),
            "::",
            stringify!(fo_ch)
        )
    );
}
extern "C" {
    pub fn m0_dtm_fol_init(fol: *mut m0_dtm_fol, dtm: *mut m0_dtm);
}
extern "C" {
    pub fn m0_dtm_fol_fini(fol: *mut m0_dtm_fol);
}
extern "C" {
    pub fn m0_dtm_fol_add(fol: *mut m0_dtm_fol, oper: *mut m0_dtm_oper);
}
extern "C" {
    pub static m0_dtm_fol_htype: m0_dtm_history_type;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_dtm_fol_remote {
    pub rfo_ch: m0_dtm_controlh,
}
#[test]
fn bindgen_test_layout_m0_dtm_fol_remote() {
    assert_eq!(
        ::std::mem::size_of::<m0_dtm_fol_remote>(),
        512usize,
        concat!("Size of: ", stringify!(m0_dtm_fol_remote))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_dtm_fol_remote>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_dtm_fol_remote))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<m0_dtm_fol_remote>())).rfo_ch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_dtm_fol_remote),
            "::",
            stringify!(rfo_ch)
        )
    );
}
extern "C" {
    pub fn m0_dtm_fol_remote_init(
        frem: *mut m0_dtm_fol_remote,
        dtm: *mut m0_dtm,
        remote: *mut m0_dtm_remote,
    );
}
extern "C" {
    pub fn m0_dtm_fol_remote_fini(frem: *mut m0_dtm_fol_remote);
}
extern "C" {
    pub fn m0_dtm_fol_remote_add(frem: *mut m0_dtm_fol_remote, oper: *mut m0_dtm_oper);
}
extern "C" {
    pub static m0_dtm_fol_remote_htype: m0_dtm_history_type;
}
#[doc = " Allocated memory will be aligned using at least this shift."]
#[doc = " @see m0_be_alloc(), m0_be_allocator_credit()."]
pub const M0_BE_ALLOC_SHIFT_MIN: ::std::os::raw::c_uint = 3;
#[doc = " @defgroup be Meta-data back-end"]
#[doc = ""]
#[doc = ""]
#[doc = " @{"]
pub type _bindgen_ty_42 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_be_allocator_call_stat {
    pub bcs_nr: ::std::os::raw::c_ulong,
    pub bcs_size: m0_bcount_t,
}
#[test]
fn bindgen_test_layout_m0_be_allocator_call_stat() {
    assert_eq!(
        ::std::mem::size_of::<m0_be_allocator_call_stat>(),
        16usize,
        concat!("Size of: ", stringify!(m0_be_allocator_call_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_be_allocator_call_stat>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_be_allocator_call_stat))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_be_allocator_call_stat>())).bcs_nr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_allocator_call_stat),
            "::",
            stringify!(bcs_nr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_be_allocator_call_stat>())).bcs_size as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_allocator_call_stat),
            "::",
            stringify!(bcs_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_be_allocator_call_stats {
    pub bacs_alloc_success: m0_be_allocator_call_stat,
    pub bacs_alloc_failure: m0_be_allocator_call_stat,
    pub bacs_free: m0_be_allocator_call_stat,
}
#[test]
fn bindgen_test_layout_m0_be_allocator_call_stats() {
    assert_eq!(
        ::std::mem::size_of::<m0_be_allocator_call_stats>(),
        48usize,
        concat!("Size of: ", stringify!(m0_be_allocator_call_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<m0_be_allocator_call_stats>(),
        8usize,
        concat!("Alignment of ", stringify!(m0_be_allocator_call_stats))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_be_allocator_call_stats>())).bacs_alloc_success as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_allocator_call_stats),
            "::",
            stringify!(bacs_alloc_success)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_be_allocator_call_stats>())).bacs_alloc_failure as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_allocator_call_stats),
            "::",
            stringify!(bacs_alloc_failure)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<m0_be_allocator_call_stats>())).bacs_free as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(m0_be_allocator_call_stats),
            "::",
            stringify!(bacs_free)
        )
    );
}
pub const M0_BE_ALLOCATOR_STATS_BOUNDARY: ::std::os::raw::c_uint = 1024;
pub const M0_BE_ALLOCATOR_STATS_PRINT_INTERVAL: ::std::os::raw::c_uint = 100;
pub type _bindgen_ty_43 = ::std::os::raw::c_uint;
#[doc = " Repair zone is used by index repair to allocate space for spare"]
#[doc = " units."]
pub const m0_be_alloc_zone_type_M0_BAP_REPAIR: m0_be_alloc_zone_type = 0;
#[doc = " Normal zone contains the bulk of segment space."]
#[doc = " It is used for usual allocations."]
pub const m0_be_alloc_zone_type_M0_BAP_NORMAL: m0_be_alloc_zone_type = 1;
#[doc = " Normal zone contains the bulk of segment space."]
#[doc = " It is used for usual allocations."]
pub const m0_be_alloc_zone_type_M0_BAP_NR: m0_be_alloc_zone_type = 2;
#[doc = " Zones within BE segment allocator space."]
#[doc = ""]
#[doc = " Each zone occupies a fixed fraction of total segment space, which is"]
#[doc = " specified when the allocator is initialised. Space can be requested from"]
#[doc = " particular zones using zones bit mask."]
#[doc = ""]
#[doc = " Zones in enumeration are sorted by priority in ascending order. For example,"]
#[doc = " if zones M0_BAP_NORMAL and M0_BAP_REPAIR are specified in allocation"]
#[doc = " request, then space in M0_BAP_NORMAL will be allocated only if there is not"]
#[doc = " enough space in M0_BAP_REPAIR."]
#[doc = ""]
#[doc = " The memory is allocated exactly in one zone and can't be distributed among"]
#[doc = " several zones even if several zones are specified in an allocation request."]
#[doc = ""]
#[doc = " Zones don't have predefined memory boundaries and can be viewed as \"labels\""]
#[doc = " for allocated memory chunks. Particular memory chunk can reside in different"]
#[doc = " zones during system life cycle."]
pub type m0_be_alloc_zone_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m0_be_alloc_zone_stats {
    pub bzs_total: m0_bcount_t,
    pub bzs_used: m0_bcount_t,
    pub bzs_free: m0_bcount_t,
    pub b