/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.ui.callbacks;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.japi.JavaUserOption;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.rustkeylock.japi.stubs.JavaMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowMessageCb
extends NativeCallbackToRustChannelSupport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RklStage stage;

    public ShowMessageCb(RklStage rklStage) {
        this.stage = rklStage;
    }

    public void apply(List<JavaUserOption> options, String message, String severity) {
        String logMessage = String.format("Callback for showing message %s of severity %s and options %s", message, severity, options.stream().map(Object::toString).collect(Collectors.joining(", ")));
        this.logger.debug(logMessage);
        Platform.runLater(() -> {
            Alert.AlertType alertType = Alert.AlertType.NONE;
            if ("Info".equals(severity)) {
                alertType = Alert.AlertType.INFORMATION;
            } else if ("Warn".equals(severity)) {
                alertType = Alert.AlertType.WARNING;
            } else if ("Error".equals(severity)) {
                alertType = Alert.AlertType.ERROR;
            }
            List buttonTypesList = options.stream().map(suo -> new ButtonType(suo.label)).collect(Collectors.toList());
            ButtonType[] buttonTypes = new ButtonType[buttonTypesList.size()];
            for (int i = 0; i < buttonTypesList.size(); ++i) {
                buttonTypes[i] = (ButtonType)buttonTypesList.get(i);
            }
            Alert alert = new Alert(alertType, message, buttonTypes);
            alert.initOwner((Window)this.stage.getFxStage());
            alert.setTitle("rust-keylock");
            alert.setContentText(message);
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            Optional selectedButtonTypeOption = alert.showAndWait();
            Optional selectedJavaUserOption = selectedButtonTypeOption.flatMap(sbt -> options.stream().filter(suo -> suo.label.equals(sbt.getText())).findFirst());
            if (selectedJavaUserOption.isPresent()) {
                this.doCallback(GuiResponse.UserOptionSelected((JavaUserOption)selectedJavaUserOption.get()));
            } else {
                this.logger.error("Pressed a button that does not exist in the User Options offered (" + selectedButtonTypeOption.toString() + ")?! How did it get here?? Please consider opening a bug to the developers.");
                this.doCallback(GuiResponse.GoToMenu(JavaMenu.Main()));
            }
        });
    }
}

