/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.ui.callbacks;

import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.rustkeylock.controllers.ChangePasswordController;
import org.rustkeylock.controllers.EnterPasswordController;
import org.rustkeylock.controllers.ExitController;
import org.rustkeylock.controllers.ImportExportController;
import org.rustkeylock.controllers.MainMenuController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.ui.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowMenuCb
extends NativeCallbackToRustChannelSupport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RklStage stage;

    public ShowMenuCb(RklStage rklStage) {
        this.stage = rklStage;
    }

    public void apply(String menu) {
        this.logger.debug("Callback for showing menu " + menu);
        Platform.runLater(() -> {
            try {
                URL resurl;
                FXMLLoader loader = new FXMLLoader();
                switch (menu) {
                    case "PleaseWait": {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/please_wait.fxml");
                        break;
                    }
                    case "TryPass": {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/enter_password.fxml");
                        loader.setControllerFactory(clazz -> new EnterPasswordController(this.stage));
                        break;
                    }
                    case "ChangePass": {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/change_password.fxml");
                        loader.setControllerFactory(clazz -> new ChangePasswordController(this.stage));
                        break;
                    }
                    case "ExportEntries": {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/import_export.fxml");
                        loader.setControllerFactory(clazz -> new ImportExportController(true, this.stage.getFxStage()));
                        break;
                    }
                    case "ImportEntries": {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/import_export.fxml");
                        loader.setControllerFactory(clazz -> new ImportExportController(false, this.stage.getFxStage()));
                        break;
                    }
                    case "Exit": {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/exit.fxml");
                        loader.setControllerFactory(clazz -> new ExitController());
                        break;
                    }
                    case "Current": {
                        resurl = null;
                        break;
                    }
                    default: {
                        resurl = ((Object)((Object)this)).getClass().getResource("/fragments/menu_main.fxml");
                        loader.setControllerFactory(clazz -> new MainMenuController());
                    }
                }
                RklController controller = null;
                if (resurl != null) {
                    loader.setLocation(resurl);
                    Parent root = (Parent)loader.load();
                    controller = (RklController)loader.getController();
                    Scene scene = new Scene(root);
                    Utils.applyRklCss(scene);
                    this.stage.updateView(scene, controller);
                } else {
                    controller = this.stage.getCurrentlyActiveController().orElseThrow(() -> new RuntimeException("Saved state not found!"));
                }
                controller.setCallback(arg_0 -> ((ShowMenuCb)this).doCallback(arg_0));
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        });
    }
}

