/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.ui.callbacks;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.rustkeylock.controllers.ListEntriesController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.japi.JavaEntry;
import org.rustkeylock.ui.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowEntriesSetCb
extends NativeCallbackToRustChannelSupport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RklStage stage;

    public ShowEntriesSetCb(RklStage rklStage) {
        this.stage = rklStage;
    }

    public void apply(List<JavaEntry> entries, String filter) {
        this.logger.debug("Callback for showing " + entries.size() + " entries ");
        String processedFilter = filter.equals("null") ? "" : filter;
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                URL resurl = ((Object)((Object)this)).getClass().getResource("/fragments/list_entries.fxml");
                loader.setControllerFactory(clazz -> new ListEntriesController(entries, processedFilter));
                loader.setLocation(resurl);
                Parent root = (Parent)loader.load();
                RklController controller = (RklController)loader.getController();
                controller.setCallback(arg_0 -> ((ShowEntriesSetCb)this).doCallback(arg_0));
                Scene scene = new Scene(root);
                Utils.applyRklCss(scene);
                this.stage.updateView(scene, controller);
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        });
    }
}

