/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.ui.callbacks;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.rustkeylock.controllers.EditConfigurationController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.ui.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditConfigurationCb
extends NativeCallbackToRustChannelSupport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private RklStage stage;

    public EditConfigurationCb(RklStage rklStage) {
        this.stage = rklStage;
    }

    public void apply(List<String> strings) {
        this.logger.debug("Callback for editing configuration");
        Platform.runLater(() -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                URL resurl = ((Object)((Object)this)).getClass().getResource("/fragments/edit_configuration.fxml");
                loader.setControllerFactory(clazz -> new EditConfigurationController(strings, this.stage));
                loader.setLocation(resurl);
                Parent root = (Parent)loader.load();
                RklController controller = (RklController)loader.getController();
                controller.setCallback(arg_0 -> ((EditConfigurationCb)this).doCallback(arg_0));
                Scene scene = new Scene(root);
                Utils.applyRklCss(scene);
                this.stage.updateView(scene, controller);
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        });
    }
}

