/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.ui;

import java.net.URL;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.ui.UiStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiLauncher
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(UiLauncher.class);
    private static AtomicReference<Optional<RklStage>> stageOpt = new AtomicReference(Optional.empty());
    private UiStopper stopper = new UiStopper();

    public static void launch() {
        new Thread(() -> Application.launch((String[])new String[0])).start();
    }

    public void start(Stage fxStage) throws Exception {
        logger.info("Starting rust-keylock-ui");
        fxStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/rkl.png")));
        URL resurl = ((Object)((Object)this)).getClass().getResource("/fragments/logo.fxml");
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(resurl);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        fxStage.setScene(scene);
        fxStage.setTitle("rust-keylock");
        fxStage.show();
        stageOpt.getAndSet(Optional.of(new RklStage(fxStage, this.getHostServices())));
    }

    public static RklStage getStage() {
        if (stageOpt.get().isEmpty()) {
            try {
                logger.debug("Stage is not available yet. Waiting...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return UiLauncher.getStage();
        }
        return stageOpt.get().get();
    }

    public static UiStopper initOnCloseHandler() {
        UiStopper stopper = new UiStopper();
        UiLauncher.getStage().getFxStage().setOnCloseRequest((EventHandler)stopper);
        return stopper;
    }
}

