/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.fxcomponents;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.HostServices;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.rustkeylock.controllers.RklController;

public class RklStage {
    private final Stage fxStage;
    private final HostServices hostServices;
    private RklController currentlyActiveController;
    private AtomicBoolean loggedIn = new AtomicBoolean(false);

    public RklStage(Stage fxStage, HostServices hostServices) {
        this.fxStage = fxStage;
        this.hostServices = hostServices;
    }

    public Optional<RklController> getCurrentlyActiveController() {
        return Optional.ofNullable(this.currentlyActiveController);
    }

    public void updateView(Scene scene, RklController controller) {
        this.currentlyActiveController = controller;
        this.fxStage.setScene(scene);
    }

    public Stage getFxStage() {
        return this.fxStage;
    }

    public HostServices getHostServices() {
        return this.hostServices;
    }

    public void markLoggedIn() {
        this.loggedIn.getAndSet(true);
    }

    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }
}

