/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import org.rustkeylock.controllers.BaseController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.japi.JavaEntry;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.rustkeylock.japi.stubs.JavaMenu;
import org.rustkeylock.ui.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowEntryController
extends BaseController
implements RklController,
Initializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Consumer<Object> callback;
    @FXML
    private TextField titleTextField = new TextField();
    @FXML
    private StringProperty titleMessage = new SimpleStringProperty("");
    @FXML
    private TextField urlTextField = new TextField();
    @FXML
    private StringProperty urlMessage = new SimpleStringProperty("");
    @FXML
    private TextField usernameTextField = new TextField();
    @FXML
    private StringProperty usernameMessage = new SimpleStringProperty("");
    @FXML
    private TextField passwordTextField = new TextField();
    @FXML
    private StringProperty passwordMessage = new SimpleStringProperty("");
    @FXML
    private TextArea descriptionTextArea = new TextArea();
    @FXML
    private StringProperty descriptionMessage = new SimpleStringProperty("");
    @FXML
    private StringProperty leftButtonTooltip = new SimpleStringProperty("");
    @FXML
    private StringProperty rightButtonTooltip = new SimpleStringProperty("");
    @FXML
    private HBox righButtonsHBox = new HBox();
    @FXML
    private final StringProperty deleteButtonId = new SimpleStringProperty("deleteButton");
    @FXML
    private final StringProperty okButtonId = new SimpleStringProperty("okButton");
    @FXML
    private final StringProperty cautionButtonId = new SimpleStringProperty("cautionButton");
    @FXML
    private HBox leftButtonsHBox = new HBox();
    @FXML
    private final StringProperty editButtonId = new SimpleStringProperty("editButton");
    @FXML
    private final StringProperty cancelButtonId = new SimpleStringProperty("cancelButton");
    @FXML
    private HBox showHidePasswordHBox = new HBox();
    @FXML
    private final StringProperty showPasswordButtonId = new SimpleStringProperty("showPassword");
    @FXML
    private final StringProperty hidePasswordButtonId = new SimpleStringProperty("hidePassword");
    @FXML
    private final StringProperty generatePassphraseButtonId = new SimpleStringProperty("genPassphrase");
    @FXML
    private Button showPasswordButton;
    @FXML
    private Button hidePasswordButton;
    @FXML
    private Button generatePassphraseButton;
    private static final String DELETE_BUTTON_ID = "deleteButton";
    private static final String OK_BUTTON_ID = "okButton";
    private static final String CAUTION_BUTTON_ID = "cautionButton";
    private static final String EDIT_BUTTON_ID = "editButton";
    private static final String CANCEL_BUTTON_ID = "cancelButton";
    private static final String SHOW_PASSWORD_BUTTON_ID = "showPassword";
    private static final String HIDE_PASSWORD_BUTTON_ID = "hidePassword";
    private static final String GENERATE_PASSPHRASE_BUTTON_ID = "genPassphrase";
    private static final String MASK_UTF_CHAR = "\u2022";
    private static final String MASK_STRING = Stream.iterate(0, n -> n + 1).limit(9L).map(i -> "\u2022").collect(Collectors.joining(""));
    private final JavaEntry anEntry;
    private final Integer entryIndex;
    private final Boolean edit;
    private final Boolean delete;

    public ShowEntryController(JavaEntry anEntry, Integer entryIndex, Boolean edit, Boolean delete) {
        this.anEntry = anEntry;
        this.entryIndex = entryIndex;
        this.edit = edit;
        this.delete = delete;
    }

    @Override
    public void setCallback(Consumer<Object> consumer) {
        this.callback = consumer;
    }

    @Override
    Consumer<Object> getCallback() {
        return this.callback;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.titleTextField.setEditable(this.edit.booleanValue());
        this.titleTextField.setDisable(this.edit == false);
        this.titleTextField.setText(this.anEntry.getName());
        this.urlTextField.setEditable(this.edit.booleanValue());
        this.urlTextField.setDisable(this.edit == false);
        this.urlTextField.setText(this.anEntry.getUrl());
        this.usernameTextField.setEditable(this.edit.booleanValue());
        this.usernameTextField.setDisable(this.edit == false);
        this.usernameTextField.setText(this.anEntry.getUser());
        this.passwordTextField.setEditable(this.edit.booleanValue());
        this.passwordTextField.setDisable(this.edit == false);
        if (!this.anEntry.getPass().isEmpty() && !this.edit.booleanValue()) {
            this.passwordTextField.setText(MASK_STRING);
        } else {
            this.passwordTextField.setText(this.anEntry.getPass());
        }
        if (this.anEntry.getMeta().isLeakedpassword()) {
            this.passwordTextField.setStyle("-fx-background-color: #E69269;");
        }
        Utils.removeChildNodeById(this.showHidePasswordHBox, HIDE_PASSWORD_BUTTON_ID);
        Utils.removeChildNodeById(this.showHidePasswordHBox, GENERATE_PASSPHRASE_BUTTON_ID);
        this.descriptionTextArea.setEditable(this.edit.booleanValue());
        this.descriptionTextArea.setDisable(this.edit == false);
        this.descriptionTextArea.setText(this.anEntry.getDesc());
        if (!this.edit.booleanValue() && !this.delete.booleanValue()) {
            this.enableMenuButtons();
            Utils.removeChildNodeById(this.leftButtonsHBox, CANCEL_BUTTON_ID);
            this.setLeftButtonTooltip("Edit");
            this.setRightButtonTooltip("Delete");
            Utils.removeChildNodeById(this.righButtonsHBox, OK_BUTTON_ID);
            Utils.removeChildNodeById(this.righButtonsHBox, CAUTION_BUTTON_ID);
        } else if (this.edit.booleanValue() && !this.delete.booleanValue()) {
            this.showPasswordButton.setDisable(true);
            this.hidePasswordButton.setDisable(true);
            this.disableMenuButtons();
            Utils.removeChildNodeById(this.leftButtonsHBox, EDIT_BUTTON_ID);
            this.setLeftButtonTooltip("Cancel");
            this.setRightButtonTooltip("OK");
            Utils.removeChildNodeById(this.righButtonsHBox, DELETE_BUTTON_ID);
            Utils.removeChildNodeById(this.righButtonsHBox, CAUTION_BUTTON_ID);
            Utils.addNode(this.showHidePasswordHBox, (Node)this.generatePassphraseButton);
        } else if (!this.edit.booleanValue() && this.delete.booleanValue()) {
            this.disableMenuButtons();
            Utils.removeChildNodeById(this.leftButtonsHBox, EDIT_BUTTON_ID);
            this.setLeftButtonTooltip("Cancel");
            Utils.removeChildNodeById(this.righButtonsHBox, DELETE_BUTTON_ID);
            Utils.removeChildNodeById(this.righButtonsHBox, OK_BUTTON_ID);
            this.setRightButtonTooltip("Yes I am sure, delete it!");
        } else {
            this.enableMenuButtons();
            this.logger.error("Undefined state reached: edit = " + this.edit + ", delete = " + this.delete);
            Utils.removeChildNodeById(this.leftButtonsHBox, EDIT_BUTTON_ID);
            Utils.removeChildNodeById(this.leftButtonsHBox, CANCEL_BUTTON_ID);
            Utils.removeChildNodeById(this.righButtonsHBox, DELETE_BUTTON_ID);
            Utils.removeChildNodeById(this.righButtonsHBox, OK_BUTTON_ID);
            Utils.removeChildNodeById(this.righButtonsHBox, CAUTION_BUTTON_ID);
        }
    }

    @FXML
    private void toggleRevealPassword(ActionEvent event) {
        event.consume();
        if (this.passwordTextField.getText().startsWith(MASK_UTF_CHAR)) {
            this.passwordTextField.setText(this.anEntry.getPass());
            Utils.removeChildNodeById(this.showHidePasswordHBox, SHOW_PASSWORD_BUTTON_ID);
            Utils.addNode(this.showHidePasswordHBox, (Node)this.hidePasswordButton);
        } else {
            this.passwordTextField.setText(MASK_STRING);
            Utils.removeChildNodeById(this.showHidePasswordHBox, HIDE_PASSWORD_BUTTON_ID);
            Utils.addNode(this.showHidePasswordHBox, (Node)this.showPasswordButton);
        }
    }

    @FXML
    private void copyUsernameAction(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.Copy(this.anEntry.user));
    }

    @FXML
    private void copyUrlAction(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.Copy(this.anEntry.url));
    }

    @FXML
    private void copyPasswordAction(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.Copy(this.anEntry.pass));
    }

    @FXML
    private void leftButtonAction(ActionEvent event) {
        event.consume();
        if (!this.edit.booleanValue() && !this.delete.booleanValue()) {
            this.editEntryAction();
        } else {
            this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.EntriesList("")));
        }
    }

    @FXML
    private void rightButtonAction(ActionEvent event) {
        event.consume();
        if (!this.edit.booleanValue() && !this.delete.booleanValue()) {
            this.deleteButtonAction();
        } else if (this.edit.booleanValue() && !this.delete.booleanValue()) {
            this.entryOkAction();
        } else if (!this.edit.booleanValue() && this.delete.booleanValue()) {
            this.areYouSureAction();
        }
    }

    private void editEntryAction() {
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.EditEntry(this.entryIndex)));
    }

    private void deleteButtonAction() {
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.DeleteEntry(this.entryIndex)));
    }

    @FXML
    private void generatePassphraseAction(ActionEvent event) {
        event.consume();
        JavaEntry entry = new JavaEntry();
        entry.name = this.titleTextField.getText();
        entry.url = this.urlTextField.getText();
        entry.user = this.usernameTextField.getText();
        entry.pass = this.passwordTextField.getText();
        entry.desc = this.descriptionTextArea.getText();
        entry.meta = this.anEntry.getMeta();
        this.logger.info("Generating passphrase for " + entry.name);
        this.getCallback().accept(GuiResponse.GeneratePassphrase(entry, this.entryIndex));
    }

    private void entryOkAction() {
        Optional<JavaEntry> entryOpt = this.generateEntry();
        if (entryOpt.isPresent()) {
            this.logger.info("Saving entry " + entryOpt.get().name);
            if (this.entryIndex >= 0) {
                this.callback.accept(GuiResponse.ReplaceEntry(entryOpt.get(), this.entryIndex));
            } else {
                this.callback.accept(GuiResponse.AddEntry(entryOpt.get()));
            }
        }
    }

    private Optional<JavaEntry> generateEntry() {
        this.setTitleMessage("");
        this.setUsernameMessage("");
        this.setPasswordMessage("");
        JavaEntry entry = new JavaEntry();
        entry.name = this.titleTextField.getText();
        entry.url = this.urlTextField.getText();
        entry.user = this.usernameTextField.getText();
        entry.pass = this.passwordTextField.getText();
        entry.desc = this.descriptionTextArea.getText();
        entry.meta = this.anEntry.getMeta();
        boolean errorsExist = false;
        if (entry.name.isEmpty()) {
            this.setTitleMessage("Required Field");
            errorsExist = true;
        }
        if (entry.user.isEmpty()) {
            this.setUsernameMessage("Required Field");
            errorsExist = true;
        }
        if (entry.pass.isEmpty()) {
            this.setPasswordMessage("Required Field");
            errorsExist = true;
        }
        if (!entry.url.isBlank()) {
            try {
                new URL(entry.url);
            }
            catch (MalformedURLException error) {
                this.setUrlMessage("Wrong URL. Eg: https://my.com");
                errorsExist = true;
            }
        }
        if (!errorsExist) {
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    private void areYouSureAction() {
        this.callback.accept(GuiResponse.DeleteEntry(this.entryIndex));
    }

    public String getTitleMessage() {
        return (String)this.titleMessage.get();
    }

    public StringProperty titleMessageProperty() {
        return this.titleMessage;
    }

    public void setTitleMessage(String titleMessage) {
        this.titleMessage.set((Object)titleMessage);
    }

    public String getUrlMessage() {
        return (String)this.urlMessage.get();
    }

    public StringProperty urlMessageProperty() {
        return this.urlMessage;
    }

    public void setUrlMessage(String urlMessage) {
        this.urlMessage.set((Object)urlMessage);
    }

    public String getUsernameMessage() {
        return (String)this.usernameMessage.get();
    }

    public StringProperty usernameMessageProperty() {
        return this.usernameMessage;
    }

    public void setUsernameMessage(String usernameMessage) {
        this.usernameMessage.set((Object)usernameMessage);
    }

    public String getPasswordMessage() {
        return (String)this.passwordMessage.get();
    }

    public StringProperty passwordMessageProperty() {
        return this.passwordMessage;
    }

    public void setPasswordMessage(String passwordMessage) {
        this.passwordMessage.set((Object)passwordMessage);
    }

    public String getDescriptionMessage() {
        return (String)this.descriptionMessage.get();
    }

    public StringProperty descriptionMessageProperty() {
        return this.descriptionMessage;
    }

    public void setDescriptionMessage(String descriptionMessage) {
        this.descriptionMessage.set((Object)descriptionMessage);
    }

    public TextField getTitleTextField() {
        return this.titleTextField;
    }

    public void setTitleTextField(TextField titleTextField) {
        this.titleTextField = titleTextField;
    }

    public TextField getUrlTextField() {
        return this.urlTextField;
    }

    public void setUrlTextField(TextField urlTextField) {
        this.urlTextField = urlTextField;
    }

    public TextField getUsernameTextField() {
        return this.usernameTextField;
    }

    public void setUsernameTextField(TextField usernameTextField) {
        this.usernameTextField = usernameTextField;
    }

    public TextField getPasswordTextField() {
        return this.passwordTextField;
    }

    public void setPasswordTextField(TextField passwordTextField) {
        this.passwordTextField = passwordTextField;
    }

    public TextArea getDescriptionTextArea() {
        return this.descriptionTextArea;
    }

    public void setDescriptionTextArea(TextArea descriptionTextArea) {
        this.descriptionTextArea = descriptionTextArea;
    }

    public String getLeftButtonTooltip() {
        return (String)this.leftButtonTooltip.get();
    }

    public StringProperty leftButtonTooltipProperty() {
        return this.leftButtonTooltip;
    }

    public void setLeftButtonTooltip(String leftButtonTooltip) {
        this.leftButtonTooltip.set((Object)leftButtonTooltip);
    }

    public String getRightButtonTooltip() {
        return (String)this.rightButtonTooltip.get();
    }

    public StringProperty rightButtonTooltipProperty() {
        return this.rightButtonTooltip;
    }

    public void setRightButtonTooltip(String rightButtonTooltip) {
        this.rightButtonTooltip.set((Object)rightButtonTooltip);
    }

    public JavaEntry getAnEntry() {
        return this.anEntry;
    }

    public Integer getEntryIndex() {
        return this.entryIndex;
    }

    public Boolean getEdit() {
        return this.edit;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public HBox getRighButtonsHBox() {
        return this.righButtonsHBox;
    }

    public void setRighButtonsHBox(HBox righButtonsHBox) {
        this.righButtonsHBox = righButtonsHBox;
    }

    public String getDeleteButtonId() {
        return (String)this.deleteButtonId.get();
    }

    public StringProperty deleteButtonIdProperty() {
        return this.deleteButtonId;
    }

    public void setDeleteButtonId(String deleteButtonId) {
        this.deleteButtonId.set((Object)deleteButtonId);
    }

    public String getOkButtonId() {
        return (String)this.okButtonId.get();
    }

    public StringProperty okButtonIdProperty() {
        return this.okButtonId;
    }

    public void setOkButtonId(String okButtonId) {
        this.okButtonId.set((Object)okButtonId);
    }

    public String getCautionButtonId() {
        return (String)this.cautionButtonId.get();
    }

    public StringProperty cautionButtonIdProperty() {
        return this.cautionButtonId;
    }

    public void setCautionButtonId(String cautionButtonId) {
        this.cautionButtonId.set((Object)cautionButtonId);
    }

    public HBox getLeftButtonsHBox() {
        return this.leftButtonsHBox;
    }

    public void setLeftButtonsHBox(HBox leftButtonsHBox) {
        this.leftButtonsHBox = leftButtonsHBox;
    }

    public String getEditButtonId() {
        return (String)this.editButtonId.get();
    }

    public StringProperty editButtonIdProperty() {
        return this.editButtonId;
    }

    public void setEditButtonId(String editButtonId) {
        this.editButtonId.set((Object)editButtonId);
    }

    public String getCancelButtonId() {
        return (String)this.cancelButtonId.get();
    }

    public StringProperty cancelButtonIdProperty() {
        return this.cancelButtonId;
    }

    public void setCancelButtonId(String cancelButtonId) {
        this.cancelButtonId.set((Object)cancelButtonId);
    }

    public HBox getShowHidePasswordHBox() {
        return this.showHidePasswordHBox;
    }

    public void setShowHidePasswordHBox(HBox showHidePasswordHBox) {
        this.showHidePasswordHBox = showHidePasswordHBox;
    }

    public String getShowPasswordButtonId() {
        return (String)this.showPasswordButtonId.get();
    }

    public StringProperty showPasswordButtonIdProperty() {
        return this.showPasswordButtonId;
    }

    public void setShowPasswordButtonId(String showPasswordButtonId) {
        this.showPasswordButtonId.set((Object)showPasswordButtonId);
    }

    public String getHidePasswordButtonId() {
        return (String)this.hidePasswordButtonId.get();
    }

    public StringProperty hidePasswordButtonIdProperty() {
        return this.hidePasswordButtonId;
    }

    public void setHidePasswordButtonId(String hidePasswordButtonId) {
        this.hidePasswordButtonId.set((Object)hidePasswordButtonId);
    }

    public String getGeneratePassphraseButtonId() {
        return (String)this.generatePassphraseButtonId.get();
    }

    public StringProperty generatePassphraseButtonIdProperty() {
        return this.generatePassphraseButtonId;
    }

    public void setGeneratePassphraseButtonId(String generatePassphraseButtonId) {
        this.generatePassphraseButtonId.set((Object)generatePassphraseButtonId);
    }
}

