/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.rustkeylock.controllers.BaseController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.japi.JavaEntry;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.rustkeylock.japi.stubs.JavaMenu;
import org.rustkeylock.ui.UiLauncher;
import org.rustkeylock.ui.callbacks.ShowMenuCb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListEntriesController
extends BaseController
implements RklController,
Initializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Consumer<Object> callback;
    @FXML
    private TextField filterTextField = new TextField();
    private String initialFilter;
    @FXML
    private ListView<JavaEntry> entriesListView = new ListView();
    private List<JavaEntry> entries;

    public ListEntriesController(List<JavaEntry> entries, String initialFilter) {
        this.entries = entries;
        this.initialFilter = initialFilter;
    }

    @FXML
    private void checkPasswordsHealth(ActionEvent event) {
        event.consume();
        new ShowMenuCb(UiLauncher.getStage()).apply("PleaseWait");
        this.callback.accept(GuiResponse.CheckPasswords());
    }

    @FXML
    private void addEntry(ActionEvent event) {
        event.consume();
        this.callback.accept(GuiResponse.GoToMenu(JavaMenu.NewEntry()));
    }

    @FXML
    private void doFilter(ActionEvent event) {
        event.consume();
        this.applyFilter();
    }

    @FXML
    public void entryClicked(MouseEvent event) {
        event.consume();
        int pos = this.entriesListView.getSelectionModel().getSelectedIndex();
        if (pos >= 0 && pos < this.entries.size()) {
            this.logger.debug("Clicked entry with index " + pos + " in the list of entries");
            this.callback.accept(GuiResponse.GoToMenu(JavaMenu.ShowEntry(pos)));
        }
    }

    @FXML
    public void filterChanged(KeyEvent event) {
        if (event.getCode().equals((Object)KeyCode.ENTER)) {
            this.applyFilter();
        } else if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
            this.filterTextField.setText("");
            this.applyFilter();
        }
    }

    private void applyFilter() {
        this.logger.debug("Filter changed to '" + this.filterTextField.getText() + "'");
        this.callback.accept(GuiResponse.GoToMenu(JavaMenu.EntriesList(this.filterTextField.getText())));
    }

    @Override
    public void setCallback(Consumer<Object> consumer) {
        this.callback = consumer;
    }

    @Override
    Consumer<Object> getCallback() {
        return this.callback;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.entriesListView.setCellFactory(cf -> new EntryListCell());
        this.entriesListView.setItems(FXCollections.observableArrayList(this.entries));
        this.filterTextField.setText(this.initialFilter);
    }

    public ListView<JavaEntry> getEntriesListView() {
        return this.entriesListView;
    }

    public void setEntriesListView(ListView<JavaEntry> entriesListView) {
        this.entriesListView = entriesListView;
    }

    public TextField getFilterTextField() {
        return this.filterTextField;
    }

    public void setFilterTextField(TextField filterTextField) {
        this.filterTextField = filterTextField;
    }

    private class EntryListCell
    extends ListCell<JavaEntry> {
        private EntryListCell() {
        }

        protected void updateItem(JavaEntry item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                HBox b = new HBox();
                b.setAlignment(Pos.CENTER_LEFT);
                Label label = new Label(item.getName());
                label.setAlignment(Pos.CENTER_LEFT);
                if (item.getMeta().isLeakedpassword()) {
                    this.setStyle("-fx-background-color: #E69269;");
                    this.setTooltip(new Tooltip("This password is leaked!"));
                } else {
                    this.setStyle("-fx-background-color: #FFFFFF;");
                    this.setTooltip(null);
                }
                b.getChildren().add((Object)label);
                this.setGraphic((Node)b);
            }
        }
    }
}

