/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.rustkeylock.controllers.BaseController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportController
extends BaseController
implements RklController,
Initializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @FXML
    private StringProperty title = new SimpleStringProperty("");
    @FXML
    private TextField path = new TextField();
    @FXML
    private StringProperty pathMessage = new SimpleStringProperty("");
    @FXML
    private PasswordField password = new PasswordField();
    @FXML
    private StringProperty passwordMessage = new SimpleStringProperty("");
    @FXML
    private PasswordField number = new PasswordField();
    @FXML
    private StringProperty numberMessage = new SimpleStringProperty("");
    private Consumer<Object> callback;
    private final Stage stage;
    private BooleanProperty export = new SimpleBooleanProperty(false);
    private String homePath = System.getProperty("user.home");
    private String proposedFilename = new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date()) + "_rust_keylock";
    private String pathString = this.homePath + File.separator + this.proposedFilename;

    public ImportExportController(boolean export, Stage stage) {
        this.setExport(export);
        this.stage = stage;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.path.setText(this.pathString);
        if (this.isExport()) {
            this.setTitle("Where to export?");
            this.password.setVisible(false);
            this.number.setVisible(false);
        } else {
            this.setTitle("What to import?");
        }
    }

    @FXML
    private void apply(ActionEvent event) {
        event.consume();
        this.setPathMessage("");
        this.setPasswordMessage("");
        this.setNumberMessage("");
        this.pathString = this.path.getText();
        if (this.isExport()) {
            this.logger.info("Exporting to " + this.pathString);
            if (this.pathString.isEmpty()) {
                this.setPathMessage("Required Field");
            } else if (new File(this.pathString).isDirectory()) {
                this.setPathMessage("Cannot export to a directory");
            } else {
                this.callback.accept(GuiResponse.ExportImport(this.pathString, 1, "Dummy", 11));
            }
        } else if (this.pathString.isEmpty()) {
            this.logger.info("Importing from " + this.path);
            this.setPathMessage("Required Field");
        } else if (new File(this.pathString).isDirectory()) {
            this.setPathMessage("Cannot import from a directory");
        } else if (this.password.getText().isEmpty()) {
            this.setPasswordMessage("Required Field");
        } else if (this.number.getText().isEmpty()) {
            this.setNumberMessage("Required Field");
        } else {
            try {
                Integer numberInt = Integer.parseInt(this.number.getText());
                this.callback.accept(GuiResponse.ExportImport(this.pathString, 0, this.password.getText(), numberInt));
            }
            catch (Exception error) {
                String message = "Incorrect number";
                error.printStackTrace();
                this.number.clear();
                this.setNumberMessage(message);
            }
        }
    }

    @FXML
    private void browseForFile(ActionEvent event) {
        event.consume();
        this.setPathMessage("");
        this.setPasswordMessage("");
        this.setNumberMessage("");
        if (this.isExport()) {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setInitialDirectory(new File(this.homePath));
            File file = directoryChooser.showDialog((Window)this.stage);
            if (file != null) {
                this.pathString = file.getAbsolutePath() + File.separator + this.proposedFilename;
            }
        } else {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialDirectory(new File(this.homePath));
            File file = fileChooser.showOpenDialog((Window)this.stage);
            if (file != null) {
                this.pathString = file.getAbsolutePath();
            }
        }
        this.logger.info("Chosen file: " + this.path);
        this.path.setText(this.pathString);
    }

    @Override
    public void setCallback(Consumer<Object> consumer) {
        this.callback = consumer;
    }

    @Override
    Consumer<Object> getCallback() {
        return this.callback;
    }

    public TextField getPath() {
        return this.path;
    }

    public void setPath(TextField path) {
        this.path = path;
    }

    public String getPathMessage() {
        return (String)this.pathMessage.get();
    }

    public StringProperty pathMessageProperty() {
        return this.pathMessage;
    }

    public void setPathMessage(String pathMessage) {
        this.pathMessage.set((Object)pathMessage);
    }

    public PasswordField getPassword() {
        return this.password;
    }

    public void setPassword(PasswordField password) {
        this.password = password;
    }

    public String getPasswordMessage() {
        return (String)this.passwordMessage.get();
    }

    public StringProperty passwordMessageProperty() {
        return this.passwordMessage;
    }

    public void setPasswordMessage(String passwordMessage) {
        this.passwordMessage.set((Object)passwordMessage);
    }

    public PasswordField getNumber() {
        return this.number;
    }

    public void setNumber(PasswordField number) {
        this.number = number;
    }

    public String getNumberMessage() {
        return (String)this.numberMessage.get();
    }

    public StringProperty numberMessageProperty() {
        return this.numberMessage;
    }

    public void setNumberMessage(String numberMessage) {
        this.numberMessage.set((Object)numberMessage);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public boolean isExport() {
        return this.export.get();
    }

    public BooleanProperty exportProperty() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export.set(export);
    }
}

