/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.util.function.Consumer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.PasswordField;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.japi.stubs.GuiResponse;

public class EnterPasswordController
implements RklController {
    @FXML
    private PasswordField password = new PasswordField();
    @FXML
    private StringProperty passwordMessage = new SimpleStringProperty("");
    @FXML
    private PasswordField number = new PasswordField();
    @FXML
    private StringProperty numberMessage = new SimpleStringProperty("");
    private Consumer<Object> callback;
    private final RklStage stage;

    public EnterPasswordController(RklStage stage) {
        this.stage = stage;
    }

    @FXML
    private void decrypt(ActionEvent event) {
        event.consume();
        this.setPasswordMessage("");
        this.setNumberMessage("");
        if (this.getPassword().getText().trim().isEmpty()) {
            this.setPasswordMessage("Required Field");
        } else if (this.getNumber().getText().trim().isEmpty()) {
            this.setNumberMessage("Required Field");
        } else {
            try {
                Integer num = Integer.parseInt(this.getNumber().getText().trim());
                this.callback.accept(GuiResponse.ChangePassword(this.getPassword().getText().trim(), num));
                if (this.stage != null) {
                    this.stage.markLoggedIn();
                }
            }
            catch (Exception error) {
                String message = "Incorrect number";
                error.printStackTrace();
                this.getNumber().setText("");
                this.setNumberMessage(message);
            }
        }
    }

    @Override
    public void setCallback(Consumer<Object> consumer) {
        this.callback = consumer;
    }

    public String getPasswordMessage() {
        return (String)this.passwordMessage.get();
    }

    public StringProperty passwordMessageProperty() {
        return this.passwordMessage;
    }

    public void setPasswordMessage(String passwordMessage) {
        this.passwordMessage.set((Object)passwordMessage);
    }

    public String getNumberMessage() {
        return (String)this.numberMessage.get();
    }

    public StringProperty numberMessageProperty() {
        return this.numberMessage;
    }

    public void setNumberMessage(String numberMessage) {
        this.numberMessage.set((Object)numberMessage);
    }

    public PasswordField getPassword() {
        return this.password;
    }

    public void setPassword(PasswordField password) {
        this.password = password;
    }

    public PasswordField getNumber() {
        return this.number;
    }

    public void setNumber(PasswordField number) {
        this.number = number;
    }
}

