/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import org.rustkeylock.controllers.BaseController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.rustkeylock.japi.stubs.JavaMenu;
import org.rustkeylock.ui.callbacks.ShowMenuCb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditConfigurationController
extends BaseController
implements RklController,
Initializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Consumer<Object> callback;
    @FXML
    private TextField ncServerUrl = new TextField();
    @FXML
    private StringProperty ncServerUrlMessage = new SimpleStringProperty("");
    @FXML
    private TextField ncUsername = new TextField();
    @FXML
    private StringProperty ncUsernameMessage = new SimpleStringProperty("");
    @FXML
    private TextField ncPassword = new TextField();
    @FXML
    private StringProperty ncPasswordMessage = new SimpleStringProperty("");
    @FXML
    private CheckBox ncUseSelfSignedCertificate = new CheckBox();
    @FXML
    private StringProperty dropboxTokenLabel = new SimpleStringProperty("");
    private final List<String> strings;
    private final RklStage stage;

    public EditConfigurationController(List<String> strings, RklStage stage) {
        this.strings = strings;
        this.stage = stage;
    }

    @Override
    public void setCallback(Consumer<Object> consumer) {
        this.callback = consumer;
    }

    @Override
    Consumer<Object> getCallback() {
        return this.callback;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.disableMenuButtons();
        if (this.strings.size() == 6) {
            this.ncServerUrl.setText(this.strings.get(0));
            this.ncUsername.setText(this.strings.get(1));
            this.ncPassword.setText(this.strings.get(2));
            this.ncUseSelfSignedCertificate.setSelected(Boolean.parseBoolean(this.strings.get(3)));
            if (this.strings.get(5).isEmpty()) {
                this.setDropboxTokenLabel("Click the button to acquire a new authentication token: ");
            } else {
                this.setDropboxTokenLabel("A token is acquired. Press the button if you want to renew: ");
            }
        }
    }

    @FXML
    private void getDropboxToken(ActionEvent event) {
        event.consume();
        try {
            String url = this.strings.get(4);
            this.callback.accept(GuiResponse.GoToMenu(JavaMenu.WaitForDbxTokenCallback(url)));
            String envVar = System.getenv("RUST_KEYLOCK_UI_JAVA_USER_HOME");
            if (envVar != null && !envVar.isBlank()) {
                this.logger.debug("Running in snap! Using xdg-open to open the browser...");
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                Runtime.getRuntime().exec("xdg-open " + url);
            } else {
                this.stage.getHostServices().showDocument(url);
            }
            new ShowMenuCb(this.stage).apply("PleaseWait");
        }
        catch (Exception error) {
            this.logger.error("", (Throwable)error);
        }
    }

    @FXML
    private void clearConfigurations(ActionEvent event) {
        event.consume();
        this.ncServerUrl.setText("");
        this.ncUsername.setText("");
        this.ncPassword.setText("");
        this.ncUseSelfSignedCertificate.setSelected(false);
        this.strings.set(5, "");
        this.setDropboxTokenLabel("Click the button to acquire a new authentication token: ");
    }

    @FXML
    private void apply(ActionEvent event) {
        event.consume();
        this.setNcServerUrlMessage("");
        boolean errorsExist = false;
        if (!(this.ncServerUrl.getText().isBlank() && this.ncUsername.getText().isBlank() && this.ncPassword.getText().isBlank())) {
            if (this.ncServerUrl.getText().isBlank()) {
                errorsExist = true;
                this.setNcServerUrlMessage("Required field");
            } else if (this.ncUsername.getText().isBlank()) {
                errorsExist = true;
                this.setNcUsernameMessage("Required field");
            } else if (this.ncPassword.getText().isBlank()) {
                errorsExist = true;
                this.setNcPasswordMessage("Required field");
            }
        }
        if (!errorsExist) {
            List<String> newStrings = List.of(this.ncServerUrl.getText(), this.ncUsername.getText(), this.ncPassword.getText(), "" + this.ncUseSelfSignedCertificate.isSelected(), this.strings.get(5));
            this.callback.accept(GuiResponse.SetConfiguration(newStrings));
        }
    }

    @FXML
    private void cancel(ActionEvent event) {
        event.consume();
        this.callback.accept(GuiResponse.GoToMenu(JavaMenu.Main()));
    }

    public TextField getNcServerUrl() {
        return this.ncServerUrl;
    }

    public void setNcServerUrl(TextField ncServerUrl) {
        this.ncServerUrl = ncServerUrl;
    }

    public String getNcServerUrlMessage() {
        return (String)this.ncServerUrlMessage.get();
    }

    public StringProperty ncServerUrlMessageProperty() {
        return this.ncServerUrlMessage;
    }

    public void setNcServerUrlMessage(String ncServerUrlMessage) {
        this.ncServerUrlMessage.set((Object)ncServerUrlMessage);
    }

    public TextField getNcUsername() {
        return this.ncUsername;
    }

    public void setNcUsername(TextField ncUsername) {
        this.ncUsername = ncUsername;
    }

    public String getNcUsernameMessage() {
        return (String)this.ncUsernameMessage.get();
    }

    public StringProperty ncUsernameMessageProperty() {
        return this.ncUsernameMessage;
    }

    public void setNcUsernameMessage(String ncUsernameMessage) {
        this.ncUsernameMessage.set((Object)ncUsernameMessage);
    }

    public TextField getNcPassword() {
        return this.ncPassword;
    }

    public void setNcPassword(TextField ncPassword) {
        this.ncPassword = ncPassword;
    }

    public String getNcPasswordMessage() {
        return (String)this.ncPasswordMessage.get();
    }

    public StringProperty ncPasswordMessageProperty() {
        return this.ncPasswordMessage;
    }

    public void setNcPasswordMessage(String ncPasswordMessage) {
        this.ncPasswordMessage.set((Object)ncPasswordMessage);
    }

    public CheckBox getNcUseSelfSignedCertificate() {
        return this.ncUseSelfSignedCertificate;
    }

    public void setNcUseSelfSignedCertificate(CheckBox ncUseSelfSignedCertificate) {
        this.ncUseSelfSignedCertificate = ncUseSelfSignedCertificate;
    }

    public String getDropboxTokenLabel() {
        return (String)this.dropboxTokenLabel.get();
    }

    public StringProperty dropboxTokenLabelProperty() {
        return this.dropboxTokenLabel;
    }

    public void setDropboxTokenLabel(String dropboxTokenLabel) {
        this.dropboxTokenLabel.set((Object)dropboxTokenLabel);
    }
}

