/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.PasswordField;
import org.rustkeylock.controllers.BaseController;
import org.rustkeylock.controllers.RklController;
import org.rustkeylock.fxcomponents.RklStage;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordController
extends BaseController
implements RklController,
Initializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @FXML
    private PasswordField password1 = new PasswordField();
    @FXML
    private StringProperty passwordMessage1 = new SimpleStringProperty("");
    @FXML
    private PasswordField password2 = new PasswordField();
    @FXML
    private StringProperty passwordMessage2 = new SimpleStringProperty("");
    @FXML
    private PasswordField number1 = new PasswordField();
    @FXML
    private StringProperty numberMessage1 = new SimpleStringProperty("");
    @FXML
    private PasswordField number2 = new PasswordField();
    @FXML
    private StringProperty numberMessage2 = new SimpleStringProperty("");
    @FXML
    private BooleanProperty cancelButtonVisible = new SimpleBooleanProperty(true);
    private Consumer<Object> callback;
    private final RklStage stage;

    public ChangePasswordController(RklStage stage) {
        this.stage = stage;
    }

    @FXML
    private void applyNewPassword(ActionEvent event) {
        event.consume();
        this.setPasswordMessage1("");
        this.setPasswordMessage2("");
        this.setNumberMessage1("");
        this.setNumberMessage2("");
        if (!this.password1.getText().equals(this.password2.getText())) {
            this.setPasswordMessage2("The provided passwords did not match");
        } else if (!this.number1.getText().equals(this.number2.getText())) {
            this.setNumberMessage2("The provided favorite numbers did not match");
        } else if (this.password1.getText().trim().isEmpty()) {
            this.setPasswordMessage1("This Field cannot be empty");
            this.password1.clear();
        } else if (this.number1.getText().trim().isEmpty()) {
            this.setNumberMessage1("This Field cannot be empty");
            this.number1.clear();
        } else {
            try {
                this.logger.info("Password and number changed");
                this.callback.accept(GuiResponse.ChangePassword(this.password1.getText().trim(), Integer.parseInt(this.number1.getText().trim())));
                this.stage.markLoggedIn();
            }
            catch (Exception error) {
                String message = "Incorrect number";
                error.printStackTrace();
                this.number1.clear();
                this.setNumberMessage1(message);
            }
        }
    }

    @FXML
    private void cancel(ActionEvent event) {
        event.consume();
        this.callback.accept(GuiResponse.GoToMenu("Main"));
    }

    @Override
    public void setCallback(Consumer<Object> consumer) {
        this.callback = consumer;
    }

    @Override
    Consumer<Object> getCallback() {
        return this.callback;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        if (this.stage.isLoggedIn()) {
            this.disableMenuButtons();
        } else {
            this.hideMenuButtons();
            this.setCancelButtonVisible(false);
        }
    }

    public PasswordField getPassword1() {
        return this.password1;
    }

    public void setPassword1(PasswordField password1) {
        this.password1 = password1;
    }

    public String getPasswordMessage1() {
        return (String)this.passwordMessage1.get();
    }

    public StringProperty passwordMessage1Property() {
        return this.passwordMessage1;
    }

    public void setPasswordMessage1(String passwordMessage1) {
        this.passwordMessage1.set((Object)passwordMessage1);
    }

    public PasswordField getPassword2() {
        return this.password2;
    }

    public void setPassword2(PasswordField password2) {
        this.password2 = password2;
    }

    public String getPasswordMessage2() {
        return (String)this.passwordMessage2.get();
    }

    public StringProperty passwordMessage2Property() {
        return this.passwordMessage2;
    }

    public void setPasswordMessage2(String passwordMessage2) {
        this.passwordMessage2.set((Object)passwordMessage2);
    }

    public PasswordField getNumber1() {
        return this.number1;
    }

    public void setNumber1(PasswordField number1) {
        this.number1 = number1;
    }

    public String getNumberMessage1() {
        return (String)this.numberMessage1.get();
    }

    public StringProperty numberMessage1Property() {
        return this.numberMessage1;
    }

    public void setNumberMessage1(String numberMessage1) {
        this.numberMessage1.set((Object)numberMessage1);
    }

    public PasswordField getNumber2() {
        return this.number2;
    }

    public void setNumber2(PasswordField number2) {
        this.number2 = number2;
    }

    public String getNumberMessage2() {
        return (String)this.numberMessage2.get();
    }

    public StringProperty numberMessage2Property() {
        return this.numberMessage2;
    }

    public void setNumberMessage2(String numberMessage2) {
        this.numberMessage2.set((Object)numberMessage2);
    }

    public boolean isCancelButtonVisible() {
        return this.cancelButtonVisible.get();
    }

    public BooleanProperty cancelButtonVisibleProperty() {
        return this.cancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean cancelButtonVisible) {
        this.cancelButtonVisible.set(cancelButtonVisible);
    }
}

