/*
 * Decompiled with CFR 0.152.
 */
package org.rustkeylock.controllers;

import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import org.rustkeylock.japi.stubs.GuiResponse;
import org.rustkeylock.japi.stubs.JavaMenu;

public abstract class BaseController {
    @FXML
    private Button goToEntriesButton;
    @FXML
    private Button encryptAndSaveButton;
    @FXML
    private Button goToChangePassButton;
    @FXML
    private Button goToExportToButton;
    @FXML
    private Button goToImportFromButton;
    @FXML
    private Button goToShowConfigurationButton;
    @FXML
    private Button goToExitButton;

    abstract Consumer<Object> getCallback();

    @FXML
    private void goToShowEntries(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.EntriesList("")));
    }

    @FXML
    private void encryptAndSave(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.Save(false)));
    }

    @FXML
    private void goToChangePassword(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.ChangePass()));
    }

    @FXML
    private void goToExportTo(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.ExportEntries()));
    }

    @FXML
    private void goToImportFrom(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.ImportEntries()));
    }

    @FXML
    private void goToShowConfiguration(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.ShowConfiguration()));
    }

    @FXML
    private void goToExit(ActionEvent event) {
        event.consume();
        this.getCallback().accept(GuiResponse.GoToMenu(JavaMenu.Exit()));
    }

    protected void disableMenuButtons() {
        this.toggleButtons(true);
    }

    protected void enableMenuButtons() {
        this.toggleButtons(false);
    }

    protected void hideMenuButtons() {
        this.goToEntriesButton.setVisible(false);
        this.encryptAndSaveButton.setVisible(false);
        this.goToChangePassButton.setVisible(false);
        this.goToExitButton.setVisible(false);
        this.goToExportToButton.setVisible(false);
        this.goToImportFromButton.setVisible(false);
        this.goToShowConfigurationButton.setVisible(false);
    }

    private void toggleButtons(boolean toggle) {
        this.goToEntriesButton.setDisable(toggle);
        this.encryptAndSaveButton.setDisable(toggle);
        this.goToChangePassButton.setDisable(toggle);
        this.goToExitButton.setDisable(toggle);
        this.goToExportToButton.setDisable(toggle);
        this.goToImportFromButton.setDisable(toggle);
        this.goToShowConfigurationButton.setDisable(toggle);
    }
}

