use crate::core::atom::AtomKind;

pub trait Direction: Clone {
    const KIND: AtomKind;
}

#[derive(Default, Clone, Debug)]
pub struct In {}

#[derive(Default, Clone, Debug)]
pub struct Out {}

#[derive(Default, Clone, Debug)]
pub struct Local {}

#[derive(Default, Clone, Debug)]
pub struct InOut {}

impl Direction for In {
    const KIND: AtomKind = AtomKind::InputParameter;
}

impl Direction for Out {
    const KIND: AtomKind = AtomKind::OutputParameter;
}

impl Direction for Local {
    const KIND: AtomKind = AtomKind::LocalSignal;
}

impl Direction for InOut {
    const KIND: AtomKind = AtomKind::InOutParameter;
}
