pub mod builder;
pub use builder::*;

pub mod shader;
pub use shader::*;

use web_sys::WebGlProgram;

pub struct Program<U = (), A = ()> {
    program: WebGlProgram,
    pub uniforms: U,
    pub attributes: A,
}

use core::ops::{Deref, DerefMut};
impl<U, A> Deref for Program<U, A> {
    type Target = WebGlProgram;
    fn deref(&self) -> &Self::Target {
        &self.program
    }
}

impl<U, A> DerefMut for Program<U, A> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.program
    }
}
