use super::Vector;
use std::mem::{swap, MaybeUninit};

#[derive(Clone, Debug, Eq, PartialEq)]
pub struct VectorIter<T, const N: usize> {
    vec: Vector<T, N>,
    index: usize,
}

impl<T, const N: usize> VectorIter<T, N> {
    pub fn new(vec: Vector<T, N>) -> Self {
        Self { vec, index: 0 }
    }
}

impl<T, const N: usize> Iterator for VectorIter<T, N> {
    type Item = T;

    fn next(&mut self) -> Option<Self::Item> {
        let output = self.nth(0)?;
        Some(output)
    }

    fn size_hint(&self) -> (usize, Option<usize>) {
        (self.index, Some(N as usize))
    }

    fn last(mut self) -> Option<Self::Item>
    where
        Self: Sized,
    {
        self.index = N - 1;
        self.next()
    }

    fn nth(&mut self, n: usize) -> Option<Self::Item> {
        self.index += n;
        let element = self.vec.get_mut(self.index)?;
        self.index += 1;
        let mut empty = unsafe { MaybeUninit::uninit().assume_init() };
        swap(element, &mut empty);
        Some(empty)
    }
}
