use ::proc_macro::TokenStream;

use ::quote::quote;

use ::syn::parse::{Parse, ParseStream, Result};
use ::syn::punctuated::Punctuated;
use ::syn::{braced, parse_macro_input, Ident, Token};

struct Targets {
    context: Ident,
    name: Ident,
    targets: Punctuated<Ident, Token![,]>,
}

impl Parse for Targets {
    fn parse(input: ParseStream) -> Result<Self> {
        let context = input.parse()?;
        input.parse::<Token![:]>()?;

        let name = input.parse()?;

        let content;
        braced!(content in input);

        let targets = content.parse_terminated(Ident::parse)?;

        let output = Self {
            context,
            name,
            targets,
        };
        Ok(output)
    }
}

pub fn gl_target(input: TokenStream) -> TokenStream {
    let Targets {
        context,
        name,
        targets,
    } = parse_macro_input!(input as Targets);

    let mut members = quote! {};
    let mut construtor = quote! {};
    for i in targets {
        use convert_case::{Case, Casing};
        use Case::{Snake, UpperSnake};
        let snake = Ident::new(i.to_string().to_case(Snake).as_str(), i.span());
        let upper = Ident::new(i.to_string().to_case(UpperSnake).as_str(), i.span());
        members = quote! {
            #members
            pub #snake : Target<#context, {#context::#upper}>,
        };
        construtor = quote! {
            #construtor
            #snake : Target(rc.clone()),
        };
    }

    let expand = quote! {
        use ::std::rc::Rc;
        pub struct Target<C, const N : u32>(Rc<C>);
        impl<C, const N : u32> ::core::ops::Deref for Target<C, N>{
            type Target = C;
            fn deref(&self) -> &Self::Target{
                &self.0
            }
        }

        pub struct #name{
            context : Rc<#context>,
            #members
        }

        impl ::core::ops::Deref for #name{
            type Target = #context;
            fn deref(&self) -> &Self::Target{
                &self.context
            }
        }

        impl ::core::convert::From<#context> for #name{
            fn from(context:#context) -> #name{
                let rc = Rc::new(context);
                Self{
                    context : rc.clone(),
                    #construtor

                }
            }
        }
    };

    expand.into()
}
