/// ATECC/ATSHA EEPROM block size
pub const ATCA_BLOCK_SIZE: usize = cryptoauthlib_sys::ATCA_BLOCK_SIZE as usize;
/// Number of random bytes generated by atcab_random call
pub const ATCA_RANDOM_BUFFER_SIZE: usize = ATCA_BLOCK_SIZE;
/// Size of a configuration buffer size in ATSHA 204A/206A
pub const ATCA_ATSHA_CONFIG_BUFFER_SIZE: usize = cryptoauthlib_sys::ATCA_SHA_CONFIG_SIZE as usize;
/// Size of a configuration buffer size in ATECCx08
pub const ATCA_ATECC_CONFIG_BUFFER_SIZE: usize = cryptoauthlib_sys::ATCA_ECC_CONFIG_SIZE as usize;
pub const ATCA_ZONE_CONFIG: u8 = 0x00;
pub const ATCA_ZONE_OTP: u8 = 0x01;
pub const ATCA_ZONE_DATA: u8 = 0x02;
pub const ATCA_LOCK_ZONE_CONFIG: u8 = ATCA_ZONE_CONFIG;
pub const ATCA_LOCK_ZONE_DATA: u8 = 0x01;
/// Number of key slots in ATECC cryptochip
pub const ATCA_ATECC_SLOTS_COUNT: u8 = 16;
/// Minimum ATECC slot number where a public ECC key can be stored
pub const ATCA_ATECC_MIN_SLOT_IDX_FOR_PUB_KEY: u8 = 8;
/// Chip serial number size
pub const ATCA_SERIAL_NUM_SIZE: usize = cryptoauthlib_sys::ATCA_SERIAL_NUM_SIZE as usize;
/// ATECC/ATSHA temporary key slot identifier
pub const ATCA_ATECC_TEMPKEY_KEYID: u16 = cryptoauthlib_sys::ATCA_TEMPKEY_KEYID as u16;
pub const ATCA_KEY_SIZE: usize = cryptoauthlib_sys::ATCA_KEY_SIZE as usize;
/// Size (in bytes) of AES data block
pub const ATCA_AES_DATA_SIZE:usize = cryptoauthlib_sys::AES_DATA_SIZE as usize;
/// Size (in bytes) of AES key
pub const ATCA_AES_KEY_SIZE: usize = cryptoauthlib_sys::AES_DATA_SIZE as usize;
/// Standard NONCE (IV) length for AES GCM encryption (in bytes)
pub const ATCA_AES_GCM_IV_STD_LENGTH: usize = cryptoauthlib_sys::ATCA_AES_GCM_IV_STD_LENGTH as usize;
/// Size (in bytes) of SHA hash
pub const ATCA_SHA2_256_DIGEST_SIZE: usize = cryptoauthlib_sys::ATCA_SHA2_256_DIGEST_SIZE as usize;
/// Place resulting SHA256 digest both in Output buffer and TempKey
pub const SHA_MODE_TARGET_TEMPKEY: u8 = 0x00;
/// Place resulting SHA256 digest both in Output buffer and Message Digest Buffer
pub const SHA_MODE_TARGET_MSGDIGBUF: u8 = 0x40;
/// Place resulting SHA256 digest in Output buffer ONLY
pub const SHA_MODE_TARGET_OUT_ONLY: u8 = 0xC0;
/// Private key size (in bytes) for elliptic curve P256 supported by ATECC
pub const ATCA_ATECC_PRIV_KEY_SIZE: usize = cryptoauthlib_sys::ATCA_PRIV_KEY_SIZE as usize;
/// Public key size (in bytes) for elliptic curve P256 supported by ATECC
pub const ATCA_ATECC_PUB_KEY_SIZE: usize = cryptoauthlib_sys::ATCA_PUB_KEY_SIZE as usize;
/// Nonce NumIn size for random modes
pub const ATCA_NONCE_NUMIN_SIZE: usize = cryptoauthlib_sys::NONCE_NUMIN_SIZE as usize;
/// Nonce NumIn size for 32-byte pass-through mode
pub const ATCA_NONCE_SIZE: usize = cryptoauthlib_sys::OUTNONCE_SIZE as usize;
/// Size (in bytes) of ECDSA signature
pub const ATCA_SIG_SIZE: usize = cryptoauthlib_sys::ATCA_SIG_SIZE as usize;
/// KDF max message size
pub const ATCA_KDF_MAX_MSG_SIZE: usize = 0x7F;
/// ECDH output data size
pub const ATCA_ECDH_KEY_SIZE: usize = cryptoauthlib_sys::ECDH_KEY_SIZE as usize;
