# rust-code-analysis

**rust-code-analysis** is a Rust library to analyze and extract information
from source codes written in many different programming languages.
It is based on a parser generator tool and an incremental parsing library
called
<a href="https://tree-sitter.github.io/tree-sitter/" target="_blank">Tree Sitter</a>.

You can find the source code of this software on
<a href="https://github.com/mozilla/rust-code-analysis/" target="_blank">GitHub</a>,
while issues and feature requests can be posted on the respective
<a href="https://github.com/mozilla/rust-code-analysis/issues/" target="_blank">GitHub Issue Tracker</a>.

## Supported platforms

**rust-code-analysis** can run on the most common platforms: Linux, macOS,
and Windows.

On our
<a href="https://github.com/mozilla/rust-code-analysis/releases" target="_blank">GitHub Release Page</a>
you can find the `Linux` and `Windows` binaries already compiled and
packed for you.


## API docs

If you prefer to use **rust-code-analysis** as a crate, you can find the
`API docs` generated by `Rustdoc`
<a href="https://docs.rs/rust-code-analysis/*/rust_code_analysis/" target="_blank">here</a>.


## How to cite rust-code-analysis

```
@article{ARDITO2020100635,
    title = {rust-code-analysis: A Rust library to analyze and extract maintainability information from source codes},
    journal = {SoftwareX},
    volume = {12},
    pages = {100635},
    year = {2020},
    issn = {2352-7110},
    doi = {https://doi.org/10.1016/j.softx.2020.100635},
    url = {https://www.sciencedirect.com/science/article/pii/S2352711020303484},
    author = {Luca Ardito and Luca Barbato and Marco Castelluccio and Riccardo Coppola and Calixte Denizet and Sylvestre Ledru and Michele Valsesia},
    keywords = {Algorithm, Software metrics, Software maintainability, Software quality},
    abstract = {The literature proposes many software metrics for evaluating the source code non-functional properties, such as its complexity and maintainability. The literature also proposes several tools to compute those properties on source codes developed with many different software languages. However, the Rust language emergence has not been paired by the community’s effort in developing parsers and tools able to compute metrics for the Rust source code. Also, metrics tools often fall short in providing immediate means of comparing maintainability metrics between different algorithms or coding languages. We hence introduce rust-code-analysis, a Rust library that allows the extraction of a set of eleven maintainability metrics for ten different languages, including Rust. rust-code-analysis, through the Abstract Syntax Tree (AST) of a source file, allows the inspection of the code structure, analyzing source code metrics at different levels of granularity, and finding code syntax errors before compiling time. The tool also offers a command-line interface that allows exporting the results in different formats. The possibility of analyzing source codes written in different programming languages enables simple and systematic comparisons between the metrics produced from different empirical and large-scale analysis sources.}
}
```

## License

- Mozilla-defined grammars are released under the MIT license.

- **rust-code-analysis**, **rust-code-analysis-cli** and **rust-code-analysis-web**
are released under the
<a href="https://www.mozilla.org/MPL/2.0/" target="_blank">Mozilla Public License v2.0</a>.
