

fn main() {
	// immutable variable 
	let x = 5;
	println!("The value of x is: {}", x);
	// x = 6;	// error: cannot mutate x
	println!("The value of x is: {}", x);

	let mut xm = 5;
	println!("The value of xm is: {}", xm);
	xm = 6; // works
	println!("The value of xm changed to: {}", xm);

	// constants
	const MAX_POINTS: u32 = 100_000;	// must annotate type
	println!("MAX POINTS: {}", MAX_POINTS);

	// shadowing 
	let x = 5;
	let x = x + 1;	// x shadows previous x
	let x = x * 2;	// ...
	println!("the value of x is: {}", x);
	// x is not mut but it is redeclared shadowing the previous x

	// change type with shadowing
	let spaces = "   ";                 // type: &str
	let spaces = spaces.len();         // type: usize

	let mut spaces_mut = "    ";            // type: &str
	// spaces_mut = spaces.len();	// error: not allowed to mutate a variables type

}
