

struct Rectangle {
	width: u32,
	height: u32,
}

impl Rectangle {
	fn area(&self) -> u32 {
		self.width * self.height
	}
	fn can_hold(&self, rect: &Rectangle) -> bool {
		rect.width <= self.width && rect.height <= self.height
	}
}

fn main() {
	let rect = Rectangle {
		width: 300,
		height: 600
	};
	let area = rect.area();
	println!(
		"The area of the rectangel is {} square pixels",
		area
	);

	let rect1 = Rectangle {
        width: 30,
        height: 50,
    };
    let rect2 = Rectangle {
        width: 10,
        height: 40,
    };
    let rect3 = Rectangle {
        width: 60,
        height: 45,
    };

    println!("Can rect1 hold rect2? {}", rect1.can_hold(&rect2));	// => true
    println!("Can rect1 hold rect3? {}", rect1.can_hold(&rect3));	// => false

	// use assosiated function
	let square = Rectangle::square(3);
	square.area();

}

// structs can have multiple impl blocks
impl Rectangle {
	// associated functions; don't take self as the first argument
	// these are functions not methods
	// String::from is an assosiated function

	fn square(size: u32) -> Rectangle {
		Rectangle {
			width: size,
			height: size
		}
	}
}
