

struct Rectangle {
	width: u32,
	height: u32,
}

#[derive(Debug)]	// opt into including debugging information on this struct
struct RectangleDebug {
	width: u32,
	height: u32
}

fn main() {
	let rect1 = Rectangle {
		width: 320,
		height: 640,
	};

	// error: `Rectangle` doesn't implement `std::fmt::Display`
	// println!("rect1 is {}", rect1);

	// error: `Rectangle` doesn't implement `Debug`
	// println!("rect1 is {:?}", rect1);

	let rect2 = RectangleDebug {
		width: 200,
		height: 200
	};

	println!("rect2 is {:?}", rect2);	// works
	println!("rect2 is {:#?}", rect2);	// display struct in a clearer format

}
