

fn main() {
	let mut user = User {
		email: String::from("someone@example.com"),
		username: String::from("someusername"),
		active: true,
		sign_in_count: 1,
	};

	// if instance is mutable we change a field
	user.email = String::from("newemail@example.com");
	let user2 = build_user(String::from("anotheruser"), String::from("another@example.com"));


	// creating a struct using `struct update syntax`

	let user3 = User {
		email: String::from("user3@exapmle.com"),
		// username: String::from("user3"),
		..user2
	};

	struct Color(i32, i32, i32);
	struct Point(i32, i32, i32);
	let black = Color(0, 0, 0);
	let oirigin = Point(0, 0, 0);
	// NOTE: that the black and origin values are different types, because they’re instances of different tuple structs


	// Unit-Like Structs
	// You can also define structs that don’t have any fields! These are called 
	// unit-like structs because they behave similarly to (), the unit type. Unit-like
	// structs can be useful in situations in which you need to implement a trait
	// on some type but don’t have any data that you want to store in the type itself.


}

// tuple structs

fn build_user(email: String, username: String) -> User {	// returns User object from function
	User {
		email: email,
		username: username,
		sign_in_count: 0,
		active: true,
	}
}

struct User {
	username: String,
	email: String,
	sign_in_count: u64,
	active: bool,
}

// error: can't define a struct that uses references without lifetimes 
// struct User {
// 	username: &str,
// 	email: &str,
// 	sign_in_count: u64,
// 	active: bool
// };