


fn main() {
	let mut s = String::from("hello world");

	let slice = &s[0..2];
	let slice = &s[..2];
	let slice = &s[3..s.len()];
	let slice = &s[3..];

	{
		let word = first_word(&s);
		// s.clear();	// error: a mutable reference to word can't be taken
						// because  there is already an imuttable reference i.e word
						// to it
		println!("the first word is : {}", word);
	};

	{
		let string_literal = "hello world";		// &str slice
		let word = first_word_better(&s[..]);
		let word = first_word_better(&string_literal[..]);
		// string literals are slices aready so this works too
		let word = first_word_better(string_literal);
	};

	// general slice type

	let a = [1,2,3,4,5];
	let slice = &a[1..3];
	assert_eq!(slice, &[2,3])


}

fn first_word(s: &String) -> &str {		// returns slice
	let bytes = s.as_bytes();

	for (i, &item) in bytes.iter().enumerate() {
		if item == b' ' {
			return &s[0..i];
		}
	}
	&s[..]
}


fn first_word_better(s: &str) -> &str {
	let bytes = s.as_bytes();

	for (i, &item) in bytes.iter().enumerate() {
		if item == b' ' {
			return &s[0..i];
		}
	}
	&s[..]
}