

fn main() {
	println!("References");
	let s1 = String::from("hello");
	let len = calculate_length(&s1);
	// We call having references as function parameters borrowing
	change(&s1);
	let mut s = String::from("hello");
	change_mut(&mut s);

	// NOTE: But mutable references have one big restriction: you can have only one 
	// mutable reference to a particular piece of data in a particular scope. 
	// This code will fail: 
	let mut s = String::from("hello");
	let r1 = &mut s;
	// let r2 = &mut s;	// error: cannot borrow `s` as mutable more than once at a time

	// this will work though
	let mut s = String::from("hello");
	{
		let r1 = &mut s;
	}	// r1 goes out of scope here, so we can make a new reference
	let r2 = &mut s;
	println!("{}, {}", r1, r2);

	// smame rule exists for combining mutable and immutable refs
	let mut s = String::from("hello");
	let r1 = &s; // no problem
	let r2 = &s; // no problem
	// let r3 = &mut s; // BIG PROBLEM
	// NOTE: we are not allowed to do this because Users of an immutable reference 
	// don’t expect the values to suddenly change out from under them!


	// NOTE: Note that a reference’s scope starts from where it is introduced 
	// and continues through the last time that reference is used. For instance, 
	// this code will compile because the last usage of the immutable references
	// occurs before the mutable reference is introduced:
	let mut s = String::from("hello");
	let r1 = &s; // no problem
	let r2 = &s; // no problem
	println!("{} and {}", r1, r2);
	// r1 and r2 are no longer used after this point
	let r3 = &mut s; // no problem
	println!("{}", r3);

}

// fn dangle() -> &String {	// error: dangling reference
// 	let s = String::from("hello");
// 	&s
// }


fn calculate_length(s: &String) -> usize {
	s.len()
}	// will not drop s because it is a ref this function doesn't own it


fn change(some_string: &String) {
	// some_string.push_str("dsfdas")	// error: can't modify something borrowed 
	// Just as variables are immutable by default, so are references. 
	// We’re not allowed to modify something we have a reference to.
}

fn change_mut(some_string: &mut String) {
	some_string.push_str(", World");
}