

fn main() {
	{
		let mut s = String::from("Hello");	// s is valid from this point forward
		s.push_str(", World");
		println!("{}", s);
	}		// this scope is now over, and s i no 
			// longer valid
	// when a variable goes out of scope rust calls a special funtion `drop`


	let x = 4;
	let y = x;	// copies x to y
	// for simple fixed size types this is the case


	{
		let s1 = String::from("hello");
		let s2 = s1;	// s1 is considered invalid now
		// println!("{}, world!", s1);	// error: s1 moved to s2
		// s2 is a shallow copy of s1 and it points to the same underlying
		// data as s1. but rust aslo invalidates s1 pointing to that memory
		// using s1 now is not allowed; i.e s1 has moved to s2 

	}			// s2 will free the underlying memory here

	// NOTE: Rust will never automatically create “deep” copies of your data. 
	// Therefore, any automatic copying can be assumed to be inexpensive 
	// in terms of runtime performance.

	// Clone
	let s1 = String::from("hello");
	let s2 = s1.clone();

	println!("s1 = {}, s2 = {}", s1, s2);

	// this is still valid however
	let x = 5;
	let y = x;
	println!("x = {}, y = {}", x, y);
	// NOTE: The reason is that types such as integers that have a known size at compile 
	// time are stored entirely on the stack, so copies of the actual values are 
	// quick to make. That means there’s no reason we would want to prevent x from 
	// being valid after we create the variable y.
	// In other words, there’s no difference between deep and shallow copying here, 
	// so calling clone wouldn’t do anything different from the usual shallow copying 
	// and we can leave it out.

	// The semantics for passing a value to a function are similar to those for assigning 
	// a value to a variable. Passing a variable to a function will move or copy, 
	// just as assignment does.

	let s = String::from("hello");
	take_ownership(s);						// s's value moves into the functoin
	// s is no longer valid

	{
		let x = 5;
		makes_copy(x);							// i32 has Copy trait so it's okay to
												// it after this
	}	// x goes out of scope, then s. But because s's value was moved, nothing special happens 

	let s1 = gives_ownership();
	let s2 = String::from("hello");
	let s3 = takes_and_gives_back(s2);	// takes s2 then gives it back


	let s1 = String::from("hello");
	let (s2, len) = calculate_length(s1);	// rember s1 is moved into function 

}

fn take_ownership (s: String) {

}	// drop is called on s 

fn makes_copy(n :i32) {

}	// nothing special happens

fn gives_ownership() -> String {
	let some_string = String::from("hello");
	some_string		// some_string is returned and moves out of calling func
}

fn takes_and_gives_back(a_string: String) -> String { a_string }	// a_string is retunred and moves out of calling function

fn calculate_length(s: String) -> (String, usize) {
	let length = s.len();
	(s, length)
}
