
use std::collections::HashMap;

fn main() {
    let mut arguments = std::env::args().skip(1);
    let key = arguments.next().expect("Key was not there");
    let value = arguments.next().expect("Value was not there");
    println!("The key is '{}' and value is '{}'", key, value);

    // write to disk
    let contents = format!("{}\t{}\n", key, value);
    // std::fs::write("kv.db", contents).unwrap();

    let mut database = Database::new().expect("failed to load db");
    database.insert(key.to_uppercase(), value.clone());
    database.insert(key, value);
    match database.flush() {
        Ok(()) => { println!("Yay")},
        Err(err) => { println!("Error!!!! {}", err)}
    };

}

struct Database {
    map: HashMap<String, String>,
    flush: bool
}

impl Database {
    fn new() -> Result<Database, std::io::Error> {

        // read the kv.db file
        // handle error
        // let contents = match std::fs::read_to_string("kv.db") {
        //     Ok(c) => c,
        //     Err(e) => {
        //         return Err(e);
        //     }
        // };
        
        // consices version
        let contents = std::fs::read_to_string("kv.db")?;   // ? returns the error to the func caller
        let mut map = HashMap::new();
        // parse the string
        for line in  contents.lines(){
            // populate our map
            // let (key, value) = line.split_once(' ').expect("corrupt database")
            let mut chunks = line.splitn(2, '\t');
            let key = chunks.next().expect("no key");
            let value = chunks.next().expect("no value");
            map.insert(key.to_owned(), value.to_owned());
        }

        Ok(Database { map, flush: false})
    }
    fn insert(&mut self, key: String, value: String) {
        self.map.insert(key.to_owned(), value);
    }
    fn flush(&mut self) -> std::io::Result<()> {
        self.flush = true;
        do_flush(&self)
    }
}

impl Drop for Database {
    fn drop(&mut self) {
        if !self.flush {
            let _ = do_flush(self);
        }
    }
}

fn do_flush(database: &Database) -> std::io::Result<()>{
    println!("Flushing...");
    let mut contents = String::new();
    for (key, value) in &database.map {
        // let kvpair = format!("{}\t{}\n", key, value);
        contents.push_str(key);
        contents.push('\t');
        contents.push_str(value);
        contents.push('\n');
        // contents.push_str(&kvpair);
    }
    std::fs::write("kv.db", contents)
}
