// Documenting library code

//! # Art
//! A library for modeling artistic concepts

pub mod theory {
	//! # Theory Module
	//! `theory` is a collection of basic mathematical
	//! utility functions 

	/// Adds one to the number given
	/// # Example
	/// ```
	/// use rust_cheatsheet::theory;
	/// let x = 1;
	/// let y = theory::add_one(x);
	/// assert_eq!(y, x + 1);
	/// ```
	pub fn add_one(x: i32) -> i32 {
		x + 1
	}

	/// Adds two to the number given
	/// ```
	/// use rust_cheatsheet::theory;
	/// let x = 1;
	/// let y = theory::add_two(x);
	/// assert_eq!(y, x + 2);
	/// ```
	pub fn add_two(x: i32) -> i32 {
		x + 2
	}

	pub mod internal {
		//! # Internal Module
		//! mod `internal` specifies some more
		//! internal functionality


		/// this function pretty much does nothing
		/// important
		/// # Example
		/// ```
		/// use rust_cheatsheet::theory::internal;
		/// internal::check_addition();
		/// ```
		pub fn check_addition() {
			// does nothing
		}
		
	}

}

pub mod base {
	//! base module

	/// vrooom!!!!!!!!
	/// # Example
	/// ```
	/// use rust_cheatsheet::base;
	/// base::start();
	/// ```
	pub fn start() {}
}

pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;

pub mod kinds {
	//! kinds of colors

	// the primary colors according to RYB color model
	pub enum PrimaryColor {
		Red, Yellow, Blue
	}
	// the secondary colors according to RYB color model
	pub enum SecondaryColor { Orange, Green, Purple }
}

pub mod utils {
    use crate::kinds::{PrimaryColor, SecondaryColor};

	/// Combines two primary colors in equal ammounts to create
	/// a secondary color.
	pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor {
		// --snip--
		// ANCHOR_END: here
		SecondaryColor::Orange
		// ANCHOR: here
	}
}
