

fn main() {
	println!("Functions");
	// another_function(3);	// error: must pass in two values
	another_function(3, 5);


	// statements and expressions
	// Function bodies are made up of a series of
	// statements optionally ending in an expression

	let y = 6; // is a statement.
	// Function definitions are also statements;
	// NOTE: Statements do not return values
	// let x = (let y = 6)	// error: statements don't return values only expressions

	// the block that we use to create new scopes, `{}`, is an expression 
	// e.g:
	let y = {
		let x = 3;
		x + 1	// NOTE: this is an expression, If you add a semi-colon at the end
				// it turns it into a statement so the block won't return a value
	};
	println!("The value of y is: {}", y); // => 4
	
	// function return
	let x = five();	// evaluates as an expression same as let x = 5;
	println!("The value of x is: {}", x);	// => 5
	let x = plus_one(5);
	println!("The value of x is: {}", x);	// => 6
}

fn another_function(x: i32, y: i32) {	// type annotation
	println!("the value of x is {}", x);
	println!("the value of y is {}", y);
}

fn five() -> i32 {	// returns type i32
	5	// NOTE: 5 doesn't need return prefix 
		// adding semi-colon changes this to a statement 
		// and produces an error: "expected `i32`, found `()`"
}

fn plus_one(x: i32) -> i32 {
	x+1
}