

enum Coin {
	Penny,
	Nickel,
	Dime,
	Quarter(UsState)
}

#[derive(Debug)]
enum UsState {
	Alabama,
	Alaska,
}

fn main() {

	let c = Coin::Dime;
	let v = value_in_cents(c);

	let v = value_in_cents(Coin::Quarter(UsState::Alabama));
	println!("cents: {}", v);

	// using match on Option<T>

	let five = Some(5);
	let six = plus_one(five);
	let none = plus_one(None);

	let some_u8_value = 0u8;

	match some_u8_value {
		1 => println!("one"),
		3 => println!("three"),
		5 => println!("five"),
		7 => println!("seven"),
		_ => (),	// placeholder handles all other cases
	}

	let some_u8_value = Some(0u8);
	match some_u8_value {
		Some(3) => println!("three"),
		_ => (),
	}
	// `if let` let's us be more concise
	if let Some(3) = some_u8_value {
		println!("three")
	}
	// In other words, you can think of if let as syntax sugar 
	// for a match that runs code when the value matches one 
	// pattern and then ignores all other values.

	// with else block
	let mut count = 0;
	let coin = Coin::Quarter(UsState::Alaska);
	if let Coin::Quarter(state) = coin {
		println!("State quarter from {:?}", state);
	} else {
		count += 1;
	}
	// else block is synonymous with the placeholder arm
}

fn plus_one(x: Option<i32>) -> Option<i32> {
	match x {
		None => None,
		Some(i) => Some(i + 1)
	}
	// NOTE: match need to match all possible cases other wise a
	// compiler will error 
}


fn value_in_cents(coin: Coin) -> u8 {
	// match <expr>
	// unlike `if` where condition must be bool
	// match <expr> can be any type 


	// match with four arms
	match coin {
		// An arm has two parts: a pattern and some code
		// the => operator seperates them
		Coin::Penny => {
			println!("Lucky penny!");
			1	// will run the print and return 1
		},
		// ^^ arm 	   ^^ //code
		Coin::Nickel => 5,
		// arms are seperated by commas
		Coin::Dime => 10,
		Coin::Quarter(state) => {
			// can use the state defined on the enumm field Quarter
			println!("State quarter from {:?}", state);
			25
		}
	}
}