#[derive(Debug)]
enum IpAddrKind {
	V4,
	V6
}

fn route(_ip: IpAddrKind) {}	// func taking IpAddrKind

// enum associated values
#[derive(Debug)]
enum IpAddrKind2 {
	V4(u8, u8, u8, u8),
	V6(String)
}

enum Message {
	_Quit, 
	_Move {x: i32, y: i32},
	Write(String),
	_ChangeColor(i32, i32, i32)
}

// just like structs we can also define impl for enums
impl Message {
	fn call(&self ) {
		// metho body...
	}
}

fn main() {
	let four = IpAddrKind::V4;
	let six = IpAddrKind::V6;
	println!("{:?} {:?}", four, six);
	// both four and six are same type
	route(IpAddrKind::V4);
	route(IpAddrKind::V4);

	let home = IpAddrKind2::V4(127, 0, 0, 1);
	let loopback = IpAddrKind2::V6(String::from("::1"));
	println!("{:#?} {:#?}", home, loopback);

	let m = Message::Write(String::from("hello"));
	m.call();

	// Option enum
	let _some_number = Some(5);	// Option<i32>
	let _some_string = Some("a string");	// Option<&str>
	let _absent_number: Option<i32> = None;
	// NOTE: If we use None rather than Some, we need to tell Rust what 
	// type of Option<T> we have, because the compiler can’t infer the 
	// type that the Some variant will hold by looking only at a None value.

	// Option<T> and T are different types
	let _x: i8 = 5;
	let _y: Option<i8> = Some(5);
	// let sum = x + y;	// error: no implementation for `i8 + Option<i8>`

}
