

fn main( ) {
	println!("Control Flow");
	let number = 3;

    if number < 5 {
        println!("condition was true");
    } else {
        println!("condition was false");
    }
	// `if` expressions are sometimes called arms,
	// NOTE: <condition> must be a bool 
	// if number {
	// 	println!("number was theere")
	// }

	// error: number evaluates to 3 which is not a bool
	// rustc will produce the error:
	// >>>
	// 4 |     if number {
	//   |        ^^^^^^ expected `bool`, found integer
	// >>>

	// NOTE: if is an expression, we can use it on the right side of a let statement
	let condition = true;
	let number = if condition { 5} else {6};	// Remember that blocks of code evaluate 
													// to the last expression in them, and 
													// numbers by themselves are also expressions
	println!("The value of number is: {}", number);	// => 5

	// this means the type from each arm (block) must return the same type
	// let number = if condition { 5 } else { "six" };	// error: The if and else arms have value types that are incompatible
	// NOTE: Rust needs to know at compile time what type the number variable is, definitively, so it can verify at compile time that its type is valid everywhere we use number

	// Loop
	let mut counter = 0;
	let result  = loop {
		counter += 1;
		if counter == 10 {
			break counter * 2
		}
	};	// notice this semi colon is required because loop is an expression
		// and has to be treated as a statement because return value goes to result
	println!("The result is {}", result);	// => 20

	let mut number = 3;
	while number != 0 {
		println!("{}!", number);
		number -= 1;
	}
	println!("LIFTOFF!!!");

	// looping a collection

	let a = [1,2,3,4,5];
	for element in a.iter() {
		println!("the value is: {}", element);
	}

	// using Ranges
	for number in (1..4).rev() {	// rev reverses the range
		println!("{}!", number);
	}
	println!("LIFTOFF!!!!");

}