
fn main() {
	print!("Testing");
}

fn add_two(a: i32) -> i32 {
    a + 2
}


#[cfg(test)]
pub mod tests {
	#[test]
	fn foooooooooooooo() {
		assert_eq!(4, 4)
	}
    #[test]
    fn exploration() {
        assert_eq!(2 + 2, 4);
    }
    // #[test]
    // fn another() {   // fail
    //     panic!("Make this test fail")
    // }
    use super::*;
    #[test]
    fn larger_can_hold_smaller() {
        let larger = Rectangle {
            width: 8,
            height: 7,
        };
        let smaller = Rectangle {
            width: 5,
            height: 1
        };
        assert!(larger._can_hold(&smaller))
    }
    // fn smaller_cannot_hold_larger() {   // fail
    //     let larger = Rectangle {
    //         width: 8,
    //         height: 7,
    //     };
    //     let smaller = Rectangle {
    //         width: 5,
    //         height: 1,
    //     };

    //     assert!(!smaller.can_hold(&larger));
    // }
    
    #[test]
    fn it_adds_two() {
        assert_eq!(4, add_two(2))
    }

    fn greeting(name: &str) -> String {
        format!("Hello, {}", name)
    }
    #[test]
    fn greeting_contains_name() {
        let result= greeting("Carol");
        assert!(
            result.contains("Carol"), 
            "Greeting did not contain name value was {}",
            result
        )
    }
    #[test]
    #[should_panic]
    fn great_than_100() {
        Guess::new(200);
    }
    #[test]
    #[should_panic(expected="Guess value must be between 1 and 100, got 233.")]
    // specifying the expected panic message
    fn greater_than_100() {
        Guess::new(233);
    }

    // test by returning Result<>
    #[test]
    fn it_works() -> Result<(), String> {
        if 2 + 2 == 4 {
            Ok(())
        } else {
            Err(String::from("two plus two does not equa four"))
        }
    }

    #[test]
    #[ignore]   // won't run
    fn expensive_test() {
        assert_eq!(2, 1 + 1)
    }

}

#[derive(Debug)]
struct Rectangle {
    width: u32,
    height: u32,
}

impl Rectangle {
    fn _can_hold(&self, other: &Rectangle) -> bool {
        self.width > other.width && self.height > other.height
    }
}


pub struct Guess {
    _value: i32,
}

impl Guess {
    pub fn new(value: i32) -> Guess {
        if value < 1 || value > 100 {
            panic!("Guess value must be between 1 and 100, got {}.", value);
        }
        Guess { _value: value }
    }
}


