
fn longest<'a>(str1: &'a str, str2: &'a str) -> &'a str {
	if str1.len() > str2.len() {
		return str1
	}else {
		return str2
	}
}

struct ImportantExcerpt<'a> {
	part: &'a str,
}

impl<'a> ImportantExcerpt<'a> {
	fn announce_and_return_part(&self, announcement: &str) -> &str {
		println!("Attention please: {}", announcement);
		self.part
	}
}

fn main() {
	println!("Lifetimes");
	let string1 = String::from("abcd");
	{
		let string2 = String::from("abc");
		let result = longest(string1.as_str(), string2.as_str());
		println!("{}", result);
	}

	let novel = String::from("call me Ishmael. Some years ago...");
	let i;
	{
		// let novel = String::from("call me Ishmael. Some years ago...");
		// if novel was defined here the next line wouldn't work
		// because novel goes out of scope while `i` is still valid
		// in the outer scope
		let first_sentence = novel.split('.').next().expect("Could not find a '.'");
		i = ImportantExcerpt {
			part: first_sentence
		};
	}
	println!("{}", i.part);

	i.announce_and_return_part("hhello");
	// static lifetime
	let s: &'static str = "some string";
	println!("s: {}", s);

	let r = longest_with_an_announcemenet("short", "realllly long string string", "Hello Everyone");
	println!("r: {}", r);

}

use std::fmt::Display;

// traits with generics and lifetimes
fn longest_with_an_announcemenet<'a, T>(
	x: &'a str,
	y: &'a str,
	ann: T
) -> &'a str 
where
	T: Display
{
	println!("Announcement {}!", ann);
	if x.len() > y.len() {
		x
	} else {
		y
	}

}
