


#[derive(Debug, PartialEq)]
struct Shoe {
	size: u32,
	style: String
}

fn shoes_in_size(shoes: Vec<Shoe>, shoe_size: u32) -> Vec<Shoe> {
	shoes.into_iter().filter(|s| s.size == shoe_size).collect()
}

#[cfg(test)]
mod tests {
	use super::*;

	#[test]
	fn iterator_sum() {
		let v1 = vec![1,2,3];
		let v1_iter = v1.iter();
		let total: i32 = v1_iter.sum();
		assert_eq!(total, 6)
	}

	#[test]
	fn filers_by_size() {
		let shoes = vec![
			Shoe {size: 10, style: String::from("sneaker")},
			Shoe {size: 13, style: String::from("sandal")},
			Shoe {size: 10, style: String::from("boot")},
		];

		let in_my_size = shoes_in_size(shoes, 10);
		assert_eq!(
			in_my_size,
			vec![
				Shoe {size: 10, style: String::from("sneaker")},
				Shoe {size: 10, style: String::from("boot")},
			]
		);
	}

	#[test]
	fn calling_next_directly() {
		let mut counter = Counter::new();
		assert_eq!(counter.next(), Some(1));
		assert_eq!(counter.next(), Some(2));
		assert_eq!(counter.next(), Some(3));
		assert_eq!(counter.next(), Some(4));
		assert_eq!(counter.next(), Some(5));
		assert_eq!(counter.next(), None);
	}

	#[test]
	fn using_other_iterator_trait_methods() {
		let sum: u32 = Counter::new()
			.zip(Counter::new().skip(1))
			.map(|(a, b)| a * b)
			.filter(|x| x % 3 == 0)
			.sum();
		assert_eq!(18, sum);
	}
}

struct Counter {
	count: u32
}
impl Counter {
	fn new() -> Self {
		Counter {count: 0}
	}
}
impl Iterator for Counter {
	type Item = u32;


	fn next(&mut self) -> Option<Self::Item> {
		self.count += 1;
		if self.count > 5 {
			None
		} else {
			Some(self.count)
		}
	}
}


fn main() {
	println!("Iterators");

	let v1: Vec<i32> = vec![1,2,3];
	let x: Vec<_> = v1.iter().map(|x|  x + 1).collect();
	// consuming adaptor takes ownership of the iterator
	for value in Counter::new() {
		println!("Value: {}", value);
	}
}