
// Traits
// defining a trait
pub trait Summary {
	fn summarize(&self) -> String;
}

pub trait DevilDisplay {
	fn devil_print(&self) -> String;
}

// trait with default implementation
pub trait SummaryDefaulted {
	fn summarizeDef(&self) -> String {
		String::from("Je ne sais quoi...")
	}
}

pub trait Minimize {
	fn minimize_author(&self) -> String;
	fn minimize(&self) -> String {
		format!("Read more from {}", self.minimize_author())
	}
}


pub struct NewsArticle {
	pub headline: String,
    pub location: String,
    pub author: String,
    pub content: String,
}

pub struct Tweet {
	pub username: String,
    pub content: String,
    pub reply: bool,
    pub retweet: bool,
}

// implementing trait on types
impl Summary for NewsArticle {
	fn summarize(&self) -> String {
		format!("{}, by {} ({})", self.headline, self.author, self.location)
	}
}

impl Summary for Tweet {
	fn summarize(&self) -> String {
		format!("{}: {}", self.username, self.content)
	}
}

// using default implementation
impl Minimize for Tweet {
	fn minimize_author(&self) -> String {
		format!("@{}", self.username)
	}
}
impl SummaryDefaulted for NewsArticle {}
