use std::collections::HashMap;


pub fn main() {

	let v: Vec<i32> = Vec::new();
	// Note that we added a type annotation here. 
	// Because we aren’t inserting any values into this vector
	
	// initialize vec using macro `vec!`
	let v = vec![1,2,3];		// type: Vec<i32>

	// pushing values
	{
		let mut v = Vec::new();
		v.push(4);
		v.push(5);
		v.push(7);
	}	// <- v goes out of scope and is freed here

	// accessing elements

	let third = &v[2];	// type: &i32
	println!("the third element {}", third);
		
	match v.get(2) {
		Some(third) => println!("the third element is {}", &third),
		None => println!("There is no third element"), 
	}
		
	// accessing index that doesn't exists
	let v = vec![1,2,3,4,5];
	// let does_not_exist = &v[100];	// error[runtime]: this will cause a panic
	let does_not_exit = v.get(100);	// type: Option<&i32> // this won't


	let mut v = vec![1,2,3,4,5];
	let first = &v[0];
	// v.push(6);	// error: cannot borrow `v` as mutable because it is also borrowed as immutabl
	println!("the first element is: {}", first);


	// iterating over values
	for i in &v {
	}
	// modifying values
	for i in &mut v {
		*i += 50;
	}

	enum SpreadsheetCell {
		Int(i32),
		Float(f64),
		Text(String),
	}

	let row = vec![
		SpreadsheetCell::Int(3),
		SpreadsheetCell::Float(5.0),
		SpreadsheetCell::Text(String::from("something")),
	];

	// you can values of different types by using enums
	#[derive(Debug)]
	enum State {
		Invalid,
		Valid(f64)
	}
	let vec = vec![
		State::Invalid,
		State::Valid(32.0),
		State::Invalid,
	];

	for elem in &vec {
		println!("{:?}", elem)
	}


	// Example
	let mut v: Vec<i32>= vec![100, 5, 2, 5, 3, 1];	// 1, 2, 3, 5, 5, 100
	v.sort();
	let mut sum: f64 = 0.0;
	for &value in  &v {
		sum += value as f64;
	}

	let mut numbers: HashMap<i32, i32> = HashMap::new();
	for &x in &v {
		let count = numbers.entry(x as i32).or_insert(0);
		*count += 1;
	}

	let mut max = 1;
	let mut mode = -100000;
	for (&k, &v) in &numbers {
		if v > max {
			max = v;
			mode = k;
		} 
	}

	let mut median: f64 = -1.0;
	if v.len() % 2 == 0 {
		let half = v.len() / 2;
		median = (v[half] + v[half - 1]) as f64 / 2.0;
	} else {
		median = v[v.len() / 2] as f64;
	}

	println!("Mod =    {}", mode);
	println!("Median = {}", median);
	println!("Mean =   {}", sum / v.len() as f64);

}