

pub fn main() {

	let mut s = String::new();	  // type: String
	let data = "initial contents";	// type: &str
	let s = data.to_string();	  // type: String
	let s = String::from("initial contents");

	// NOTE: Remember that strings are UTF-8 encoded,
	let hello = String::from("السلام عليكم");
    let hello = String::from("Dobrý den");
    let hello = String::from("Hello");
    let hello = String::from("שָׁלוֹם");
    let hello = String::from("नमस्ते");
    let hello = String::from("こんにちは");
    let hello = String::from("안녕하세요");
    let hello = String::from("你好");
    let hello = String::from("Olá");
    let hello = String::from("Здравствуйте");
    let hello = String::from("Hola");

	let mut s = String::from("foo");
	s.push_str(" bar");
	// push_str takes parameter as &str
	let mut s1 = String::from("foo");
    let s2 = "bar";
    s1.push_str(s2);	// borrows str and gives it back
    println!("s2 is {}", s2);	// we need to use s2

	// push character
	let mut s = String::from("lo");
	s.push('l');	// push takes type: `ch`

	// using + operator

	let s1 = String::from("hello, ");
	let s2 = String::from("World!");
	let s3 = s1 + &s2;	// NOTE: s1 has been moved here and can no longer be used
	// NOTE: The reason we’re able to use &s2 in the call to add is that the compiler can coerce the &String argument into a &str.

	// Using the format macro
	let s1 = String::from("tic");
    let s2 = String::from("tac");
    let s3 = String::from("toe");
    let s = format!("{}-{}-{}", s1, s2, s3);


	// Indexing
	let s1 = String::from("hello");
    // let h = s1[0];	// error: `String` cannot be indexed by `{integer}`
	// NOTE: A String is a wrapper over a Vec<u8>.
	let hello = String::from("Hola");	// len is 4 each character in UTF-8 is 1 byte
	let hello = String::from("З3дравствуйте");	// len is 24 not 12
	// this stirng ecnoded in utf-8 is not 24 bytes long each character here in UTF-8 takes 2 bytes
	let hello = "Здравствуйте";
	let s = &hello[0..4];	// type: &str (actual bytes)
	// let s = &hello[0..1];	// error[runtime]: this will cause rust to panic
	// using `chars` extracts individual unicode scalar values
	for c in "नमस्ते".chars() {	// will returns six values
		println!(">{}", c);
	}

	// using `bytes` will print all the bytes one by one
	for b in "नमस्ते".bytes() {	// will print 18 values
		println!(">{}", b)
	}

}