
use std::collections::HashMap;
// unlike String and Vec, HashMap is not automatically brought in
// we have to `use` it

pub fn main() {

	let mut scores = HashMap::new();
	scores.insert(String::from("Blue"), 10);
	scores.insert(String::from("Red"), 50);

	// hash maps are homogeneous all keys have to be same type and values as well
	// using iterators with `collect` method
	let teams = vec![String::from("Blue"), String::from("Yellow")];
	let initial_scores = vec![10, 50];
	let mut scores: HashMap<_, _> = teams.into_iter().zip(initial_scores.into_iter()).collect();

	let field_name = String::from("Favorite color");
    let field_value = String::from("Blue");

    let mut map = HashMap::new();
    map.insert(field_name, field_value);
    // field_name and field_value are invalid at this point, try using them and
    // see what compiler error you get!

	let team_name = String::from("Blue");
	let value = scores.get(&team_name);

	if let Some(value) = value {
		println!("Value: {}", value);
	} else {
		println!("Value doesn't exists");
	}

	// iterating key, value pair

	for(key, value) in &scores {
		println!("{} {}", key, value);
		// key = String::from("something");
	}

	for(key, value) in &scores {
		println!("{} {}", key, value);
	}


	// insert only if entry exists
	scores.entry(String::from("Blue")).or_insert(50);
	// return mutable refrence of value if it exists or insert the default 
	// value and return as a mutable ref
	println!("{:#?}", scores);

	// updating a value
	let text = "hello world wonderful world world";
	let mut map = HashMap::new();	// type: HashMap<&str, i32> 

	for word in text.split_whitespace() {
		let count = map.entry(word).or_insert(0);
		*count += 1;	// &mut ref count goes out of scope so this is safe 
	}

	// since the keys are &str they need to live for as long as the map lives
	// in this case they will because text is store in the binary itself
	// and is always accessible
	{
		// let v =String::from("last");
		let k = "world";	// type: &str
		map.insert(k, 32);	// works: v will always be available

		let k2 = String::from("world");
		// map.insert(&k2, 20);	// error: `k2` does not live long enough
	}

	println!("{:?}", map);

}
// you can implete BuildHasher to use your own hashing function 
