
struct Cacher<T> 
where
	T: Fn(i32) -> i32,
{
	calculation: T,
	value: Option<i32>
}

impl<T> Cacher<T>  
where
	T: Fn(i32) -> i32,
{
	fn new(calculation: T) -> Cacher<T> {
		Cacher {
			calculation,
			value: None
		}
	}
	fn value(&mut self, arg: i32) -> i32 {
		match self.value {
			Some(value) => value,
			None => {
				let v = (self.calculation)(arg);
				self.value = Some(v);
				v
			}
		}
	}
}

fn generate_workout(random_number: i32, intensity: i32) {

	let mut expensive_result = Cacher::new(|num| {
		println!("calculating slowly ...");
		std::thread::sleep(std::time::Duration::from_secs(2));
		num
	} );

	if intensity < 25 {
		println!("Today, do {} pushups!", expensive_result.value(intensity));
		println!("Next, do {} situps!", expensive_result.value(intensity));
	} else {
		if random_number == 3 {
			println!("Take a break today! Remember to stay hydrated!");
		} else {
			println!(
				"Today, run for {} minutes!",
				expensive_result.value(intensity)
			);
		}
	}
}

fn main() {
	generate_workout(3,5);
	let x = 4;
	let equal_to_x = |z| z == x;
	let y = 4;
	assert!(equal_to_x(y));
	
	let x = vec![1,2,3];
	let y = vec![1,2,3];
	let equal_to_x2 = move |z| z == x;
	
	// println!("can't use x here: {:?}", x);	// error: can't use x after move
	assert!(equal_to_x2(y));

}
