use criterion::{black_box, criterion_group, criterion_main, Criterion, Benchmark, BenchmarkGroup};
use rand::{random, Rng, thread_rng};
use rust_als::als::ALS;

pub fn bench_train_50K_200K_20(c : &mut Criterion) {
    let n = 50_000;
    let m = 100_000;
    let k = 10;
    let mut als = ALS::new(n, m, k);
    for i_n in 0..n {
        for i_m in 0..m {
            if thread_rng().gen_bool(0.01) {
                als.add((i_n, i_m, thread_rng().gen_range(0.0..10.0)));
            }

        }
    }
    c
        .benchmark_group("slow training")
        .sample_size(20)
        .bench_function("bench_train_50K_200K_20", |b| b.iter(|| {
            als.train_for(1);
        }));
}

pub fn bench_pred_50K_200K_20(c : &mut Criterion) {
    let n = 50_000;
    let m = 100_000;
    let k = 10;
    let mut als = ALS::new(n, m, k);
    for i_n in 0..n {
        for i_m in 0..m {
            if thread_rng().gen_bool(0.01) {
                als.add((i_n, i_m, thread_rng().gen_range(0.0..10.0)));
            }

        }
    }
    als.train();
    c.bench_function("bench_pred_50K_200K_20", |b| b.iter(|| {
        als.predict_r_val(thread_rng().gen_range(0..n), thread_rng().gen_range(0..m));
    }));
}

criterion_group!(
    benches,
    bench_train_50K_200K_20,
    bench_pred_50K_200K_20,

);
criterion_main!(benches);