// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::proto;
use rusoto_core::request::HttpResponse;
use rusoto_core::signature::SignedRequest;
#[allow(unused_imports)]
use serde::{Deserialize, Serialize};

impl SageMakerClient {
    fn new_signed_request(&self, http_method: &str, request_uri: &str) -> SignedRequest {
        let mut request = SignedRequest::new(http_method, "sagemaker", &self.region, request_uri);
        request.set_endpoint_prefix("api.sagemaker".to_string());

        request.set_content_type("application/x-amz-json-1.1".to_owned());

        request
    }

    async fn sign_and_dispatch<E>(
        &self,
        request: SignedRequest,
        from_response: fn(BufferedHttpResponse) -> RusotoError<E>,
    ) -> Result<HttpResponse, RusotoError<E>> {
        let mut response = self.client.sign_and_dispatch(request).await?;
        if !response.status.is_success() {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            return Err(from_response(response));
        }

        Ok(response)
    }
}

use serde_json;
/// <p>A structure describing the source of an action.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ActionSource {
    /// <p>The ID of the source.</p>
    #[serde(rename = "SourceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_id: Option<String>,
    /// <p>The type of the source.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
    /// <p>The URI of the source.</p>
    #[serde(rename = "SourceUri")]
    pub source_uri: String,
}

/// <p>Lists the properties of an <i>action</i>. An action represents an action or activity. Some examples are a workflow step and a model deployment. Generally, an action involves at least one input artifact or output artifact.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ActionSummary {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    #[serde(rename = "ActionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
    /// <p>The name of the action.</p>
    #[serde(rename = "ActionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    /// <p>The type of the action.</p>
    #[serde(rename = "ActionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    /// <p>When the action was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>When the action was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The source of the action.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ActionSource>,
    /// <p>The status of the action.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddAssociationRequest {
    /// <p><p>The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.</p> <ul> <li> <p>ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.</p> </li> <li> <p>AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.</p> </li> <li> <p>DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.</p> </li> <li> <p>Produced - The source generated the destination. For example, a training job produced a model artifact.</p> </li> </ul></p>
    #[serde(rename = "AssociationType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub association_type: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    #[serde(rename = "DestinationArn")]
    pub destination_arn: String,
    /// <p>The ARN of the source.</p>
    #[serde(rename = "SourceArn")]
    pub source_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AddAssociationResponse {
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    #[serde(rename = "DestinationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_arn: Option<String>,
    /// <p>The ARN of the source.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AddTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
    #[serde(rename = "ResourceArn")]
    pub resource_arn: String,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    pub tags: Vec<Tag>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AddTagsOutput {
    /// <p>A list of tags associated with the Amazon SageMaker resource.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>Edge Manager agent version.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AgentVersion {
    /// <p>The number of Edge Manager agents.</p>
    #[serde(rename = "AgentCount")]
    pub agent_count: i64,
    /// <p>Version of the agent.</p>
    #[serde(rename = "Version")]
    pub version: String,
}

/// <p>This API is not supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Alarm {
    /// <p><p/></p>
    #[serde(rename = "AlarmName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alarm_name: Option<String>,
}

/// <p>Specifies the training algorithm to use in a <a>CreateTrainingJob</a> request.</p> <p>For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about using your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AlgorithmSpecification {
    /// <p>The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on AWS Marketplace. If you specify a value for this parameter, you can't specify a value for <code>TrainingImage</code>.</p>
    #[serde(rename = "AlgorithmName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub algorithm_name: Option<String>,
    /// <p><p>To generate and save time-series metrics during training, set to <code>true</code>. The default is <code>false</code> and time-series metrics aren&#39;t generated except in the following cases:</p> <ul> <li> <p>You use one of the Amazon SageMaker built-in algorithms</p> </li> <li> <p>You use one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html">Prebuilt Amazon SageMaker Docker Images</a>:</p> <ul> <li> <p>Tensorflow (version &gt;= 1.15)</p> </li> <li> <p>MXNet (version &gt;= 1.6)</p> </li> <li> <p>PyTorch (version &gt;= 1.3)</p> </li> </ul> </li> <li> <p>You specify at least one <a>MetricDefinition</a> </p> </li> </ul></p>
    #[serde(rename = "EnableSageMakerMetricsTimeSeries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_sage_maker_metrics_time_series: Option<bool>,
    /// <p>A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. Amazon SageMaker publishes each metric to Amazon CloudWatch.</p>
    #[serde(rename = "MetricDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_definitions: Option<Vec<MetricDefinition>>,
    /// <p>The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>
    #[serde(rename = "TrainingImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_image: Option<String>,
    /// <p>The input mode that the algorithm supports. For the input modes that Amazon SageMaker algorithms support, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. If an algorithm supports the <code>File</code> input mode, Amazon SageMaker downloads the training data from S3 to the provisioned ML storage Volume, and mounts the directory to docker volume for training container. If an algorithm supports the <code>Pipe</code> input mode, Amazon SageMaker streams data directly from S3 to the container. </p> <p> In File mode, make sure you provision ML storage volume with sufficient capacity to accommodate the data download from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container use ML storage volume to also store intermediate information, if any. </p> <p> For distributed algorithms using File mode, training data is distributed uniformly, and your training duration is predictable if the input data objects size is approximately same. Amazon SageMaker does not split the files any further for model training. If the object sizes are skewed, training won't be optimal as the data distribution is also skewed where one host in a training cluster is overloaded, thus becoming bottleneck in training. </p>
    #[serde(rename = "TrainingInputMode")]
    pub training_input_mode: String,
}

/// <p>Specifies the validation and image scan statuses of the algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AlgorithmStatusDetails {
    /// <p>The status of the scan of the algorithm's Docker image container.</p>
    #[serde(rename = "ImageScanStatuses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_scan_statuses: Option<Vec<AlgorithmStatusItem>>,
    /// <p>The status of algorithm validation.</p>
    #[serde(rename = "ValidationStatuses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_statuses: Option<Vec<AlgorithmStatusItem>>,
}

/// <p>Represents the overall status of an algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AlgorithmStatusItem {
    /// <p>if the overall status is <code>Failed</code>, the reason for the failure.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The name of the algorithm for which the overall status is being reported.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The current status.</p>
    #[serde(rename = "Status")]
    pub status: String,
}

/// <p>Provides summary information about an algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AlgorithmSummary {
    /// <p>The Amazon Resource Name (ARN) of the algorithm.</p>
    #[serde(rename = "AlgorithmArn")]
    pub algorithm_arn: String,
    /// <p>A brief description of the algorithm.</p>
    #[serde(rename = "AlgorithmDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub algorithm_description: Option<String>,
    /// <p>The name of the algorithm that is described by the summary.</p>
    #[serde(rename = "AlgorithmName")]
    pub algorithm_name: String,
    /// <p>The overall status of the algorithm.</p>
    #[serde(rename = "AlgorithmStatus")]
    pub algorithm_status: String,
    /// <p>A timestamp that shows when the algorithm was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
}

/// <p>Defines a training job and a batch transform job that Amazon SageMaker runs to validate your algorithm.</p> <p>The data provided in the validation profile is made available to your buyers on AWS Marketplace.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AlgorithmValidationProfile {
    /// <p>The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
    #[serde(rename = "ProfileName")]
    pub profile_name: String,
    /// <p>The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs to validate your algorithm.</p>
    #[serde(rename = "TrainingJobDefinition")]
    pub training_job_definition: TrainingJobDefinition,
    /// <p>The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker runs to validate your algorithm.</p>
    #[serde(rename = "TransformJobDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_job_definition: Option<TransformJobDefinition>,
}

/// <p>Specifies configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AlgorithmValidationSpecification {
    /// <p>An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch transform job that Amazon SageMaker runs to validate your algorithm.</p>
    #[serde(rename = "ValidationProfiles")]
    pub validation_profiles: Vec<AlgorithmValidationProfile>,
    /// <p>The IAM roles that Amazon SageMaker uses to run the training jobs.</p>
    #[serde(rename = "ValidationRole")]
    pub validation_role: String,
}

/// <p>Configures how labels are consolidated across human workers and processes output data. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AnnotationConsolidationConfig {
    /// <p><p>The Amazon Resource Name (ARN) of a Lambda function implements the logic for <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">annotation consolidation</a> and to process output data.</p> <p>This parameter is required for all labeling jobs. For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>AnnotationConsolidationLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda">Post-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as &quot;votes&quot; for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>rn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Semantic Segmentation Adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as &quot;votes&quot; for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic Segmentation Verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Bounding Box Adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Bounding Box Verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Detection Adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking Adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects that appear in a sequence of 3D point cloud frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation Adjustment</b> - Use this task type when you want workers to adjust a point-level semantic segmentation masks using a paint tool.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul></p>
    #[serde(rename = "AnnotationConsolidationLambdaArn")]
    pub annotation_consolidation_lambda_arn: String,
}

/// <p>Details about an Amazon SageMaker app.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppDetails {
    /// <p>The name of the app.</p>
    #[serde(rename = "AppName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_name: Option<String>,
    /// <p>The type of app.</p>
    #[serde(rename = "AppType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_type: Option<String>,
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name: Option<String>,
}

/// <p>The configuration for running a SageMaker image as a KernelGateway app.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AppImageConfigDetails {
    /// <p>The Amazon Resource Name (ARN) of the AppImageConfig.</p>
    #[serde(rename = "AppImageConfigArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_config_arn: Option<String>,
    /// <p>The name of the AppImageConfig. Must be unique to your account.</p>
    #[serde(rename = "AppImageConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_config_name: Option<String>,
    /// <p>When the AppImageConfig was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The configuration for the file system and kernels in the SageMaker image.</p>
    #[serde(rename = "KernelGatewayImageConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kernel_gateway_image_config: Option<KernelGatewayImageConfig>,
    /// <p>When the AppImageConfig was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
}

/// <p>Configuration to run a processing job in a specified container image.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AppSpecification {
    /// <p>The arguments for a container used to run a processing job.</p>
    #[serde(rename = "ContainerArguments")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_arguments: Option<Vec<String>>,
    /// <p>The entrypoint for a container used to run a processing job.</p>
    #[serde(rename = "ContainerEntrypoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_entrypoint: Option<Vec<String>>,
    /// <p>The container image to be run by the processing job.</p>
    #[serde(rename = "ImageUri")]
    pub image_uri: String,
}

/// <p>A structure describing the source of an artifact.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ArtifactSource {
    /// <p>A list of source types.</p>
    #[serde(rename = "SourceTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_types: Option<Vec<ArtifactSourceType>>,
    /// <p>The URI of the source.</p>
    #[serde(rename = "SourceUri")]
    pub source_uri: String,
}

/// <p>The ID and ID type of an artifact source.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ArtifactSourceType {
    /// <p>The type of ID.</p>
    #[serde(rename = "SourceIdType")]
    pub source_id_type: String,
    /// <p>The ID.</p>
    #[serde(rename = "Value")]
    pub value: String,
}

/// <p>Lists a summary of the properties of an artifact. An artifact represents a URI addressable object or data. Some examples are a dataset and a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ArtifactSummary {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    #[serde(rename = "ArtifactArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_arn: Option<String>,
    /// <p>The name of the artifact.</p>
    #[serde(rename = "ArtifactName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_name: Option<String>,
    /// <p>The type of the artifact.</p>
    #[serde(rename = "ArtifactType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_type: Option<String>,
    /// <p>When the artifact was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>When the artifact was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The source of the artifact.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ArtifactSource>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AssociateTrialComponentRequest {
    /// <p>The name of the component to associated with the trial.</p>
    #[serde(rename = "TrialComponentName")]
    pub trial_component_name: String,
    /// <p>The name of the trial to associate with.</p>
    #[serde(rename = "TrialName")]
    pub trial_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociateTrialComponentResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
    /// <p>The ARN of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
}

/// <p>Lists a summary of the properties of an association. An association is an entity that links other lineage or experiment entities. An example would be an association between a training job and a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AssociationSummary {
    /// <p>The type of the association.</p>
    #[serde(rename = "AssociationType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub association_type: Option<String>,
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the association was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    #[serde(rename = "DestinationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_arn: Option<String>,
    /// <p>The name of the destination.</p>
    #[serde(rename = "DestinationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_name: Option<String>,
    /// <p>The destination type.</p>
    #[serde(rename = "DestinationType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_type: Option<String>,
    /// <p>The ARN of the source.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
    /// <p>The name of the source.</p>
    #[serde(rename = "SourceName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_name: Option<String>,
    /// <p>The source type.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
}

/// <p>Configuration for Athena Dataset Definition input.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AthenaDatasetDefinition {
    #[serde(rename = "Catalog")]
    pub catalog: String,
    #[serde(rename = "Database")]
    pub database: String,
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data generated from an Athena query execution.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    #[serde(rename = "OutputCompression")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_compression: Option<String>,
    #[serde(rename = "OutputFormat")]
    pub output_format: String,
    /// <p>The location in Amazon S3 where Athena query results are stored.</p>
    #[serde(rename = "OutputS3Uri")]
    pub output_s3_uri: String,
    #[serde(rename = "QueryString")]
    pub query_string: String,
    #[serde(rename = "WorkGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub work_group: Option<String>,
}

/// <p>An Autopilot job returns recommendations, or candidates. Each candidate has futher details about the steps involved and the status.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AutoMLCandidate {
    /// <p>The name of the candidate.</p>
    #[serde(rename = "CandidateName")]
    pub candidate_name: String,
    /// <p>The AutoML candidate's properties.</p>
    #[serde(rename = "CandidateProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub candidate_properties: Option<CandidateProperties>,
    /// <p>The candidate's status.</p>
    #[serde(rename = "CandidateStatus")]
    pub candidate_status: String,
    /// <p>Information about the candidate's steps.</p>
    #[serde(rename = "CandidateSteps")]
    pub candidate_steps: Vec<AutoMLCandidateStep>,
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The end time.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The failure reason.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    #[serde(rename = "FinalAutoMLJobObjectiveMetric")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub final_auto_ml_job_objective_metric: Option<FinalAutoMLJobObjectiveMetric>,
    /// <p>Information about the inference container definitions.</p>
    #[serde(rename = "InferenceContainers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_containers: Option<Vec<AutoMLContainerDefinition>>,
    /// <p>The last modified time.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The objective's status.</p>
    #[serde(rename = "ObjectiveStatus")]
    pub objective_status: String,
}

/// <p>Information about the steps for a candidate and what step it is working on.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AutoMLCandidateStep {
    /// <p>The ARN for the candidate's step.</p>
    #[serde(rename = "CandidateStepArn")]
    pub candidate_step_arn: String,
    /// <p>The name for the candidate's step.</p>
    #[serde(rename = "CandidateStepName")]
    pub candidate_step_name: String,
    /// <p>Whether the candidate is at the transform, training, or processing step.</p>
    #[serde(rename = "CandidateStepType")]
    pub candidate_step_type: String,
}

/// <p>A channel is a named input source that training algorithms can consume. For more information, see .</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLChannel {
    /// <p>You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.</p>
    #[serde(rename = "CompressionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compression_type: Option<String>,
    /// <p>The data source for an AutoML channel.</p>
    #[serde(rename = "DataSource")]
    pub data_source: AutoMLDataSource,
    /// <p>The name of the target variable in supervised learning, usually represented by 'y'.</p>
    #[serde(rename = "TargetAttributeName")]
    pub target_attribute_name: String,
}

/// <p>A list of container definitions that describe the different containers that make up an AutoML candidate. For more information, see .</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AutoMLContainerDefinition {
    /// <p>The environment variables to set in the container. For more information, see .</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The ECR path of the container. For more information, see .</p>
    #[serde(rename = "Image")]
    pub image: String,
    /// <p>The location of the model artifacts. For more information, see .</p>
    #[serde(rename = "ModelDataUrl")]
    pub model_data_url: String,
}

/// <p>The data source for the Autopilot job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLDataSource {
    /// <p><p>The Amazon S3 location of the input data.</p> <note> <p>The input data must be in CSV format and contain at least 500 rows.</p> </note></p>
    #[serde(rename = "S3DataSource")]
    pub s3_data_source: AutoMLS3DataSource,
}

/// <p>The artifacts that are generated during an AutoML job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AutoMLJobArtifacts {
    /// <p>The URL of the notebook location.</p>
    #[serde(rename = "CandidateDefinitionNotebookLocation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub candidate_definition_notebook_location: Option<String>,
    /// <p>The URL of the notebook location.</p>
    #[serde(rename = "DataExplorationNotebookLocation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_exploration_notebook_location: Option<String>,
}

/// <p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLJobCompletionCriteria {
    /// <p>The maximum runtime, in seconds, an AutoML job has to complete.</p>
    #[serde(rename = "MaxAutoMLJobRuntimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_auto_ml_job_runtime_in_seconds: Option<i64>,
    /// <p>The maximum number of times a training job is allowed to run.</p>
    #[serde(rename = "MaxCandidates")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_candidates: Option<i64>,
    /// <p>The maximum time, in seconds, a training job is allowed to run as part of an AutoML job.</p>
    #[serde(rename = "MaxRuntimePerTrainingJobInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_runtime_per_training_job_in_seconds: Option<i64>,
}

/// <p>A collection of settings used for an AutoML job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLJobConfig {
    /// <p>How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.</p>
    #[serde(rename = "CompletionCriteria")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completion_criteria: Option<AutoMLJobCompletionCriteria>,
    /// <p>The security configuration for traffic encryption or Amazon VPC settings.</p>
    #[serde(rename = "SecurityConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_config: Option<AutoMLSecurityConfig>,
}

/// <p>Specifies a metric to minimize or maximize as the objective of a job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLJobObjective {
    /// <p><p>The name of the objective metric used to measure the predictive quality of a machine learning system. This metric is optimized during training to provide the best estimate for model parameter values from data.</p> <p>Here are the options:</p> <ul> <li> <p> <code>MSE</code>: The mean squared error (MSE) is the average of the squared differences between the predicted and actual values. It is used for regression. MSE values are always positive: the better a model is at predicting the actual values, the smaller the MSE value. When the data contains outliers, they tend to dominate the MSE, which might cause subpar prediction performance.</p> </li> <li> <p> <code>Accuracy</code>: The ratio of the number of correctly classified items to the total number of (correctly and incorrectly) classified items. It is used for binary and multiclass classification. It measures how close the predicted class values are to the actual values. Accuracy values vary between zero and one: one indicates perfect accuracy and zero indicates perfect inaccuracy.</p> </li> <li> <p> <code>F1</code>: The F1 score is the harmonic mean of the precision and recall. It is used for binary classification into classes traditionally referred to as positive and negative. Predictions are said to be true when they match their actual (correct) class and false when they do not. Precision is the ratio of the true positive predictions to all positive predictions (including the false positives) in a data set and measures the quality of the prediction when it predicts the positive class. Recall (or sensitivity) is the ratio of the true positive predictions to all actual positive instances and measures how completely a model predicts the actual class members in a data set. The standard F1 score weighs precision and recall equally. But which metric is paramount typically depends on specific aspects of a problem. F1 scores vary between zero and one: one indicates the best possible performance and zero the worst.</p> </li> <li> <p> <code>AUC</code>: The area under the curve (AUC) metric is used to compare and evaluate binary classification by algorithms such as logistic regression that return probabilities. A threshold is needed to map the probabilities into classifications. The relevant curve is the receiver operating characteristic curve that plots the true positive rate (TPR) of predictions (or recall) against the false positive rate (FPR) as a function of the threshold value, above which a prediction is considered positive. Increasing the threshold results in fewer false positives but more false negatives. AUC is the area under this receiver operating characteristic curve and so provides an aggregated measure of the model performance across all possible classification thresholds. The AUC score can also be interpreted as the probability that a randomly selected positive data point is more likely to be predicted positive than a randomly selected negative example. AUC scores vary between zero and one: a score of one indicates perfect accuracy and a score of one half indicates that the prediction is not better than a random classifier. Values under one half predict less accurately than a random predictor. But such consistently bad predictors can simply be inverted to obtain better than random predictors.</p> </li> <li> <p> <code>F1macro</code>: The F1macro score applies F1 scoring to multiclass classification. In this context, you have multiple classes to predict. You just calculate the precision and recall for each class as you did for the positive class in binary classification. Then, use these values to calculate the F1 score for each class and average them to obtain the F1macro score. F1macro scores vary between zero and one: one indicates the best possible performance and zero the worst.</p> </li> </ul> <p>If you do not specify a metric explicitly, the default behavior is to automatically use:</p> <ul> <li> <p> <code>MSE</code>: for regression.</p> </li> <li> <p> <code>F1</code>: for binary classification</p> </li> <li> <p> <code>Accuracy</code>: for multiclass classification.</p> </li> </ul></p>
    #[serde(rename = "MetricName")]
    pub metric_name: String,
}

/// <p>Provides a summary about an AutoML job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AutoMLJobSummary {
    /// <p>The ARN of the AutoML job.</p>
    #[serde(rename = "AutoMLJobArn")]
    pub auto_ml_job_arn: String,
    /// <p>The name of the AutoML you are requesting.</p>
    #[serde(rename = "AutoMLJobName")]
    pub auto_ml_job_name: String,
    /// <p>The secondary status of the AutoML job.</p>
    #[serde(rename = "AutoMLJobSecondaryStatus")]
    pub auto_ml_job_secondary_status: String,
    /// <p>The status of the AutoML job.</p>
    #[serde(rename = "AutoMLJobStatus")]
    pub auto_ml_job_status: String,
    /// <p>When the AutoML job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The end time of an AutoML job.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The failure reason of an AutoML job.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>When the AutoML job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The list of reasons for partial failures within an AutoML job.</p>
    #[serde(rename = "PartialFailureReasons")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub partial_failure_reasons: Option<Vec<AutoMLPartialFailureReason>>,
}

/// <p>The output data configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLOutputDataConfig {
    /// <p>The AWS KMS encryption key ID.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The Amazon S3 output path. Must be 128 characters or less.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>The reason for a partial failure of an AutoML job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct AutoMLPartialFailureReason {
    /// <p>The message containing the reason for a partial failure of an AutoML job.</p>
    #[serde(rename = "PartialFailureMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub partial_failure_message: Option<String>,
}

/// <p>The Amazon S3 data source.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLS3DataSource {
    /// <p>The data type.</p>
    #[serde(rename = "S3DataType")]
    pub s3_data_type: String,
    /// <p>The URL to the Amazon S3 data source.</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>Security options.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoMLSecurityConfig {
    /// <p>Whether to use traffic encryption between the container layers.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>The key used to encrypt stored data.</p>
    #[serde(rename = "VolumeKmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_kms_key_id: Option<String>,
    /// <p>The VPC configuration.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

/// <p>Currently, the <code>AutoRollbackConfig</code> API is not supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct AutoRollbackConfig {
    /// <p><p/></p>
    #[serde(rename = "Alarms")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub alarms: Option<Vec<Alarm>>,
}

/// <p>Contains bias metrics for a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Bias {
    /// <p>The bias report for a model</p>
    #[serde(rename = "Report")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub report: Option<MetricsSource>,
}

/// <p>Currently, the <code>BlueGreenUpdatePolicy</code> API is not supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct BlueGreenUpdatePolicy {
    /// <p><p/></p>
    #[serde(rename = "MaximumExecutionTimeoutInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub maximum_execution_timeout_in_seconds: Option<i64>,
    /// <p><p/></p>
    #[serde(rename = "TerminationWaitInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub termination_wait_in_seconds: Option<i64>,
    /// <p><p/></p>
    #[serde(rename = "TrafficRoutingConfiguration")]
    pub traffic_routing_configuration: TrafficRoutingConfig,
}

/// <p>Details on the cache hit of a pipeline execution step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CacheHitResult {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "SourcePipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_pipeline_execution_arn: Option<String>,
}

/// <p>Metadata about a callback step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CallbackStepMetadata {
    /// <p>The pipeline generated token from the Amazon SQS queue.</p>
    #[serde(rename = "CallbackToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub callback_token: Option<String>,
    /// <p>A list of the output parameters of the callback step.</p>
    #[serde(rename = "OutputParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_parameters: Option<Vec<OutputParameter>>,
    /// <p>The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the callback step.</p>
    #[serde(rename = "SqsQueueUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sqs_queue_url: Option<String>,
}

/// <p>The location of artifacts for an AutoML candidate job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CandidateArtifactLocations {
    /// <p>The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.</p>
    #[serde(rename = "Explainability")]
    pub explainability: String,
}

/// <p>The properties of an AutoML candidate job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CandidateProperties {
    /// <p>The Amazon S3 prefix to the artifacts generated for an AutoML candidate.</p>
    #[serde(rename = "CandidateArtifactLocations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub candidate_artifact_locations: Option<CandidateArtifactLocations>,
}

/// <p>Currently, the <code>CapacitySize</code> API is not supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CapacitySize {
    /// <p>This API is not supported.</p>
    #[serde(rename = "Type")]
    pub type_: String,
    /// <p><p/></p>
    #[serde(rename = "Value")]
    pub value: i64,
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CaptureContentTypeHeader {
    /// <p><p/></p>
    #[serde(rename = "CsvContentTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub csv_content_types: Option<Vec<String>>,
    /// <p><p/></p>
    #[serde(rename = "JsonContentTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub json_content_types: Option<Vec<String>>,
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CaptureOption {
    /// <p><p/></p>
    #[serde(rename = "CaptureMode")]
    pub capture_mode: String,
}

/// <p>A list of categorical hyperparameters to tune.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CategoricalParameterRange {
    /// <p>The name of the categorical hyperparameter to tune.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>A list of the categories for the hyperparameter.</p>
    #[serde(rename = "Values")]
    pub values: Vec<String>,
}

/// <p>Defines the possible values for a categorical hyperparameter.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CategoricalParameterRangeSpecification {
    /// <p>The allowed categories for the hyperparameter.</p>
    #[serde(rename = "Values")]
    pub values: Vec<String>,
}

/// <p>A channel is a named input source that training algorithms can consume. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Channel {
    /// <p>The name of the channel. </p>
    #[serde(rename = "ChannelName")]
    pub channel_name: String,
    /// <p>If training data is compressed, the compression type. The default value is <code>None</code>. <code>CompressionType</code> is used only in Pipe input mode. In File mode, leave this field unset or set it to None.</p>
    #[serde(rename = "CompressionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compression_type: Option<String>,
    /// <p>The MIME type of the data.</p>
    #[serde(rename = "ContentType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    /// <p>The location of the channel data.</p>
    #[serde(rename = "DataSource")]
    pub data_source: DataSource,
    /// <p>(Optional) The input mode to use for the data channel in a training job. If you don't set a value for <code>InputMode</code>, Amazon SageMaker uses the value set for <code>TrainingInputMode</code>. Use this parameter to override the <code>TrainingInputMode</code> setting in a <a>AlgorithmSpecification</a> request when you have a channel that needs a different input mode from the training job's general setting. To download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned ML storage volume, and mount the directory to a Docker volume, use <code>File</code> input mode. To stream data directly from Amazon S3 to the container, choose <code>Pipe</code> input mode.</p> <p>To use a model for incremental training, choose <code>File</code> input model.</p>
    #[serde(rename = "InputMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_mode: Option<String>,
    /// <p><p/> <p>Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps each individual S3 object in a RecordIO record. If the input data is already in RecordIO format, you don&#39;t need to set this attribute. For more information, see <a href="https://mxnet.apache.org/api/architecture/note_data_loading#data-format">Create a Dataset Using RecordIO</a>. </p> <p>In File mode, leave this field unset or set it to None.</p></p>
    #[serde(rename = "RecordWrapperType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub record_wrapper_type: Option<String>,
    /// <p>A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for <code>S3DataType</code>, this shuffles the results of the S3 key prefix matches. If you use <code>ManifestFile</code>, the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is shuffled. The shuffling order is determined using the <code>Seed</code> value.</p> <p>For Pipe input mode, shuffling is done at the start of every epoch. With large datasets this ensures that the order of the training data is different for each epoch, it helps reduce bias and possible overfitting. In a multi-node training job when ShuffleConfig is combined with <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.</p>
    #[serde(rename = "ShuffleConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub shuffle_config: Option<ShuffleConfig>,
}

/// <p>Defines a named input source, called a channel, to be used by an algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ChannelSpecification {
    /// <p>A brief description of the channel.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>Indicates whether the channel is required by the algorithm.</p>
    #[serde(rename = "IsRequired")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_required: Option<bool>,
    /// <p>The name of the channel.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The allowed compression types, if data compression is used.</p>
    #[serde(rename = "SupportedCompressionTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_compression_types: Option<Vec<String>>,
    /// <p>The supported MIME types for the data.</p>
    #[serde(rename = "SupportedContentTypes")]
    pub supported_content_types: Vec<String>,
    /// <p>The allowed input mode, either FILE or PIPE.</p> <p>In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.</p> <p>In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>
    #[serde(rename = "SupportedInputModes")]
    pub supported_input_modes: Vec<String>,
}

/// <p>Contains information about the output location for managed spot training checkpoint data. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CheckpointConfig {
    /// <p>(Optional) The local directory where checkpoints are written. The default directory is <code>/opt/ml/checkpoints/</code>. </p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    /// <p>Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example, <code>s3://bucket-name/key-name-prefix</code>.</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>Specifies summary information about a Git repository.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CodeRepositorySummary {
    /// <p>The Amazon Resource Name (ARN) of the Git repository.</p>
    #[serde(rename = "CodeRepositoryArn")]
    pub code_repository_arn: String,
    /// <p>The name of the Git repository.</p>
    #[serde(rename = "CodeRepositoryName")]
    pub code_repository_name: String,
    /// <p>The date and time that the Git repository was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.</p>
    #[serde(rename = "GitConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub git_config: Option<GitConfig>,
    /// <p>The date and time that the Git repository was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
}

/// <p>Use this parameter to configure your Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CognitoConfig {
    /// <p>The client ID for your Amazon Cognito user pool.</p>
    #[serde(rename = "ClientId")]
    pub client_id: String,
    /// <p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> user pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web or mobile app through Amazon Cognito. Your users can also sign in through social identity providers like Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>
    #[serde(rename = "UserPool")]
    pub user_pool: String,
}

/// <p>Identifies a Amazon Cognito user group. A user group can be used in on or more work teams.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CognitoMemberDefinition {
    /// <p>An identifier for an application client. You must create the app client ID using Amazon Cognito.</p>
    #[serde(rename = "ClientId")]
    pub client_id: String,
    /// <p>An identifier for a user group.</p>
    #[serde(rename = "UserGroup")]
    pub user_group: String,
    /// <p>An identifier for a user pool. The user pool must be in the same region as the service that you are calling.</p>
    #[serde(rename = "UserPool")]
    pub user_pool: String,
}

/// <p>Configuration information for the Debugger output tensor collections.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CollectionConfiguration {
    /// <p>The name of the tensor collection. The name must be unique relative to other rule configuration names.</p>
    #[serde(rename = "CollectionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub collection_name: Option<String>,
    /// <p>Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>, <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>, <code>"tensor_names"</code>, and <code>"save_histogram"</code>.</p>
    #[serde(rename = "CollectionParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub collection_parameters: Option<::std::collections::HashMap<String, String>>,
}

/// <p>A summary of a model compilation job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CompilationJobSummary {
    /// <p>The time when the model compilation job completed.</p>
    #[serde(rename = "CompilationEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the model compilation job.</p>
    #[serde(rename = "CompilationJobArn")]
    pub compilation_job_arn: String,
    /// <p>The name of the model compilation job that you want a summary for.</p>
    #[serde(rename = "CompilationJobName")]
    pub compilation_job_name: String,
    /// <p>The status of the model compilation job.</p>
    #[serde(rename = "CompilationJobStatus")]
    pub compilation_job_status: String,
    /// <p>The time when the model compilation job started.</p>
    #[serde(rename = "CompilationStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_start_time: Option<f64>,
    /// <p>The type of device that the model will run on after the compilation job has completed.</p>
    #[serde(rename = "CompilationTargetDevice")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_target_device: Option<String>,
    /// <p>The type of accelerator that the model will run on after the compilation job has completed.</p>
    #[serde(rename = "CompilationTargetPlatformAccelerator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_target_platform_accelerator: Option<String>,
    /// <p>The type of architecture that the model will run on after the compilation job has completed.</p>
    #[serde(rename = "CompilationTargetPlatformArch")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_target_platform_arch: Option<String>,
    /// <p>The type of OS that the model will run on after the compilation job has completed.</p>
    #[serde(rename = "CompilationTargetPlatformOs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_target_platform_os: Option<String>,
    /// <p>The time when the model compilation job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The time when the model compilation job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
}

/// <p>Metadata for a Condition step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ConditionStepMetadata {
    /// <p>The outcome of the Condition step evaluation.</p>
    #[serde(rename = "Outcome")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub outcome: Option<String>,
}

/// <p>Describes the container, as part of model definition.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ContainerDefinition {
    /// <p>This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.</p> <p>When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and Metrics to Monitor an Inference Pipeline</a>. If you don't specify a value for this parameter for a <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically assigned based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an inference pipeline, you must specify a value for the <code>ContainerHostName</code> parameter of every <code>ContainerDefinition</code> in that pipeline.</p>
    #[serde(rename = "ContainerHostname")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_hostname: Option<String>,
    /// <p>The environment variables to set in the Docker container. Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map. </p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a> </p>
    #[serde(rename = "Image")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image: Option<String>,
    /// <p>Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html">Use a Private Docker Registry for Real-Time Inference Containers</a> </p>
    #[serde(rename = "ImageConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_config: Option<ImageConfig>,
    /// <p>Whether the container hosts a single model or multiple models.</p>
    #[serde(rename = "Mode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mode: Option<String>,
    /// <p><p>The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Common Parameters</a>. </p> <note> <p>The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating.</p> </note> <p>If you provide a value for this parameter, Amazon SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management User Guide</i>.</p> <important> <p>If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3 path to the model artifacts in <code>ModelDataUrl</code>.</p> </important></p>
    #[serde(rename = "ModelDataUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_data_url: Option<String>,
    /// <p>The name or Amazon Resource Name (ARN) of the model package to use to create the model.</p>
    #[serde(rename = "ModelPackageName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_name: Option<String>,
    /// <p>Specifies additional configuration for multi-model endpoints.</p>
    #[serde(rename = "MultiModelConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub multi_model_config: Option<MultiModelConfig>,
}

/// <p>A structure describing the source of a context.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ContextSource {
    /// <p>The ID of the source.</p>
    #[serde(rename = "SourceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_id: Option<String>,
    /// <p>The type of the source.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
    /// <p>The URI of the source.</p>
    #[serde(rename = "SourceUri")]
    pub source_uri: String,
}

/// <p>Lists a summary of the properties of a context. A context provides a logical grouping of other entities.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ContextSummary {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    #[serde(rename = "ContextArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_arn: Option<String>,
    /// <p>The name of the context.</p>
    #[serde(rename = "ContextName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_name: Option<String>,
    /// <p>The type of the context.</p>
    #[serde(rename = "ContextType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_type: Option<String>,
    /// <p>When the context was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>When the context was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The source of the context.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ContextSource>,
}

/// <p>A list of continuous hyperparameters to tune.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ContinuousParameterRange {
    /// <p>The maximum value for the hyperparameter. The tuning job uses floating-point values between <code>MinValue</code> value and this value for tuning.</p>
    #[serde(rename = "MaxValue")]
    pub max_value: String,
    /// <p>The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and <code>MaxValue</code>for tuning.</p>
    #[serde(rename = "MinValue")]
    pub min_value: String,
    /// <p>The name of the continuous hyperparameter to tune.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p><p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> <dt>ReverseLogarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p> <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.</p> </dd> </dl></p>
    #[serde(rename = "ScalingType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scaling_type: Option<String>,
}

/// <p>Defines the possible values for a continuous hyperparameter.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ContinuousParameterRangeSpecification {
    /// <p>The maximum floating-point value allowed.</p>
    #[serde(rename = "MaxValue")]
    pub max_value: String,
    /// <p>The minimum floating-point value allowed.</p>
    #[serde(rename = "MinValue")]
    pub min_value: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateActionRequest {
    /// <p>The name of the action. Must be unique to your account in an AWS Region.</p>
    #[serde(rename = "ActionName")]
    pub action_name: String,
    /// <p>The action type.</p>
    #[serde(rename = "ActionType")]
    pub action_type: String,
    /// <p>The description of the action.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>A list of properties to add to the action.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>The source type, ID, and URI.</p>
    #[serde(rename = "Source")]
    pub source: ActionSource,
    /// <p>The status of the action.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>A list of tags to apply to the action.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateActionResponse {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    #[serde(rename = "ActionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAlgorithmInput {
    /// <p>A description of the algorithm.</p>
    #[serde(rename = "AlgorithmDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub algorithm_description: Option<String>,
    /// <p>The name of the algorithm.</p>
    #[serde(rename = "AlgorithmName")]
    pub algorithm_name: String,
    /// <p>Whether to certify the algorithm so that it can be listed in AWS Marketplace.</p>
    #[serde(rename = "CertifyForMarketplace")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certify_for_marketplace: Option<bool>,
    /// <p><p>Specifies details about inference jobs that the algorithm runs, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the algorithm supports for inference.</p> </li> </ul></p>
    #[serde(rename = "InferenceSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_specification: Option<InferenceSpecification>,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p><p>Specifies details about training jobs run by this algorithm, including the following:</p> <ul> <li> <p>The Amazon ECR path of the container and the version digest of the algorithm.</p> </li> <li> <p>The hyperparameters that the algorithm supports.</p> </li> <li> <p>The instance types that the algorithm supports for training.</p> </li> <li> <p>Whether the algorithm supports distributed training.</p> </li> <li> <p>The metrics that the algorithm emits to Amazon CloudWatch.</p> </li> <li> <p>Which metrics that the algorithm emits can be used as the objective metric for hyperparameter tuning jobs.</p> </li> <li> <p>The input channels that the algorithm supports for training data. For example, an algorithm might support <code>train</code>, <code>validation</code>, and <code>test</code> channels.</p> </li> </ul></p>
    #[serde(rename = "TrainingSpecification")]
    pub training_specification: TrainingSpecification,
    /// <p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the algorithm's training code and, optionally, one or more batch transform jobs that Amazon SageMaker runs to test the algorithm's inference code.</p>
    #[serde(rename = "ValidationSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_specification: Option<AlgorithmValidationSpecification>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAlgorithmOutput {
    /// <p>The Amazon Resource Name (ARN) of the new algorithm.</p>
    #[serde(rename = "AlgorithmArn")]
    pub algorithm_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAppImageConfigRequest {
    /// <p>The name of the AppImageConfig. Must be unique to your account.</p>
    #[serde(rename = "AppImageConfigName")]
    pub app_image_config_name: String,
    /// <p>The KernelGatewayImageConfig.</p>
    #[serde(rename = "KernelGatewayImageConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kernel_gateway_image_config: Option<KernelGatewayImageConfig>,
    /// <p>A list of tags to apply to the AppImageConfig.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAppImageConfigResponse {
    /// <p>The Amazon Resource Name (ARN) of the AppImageConfig.</p>
    #[serde(rename = "AppImageConfigArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_config_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAppRequest {
    /// <p>The name of the app.</p>
    #[serde(rename = "AppName")]
    pub app_name: String,
    /// <p>The type of app. Supported apps are <code>JupyterServer</code> and <code>KernelGateway</code>. <code>TensorBoard</code> is not supported.</p>
    #[serde(rename = "AppType")]
    pub app_type: String,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
    #[serde(rename = "ResourceSpec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_spec: Option<ResourceSpec>,
    /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAppResponse {
    /// <p>The Amazon Resource Name (ARN) of the app.</p>
    #[serde(rename = "AppArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateArtifactRequest {
    /// <p>The name of the artifact. Must be unique to your account in an AWS Region.</p>
    #[serde(rename = "ArtifactName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_name: Option<String>,
    /// <p>The artifact type.</p>
    #[serde(rename = "ArtifactType")]
    pub artifact_type: String,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>A list of properties to add to the artifact.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>The ID, ID type, and URI of the source.</p>
    #[serde(rename = "Source")]
    pub source: ArtifactSource,
    /// <p>A list of tags to apply to the artifact.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateArtifactResponse {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    #[serde(rename = "ArtifactArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateAutoMLJobRequest {
    /// <p>Contains <code>CompletionCriteria</code> and <code>SecurityConfig</code> settings for the AutoML job.</p>
    #[serde(rename = "AutoMLJobConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_config: Option<AutoMLJobConfig>,
    /// <p>Identifies an Autopilot job. The name must be unique to your account and is case-insensitive.</p>
    #[serde(rename = "AutoMLJobName")]
    pub auto_ml_job_name: String,
    /// <p>Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it.</p>
    #[serde(rename = "AutoMLJobObjective")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_objective: Option<AutoMLJobObjective>,
    /// <p>Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>
    #[serde(rename = "GenerateCandidateDefinitionsOnly")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generate_candidate_definitions_only: Option<bool>,
    /// <p>An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV. Minimum of 500 rows.</p>
    #[serde(rename = "InputDataConfig")]
    pub input_data_config: Vec<AutoMLChannel>,
    /// <p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>
    #[serde(rename = "ModelDeployConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_deploy_config: Option<ModelDeployConfig>,
    /// <p>Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.</p>
    #[serde(rename = "OutputDataConfig")]
    pub output_data_config: AutoMLOutputDataConfig,
    /// <p>Defines the type of supervised learning available for the candidates. Options include: <code>BinaryClassification</code>, <code>MulticlassClassification</code>, and <code>Regression</code>. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"> Amazon SageMaker Autopilot problem types and algorithm support</a>.</p>
    #[serde(rename = "ProblemType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub problem_type: Option<String>,
    /// <p>The ARN of the role that is used to access the data.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateAutoMLJobResponse {
    /// <p>The unique ARN that is assigned to the AutoML job when it is created.</p>
    #[serde(rename = "AutoMLJobArn")]
    pub auto_ml_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCodeRepositoryInput {
    /// <p>The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
    #[serde(rename = "CodeRepositoryName")]
    pub code_repository_name: String,
    /// <p>Specifies details about the repository, including the URL where the repository is located, the default branch, and credentials to use to access the repository.</p>
    #[serde(rename = "GitConfig")]
    pub git_config: GitConfig,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateCodeRepositoryOutput {
    /// <p>The Amazon Resource Name (ARN) of the new repository.</p>
    #[serde(rename = "CodeRepositoryArn")]
    pub code_repository_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateCompilationJobRequest {
    /// <p>A name for the model compilation job. The name must be unique within the AWS Region and within your AWS account. </p>
    #[serde(rename = "CompilationJobName")]
    pub compilation_job_name: String,
    /// <p>Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>
    #[serde(rename = "InputConfig")]
    pub input_config: InputConfig,
    /// <p>Provides information about the output location for the compiled model and the target device the model runs on.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: OutputConfig,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. </p> <p>During model compilation, Amazon SageMaker needs your permission to:</p> <ul> <li> <p>Read input data from an S3 bucket</p> </li> <li> <p>Write model artifacts to an S3 bucket</p> </li> <li> <p>Write logs to Amazon CloudWatch Logs</p> </li> <li> <p>Publish metrics to Amazon CloudWatch</p> </li> </ul> <p>You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a> </p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>
    #[serde(rename = "StoppingCondition")]
    pub stopping_condition: StoppingCondition,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<NeoVpcConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateCompilationJobResponse {
    /// <p><p>If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the following data in JSON format:</p> <ul> <li> <p> <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.</p> </li> </ul></p>
    #[serde(rename = "CompilationJobArn")]
    pub compilation_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateContextRequest {
    /// <p>The name of the context. Must be unique to your account in an AWS Region.</p>
    #[serde(rename = "ContextName")]
    pub context_name: String,
    /// <p>The context type.</p>
    #[serde(rename = "ContextType")]
    pub context_type: String,
    /// <p>The description of the context.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>A list of properties to add to the context.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>The source type, ID, and URI.</p>
    #[serde(rename = "Source")]
    pub source: ContextSource,
    /// <p>A list of tags to apply to the context.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateContextResponse {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    #[serde(rename = "ContextArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDataQualityJobDefinitionRequest {
    /// <p>Specifies the container that runs the monitoring job.</p>
    #[serde(rename = "DataQualityAppSpecification")]
    pub data_quality_app_specification: DataQualityAppSpecification,
    /// <p>Configures the constraints and baselines for the monitoring job.</p>
    #[serde(rename = "DataQualityBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_quality_baseline_config: Option<DataQualityBaselineConfig>,
    /// <p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.</p>
    #[serde(rename = "DataQualityJobInput")]
    pub data_quality_job_input: DataQualityJobInput,
    #[serde(rename = "DataQualityJobOutputConfig")]
    pub data_quality_job_output_config: MonitoringOutputConfig,
    /// <p>The name for the monitoring job definition.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>Specifies networking configuration for the monitoring job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateDataQualityJobDefinitionResponse {
    /// <p>The Amazon Resource Name (ARN) of the job definition.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDeviceFleetRequest {
    /// <p>A description of the fleet.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the fleet that the device belongs to.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>Whether to create an AWS IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p> <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>
    #[serde(rename = "EnableIotRoleAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_iot_role_alias: Option<bool>,
    /// <p>The output configuration for storing sample data collected by the fleet.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: EdgeOutputConfig,
    /// <p>The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>Creates tags for the specified fleet.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateDomainRequest {
    /// <p><p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li> <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p> </li> </ul></p>
    #[serde(rename = "AppNetworkAccessType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_network_access_type: Option<String>,
    /// <p>The mode of authentication that members use to access the domain.</p>
    #[serde(rename = "AuthMode")]
    pub auth_mode: String,
    /// <p>The default settings to use to create a user profile when <code>UserSettings</code> isn't specified in the call to the <code>CreateUserProfile</code> API.</p> <p> <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code>.</p>
    #[serde(rename = "DefaultUserSettings")]
    pub default_user_settings: UserSettings,
    /// <p>A name for the domain.</p>
    #[serde(rename = "DomainName")]
    pub domain_name: String,
    /// <p>SageMaker uses AWS KMS to encrypt the EFS volume attached to the domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The VPC subnets that Studio uses for communication.</p>
    #[serde(rename = "SubnetIds")]
    pub subnet_ids: Vec<String>,
    /// <p>Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the <code>Search</code> API.</p> <p>Tags that you specify for the Domain are also added to all Apps that the Domain launches.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
    #[serde(rename = "VpcId")]
    pub vpc_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateDomainResponse {
    /// <p>The Amazon Resource Name (ARN) of the created domain.</p>
    #[serde(rename = "DomainArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_arn: Option<String>,
    /// <p>The URL to the created domain.</p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEdgePackagingJobRequest {
    /// <p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>
    #[serde(rename = "CompilationJobName")]
    pub compilation_job_name: String,
    /// <p>The name of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobName")]
    pub edge_packaging_job_name: String,
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The version of the model.</p>
    #[serde(rename = "ModelVersion")]
    pub model_version: String,
    /// <p>Provides information about the output location for the packaged model.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: EdgeOutputConfig,
    /// <p>The CMK to use when encrypting the EBS volume the edge packaging job runs on.</p>
    #[serde(rename = "ResourceKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_key: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact SageMaker Neo.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Creates tags for the packaging job.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEndpointConfigInput {
    #[serde(rename = "DataCaptureConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_capture_config: Option<DataCaptureConfig>,
    /// <p>The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request. </p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
    /// <p><p>The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.</p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in AWS KMS </a> </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can&#39;t request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note></p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
    #[serde(rename = "ProductionVariants")]
    pub production_variants: Vec<ProductionVariant>,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateEndpointConfigOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint configuration. </p>
    #[serde(rename = "EndpointConfigArn")]
    pub endpoint_config_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEndpointInput {
    /// <p>The name of an endpoint configuration. For more information, see <a>CreateEndpointConfig</a>. </p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
    /// <p>The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and must be matched in .</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateEndpointOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    #[serde(rename = "EndpointArn")]
    pub endpoint_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateExperimentRequest {
    /// <p>The description of the experiment.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the experiment as displayed. The name doesn't need to be unique. If you don't specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the experiment. The name must be unique in your AWS account and is not case-sensitive.</p>
    #[serde(rename = "ExperimentName")]
    pub experiment_name: String,
    /// <p>A list of tags to associate with the experiment. You can use <a>Search</a> API to search on the tags.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateExperimentResponse {
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    #[serde(rename = "ExperimentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateFeatureGroupRequest {
    /// <p>A free-form description of a <code>FeatureGroup</code>.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p><p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a <code>FeatureGroup</code>.</p> <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p> <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p> <ul> <li> <p> <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.</p> </li> <li> <p> <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The following formats are supported <code>yyyy-MM-dd&#39;T&#39;HH:mm:ssZ</code> and <code>yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>, and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively. <code>&#39;T&#39;</code> and <code>Z</code> are constants.</p> </li> </ul></p>
    #[serde(rename = "EventTimeFeatureName")]
    pub event_time_feature_name: String,
    /// <p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per <code>Feature</code>. </p> <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>.</p> <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code> </p> <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureDefinitions")]
    pub feature_definitions: Vec<FeatureDefinition>,
    /// <p><p>The name of the <code>FeatureGroup</code>. The name must be unique within an AWS Region in an AWS account. The name:</p> <ul> <li> <p>Must start and end with an alphanumeric character.</p> </li> <li> <p>Can only contain alphanumeric character and hyphens. Spaces are not allowed. </p> </li> </ul></p>
    #[serde(rename = "FeatureGroupName")]
    pub feature_group_name: String,
    /// <p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p> <ul> <li> <p>The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.</p> </li> <li> <p>A configuration for an AWS Glue or AWS Hive data cataolgue. </p> </li> <li> <p>An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>.</p> </li> </ul> <p>To learn more about this parameter, see <a>OfflineStoreConfig</a>.</p>
    #[serde(rename = "OfflineStoreConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_config: Option<OfflineStoreConfig>,
    /// <p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>; the default value is <code>False</code>.</p> <p>You can also include an AWS KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the <code>OnlineStore</code>.</p>
    #[serde(rename = "OnlineStoreConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub online_store_config: Option<OnlineStoreConfig>,
    /// <p><p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions&#39; names.</p> <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.</p> <p>This name:</p> <ul> <li> <p>Must start and end with an alphanumeric character.</p> </li> <li> <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed. </p> </li> </ul></p>
    #[serde(rename = "RecordIdentifierFeatureName")]
    pub record_identifier_feature_name: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateFeatureGroupResponse {
    /// <p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. This is a unique identifier for the feature group. </p>
    #[serde(rename = "FeatureGroupArn")]
    pub feature_group_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateFlowDefinitionRequest {
    /// <p>The name of your flow definition.</p>
    #[serde(rename = "FlowDefinitionName")]
    pub flow_definition_name: String,
    /// <p>An object containing information about the events that trigger a human workflow.</p>
    #[serde(rename = "HumanLoopActivationConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_loop_activation_config: Option<HumanLoopActivationConfig>,
    /// <p>An object containing information about the tasks the human reviewers will perform.</p>
    #[serde(rename = "HumanLoopConfig")]
    pub human_loop_config: HumanLoopConfig,
    /// <p>Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
    #[serde(rename = "HumanLoopRequestSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_loop_request_source: Option<HumanLoopRequestSource>,
    /// <p>An object containing information about where the human review results will be uploaded.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: FlowDefinitionOutputConfig,
    /// <p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateFlowDefinitionResponse {
    /// <p>The Amazon Resource Name (ARN) of the flow definition you create.</p>
    #[serde(rename = "FlowDefinitionArn")]
    pub flow_definition_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateHumanTaskUiRequest {
    /// <p>The name of the user interface you are creating.</p>
    #[serde(rename = "HumanTaskUiName")]
    pub human_task_ui_name: String,
    /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    #[serde(rename = "UiTemplate")]
    pub ui_template: UiTemplate,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateHumanTaskUiResponse {
    /// <p>The Amazon Resource Name (ARN) of the human review workflow user interface you create.</p>
    #[serde(rename = "HumanTaskUiArn")]
    pub human_task_ui_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateHyperParameterTuningJobRequest {
    /// <p>The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>
    #[serde(rename = "HyperParameterTuningJobConfig")]
    pub hyper_parameter_tuning_job_config: HyperParameterTuningJobConfig,
    /// <p>The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same AWS account and AWS Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    pub hyper_parameter_tuning_job_name: String,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p> <p>Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.</p>
    #[serde(rename = "TrainingJobDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_definition: Option<HyperParameterTrainingJobDefinition>,
    /// <p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>
    #[serde(rename = "TrainingJobDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_definitions: Option<Vec<HyperParameterTrainingJobDefinition>>,
    /// <p><p>Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify <code>IDENTICAL<em>DATA</em>AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note></p>
    #[serde(rename = "WarmStartConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub warm_start_config: Option<HyperParameterTuningJobWarmStartConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateHyperParameterTuningJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter tuning job when you create it.</p>
    #[serde(rename = "HyperParameterTuningJobArn")]
    pub hyper_parameter_tuning_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateImageRequest {
    /// <p>The description of the image.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the image. Must be unique to your account.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>A list of tags to apply to the image.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateImageResponse {
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    #[serde(rename = "ImageArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateImageVersionRequest {
    /// <p>The registry path of the container image to use as the starting point for this version. The path is an Amazon Container Registry (ECR) URI in the following format:</p> <p> <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code> </p>
    #[serde(rename = "BaseImage")]
    pub base_image: String,
    /// <p>A unique ID. If not specified, the AWS CLI and AWS SDKs, such as the SDK for Python (Boto3), add a unique value to the call.</p>
    #[serde(rename = "ClientToken")]
    pub client_token: String,
    /// <p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateImageVersionResponse {
    /// <p>The Amazon Resource Name (ARN) of the image version.</p>
    #[serde(rename = "ImageVersionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_version_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateLabelingJobRequest {
    /// <p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>
    #[serde(rename = "HumanTaskConfig")]
    pub human_task_config: HumanTaskConfig,
    /// <p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p> <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>. </p> <ul> <li> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data objects in the input manifest file have been labeled.</p> </li> <li> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p> </li> </ul> <p>If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information, personal information or protected health information. Use <code>ContentClassifiers</code> to specify that your data is free of personally identifiable information and adult content.</p>
    #[serde(rename = "InputConfig")]
    pub input_config: LabelingJobInputConfig,
    /// <p><p>The attribute name to use for the label in the output manifest file. This is the key for the key/value pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the following requirements.</p> <ul> <li> <p>The name can&#39;t end with &quot;-metadata&quot;. </p> </li> <li> <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the attribute name <i>must</i> end with &quot;-ref&quot;. If the task type you are using is not listed below, the attribute name <i>must not</i> end with &quot;-ref&quot;.</p> <ul> <li> <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (<code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.</p> </li> <li> <p>Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.</p> </li> <li> <p>Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (<code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.</p> </li> <li> <p>3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type. </p> </li> <li> <p>3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type. </p> </li> </ul> </li> </ul> <p/> <important> <p>If you are creating an adjustment or verification labeling job, you must use a <i>different</i> <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more about adjustment and verification labeling jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels</a>.</p> </important></p>
    #[serde(rename = "LabelAttributeName")]
    pub label_attribute_name: String,
    /// <p><p>The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the categories used to label the data objects.</p> <p>For 3D point cloud and video frame task types, you can add label category attributes and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p> <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the labels you want to use by replacing <code>label<em>1</code>, <code>label</em>2</code>,<code>...</code>,<code>label<em>n</code> with your label categories.</p> <p> <code>{ </code> </p> <p> <code>&quot;document-version&quot;: &quot;2018-11-28&quot;,</code> </p> <p> <code>&quot;labels&quot;: [{&quot;label&quot;: &quot;label</em>1&quot;},{&quot;label&quot;: &quot;label<em>2&quot;},...{&quot;label&quot;: &quot;label</em>n&quot;}]</code> </p> <p> <code>}</code> </p> <p>Note the following about the label category configuration file:</p> <ul> <li> <p>For image classification and text classification (single and multi-label) you must specify at least two label categories. For all other task types, the minimum number of label categories required is one. </p> </li> <li> <p>Each label category must be unique, you cannot specify duplicate label categories.</p> </li> <li> <p>If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"> <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.</p> </li> </ul></p>
    #[serde(rename = "LabelCategoryConfigS3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub label_category_config_s3_uri: Option<String>,
    /// <p>Configures the information required to perform automated data labeling.</p>
    #[serde(rename = "LabelingJobAlgorithmsConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_algorithms_config: Option<LabelingJobAlgorithmsConfig>,
    /// <p>The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job names must be unique within an AWS account and region. <code>LabelingJobName</code> is not case sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground Truth.</p>
    #[serde(rename = "LabelingJobName")]
    pub labeling_job_name: String,
    /// <p>The location of the output data and the AWS Key Management Service key ID for the key used to encrypt the output data, if any.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: LabelingJobOutputConfig,
    /// <p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete data labeling.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p>
    #[serde(rename = "StoppingConditions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_conditions: Option<LabelingJobStoppingConditions>,
    /// <p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateLabelingJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the labeling job. You use this ARN to identify the labeling job.</p>
    #[serde(rename = "LabelingJobArn")]
    pub labeling_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateModelBiasJobDefinitionRequest {
    /// <p>The name of the bias job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>Configures the model bias job to run a specified Docker container image.</p>
    #[serde(rename = "ModelBiasAppSpecification")]
    pub model_bias_app_specification: ModelBiasAppSpecification,
    /// <p>The baseline configuration for a model bias job.</p>
    #[serde(rename = "ModelBiasBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_bias_baseline_config: Option<ModelBiasBaselineConfig>,
    /// <p>Inputs for the model bias job.</p>
    #[serde(rename = "ModelBiasJobInput")]
    pub model_bias_job_input: ModelBiasJobInput,
    #[serde(rename = "ModelBiasJobOutputConfig")]
    pub model_bias_job_output_config: MonitoringOutputConfig,
    /// <p>Networking options for a model bias job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateModelBiasJobDefinitionResponse {
    /// <p>The Amazon Resource Name (ARN) of the model bias job.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateModelExplainabilityJobDefinitionRequest {
    /// <p> The name of the model explainability job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>Configures the model explainability job to run a specified Docker container image.</p>
    #[serde(rename = "ModelExplainabilityAppSpecification")]
    pub model_explainability_app_specification: ModelExplainabilityAppSpecification,
    /// <p>The baseline configuration for a model explainability job.</p>
    #[serde(rename = "ModelExplainabilityBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_explainability_baseline_config: Option<ModelExplainabilityBaselineConfig>,
    /// <p>Inputs for the model explainability job.</p>
    #[serde(rename = "ModelExplainabilityJobInput")]
    pub model_explainability_job_input: ModelExplainabilityJobInput,
    #[serde(rename = "ModelExplainabilityJobOutputConfig")]
    pub model_explainability_job_output_config: MonitoringOutputConfig,
    /// <p>Networking options for a model explainability job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateModelExplainabilityJobDefinitionResponse {
    /// <p>The Amazon Resource Name (ARN) of the model explainability job.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateModelInput {
    /// <p>Specifies the containers in the inference pipeline.</p>
    #[serde(rename = "Containers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub containers: Option<Vec<ContainerDefinition>>,
    /// <p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    /// <p><p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note></p>
    #[serde(rename = "ExecutionRoleArn")]
    pub execution_role_arn: String,
    /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
    #[serde(rename = "InferenceExecutionConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_execution_config: Option<InferenceExecutionConfig>,
    /// <p>The name of the new model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. </p>
    #[serde(rename = "PrimaryContainer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub primary_container: Option<ContainerDefinition>,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. <code>VpcConfig</code> is used in hosting services and in batch transform. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateModelOutput {
    /// <p>The ARN of the model created in Amazon SageMaker.</p>
    #[serde(rename = "ModelArn")]
    pub model_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateModelPackageGroupInput {
    /// <p>A description for the model group.</p>
    #[serde(rename = "ModelPackageGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_description: Option<String>,
    /// <p>The name of the model group.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
    /// <p>A list of key value pairs associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateModelPackageGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    #[serde(rename = "ModelPackageGroupArn")]
    pub model_package_group_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateModelPackageInput {
    /// <p>Whether to certify the model package for listing on AWS Marketplace.</p> <p>This parameter is optional for unversioned models, and does not apply to versioned models.</p>
    #[serde(rename = "CertifyForMarketplace")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certify_for_marketplace: Option<bool>,
    /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
    #[serde(rename = "ClientToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_token: Option<String>,
    /// <p><p>Specifies details about inference jobs that can be run with models based on this model package, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the model package supports for inference.</p> </li> </ul></p>
    #[serde(rename = "InferenceSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_specification: Option<InferenceSpecification>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>Whether the model is approved for deployment.</p> <p>This parameter is optional for versioned models, and does not apply to unversioned models.</p> <p>For versioned models, the value of this parameter must be set to <code>Approved</code> to deploy the model.</p>
    #[serde(rename = "ModelApprovalStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_approval_status: Option<String>,
    /// <p>A structure that contains model metrics reports.</p>
    #[serde(rename = "ModelMetrics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_metrics: Option<ModelMetrics>,
    /// <p>A description of the model package.</p>
    #[serde(rename = "ModelPackageDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_description: Option<String>,
    /// <p>The name of the model group that this model version belongs to.</p> <p>This parameter is required for versioned models, and does not apply to unversioned models.</p>
    #[serde(rename = "ModelPackageGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_name: Option<String>,
    /// <p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p> <p>This parameter is required for unversioned models. It is not applicable to versioned models.</p>
    #[serde(rename = "ModelPackageName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_name: Option<String>,
    /// <p>Details about the algorithm that was used to create the model package.</p>
    #[serde(rename = "SourceAlgorithmSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_algorithm_specification: Option<SourceAlgorithmSpecification>,
    /// <p>A list of key value pairs associated with the model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>
    #[serde(rename = "ValidationSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_specification: Option<ModelPackageValidationSpecification>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateModelPackageOutput {
    /// <p>The Amazon Resource Name (ARN) of the new model package.</p>
    #[serde(rename = "ModelPackageArn")]
    pub model_package_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateModelQualityJobDefinitionRequest {
    /// <p>The name of the monitoring job definition.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>The container that runs the monitoring job.</p>
    #[serde(rename = "ModelQualityAppSpecification")]
    pub model_quality_app_specification: ModelQualityAppSpecification,
    /// <p>Specifies the constraints and baselines for the monitoring job.</p>
    #[serde(rename = "ModelQualityBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_quality_baseline_config: Option<ModelQualityBaselineConfig>,
    /// <p>A list of the inputs that are monitored. Currently endpoints are supported.</p>
    #[serde(rename = "ModelQualityJobInput")]
    pub model_quality_job_input: ModelQualityJobInput,
    #[serde(rename = "ModelQualityJobOutputConfig")]
    pub model_quality_job_output_config: MonitoringOutputConfig,
    /// <p>Specifies the network configuration for the monitoring job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateModelQualityJobDefinitionResponse {
    /// <p>The Amazon Resource Name (ARN) of the model quality monitoring job.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateMonitoringScheduleRequest {
    /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
    #[serde(rename = "MonitoringScheduleConfig")]
    pub monitoring_schedule_config: MonitoringScheduleConfig,
    /// <p>The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateMonitoringScheduleResponse {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    pub monitoring_schedule_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNotebookInstanceInput {
    /// <p>A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
    #[serde(rename = "AcceleratorTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accelerator_types: Option<Vec<String>>,
    /// <p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "AdditionalCodeRepositories")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_code_repositories: Option<Vec<String>>,
    /// <p>A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "DefaultCodeRepository")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_code_repository: Option<String>,
    /// <p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.</p>
    #[serde(rename = "DirectInternetAccess")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub direct_internet_access: Option<String>,
    /// <p>The type of ML compute instance to launch for the notebook instance.</p>
    #[serde(rename = "InstanceType")]
    pub instance_type: String,
    /// <p>The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
    #[serde(rename = "LifecycleConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lifecycle_config_name: Option<String>,
    /// <p>The name of the new notebook instance.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
    /// <p><p> When you send any requests to AWS resources from the notebook instance, Amazon SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note></p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p><p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note> <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p> </note></p>
    #[serde(rename = "RootAccess")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub root_access: Option<String>,
    /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in the subnet. </p>
    #[serde(rename = "SecurityGroupIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_group_ids: Option<Vec<String>>,
    /// <p>The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance. </p>
    #[serde(rename = "SubnetId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.</p>
    #[serde(rename = "VolumeSizeInGB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_size_in_gb: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateNotebookInstanceLifecycleConfigInput {
    /// <p>The name of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    pub notebook_instance_lifecycle_config_name: String,
    /// <p>A shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>
    #[serde(rename = "OnCreate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_create: Option<Vec<NotebookInstanceLifecycleHook>>,
    /// <p>A shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>
    #[serde(rename = "OnStart")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_start: Option<Vec<NotebookInstanceLifecycleHook>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateNotebookInstanceLifecycleConfigOutput {
    /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_config_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateNotebookInstanceOutput {
    /// <p>The Amazon Resource Name (ARN) of the notebook instance. </p>
    #[serde(rename = "NotebookInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePipelineRequest {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The JSON pipeline definition of the pipeline.</p>
    #[serde(rename = "PipelineDefinition")]
    pub pipeline_definition: String,
    /// <p>A description of the pipeline.</p>
    #[serde(rename = "PipelineDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_description: Option<String>,
    /// <p>The display name of the pipeline.</p>
    #[serde(rename = "PipelineDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_display_name: Option<String>,
    /// <p>The name of the pipeline.</p>
    #[serde(rename = "PipelineName")]
    pub pipeline_name: String,
    /// <p>The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>A list of tags to apply to the created pipeline.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreatePipelineResponse {
    /// <p>The Amazon Resource Name (ARN) of the created pipeline.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePresignedDomainUrlRequest {
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The number of seconds until the pre-signed URL expires. This value defaults to 300.</p>
    #[serde(rename = "ExpiresInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub expires_in_seconds: Option<i64>,
    /// <p>The session expiration duration in seconds. This value defaults to 43200.</p>
    #[serde(rename = "SessionExpirationDurationInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub session_expiration_duration_in_seconds: Option<i64>,
    /// <p>The name of the UserProfile to sign-in as.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreatePresignedDomainUrlResponse {
    /// <p>The presigned URL.</p>
    #[serde(rename = "AuthorizedUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorized_url: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreatePresignedNotebookInstanceUrlInput {
    /// <p>The name of the notebook instance.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
    /// <p>The duration of the session, in seconds. The default is 12 hours.</p>
    #[serde(rename = "SessionExpirationDurationInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub session_expiration_duration_in_seconds: Option<i64>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreatePresignedNotebookInstanceUrlOutput {
    /// <p>A JSON object that contains the URL string. </p>
    #[serde(rename = "AuthorizedUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorized_url: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateProcessingJobRequest {
    /// <p>Configures the processing job to run a specified Docker container image.</p>
    #[serde(rename = "AppSpecification")]
    pub app_specification: AppSpecification,
    /// <p>The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<NetworkConfig>,
    /// <p>An array of inputs configuring the data to download into the processing container.</p>
    #[serde(rename = "ProcessingInputs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_inputs: Option<Vec<ProcessingInput>>,
    /// <p> The name of the processing job. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "ProcessingJobName")]
    pub processing_job_name: String,
    /// <p>Output configuration for the processing job.</p>
    #[serde(rename = "ProcessingOutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_output_config: Option<ProcessingOutputConfig>,
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
    #[serde(rename = "ProcessingResources")]
    pub processing_resources: ProcessingResources,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>The time limit for how long the processing job is allowed to run.</p>
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<ProcessingStoppingCondition>,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateProcessingJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
    #[serde(rename = "ProcessingJobArn")]
    pub processing_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateProjectInput {
    /// <p>A description for the project.</p>
    #[serde(rename = "ProjectDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub project_description: Option<String>,
    /// <p>The name of the project.</p>
    #[serde(rename = "ProjectName")]
    pub project_name: String,
    /// <p>The product ID and provisioning artifact ID to provision a service catalog. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a>.</p>
    #[serde(rename = "ServiceCatalogProvisioningDetails")]
    pub service_catalog_provisioning_details: ServiceCatalogProvisioningDetails,
    /// <p>An array of key-value pairs that you want to use to organize and track your AWS resource costs. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    #[serde(rename = "ProjectArn")]
    pub project_arn: String,
    /// <p>The ID of the new project.</p>
    #[serde(rename = "ProjectId")]
    pub project_id: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrainingJobRequest {
    /// <p>The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>
    #[serde(rename = "AlgorithmSpecification")]
    pub algorithm_specification: AlgorithmSpecification,
    /// <p>Contains information about the output location for managed spot training checkpoint data.</p>
    #[serde(rename = "CheckpointConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub checkpoint_config: Option<CheckpointConfig>,
    #[serde(rename = "DebugHookConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_hook_config: Option<DebugHookConfig>,
    /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
    #[serde(rename = "DebugRuleConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_rule_configurations: Option<Vec<DebugRuleConfiguration>>,
    /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML Compute Instances in a Distributed Training Job</a>.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run. </p> <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed. </p>
    #[serde(rename = "EnableManagedSpotTraining")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_managed_spot_training: Option<bool>,
    /// <p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    /// <p>The environment variables to set in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the <code>Length Constraint</code>. </p>
    #[serde(rename = "HyperParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code> describes the input data and its location. </p> <p>Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format. </p> <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files will be made available as input streams. They do not need to be downloaded.</p>
    #[serde(rename = "InputDataConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_data_config: Option<Vec<Channel>>,
    /// <p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts. </p>
    #[serde(rename = "OutputDataConfig")]
    pub output_data_config: OutputDataConfig,
    #[serde(rename = "ProfilerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_config: Option<ProfilerConfig>,
    /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
    #[serde(rename = "ProfilerRuleConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_rule_configurations: Option<Vec<ProfilerRuleConfiguration>>,
    /// <p>The resources, including the ML compute instances and ML storage volumes, to use for model training. </p> <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>
    #[serde(rename = "ResourceConfig")]
    pub resource_config: ResourceConfig,
    /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
    #[serde(rename = "RetryStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retry_strategy: Option<RetryStrategy>,
    /// <p><p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. </p> <p>During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note></p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
    #[serde(rename = "StoppingCondition")]
    pub stopping_condition: StoppingCondition,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    #[serde(rename = "TensorBoardOutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tensor_board_output_config: Option<TensorBoardOutputConfig>,
    /// <p>The name of the training job. The name must be unique within an AWS Region in an AWS account. </p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateTrainingJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    #[serde(rename = "TrainingJobArn")]
    pub training_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTransformJobRequest {
    /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p> <p>To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.</p> <p>To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
    #[serde(rename = "BatchStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_strategy: Option<String>,
    /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
    #[serde(rename = "DataProcessing")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_processing: Option<DataProcessing>,
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for <code>MaxConcurrentTransforms</code>.</p>
    #[serde(rename = "MaxConcurrentTransforms")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_concurrent_transforms: Option<i64>,
    /// <p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is <code>6</code> MB. </p> <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.</p>
    #[serde(rename = "MaxPayloadInMB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_payload_in_mb: Option<i64>,
    /// <p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>
    #[serde(rename = "ModelClientConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_client_config: Option<ModelClientConfig>,
    /// <p>The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an AWS Region in an AWS account.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Describes the input source and the way the transform job consumes it.</p>
    #[serde(rename = "TransformInput")]
    pub transform_input: TransformInput,
    /// <p>The name of the transform job. The name must be unique within an AWS Region in an AWS account. </p>
    #[serde(rename = "TransformJobName")]
    pub transform_job_name: String,
    /// <p>Describes the results of the transform job.</p>
    #[serde(rename = "TransformOutput")]
    pub transform_output: TransformOutput,
    /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
    #[serde(rename = "TransformResources")]
    pub transform_resources: TransformResources,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateTransformJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
    #[serde(rename = "TransformJobArn")]
    pub transform_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrialComponentRequest {
    /// <p>The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When the component ended.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.</p>
    #[serde(rename = "InputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.</p>
    #[serde(rename = "OutputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    /// <p>The hyperparameters for the component.</p>
    #[serde(rename = "Parameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameters: Option<::std::collections::HashMap<String, TrialComponentParameterValue>>,
    /// <p>When the component started.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p><p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul></p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<TrialComponentStatus>,
    /// <p>A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the component. The name must be unique in your AWS account and is not case-sensitive.</p>
    #[serde(rename = "TrialComponentName")]
    pub trial_component_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateTrialComponentResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTrialRequest {
    /// <p>The name of the trial as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the experiment to associate the trial with.</p>
    #[serde(rename = "ExperimentName")]
    pub experiment_name: String,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>A list of tags to associate with the trial. You can use <a>Search</a> API to search on the tags.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the trial. The name must be unique in your AWS account and is not case-sensitive.</p>
    #[serde(rename = "TrialName")]
    pub trial_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateTrialResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateUserProfileRequest {
    /// <p>The ID of the associated Domain.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified. </p>
    #[serde(rename = "SingleSignOnUserIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub single_sign_on_user_identifier: Option<String>,
    /// <p>The username of the associated AWS Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified. </p>
    #[serde(rename = "SingleSignOnUserValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub single_sign_on_user_value: Option<String>,
    /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p> <p>Tags that you specify for the User Profile are also added to all Apps that the User Profile launches.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>A name for the UserProfile. This value is not case sensitive.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
    /// <p>A collection of settings.</p>
    #[serde(rename = "UserSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_settings: Option<UserSettings>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateUserProfileResponse {
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    #[serde(rename = "UserProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateWorkforceRequest {
    /// <p>Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p> <p>Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.</p>
    #[serde(rename = "CognitoConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cognito_config: Option<CognitoConfig>,
    /// <p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p> <p>Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.</p>
    #[serde(rename = "OidcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub oidc_config: Option<OidcConfig>,
    #[serde(rename = "SourceIpConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_ip_config: Option<SourceIpConfig>,
    /// <p>An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the private workforce.</p>
    #[serde(rename = "WorkforceName")]
    pub workforce_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateWorkforceResponse {
    /// <p>The Amazon Resource Name (ARN) of the workforce.</p>
    #[serde(rename = "WorkforceArn")]
    pub workforce_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateWorkteamRequest {
    /// <p>A description of the work team.</p>
    #[serde(rename = "Description")]
    pub description: String,
    /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters in a single request.</p> <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>.</p>
    #[serde(rename = "MemberDefinitions")]
    pub member_definitions: Vec<MemberDefinition>,
    /// <p>Configures notification of workers regarding available or expiring work items.</p>
    #[serde(rename = "NotificationConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notification_configuration: Option<NotificationConfiguration>,
    /// <p>An array of key-value pairs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The name of the workforce.</p>
    #[serde(rename = "WorkforceName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub workforce_name: Option<String>,
    /// <p>The name of the work team. Use this name to identify the work team.</p>
    #[serde(rename = "WorkteamName")]
    pub workteam_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct CreateWorkteamResponse {
    /// <p>The Amazon Resource Name (ARN) of the work team. You can use this ARN to identify the work team.</p>
    #[serde(rename = "WorkteamArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub workteam_arn: Option<String>,
}

/// <p>A custom SageMaker image. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct CustomImage {
    /// <p>The name of the AppImageConfig.</p>
    #[serde(rename = "AppImageConfigName")]
    pub app_image_config_name: String,
    /// <p>The name of the CustomImage. Must be unique to your account.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>The version number of the CustomImage.</p>
    #[serde(rename = "ImageVersionNumber")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_version_number: Option<i64>,
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataCaptureConfig {
    /// <p><p/></p>
    #[serde(rename = "CaptureContentTypeHeader")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub capture_content_type_header: Option<CaptureContentTypeHeader>,
    /// <p><p/></p>
    #[serde(rename = "CaptureOptions")]
    pub capture_options: Vec<CaptureOption>,
    /// <p><p/></p>
    #[serde(rename = "DestinationS3Uri")]
    pub destination_s3_uri: String,
    /// <p><p/></p>
    #[serde(rename = "EnableCapture")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_capture: Option<bool>,
    /// <p><p/></p>
    #[serde(rename = "InitialSamplingPercentage")]
    pub initial_sampling_percentage: i64,
    /// <p><p/></p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DataCaptureConfigSummary {
    /// <p><p/></p>
    #[serde(rename = "CaptureStatus")]
    pub capture_status: String,
    /// <p><p/></p>
    #[serde(rename = "CurrentSamplingPercentage")]
    pub current_sampling_percentage: i64,
    /// <p><p/></p>
    #[serde(rename = "DestinationS3Uri")]
    pub destination_s3_uri: String,
    /// <p><p/></p>
    #[serde(rename = "EnableCapture")]
    pub enable_capture: bool,
    /// <p><p/></p>
    #[serde(rename = "KmsKeyId")]
    pub kms_key_id: String,
}

/// <p>The meta data of the Glue table which serves as data catalog for the <code>OfflineStore</code>. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataCatalogConfig {
    /// <p>The name of the Glue table catalog.</p>
    #[serde(rename = "Catalog")]
    pub catalog: String,
    /// <p>The name of the Glue table database.</p>
    #[serde(rename = "Database")]
    pub database: String,
    /// <p>The name of the Glue table.</p>
    #[serde(rename = "TableName")]
    pub table_name: String,
}

/// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataProcessing {
    /// <p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want Amazon SageMaker to pass the entire input dataset to the algorithm, accept the default value <code>$</code>.</p> <p>Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code> </p>
    #[serde(rename = "InputFilter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_filter: Option<String>,
    /// <p>Specifies the source of the data to join with the transformed data. The valid values are <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with the transformed data. If you want the batch transform job to join the original input data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it in the output file.</p> <p>For JSON or JSONLines objects, such as a JSON array, Amazon SageMaker adds the transformed data to the input JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value pair object. If the input is not a key-value pair object, Amazon SageMaker creates a new JSON file. In the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the results are stored in <code>SageMakerOutput</code>.</p> <p>For CSV data, Amazon SageMaker takes each row as a JSON array and joins the transformed data with the input by appending each transformed row to the end of the input. The joined data has the original input data followed by the transformed data and the output is a CSV file.</p> <p>For information on how joining in applied, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow">Workflow for Associating Inferences with Input Records</a>.</p>
    #[serde(rename = "JoinSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub join_source: Option<String>,
    /// <p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a batch transform job. If you want Amazon SageMaker to store the entire input dataset in the output file, leave the default value, <code>$</code>. If you specify indexes that aren't within the dimension size of the joined dataset, you get an error.</p> <p>Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$['id','SageMakerOutput']"</code> </p>
    #[serde(rename = "OutputFilter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_filter: Option<String>,
}

/// <p>Information about the container that a data quality monitoring job runs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataQualityAppSpecification {
    /// <p>The arguments to send to the container that the monitoring job runs.</p>
    #[serde(rename = "ContainerArguments")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_arguments: Option<Vec<String>>,
    /// <p>The entrypoint for a container used to run a monitoring job.</p>
    #[serde(rename = "ContainerEntrypoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_entrypoint: Option<Vec<String>>,
    /// <p>Sets the environment variables in the container that the monitoring job runs.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The container image that the data quality monitoring job runs.</p>
    #[serde(rename = "ImageUri")]
    pub image_uri: String,
    /// <p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>
    #[serde(rename = "PostAnalyticsProcessorSourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub post_analytics_processor_source_uri: Option<String>,
    /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>
    #[serde(rename = "RecordPreprocessorSourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub record_preprocessor_source_uri: Option<String>,
}

/// <p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataQualityBaselineConfig {
    /// <p>The name of the job that performs baselining for the data quality monitoring job.</p>
    #[serde(rename = "BaseliningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub baselining_job_name: Option<String>,
    #[serde(rename = "ConstraintsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints_resource: Option<MonitoringConstraintsResource>,
    #[serde(rename = "StatisticsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistics_resource: Option<MonitoringStatisticsResource>,
}

/// <p>The input for the data quality monitoring job. Currently endpoints are supported for input.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataQualityJobInput {
    #[serde(rename = "EndpointInput")]
    pub endpoint_input: EndpointInput,
}

/// <p>Describes the location of the channel data.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DataSource {
    /// <p>The file system that is associated with a channel.</p>
    #[serde(rename = "FileSystemDataSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_system_data_source: Option<FileSystemDataSource>,
    /// <p>The S3 location of the data source that is associated with a channel.</p>
    #[serde(rename = "S3DataSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_data_source: Option<S3DataSource>,
}

/// <p>Configuration for Dataset Definition inputs. The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DatasetDefinition {
    #[serde(rename = "AthenaDatasetDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub athena_dataset_definition: Option<AthenaDatasetDefinition>,
    /// <p>Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).</p>
    #[serde(rename = "DataDistributionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_distribution_type: Option<String>,
    /// <p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>
    #[serde(rename = "InputMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_mode: Option<String>,
    /// <p>The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job. <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when <code>AppManaged</code> is <code>False</code> (default).</p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    #[serde(rename = "RedshiftDatasetDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub redshift_dataset_definition: Option<RedshiftDatasetDefinition>,
}

/// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DebugHookConfig {
    /// <p>Configuration information for Debugger tensor collections. To learn more about how to configure the <code>CollectionConfiguration</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>
    #[serde(rename = "CollectionConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub collection_configurations: Option<Vec<CollectionConfiguration>>,
    /// <p>Configuration information for the Debugger hook parameters.</p>
    #[serde(rename = "HookParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hook_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>Path to local storage location for metrics and tensors. Defaults to <code>/opt/ml/output/tensors/</code>.</p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    /// <p>Path to Amazon S3 storage location for metrics and tensors.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>Configuration information for SageMaker Debugger rules for debugging. To learn more about how to configure the <code>DebugRuleConfiguration</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DebugRuleConfiguration {
    /// <p>The instance type to deploy a Debugger custom rule for debugging a training job.</p>
    #[serde(rename = "InstanceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    /// <p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>.</p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    /// <p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>
    #[serde(rename = "RuleConfigurationName")]
    pub rule_configuration_name: String,
    /// <p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>
    #[serde(rename = "RuleEvaluatorImage")]
    pub rule_evaluator_image: String,
    /// <p>Runtime configuration for rule container.</p>
    #[serde(rename = "RuleParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>Path to Amazon S3 storage location for rules.</p>
    #[serde(rename = "S3OutputPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_output_path: Option<String>,
    /// <p>The size, in GB, of the ML storage volume attached to the processing instance.</p>
    #[serde(rename = "VolumeSizeInGB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_size_in_gb: Option<i64>,
}

/// <p>Information about the status of the rule evaluation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DebugRuleEvaluationStatus {
    /// <p>Timestamp when the rule evaluation status was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The name of the rule configuration.</p>
    #[serde(rename = "RuleConfigurationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_configuration_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>
    #[serde(rename = "RuleEvaluationJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_evaluation_job_arn: Option<String>,
    /// <p>Status of the rule evaluation.</p>
    #[serde(rename = "RuleEvaluationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_evaluation_status: Option<String>,
    /// <p>Details from the rule evaluation.</p>
    #[serde(rename = "StatusDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_details: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteActionRequest {
    /// <p>The name of the action to delete.</p>
    #[serde(rename = "ActionName")]
    pub action_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteActionResponse {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    #[serde(rename = "ActionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAlgorithmInput {
    /// <p>The name of the algorithm to delete.</p>
    #[serde(rename = "AlgorithmName")]
    pub algorithm_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAppImageConfigRequest {
    /// <p>The name of the AppImageConfig to delete.</p>
    #[serde(rename = "AppImageConfigName")]
    pub app_image_config_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAppRequest {
    /// <p>The name of the app.</p>
    #[serde(rename = "AppName")]
    pub app_name: String,
    /// <p>The type of app.</p>
    #[serde(rename = "AppType")]
    pub app_type: String,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteArtifactRequest {
    /// <p>The Amazon Resource Name (ARN) of the artifact to delete.</p>
    #[serde(rename = "ArtifactArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_arn: Option<String>,
    /// <p>The URI of the source.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ArtifactSource>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteArtifactResponse {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    #[serde(rename = "ArtifactArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteAssociationRequest {
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    #[serde(rename = "DestinationArn")]
    pub destination_arn: String,
    /// <p>The ARN of the source.</p>
    #[serde(rename = "SourceArn")]
    pub source_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteAssociationResponse {
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    #[serde(rename = "DestinationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_arn: Option<String>,
    /// <p>The ARN of the source.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteCodeRepositoryInput {
    /// <p>The name of the Git repository to delete.</p>
    #[serde(rename = "CodeRepositoryName")]
    pub code_repository_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteContextRequest {
    /// <p>The name of the context to delete.</p>
    #[serde(rename = "ContextName")]
    pub context_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteContextResponse {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    #[serde(rename = "ContextArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDataQualityJobDefinitionRequest {
    /// <p>The name of the data quality monitoring job definition to delete.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDeviceFleetRequest {
    /// <p>The name of the fleet to delete.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteDomainRequest {
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained (not automatically deleted). </p>
    #[serde(rename = "RetentionPolicy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retention_policy: Option<RetentionPolicy>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEndpointConfigInput {
    /// <p>The name of the endpoint configuration that you want to delete.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEndpointInput {
    /// <p>The name of the endpoint that you want to delete.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteExperimentRequest {
    /// <p>The name of the experiment to delete.</p>
    #[serde(rename = "ExperimentName")]
    pub experiment_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteExperimentResponse {
    /// <p>The Amazon Resource Name (ARN) of the experiment that is being deleted.</p>
    #[serde(rename = "ExperimentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteFeatureGroupRequest {
    /// <p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique within an AWS Region in an AWS account. </p>
    #[serde(rename = "FeatureGroupName")]
    pub feature_group_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteFlowDefinitionRequest {
    /// <p>The name of the flow definition you are deleting.</p>
    #[serde(rename = "FlowDefinitionName")]
    pub flow_definition_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteFlowDefinitionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteHumanTaskUiRequest {
    /// <p>The name of the human task user interface (work task template) you want to delete.</p>
    #[serde(rename = "HumanTaskUiName")]
    pub human_task_ui_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteHumanTaskUiResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteImageRequest {
    /// <p>The name of the image to delete.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteImageResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteImageVersionRequest {
    /// <p>The name of the image.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>The version to delete.</p>
    #[serde(rename = "Version")]
    pub version: i64,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteImageVersionResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelBiasJobDefinitionRequest {
    /// <p>The name of the model bias job definition to delete.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelExplainabilityJobDefinitionRequest {
    /// <p>The name of the model explainability job definition to delete.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelInput {
    /// <p>The name of the model to delete.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelPackageGroupInput {
    /// <p>The name of the model group to delete.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelPackageGroupPolicyInput {
    /// <p>The name of the model group for which to delete the policy.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelPackageInput {
    /// <p>The name or Amazon Resource Name (ARN) of the model package to delete.</p> <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
    #[serde(rename = "ModelPackageName")]
    pub model_package_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteModelQualityJobDefinitionRequest {
    /// <p>The name of the model quality monitoring job definition to delete.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteMonitoringScheduleRequest {
    /// <p>The name of the monitoring schedule to delete.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNotebookInstanceInput {
    /// <p>The name of the Amazon SageMaker notebook instance to delete.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteNotebookInstanceLifecycleConfigInput {
    /// <p>The name of the lifecycle configuration to delete.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    pub notebook_instance_lifecycle_config_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeletePipelineRequest {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The name of the pipeline to delete.</p>
    #[serde(rename = "PipelineName")]
    pub pipeline_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeletePipelineResponse {
    /// <p>The Amazon Resource Name (ARN) of the pipeline to delete.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteProjectInput {
    /// <p>The name of the project to delete.</p>
    #[serde(rename = "ProjectName")]
    pub project_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTagsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to delete.</p>
    #[serde(rename = "ResourceArn")]
    pub resource_arn: String,
    /// <p>An array or one or more tag keys to delete.</p>
    #[serde(rename = "TagKeys")]
    pub tag_keys: Vec<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteTagsOutput {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTrialComponentRequest {
    /// <p>The name of the component to delete.</p>
    #[serde(rename = "TrialComponentName")]
    pub trial_component_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteTrialComponentResponse {
    /// <p>The Amazon Resource Name (ARN) of the component is being deleted.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTrialRequest {
    /// <p>The name of the trial to delete.</p>
    #[serde(rename = "TrialName")]
    pub trial_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteTrialResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial that is being deleted.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteUserProfileRequest {
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteWorkforceRequest {
    /// <p>The name of the workforce.</p>
    #[serde(rename = "WorkforceName")]
    pub workforce_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteWorkforceResponse {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteWorkteamRequest {
    /// <p>The name of the work team to delete.</p>
    #[serde(rename = "WorkteamName")]
    pub workteam_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeleteWorkteamResponse {
    /// <p>Returns <code>true</code> if the work team was successfully deleted; otherwise, returns <code>false</code>.</p>
    #[serde(rename = "Success")]
    pub success: bool,
}

/// <p>Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this <a>ProductionVariant</a>.</p> <p>If you used the <code>registry/repository[:tag]</code> form to specify the image path of the primary container when you created the model hosted in this <code>ProductionVariant</code>, the path resolves to a path of the form <code>registry/repository[@digest]</code>. A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image</a> in the <i>Amazon ECR User Guide</i>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeployedImage {
    /// <p>The date and time when the image path for the model resolved to the <code>ResolvedImage</code> </p>
    #[serde(rename = "ResolutionTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resolution_time: Option<f64>,
    /// <p>The specific digest path of the image hosted in this <code>ProductionVariant</code>.</p>
    #[serde(rename = "ResolvedImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resolved_image: Option<String>,
    /// <p>The image path you specified when you created the model.</p>
    #[serde(rename = "SpecifiedImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub specified_image: Option<String>,
}

/// <p>Currently, the <code>DeploymentConfig</code> API is not supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct DeploymentConfig {
    /// <p><p/></p>
    #[serde(rename = "AutoRollbackConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_rollback_configuration: Option<AutoRollbackConfig>,
    /// <p><p/></p>
    #[serde(rename = "BlueGreenUpdatePolicy")]
    pub blue_green_update_policy: BlueGreenUpdatePolicy,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeregisterDevicesRequest {
    /// <p>The name of the fleet the devices belong to.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>The unique IDs of the devices.</p>
    #[serde(rename = "DeviceNames")]
    pub device_names: Vec<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeActionRequest {
    /// <p>The name of the action to describe.</p>
    #[serde(rename = "ActionName")]
    pub action_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeActionResponse {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    #[serde(rename = "ActionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
    /// <p>The name of the action.</p>
    #[serde(rename = "ActionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_name: Option<String>,
    /// <p>The type of the action.</p>
    #[serde(rename = "ActionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the action was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The description of the action.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the action was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>A list of the action's properties.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>The source of the action.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ActionSource>,
    /// <p>The status of the action.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAlgorithmInput {
    /// <p>The name of the algorithm to describe.</p>
    #[serde(rename = "AlgorithmName")]
    pub algorithm_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAlgorithmOutput {
    /// <p>The Amazon Resource Name (ARN) of the algorithm.</p>
    #[serde(rename = "AlgorithmArn")]
    pub algorithm_arn: String,
    /// <p>A brief summary about the algorithm.</p>
    #[serde(rename = "AlgorithmDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub algorithm_description: Option<String>,
    /// <p>The name of the algorithm being described.</p>
    #[serde(rename = "AlgorithmName")]
    pub algorithm_name: String,
    /// <p>The current status of the algorithm.</p>
    #[serde(rename = "AlgorithmStatus")]
    pub algorithm_status: String,
    /// <p>Details about the current status of the algorithm.</p>
    #[serde(rename = "AlgorithmStatusDetails")]
    pub algorithm_status_details: AlgorithmStatusDetails,
    /// <p>Whether the algorithm is certified to be listed in AWS Marketplace.</p>
    #[serde(rename = "CertifyForMarketplace")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certify_for_marketplace: Option<bool>,
    /// <p>A timestamp specifying when the algorithm was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Details about inference jobs that the algorithm runs.</p>
    #[serde(rename = "InferenceSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_specification: Option<InferenceSpecification>,
    /// <p>The product identifier of the algorithm.</p>
    #[serde(rename = "ProductId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
    /// <p>Details about training jobs run by this algorithm.</p>
    #[serde(rename = "TrainingSpecification")]
    pub training_specification: TrainingSpecification,
    /// <p>Details about configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.</p>
    #[serde(rename = "ValidationSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_specification: Option<AlgorithmValidationSpecification>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAppImageConfigRequest {
    /// <p>The name of the AppImageConfig to describe.</p>
    #[serde(rename = "AppImageConfigName")]
    pub app_image_config_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAppImageConfigResponse {
    /// <p>The Amazon Resource Name (ARN) of the AppImageConfig.</p>
    #[serde(rename = "AppImageConfigArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_config_arn: Option<String>,
    /// <p>The name of the AppImageConfig.</p>
    #[serde(rename = "AppImageConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_config_name: Option<String>,
    /// <p>When the AppImageConfig was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The configuration of a KernelGateway app.</p>
    #[serde(rename = "KernelGatewayImageConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kernel_gateway_image_config: Option<KernelGatewayImageConfig>,
    /// <p>When the AppImageConfig was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAppRequest {
    /// <p>The name of the app.</p>
    #[serde(rename = "AppName")]
    pub app_name: String,
    /// <p>The type of app.</p>
    #[serde(rename = "AppType")]
    pub app_type: String,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAppResponse {
    /// <p>The Amazon Resource Name (ARN) of the app.</p>
    #[serde(rename = "AppArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_arn: Option<String>,
    /// <p>The name of the app.</p>
    #[serde(rename = "AppName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_name: Option<String>,
    /// <p>The type of app.</p>
    #[serde(rename = "AppType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_type: Option<String>,
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The failure reason.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The timestamp of the last health check.</p>
    #[serde(rename = "LastHealthCheckTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_health_check_timestamp: Option<f64>,
    /// <p>The timestamp of the last user's activity.</p>
    #[serde(rename = "LastUserActivityTimestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_user_activity_timestamp: Option<f64>,
    /// <p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
    #[serde(rename = "ResourceSpec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_spec: Option<ResourceSpec>,
    /// <p>The status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeArtifactRequest {
    /// <p>The Amazon Resource Name (ARN) of the artifact to describe.</p>
    #[serde(rename = "ArtifactArn")]
    pub artifact_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeArtifactResponse {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    #[serde(rename = "ArtifactArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_arn: Option<String>,
    /// <p>The name of the artifact.</p>
    #[serde(rename = "ArtifactName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_name: Option<String>,
    /// <p>The type of the artifact.</p>
    #[serde(rename = "ArtifactType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_type: Option<String>,
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the artifact was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the artifact was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>A list of the artifact's properties.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>The source of the artifact.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ArtifactSource>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAutoMLJobRequest {
    /// <p>Requests information about an AutoML job using its unique name.</p>
    #[serde(rename = "AutoMLJobName")]
    pub auto_ml_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeAutoMLJobResponse {
    /// <p>Returns the ARN of the AutoML job.</p>
    #[serde(rename = "AutoMLJobArn")]
    pub auto_ml_job_arn: String,
    /// <p>Returns information on the job's artifacts found in <code>AutoMLJobArtifacts</code>.</p>
    #[serde(rename = "AutoMLJobArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_artifacts: Option<AutoMLJobArtifacts>,
    /// <p>Returns the configuration for the AutoML job.</p>
    #[serde(rename = "AutoMLJobConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_config: Option<AutoMLJobConfig>,
    /// <p>Returns the name of the AutoML job.</p>
    #[serde(rename = "AutoMLJobName")]
    pub auto_ml_job_name: String,
    /// <p>Returns the job's objective.</p>
    #[serde(rename = "AutoMLJobObjective")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_objective: Option<AutoMLJobObjective>,
    /// <p>Returns the secondary status of the AutoML job.</p>
    #[serde(rename = "AutoMLJobSecondaryStatus")]
    pub auto_ml_job_secondary_status: String,
    /// <p>Returns the status of the AutoML job.</p>
    #[serde(rename = "AutoMLJobStatus")]
    pub auto_ml_job_status: String,
    /// <p>Returns the job's best <code>AutoMLCandidate</code>.</p>
    #[serde(rename = "BestCandidate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub best_candidate: Option<AutoMLCandidate>,
    /// <p>Returns the creation time of the AutoML job.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Returns the end time of the AutoML job.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>Returns the failure reason for an AutoML job, when applicable.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>Indicates whether the output for an AutoML job generates candidate definitions only.</p>
    #[serde(rename = "GenerateCandidateDefinitionsOnly")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generate_candidate_definitions_only: Option<bool>,
    /// <p>Returns the input data configuration for the AutoML job..</p>
    #[serde(rename = "InputDataConfig")]
    pub input_data_config: Vec<AutoMLChannel>,
    /// <p>Returns the job's last modified time.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if deployed automatically.</p>
    #[serde(rename = "ModelDeployConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_deploy_config: Option<ModelDeployConfig>,
    /// <p>Provides information about endpoint for the model deployment.</p>
    #[serde(rename = "ModelDeployResult")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_deploy_result: Option<ModelDeployResult>,
    /// <p>Returns the job's output data config.</p>
    #[serde(rename = "OutputDataConfig")]
    pub output_data_config: AutoMLOutputDataConfig,
    /// <p>Returns a list of reasons for partial failures within an AutoML job.</p>
    #[serde(rename = "PartialFailureReasons")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub partial_failure_reasons: Option<Vec<AutoMLPartialFailureReason>>,
    /// <p>Returns the job's problem type.</p>
    #[serde(rename = "ProblemType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub problem_type: Option<String>,
    /// <p>This contains <code>ProblemType</code>, <code>AutoMLJobObjective</code> and <code>CompletionCriteria</code>. If you do not provide these values, they are auto-inferred. If you do provide them, the values used are the ones you provide.</p>
    #[serde(rename = "ResolvedAttributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resolved_attributes: Option<ResolvedAttributes>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCodeRepositoryInput {
    /// <p>The name of the Git repository to describe.</p>
    #[serde(rename = "CodeRepositoryName")]
    pub code_repository_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeCodeRepositoryOutput {
    /// <p>The Amazon Resource Name (ARN) of the Git repository.</p>
    #[serde(rename = "CodeRepositoryArn")]
    pub code_repository_arn: String,
    /// <p>The name of the Git repository.</p>
    #[serde(rename = "CodeRepositoryName")]
    pub code_repository_name: String,
    /// <p>The date and time that the repository was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Configuration details about the repository, including the URL where the repository is located, the default branch, and the Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the repository.</p>
    #[serde(rename = "GitConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub git_config: Option<GitConfig>,
    /// <p>The date and time that the repository was last changed.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeCompilationJobRequest {
    /// <p>The name of the model compilation job that you want information about.</p>
    #[serde(rename = "CompilationJobName")]
    pub compilation_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeCompilationJobResponse {
    /// <p>The time when the model compilation job on a compilation job instance ended. For a successful or stopped job, this is when the job's model artifacts have finished uploading. For a failed job, this is when Amazon SageMaker detected that the job failed. </p>
    #[serde(rename = "CompilationEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the model compilation job.</p>
    #[serde(rename = "CompilationJobArn")]
    pub compilation_job_arn: String,
    /// <p>The name of the model compilation job.</p>
    #[serde(rename = "CompilationJobName")]
    pub compilation_job_name: String,
    /// <p>The status of the model compilation job.</p>
    #[serde(rename = "CompilationJobStatus")]
    pub compilation_job_status: String,
    /// <p>The time when the model compilation job started the <code>CompilationJob</code> instances. </p> <p>You are billed for the time between this timestamp and the timestamp in the <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start time might be later than this time. That's because it takes time to download the compilation job, which depends on the size of the compilation job container. </p>
    #[serde(rename = "CompilationStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_start_time: Option<f64>,
    /// <p>The time that the model compilation job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>If a model compilation job failed, the reason it failed. </p>
    #[serde(rename = "FailureReason")]
    pub failure_reason: String,
    #[serde(rename = "InferenceImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_image: Option<String>,
    /// <p>Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>
    #[serde(rename = "InputConfig")]
    pub input_config: InputConfig,
    /// <p>The time that the status of the model compilation job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the compilation job.</p>
    #[serde(rename = "ModelArtifacts")]
    pub model_artifacts: ModelArtifacts,
    /// <p>Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.</p>
    #[serde(rename = "ModelDigests")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_digests: Option<ModelDigests>,
    /// <p>Information about the output location for the compiled model and the target device that the model runs on.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: OutputConfig,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model compilation job.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>
    #[serde(rename = "StoppingCondition")]
    pub stopping_condition: StoppingCondition,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<NeoVpcConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeContextRequest {
    /// <p>The name of the context to describe.</p>
    #[serde(rename = "ContextName")]
    pub context_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeContextResponse {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    #[serde(rename = "ContextArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_arn: Option<String>,
    /// <p>The name of the context.</p>
    #[serde(rename = "ContextName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_name: Option<String>,
    /// <p>The type of the context.</p>
    #[serde(rename = "ContextType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_type: Option<String>,
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the context was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The description of the context.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the context was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>A list of the context's properties.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>The source of the context.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ContextSource>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDataQualityJobDefinitionRequest {
    /// <p>The name of the data quality monitoring job definition to describe.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDataQualityJobDefinitionResponse {
    /// <p>The time that the data quality monitoring job definition was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Information about the container that runs the data quality monitoring job.</p>
    #[serde(rename = "DataQualityAppSpecification")]
    pub data_quality_app_specification: DataQualityAppSpecification,
    /// <p>The constraints and baselines for the data quality monitoring job definition.</p>
    #[serde(rename = "DataQualityBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_quality_baseline_config: Option<DataQualityBaselineConfig>,
    /// <p>The list of inputs for the data quality monitoring job. Currently endpoints are supported.</p>
    #[serde(rename = "DataQualityJobInput")]
    pub data_quality_job_input: DataQualityJobInput,
    #[serde(rename = "DataQualityJobOutputConfig")]
    pub data_quality_job_output_config: MonitoringOutputConfig,
    /// <p>The Amazon Resource Name (ARN) of the data quality monitoring job definition.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
    /// <p>The name of the data quality monitoring job definition.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>The networking configuration for the data quality monitoring job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDeviceFleetRequest {
    /// <p>The name of the fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDeviceFleetResponse {
    /// <p>Timestamp of when the device fleet was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>A description of the fleet.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The The Amazon Resource Name (ARN) of the fleet.</p>
    #[serde(rename = "DeviceFleetArn")]
    pub device_fleet_arn: String,
    /// <p>The name of the fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>The Amazon Resource Name (ARN) alias created in AWS Internet of Things (IoT).</p>
    #[serde(rename = "IotRoleAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_role_alias: Option<String>,
    /// <p>Timestamp of when the device fleet was last updated.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The output configuration for storing sampled data.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: EdgeOutputConfig,
    /// <p>The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDeviceRequest {
    /// <p>The name of the fleet the devices belong to.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>The unique ID of the device.</p>
    #[serde(rename = "DeviceName")]
    pub device_name: String,
    /// <p>Next token of device description.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDeviceResponse {
    /// <p>A description of the device.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    #[serde(rename = "DeviceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub device_arn: Option<String>,
    /// <p>The name of the fleet the device belongs to.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>The unique identifier of the device.</p>
    #[serde(rename = "DeviceName")]
    pub device_name: String,
    /// <p>The AWS Internet of Things (IoT) object thing name associated with the device.</p>
    #[serde(rename = "IotThingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_thing_name: Option<String>,
    /// <p>The last heartbeat received from the device.</p>
    #[serde(rename = "LatestHeartbeat")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub latest_heartbeat: Option<f64>,
    /// <p>The maximum number of models.</p>
    #[serde(rename = "MaxModels")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_models: Option<i64>,
    /// <p>Models on the device.</p>
    #[serde(rename = "Models")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub models: Option<Vec<EdgeModel>>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The timestamp of the last registration or de-reregistration.</p>
    #[serde(rename = "RegistrationTime")]
    pub registration_time: f64,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDomainRequest {
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeDomainResponse {
    /// <p><p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li> <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p> </li> </ul></p>
    #[serde(rename = "AppNetworkAccessType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_network_access_type: Option<String>,
    /// <p>The domain's authentication mode.</p>
    #[serde(rename = "AuthMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auth_mode: Option<String>,
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given UserProfile. </p>
    #[serde(rename = "DefaultUserSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_user_settings: Option<UserSettings>,
    /// <p>The domain's Amazon Resource Name (ARN).</p>
    #[serde(rename = "DomainArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_arn: Option<String>,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The domain name.</p>
    #[serde(rename = "DomainName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    /// <p>The failure reason.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The ID of the Amazon Elastic File System (EFS) managed by this Domain.</p>
    #[serde(rename = "HomeEfsFileSystemId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub home_efs_file_system_id: Option<String>,
    /// <p>The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The last modified time.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The SSO managed application instance ID.</p>
    #[serde(rename = "SingleSignOnManagedApplicationInstanceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub single_sign_on_managed_application_instance_id: Option<String>,
    /// <p>The status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The VPC subnets that Studio uses for communication.</p>
    #[serde(rename = "SubnetIds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subnet_ids: Option<Vec<String>>,
    /// <p>The domain's URL.</p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    /// <p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
    #[serde(rename = "VpcId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_id: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEdgePackagingJobRequest {
    /// <p>The name of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobName")]
    pub edge_packaging_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeEdgePackagingJobResponse {
    /// <p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>
    #[serde(rename = "CompilationJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_job_name: Option<String>,
    /// <p>The timestamp of when the packaging job was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobArn")]
    pub edge_packaging_job_arn: String,
    /// <p>The name of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobName")]
    pub edge_packaging_job_name: String,
    /// <p>The current status of the packaging job.</p>
    #[serde(rename = "EdgePackagingJobStatus")]
    pub edge_packaging_job_status: String,
    /// <p>Returns a message describing the job status and error messages.</p>
    #[serde(rename = "EdgePackagingJobStatusMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub edge_packaging_job_status_message: Option<String>,
    /// <p>The timestamp of when the job was last updated.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Simple Storage (S3) URI where model artifacts ares stored.</p>
    #[serde(rename = "ModelArtifact")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_artifact: Option<String>,
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_name: Option<String>,
    /// <p>The signature document of files in the model artifact.</p>
    #[serde(rename = "ModelSignature")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_signature: Option<String>,
    /// <p>The version of the model.</p>
    #[serde(rename = "ModelVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_version: Option<String>,
    /// <p>The output configuration for the edge packaging job.</p>
    #[serde(rename = "OutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_config: Option<EdgeOutputConfig>,
    /// <p>The output of a SageMaker Edge Manager deployable resource.</p>
    #[serde(rename = "PresetDeploymentOutput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preset_deployment_output: Option<EdgePresetDeploymentOutput>,
    /// <p>The CMK to use when encrypting the EBS volume the job run on.</p>
    #[serde(rename = "ResourceKey")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_key: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact Neo.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEndpointConfigInput {
    /// <p>The name of the endpoint configuration.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeEndpointConfigOutput {
    /// <p>A timestamp that shows when the endpoint configuration was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    #[serde(rename = "DataCaptureConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_capture_config: Option<DataCaptureConfig>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>
    #[serde(rename = "EndpointConfigArn")]
    pub endpoint_config_arn: String,
    /// <p>Name of the Amazon SageMaker endpoint configuration.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
    /// <p>AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
    #[serde(rename = "ProductionVariants")]
    pub production_variants: Vec<ProductionVariant>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEndpointInput {
    /// <p>The name of the endpoint.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeEndpointOutput {
    /// <p>A timestamp that shows when the endpoint was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    #[serde(rename = "DataCaptureConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_capture_config: Option<DataCaptureConfigSummary>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    #[serde(rename = "EndpointArn")]
    pub endpoint_arn: String,
    /// <p>The name of the endpoint configuration associated with this endpoint.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
    /// <p>Name of the endpoint.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p><p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a>CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul></p>
    #[serde(rename = "EndpointStatus")]
    pub endpoint_status: String,
    /// <p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The most recent deployment configuration for the endpoint.</p>
    #[serde(rename = "LastDeploymentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_deployment_config: Option<DeploymentConfig>,
    /// <p>A timestamp that shows when the endpoint was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p> An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint. </p>
    #[serde(rename = "ProductionVariants")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub production_variants: Option<Vec<ProductionVariantSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeExperimentRequest {
    /// <p>The name of the experiment to describe.</p>
    #[serde(rename = "ExperimentName")]
    pub experiment_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeExperimentResponse {
    /// <p>Who created the experiment.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the experiment was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The description of the experiment.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    #[serde(rename = "ExperimentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_arn: Option<String>,
    /// <p>The name of the experiment.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>Who last modified the experiment.</p>
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the experiment was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The ARN of the source and, optionally, the type.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ExperimentSource>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFeatureGroupRequest {
    /// <p>The name of the <code>FeatureGroup</code> you want described. </p>
    #[serde(rename = "FeatureGroupName")]
    pub feature_group_name: String,
    /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>). 2,500 <code>Features</code> are returned by default.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeFeatureGroupResponse {
    /// <p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>A free form description of the feature group.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p> <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>
    #[serde(rename = "EventTimeFeatureName")]
    pub event_time_feature_name: String,
    /// <p><p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p> <ul> <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li> <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li> </ul></p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>
    #[serde(rename = "FeatureDefinitions")]
    pub feature_definitions: Vec<FeatureDefinition>,
    /// <p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>
    #[serde(rename = "FeatureGroupArn")]
    pub feature_group_arn: String,
    /// <p>he name of the <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureGroupName")]
    pub feature_group_name: String,
    /// <p>The status of the feature group.</p>
    #[serde(rename = "FeatureGroupStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group_status: Option<String>,
    /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>
    #[serde(rename = "NextToken")]
    pub next_token: String,
    /// <p>The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>, AWS Glue or AWS Hive data catalogue configurations, and the security configuration.</p>
    #[serde(rename = "OfflineStoreConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_config: Option<OfflineStoreConfig>,
    /// <p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>
    #[serde(rename = "OfflineStoreStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_status: Option<OfflineStoreStatus>,
    /// <p>The configuration for the <code>OnlineStore</code>.</p>
    #[serde(rename = "OnlineStoreConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub online_store_config: Option<OnlineStoreConfig>,
    /// <p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>
    #[serde(rename = "RecordIdentifierFeatureName")]
    pub record_identifier_feature_name: String,
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeFlowDefinitionRequest {
    /// <p>The name of the flow definition.</p>
    #[serde(rename = "FlowDefinitionName")]
    pub flow_definition_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeFlowDefinitionResponse {
    /// <p>The timestamp when the flow definition was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The reason your flow definition failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the flow defintion.</p>
    #[serde(rename = "FlowDefinitionArn")]
    pub flow_definition_arn: String,
    /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
    #[serde(rename = "FlowDefinitionName")]
    pub flow_definition_name: String,
    /// <p>The status of the flow definition. Valid values are listed below.</p>
    #[serde(rename = "FlowDefinitionStatus")]
    pub flow_definition_status: String,
    /// <p>An object containing information about what triggers a human review workflow.</p>
    #[serde(rename = "HumanLoopActivationConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_loop_activation_config: Option<HumanLoopActivationConfig>,
    /// <p>An object containing information about who works on the task, the workforce task price, and other task details.</p>
    #[serde(rename = "HumanLoopConfig")]
    pub human_loop_config: HumanLoopConfig,
    /// <p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
    #[serde(rename = "HumanLoopRequestSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_loop_request_source: Option<HumanLoopRequestSource>,
    /// <p>An object containing information about the output file.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: FlowDefinitionOutputConfig,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) execution role for the flow definition.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHumanTaskUiRequest {
    /// <p>The name of the human task user interface (worker task template) you want information about.</p>
    #[serde(rename = "HumanTaskUiName")]
    pub human_task_ui_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeHumanTaskUiResponse {
    /// <p>The timestamp when the human task user interface was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>
    #[serde(rename = "HumanTaskUiArn")]
    pub human_task_ui_arn: String,
    /// <p>The name of the human task user interface (worker task template).</p>
    #[serde(rename = "HumanTaskUiName")]
    pub human_task_ui_name: String,
    /// <p>The status of the human task user interface (worker task template). Valid values are listed below.</p>
    #[serde(rename = "HumanTaskUiStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_task_ui_status: Option<String>,
    #[serde(rename = "UiTemplate")]
    pub ui_template: UiTemplateInfo,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHyperParameterTuningJobRequest {
    /// <p>The name of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    pub hyper_parameter_tuning_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeHyperParameterTuningJobResponse {
    /// <p>A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current <a>HyperParameterTuningJobObjective</a>.</p>
    #[serde(rename = "BestTrainingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub best_training_job: Option<HyperParameterTrainingJobSummary>,
    /// <p>The date and time that the tuning job started.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>If the tuning job failed, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The date and time that the tuning job ended.</p>
    #[serde(rename = "HyperParameterTuningEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameter_tuning_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobArn")]
    pub hyper_parameter_tuning_job_arn: String,
    /// <p>The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobConfig")]
    pub hyper_parameter_tuning_job_config: HyperParameterTuningJobConfig,
    /// <p>The name of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    pub hyper_parameter_tuning_job_name: String,
    /// <p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>
    #[serde(rename = "HyperParameterTuningJobStatus")]
    pub hyper_parameter_tuning_job_status: String,
    /// <p>The date and time that the status of the tuning job was modified. </p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>
    #[serde(rename = "ObjectiveStatusCounters")]
    pub objective_status_counters: ObjectiveStatusCounters,
    /// <p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>
    #[serde(rename = "OverallBestTrainingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub overall_best_training_job: Option<HyperParameterTrainingJobSummary>,
    /// <p>The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that this tuning job launches.</p>
    #[serde(rename = "TrainingJobDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_definition: Option<HyperParameterTrainingJobDefinition>,
    /// <p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>
    #[serde(rename = "TrainingJobDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_definitions: Option<Vec<HyperParameterTrainingJobDefinition>>,
    /// <p>The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>
    #[serde(rename = "TrainingJobStatusCounters")]
    pub training_job_status_counters: TrainingJobStatusCounters,
    /// <p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
    #[serde(rename = "WarmStartConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub warm_start_config: Option<HyperParameterTuningJobWarmStartConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeImageRequest {
    /// <p>The name of the image to describe.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeImageResponse {
    /// <p>When the image was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The description of the image.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the image as displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When a create, update, or delete operation fails, the reason for the failure.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    #[serde(rename = "ImageArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_arn: Option<String>,
    /// <p>The name of the image.</p>
    #[serde(rename = "ImageName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_name: Option<String>,
    /// <p>The status of the image.</p>
    #[serde(rename = "ImageStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_status: Option<String>,
    /// <p>When the image was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeImageVersionRequest {
    /// <p>The name of the image.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>The version of the image. If not specified, the latest version is described.</p>
    #[serde(rename = "Version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeImageVersionResponse {
    /// <p>The registry path of the container image on which this image version is based.</p>
    #[serde(rename = "BaseImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub base_image: Option<String>,
    /// <p>The registry path of the container image that contains this image version.</p>
    #[serde(rename = "ContainerImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_image: Option<String>,
    /// <p>When the version was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>When a create or delete operation fails, the reason for the failure.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the image the version is based on.</p>
    #[serde(rename = "ImageArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_arn: Option<String>,
    /// <p>The ARN of the version.</p>
    #[serde(rename = "ImageVersionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_version_arn: Option<String>,
    /// <p>The status of the version.</p>
    #[serde(rename = "ImageVersionStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_version_status: Option<String>,
    /// <p>When the version was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The version number.</p>
    #[serde(rename = "Version")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub version: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeLabelingJobRequest {
    /// <p>The name of the labeling job to return information for.</p>
    #[serde(rename = "LabelingJobName")]
    pub labeling_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeLabelingJobResponse {
    /// <p>The date and time that the labeling job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>If the job failed, the reason that it failed. </p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>Configuration information required for human workers to complete a labeling task.</p>
    #[serde(rename = "HumanTaskConfig")]
    pub human_task_config: HumanTaskConfig,
    /// <p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
    #[serde(rename = "InputConfig")]
    pub input_config: LabelingJobInputConfig,
    /// <p>A unique identifier for work done as part of a labeling job.</p>
    #[serde(rename = "JobReferenceCode")]
    pub job_reference_code: String,
    /// <p>The attribute used as the label in the output manifest file.</p>
    #[serde(rename = "LabelAttributeName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub label_attribute_name: Option<String>,
    /// <p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p> <ul> <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li> <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li> </ul> <p>The file is a JSON structure in the following format:</p> <p> <code>{</code> </p> <p> <code> "document-version": "2018-11-28"</code> </p> <p> <code> "labels": [</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label 1</i>"</code> </p> <p> <code> },</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label 2</i>"</code> </p> <p> <code> },</code> </p> <p> <code> ...</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label n</i>"</code> </p> <p> <code> }</code> </p> <p> <code> ]</code> </p> <p> <code>}</code> </p>
    #[serde(rename = "LabelCategoryConfigS3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub label_category_config_s3_uri: Option<String>,
    /// <p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled. </p>
    #[serde(rename = "LabelCounters")]
    pub label_counters: LabelCounters,
    /// <p>Configuration information for automated data labeling.</p>
    #[serde(rename = "LabelingJobAlgorithmsConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_algorithms_config: Option<LabelingJobAlgorithmsConfig>,
    /// <p>The Amazon Resource Name (ARN) of the labeling job.</p>
    #[serde(rename = "LabelingJobArn")]
    pub labeling_job_arn: String,
    /// <p>The name assigned to the labeling job when it was created.</p>
    #[serde(rename = "LabelingJobName")]
    pub labeling_job_name: String,
    /// <p>The location of the output produced by the labeling job.</p>
    #[serde(rename = "LabelingJobOutput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_output: Option<LabelingJobOutput>,
    /// <p>The processing status of the labeling job. </p>
    #[serde(rename = "LabelingJobStatus")]
    pub labeling_job_status: String,
    /// <p>The date and time that the labeling job was last updated.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The location of the job's output data and the AWS Key Management Service key ID for the key used to encrypt the output data, if any.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: LabelingJobOutputConfig,
    /// <p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>
    #[serde(rename = "StoppingConditions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_conditions: Option<LabelingJobStoppingConditions>,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeModelBiasJobDefinitionRequest {
    /// <p>The name of the model bias job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeModelBiasJobDefinitionResponse {
    /// <p>The time at which the model bias job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the model bias job.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
    /// <p>The name of the bias job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>Configures the model bias job to run a specified Docker container image.</p>
    #[serde(rename = "ModelBiasAppSpecification")]
    pub model_bias_app_specification: ModelBiasAppSpecification,
    /// <p>The baseline configuration for a model bias job.</p>
    #[serde(rename = "ModelBiasBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_bias_baseline_config: Option<ModelBiasBaselineConfig>,
    /// <p>Inputs for the model bias job.</p>
    #[serde(rename = "ModelBiasJobInput")]
    pub model_bias_job_input: ModelBiasJobInput,
    #[serde(rename = "ModelBiasJobOutputConfig")]
    pub model_bias_job_output_config: MonitoringOutputConfig,
    /// <p>Networking options for a model bias job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeModelExplainabilityJobDefinitionRequest {
    /// <p>The name of the model explainability job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeModelExplainabilityJobDefinitionResponse {
    /// <p>The time at which the model explainability job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the model explainability job.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
    /// <p>The name of the explainability job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>Configures the model explainability job to run a specified Docker container image.</p>
    #[serde(rename = "ModelExplainabilityAppSpecification")]
    pub model_explainability_app_specification: ModelExplainabilityAppSpecification,
    /// <p>The baseline configuration for a model explainability job.</p>
    #[serde(rename = "ModelExplainabilityBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_explainability_baseline_config: Option<ModelExplainabilityBaselineConfig>,
    /// <p>Inputs for the model explainability job.</p>
    #[serde(rename = "ModelExplainabilityJobInput")]
    pub model_explainability_job_input: ModelExplainabilityJobInput,
    #[serde(rename = "ModelExplainabilityJobOutputConfig")]
    pub model_explainability_job_output_config: MonitoringOutputConfig,
    /// <p>Networking options for a model explainability job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeModelInput {
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeModelOutput {
    /// <p>The containers in the inference pipeline.</p>
    #[serde(rename = "Containers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub containers: Option<Vec<ContainerDefinition>>,
    /// <p>A timestamp that shows when the model was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>
    #[serde(rename = "ExecutionRoleArn")]
    pub execution_role_arn: String,
    /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
    #[serde(rename = "InferenceExecutionConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_execution_config: Option<InferenceExecutionConfig>,
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    #[serde(rename = "ModelArn")]
    pub model_arn: String,
    /// <p>Name of the Amazon SageMaker model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>
    #[serde(rename = "PrimaryContainer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub primary_container: Option<ContainerDefinition>,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeModelPackageGroupInput {
    /// <p>The name of the model group to describe.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeModelPackageGroupOutput {
    #[serde(rename = "CreatedBy")]
    pub created_by: UserContext,
    /// <p>The time that the model group was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    #[serde(rename = "ModelPackageGroupArn")]
    pub model_package_group_arn: String,
    /// <p>A description of the model group.</p>
    #[serde(rename = "ModelPackageGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_description: Option<String>,
    /// <p>The name of the model group.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
    /// <p>The status of the model group.</p>
    #[serde(rename = "ModelPackageGroupStatus")]
    pub model_package_group_status: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeModelPackageInput {
    /// <p>The name or Amazon Resource Name (ARN) of the model package to describe.</p> <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
    #[serde(rename = "ModelPackageName")]
    pub model_package_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeModelPackageOutput {
    /// <p>A description provided for the model approval.</p>
    #[serde(rename = "ApprovalDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub approval_description: Option<String>,
    /// <p>Whether the model package is certified for listing on AWS Marketplace.</p>
    #[serde(rename = "CertifyForMarketplace")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certify_for_marketplace: Option<bool>,
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>A timestamp specifying when the model package was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Details about inference jobs that can be run with models based on this model package.</p>
    #[serde(rename = "InferenceSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_specification: Option<InferenceSpecification>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>The last time the model package was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>The approval status of the model package.</p>
    #[serde(rename = "ModelApprovalStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_approval_status: Option<String>,
    /// <p>Metrics for the model.</p>
    #[serde(rename = "ModelMetrics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_metrics: Option<ModelMetrics>,
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    #[serde(rename = "ModelPackageArn")]
    pub model_package_arn: String,
    /// <p>A brief summary of the model package.</p>
    #[serde(rename = "ModelPackageDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_description: Option<String>,
    /// <p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>
    #[serde(rename = "ModelPackageGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_name: Option<String>,
    /// <p>The name of the model package being described.</p>
    #[serde(rename = "ModelPackageName")]
    pub model_package_name: String,
    /// <p>The current status of the model package.</p>
    #[serde(rename = "ModelPackageStatus")]
    pub model_package_status: String,
    /// <p>Details about the current status of the model package.</p>
    #[serde(rename = "ModelPackageStatusDetails")]
    pub model_package_status_details: ModelPackageStatusDetails,
    /// <p>The version of the model package.</p>
    #[serde(rename = "ModelPackageVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_version: Option<i64>,
    /// <p>Details about the algorithm that was used to create the model package.</p>
    #[serde(rename = "SourceAlgorithmSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_algorithm_specification: Option<SourceAlgorithmSpecification>,
    /// <p>Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>
    #[serde(rename = "ValidationSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_specification: Option<ModelPackageValidationSpecification>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeModelQualityJobDefinitionRequest {
    /// <p>The name of the model quality job. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeModelQualityJobDefinitionResponse {
    /// <p>The time at which the model quality job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the model quality job.</p>
    #[serde(rename = "JobDefinitionArn")]
    pub job_definition_arn: String,
    /// <p>The name of the quality job definition. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "JobDefinitionName")]
    pub job_definition_name: String,
    #[serde(rename = "JobResources")]
    pub job_resources: MonitoringResources,
    /// <p>Configures the model quality job to run a specified Docker container image.</p>
    #[serde(rename = "ModelQualityAppSpecification")]
    pub model_quality_app_specification: ModelQualityAppSpecification,
    /// <p>The baseline configuration for a model quality job.</p>
    #[serde(rename = "ModelQualityBaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_quality_baseline_config: Option<ModelQualityBaselineConfig>,
    /// <p>Inputs for the model quality job.</p>
    #[serde(rename = "ModelQualityJobInput")]
    pub model_quality_job_input: ModelQualityJobInput,
    #[serde(rename = "ModelQualityJobOutputConfig")]
    pub model_quality_job_output_config: MonitoringOutputConfig,
    /// <p>Networking options for a model quality job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeMonitoringScheduleRequest {
    /// <p>Name of a previously created monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeMonitoringScheduleResponse {
    /// <p>The time at which the monitoring job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p> The name of the endpoint for the monitoring job.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The time at which the monitoring job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>Describes metadata on the last execution to run, if there was one.</p>
    #[serde(rename = "LastMonitoringExecutionSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_monitoring_execution_summary: Option<MonitoringExecutionSummary>,
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    pub monitoring_schedule_arn: String,
    /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
    #[serde(rename = "MonitoringScheduleConfig")]
    pub monitoring_schedule_config: MonitoringScheduleConfig,
    /// <p>Name of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
    /// <p>The status of an monitoring job.</p>
    #[serde(rename = "MonitoringScheduleStatus")]
    pub monitoring_schedule_status: String,
    /// <p><p>The type of the monitoring job that this schedule runs. This is one of the following values.</p> <ul> <li> <p> <code>DATA<em>QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li> <li> <p> <code>MODEL</em>QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li> <li> <p> <code>MODEL<em>BIAS</code> - The schedule is for a bias monitoring job.</p> </li> <li> <p> <code>MODEL</em>EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li> </ul></p>
    #[serde(rename = "MonitoringType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeNotebookInstanceInput {
    /// <p>The name of the notebook instance that you want information about.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeNotebookInstanceLifecycleConfigInput {
    /// <p>The name of the lifecycle configuration to describe.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    pub notebook_instance_lifecycle_config_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeNotebookInstanceLifecycleConfigOutput {
    /// <p>A timestamp that tells when the lifecycle configuration was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>A timestamp that tells when the lifecycle configuration was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_config_arn: Option<String>,
    /// <p>The name of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_config_name: Option<String>,
    /// <p>The shell script that runs only once, when you create a notebook instance.</p>
    #[serde(rename = "OnCreate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_create: Option<Vec<NotebookInstanceLifecycleHook>>,
    /// <p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>
    #[serde(rename = "OnStart")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_start: Option<Vec<NotebookInstanceLifecycleHook>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeNotebookInstanceOutput {
    /// <p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
    #[serde(rename = "AcceleratorTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accelerator_types: Option<Vec<String>>,
    /// <p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "AdditionalCodeRepositories")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_code_repositories: Option<Vec<String>>,
    /// <p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "DefaultCodeRepository")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_code_repository: Option<String>,
    /// <p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>
    #[serde(rename = "DirectInternetAccess")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub direct_internet_access: Option<String>,
    /// <p>If status is <code>Failed</code>, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The type of ML compute instance running on the notebook instance.</p>
    #[serde(rename = "InstanceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    /// <p>The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>
    #[serde(rename = "NetworkInterfaceId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_interface_id: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the notebook instance.</p>
    #[serde(rename = "NotebookInstanceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_arn: Option<String>,
    /// <p>Returns the name of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_config_name: Option<String>,
    /// <p>The name of the Amazon SageMaker notebook instance. </p>
    #[serde(rename = "NotebookInstanceName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_name: Option<String>,
    /// <p>The status of the notebook instance.</p>
    #[serde(rename = "NotebookInstanceStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p><p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note> <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p> </note></p>
    #[serde(rename = "RootAccess")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub root_access: Option<String>,
    /// <p>The IDs of the VPC security groups.</p>
    #[serde(rename = "SecurityGroups")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_groups: Option<Vec<String>>,
    /// <p>The ID of the VPC subnet.</p>
    #[serde(rename = "SubnetId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub subnet_id: Option<String>,
    /// <p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    /// <p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>
    #[serde(rename = "VolumeSizeInGB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_size_in_gb: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribePipelineDefinitionForExecutionRequest {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    pub pipeline_execution_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribePipelineDefinitionForExecutionResponse {
    /// <p>The time when the pipeline was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The JSON pipeline definition.</p>
    #[serde(rename = "PipelineDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_definition: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribePipelineExecutionRequest {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    pub pipeline_execution_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribePipelineExecutionResponse {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The time when the pipeline execution was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>If the execution failed, a message describing why.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>The time when the pipeline execution was modified last.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
    /// <p>The description of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_description: Option<String>,
    /// <p>The display name of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_display_name: Option<String>,
    /// <p>The status of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_status: Option<String>,
    #[serde(rename = "PipelineExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_experiment_config: Option<PipelineExperimentConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribePipelineRequest {
    /// <p>The name of the pipeline to describe.</p>
    #[serde(rename = "PipelineName")]
    pub pipeline_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribePipelineResponse {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The time when the pipeline was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>The time when the pipeline was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The time when the pipeline was last run.</p>
    #[serde(rename = "LastRunTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_run_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
    /// <p>The JSON pipeline definition.</p>
    #[serde(rename = "PipelineDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_definition: Option<String>,
    /// <p>The description of the pipeline.</p>
    #[serde(rename = "PipelineDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_description: Option<String>,
    /// <p>The display name of the pipeline.</p>
    #[serde(rename = "PipelineDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_display_name: Option<String>,
    /// <p>The name of the pipeline.</p>
    #[serde(rename = "PipelineName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    /// <p>The status of the pipeline execution.</p>
    #[serde(rename = "PipelineStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeProcessingJobRequest {
    /// <p>The name of the processing job. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "ProcessingJobName")]
    pub processing_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeProcessingJobResponse {
    /// <p>Configures the processing job to run a specified container image.</p>
    #[serde(rename = "AppSpecification")]
    pub app_specification: AppSpecification,
    /// <p>The ARN of an AutoML job associated with this processing job.</p>
    #[serde(rename = "AutoMLJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_arn: Option<String>,
    /// <p>The time at which the processing job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The environment variables set in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
    #[serde(rename = "ExitMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exit_message: Option<String>,
    /// <p>The configuration information used to create an experiment.</p>
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The time at which the processing job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_arn: Option<String>,
    /// <p>Networking options for a processing job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<NetworkConfig>,
    /// <p>The time at which the processing job completed.</p>
    #[serde(rename = "ProcessingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_end_time: Option<f64>,
    /// <p>The inputs for a processing job.</p>
    #[serde(rename = "ProcessingInputs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_inputs: Option<Vec<ProcessingInput>>,
    /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
    #[serde(rename = "ProcessingJobArn")]
    pub processing_job_arn: String,
    /// <p>The name of the processing job. The name must be unique within an AWS Region in the AWS account.</p>
    #[serde(rename = "ProcessingJobName")]
    pub processing_job_name: String,
    /// <p>Provides the status of a processing job.</p>
    #[serde(rename = "ProcessingJobStatus")]
    pub processing_job_status: String,
    /// <p>Output configuration for the processing job.</p>
    #[serde(rename = "ProcessingOutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_output_config: Option<ProcessingOutputConfig>,
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
    #[serde(rename = "ProcessingResources")]
    pub processing_resources: ProcessingResources,
    /// <p>The time at which the processing job started.</p>
    #[serde(rename = "ProcessingStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_start_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>The time limit for how long the processing job is allowed to run.</p>
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<ProcessingStoppingCondition>,
    /// <p>The ARN of a training job associated with this processing job.</p>
    #[serde(rename = "TrainingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeProjectInput {
    /// <p>The name of the project to describe.</p>
    #[serde(rename = "ProjectName")]
    pub project_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeProjectOutput {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The time when the project was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    #[serde(rename = "ProjectArn")]
    pub project_arn: String,
    /// <p>The description of the project.</p>
    #[serde(rename = "ProjectDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub project_description: Option<String>,
    /// <p>The ID of the project.</p>
    #[serde(rename = "ProjectId")]
    pub project_id: String,
    /// <p>The name of the project.</p>
    #[serde(rename = "ProjectName")]
    pub project_name: String,
    /// <p>The status of the project.</p>
    #[serde(rename = "ProjectStatus")]
    pub project_status: String,
    /// <p>Information about a provisioned service catalog product.</p>
    #[serde(rename = "ServiceCatalogProvisionedProductDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub service_catalog_provisioned_product_details:
        Option<ServiceCatalogProvisionedProductDetails>,
    /// <p>Information used to provision a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a>.</p>
    #[serde(rename = "ServiceCatalogProvisioningDetails")]
    pub service_catalog_provisioning_details: ServiceCatalogProvisioningDetails,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeSubscribedWorkteamRequest {
    /// <p>The Amazon Resource Name (ARN) of the subscribed work team to describe.</p>
    #[serde(rename = "WorkteamArn")]
    pub workteam_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeSubscribedWorkteamResponse {
    /// <p>A <code>Workteam</code> instance that contains information about the work team.</p>
    #[serde(rename = "SubscribedWorkteam")]
    pub subscribed_workteam: SubscribedWorkteam,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeTrainingJobRequest {
    /// <p>The name of the training job.</p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeTrainingJobResponse {
    /// <p>Information about the algorithm used for training, and algorithm metadata. </p>
    #[serde(rename = "AlgorithmSpecification")]
    pub algorithm_specification: AlgorithmSpecification,
    /// <p>The Amazon Resource Name (ARN) of an AutoML job.</p>
    #[serde(rename = "AutoMLJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_arn: Option<String>,
    /// <p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p> <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time Amazon SageMaker will bill you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p> <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>
    #[serde(rename = "BillableTimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billable_time_in_seconds: Option<i64>,
    #[serde(rename = "CheckpointConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub checkpoint_config: Option<CheckpointConfig>,
    /// <p>A timestamp that indicates when the training job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    #[serde(rename = "DebugHookConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_hook_config: Option<DebugHookConfig>,
    /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
    #[serde(rename = "DebugRuleConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_rule_configurations: Option<Vec<DebugRuleConfiguration>>,
    /// <p>Evaluation status of Debugger rules for debugging on a training job.</p>
    #[serde(rename = "DebugRuleEvaluationStatuses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_rule_evaluation_statuses: Option<Vec<DebugRuleEvaluationStatus>>,
    /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>
    #[serde(rename = "EnableManagedSpotTraining")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_managed_spot_training: Option<bool>,
    /// <p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    /// <p>The environment variables to set in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>If the training job failed, the reason it failed. </p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>
    #[serde(rename = "FinalMetricDataList")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub final_metric_data_list: Option<Vec<MetricData>>,
    /// <p>Algorithm-specific parameters. </p>
    #[serde(rename = "HyperParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>An array of <code>Channel</code> objects that describes each data input channel. </p>
    #[serde(rename = "InputDataConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_data_config: Option<Vec<Channel>>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
    #[serde(rename = "LabelingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_arn: Option<String>,
    /// <p>A timestamp that indicates when the status of the training job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>
    #[serde(rename = "ModelArtifacts")]
    pub model_artifacts: ModelArtifacts,
    /// <p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>
    #[serde(rename = "OutputDataConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_data_config: Option<OutputDataConfig>,
    #[serde(rename = "ProfilerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_config: Option<ProfilerConfig>,
    /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
    #[serde(rename = "ProfilerRuleConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_rule_configurations: Option<Vec<ProfilerRuleConfiguration>>,
    /// <p>Evaluation status of Debugger rules for profiling on a training job.</p>
    #[serde(rename = "ProfilerRuleEvaluationStatuses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_rule_evaluation_statuses: Option<Vec<ProfilerRuleEvaluationStatus>>,
    /// <p>Profiling status of a training job.</p>
    #[serde(rename = "ProfilingStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiling_status: Option<String>,
    /// <p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>
    #[serde(rename = "ResourceConfig")]
    pub resource_config: ResourceConfig,
    /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
    #[serde(rename = "RetryStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retry_strategy: Option<RetryStrategy>,
    /// <p>The AWS Identity and Access Management (IAM) role configured for the training job. </p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p><p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.</p> <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <important> <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p> </important> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTraining</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul></p>
    #[serde(rename = "SecondaryStatus")]
    pub secondary_status: String,
    /// <p>A history of all of the secondary statuses that the training job has transitioned through.</p>
    #[serde(rename = "SecondaryStatusTransitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secondary_status_transitions: Option<Vec<SecondaryStatusTransition>>,
    /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
    #[serde(rename = "StoppingCondition")]
    pub stopping_condition: StoppingCondition,
    #[serde(rename = "TensorBoardOutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tensor_board_output_config: Option<TensorBoardOutputConfig>,
    /// <p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
    #[serde(rename = "TrainingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    #[serde(rename = "TrainingJobArn")]
    pub training_job_arn: String,
    /// <p> Name of the model training job. </p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
    /// <p>The status of the training job.</p> <p>Amazon SageMaker provides the following training job statuses:</p> <ul> <li> <p> <code>InProgress</code> - The training is in progress.</p> </li> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li> <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> <p>For more detailed information, see <code>SecondaryStatus</code>. </p>
    #[serde(rename = "TrainingJobStatus")]
    pub training_job_status: String,
    /// <p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>
    #[serde(rename = "TrainingStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_start_time: Option<f64>,
    /// <p>The training time in seconds.</p>
    #[serde(rename = "TrainingTimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_time_in_seconds: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>
    #[serde(rename = "TuningJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tuning_job_arn: Option<String>,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeTransformJobRequest {
    /// <p>The name of the transform job that you want to view details of.</p>
    #[serde(rename = "TransformJobName")]
    pub transform_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeTransformJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>
    #[serde(rename = "AutoMLJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_arn: Option<String>,
    /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
    #[serde(rename = "BatchStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_strategy: Option<String>,
    /// <p>A timestamp that shows when the transform Job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    #[serde(rename = "DataProcessing")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_processing: Option<DataProcessing>,
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
    #[serde(rename = "LabelingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_arn: Option<String>,
    /// <p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>
    #[serde(rename = "MaxConcurrentTransforms")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_concurrent_transforms: Option<i64>,
    /// <p>The maximum payload size, in MB, used in the transform job.</p>
    #[serde(rename = "MaxPayloadInMB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_payload_in_mb: Option<i64>,
    /// <p>The timeout and maximum number of retries for processing a transform job invocation.</p>
    #[serde(rename = "ModelClientConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_client_config: Option<ModelClientConfig>,
    /// <p>The name of the model used in the transform job.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>
    #[serde(rename = "TransformEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_end_time: Option<f64>,
    /// <p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>
    #[serde(rename = "TransformInput")]
    pub transform_input: TransformInput,
    /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
    #[serde(rename = "TransformJobArn")]
    pub transform_job_arn: String,
    /// <p>The name of the transform job.</p>
    #[serde(rename = "TransformJobName")]
    pub transform_job_name: String,
    /// <p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>
    #[serde(rename = "TransformJobStatus")]
    pub transform_job_status: String,
    /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>
    #[serde(rename = "TransformOutput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_output: Option<TransformOutput>,
    /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
    #[serde(rename = "TransformResources")]
    pub transform_resources: TransformResources,
    /// <p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>
    #[serde(rename = "TransformStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_start_time: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeTrialComponentRequest {
    /// <p>The name of the trial component to describe.</p>
    #[serde(rename = "TrialComponentName")]
    pub trial_component_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeTrialComponentResponse {
    /// <p>Who created the component.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the component was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When the component ended.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The input artifacts of the component.</p>
    #[serde(rename = "InputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    /// <p>Who last modified the component.</p>
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the component was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>The metrics for the component.</p>
    #[serde(rename = "Metrics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metrics: Option<Vec<TrialComponentMetricSummary>>,
    /// <p>The output artifacts of the component.</p>
    #[serde(rename = "OutputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    /// <p>The hyperparameters of the component.</p>
    #[serde(rename = "Parameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameters: Option<::std::collections::HashMap<String, TrialComponentParameterValue>>,
    /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<TrialComponentSource>,
    /// <p>When the component started.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p><p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul></p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<TrialComponentStatus>,
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
    /// <p>The name of the trial component.</p>
    #[serde(rename = "TrialComponentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeTrialRequest {
    /// <p>The name of the trial to describe.</p>
    #[serde(rename = "TrialName")]
    pub trial_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeTrialResponse {
    /// <p>Who created the trial.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the trial was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the experiment the trial is part of.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>Who last modified the trial.</p>
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the trial was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<TrialSource>,
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
    /// <p>The name of the trial.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeUserProfileRequest {
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The user profile name. This value is not case sensitive.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeUserProfileResponse {
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The ID of the domain that contains the profile.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The failure reason.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The ID of the user's profile in the Amazon Elastic File System (EFS) volume.</p>
    #[serde(rename = "HomeEfsFileSystemUid")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub home_efs_file_system_uid: Option<String>,
    /// <p>The last modified time.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The SSO user identifier.</p>
    #[serde(rename = "SingleSignOnUserIdentifier")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub single_sign_on_user_identifier: Option<String>,
    /// <p>The SSO user value.</p>
    #[serde(rename = "SingleSignOnUserValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub single_sign_on_user_value: Option<String>,
    /// <p>The status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    #[serde(rename = "UserProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_arn: Option<String>,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name: Option<String>,
    /// <p>A collection of settings.</p>
    #[serde(rename = "UserSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_settings: Option<UserSettings>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeWorkforceRequest {
    /// <p>The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically set to <code>default</code> when a workforce is created and cannot be modified. </p>
    #[serde(rename = "WorkforceName")]
    pub workforce_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeWorkforceResponse {
    /// <p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each AWS Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
    #[serde(rename = "Workforce")]
    pub workforce: Workforce,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeWorkteamRequest {
    /// <p>The name of the work team to return a description of.</p>
    #[serde(rename = "WorkteamName")]
    pub workteam_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DescribeWorkteamResponse {
    /// <p>A <code>Workteam</code> instance that contains information about the work team. </p>
    #[serde(rename = "Workteam")]
    pub workteam: Workteam,
}

/// <p>Specifies weight and capacity values for a production variant.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DesiredWeightAndCapacity {
    /// <p>The variant's capacity.</p>
    #[serde(rename = "DesiredInstanceCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub desired_instance_count: Option<i64>,
    /// <p>The variant's weight.</p>
    #[serde(rename = "DesiredWeight")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub desired_weight: Option<f32>,
    /// <p>The name of the variant to update.</p>
    #[serde(rename = "VariantName")]
    pub variant_name: String,
}

/// <p>Information of a particular device.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Device {
    /// <p>Description of the device.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the device.</p>
    #[serde(rename = "DeviceName")]
    pub device_name: String,
    /// <p>AWS Internet of Things (IoT) object name.</p>
    #[serde(rename = "IotThingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_thing_name: Option<String>,
}

/// <p>Summary of the device fleet.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeviceFleetSummary {
    /// <p>Timestamp of when the device fleet was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>Amazon Resource Name (ARN) of the device fleet.</p>
    #[serde(rename = "DeviceFleetArn")]
    pub device_fleet_arn: String,
    /// <p>Name of the device fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>Timestamp of when the device fleet was last updated.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
}

/// <p>Status of devices.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeviceStats {
    /// <p>The number of devices connected with a heartbeat.</p>
    #[serde(rename = "ConnectedDeviceCount")]
    pub connected_device_count: i64,
    /// <p>The number of registered devices.</p>
    #[serde(rename = "RegisteredDeviceCount")]
    pub registered_device_count: i64,
}

/// <p>Summary of the device.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DeviceSummary {
    /// <p>A description of the device.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>Amazon Resource Name (ARN) of the device.</p>
    #[serde(rename = "DeviceArn")]
    pub device_arn: String,
    /// <p>The name of the fleet the device belongs to.</p>
    #[serde(rename = "DeviceFleetName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub device_fleet_name: Option<String>,
    /// <p>The unique identifier of the device.</p>
    #[serde(rename = "DeviceName")]
    pub device_name: String,
    /// <p>The AWS Internet of Things (IoT) object thing name associated with the device..</p>
    #[serde(rename = "IotThingName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub iot_thing_name: Option<String>,
    /// <p>The last heartbeat received from the device.</p>
    #[serde(rename = "LatestHeartbeat")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub latest_heartbeat: Option<f64>,
    /// <p>Models on the device.</p>
    #[serde(rename = "Models")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub models: Option<Vec<EdgeModelSummary>>,
    /// <p>The timestamp of the last registration or de-reregistration.</p>
    #[serde(rename = "RegistrationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub registration_time: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisableSagemakerServicecatalogPortfolioInput {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DisableSagemakerServicecatalogPortfolioOutput {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisassociateTrialComponentRequest {
    /// <p>The name of the component to disassociate from the trial.</p>
    #[serde(rename = "TrialComponentName")]
    pub trial_component_name: String,
    /// <p>The name of the trial to disassociate from.</p>
    #[serde(rename = "TrialName")]
    pub trial_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DisassociateTrialComponentResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
    /// <p>The ARN of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
}

/// <p>The domain's details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct DomainDetails {
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The domain's Amazon Resource Name (ARN).</p>
    #[serde(rename = "DomainArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_arn: Option<String>,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The domain name.</p>
    #[serde(rename = "DomainName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_name: Option<String>,
    /// <p>The last modified time.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The domain's URL.</p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

/// <p>The model on the edge device.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EdgeModel {
    /// <p>The timestamp of the last inference that was made.</p>
    #[serde(rename = "LatestInference")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub latest_inference: Option<f64>,
    /// <p>The timestamp of the last data sample taken.</p>
    #[serde(rename = "LatestSampleTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub latest_sample_time: Option<f64>,
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The model version.</p>
    #[serde(rename = "ModelVersion")]
    pub model_version: String,
}

/// <p>Status of edge devices with this model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EdgeModelStat {
    /// <p>The number of devices that have this model version, a heart beat, and are currently running.</p>
    #[serde(rename = "ActiveDeviceCount")]
    pub active_device_count: i64,
    /// <p>The number of devices that have this model version and have a heart beat. </p>
    #[serde(rename = "ConnectedDeviceCount")]
    pub connected_device_count: i64,
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The model version.</p>
    #[serde(rename = "ModelVersion")]
    pub model_version: String,
    /// <p>The number of devices that have this model version and do not have a heart beat.</p>
    #[serde(rename = "OfflineDeviceCount")]
    pub offline_device_count: i64,
    /// <p>The number of devices with this model version and are producing sample data.</p>
    #[serde(rename = "SamplingDeviceCount")]
    pub sampling_device_count: i64,
}

/// <p>Summary of model on edge device.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EdgeModelSummary {
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The version model.</p>
    #[serde(rename = "ModelVersion")]
    pub model_version: String,
}

/// <p>The output configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct EdgeOutputConfig {
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p><p>The configuration used to create deployment artifacts. Specify configuration options with a JSON string. The available configuration options for each type are:</p> <ul> <li> <p> <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified, the default name generated consists of &quot;SagemakerEdgeManager&quot; and the name of your SageMaker Edge Manager packaging job.</p> </li> <li> <p> <code>ComponentDescription</code> (optional) - Description of the component.</p> </li> <li> <p> <code>ComponentVersion</code> (optional) - The version of the component.</p> <note> <p>AWS IoT Greengrass uses semantic versions for components. Semantic versions follow a<i> major.minor.patch</i> number system. For example, version 1.0.0 represents the first major release for a component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.</p> </note> </li> <li> <p> <code>PlatformOS</code> (optional) - The name of the operating system for the platform. Supported platforms include Windows and Linux.</p> </li> <li> <p> <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform. </p> <p>Supported architectures Windows include: Windows32<em>x86, Windows64</em>x64.</p> <p>Supported architectures for Linux include: Linux x86_64, Linux ARMV8.</p> </li> </ul></p>
    #[serde(rename = "PresetDeploymentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preset_deployment_config: Option<String>,
    /// <p>The deployment type SageMaker Edge Manager will create. Currently only supports AWS IoT Greengrass Version 2 components.</p>
    #[serde(rename = "PresetDeploymentType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub preset_deployment_type: Option<String>,
    /// <p>The Amazon Simple Storage (S3) bucker URI.</p>
    #[serde(rename = "S3OutputLocation")]
    pub s3_output_location: String,
}

/// <p>Summary of edge packaging job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EdgePackagingJobSummary {
    /// <p>The name of the SageMaker Neo compilation job.</p>
    #[serde(rename = "CompilationJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compilation_job_name: Option<String>,
    /// <p>The timestamp of when the job was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobArn")]
    pub edge_packaging_job_arn: String,
    /// <p>The name of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobName")]
    pub edge_packaging_job_name: String,
    /// <p>The status of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobStatus")]
    pub edge_packaging_job_status: String,
    /// <p>The timestamp of when the edge packaging job was last updated.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_name: Option<String>,
    /// <p>The version of the model.</p>
    #[serde(rename = "ModelVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_version: Option<String>,
}

/// <p>The output of a SageMaker Edge Manager deployable resource.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EdgePresetDeploymentOutput {
    /// <p>The Amazon Resource Name (ARN) of the generated deployable resource.</p>
    #[serde(rename = "Artifact")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact: Option<String>,
    /// <p>The status of the deployable resource.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>Returns a message describing the status of the deployed resource.</p>
    #[serde(rename = "StatusMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_message: Option<String>,
    /// <p>The deployment type created by SageMaker Edge Manager. Currently only supports AWS IoT Greengrass Version 2 components.</p>
    #[serde(rename = "Type")]
    pub type_: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct EnableSagemakerServicecatalogPortfolioInput {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EnableSagemakerServicecatalogPortfolioOutput {}

/// <p>A hosted endpoint for real-time inference.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Endpoint {
    /// <p>The time that the endpoint was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    #[serde(rename = "DataCaptureConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_capture_config: Option<DataCaptureConfigSummary>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    #[serde(rename = "EndpointArn")]
    pub endpoint_arn: String,
    /// <p>The endpoint configuration associated with the endpoint.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
    /// <p>The name of the endpoint.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p>The status of the endpoint.</p>
    #[serde(rename = "EndpointStatus")]
    pub endpoint_status: String,
    /// <p>If the endpoint failed, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The last time the endpoint was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>A list of monitoring schedules for the endpoint. For information about model monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
    #[serde(rename = "MonitoringSchedules")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedules: Option<Vec<MonitoringSchedule>>,
    /// <p>A list of the production variants hosted on the endpoint. Each production variant is a model.</p>
    #[serde(rename = "ProductionVariants")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub production_variants: Option<Vec<ProductionVariantSummary>>,
    /// <p>A list of the tags associated with the endpoint. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>Provides summary information for an endpoint configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EndpointConfigSummary {
    /// <p>A timestamp that shows when the endpoint configuration was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>
    #[serde(rename = "EndpointConfigArn")]
    pub endpoint_config_arn: String,
    /// <p>The name of the endpoint configuration.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
}

/// <p>Input object for the endpoint</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct EndpointInput {
    /// <p>If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>
    #[serde(rename = "EndTimeOffset")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time_offset: Option<String>,
    /// <p>An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p>The attributes of the input data that are the input features.</p>
    #[serde(rename = "FeaturesAttribute")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub features_attribute: Option<String>,
    /// <p>The attribute of the input data that represents the ground truth label.</p>
    #[serde(rename = "InferenceAttribute")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_attribute: Option<String>,
    /// <p>Path to the filesystem where the endpoint data is available to the container.</p>
    #[serde(rename = "LocalPath")]
    pub local_path: String,
    /// <p>In a classification problem, the attribute that represents the class probability.</p>
    #[serde(rename = "ProbabilityAttribute")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub probability_attribute: Option<String>,
    /// <p>The threshold for the class probability to be evaluated as a positive result.</p>
    #[serde(rename = "ProbabilityThresholdAttribute")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub probability_threshold_attribute: Option<f64>,
    /// <p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to <code>FullyReplicated</code> </p>
    #[serde(rename = "S3DataDistributionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_data_distribution_type: Option<String>,
    /// <p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code>.</p>
    #[serde(rename = "S3InputMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_input_mode: Option<String>,
    /// <p>If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>
    #[serde(rename = "StartTimeOffset")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time_offset: Option<String>,
}

/// <p>Provides summary information for an endpoint.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct EndpointSummary {
    /// <p>A timestamp that shows when the endpoint was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    #[serde(rename = "EndpointArn")]
    pub endpoint_arn: String,
    /// <p>The name of the endpoint.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a>CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul> <p>To get a list of endpoints with a specified status, use the <a>ListEndpointsInput$StatusEquals</a> filter.</p>
    #[serde(rename = "EndpointStatus")]
    pub endpoint_status: String,
    /// <p>A timestamp that shows when the endpoint was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
}

/// <p>The properties of an experiment as returned by the <a>Search</a> API.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Experiment {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the experiment was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The description of the experiment.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    #[serde(rename = "ExperimentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_arn: Option<String>,
    /// <p>The name of the experiment.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the experiment was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<ExperimentSource>,
    /// <p>The list of tags that are associated with the experiment. You can use <a>Search</a> API to search on the tags.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p><p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p> <ul> <li> <p> <a>CreateProcessingJob</a> </p> </li> <li> <p> <a>CreateTrainingJob</a> </p> </li> <li> <p> <a>CreateTransformJob</a> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ExperimentConfig {
    /// <p>The name of an existing experiment to associate the trial component with.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>The display name for the trial component. If this key isn't specified, the display name is the trial component name.</p>
    #[serde(rename = "TrialComponentDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_display_name: Option<String>,
    /// <p>The name of an existing trial to associate the trial component with. If not specified, a new trial is created.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
}

/// <p>The source of the experiment.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ExperimentSource {
    /// <p>The Amazon Resource Name (ARN) of the source.</p>
    #[serde(rename = "SourceArn")]
    pub source_arn: String,
    /// <p>The source type.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
}

/// <p>A summary of the properties of an experiment. To get the complete set of properties, call the <a>DescribeExperiment</a> API and provide the <code>ExperimentName</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ExperimentSummary {
    /// <p>When the experiment was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    #[serde(rename = "ExperimentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_arn: Option<String>,
    /// <p>The name of the experiment.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[serde(rename = "ExperimentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_source: Option<ExperimentSource>,
    /// <p>When the experiment was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
}

/// <p>Contains explainability metrics for a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Explainability {
    /// <p>The explainability report for a model.</p>
    #[serde(rename = "Report")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub report: Option<MetricsSource>,
}

/// <p>A list of features. You must include <code>FeatureName</code> and <code>FeatureType</code>. Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct FeatureDefinition {
    /// <p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.</p>
    #[serde(rename = "FeatureName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_name: Option<String>,
    /// <p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>
    #[serde(rename = "FeatureType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_type: Option<String>,
}

/// <p>Amazon SageMaker Feature Store stores features in a collection called Feature Group. A Feature Group can be visualized as a table which has rows, with a unique identifier for each row where each column in the table is a feature. In principle, a Feature Group is composed of features and values per features.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FeatureGroup {
    /// <p>The time a <code>FeatureGroup</code> was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>A free form description of a <code>FeatureGroup</code>.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p> <p>A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p>
    #[serde(rename = "EventTimeFeatureName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub event_time_feature_name: Option<String>,
    /// <p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure may be due to a failure to create a <code>FeatureGroup</code> in or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code>. </p> <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p> <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.</p> <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_definitions: Option<Vec<FeatureDefinition>>,
    /// <p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group_arn: Option<String>,
    /// <p>The name of the <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group_name: Option<String>,
    /// <p>A <code>FeatureGroup</code> status.</p>
    #[serde(rename = "FeatureGroupStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group_status: Option<String>,
    #[serde(rename = "OfflineStoreConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_config: Option<OfflineStoreConfig>,
    #[serde(rename = "OfflineStoreStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_status: Option<OfflineStoreStatus>,
    #[serde(rename = "OnlineStoreConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub online_store_config: Option<OnlineStoreConfig>,
    /// <p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code>.</p>
    #[serde(rename = "RecordIdentifierFeatureName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub record_identifier_feature_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>Tags used to define a <code>FeatureGroup</code>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>The name, Arn, <code>CreationTime</code>, <code>FeatureGroup</code> values, <code>LastUpdatedTime</code> and <code>EnableOnlineStorage</code> status of a <code>FeatureGroup</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FeatureGroupSummary {
    /// <p>A timestamp indicating the time of creation time of the <code>FeatureGroup</code>.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>Unique identifier for the <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureGroupArn")]
    pub feature_group_arn: String,
    /// <p>The name of <code>FeatureGroup</code>.</p>
    #[serde(rename = "FeatureGroupName")]
    pub feature_group_name: String,
    /// <p>The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>, <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>. </p>
    #[serde(rename = "FeatureGroupStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group_status: Option<String>,
    /// <p>Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>.</p>
    #[serde(rename = "OfflineStoreStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_status: Option<OfflineStoreStatus>,
}

/// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct FileSystemConfig {
    /// <p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>
    #[serde(rename = "DefaultGid")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_gid: Option<i64>,
    /// <p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>
    #[serde(rename = "DefaultUid")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_uid: Option<i64>,
    /// <p>The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>
    #[serde(rename = "MountPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub mount_path: Option<String>,
}

/// <p>Specifies a file system data source for a channel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct FileSystemDataSource {
    /// <p>The full path to the directory to associate with the channel.</p>
    #[serde(rename = "DirectoryPath")]
    pub directory_path: String,
    /// <p>The access mode of the mount of the directory associated with the channel. A directory can be mounted either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.</p>
    #[serde(rename = "FileSystemAccessMode")]
    pub file_system_access_mode: String,
    /// <p>The file system id.</p>
    #[serde(rename = "FileSystemId")]
    pub file_system_id: String,
    /// <p>The file system type. </p>
    #[serde(rename = "FileSystemType")]
    pub file_system_type: String,
}

/// <p><p>A conditional statement for a search expression that includes a resource property, a Boolean operator, and a value. Resources that match the statement are returned in the results from the <a>Search</a> API.</p> <p>If you specify a <code>Value</code>, but not an <code>Operator</code>, Amazon SageMaker uses the equals operator.</p> <p>In search, there are several property types:</p> <dl> <dt>Metrics</dt> <dd> <p>To define a metric filter, enter a value using the form <code>&quot;Metrics.&lt;name&gt;&quot;</code>, where <code>&lt;name&gt;</code> is a metric name. For example, the following filter searches for training jobs with an <code>&quot;accuracy&quot;</code> metric greater than <code>&quot;0.9&quot;</code>:</p> <p> <code>{</code> </p> <p> <code>&quot;Name&quot;: &quot;Metrics.accuracy&quot;,</code> </p> <p> <code>&quot;Operator&quot;: &quot;GreaterThan&quot;,</code> </p> <p> <code>&quot;Value&quot;: &quot;0.9&quot;</code> </p> <p> <code>}</code> </p> </dd> <dt>HyperParameters</dt> <dd> <p>To define a hyperparameter filter, enter a value with the form <code>&quot;HyperParameters.&lt;name&gt;&quot;</code>. Decimal hyperparameter values are treated as a decimal in a comparison if the specified <code>Value</code> is also a decimal value. If the specified <code>Value</code> is an integer, the decimal hyperparameter values are treated as integers. For example, the following filter is satisfied by training jobs with a <code>&quot;learning<em>rate&quot;</code> hyperparameter that is less than <code>&quot;0.5&quot;</code>:</p> <p> <code> {</code> </p> <p> <code> &quot;Name&quot;: &quot;HyperParameters.learning</em>rate&quot;,</code> </p> <p> <code> &quot;Operator&quot;: &quot;LessThan&quot;,</code> </p> <p> <code> &quot;Value&quot;: &quot;0.5&quot;</code> </p> <p> <code> }</code> </p> </dd> <dt>Tags</dt> <dd> <p>To define a tag filter, enter a value with the form <code>Tags.&lt;key&gt;</code>.</p> </dd> </dl></p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Filter {
    /// <p>A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see <a>SearchRecord</a>. You must specify a valid property for the resource.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p><p>A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following values:</p> <dl> <dt>Equals</dt> <dd> <p>The value of <code>Name</code> equals <code>Value</code>.</p> </dd> <dt>NotEquals</dt> <dd> <p>The value of <code>Name</code> doesn&#39;t equal <code>Value</code>.</p> </dd> <dt>Exists</dt> <dd> <p>The <code>Name</code> property exists.</p> </dd> <dt>NotExists</dt> <dd> <p>The <code>Name</code> property does not exist.</p> </dd> <dt>GreaterThan</dt> <dd> <p>The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>GreaterThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThan</dt> <dd> <p>The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>In</dt> <dd> <p>The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported for text properties.</p> </dd> <dt>Contains</dt> <dd> <p>The value of <code>Name</code> contains the string <code>Value</code>. Only supported for text properties.</p> <p>A <code>SearchExpression</code> can include the <code>Contains</code> operator multiple times when the value of <code>Name</code> is one of the following:</p> <ul> <li> <p> <code>Experiment.DisplayName</code> </p> </li> <li> <p> <code>Experiment.ExperimentName</code> </p> </li> <li> <p> <code>Experiment.Tags</code> </p> </li> <li> <p> <code>Trial.DisplayName</code> </p> </li> <li> <p> <code>Trial.TrialName</code> </p> </li> <li> <p> <code>Trial.Tags</code> </p> </li> <li> <p> <code>TrialComponent.DisplayName</code> </p> </li> <li> <p> <code>TrialComponent.TrialComponentName</code> </p> </li> <li> <p> <code>TrialComponent.Tags</code> </p> </li> <li> <p> <code>TrialComponent.InputArtifacts</code> </p> </li> <li> <p> <code>TrialComponent.OutputArtifacts</code> </p> </li> </ul> <p>A <code>SearchExpression</code> can include only one <code>Contains</code> operator for all other values of <code>Name</code>. In these cases, if you include multiple <code>Contains</code> operators in the <code>SearchExpression</code>, the result is the following error message: &quot;<code>&#39;CONTAINS&#39; operator usage limit of 1 exceeded.</code>&quot;</p> </dd> </dl></p>
    #[serde(rename = "Operator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub operator: Option<String>,
    /// <p>A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the filter's condition. For numerical properties, <code>Value</code> must be an integer or floating-point decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the following format: <code>YYYY-mm-dd'T'HH:MM:SS</code>.</p>
    #[serde(rename = "Value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}

/// <p>The best candidate result from an AutoML training job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FinalAutoMLJobObjectiveMetric {
    /// <p>The name of the metric with the best result. For a description of the possible objective metrics, see <a>AutoMLJobObjective$MetricName</a>.</p>
    #[serde(rename = "MetricName")]
    pub metric_name: String,
    /// <p>The type of metric with the best result.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    /// <p>The value of the metric with the best result.</p>
    #[serde(rename = "Value")]
    pub value: f32,
}

/// <p>Shows the final value for the objective metric for a training job that was launched by a hyperparameter tuning job. You define the objective metric in the <code>HyperParameterTuningJobObjective</code> parameter of <a>HyperParameterTuningJobConfig</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FinalHyperParameterTuningJobObjectiveMetric {
    /// <p>The name of the objective metric.</p>
    #[serde(rename = "MetricName")]
    pub metric_name: String,
    /// <p>Whether to minimize or maximize the objective metric. Valid values are Minimize and Maximize.</p>
    #[serde(rename = "Type")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub type_: Option<String>,
    /// <p>The value of the objective metric.</p>
    #[serde(rename = "Value")]
    pub value: f32,
}

/// <p>Contains information about where human output will be stored.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct FlowDefinitionOutputConfig {
    /// <p>The Amazon Key Management Service (KMS) key ID for server-side encryption.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The Amazon S3 path where the object containing human output will be made available.</p> <p>To learn more about the format of Amazon A2I output data, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-output-data.html">Amazon A2I Output Data</a>.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>Contains summary information about the flow definition.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct FlowDefinitionSummary {
    /// <p>The timestamp when SageMaker created the flow definition.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The reason why the flow definition creation failed. A failure reason is returned only when the flow definition status is <code>Failed</code>.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
    #[serde(rename = "FlowDefinitionArn")]
    pub flow_definition_arn: String,
    /// <p>The name of the flow definition.</p>
    #[serde(rename = "FlowDefinitionName")]
    pub flow_definition_name: String,
    /// <p>The status of the flow definition. Valid values:</p>
    #[serde(rename = "FlowDefinitionStatus")]
    pub flow_definition_status: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetDeviceFleetReportRequest {
    /// <p>The name of the fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetDeviceFleetReportResponse {
    /// <p>The versions of Edge Manager agent deployed on the fleet.</p>
    #[serde(rename = "AgentVersions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub agent_versions: Option<Vec<AgentVersion>>,
    /// <p>Description of the fleet.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    #[serde(rename = "DeviceFleetArn")]
    pub device_fleet_arn: String,
    /// <p>The name of the fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>Status of devices.</p>
    #[serde(rename = "DeviceStats")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub device_stats: Option<DeviceStats>,
    /// <p>Status of model on device.</p>
    #[serde(rename = "ModelStats")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_stats: Option<Vec<EdgeModelStat>>,
    /// <p>The output configuration for storing sample data collected by the fleet.</p>
    #[serde(rename = "OutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_config: Option<EdgeOutputConfig>,
    /// <p>Timestamp of when the report was generated.</p>
    #[serde(rename = "ReportGenerated")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub report_generated: Option<f64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetModelPackageGroupPolicyInput {
    /// <p>The name of the model group for which to get the resource policy.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetModelPackageGroupPolicyOutput {
    /// <p>The resource policy for the model group.</p>
    #[serde(rename = "ResourcePolicy")]
    pub resource_policy: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSagemakerServicecatalogPortfolioStatusInput {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetSagemakerServicecatalogPortfolioStatusOutput {
    /// <p>Whether Service Catalog is enabled or disabled in SageMaker.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetSearchSuggestionsRequest {
    /// <p>The name of the Amazon SageMaker resource to search for.</p>
    #[serde(rename = "Resource")]
    pub resource: String,
    /// <p>Limits the property names that are included in the response.</p>
    #[serde(rename = "SuggestionQuery")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub suggestion_query: Option<SuggestionQuery>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct GetSearchSuggestionsResponse {
    /// <p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>
    #[serde(rename = "PropertyNameSuggestions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub property_name_suggestions: Option<Vec<PropertyNameSuggestion>>,
}

/// <p>Specifies configuration details for a Git repository in your AWS account.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct GitConfig {
    /// <p>The default branch for the Git repository.</p>
    #[serde(rename = "Branch")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    /// <p>The URL where the Git repository is located.</p>
    #[serde(rename = "RepositoryUrl")]
    pub repository_url: String,
    /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>
    #[serde(rename = "SecretArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secret_arn: Option<String>,
}

/// <p>Specifies configuration details for a Git repository when the repository is updated.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GitConfigForUpdate {
    /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>
    #[serde(rename = "SecretArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secret_arn: Option<String>,
}

/// <p>Defines under what conditions SageMaker creates a human loop. Used within . See for the required format of activation conditions.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HumanLoopActivationConditionsConfig {
    /// <p>JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. The set of conditions is different for Rekognition and Textract. For more information about how to structure the JSON, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html">JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>
    #[serde(rename = "HumanLoopActivationConditions")]
    pub human_loop_activation_conditions: String,
}

/// <p>Provides information about how and under what conditions SageMaker creates a human loop. If <code>HumanLoopActivationConfig</code> is not given, then all requests go to humans.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HumanLoopActivationConfig {
    /// <p>Container structure for defining under what conditions SageMaker creates a human loop.</p>
    #[serde(rename = "HumanLoopActivationConditionsConfig")]
    pub human_loop_activation_conditions_config: HumanLoopActivationConditionsConfig,
}

/// <p>Describes the work to be performed by human workers.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HumanLoopConfig {
    /// <p>The Amazon Resource Name (ARN) of the human task user interface.</p> <p>You can use standard HTML and Crowd HTML Elements to create a custom worker task template. You use this template to create a human task UI.</p> <p>To learn how to create a custom HTML template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html">Create Custom Worker Task Template</a>.</p> <p>To learn how to create a human task UI, which is a worker task template that can be used in a flow definition, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html">Create and Delete a Worker Task Templates</a>.</p>
    #[serde(rename = "HumanTaskUiArn")]
    pub human_task_ui_arn: String,
    #[serde(rename = "PublicWorkforceTaskPrice")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub public_workforce_task_price: Option<PublicWorkforceTaskPrice>,
    /// <p>The length of time that a task remains available for review by human workers.</p>
    #[serde(rename = "TaskAvailabilityLifetimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_availability_lifetime_in_seconds: Option<i64>,
    /// <p>The number of distinct workers who will perform the same task on each object. For example, if <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers will classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.</p>
    #[serde(rename = "TaskCount")]
    pub task_count: i64,
    /// <p>A description for the human worker task.</p>
    #[serde(rename = "TaskDescription")]
    pub task_description: String,
    /// <p>Keywords used to describe the task so that workers can discover the task.</p>
    #[serde(rename = "TaskKeywords")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_keywords: Option<Vec<String>>,
    /// <p>The amount of time that a worker has to complete a task. The default value is 3,600 seconds (1 hour).</p>
    #[serde(rename = "TaskTimeLimitInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_time_limit_in_seconds: Option<i64>,
    /// <p>A title for the human worker task.</p>
    #[serde(rename = "TaskTitle")]
    pub task_title: String,
    /// <p>Amazon Resource Name (ARN) of a team of workers. To learn more about the types of workforces and work teams you can create and use with Amazon A2I, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html">Create and Manage Workforces</a>.</p>
    #[serde(rename = "WorkteamArn")]
    pub workteam_arn: String,
}

/// <p>Container for configuring the source of human task requests.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HumanLoopRequestSource {
    /// <p>Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field settings and JSON parsing rules are different based on the integration source. Valid values:</p>
    #[serde(rename = "AwsManagedHumanLoopRequestSource")]
    pub aws_managed_human_loop_request_source: String,
}

/// <p>Information required for human workers to complete a labeling task.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HumanTaskConfig {
    /// <p>Configures how labels are consolidated across human workers.</p>
    #[serde(rename = "AnnotationConsolidationConfig")]
    pub annotation_consolidation_config: AnnotationConsolidationConfig,
    /// <p>Defines the maximum number of data objects that can be labeled by human workers at the same time. Also referred to as batch size. Each object may have more than one worker at one time. The default value is 1000 objects.</p>
    #[serde(rename = "MaxConcurrentTaskCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_concurrent_task_count: Option<i64>,
    /// <p>The number of human workers that will label an object. </p>
    #[serde(rename = "NumberOfHumanWorkersPerDataObject")]
    pub number_of_human_workers_per_data_object: i64,
    /// <p><p>The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human worker. Use this function to provide input to a custom labeling job.</p> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda">Pre-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as &quot;votes&quot; for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Modalities</b> </p> <p>Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud Task types </a> to learn more. </p> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as &quot;votes&quot; for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul></p>
    #[serde(rename = "PreHumanTaskLambdaArn")]
    pub pre_human_task_lambda_arn: String,
    /// <p>The price that you pay for each task performed by an Amazon Mechanical Turk worker.</p>
    #[serde(rename = "PublicWorkforceTaskPrice")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub public_workforce_task_price: Option<PublicWorkforceTaskPrice>,
    /// <p><p>The length of time that a task remains available for labeling by human workers. The default and maximum values for this parameter depend on the type of workforce you use.</p> <ul> <li> <p>If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43,200 seconds). The default is 6 hours (21,600 seconds).</p> </li> <li> <p>If you choose a private or vendor workforce, the default value is 10 days (864,000 seconds). For most users, the maximum is also 10 days. If you want to change this limit, contact AWS Support.</p> </li> </ul></p>
    #[serde(rename = "TaskAvailabilityLifetimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_availability_lifetime_in_seconds: Option<i64>,
    /// <p>A description of the task for your human workers.</p>
    #[serde(rename = "TaskDescription")]
    pub task_description: String,
    /// <p>Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.</p>
    #[serde(rename = "TaskKeywords")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub task_keywords: Option<Vec<String>>,
    /// <p><p>The amount of time that a worker has to complete a task. </p> <p>If you create a custom labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).</p> <p>If you create a labeling job using a <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task type</a> the maximum for this parameter depends on the task type you use:</p> <ul> <li> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html">image</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html">text</a> labeling jobs, the maximum is 8 hours (28,800 seconds).</p> </li> <li> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html">3D point cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html">video frame</a> labeling jobs, the maximum is 7 days (604,800 seconds). If you want to change these limits, contact AWS Support.</p> </li> </ul></p>
    #[serde(rename = "TaskTimeLimitInSeconds")]
    pub task_time_limit_in_seconds: i64,
    /// <p>A title for the task for your human workers.</p>
    #[serde(rename = "TaskTitle")]
    pub task_title: String,
    /// <p>Information about the user interface that workers use to complete the labeling task.</p>
    #[serde(rename = "UiConfig")]
    pub ui_config: UiConfig,
    /// <p>The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.</p>
    #[serde(rename = "WorkteamArn")]
    pub workteam_arn: String,
}

/// <p>Container for human task user interface information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct HumanTaskUiSummary {
    /// <p>A timestamp when SageMaker created the human task user interface.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the human task user interface.</p>
    #[serde(rename = "HumanTaskUiArn")]
    pub human_task_ui_arn: String,
    /// <p>The name of the human task user interface.</p>
    #[serde(rename = "HumanTaskUiName")]
    pub human_task_ui_name: String,
}

/// <p>Specifies which training algorithm to use for training jobs that a hyperparameter tuning job launches and the metrics to monitor.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HyperParameterAlgorithmSpecification {
    /// <p>The name of the resource algorithm to use for the hyperparameter tuning job. If you specify a value for this parameter, do not specify a value for <code>TrainingImage</code>.</p>
    #[serde(rename = "AlgorithmName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub algorithm_name: Option<String>,
    /// <p>An array of <a>MetricDefinition</a> objects that specify the metrics that the algorithm emits.</p>
    #[serde(rename = "MetricDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_definitions: Option<Vec<MetricDefinition>>,
    /// <p> The registry path of the Docker image that contains the training algorithm. For information about Docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>
    #[serde(rename = "TrainingImage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_image: Option<String>,
    /// <p>The input mode that the algorithm supports: File or Pipe. In File input mode, Amazon SageMaker downloads the training data from Amazon S3 to the storage volume that is attached to the training instance and mounts the directory to the Docker volume for the training container. In Pipe input mode, Amazon SageMaker streams data directly from Amazon S3 to the container. </p> <p>If you specify File mode, make sure that you provision the storage volume that is attached to the training instance with enough capacity to accommodate the training data downloaded from Amazon S3, the model artifacts, and intermediate information.</p> <p/> <p>For more information about input modes, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
    #[serde(rename = "TrainingInputMode")]
    pub training_input_mode: String,
}

/// <p>Defines a hyperparameter to be used by an algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HyperParameterSpecification {
    /// <p>The default value for this hyperparameter. If a default value is specified, a hyperparameter cannot be required.</p>
    #[serde(rename = "DefaultValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_value: Option<String>,
    /// <p>A brief description of the hyperparameter.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>Indicates whether this hyperparameter is required.</p>
    #[serde(rename = "IsRequired")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_required: Option<bool>,
    /// <p>Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.</p>
    #[serde(rename = "IsTunable")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub is_tunable: Option<bool>,
    /// <p>The name of this hyperparameter. The name must be unique.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The allowed range for this hyperparameter.</p>
    #[serde(rename = "Range")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub range: Option<ParameterRange>,
    /// <p>The type of this hyperparameter. The valid types are <code>Integer</code>, <code>Continuous</code>, <code>Categorical</code>, and <code>FreeText</code>.</p>
    #[serde(rename = "Type")]
    pub type_: String,
}

/// <p>Defines the training jobs launched by a hyperparameter tuning job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HyperParameterTrainingJobDefinition {
    /// <p>The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the training jobs that the tuning job launches.</p>
    #[serde(rename = "AlgorithmSpecification")]
    pub algorithm_specification: HyperParameterAlgorithmSpecification,
    #[serde(rename = "CheckpointConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub checkpoint_config: Option<CheckpointConfig>,
    /// <p>The job definition name.</p>
    #[serde(rename = "DefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub definition_name: Option<String>,
    /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>
    #[serde(rename = "EnableManagedSpotTraining")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_managed_spot_training: Option<bool>,
    /// <p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If network isolation is used for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    #[serde(rename = "HyperParameterRanges")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameter_ranges: Option<ParameterRanges>,
    /// <p>An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.</p>
    #[serde(rename = "InputDataConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_data_config: Option<Vec<Channel>>,
    /// <p>Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning job launches.</p>
    #[serde(rename = "OutputDataConfig")]
    pub output_data_config: OutputDataConfig,
    /// <p>The resources, including the compute instances and storage volumes, to use for the training jobs that the tuning job launches.</p> <p>Storage volumes store model artifacts and incremental states. Training algorithms might also use storage volumes for scratch space. If you want Amazon SageMaker to use the storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>
    #[serde(rename = "ResourceConfig")]
    pub resource_config: ResourceConfig,
    /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
    #[serde(rename = "RetryStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retry_strategy: Option<RetryStrategy>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job launches.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Specifies the values of hyperparameters that do not change for the tuning job.</p>
    #[serde(rename = "StaticHyperParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub static_hyper_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
    #[serde(rename = "StoppingCondition")]
    pub stopping_condition: StoppingCondition,
    #[serde(rename = "TuningObjective")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tuning_objective: Option<HyperParameterTuningJobObjective>,
    /// <p>The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this hyperparameter tuning job launches to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

/// <p>Specifies summary information about a training job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct HyperParameterTrainingJobSummary {
    /// <p>The date and time that the training job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The reason that the training job failed. </p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective metric of the tuning job that launched this training job.</p>
    #[serde(rename = "FinalHyperParameterTuningJobObjectiveMetric")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub final_hyper_parameter_tuning_job_objective_metric:
        Option<FinalHyperParameterTuningJobObjectiveMetric>,
    /// <p><p>The status of the objective metric for the training job:</p> <ul> <li> <p>Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p> </li> </ul> <ul> <li> <p>Pending: The training job is in progress and evaluation of its final objective metric is pending.</p> </li> </ul> <ul> <li> <p>Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p> </li> </ul></p>
    #[serde(rename = "ObjectiveStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub objective_status: Option<String>,
    /// <p>Specifies the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
    #[serde(rename = "TrainingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    #[serde(rename = "TrainingJobArn")]
    pub training_job_arn: String,
    /// <p>The training job definition name.</p>
    #[serde(rename = "TrainingJobDefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_definition_name: Option<String>,
    /// <p>The name of the training job.</p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
    /// <p>The status of the training job.</p>
    #[serde(rename = "TrainingJobStatus")]
    pub training_job_status: String,
    /// <p>The date and time that the training job started.</p>
    #[serde(rename = "TrainingStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_start_time: Option<f64>,
    /// <p>A list of the hyperparameters for which you specified ranges to search.</p>
    #[serde(rename = "TunedHyperParameters")]
    pub tuned_hyper_parameters: ::std::collections::HashMap<String, String>,
    /// <p>The HyperParameter tuning job that launched the training job.</p>
    #[serde(rename = "TuningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tuning_job_name: Option<String>,
}

/// <p>Configures a hyperparameter tuning job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HyperParameterTuningJobConfig {
    /// <p>The <a>HyperParameterTuningJobObjective</a> object that specifies the objective metric for this tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobObjective")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameter_tuning_job_objective: Option<HyperParameterTuningJobObjective>,
    /// <p>The <a>ParameterRanges</a> object that specifies the ranges of hyperparameters that this tuning job searches.</p>
    #[serde(rename = "ParameterRanges")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameter_ranges: Option<ParameterRanges>,
    /// <p>The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs for this tuning job.</p>
    #[serde(rename = "ResourceLimits")]
    pub resource_limits: ResourceLimits,
    /// <p>Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job it launches. To use the Bayesian search strategy, set this to <code>Bayesian</code>. To randomly search, set it to <code>Random</code>. For information about search strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>
    #[serde(rename = "Strategy")]
    pub strategy: String,
    /// <p><p>Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. This can be one of the following values (the default value is <code>OFF</code>):</p> <dl> <dt>OFF</dt> <dd> <p>Training jobs launched by the hyperparameter tuning job do not use early stopping.</p> </dd> <dt>AUTO</dt> <dd> <p>Amazon SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better than previously completed training jobs. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training Jobs Early</a>.</p> </dd> </dl></p>
    #[serde(rename = "TrainingJobEarlyStoppingType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_early_stopping_type: Option<String>,
    /// <p>The tuning job's completion criteria.</p>
    #[serde(rename = "TuningJobCompletionCriteria")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tuning_job_completion_criteria: Option<TuningJobCompletionCriteria>,
}

/// <p>Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest value for this metric, depending on the value you specify for the <code>Type</code> parameter.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HyperParameterTuningJobObjective {
    /// <p>The name of the metric to use for the objective metric.</p>
    #[serde(rename = "MetricName")]
    pub metric_name: String,
    /// <p>Whether to minimize or maximize the objective metric.</p>
    #[serde(rename = "Type")]
    pub type_: String,
}

/// <p>Provides summary information about a hyperparameter tuning job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct HyperParameterTuningJobSummary {
    /// <p>The date and time that the tuning job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The date and time that the tuning job ended.</p>
    #[serde(rename = "HyperParameterTuningEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameter_tuning_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobArn")]
    pub hyper_parameter_tuning_job_arn: String,
    /// <p>The name of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    pub hyper_parameter_tuning_job_name: String,
    /// <p>The status of the tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobStatus")]
    pub hyper_parameter_tuning_job_status: String,
    /// <p>The date and time that the tuning job was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by objective metric status, that this tuning job launched.</p>
    #[serde(rename = "ObjectiveStatusCounters")]
    pub objective_status_counters: ObjectiveStatusCounters,
    /// <p>The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs allowed for this tuning job.</p>
    #[serde(rename = "ResourceLimits")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_limits: Option<ResourceLimits>,
    /// <p>Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each iteration. Currently, the only valid value is Bayesian.</p>
    #[serde(rename = "Strategy")]
    pub strategy: String,
    /// <p>The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by status, that this tuning job launched.</p>
    #[serde(rename = "TrainingJobStatusCounters")]
    pub training_job_status_counters: TrainingJobStatusCounters,
}

/// <p><p>Specifies the configuration for a hyperparameter tuning job that uses one or more previous hyperparameter tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric, and the training job that performs the best is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct HyperParameterTuningJobWarmStartConfig {
    /// <p>An array of hyperparameter tuning jobs that are used as the starting point for the new hyperparameter tuning job. For more information about warm starting a hyperparameter tuning job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html">Using a Previous Hyperparameter Tuning Job as a Starting Point</a>.</p> <p>Hyperparameter tuning jobs created before October 1, 2018 cannot be used as parent jobs for warm start tuning jobs.</p>
    #[serde(rename = "ParentHyperParameterTuningJobs")]
    pub parent_hyper_parameter_tuning_jobs: Vec<ParentHyperParameterTuningJob>,
    /// <p><p>Specifies one of the following:</p> <dl> <dt>IDENTICAL<em>DATA</em>AND<em>ALGORITHM</dt> <dd> <p>The new hyperparameter tuning job uses the same input data and training image as the parent tuning jobs. You can change the hyperparameter ranges to search and the maximum number of training jobs that the hyperparameter tuning job launches. You cannot use a new version of the training algorithm, unless the changes in the new version do not affect the algorithm itself. For example, changes that improve logging or adding support for a different data format are allowed. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> <dt>TRANSFER</em>LEARNING</dt> <dd> <p>The new hyperparameter tuning job can include input data, hyperparameter ranges, maximum number of concurrent training jobs, and maximum number of training jobs that are different than those of its parent hyperparameter tuning jobs. The training image can also be a different version from the version used in the parent hyperparameter tuning job. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> </dl></p>
    #[serde(rename = "WarmStartType")]
    pub warm_start_type: String,
}

/// <p>A SageMaker image. A SageMaker image represents a set of container images that are derived from a common base container image. Each of these container images is represented by a SageMaker <code>ImageVersion</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Image {
    /// <p>When the image was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The description of the image.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the image as displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When a create, update, or delete operation fails, the reason for the failure.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    #[serde(rename = "ImageArn")]
    pub image_arn: String,
    /// <p>The name of the image.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>The status of the image.</p>
    #[serde(rename = "ImageStatus")]
    pub image_status: String,
    /// <p>When the image was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
}

/// <p>Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ImageConfig {
    /// <p><p>Set this to one of the following values:</p> <ul> <li> <p> <code>Platform</code> - The model image is hosted in Amazon ECR.</p> </li> <li> <p> <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.</p> </li> </ul></p>
    #[serde(rename = "RepositoryAccessMode")]
    pub repository_access_mode: String,
    /// <p>(Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is hosted requires authentication.</p>
    #[serde(rename = "RepositoryAuthConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub repository_auth_config: Option<RepositoryAuthConfig>,
}

/// <p>A version of a SageMaker <code>Image</code>. A version represents an existing container image.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ImageVersion {
    /// <p>When the version was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>When a create or delete operation fails, the reason for the failure.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the image the version is based on.</p>
    #[serde(rename = "ImageArn")]
    pub image_arn: String,
    /// <p>The ARN of the version.</p>
    #[serde(rename = "ImageVersionArn")]
    pub image_version_arn: String,
    /// <p>The status of the version.</p>
    #[serde(rename = "ImageVersionStatus")]
    pub image_version_status: String,
    /// <p>When the version was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The version number.</p>
    #[serde(rename = "Version")]
    pub version: i64,
}

/// <p>Specifies details about how containers in a multi-container endpoint are run.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct InferenceExecutionConfig {
    /// <p><p>How containers in a multi-container are run. The following values are valid.</p> <ul> <li> <p> <code>SERIAL</code> - Containers run as a serial pipeline.</p> </li> <li> <p> <code>DIRECT</code> - Only the individual container that you specify is run.</p> </li> </ul></p>
    #[serde(rename = "Mode")]
    pub mode: String,
}

/// <p>Defines how to perform inference generation after a training job is run.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct InferenceSpecification {
    /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
    #[serde(rename = "Containers")]
    pub containers: Vec<ModelPackageContainerDefinition>,
    /// <p>The supported MIME types for the input data.</p>
    #[serde(rename = "SupportedContentTypes")]
    pub supported_content_types: Vec<String>,
    /// <p>A list of the instance types that are used to generate inferences in real-time.</p> <p>This parameter is required for unversioned models, and optional for versioned models.</p>
    #[serde(rename = "SupportedRealtimeInferenceInstanceTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_realtime_inference_instance_types: Option<Vec<String>>,
    /// <p>The supported MIME types for the output data.</p>
    #[serde(rename = "SupportedResponseMIMETypes")]
    pub supported_response_mime_types: Vec<String>,
    /// <p>A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.</p> <p>This parameter is required for unversioned models, and optional for versioned models.</p>
    #[serde(rename = "SupportedTransformInstanceTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_transform_instance_types: Option<Vec<String>>,
}

/// <p>Contains information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct InputConfig {
    /// <p><p>Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. The data inputs are <a>InputConfig$Framework</a> specific. </p> <ul> <li> <p> <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{&quot;input&quot;:[1,1024,1024,3]}</code> </p> </li> <li> <p>If using the CLI, <code>{&quot;input&quot;:[1,1024,1024,3]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{&quot;data1&quot;: [1,28,28,1], &quot;data2&quot;:[1,28,28,1]}</code> </p> </li> <li> <p>If using the CLI, <code>{&quot;data1&quot;: [1,28,28,1], &quot;data2&quot;:[1,28,28,1]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in NHWC (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first) format. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{&quot;input<em>1&quot;:[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{&quot;input</em>1&quot;:[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{&quot;input<em>1&quot;: [1,3,224,224], &quot;input</em>2&quot;:[1,3,224,224]} </code> </p> </li> <li> <p>If using the CLI, <code>{&quot;input<em>1&quot;: [1,3,224,224], &quot;input</em>2&quot;:[1,3,224,224]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>MXNET/ONNX/DARKNET</code>: You must specify the name and shape (NCHW format) of the expected data inputs in order using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{&quot;data&quot;:[1,3,1024,1024]}</code> </p> </li> <li> <p>If using the CLI, <code>{&quot;data&quot;:[1,3,1024,1024]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{&quot;var1&quot;: [1,1,28,28], &quot;var2&quot;:[1,1,28,28]} </code> </p> </li> <li> <p>If using the CLI, <code>{&quot;var1&quot;: [1,1,28,28], &quot;var2&quot;:[1,1,28,28]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in order using a dictionary format for your trained model or you can specify the shape only using a list format. The dictionary formats required for the console and CLI are different. The list formats for the console and CLI are the same.</p> <ul> <li> <p>Examples for one input in dictionary format:</p> <ul> <li> <p>If using the console, <code>{&quot;input0&quot;:[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{&quot;input0&quot;:[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Example for one input in list format: <code>[[1,3,224,224]]</code> </p> </li> <li> <p>Examples for two inputs in dictionary format:</p> <ul> <li> <p>If using the console, <code>{&quot;input0&quot;:[1,3,224,224], &quot;input1&quot;:[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{&quot;input0&quot;:[1,3,224,224], &quot;input1&quot;:[1,3,224,224]} </code> </p> </li> </ul> </li> <li> <p>Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code> </p> </li> </ul> </li> <li> <p> <code>XGBOOST</code>: input data name and shape are not needed.</p> </li> </ul> <p> <code>DataInputConfig</code> supports the following parameters for <code>CoreML</code> <a>OutputConfig$TargetDevice</a> (ML Model format):</p> <ul> <li> <p> <code>shape</code>: Input shape, for example <code>{&quot;input<em>1&quot;: {&quot;shape&quot;: [1,224,224,3]}}</code>. In addition to static input shapes, CoreML converter supports Flexible input shapes:</p> <ul> <li> <p>Range Dimension. You can use the Range Dimension feature if you know the input shape will be within some specific interval in that dimension, for example: <code>{&quot;input</em>1&quot;: {&quot;shape&quot;: [&quot;1..10&quot;, 224, 224, 3]}}</code> </p> </li> <li> <p>Enumerated shapes. Sometimes, the models are trained to work only on a select set of inputs. You can enumerate all supported input shapes, for example: <code>{&quot;input<em>1&quot;: {&quot;shape&quot;: [[1, 224, 224, 3], [1, 160, 160, 3]]}}</code> </p> </li> </ul> </li> <li> <p> <code>default</em>shape</code>: Default input shape. You can set a default shape during conversion for both Range Dimension and Enumerated Shapes. For example <code>{&quot;input<em>1&quot;: {&quot;shape&quot;: [&quot;1..10&quot;, 224, 224, 3], &quot;default</em>shape&quot;: [1, 224, 224, 3]}}</code> </p> </li> <li> <p> <code>type</code>: Input type. Allowed values: <code>Image</code> and <code>Tensor</code>. By default, the converter generates an ML Model with inputs of type Tensor (MultiArray). User can set input type to be Image. Image input type requires additional input parameters such as <code>bias</code> and <code>scale</code>.</p> </li> <li> <p> <code>bias</code>: If the input type is an Image, you need to provide the bias vector.</p> </li> <li> <p> <code>scale</code>: If the input type is an Image, you need to provide a scale factor.</p> </li> </ul> <p>CoreML <code>ClassifierConfig</code> parameters can be specified using <a>OutputConfig$CompilerOptions</a>. CoreML converter supports Tensorflow and PyTorch models. CoreML conversion examples:</p> <ul> <li> <p>Tensor type input:</p> <ul> <li> <p> <code>&quot;DataInputConfig&quot;: {&quot;input<em>1&quot;: {&quot;shape&quot;: [[1,224,224,3], [1,160,160,3]], &quot;default</em>shape&quot;: [1,224,224,3]}}</code> </p> </li> </ul> </li> <li> <p>Tensor type input without input name (PyTorch):</p> <ul> <li> <p> <code>&quot;DataInputConfig&quot;: [{&quot;shape&quot;: [[1,3,224,224], [1,3,160,160]], &quot;default<em>shape&quot;: [1,3,224,224]}]</code> </p> </li> </ul> </li> <li> <p>Image type input:</p> <ul> <li> <p> <code>&quot;DataInputConfig&quot;: {&quot;input</em>1&quot;: {&quot;shape&quot;: [[1,224,224,3], [1,160,160,3]], &quot;default<em>shape&quot;: [1,224,224,3], &quot;type&quot;: &quot;Image&quot;, &quot;bias&quot;: [-1,-1,-1], &quot;scale&quot;: 0.007843137255}}</code> </p> </li> <li> <p> <code>&quot;CompilerOptions&quot;: {&quot;class</em>labels&quot;: &quot;imagenet<em>labels</em>1000.txt&quot;}</code> </p> </li> </ul> </li> <li> <p>Image type input without input name (PyTorch):</p> <ul> <li> <p> <code>&quot;DataInputConfig&quot;: [{&quot;shape&quot;: [[1,3,224,224], [1,3,160,160]], &quot;default<em>shape&quot;: [1,3,224,224], &quot;type&quot;: &quot;Image&quot;, &quot;bias&quot;: [-1,-1,-1], &quot;scale&quot;: 0.007843137255}]</code> </p> </li> <li> <p> <code>&quot;CompilerOptions&quot;: {&quot;class</em>labels&quot;: &quot;imagenet<em>labels</em>1000.txt&quot;}</code> </p> </li> </ul> </li> </ul> <p>Depending on the model format, <code>DataInputConfig</code> requires the following parameters for <code>ml<em>eia2</code> &lt;a href=&quot;https://docs.aws.amazon.com/sagemaker/latest/APIReference/API</em>OutputConfig.html#sagemaker-Type-OutputConfig-TargetDevice&quot;&gt;OutputConfig:TargetDevice</a>.</p> <ul> <li> <p>For TensorFlow models saved in the SavedModel format, specify the input names from <code>signature<em>def</em>key</code> and the input model shapes for <code>DataInputConfig</code>. Specify the <code>signature<em>def</em>key</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions"> <code>OutputConfig:CompilerOptions</code> </a> if the model does not use TensorFlow&#39;s default signature def key. For example:</p> <ul> <li> <p> <code>&quot;DataInputConfig&quot;: {&quot;inputs&quot;: [1, 224, 224, 3]}</code> </p> </li> <li> <p> <code>&quot;CompilerOptions&quot;: {&quot;signature<em>def</em>key&quot;: &quot;serving<em>custom&quot;}</code> </p> </li> </ul> </li> <li> <p>For TensorFlow models saved as a frozen graph, specify the input tensor names and shapes in <code>DataInputConfig</code> and the output tensor names for <code>output</em>names</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions"> <code>OutputConfig:CompilerOptions</code> </a>. For example:</p> <ul> <li> <p> <code>&quot;DataInputConfig&quot;: {&quot;input<em>tensor:0&quot;: [1, 224, 224, 3]}</code> </p> </li> <li> <p> <code>&quot;CompilerOptions&quot;: {&quot;output</em>names&quot;: [&quot;output_tensor:0&quot;]}</code> </p> </li> </ul> </li> </ul></p>
    #[serde(rename = "DataInputConfig")]
    pub data_input_config: String,
    /// <p>Identifies the framework in which the model was trained. For example: TENSORFLOW.</p>
    #[serde(rename = "Framework")]
    pub framework: String,
    /// <p>Specifies the framework version to use.</p> <p>This API field is only supported for PyTorch framework versions <code>1.4</code>, <code>1.5</code>, and <code>1.6</code> for cloud instance target devices: <code>ml_c4</code>, <code>ml_c5</code>, <code>ml_m4</code>, <code>ml_m5</code>, <code>ml_p2</code>, <code>ml_p3</code>, and <code>ml_g4dn</code>.</p>
    #[serde(rename = "FrameworkVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub framework_version: Option<String>,
    /// <p>The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>For a hyperparameter of the integer type, specifies the range that a hyperparameter tuning job searches.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IntegerParameterRange {
    /// <p>The maximum value of the hyperparameter to search.</p>
    #[serde(rename = "MaxValue")]
    pub max_value: String,
    /// <p>The minimum value of the hyperparameter to search.</p>
    #[serde(rename = "MinValue")]
    pub min_value: String,
    /// <p>The name of the hyperparameter to search.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p><p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> </dl></p>
    #[serde(rename = "ScalingType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scaling_type: Option<String>,
}

/// <p>Defines the possible values for an integer hyperparameter.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct IntegerParameterRangeSpecification {
    /// <p>The maximum integer value allowed.</p>
    #[serde(rename = "MaxValue")]
    pub max_value: String,
    /// <p>The minimum integer value allowed.</p>
    #[serde(rename = "MinValue")]
    pub min_value: String,
}

/// <p>The JupyterServer app settings.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct JupyterServerAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.</p>
    #[serde(rename = "DefaultResourceSpec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_resource_spec: Option<ResourceSpec>,
}

/// <p>The KernelGateway app settings.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KernelGatewayAppSettings {
    /// <p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>
    #[serde(rename = "CustomImages")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub custom_images: Option<Vec<CustomImage>>,
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.</p>
    #[serde(rename = "DefaultResourceSpec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_resource_spec: Option<ResourceSpec>,
}

/// <p>The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KernelGatewayImageConfig {
    /// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
    #[serde(rename = "FileSystemConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub file_system_config: Option<FileSystemConfig>,
    /// <p>The specification of the Jupyter kernels in the image.</p>
    #[serde(rename = "KernelSpecs")]
    pub kernel_specs: Vec<KernelSpec>,
}

/// <p>The specification of a Jupyter kernel.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct KernelSpec {
    /// <p>The display name of the kernel.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>
    #[serde(rename = "Name")]
    pub name: String,
}

/// <p>Provides a breakdown of the number of objects labeled.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LabelCounters {
    /// <p>The total number of objects that could not be labeled due to an error.</p>
    #[serde(rename = "FailedNonRetryableError")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failed_non_retryable_error: Option<i64>,
    /// <p>The total number of objects labeled by a human worker.</p>
    #[serde(rename = "HumanLabeled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_labeled: Option<i64>,
    /// <p>The total number of objects labeled by automated data labeling.</p>
    #[serde(rename = "MachineLabeled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub machine_labeled: Option<i64>,
    /// <p>The total number of objects labeled.</p>
    #[serde(rename = "TotalLabeled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub total_labeled: Option<i64>,
    /// <p>The total number of objects not yet labeled.</p>
    #[serde(rename = "Unlabeled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub unlabeled: Option<i64>,
}

/// <p>Provides counts for human-labeled tasks in the labeling job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LabelCountersForWorkteam {
    /// <p>The total number of data objects labeled by a human worker.</p>
    #[serde(rename = "HumanLabeled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_labeled: Option<i64>,
    /// <p>The total number of data objects that need to be labeled by a human worker.</p>
    #[serde(rename = "PendingHuman")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pending_human: Option<i64>,
    /// <p>The total number of tasks in the labeling job.</p>
    #[serde(rename = "Total")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub total: Option<i64>,
}

/// <p>Provides configuration information for auto-labeling of your data objects. A <code>LabelingJobAlgorithmsConfig</code> object must be supplied in order to use auto-labeling.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobAlgorithmsConfig {
    /// <p>At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of the model here. </p>
    #[serde(rename = "InitialActiveLearningModelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub initial_active_learning_model_arn: Option<String>,
    /// <p><p>Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the following ARNs:</p> <ul> <li> <p> <i>Image classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code> </p> </li> <li> <p> <i>Text classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code> </p> </li> <li> <p> <i>Object detection</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code> </p> </li> <li> <p> <i>Semantic Segmentation</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code> </p> </li> </ul></p>
    #[serde(rename = "LabelingJobAlgorithmSpecificationArn")]
    pub labeling_job_algorithm_specification_arn: String,
    /// <p>Provides configuration information for a labeling job.</p>
    #[serde(rename = "LabelingJobResourceConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_resource_config: Option<LabelingJobResourceConfig>,
}

/// <p>Attributes of the data specified by the customer. Use these to describe the data to be labeled.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobDataAttributes {
    /// <p>Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this information.</p>
    #[serde(rename = "ContentClassifiers")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content_classifiers: Option<Vec<String>>,
}

/// <p>Provides information about the location of input data.</p> <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.</p> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job.</p> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobDataSource {
    /// <p>The Amazon S3 location of the input data objects.</p>
    #[serde(rename = "S3DataSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_data_source: Option<LabelingJobS3DataSource>,
    /// <p>An Amazon SNS data source used for streaming labeling jobs. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data">Send Data to a Streaming Labeling Job</a>. </p>
    #[serde(rename = "SnsDataSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sns_data_source: Option<LabelingJobSnsDataSource>,
}

/// <p>Provides summary information for a work team.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LabelingJobForWorkteamSummary {
    /// <p>The date and time that the labeling job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>A unique identifier for a labeling job. You can use this to refer to a specific labeling job.</p>
    #[serde(rename = "JobReferenceCode")]
    pub job_reference_code: String,
    /// <p>Provides information about the progress of a labeling job.</p>
    #[serde(rename = "LabelCounters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub label_counters: Option<LabelCountersForWorkteam>,
    /// <p>The name of the labeling job that the work team is assigned to.</p>
    #[serde(rename = "LabelingJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_name: Option<String>,
    /// <p>The configured number of workers per data object.</p>
    #[serde(rename = "NumberOfHumanWorkersPerDataObject")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_of_human_workers_per_data_object: Option<i64>,
    /// <p>The AWS account ID of the account used to start the labeling job.</p>
    #[serde(rename = "WorkRequesterAccountId")]
    pub work_requester_account_id: String,
}

/// <p>Input configuration information for a labeling job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobInputConfig {
    /// <p>Attributes of the data specified by the customer.</p>
    #[serde(rename = "DataAttributes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_attributes: Option<LabelingJobDataAttributes>,
    /// <p>The location of the input data.</p>
    #[serde(rename = "DataSource")]
    pub data_source: LabelingJobDataSource,
}

/// <p>Specifies the location of the output produced by the labeling job. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LabelingJobOutput {
    /// <p>The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated data labeling. </p>
    #[serde(rename = "FinalActiveLearningModelArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub final_active_learning_model_arn: Option<String>,
    /// <p>The Amazon S3 bucket location of the manifest file for labeled data. </p>
    #[serde(rename = "OutputDatasetS3Uri")]
    pub output_dataset_s3_uri: String,
}

/// <p>Output configuration information for a labeling job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobOutputConfig {
    /// <p>The AWS Key Management Service ID of the key used to encrypt the output data, if any.</p> <p>If you provide your own KMS key ID, you must add the required permissions to your KMS key described in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions">Encrypt Output Data and Storage Volume with AWS KMS</a>.</p> <p>If you don't provide a KMS key ID, Amazon SageMaker uses the default AWS KMS key for Amazon S3 for your role's account to encrypt your output data.</p> <p>If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The Amazon S3 location to write output data.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
    /// <p>An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a <code>SnsTopicArn</code> if you want to do real time chaining to another streaming job and receive an Amazon SNS notifications each time a data object is submitted by a worker.</p> <p>If you provide an <code>SnsTopicArn</code> in <code>OutputConfig</code>, when workers complete labeling tasks, Ground Truth will send labeling task output data to the SNS output topic you specify here. </p> <p>To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data">Receive Output Data from a Streaming Labeling Job</a>. </p>
    #[serde(rename = "SnsTopicArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sns_topic_arn: Option<String>,
}

/// <p>Configure encryption on the storage volume attached to the ML compute instance used to run automated data labeling model training and inference. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobResourceConfig {
    /// <p><p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training and inference jobs used for automated data labeling. </p> <p>You can only specify a <code>VolumeKmsKeyId</code> when you create a labeling job with automated data labeling enabled using the API operation <code>CreateLabelingJob</code>. You cannot specify an AWS KMS customer managed CMK to encrypt the storage volume used for automated data labeling model training and inference when you create a labeling job using the console. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security.html">Output Data and Storage Volume Encryption</a>.</p> <p>The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>KMS Key ID</p> <p> <code>&quot;1234abcd-12ab-34cd-56ef-1234567890ab&quot;</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>&quot;arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab&quot;</code> </p> </li> </ul></p>
    #[serde(rename = "VolumeKmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_kms_key_id: Option<String>,
}

/// <p>The Amazon S3 location of the input data objects.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobS3DataSource {
    /// <p>The Amazon S3 location of the manifest file that describes the input data objects. </p> <p>The input manifest file referenced in <code>ManifestS3Uri</code> must contain one of the following keys: <code>source-ref</code> or <code>source</code>. The value of the keys are interpreted as follows:</p> <ul> <li> <p> <code>source-ref</code>: The source of the object is the Amazon S3 object specified in the value. Use this value when the object is a binary object, such as an image.</p> </li> <li> <p> <code>source</code>: The source of the object is the value. Use this value when the object is a text value.</p> </li> </ul> <p>If you are a new user of Ground Truth, it is recommended you review <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html">Use an Input Manifest File </a> in the Amazon SageMaker Developer Guide to learn how to create an input manifest file.</p>
    #[serde(rename = "ManifestS3Uri")]
    pub manifest_s3_uri: String,
}

/// <p>An Amazon SNS data source used for streaming labeling jobs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobSnsDataSource {
    /// <p>The Amazon SNS input topic Amazon Resource Name (ARN). Specify the ARN of the input topic you will use to send new data objects to a streaming labeling job.</p>
    #[serde(rename = "SnsTopicArn")]
    pub sns_topic_arn: String,
}

/// <p><p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p> <note> <p>Labeling jobs fail after 30 days with an appropriate client error message.</p> </note></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct LabelingJobStoppingConditions {
    /// <p>The maximum number of objects that can be labeled by human workers.</p>
    #[serde(rename = "MaxHumanLabeledObjectCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_human_labeled_object_count: Option<i64>,
    /// <p>The maximum number of input data objects that should be labeled.</p>
    #[serde(rename = "MaxPercentageOfInputDatasetLabeled")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_percentage_of_input_dataset_labeled: Option<i64>,
}

/// <p>Provides summary information about a labeling job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct LabelingJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers into a label for a data object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation Consolidation</a>.</p>
    #[serde(rename = "AnnotationConsolidationLambdaArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub annotation_consolidation_lambda_arn: Option<String>,
    /// <p>The date and time that the job was created (timestamp).</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of the error.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>Input configuration for the labeling job.</p>
    #[serde(rename = "InputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_config: Option<LabelingJobInputConfig>,
    /// <p>Counts showing the progress of the labeling job.</p>
    #[serde(rename = "LabelCounters")]
    pub label_counters: LabelCounters,
    /// <p>The Amazon Resource Name (ARN) assigned to the labeling job when it was created.</p>
    #[serde(rename = "LabelingJobArn")]
    pub labeling_job_arn: String,
    /// <p>The name of the labeling job.</p>
    #[serde(rename = "LabelingJobName")]
    pub labeling_job_name: String,
    /// <p>The location of the output produced by the labeling job.</p>
    #[serde(rename = "LabelingJobOutput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_output: Option<LabelingJobOutput>,
    /// <p>The current status of the labeling job. </p>
    #[serde(rename = "LabelingJobStatus")]
    pub labeling_job_status: String,
    /// <p>The date and time that the job was last modified (timestamp).</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a worker.</p>
    #[serde(rename = "PreHumanTaskLambdaArn")]
    pub pre_human_task_lambda_arn: String,
    /// <p>The Amazon Resource Name (ARN) of the work team assigned to the job.</p>
    #[serde(rename = "WorkteamArn")]
    pub workteam_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListActionsRequest {
    /// <p>A filter that returns only actions of the specified type.</p>
    #[serde(rename = "ActionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_type: Option<String>,
    /// <p>A filter that returns only actions created on or after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only actions created on or before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>The maximum number of actions to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListActions</code> didn't return the full set of actions, the call returns a token for getting the next set of actions.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only actions with the specified source URI.</p>
    #[serde(rename = "SourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_uri: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListActionsResponse {
    /// <p>A list of actions and their properties.</p>
    #[serde(rename = "ActionSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_summaries: Option<Vec<ActionSummary>>,
    /// <p>A token for getting the next set of actions, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAlgorithmsInput {
    /// <p>A filter that returns only algorithms created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only algorithms created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of algorithms to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the algorithm name. This filter returns only algorithms whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the response to a previous <code>ListAlgorithms</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of algorithms, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAlgorithmsOutput {
    /// <p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>
    #[serde(rename = "AlgorithmSummaryList")]
    pub algorithm_summary_list: Vec<AlgorithmSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAppImageConfigsRequest {
    /// <p>A filter that returns only AppImageConfigs created on or after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only AppImageConfigs created on or before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of AppImageConfigs to return in the response. The default value is 10. </p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that returns only AppImageConfigs modified on or after the specified time.</p>
    #[serde(rename = "ModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub modified_time_after: Option<f64>,
    /// <p>A filter that returns only AppImageConfigs modified on or before the specified time.</p>
    #[serde(rename = "ModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub modified_time_before: Option<f64>,
    /// <p>A filter that returns only AppImageConfigs whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the call returns a token for getting the next set of AppImageConfigs.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAppImageConfigsResponse {
    /// <p>A list of AppImageConfigs and their properties.</p>
    #[serde(rename = "AppImageConfigs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_configs: Option<Vec<AppImageConfigDetails>>,
    /// <p>A token for getting the next set of AppImageConfigs, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAppsRequest {
    /// <p>A parameter to search for the domain ID.</p>
    #[serde(rename = "DomainIdEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id_equals: Option<String>,
    /// <p>Returns a list up to a specified limit.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The parameter by which to sort the results. The default is CreationTime.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for the results. The default is Ascending.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A parameter to search by user profile name.</p>
    #[serde(rename = "UserProfileNameEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAppsResponse {
    /// <p>The list of apps.</p>
    #[serde(rename = "Apps")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub apps: Option<Vec<AppDetails>>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListArtifactsRequest {
    /// <p>A filter that returns only artifacts of the specified type.</p>
    #[serde(rename = "ArtifactType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_type: Option<String>,
    /// <p>A filter that returns only artifacts created on or after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only artifacts created on or before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>The maximum number of artifacts to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListArtifacts</code> didn't return the full set of artifacts, the call returns a token for getting the next set of artifacts.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only artifacts with the specified source URI.</p>
    #[serde(rename = "SourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_uri: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListArtifactsResponse {
    /// <p>A list of artifacts and their properties.</p>
    #[serde(rename = "ArtifactSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_summaries: Option<Vec<ArtifactSummary>>,
    /// <p>A token for getting the next set of artifacts, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAssociationsRequest {
    /// <p>A filter that returns only associations of the specified type.</p>
    #[serde(rename = "AssociationType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub association_type: Option<String>,
    /// <p>A filter that returns only associations created on or after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only associations created on or before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>A filter that returns only associations with the specified destination Amazon Resource Name (ARN).</p>
    #[serde(rename = "DestinationArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_arn: Option<String>,
    /// <p>A filter that returns only associations with the specified destination type.</p>
    #[serde(rename = "DestinationType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub destination_type: Option<String>,
    /// <p>The maximum number of associations to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListAssociations</code> didn't return the full set of associations, the call returns a token for getting the next set of associations.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only associations with the specified source ARN.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
    /// <p>A filter that returns only associations with the specified source type.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAssociationsResponse {
    /// <p>A list of associations and their properties.</p>
    #[serde(rename = "AssociationSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub association_summaries: Option<Vec<AssociationSummary>>,
    /// <p>A token for getting the next set of associations, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListAutoMLJobsRequest {
    /// <p>Request a list of jobs, using a filter for time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>Request a list of jobs, using a filter for time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Request a list of jobs, using a filter for time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>Request a list of jobs, using a filter for time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>Request a list of jobs up to a specified limit.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Request a list of jobs, using a search filter for name.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The parameter by which to sort the results. The default is <code>Name</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for the results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>Request a list of jobs, using a filter for status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListAutoMLJobsResponse {
    /// <p>Returns a summary list of jobs.</p>
    #[serde(rename = "AutoMLJobSummaries")]
    pub auto_ml_job_summaries: Vec<AutoMLJobSummary>,
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCandidatesForAutoMLJobRequest {
    /// <p>List the candidates created for the job by providing the job's name.</p>
    #[serde(rename = "AutoMLJobName")]
    pub auto_ml_job_name: String,
    /// <p>List the candidates for the job and filter by candidate name.</p>
    #[serde(rename = "CandidateNameEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub candidate_name_equals: Option<String>,
    /// <p>List the job's candidates up to a specified limit.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The parameter by which to sort the results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>List the candidates for the job and filter by status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCandidatesForAutoMLJobResponse {
    /// <p>Summaries about the <code>AutoMLCandidates</code>.</p>
    #[serde(rename = "Candidates")]
    pub candidates: Vec<AutoMLCandidate>,
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCodeRepositoriesInput {
    /// <p>A filter that returns only Git repositories that were created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only Git repositories that were created before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only Git repositories that were last modified after the specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only Git repositories that were last modified before the specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of Git repositories to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the Git repositories name. This filter returns only repositories whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>Name</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCodeRepositoriesOutput {
    /// <p><p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p> <ul> <li> <p>Name</p> </li> <li> <p>Amazon Resource Name (ARN)</p> </li> <li> <p>Creation time</p> </li> <li> <p>Last modified time</p> </li> <li> <p>Configuration information, including the URL location of the repository and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.</p> </li> </ul></p>
    #[serde(rename = "CodeRepositorySummaryList")]
    pub code_repository_summary_list: Vec<CodeRepositorySummary>,
    /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListCompilationJobsRequest {
    /// <p>A filter that returns the model compilation jobs that were created after a specified time. </p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns the model compilation jobs that were created before a specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns the model compilation jobs that were modified after a specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns the model compilation jobs that were modified before a specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of model compilation jobs to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that returns the model compilation jobs whose name contains a specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field by which to sort results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that retrieves model compilation jobs with a specific <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListCompilationJobsResponse {
    /// <p>An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job. </p>
    #[serde(rename = "CompilationJobSummaries")]
    pub compilation_job_summaries: Vec<CompilationJobSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListContextsRequest {
    /// <p>A filter that returns only contexts of the specified type.</p>
    #[serde(rename = "ContextType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_type: Option<String>,
    /// <p>A filter that returns only contexts created on or after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only contexts created on or before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>The maximum number of contexts to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListContexts</code> didn't return the full set of contexts, the call returns a token for getting the next set of contexts.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only contexts with the specified source URI.</p>
    #[serde(rename = "SourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_uri: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListContextsResponse {
    /// <p>A list of contexts and their properties.</p>
    #[serde(rename = "ContextSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_summaries: Option<Vec<ContextSummary>>,
    /// <p>A token for getting the next set of contexts, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDataQualityJobDefinitionsRequest {
    /// <p>A filter that returns only data quality monitoring job definitions created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only data quality monitoring job definitions created before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that lists the data quality job definitions associated with the specified endpoint.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>The maximum number of data quality monitoring job definitions to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the data quality monitoring job definition name. This filter returns only data quality monitoring job definitions whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.&gt;</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDataQualityJobDefinitionsResponse {
    /// <p>A list of data quality monitoring job definitions.</p>
    #[serde(rename = "JobDefinitionSummaries")]
    pub job_definition_summaries: Vec<MonitoringJobDefinitionSummary>,
    /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDeviceFleetsRequest {
    /// <p>Filter fleets where packaging job was created after specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>Filter fleets where the edge packaging job was created before specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Select fleets where the job was updated after X</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>Select fleets where the job was updated before X</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of results to select.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Filter for fleets containing this name in their fleet device name.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The column to sort by.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>What direction to sort in.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDeviceFleetsResponse {
    /// <p>Summary of the device fleet.</p>
    #[serde(rename = "DeviceFleetSummaries")]
    pub device_fleet_summaries: Vec<DeviceFleetSummary>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDevicesRequest {
    /// <p>Filter for fleets containing this name in their device fleet name.</p>
    #[serde(rename = "DeviceFleetName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub device_fleet_name: Option<String>,
    /// <p>Select fleets where the job was updated after X</p>
    #[serde(rename = "LatestHeartbeatAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub latest_heartbeat_after: Option<f64>,
    /// <p>Maximum number of results to select.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that searches devices that contains this name in any of their models.</p>
    #[serde(rename = "ModelName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_name: Option<String>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDevicesResponse {
    /// <p>Summary of devices.</p>
    #[serde(rename = "DeviceSummaries")]
    pub device_summaries: Vec<DeviceSummary>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListDomainsRequest {
    /// <p>Returns a list up to a specified limit.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListDomainsResponse {
    /// <p>The list of domains.</p>
    #[serde(rename = "Domains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domains: Option<Vec<DomainDetails>>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListEdgePackagingJobsRequest {
    /// <p>Select jobs where the job was created after specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>Select jobs where the job was created before specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Select jobs where the job was updated after specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>Select jobs where the job was updated before specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>Maximum number of results to select.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Filter for jobs where the model name contains this string.</p>
    #[serde(rename = "ModelNameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_name_contains: Option<String>,
    /// <p>Filter for jobs containing this name in their packaging job name.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Use to specify what column to sort by.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>What direction to sort by.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>The job status to filter for.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListEdgePackagingJobsResponse {
    /// <p>Summaries of edge packaging jobs.</p>
    #[serde(rename = "EdgePackagingJobSummaries")]
    pub edge_packaging_job_summaries: Vec<EdgePackagingJobSummary>,
    /// <p>Token to use when calling the next page of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListEndpointConfigsInput {
    /// <p>A filter that returns only endpoint configurations with a creation time greater than or equal to the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only endpoint configurations created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of training jobs to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the endpoint configuration name. This filter returns only endpoint configurations whose name contains the specified string. </p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListEndpointConfig</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoint configurations, use the token in the next request. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListEndpointConfigsOutput {
    /// <p>An array of endpoint configurations.</p>
    #[serde(rename = "EndpointConfigs")]
    pub endpoint_configs: Vec<EndpointConfigSummary>,
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListEndpointsInput {
    /// <p>A filter that returns only endpoints with a creation time greater than or equal to the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only endpoints that were created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p> A filter that returns only endpoints that were modified after the specified timestamp. </p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p> A filter that returns only endpoints that were modified before the specified timestamp. </p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of endpoints to return in the response. This value defaults to 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in endpoint names. This filter returns only endpoints whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of a <code>ListEndpoints</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoints, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Sorts the list of results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p> A filter that returns only endpoints with the specified status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListEndpointsOutput {
    /// <p> An array or endpoint objects. </p>
    #[serde(rename = "Endpoints")]
    pub endpoints: Vec<EndpointSummary>,
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListExperimentsRequest {
    /// <p>A filter that returns only experiments created after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only experiments created before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>The maximum number of experiments to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListExperiments</code> didn't return the full set of experiments, the call returns a token for getting the next set of experiments.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListExperimentsResponse {
    /// <p>A list of the summaries of your experiments.</p>
    #[serde(rename = "ExperimentSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_summaries: Option<Vec<ExperimentSummary>>,
    /// <p>A token for getting the next set of experiments, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListFeatureGroupsRequest {
    /// <p>Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status. </p>
    #[serde(rename = "FeatureGroupStatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group_status_equals: Option<String>,
    /// <p>The maximum number of results returned by <code>ListFeatureGroups</code>.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string that partially matches one or more <code>FeatureGroup</code>s names. Filters <code>FeatureGroup</code>s by name. </p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status. </p>
    #[serde(rename = "OfflineStoreStatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub offline_store_status_equals: Option<String>,
    /// <p>The value on which the feature group list is sorted.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The order in which feature groups are listed.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListFeatureGroupsResponse {
    /// <p>A summary of feature groups.</p>
    #[serde(rename = "FeatureGroupSummaries")]
    pub feature_group_summaries: Vec<FeatureGroupSummary>,
    /// <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
    #[serde(rename = "NextToken")]
    pub next_token: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListFlowDefinitionsRequest {
    /// <p>A filter that returns only flow definitions with a creation time greater than or equal to the specified timestamp.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only flow definitions that were created before the specified timestamp.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token to resume pagination.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListFlowDefinitionsResponse {
    /// <p>An array of objects describing the flow definitions.</p>
    #[serde(rename = "FlowDefinitionSummaries")]
    pub flow_definition_summaries: Vec<FlowDefinitionSummary>,
    /// <p>A token to resume pagination.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListHumanTaskUisRequest {
    /// <p>A filter that returns only human task user interfaces with a creation time greater than or equal to the specified timestamp.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only human task user interfaces that were created before the specified timestamp.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A token to resume pagination.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListHumanTaskUisResponse {
    /// <p>An array of objects describing the human task user interfaces.</p>
    #[serde(rename = "HumanTaskUiSummaries")]
    pub human_task_ui_summaries: Vec<HumanTaskUiSummary>,
    /// <p>A token to resume pagination.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListHyperParameterTuningJobsRequest {
    /// <p>A filter that returns only tuning jobs that were created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only tuning jobs that were created before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only tuning jobs that were modified after the specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only tuning jobs that were modified before the specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of tuning jobs to return. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the tuning job name. This filter returns only tuning jobs whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>Name</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only tuning jobs with the specified status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListHyperParameterTuningJobsResponse {
    /// <p>A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>
    #[serde(rename = "HyperParameterTuningJobSummaries")]
    pub hyper_parameter_tuning_job_summaries: Vec<HyperParameterTuningJobSummary>,
    /// <p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListImageVersionsRequest {
    /// <p>A filter that returns only versions created on or after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only versions created on or before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The name of the image to list the versions of.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>A filter that returns only versions modified on or after the specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only versions modified on or before the specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of versions to return in the response. The default value is 10. </p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListImageVersions</code> didn't return the full set of versions, the call returns a token for getting the next set of versions.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CREATION_TIME</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>DESCENDING</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListImageVersionsResponse {
    /// <p>A list of versions and their properties.</p>
    #[serde(rename = "ImageVersions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_versions: Option<Vec<ImageVersion>>,
    /// <p>A token for getting the next set of versions, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListImagesRequest {
    /// <p>A filter that returns only images created on or after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only images created on or before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only images modified on or after the specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only images modified on or before the specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of images to return in the response. The default value is 10. </p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that returns only images whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the previous call to <code>ListImages</code> didn't return the full set of images, the call returns a token for getting the next set of images.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CREATION_TIME</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>DESCENDING</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListImagesResponse {
    /// <p>A list of images and their properties.</p>
    #[serde(rename = "Images")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub images: Option<Vec<Image>>,
    /// <p>A token for getting the next set of images, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListLabelingJobsForWorkteamRequest {
    /// <p>A filter that returns only labeling jobs created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only labeling jobs created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter the limits jobs to only the ones whose job reference code contains the specified string.</p>
    #[serde(rename = "JobReferenceCodeContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub job_reference_code_contains: Option<String>,
    /// <p>The maximum number of labeling jobs to return in each page of the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.</p>
    #[serde(rename = "WorkteamArn")]
    pub workteam_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListLabelingJobsForWorkteamResponse {
    /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
    #[serde(rename = "LabelingJobSummaryList")]
    pub labeling_job_summary_list: Vec<LabelingJobForWorkteamSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListLabelingJobsRequest {
    /// <p>A filter that returns only labeling jobs created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only labeling jobs created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only labeling jobs modified after the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only labeling jobs modified before the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of labeling jobs to return in each page of the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the labeling job name. This filter returns only labeling jobs whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListLabelingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that retrieves only labeling jobs with a specific status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListLabelingJobsResponse {
    /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
    #[serde(rename = "LabelingJobSummaryList")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_summary_list: Option<Vec<LabelingJobSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListModelBiasJobDefinitionsRequest {
    /// <p>A filter that returns only model bias jobs created after a specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only model bias jobs created before a specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Name of the endpoint to monitor for model bias.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>The maximum number of model bias jobs to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Filter for model bias jobs whose name contains a specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListModelBiasJobDefinitionsResponse {
    /// <p>A JSON array in which each element is a summary for a model bias jobs.</p>
    #[serde(rename = "JobDefinitionSummaries")]
    pub job_definition_summaries: Vec<MonitoringJobDefinitionSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListModelExplainabilityJobDefinitionsRequest {
    /// <p>A filter that returns only model explainability jobs created after a specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only model explainability jobs created before a specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Name of the endpoint to monitor for model explainability.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>The maximum number of jobs to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Filter for model explainability jobs whose name contains a specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListModelExplainabilityJobDefinitionsResponse {
    /// <p>A JSON array in which each element is a summary for a explainability bias jobs.</p>
    #[serde(rename = "JobDefinitionSummaries")]
    pub job_definition_summaries: Vec<MonitoringJobDefinitionSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListModelPackageGroupsInput {
    /// <p>A filter that returns only model groups created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only model groups created before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of results to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the model group name. This filter returns only model groups whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListModelPackageGroups</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model groups, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListModelPackageGroupsOutput {
    /// <p>A list of summaries of the model groups in your AWS account.</p>
    #[serde(rename = "ModelPackageGroupSummaryList")]
    pub model_package_group_summary_list: Vec<ModelPackageGroupSummary>,
    /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListModelPackagesInput {
    /// <p>A filter that returns only model packages created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only model packages created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of model packages to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that returns only the model packages with the specified approval status.</p>
    #[serde(rename = "ModelApprovalStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_approval_status: Option<String>,
    /// <p>A filter that returns only model versions that belong to the specified model group.</p>
    #[serde(rename = "ModelPackageGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_name: Option<String>,
    /// <p><p>A filter that returns onlyl the model packages of the specified type. This can be one of the following values.</p> <ul> <li> <p> <code>VERSIONED</code> - List only versioned models.</p> </li> <li> <p> <code>UNVERSIONED</code> - List only unversioined models.</p> </li> <li> <p> <code>BOTH</code> - List both versioned and unversioned models.</p> </li> </ul></p>
    #[serde(rename = "ModelPackageType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_type: Option<String>,
    /// <p>A string in the model package name. This filter returns only model packages whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the response to a previous <code>ListModelPackages</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model packages, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListModelPackagesOutput {
    /// <p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>
    #[serde(rename = "ModelPackageSummaryList")]
    pub model_package_summary_list: Vec<ModelPackageSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListModelQualityJobDefinitionsRequest {
    /// <p>A filter that returns only model quality monitoring job definitions created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only model quality monitoring job definitions created before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only model quality monitoring job definitions that are associated with the specified endpoint.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the transform job name. This filter returns only model quality monitoring job definitions whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job definitions, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListModelQualityJobDefinitionsResponse {
    /// <p>A list of summaries of model quality monitoring job definitions.</p>
    #[serde(rename = "JobDefinitionSummaries")]
    pub job_definition_summaries: Vec<MonitoringJobDefinitionSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListModelsInput {
    /// <p>A filter that returns only models with a creation time greater than or equal to the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only models created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of models to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the training job name. This filter returns only models in the training job whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the response to a previous <code>ListModels</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of models, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Sorts the list of results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListModelsOutput {
    /// <p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>
    #[serde(rename = "Models")]
    pub models: Vec<ModelSummary>,
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMonitoringExecutionsRequest {
    /// <p>A filter that returns only jobs created after a specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only jobs created before a specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Name of a specific endpoint to fetch jobs for.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>A filter that returns only jobs modified before a specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only jobs modified after a specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of jobs to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Gets a list of the monitoring job runs of the specified monitoring job definitions.</p>
    #[serde(rename = "MonitoringJobDefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_job_definition_name: Option<String>,
    /// <p>Name of a specific schedule to fetch jobs for.</p>
    #[serde(rename = "MonitoringScheduleName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_name: Option<String>,
    /// <p>A filter that returns only the monitoring job runs of the specified monitoring type.</p>
    #[serde(rename = "MonitoringTypeEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type_equals: Option<String>,
    /// <p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Filter for jobs scheduled after a specified time.</p>
    #[serde(rename = "ScheduledTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_time_after: Option<f64>,
    /// <p>Filter for jobs scheduled before a specified time.</p>
    #[serde(rename = "ScheduledTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scheduled_time_before: Option<f64>,
    /// <p>Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that retrieves only jobs with a specific status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListMonitoringExecutionsResponse {
    /// <p>A JSON array in which each element is a summary for a monitoring execution.</p>
    #[serde(rename = "MonitoringExecutionSummaries")]
    pub monitoring_execution_summaries: Vec<MonitoringExecutionSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListMonitoringSchedulesRequest {
    /// <p>A filter that returns only monitoring schedules created after a specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only monitoring schedules created before a specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>Name of a specific endpoint to fetch schedules for.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>A filter that returns only monitoring schedules modified after a specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only monitoring schedules modified before a specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of jobs to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>Gets a list of the monitoring schedules for the specified monitoring job definition.</p>
    #[serde(rename = "MonitoringJobDefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_job_definition_name: Option<String>,
    /// <p>A filter that returns only the monitoring schedules for the specified monitoring type.</p>
    #[serde(rename = "MonitoringTypeEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type_equals: Option<String>,
    /// <p>Filter for monitoring schedules whose name contains a specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only monitoring schedules modified before a specified time.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListMonitoringSchedulesResponse {
    /// <p>A JSON array in which each element is a summary for a monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleSummaries")]
    pub monitoring_schedule_summaries: Vec<MonitoringScheduleSummary>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListNotebookInstanceLifecycleConfigsInput {
    /// <p>A filter that returns only lifecycle configurations that were created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only lifecycle configurations that were created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only lifecycle configurations that were modified after the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only lifecycle configurations that were modified before the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of lifecycle configurations to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Sorts the list of results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListNotebookInstanceLifecycleConfigsOutput {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_configs: Option<Vec<NotebookInstanceLifecycleConfigSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListNotebookInstancesInput {
    /// <p>A filter that returns only notebook instances with associated with the specified git repository.</p>
    #[serde(rename = "AdditionalCodeRepositoryEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_code_repository_equals: Option<String>,
    /// <p>A filter that returns only notebook instances that were created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only notebook instances that were created before the specified time (timestamp). </p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A string in the name or URL of a Git repository associated with this notebook instance. This filter returns only notebook instances associated with a git repository with a name that contains the specified string.</p>
    #[serde(rename = "DefaultCodeRepositoryContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_code_repository_contains: Option<String>,
    /// <p>A filter that returns only notebook instances that were modified after the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only notebook instances that were modified before the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of notebook instances to return.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the notebook instances' name. This filter returns only notebook instances whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p><p> If the previous call to the <code>ListNotebookInstances</code> is truncated, the response includes a <code>NextToken</code>. You can use this token in your subsequent <code>ListNotebookInstances</code> request to fetch the next set of notebook instances. </p> <note> <p>You might specify a filter or a sort order in your request. When response is truncated, you must use the same values for the filer and sort order in the next request. </p> </note></p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A string in the name of a notebook instances lifecycle configuration associated with this notebook instance. This filter returns only notebook instances associated with a lifecycle configuration with a name that contains the specified string.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigNameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_config_name_contains: Option<String>,
    /// <p>The field to sort results by. The default is <code>Name</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. </p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only notebook instances with the specified status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListNotebookInstancesOutput {
    /// <p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>
    #[serde(rename = "NotebookInstances")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instances: Option<Vec<NotebookInstanceSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPipelineExecutionStepsRequest {
    /// <p>The maximum number of pipeline execution steps to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
    /// <p>The field by which to sort results. The default is <code>CreatedTime</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPipelineExecutionStepsResponse {
    /// <p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>
    #[serde(rename = "PipelineExecutionSteps")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_steps: Option<Vec<PipelineExecutionStep>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPipelineExecutionsRequest {
    /// <p>A filter that returns the pipeline executions that were created after a specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns the pipeline executions that were created before a specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>The maximum number of pipeline executions to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the pipeline.</p>
    #[serde(rename = "PipelineName")]
    pub pipeline_name: String,
    /// <p>The field by which to sort results. The default is <code>CreatedTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPipelineExecutionsResponse {
    /// <p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>
    #[serde(rename = "PipelineExecutionSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_summaries: Option<Vec<PipelineExecutionSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPipelineParametersForExecutionRequest {
    /// <p>The maximum number of parameters to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    pub pipeline_execution_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPipelineParametersForExecutionResponse {
    /// <p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    #[serde(rename = "PipelineParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_parameters: Option<Vec<Parameter>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListPipelinesRequest {
    /// <p>A filter that returns the pipelines that were created after a specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns the pipelines that were created before a specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>The maximum number of pipelines to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The prefix of the pipeline name.</p>
    #[serde(rename = "PipelineNamePrefix")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_name_prefix: Option<String>,
    /// <p>The field by which to sort results. The default is <code>CreatedTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListPipelinesResponse {
    /// <p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>
    #[serde(rename = "PipelineSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_summaries: Option<Vec<PipelineSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListProcessingJobsRequest {
    /// <p>A filter that returns only processing jobs created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only processing jobs created after the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only processing jobs modified after the specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only processing jobs modified before the specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of processing jobs to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the processing job name. This filter returns only processing jobs whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListProcessingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of processing jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that retrieves only processing jobs with a specific status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListProcessingJobsResponse {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>
    #[serde(rename = "ProcessingJobSummaries")]
    pub processing_job_summaries: Vec<ProcessingJobSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListProjectsInput {
    /// <p>A filter that returns the projects that were created after a specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns the projects that were created before a specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>The maximum number of projects to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter that returns the projects whose name contains a specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListProjects</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of projects, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field by which to sort results. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListProjectsOutput {
    /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of summaries of projects.</p>
    #[serde(rename = "ProjectSummaryList")]
    pub project_summary_list: Vec<ProjectSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListSubscribedWorkteamsRequest {
    /// <p>The maximum number of work teams to return in each page of the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the work team name. This filter returns only work teams whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListSubscribedWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListSubscribedWorkteamsResponse {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
    #[serde(rename = "SubscribedWorkteams")]
    pub subscribed_workteams: Vec<SubscribedWorkteam>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTagsInput {
    /// <p>Maximum number of tags to return.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p> If the response to the previous <code>ListTags</code> request is truncated, Amazon SageMaker returns this token. To retrieve the next set of tags, use it in the subsequent request. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
    #[serde(rename = "ResourceArn")]
    pub resource_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTagsOutput {
    /// <p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTrainingJobsForHyperParameterTuningJobRequest {
    /// <p>The name of the tuning job whose training jobs you want to list.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    pub hyper_parameter_tuning_job_name: String,
    /// <p>The maximum number of training jobs to return. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>Name</code>.</p> <p>If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return an objective metric are not listed.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only training jobs with the specified status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTrainingJobsForHyperParameterTuningJobResponse {
    /// <p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>
    #[serde(rename = "TrainingJobSummaries")]
    pub training_job_summaries: Vec<HyperParameterTrainingJobSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTrainingJobsRequest {
    /// <p>A filter that returns only training jobs created after the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only training jobs created before the specified time (timestamp).</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only training jobs modified after the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only training jobs modified before the specified time (timestamp).</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of training jobs to return in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the training job name. This filter returns only training jobs whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListTrainingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request. </p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that retrieves only training jobs with a specific status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTrainingJobsResponse {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>
    #[serde(rename = "TrainingJobSummaries")]
    pub training_job_summaries: Vec<TrainingJobSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTransformJobsRequest {
    /// <p>A filter that returns only transform jobs created after the specified time.</p>
    #[serde(rename = "CreationTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_after: Option<f64>,
    /// <p>A filter that returns only transform jobs created before the specified time.</p>
    #[serde(rename = "CreationTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time_before: Option<f64>,
    /// <p>A filter that returns only transform jobs modified after the specified time.</p>
    #[serde(rename = "LastModifiedTimeAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_after: Option<f64>,
    /// <p>A filter that returns only transform jobs modified before the specified time.</p>
    #[serde(rename = "LastModifiedTimeBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time_before: Option<f64>,
    /// <p>The maximum number of transform jobs to return in the response. The default value is <code>10</code>.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the transform job name. This filter returns only transform jobs whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListTransformJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that retrieves only transform jobs with a specific status.</p>
    #[serde(rename = "StatusEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_equals: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTransformJobsResponse {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>TransformJobSummary</code> objects.</p>
    #[serde(rename = "TransformJobSummaries")]
    pub transform_job_summaries: Vec<TransformJobSummary>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTrialComponentsRequest {
    /// <p>A filter that returns only components created after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only components created before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>A filter that returns only components that are part of the specified experiment. If you specify <code>ExperimentName</code>, you can't filter by <code>SourceArn</code> or <code>TrialName</code>.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>The maximum number of components to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListTrialComponents</code> didn't return the full set of components, the call returns a token for getting the next set of components.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you specify <code>SourceArn</code>, you can't filter by <code>ExperimentName</code> or <code>TrialName</code>.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
    /// <p>A filter that returns only components that are part of the specified trial. If you specify <code>TrialName</code>, you can't filter by <code>ExperimentName</code> or <code>SourceArn</code>.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTrialComponentsResponse {
    /// <p>A token for getting the next set of components, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of the summaries of your trial components.</p>
    #[serde(rename = "TrialComponentSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_summaries: Option<Vec<TrialComponentSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListTrialsRequest {
    /// <p>A filter that returns only trials created after the specified time.</p>
    #[serde(rename = "CreatedAfter")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_after: Option<f64>,
    /// <p>A filter that returns only trials created before the specified time.</p>
    #[serde(rename = "CreatedBefore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_before: Option<f64>,
    /// <p>A filter that returns only trials that are part of the specified experiment.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>The maximum number of trials to return in the response. The default value is 10.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous call to <code>ListTrials</code> didn't return the full set of trials, the call returns a token for getting the next set of trials.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order. The default value is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A filter that returns only trials that are associated with the specified trial component.</p>
    #[serde(rename = "TrialComponentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListTrialsResponse {
    /// <p>A token for getting the next set of trials, if there are any.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of the summaries of your trials.</p>
    #[serde(rename = "TrialSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_summaries: Option<Vec<TrialSummary>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListUserProfilesRequest {
    /// <p>A parameter by which to filter the results.</p>
    #[serde(rename = "DomainIdEquals")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id_equals: Option<String>,
    /// <p>Returns a list up to a specified limit.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The parameter by which to sort the results. The default is CreationTime.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for the results. The default is Ascending.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
    /// <p>A parameter by which to filter the results.</p>
    #[serde(rename = "UserProfileNameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name_contains: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListUserProfilesResponse {
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The list of user profiles.</p>
    #[serde(rename = "UserProfiles")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profiles: Option<Vec<UserProfileDetails>>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListWorkforcesRequest {
    /// <p>The maximum number of workforces returned in the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A filter you can use to search for workforces using part of the workforce name.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>A token to resume pagination.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>Sort workforces using the workforce name or creation date.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>Sort workforces in ascending or descending order.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListWorkforcesResponse {
    /// <p>A token to resume pagination.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list containing information about your workforce.</p>
    #[serde(rename = "Workforces")]
    pub workforces: Vec<Workforce>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ListWorkteamsRequest {
    /// <p>The maximum number of work teams to return in each page of the response.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>A string in the work team's name. This filter returns only work teams whose name contains the specified string.</p>
    #[serde(rename = "NameContains")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub name_contains: Option<String>,
    /// <p>If the result of the previous <code>ListWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ListWorkteamsResponse {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
    #[serde(rename = "Workteams")]
    pub workteams: Vec<Workteam>,
}

/// <p>Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work team.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MemberDefinition {
    /// <p>The Amazon Cognito user group that is part of the work team.</p>
    #[serde(rename = "CognitoMemberDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cognito_member_definition: Option<CognitoMemberDefinition>,
    /// <p>A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>
    #[serde(rename = "OidcMemberDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub oidc_member_definition: Option<OidcMemberDefinition>,
}

/// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MetadataProperties {
    /// <p>The commit ID.</p>
    #[serde(rename = "CommitId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub commit_id: Option<String>,
    /// <p>The entity this entity was generated by.</p>
    #[serde(rename = "GeneratedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub generated_by: Option<String>,
    /// <p>The project ID.</p>
    #[serde(rename = "ProjectId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    /// <p>The repository.</p>
    #[serde(rename = "Repository")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub repository: Option<String>,
}

/// <p>The name, value, and date and time of a metric that was emitted to Amazon CloudWatch.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MetricData {
    /// <p>The name of the metric.</p>
    #[serde(rename = "MetricName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    /// <p>The date and time that the algorithm emitted the metric.</p>
    #[serde(rename = "Timestamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub timestamp: Option<f64>,
    /// <p>The value of the metric.</p>
    #[serde(rename = "Value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<f32>,
}

/// <p>Specifies a metric that the training algorithm writes to <code>stderr</code> or <code>stdout</code>. Amazon SageMakerhyperparameter tuning captures all defined metrics. You specify one metric that a hyperparameter tuning job uses as its objective metric to choose the best training job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MetricDefinition {
    /// <p>The name of the metric.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>A regular expression that searches the output of a training job and gets the value of the metric. For more information about using regular expressions to define metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html">Defining Objective Metrics</a>.</p>
    #[serde(rename = "Regex")]
    pub regex: String,
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MetricsSource {
    /// <p><p/></p>
    #[serde(rename = "ContentDigest")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content_digest: Option<String>,
    /// <p><p/></p>
    #[serde(rename = "ContentType")]
    pub content_type: String,
    /// <p><p/></p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>Provides information about the location that is configured for storing model artifacts. </p> <p>Model artifacts are the output that results from training a model, and typically consist of trained parameters, a model defintion that describes how to compute inferences, and other metadata.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelArtifacts {
    /// <p>The path of the S3 object that contains the model artifacts. For example, <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.</p>
    #[serde(rename = "S3ModelArtifacts")]
    pub s3_model_artifacts: String,
}

/// <p>Docker container image configuration object for the model bias job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelBiasAppSpecification {
    /// <p>JSON formatted S3 file that defines bias parameters. For more information on this JSON configuration file, see <a href="https://docs.aws.amazon.com/sagemaker/latest/json-bias-parameter-config.html">Configure bias parameters</a>.</p>
    #[serde(rename = "ConfigUri")]
    pub config_uri: String,
    /// <p>Sets the environment variables in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The container image to be run by the model bias job.</p>
    #[serde(rename = "ImageUri")]
    pub image_uri: String,
}

/// <p>The configuration for a baseline model bias job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelBiasBaselineConfig {
    /// <p>The name of the baseline model bias job.</p>
    #[serde(rename = "BaseliningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub baselining_job_name: Option<String>,
    #[serde(rename = "ConstraintsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints_resource: Option<MonitoringConstraintsResource>,
}

/// <p>Inputs for the model bias job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelBiasJobInput {
    #[serde(rename = "EndpointInput")]
    pub endpoint_input: EndpointInput,
    /// <p>Location of ground truth labels to use in model bias job.</p>
    #[serde(rename = "GroundTruthS3Input")]
    pub ground_truth_s3_input: MonitoringGroundTruthS3Input,
}

/// <p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelClientConfig {
    /// <p>The maximum number of retries when invocation requests are failing.</p>
    #[serde(rename = "InvocationsMaxRetries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invocations_max_retries: Option<i64>,
    /// <p>The timeout value in seconds for an invocation request.</p>
    #[serde(rename = "InvocationsTimeoutInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub invocations_timeout_in_seconds: Option<i64>,
}

/// <p>Data quality constraints and statistics for a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelDataQuality {
    /// <p>Data quality constraints for a model.</p>
    #[serde(rename = "Constraints")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints: Option<MetricsSource>,
    /// <p>Data quality statistics for a model.</p>
    #[serde(rename = "Statistics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistics: Option<MetricsSource>,
}

/// <p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelDeployConfig {
    /// <p><p>Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model deployment; set to <code>False</code> otherwise. The default value is <code>False</code>.</p> <note> <p>If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the <code>EndpointName</code>; otherwise a 400 error is thrown.</p> </note></p>
    #[serde(rename = "AutoGenerateEndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_generate_endpoint_name: Option<bool>,
    /// <p><p>Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.</p> <note> <p>Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to <code>False</code>; otherwise a 400 error is thrown.</p> </note></p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
}

/// <p>Provides information about the endpoint of the model deployment.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelDeployResult {
    /// <p><p>The name of the endpoint to which the model has been deployed.</p> <note> <p>If model deployment fails, this field is omitted from the response.</p> </note></p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
}

/// <p>Provides information to verify the integrity of stored model artifacts. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelDigests {
    /// <p>Provides a hash value that uniquely identifies the stored model artifacts.</p>
    #[serde(rename = "ArtifactDigest")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_digest: Option<String>,
}

/// <p>Docker container image configuration object for the model explainability job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelExplainabilityAppSpecification {
    /// <p>JSON formatted S3 file that defines explainability parameters. For more information on this JSON configuration file, see <a href="https://docs.aws.amazon.com/sagemaker/latest/json-model-explainability-parameter-config.html">Configure model explainability parameters</a>.</p>
    #[serde(rename = "ConfigUri")]
    pub config_uri: String,
    /// <p>Sets the environment variables in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The container image to be run by the model explainability job.</p>
    #[serde(rename = "ImageUri")]
    pub image_uri: String,
}

/// <p>The configuration for a baseline model explainability job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelExplainabilityBaselineConfig {
    /// <p>The name of the baseline model explainability job.</p>
    #[serde(rename = "BaseliningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub baselining_job_name: Option<String>,
    #[serde(rename = "ConstraintsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints_resource: Option<MonitoringConstraintsResource>,
}

/// <p>Inputs for the model explainability job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelExplainabilityJobInput {
    #[serde(rename = "EndpointInput")]
    pub endpoint_input: EndpointInput,
}

/// <p>Contains metrics captured from a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelMetrics {
    /// <p>Metrics that measure bais in a model.</p>
    #[serde(rename = "Bias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub bias: Option<Bias>,
    /// <p>Metrics that help explain a model.</p>
    #[serde(rename = "Explainability")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub explainability: Option<Explainability>,
    /// <p>Metrics that measure the quality of the input data for a model.</p>
    #[serde(rename = "ModelDataQuality")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_data_quality: Option<ModelDataQuality>,
    /// <p>Metrics that measure the quality of a model.</p>
    #[serde(rename = "ModelQuality")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_quality: Option<ModelQuality>,
}

/// <p>A versioned model that can be deployed for SageMaker inference.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelPackage {
    /// <p>A description provided when the model approval is set.</p>
    #[serde(rename = "ApprovalDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub approval_description: Option<String>,
    /// <p>Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a>.</p>
    #[serde(rename = "CertifyForMarketplace")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub certify_for_marketplace: Option<bool>,
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The time that the model package was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    #[serde(rename = "InferenceSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub inference_specification: Option<InferenceSpecification>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>The last time the model package was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p><p>The approval status of the model. This can be one of the following values.</p> <ul> <li> <p> <code>APPROVED</code> - The model is approved</p> </li> <li> <p> <code>REJECTED</code> - The model is rejected.</p> </li> <li> <p> <code>PENDING<em>MANUAL</em>APPROVAL</code> - The model is waiting for manual approval.</p> </li> </ul></p>
    #[serde(rename = "ModelApprovalStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_approval_status: Option<String>,
    /// <p>Metrics for the model.</p>
    #[serde(rename = "ModelMetrics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_metrics: Option<ModelMetrics>,
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    #[serde(rename = "ModelPackageArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_arn: Option<String>,
    /// <p>The description of the model package.</p>
    #[serde(rename = "ModelPackageDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_description: Option<String>,
    /// <p>The model group to which the model belongs.</p>
    #[serde(rename = "ModelPackageGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_name: Option<String>,
    /// <p>The name of the model.</p>
    #[serde(rename = "ModelPackageName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_name: Option<String>,
    /// <p><p>The status of the model package. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The model package is pending being created.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The model package is in the process of being created.</p> </li> <li> <p> <code>COMPLETED</code> - The model package was successfully created.</p> </li> <li> <p> <code>FAILED</code> - The model package failed.</p> </li> <li> <p> <code>DELETING</code> - The model package is in the process of being deleted.</p> </li> </ul></p>
    #[serde(rename = "ModelPackageStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_status: Option<String>,
    #[serde(rename = "ModelPackageStatusDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_status_details: Option<ModelPackageStatusDetails>,
    /// <p>The version number of a versioned model.</p>
    #[serde(rename = "ModelPackageVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_version: Option<i64>,
    #[serde(rename = "SourceAlgorithmSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_algorithm_specification: Option<SourceAlgorithmSpecification>,
    /// <p>A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    #[serde(rename = "ValidationSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub validation_specification: Option<ModelPackageValidationSpecification>,
}

/// <p>Describes the Docker container for the model package.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelPackageContainerDefinition {
    /// <p>The DNS host name for the Docker container.</p>
    #[serde(rename = "ContainerHostname")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_hostname: Option<String>,
    /// <p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p> <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>
    #[serde(rename = "Image")]
    pub image: String,
    /// <p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>
    #[serde(rename = "ImageDigest")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_digest: Option<String>,
    /// <p><p>The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p> <note> <p>The model artifacts must be in an S3 bucket that is in the same region as the model package.</p> </note></p>
    #[serde(rename = "ModelDataUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_data_url: Option<String>,
    /// <p>The AWS Marketplace product ID of the model package.</p>
    #[serde(rename = "ProductId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub product_id: Option<String>,
}

/// <p>A group of versioned models in the model registry.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelPackageGroup {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The time that the model group was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    #[serde(rename = "ModelPackageGroupArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_arn: Option<String>,
    /// <p>The description for the model group.</p>
    #[serde(rename = "ModelPackageGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_description: Option<String>,
    /// <p>The name of the model group.</p>
    #[serde(rename = "ModelPackageGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_name: Option<String>,
    /// <p><p>The status of the model group. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The model group is pending being created.</p> </li> <li> <p> <code>IN<em>PROGRESS</code> - The model group is in the process of being created.</p> </li> <li> <p> <code>COMPLETED</code> - The model group was successfully created.</p> </li> <li> <p> <code>FAILED</code> - The model group failed.</p> </li> <li> <p> <code>DELETING</code> - The model group is in the process of being deleted.</p> </li> <li> <p> <code>DELETE</em>FAILED</code> - SageMaker failed to delete the model group.</p> </li> </ul></p>
    #[serde(rename = "ModelPackageGroupStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_status: Option<String>,
    /// <p>A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>Summary information about a model group.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelPackageGroupSummary {
    /// <p>The time that the model group was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    #[serde(rename = "ModelPackageGroupArn")]
    pub model_package_group_arn: String,
    /// <p>A description of the model group.</p>
    #[serde(rename = "ModelPackageGroupDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_description: Option<String>,
    /// <p>The name of the model group.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
    /// <p>The status of the model group.</p>
    #[serde(rename = "ModelPackageGroupStatus")]
    pub model_package_group_status: String,
}

/// <p>Specifies the validation and image scan statuses of the model package.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelPackageStatusDetails {
    /// <p>The status of the scan of the Docker image container for the model package.</p>
    #[serde(rename = "ImageScanStatuses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_scan_statuses: Option<Vec<ModelPackageStatusItem>>,
    /// <p>The validation status of the model package.</p>
    #[serde(rename = "ValidationStatuses")]
    pub validation_statuses: Vec<ModelPackageStatusItem>,
}

/// <p>Represents the overall status of a model package.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelPackageStatusItem {
    /// <p>if the overall status is <code>Failed</code>, the reason for the failure.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The name of the model package for which the overall status is being reported.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The current status.</p>
    #[serde(rename = "Status")]
    pub status: String,
}

/// <p>Provides summary information about a model package.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelPackageSummary {
    /// <p>A timestamp that shows when the model package was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p><p>The approval status of the model. This can be one of the following values.</p> <ul> <li> <p> <code>APPROVED</code> - The model is approved</p> </li> <li> <p> <code>REJECTED</code> - The model is rejected.</p> </li> <li> <p> <code>PENDING<em>MANUAL</em>APPROVAL</code> - The model is waiting for manual approval.</p> </li> </ul></p>
    #[serde(rename = "ModelApprovalStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_approval_status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    #[serde(rename = "ModelPackageArn")]
    pub model_package_arn: String,
    /// <p>A brief description of the model package.</p>
    #[serde(rename = "ModelPackageDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_description: Option<String>,
    /// <p>If the model package is a versioned model, the model group that the versioned model belongs to.</p>
    #[serde(rename = "ModelPackageGroupName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group_name: Option<String>,
    /// <p>The name of the model package.</p>
    #[serde(rename = "ModelPackageName")]
    pub model_package_name: String,
    /// <p>The overall status of the model package.</p>
    #[serde(rename = "ModelPackageStatus")]
    pub model_package_status: String,
    /// <p>If the model package is a versioned model, the version of the model.</p>
    #[serde(rename = "ModelPackageVersion")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_version: Option<i64>,
}

/// <p>Contains data, such as the inputs and targeted instance types that are used in the process of validating the model package.</p> <p>The data provided in the validation profile is made available to your buyers on AWS Marketplace.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelPackageValidationProfile {
    /// <p>The name of the profile for the model package.</p>
    #[serde(rename = "ProfileName")]
    pub profile_name: String,
    /// <p>The <code>TransformJobDefinition</code> object that describes the transform job used for the validation of the model package.</p>
    #[serde(rename = "TransformJobDefinition")]
    pub transform_job_definition: TransformJobDefinition,
}

/// <p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelPackageValidationSpecification {
    /// <p>An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>
    #[serde(rename = "ValidationProfiles")]
    pub validation_profiles: Vec<ModelPackageValidationProfile>,
    /// <p>The IAM roles to be used for the validation of the model package.</p>
    #[serde(rename = "ValidationRole")]
    pub validation_role: String,
}

/// <p>Model quality statistics and constraints.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelQuality {
    /// <p>Model quality constraints.</p>
    #[serde(rename = "Constraints")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints: Option<MetricsSource>,
    /// <p>Model quality statistics.</p>
    #[serde(rename = "Statistics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistics: Option<MetricsSource>,
}

/// <p>Container image configuration object for the monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelQualityAppSpecification {
    /// <p>An array of arguments for the container used to run the monitoring job.</p>
    #[serde(rename = "ContainerArguments")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_arguments: Option<Vec<String>>,
    /// <p>Specifies the entrypoint for a container that the monitoring job runs.</p>
    #[serde(rename = "ContainerEntrypoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_entrypoint: Option<Vec<String>>,
    /// <p>Sets the environment variables in the container that the monitoring job runs.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The address of the container image that the monitoring job runs.</p>
    #[serde(rename = "ImageUri")]
    pub image_uri: String,
    /// <p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>
    #[serde(rename = "PostAnalyticsProcessorSourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub post_analytics_processor_source_uri: Option<String>,
    /// <p>The machine learning problem type of the model that the monitoring job monitors.</p>
    #[serde(rename = "ProblemType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub problem_type: Option<String>,
    /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>
    #[serde(rename = "RecordPreprocessorSourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub record_preprocessor_source_uri: Option<String>,
}

/// <p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelQualityBaselineConfig {
    /// <p>The name of the job that performs baselining for the monitoring job.</p>
    #[serde(rename = "BaseliningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub baselining_job_name: Option<String>,
    #[serde(rename = "ConstraintsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints_resource: Option<MonitoringConstraintsResource>,
}

/// <p>The input for the model quality monitoring job. Currently endponts are supported for input for model quality monitoring jobs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ModelQualityJobInput {
    #[serde(rename = "EndpointInput")]
    pub endpoint_input: EndpointInput,
    /// <p>The ground truth label provided for the model.</p>
    #[serde(rename = "GroundTruthS3Input")]
    pub ground_truth_s3_input: MonitoringGroundTruthS3Input,
}

/// <p>Metadata for Model steps.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelStepMetadata {
    /// <p>The Amazon Resource Name (ARN) of the created model.</p>
    #[serde(rename = "Arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
}

/// <p>Provides summary information about a model.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ModelSummary {
    /// <p>A timestamp that indicates when the model was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    #[serde(rename = "ModelArn")]
    pub model_arn: String,
    /// <p>The name of the model that you want a summary for.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
}

/// <p>Container image configuration object for the monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringAppSpecification {
    /// <p>An array of arguments for the container used to run the monitoring job.</p>
    #[serde(rename = "ContainerArguments")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_arguments: Option<Vec<String>>,
    /// <p>Specifies the entrypoint for a container used to run the monitoring job.</p>
    #[serde(rename = "ContainerEntrypoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub container_entrypoint: Option<Vec<String>>,
    /// <p>The container image to be run by the monitoring job.</p>
    #[serde(rename = "ImageUri")]
    pub image_uri: String,
    /// <p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>
    #[serde(rename = "PostAnalyticsProcessorSourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub post_analytics_processor_source_uri: Option<String>,
    /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>
    #[serde(rename = "RecordPreprocessorSourceUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub record_preprocessor_source_uri: Option<String>,
}

/// <p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringBaselineConfig {
    /// <p>The name of the job that performs baselining for the monitoring job.</p>
    #[serde(rename = "BaseliningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub baselining_job_name: Option<String>,
    /// <p>The baseline constraint file in Amazon S3 that the current monitoring job should validated against.</p>
    #[serde(rename = "ConstraintsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub constraints_resource: Option<MonitoringConstraintsResource>,
    /// <p>The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.</p>
    #[serde(rename = "StatisticsResource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub statistics_resource: Option<MonitoringStatisticsResource>,
}

/// <p>Configuration for the cluster used to run model monitoring jobs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringClusterConfig {
    /// <p>The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>
    #[serde(rename = "InstanceCount")]
    pub instance_count: i64,
    /// <p>The ML compute instance type for the processing job.</p>
    #[serde(rename = "InstanceType")]
    pub instance_type: String,
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.</p>
    #[serde(rename = "VolumeKmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_kms_key_id: Option<String>,
    /// <p>The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.</p>
    #[serde(rename = "VolumeSizeInGB")]
    pub volume_size_in_gb: i64,
}

/// <p>The constraints resource for a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringConstraintsResource {
    /// <p>The Amazon S3 URI for the constraints resource.</p>
    #[serde(rename = "S3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_uri: Option<String>,
}

/// <p>Summary of information about the last monitoring job to run.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MonitoringExecutionSummary {
    /// <p>The time at which the monitoring job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The name of the endpoint used to run the monitoring job.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>Contains the reason a monitoring job failed, if it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>A timestamp that indicates the last time the monitoring job was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The status of the monitoring job.</p>
    #[serde(rename = "MonitoringExecutionStatus")]
    pub monitoring_execution_status: String,
    /// <p>The name of the monitoring job.</p>
    #[serde(rename = "MonitoringJobDefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_job_definition_name: Option<String>,
    /// <p>The name of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
    /// <p>The type of the monitoring job.</p>
    #[serde(rename = "MonitoringType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the monitoring job.</p>
    #[serde(rename = "ProcessingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_job_arn: Option<String>,
    /// <p>The time the monitoring job was scheduled.</p>
    #[serde(rename = "ScheduledTime")]
    pub scheduled_time: f64,
}

/// <p>The ground truth labels for the dataset used for the monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringGroundTruthS3Input {
    /// <p>The address of the Amazon S3 location of the ground truth labels.</p>
    #[serde(rename = "S3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_uri: Option<String>,
}

/// <p>The inputs for a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringInput {
    /// <p>The endpoint for a monitoring job.</p>
    #[serde(rename = "EndpointInput")]
    pub endpoint_input: EndpointInput,
}

/// <p>Defines the monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringJobDefinition {
    /// <p>Baseline configuration used to validate that the data conforms to the specified constraints and statistics</p>
    #[serde(rename = "BaselineConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub baseline_config: Option<MonitoringBaselineConfig>,
    /// <p>Sets the environment variables in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>Configures the monitoring job to run a specified Docker container image.</p>
    #[serde(rename = "MonitoringAppSpecification")]
    pub monitoring_app_specification: MonitoringAppSpecification,
    /// <p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.</p>
    #[serde(rename = "MonitoringInputs")]
    pub monitoring_inputs: Vec<MonitoringInput>,
    /// <p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).</p>
    #[serde(rename = "MonitoringOutputConfig")]
    pub monitoring_output_config: MonitoringOutputConfig,
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.</p>
    #[serde(rename = "MonitoringResources")]
    pub monitoring_resources: MonitoringResources,
    /// <p>Specifies networking options for an monitoring job.</p>
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<NetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>Specifies a time limit for how long the monitoring job is allowed to run.</p>
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<MonitoringStoppingCondition>,
}

/// <p>Summary information about a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MonitoringJobDefinitionSummary {
    /// <p>The time that the monitoring job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The name of the endpoint that the job monitors.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p>The Amazon Resource Name (ARN) of the monitoring job.</p>
    #[serde(rename = "MonitoringJobDefinitionArn")]
    pub monitoring_job_definition_arn: String,
    /// <p>The name of the monitoring job.</p>
    #[serde(rename = "MonitoringJobDefinitionName")]
    pub monitoring_job_definition_name: String,
}

/// <p>The networking configuration for the monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringNetworkConfig {
    /// <p>Whether to encrypt all communications between the instances used for the monitoring jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

/// <p>The output object for a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringOutput {
    /// <p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>
    #[serde(rename = "S3Output")]
    pub s3_output: MonitoringS3Output,
}

/// <p>The output configuration for monitoring jobs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringOutputConfig {
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.</p>
    #[serde(rename = "MonitoringOutputs")]
    pub monitoring_outputs: Vec<MonitoringOutput>,
}

/// <p>Identifies the resources to deploy for a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringResources {
    /// <p>The configuration for the cluster resources used to run the processing job.</p>
    #[serde(rename = "ClusterConfig")]
    pub cluster_config: MonitoringClusterConfig,
}

/// <p>Information about where and how you want to store the results of a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringS3Output {
    /// <p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.</p>
    #[serde(rename = "LocalPath")]
    pub local_path: String,
    /// <p>Whether to upload the results of the monitoring job continuously or after the job completes.</p>
    #[serde(rename = "S3UploadMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_upload_mode: Option<String>,
    /// <p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>A schedule for a model monitoring job. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MonitoringSchedule {
    /// <p>The time that the monitoring schedule was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The endpoint that hosts the model being monitored.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>If the monitoring schedule failed, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The last time the monitoring schedule was changed.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "LastMonitoringExecutionSummary")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_monitoring_execution_summary: Option<MonitoringExecutionSummary>,
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_arn: Option<String>,
    #[serde(rename = "MonitoringScheduleConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_config: Option<MonitoringScheduleConfig>,
    /// <p>The name of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_name: Option<String>,
    /// <p><p>The status of the monitoring schedule. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The schedule is pending being created.</p> </li> <li> <p> <code>FAILED</code> - The schedule failed.</p> </li> <li> <p> <code>SCHEDULED</code> - The schedule was successfully created.</p> </li> <li> <p> <code>STOPPED</code> - The schedule was stopped.</p> </li> </ul></p>
    #[serde(rename = "MonitoringScheduleStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_status: Option<String>,
    /// <p>The type of the monitoring job definition to schedule.</p>
    #[serde(rename = "MonitoringType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type: Option<String>,
    /// <p>A list of the tags associated with the monitoring schedlue. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <i>AWS General Reference Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>Configures the monitoring schedule and defines the monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringScheduleConfig {
    /// <p>Defines the monitoring job.</p>
    #[serde(rename = "MonitoringJobDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_job_definition: Option<MonitoringJobDefinition>,
    /// <p>The name of the monitoring job definition to schedule.</p>
    #[serde(rename = "MonitoringJobDefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_job_definition_name: Option<String>,
    /// <p>The type of the monitoring job definition to schedule.</p>
    #[serde(rename = "MonitoringType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type: Option<String>,
    /// <p>Configures the monitoring schedule.</p>
    #[serde(rename = "ScheduleConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub schedule_config: Option<ScheduleConfig>,
}

/// <p>Summarizes the monitoring schedule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct MonitoringScheduleSummary {
    /// <p>The creation time of the monitoring schedule.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The name of the endpoint using the monitoring schedule.</p>
    #[serde(rename = "EndpointName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint_name: Option<String>,
    /// <p>The last time the monitoring schedule was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    pub last_modified_time: f64,
    /// <p>The name of the monitoring job definition that the schedule is for.</p>
    #[serde(rename = "MonitoringJobDefinitionName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_job_definition_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    pub monitoring_schedule_arn: String,
    /// <p>The name of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
    /// <p>The status of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleStatus")]
    pub monitoring_schedule_status: String,
    /// <p>The type of the monitoring job definition that the schedule is for.</p>
    #[serde(rename = "MonitoringType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_type: Option<String>,
}

/// <p>The statistics resource for a monitoring job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringStatisticsResource {
    /// <p>The Amazon S3 URI for the statistics resource.</p>
    #[serde(rename = "S3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_uri: Option<String>,
}

/// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MonitoringStoppingCondition {
    /// <p><p>The maximum runtime allowed in seconds.</p> <note> <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and model explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model quality hourly schedules, this can be up to 1800 seconds.</p> </note></p>
    #[serde(rename = "MaxRuntimeInSeconds")]
    pub max_runtime_in_seconds: i64,
}

/// <p>Specifies additional configuration for hosting multi-model endpoints.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct MultiModelConfig {
    /// <p>Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to <code>Disabled</code>.</p>
    #[serde(rename = "ModelCacheSetting")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_cache_setting: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct NeoVpcConfig {
    #[serde(rename = "SecurityGroupIds")]
    pub security_group_ids: Vec<String>,
    #[serde(rename = "Subnets")]
    pub subnets: Vec<String>,
}

/// <p><p>A list of nested <a>Filter</a> objects. A resource must satisfy the conditions of all filters to be included in the results returned from the <a>Search</a> API.</p> <p>For example, to filter on a training job&#39;s <code>InputDataConfig</code> property with a specific channel name and <code>S3Uri</code> prefix, define the following filters:</p> <ul> <li> <p> <code>&#39;{Name:&quot;InputDataConfig.ChannelName&quot;, &quot;Operator&quot;:&quot;Equals&quot;, &quot;Value&quot;:&quot;train&quot;}&#39;,</code> </p> </li> <li> <p> <code>&#39;{Name:&quot;InputDataConfig.DataSource.S3DataSource.S3Uri&quot;, &quot;Operator&quot;:&quot;Contains&quot;, &quot;Value&quot;:&quot;mybucket/catdata&quot;}&#39;</code> </p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct NestedFilters {
    /// <p>A list of filters. Each filter acts on a property. Filters must contain at least one <code>Filters</code> value. For example, a <code>NestedFilters</code> call might include a filter on the <code>PropertyName</code> parameter of the <code>InputDataConfig</code> property: <code>InputDataConfig.DataSource.S3DataSource.S3Uri</code>.</p>
    #[serde(rename = "Filters")]
    pub filters: Vec<Filter>,
    /// <p>The name of the property to use in the nested filters. The value must match a listed property name, such as <code>InputDataConfig</code>.</p>
    #[serde(rename = "NestedPropertyName")]
    pub nested_property_name: String,
}

/// <p>Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct NetworkConfig {
    /// <p>Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>Whether to allow inbound and outbound network calls to and from the containers used for the processing job.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

/// <p>Provides a summary of a notebook instance lifecycle configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct NotebookInstanceLifecycleConfigSummary {
    /// <p>A timestamp that tells when the lifecycle configuration was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>A timestamp that tells when the lifecycle configuration was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigArn")]
    pub notebook_instance_lifecycle_config_arn: String,
    /// <p>The name of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    pub notebook_instance_lifecycle_config_name: String,
}

/// <p>Contains the notebook instance lifecycle configuration script.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct NotebookInstanceLifecycleHook {
    /// <p>A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.</p>
    #[serde(rename = "Content")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
}

/// <p>Provides summary information for an Amazon SageMaker notebook instance.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct NotebookInstanceSummary {
    /// <p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "AdditionalCodeRepositories")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_code_repositories: Option<Vec<String>>,
    /// <p>A timestamp that shows when the notebook instance was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "DefaultCodeRepository")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_code_repository: Option<String>,
    /// <p>The type of ML compute instance that the notebook instance is running on.</p>
    #[serde(rename = "InstanceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    /// <p>A timestamp that shows when the notebook instance was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the notebook instance.</p>
    #[serde(rename = "NotebookInstanceArn")]
    pub notebook_instance_arn: String,
    /// <p>The name of a notebook instance lifecycle configuration associated with this notebook instance.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_lifecycle_config_name: Option<String>,
    /// <p>The name of the notebook instance that you want a summary for.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
    /// <p>The status of the notebook instance.</p>
    #[serde(rename = "NotebookInstanceStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_instance_status: Option<String>,
    /// <p>The URL that you use to connect to the Jupyter instance running in your notebook instance. </p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

/// <p>Configures SNS notifications of available or expiring work items for work teams.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct NotificationConfiguration {
    /// <p>The ARN for the SNS topic to which notifications should be published.</p>
    #[serde(rename = "NotificationTopicArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notification_topic_arn: Option<String>,
}

/// <p>Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ObjectiveStatusCounters {
    /// <p>The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p>
    #[serde(rename = "Failed")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failed: Option<i64>,
    /// <p>The number of training jobs that are in progress and pending evaluation of their final objective metric.</p>
    #[serde(rename = "Pending")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pending: Option<i64>,
    /// <p>The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p>
    #[serde(rename = "Succeeded")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub succeeded: Option<i64>,
}

/// <p>The configuration of an <code>OfflineStore</code>.</p> <p>Provide an <code>OfflineStoreConfig</code> in a request to <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p> <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify AWS Key Management Service (KMS) key ID, or <code>KMSKeyId</code>, in <code>S3StorageConfig</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OfflineStoreConfig {
    /// <p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created. </p>
    #[serde(rename = "DataCatalogConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_catalog_config: Option<DataCatalogConfig>,
    /// <p>Set to <code>True</code> to disable the automatic creation of an AWS Glue table when configuring an <code>OfflineStore</code>.</p>
    #[serde(rename = "DisableGlueTableCreation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disable_glue_table_creation: Option<bool>,
    /// <p>The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.</p>
    #[serde(rename = "S3StorageConfig")]
    pub s3_storage_config: S3StorageConfig,
}

/// <p>The status of <code>OfflineStore</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct OfflineStoreStatus {
    /// <p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>
    #[serde(rename = "BlockedReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub blocked_reason: Option<String>,
    /// <p>An <code>OfflineStore</code> status.</p>
    #[serde(rename = "Status")]
    pub status: String,
}

/// <p>Use this parameter to configure your OIDC Identity Provider (IdP).</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct OidcConfig {
    /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
    #[serde(rename = "AuthorizationEndpoint")]
    pub authorization_endpoint: String,
    /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
    #[serde(rename = "ClientId")]
    pub client_id: String,
    /// <p>The OIDC IdP client secret used to configure your private workforce.</p>
    #[serde(rename = "ClientSecret")]
    pub client_secret: String,
    /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
    #[serde(rename = "Issuer")]
    pub issuer: String,
    /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
    #[serde(rename = "JwksUri")]
    pub jwks_uri: String,
    /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
    #[serde(rename = "LogoutEndpoint")]
    pub logout_endpoint: String,
    /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
    #[serde(rename = "TokenEndpoint")]
    pub token_endpoint: String,
    /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
    #[serde(rename = "UserInfoEndpoint")]
    pub user_info_endpoint: String,
}

/// <p>Your OIDC IdP workforce configuration.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct OidcConfigForResponse {
    /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
    #[serde(rename = "AuthorizationEndpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub authorization_endpoint: Option<String>,
    /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
    #[serde(rename = "ClientId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_id: Option<String>,
    /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
    #[serde(rename = "Issuer")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub issuer: Option<String>,
    /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
    #[serde(rename = "JwksUri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub jwks_uri: Option<String>,
    /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
    #[serde(rename = "LogoutEndpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub logout_endpoint: Option<String>,
    /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
    #[serde(rename = "TokenEndpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub token_endpoint: Option<String>,
    /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
    #[serde(rename = "UserInfoEndpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_info_endpoint: Option<String>,
}

/// <p>A list of user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OidcMemberDefinition {
    /// <p>A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.</p>
    #[serde(rename = "Groups")]
    pub groups: Vec<String>,
}

/// <p>Use this to specify the AWS Key Management Service (KMS) Key ID, or <code>KMSKeyId</code>, for at rest data encryption. You can turn <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag at General Assembly; the default value is <code>False</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OnlineStoreConfig {
    /// <p>Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag. </p> <p>The default value is <code>False</code>.</p>
    #[serde(rename = "EnableOnlineStore")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_online_store: Option<bool>,
    /// <p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>.</p>
    #[serde(rename = "SecurityConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub security_config: Option<OnlineStoreSecurityConfig>,
}

/// <p>The security configuration for <code>OnlineStore</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OnlineStoreSecurityConfig {
    /// <p><p>The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p> <p>The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to the <code>OnlineStore</code> <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>&quot;kms:Encrypt&quot;</code> </p> </li> <li> <p> <code>&quot;kms:Decrypt&quot;</code> </p> </li> <li> <p> <code>&quot;kms:DescribeKey&quot;</code> </p> </li> <li> <p> <code>&quot;kms:CreateGrant&quot;</code> </p> </li> <li> <p> <code>&quot;kms:RetireGrant&quot;</code> </p> </li> <li> <p> <code>&quot;kms:ReEncryptFrom&quot;</code> </p> </li> <li> <p> <code>&quot;kms:ReEncryptTo&quot;</code> </p> </li> <li> <p> <code>&quot;kms:GenerateDataKey&quot;</code> </p> </li> <li> <p> <code>&quot;kms:ListAliases&quot;</code> </p> </li> <li> <p> <code>&quot;kms:ListGrants&quot;</code> </p> </li> <li> <p> <code>&quot;kms:RevokeGrant&quot;</code> </p> </li> </ul> <p>The caller (either IAM user or IAM role) to all DataPlane operations (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>&quot;kms:Decrypt&quot;</code> </p> </li> </ul></p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
}

/// <p>Contains information about the output location for the compiled model and the target device that the model runs on. <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OutputConfig {
    /// <p><p>Specifies additional parameters for compiler options in JSON format. The compiler options are <code>TargetPlatform</code> specific. It is required for NVIDIA accelerators and highly recommended for CPU compilations. For any other cases, it is optional to specify <code>CompilerOptions.</code> </p> <ul> <li> <p> <code>DTYPE</code>: Specifies the data type for the input. When compiling for <code>ml<em>*</code> (except for <code>ml</em>inf</code>) instances using PyTorch framework, provide the data type (dtype) of the model&#39;s input. <code>&quot;float32&quot;</code> is used if <code>&quot;DTYPE&quot;</code> is not specified. Options for data type are:</p> <ul> <li> <p>float32: Use either <code>&quot;float&quot;</code> or <code>&quot;float32&quot;</code>.</p> </li> <li> <p>int64: Use either <code>&quot;int64&quot;</code> or <code>&quot;long&quot;</code>.</p> </li> </ul> <p> For example, <code>{&quot;dtype&quot; : &quot;float32&quot;}</code>.</p> </li> <li> <p> <code>CPU</code>: Compilation for CPU supports the following compiler options.</p> <ul> <li> <p> <code>mcpu</code>: CPU micro-architecture. For example, <code>{&#39;mcpu&#39;: &#39;skylake-avx512&#39;}</code> </p> </li> <li> <p> <code>mattr</code>: CPU flags. For example, <code>{&#39;mattr&#39;: [&#39;+neon&#39;, &#39;+vfpv4&#39;]}</code> </p> </li> </ul> </li> <li> <p> <code>ARM</code>: Details of ARM CPU compilations.</p> <ul> <li> <p> <code>NEON</code>: NEON is an implementation of the Advanced SIMD extension used in ARMv7 processors.</p> <p>For example, add <code>{&#39;mattr&#39;: [&#39;+neon&#39;]}</code> to the compiler options if compiling for ARM 32-bit platform with the NEON support.</p> </li> </ul> </li> <li> <p> <code>NVIDIA</code>: Compilation for NVIDIA GPU supports the following compiler options.</p> <ul> <li> <p> <code>gpu<em>code</code>: Specifies the targeted architecture.</p> </li> <li> <p> <code>trt-ver</code>: Specifies the TensorRT versions in x.y.z. format.</p> </li> <li> <p> <code>cuda-ver</code>: Specifies the CUDA version in x.y format.</p> </li> </ul> <p>For example, <code>{&#39;gpu-code&#39;: &#39;sm</em>72&#39;, &#39;trt-ver&#39;: &#39;6.0.1&#39;, &#39;cuda-ver&#39;: &#39;10.1&#39;}</code> </p> </li> <li> <p> <code>ANDROID</code>: Compilation for the Android OS supports the following compiler options:</p> <ul> <li> <p> <code>ANDROID<em>PLATFORM</code>: Specifies the Android API levels. Available levels range from 21 to 29. For example, <code>{&#39;ANDROID</em>PLATFORM&#39;: 28}</code>.</p> </li> <li> <p> <code>mattr</code>: Add <code>{&#39;mattr&#39;: [&#39;+neon&#39;]}</code> to compiler options if compiling for ARM 32-bit platform with NEON support.</p> </li> </ul> </li> <li> <p> <code>INFERENTIA</code>: Compilation for target ml<em>inf1 uses compiler options passed in as a JSON string. For example, <code>&quot;CompilerOptions&quot;: &quot;&quot;--verbose 1 --num-neuroncores 2 -O2&quot;&quot;</code>. </p> <p>For information about supported compiler options, see <a href="https://github.com/aws/aws-neuron-sdk/blob/master/docs/neuron-cc/command-line-reference.md"> Neuron Compiler CLI</a>. </p> </li> <li> <p> <code>CoreML</code>: Compilation for the CoreML <a>OutputConfig$TargetDevice</a> supports the following compiler options:</p> <ul> <li> <p> <code>class</em>labels</code>: Specifies the classification labels file name inside input tar.gz file. For example, <code>{&quot;class<em>labels&quot;: &quot;imagenet</em>labels<em>1000.txt&quot;}</code>. Labels inside the txt file should be separated by newlines.</p> </li> </ul> </li> <li> <p> <code>EIA</code>: Compilation for the Elastic Inference Accelerator supports the following compiler options:</p> <ul> <li> <p> <code>precision</em>mode</code>: Specifies the precision of compiled artifacts. Supported values are <code>&quot;FP16&quot;</code> and <code>&quot;FP32&quot;</code>. Default is <code>&quot;FP32&quot;</code>.</p> </li> <li> <p> <code>signature<em>def</em>key</code>: Specifies the signature to use for models in SavedModel format. Defaults is TensorFlow&#39;s default signature def key.</p> </li> <li> <p> <code>output<em>names</code>: Specifies a list of output tensor names for models in FrozenGraph format. Set at most one API field, either: <code>signature</em>def<em>key</code> or <code>output</em>names</code>.</p> </li> </ul> <p>For example: <code>{&quot;precision<em>mode&quot;: &quot;FP32&quot;, &quot;output</em>names&quot;: [&quot;output:0&quot;]}</code> </p> </li> </ul></p>
    #[serde(rename = "CompilerOptions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compiler_options: Option<String>,
    /// <p><p>The Amazon Web Services Key Management Service key (Amazon Web Services KMS) that Amazon SageMaker uses to encrypt your output models with Amazon S3 server-side encryption after compilation job. If you don&#39;t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role&#39;s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul></p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>Identifies the S3 bucket where you want Amazon SageMaker to store the model artifacts. For example, <code>s3://bucket-name/key-name-prefix</code>.</p>
    #[serde(rename = "S3OutputLocation")]
    pub s3_output_location: String,
    /// <p>Identifies the target device or the machine learning instance that you want to run your model on after the compilation has completed. Alternatively, you can specify OS, architecture, and accelerator using <a>TargetPlatform</a> fields. It can be used instead of <code>TargetPlatform</code>.</p>
    #[serde(rename = "TargetDevice")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_device: Option<String>,
    /// <p><p>Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of <code>TargetDevice</code>.</p> <p>The following examples show how to configure the <code>TargetPlatform</code> and <code>CompilerOptions</code> JSON strings for popular target platforms: </p> <ul> <li> <p>Raspberry Pi 3 Model B+</p> <p> <code>&quot;TargetPlatform&quot;: {&quot;Os&quot;: &quot;LINUX&quot;, &quot;Arch&quot;: &quot;ARM<em>EABIHF&quot;},</code> </p> <p> <code> &quot;CompilerOptions&quot;: {&#39;mattr&#39;: [&#39;+neon&#39;]}</code> </p> </li> <li> <p>Jetson TX2</p> <p> <code>&quot;TargetPlatform&quot;: {&quot;Os&quot;: &quot;LINUX&quot;, &quot;Arch&quot;: &quot;ARM64&quot;, &quot;Accelerator&quot;: &quot;NVIDIA&quot;},</code> </p> <p> <code> &quot;CompilerOptions&quot;: {&#39;gpu-code&#39;: &#39;sm</em>62&#39;, &#39;trt-ver&#39;: &#39;6.0.1&#39;, &#39;cuda-ver&#39;: &#39;10.0&#39;}</code> </p> </li> <li> <p>EC2 m5.2xlarge instance OS</p> <p> <code>&quot;TargetPlatform&quot;: {&quot;Os&quot;: &quot;LINUX&quot;, &quot;Arch&quot;: &quot;X86<em>64&quot;, &quot;Accelerator&quot;: &quot;NVIDIA&quot;},</code> </p> <p> <code> &quot;CompilerOptions&quot;: {&#39;mcpu&#39;: &#39;skylake-avx512&#39;}</code> </p> </li> <li> <p>RK3399</p> <p> <code>&quot;TargetPlatform&quot;: {&quot;Os&quot;: &quot;LINUX&quot;, &quot;Arch&quot;: &quot;ARM64&quot;, &quot;Accelerator&quot;: &quot;MALI&quot;}</code> </p> </li> <li> <p>ARMv7 phone (CPU)</p> <p> <code>&quot;TargetPlatform&quot;: {&quot;Os&quot;: &quot;ANDROID&quot;, &quot;Arch&quot;: &quot;ARM</em>EABI&quot;},</code> </p> <p> <code> &quot;CompilerOptions&quot;: {&#39;ANDROID<em>PLATFORM&#39;: 25, &#39;mattr&#39;: [&#39;+neon&#39;]}</code> </p> </li> <li> <p>ARMv8 phone (CPU)</p> <p> <code>&quot;TargetPlatform&quot;: {&quot;Os&quot;: &quot;ANDROID&quot;, &quot;Arch&quot;: &quot;ARM64&quot;},</code> </p> <p> <code> &quot;CompilerOptions&quot;: {&#39;ANDROID</em>PLATFORM&#39;: 29}</code> </p> </li> </ul></p>
    #[serde(rename = "TargetPlatform")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub target_platform: Option<TargetPlatform>,
}

/// <p>Provides information about how to store model training results (model artifacts).</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OutputDataConfig {
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your master key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. Amazon SageMaker uses server-side encryption with KMS-managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateTrainingJob</code>, <code>CreateTransformJob</code>, or <code>CreateHyperParameterTuningJob</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example, <code>s3://bucket-name/key-name-prefix</code>. </p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>An output parameter of a pipeline step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct OutputParameter {
    /// <p>The name of the output parameter.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The value of the output parameter.</p>
    #[serde(rename = "Value")]
    pub value: String,
}

/// <p>Assigns a value to a named Pipeline parameter.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Parameter {
    /// <p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>
    #[serde(rename = "Name")]
    pub name: String,
    /// <p>The literal value for the parameter.</p>
    #[serde(rename = "Value")]
    pub value: String,
}

/// <p>Defines the possible values for categorical, continuous, and integer hyperparameters to be used by an algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ParameterRange {
    /// <p>A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a categorical hyperparameter.</p>
    #[serde(rename = "CategoricalParameterRangeSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub categorical_parameter_range_specification: Option<CategoricalParameterRangeSpecification>,
    /// <p>A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous hyperparameter.</p>
    #[serde(rename = "ContinuousParameterRangeSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub continuous_parameter_range_specification: Option<ContinuousParameterRangeSpecification>,
    /// <p>A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer hyperparameter.</p>
    #[serde(rename = "IntegerParameterRangeSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub integer_parameter_range_specification: Option<IntegerParameterRangeSpecification>,
}

/// <p><p>Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.</p> <note> <p>You can specify a maximum of 20 hyperparameters that a hyperparameter tuning job can search over. Every possible value of a categorical parameter range counts against this limit.</p> </note></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ParameterRanges {
    /// <p>The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that a hyperparameter tuning job searches.</p>
    #[serde(rename = "CategoricalParameterRanges")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub categorical_parameter_ranges: Option<Vec<CategoricalParameterRange>>,
    /// <p>The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a hyperparameter tuning job searches.</p>
    #[serde(rename = "ContinuousParameterRanges")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub continuous_parameter_ranges: Option<Vec<ContinuousParameterRange>>,
    /// <p>The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a hyperparameter tuning job searches.</p>
    #[serde(rename = "IntegerParameterRanges")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub integer_parameter_ranges: Option<Vec<IntegerParameterRange>>,
}

/// <p>The trial that a trial component is associated with and the experiment the trial is part of. A component might not be associated with a trial. A component can be associated with multiple trials.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Parent {
    /// <p>The name of the experiment.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>The name of the trial.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
}

/// <p>A previously completed or stopped hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ParentHyperParameterTuningJob {
    /// <p>The name of the hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameter_tuning_job_name: Option<String>,
}

/// <p>A SageMaker Model Building Pipeline instance.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Pipeline {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The creation time of the pipeline.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>The time that the pipeline was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The time when the pipeline was last run.</p>
    #[serde(rename = "LastRunTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_run_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
    /// <p>The description of the pipeline.</p>
    #[serde(rename = "PipelineDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_description: Option<String>,
    /// <p>The display name of the pipeline.</p>
    #[serde(rename = "PipelineDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_display_name: Option<String>,
    /// <p>The name of the pipeline.</p>
    #[serde(rename = "PipelineName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    /// <p>The status of the pipeline.</p>
    #[serde(rename = "PipelineStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the role that created the pipeline.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p>A list of tags that apply to the pipeline.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>An execution of a pipeline.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PipelineExecution {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>The creation time of the pipeline execution.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>If the execution failed, a message describing why.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>The time that the pipeline execution was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
    /// <p>The description of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_description: Option<String>,
    /// <p>The display name of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_display_name: Option<String>,
    /// <p>The status of the pipeline status.</p>
    #[serde(rename = "PipelineExecutionStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_status: Option<String>,
    #[serde(rename = "PipelineExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_experiment_config: Option<PipelineExperimentConfig>,
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    #[serde(rename = "PipelineParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_parameters: Option<Vec<Parameter>>,
}

/// <p>An execution of a step in a pipeline.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PipelineExecutionStep {
    /// <p>If this pipeline execution step was cached, details on the cache hit.</p>
    #[serde(rename = "CacheHitResult")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cache_hit_result: Option<CacheHitResult>,
    /// <p>The time that the step stopped executing.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The reason why the step failed execution. This is only returned if the step failed its execution.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>Metadata for the step execution.</p>
    #[serde(rename = "Metadata")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata: Option<PipelineExecutionStepMetadata>,
    /// <p>The time that the step started executing.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p>The name of the step that is executed.</p>
    #[serde(rename = "StepName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub step_name: Option<String>,
    /// <p>The status of the step execution.</p>
    #[serde(rename = "StepStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub step_status: Option<String>,
}

/// <p>Metadata for a step execution.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PipelineExecutionStepMetadata {
    #[serde(rename = "Callback")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub callback: Option<CallbackStepMetadata>,
    /// <p>If this is a Condition step metadata object, details on the condition.</p>
    #[serde(rename = "Condition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub condition: Option<ConditionStepMetadata>,
    /// <p>Metadata for the Model step.</p>
    #[serde(rename = "Model")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model: Option<ModelStepMetadata>,
    /// <p>The Amazon Resource Name (ARN) of the processing job that was run by this step execution.</p>
    #[serde(rename = "ProcessingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_job: Option<ProcessingJobStepMetadata>,
    /// <p>Metadata for the RegisterModel step.</p>
    #[serde(rename = "RegisterModel")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub register_model: Option<RegisterModelStepMetadata>,
    /// <p>The Amazon Resource Name (ARN) of the training job that was run by this step execution.</p>
    #[serde(rename = "TrainingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job: Option<TrainingJobStepMetadata>,
    /// <p>The Amazon Resource Name (ARN) of the transform job that was run by this step execution.</p>
    #[serde(rename = "TransformJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_job: Option<TransformJobStepMetadata>,
}

/// <p>A pipeline execution summary.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PipelineExecutionSummary {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
    /// <p>The description of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_description: Option<String>,
    /// <p>The display name of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_display_name: Option<String>,
    /// <p>The status of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_status: Option<String>,
    /// <p>The start time of the pipeline execution.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
}

/// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PipelineExperimentConfig {
    /// <p>The name of the experiment.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    /// <p>The name of the trial.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
}

/// <p>A summary of a pipeline.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PipelineSummary {
    /// <p>The creation time of the pipeline.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The last time that a pipeline execution began.</p>
    #[serde(rename = "LastExecutionTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_execution_time: Option<f64>,
    /// <p>The time that the pipeline was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p> The Amazon Resource Name (ARN) of the pipeline.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
    /// <p>The description of the pipeline.</p>
    #[serde(rename = "PipelineDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_description: Option<String>,
    /// <p>The display name of the pipeline.</p>
    #[serde(rename = "PipelineDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_display_name: Option<String>,
    /// <p>The name of the pipeline.</p>
    #[serde(rename = "PipelineName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) that the pipeline used to execute.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

/// <p>Configuration for the cluster used to run a processing job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingClusterConfig {
    /// <p>The number of ML compute instances to use in the processing job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>
    #[serde(rename = "InstanceCount")]
    pub instance_count: i64,
    /// <p>The ML compute instance type for the processing job.</p>
    #[serde(rename = "InstanceType")]
    pub instance_type: String,
    /// <p><p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the processing job. </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can&#39;t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note></p>
    #[serde(rename = "VolumeKmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_kms_key_id: Option<String>,
    /// <p><p>The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML storage for your scenario.</p> <note> <p>Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for processing, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can&#39;t request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.</p> <p>For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> </note></p>
    #[serde(rename = "VolumeSizeInGB")]
    pub volume_size_in_gb: i64,
}

/// <p>Configuration for processing job outputs in Amazon SageMaker Feature Store.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingFeatureStoreOutput {
    /// <p>The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. Note that your processing script is responsible for putting records into your Feature Store.</p>
    #[serde(rename = "FeatureGroupName")]
    pub feature_group_name: String,
}

/// <p>The inputs for a processing job. The processing input must specify exactly one of either <code>S3Input</code> or <code>DatasetDefinition</code> types.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingInput {
    /// <p>When <code>True</code>, input operations such as data download are managed natively by the processing job application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.</p>
    #[serde(rename = "AppManaged")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_managed: Option<bool>,
    /// <p>Configuration for a Dataset Definition input. </p>
    #[serde(rename = "DatasetDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dataset_definition: Option<DatasetDefinition>,
    /// <p>The name for the processing job input.</p>
    #[serde(rename = "InputName")]
    pub input_name: String,
    /// <p>Configuration for downloading input data from Amazon S3 into the processing container.</p>
    #[serde(rename = "S3Input")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_input: Option<ProcessingS3Input>,
}

/// <p>An Amazon SageMaker processing job that is used to analyze data and evaluate models. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html">Process Data and Evaluate Models</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProcessingJob {
    #[serde(rename = "AppSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_specification: Option<AppSpecification>,
    /// <p>The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.</p>
    #[serde(rename = "AutoMLJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_arn: Option<String>,
    /// <p>The time the processing job was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>Sets the environment variables in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
    #[serde(rename = "ExitMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exit_message: Option<String>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The time the processing job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub monitoring_schedule_arn: Option<String>,
    #[serde(rename = "NetworkConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub network_config: Option<NetworkConfig>,
    /// <p>The time that the processing job ended.</p>
    #[serde(rename = "ProcessingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_end_time: Option<f64>,
    /// <p>List of input configurations for the processing job.</p>
    #[serde(rename = "ProcessingInputs")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_inputs: Option<Vec<ProcessingInput>>,
    /// <p>The ARN of the processing job.</p>
    #[serde(rename = "ProcessingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_job_arn: Option<String>,
    /// <p>The name of the processing job.</p>
    #[serde(rename = "ProcessingJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_job_name: Option<String>,
    /// <p>The status of the processing job.</p>
    #[serde(rename = "ProcessingJobStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_job_status: Option<String>,
    #[serde(rename = "ProcessingOutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_output_config: Option<ProcessingOutputConfig>,
    #[serde(rename = "ProcessingResources")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_resources: Option<ProcessingResources>,
    /// <p>The time that the processing job started.</p>
    #[serde(rename = "ProcessingStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_start_time: Option<f64>,
    /// <p>The ARN of the role used to create the processing job.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<ProcessingStoppingCondition>,
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The ARN of the training job associated with this processing job.</p>
    #[serde(rename = "TrainingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_arn: Option<String>,
}

/// <p>Metadata for a processing job step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProcessingJobStepMetadata {
    /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
    #[serde(rename = "Arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
}

/// <p>Summary of information about a processing job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProcessingJobSummary {
    /// <p>The time at which the processing job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
    #[serde(rename = "ExitMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exit_message: Option<String>,
    /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>A timestamp that indicates the last time the processing job was modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The time at which the processing job completed.</p>
    #[serde(rename = "ProcessingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the processing job..</p>
    #[serde(rename = "ProcessingJobArn")]
    pub processing_job_arn: String,
    /// <p>The name of the processing job.</p>
    #[serde(rename = "ProcessingJobName")]
    pub processing_job_name: String,
    /// <p>The status of the processing job.</p>
    #[serde(rename = "ProcessingJobStatus")]
    pub processing_job_status: String,
}

/// <p>Describes the results of a processing job. The processing output must specify exactly one of either <code>S3Output</code> or <code>FeatureStoreOutput</code> types.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingOutput {
    /// <p>When <code>True</code>, output operations such as data upload are managed natively by the processing job application. When <code>False</code> (default), output operations are managed by Amazon SageMaker.</p>
    #[serde(rename = "AppManaged")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_managed: Option<bool>,
    /// <p>Configuration for processing job outputs in Amazon SageMaker Feature Store. This processing output type is only supported when <code>AppManaged</code> is specified. </p>
    #[serde(rename = "FeatureStoreOutput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_store_output: Option<ProcessingFeatureStoreOutput>,
    /// <p>The name for the processing job output.</p>
    #[serde(rename = "OutputName")]
    pub output_name: String,
    /// <p>Configuration for processing job outputs in Amazon S3.</p>
    #[serde(rename = "S3Output")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_output: Option<ProcessingS3Output>,
}

/// <p>Configuration for uploading output from the processing container.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingOutputConfig {
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>An array of outputs configuring the data to upload from the processing container.</p>
    #[serde(rename = "Outputs")]
    pub outputs: Vec<ProcessingOutput>,
}

/// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingResources {
    /// <p>The configuration for the resources in a cluster used to run the processing job.</p>
    #[serde(rename = "ClusterConfig")]
    pub cluster_config: ProcessingClusterConfig,
}

/// <p>Configuration for downloading input data from Amazon S3 into the processing container.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingS3Input {
    /// <p>The local path in your container where you want Amazon SageMaker to write input data to. <code>LocalPath</code> is an absolute path to the input data and must begin with <code>/opt/ml/processing/</code>. <code>LocalPath</code> is a required parameter when <code>AppManaged</code> is <code>False</code> (default).</p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    /// <p>Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container. <code>Gzip</code> can only be used when <code>Pipe</code> mode is specified as the <code>S3InputMode</code>. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.</p>
    #[serde(rename = "S3CompressionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_compression_type: Option<String>,
    /// <p>Whether to distribute the data from Amazon S3 to all processing instances with <code>FullyReplicated</code>, or whether the data from Amazon S3 is shared by Amazon S3 key, downloading one shard of data to each processing instance.</p>
    #[serde(rename = "S3DataDistributionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_data_distribution_type: Option<String>,
    /// <p>Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.</p>
    #[serde(rename = "S3DataType")]
    pub s3_data_type: String,
    /// <p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.</p>
    #[serde(rename = "S3InputMode")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_input_mode: Option<String>,
    /// <p>The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job.</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>Configuration for uploading output data to Amazon S3 from the processing container.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingS3Output {
    /// <p>The local path of a directory where you want Amazon SageMaker to upload its contents to Amazon S3. <code>LocalPath</code> is an absolute path to a directory containing output files. This directory will be created by the platform and exist when your container's entrypoint is invoked.</p>
    #[serde(rename = "LocalPath")]
    pub local_path: String,
    /// <p>Whether to upload the results of the processing job continuously or after the job completes.</p>
    #[serde(rename = "S3UploadMode")]
    pub s3_upload_mode: String,
    /// <p>A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a processing job.</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. After the condition is met, the processing job is stopped.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProcessingStoppingCondition {
    /// <p>Specifies the maximum runtime in seconds.</p>
    #[serde(rename = "MaxRuntimeInSeconds")]
    pub max_runtime_in_seconds: i64,
}

/// <p>Identifies a model that you want to host and the resources chosen to deploy for hosting it. If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying variant weights. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProductionVariant {
    /// <p>The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
    #[serde(rename = "AcceleratorType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accelerator_type: Option<String>,
    /// <p>Specifies configuration for a core dump from the model container when the process crashes.</p>
    #[serde(rename = "CoreDumpConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub core_dump_config: Option<ProductionVariantCoreDumpConfig>,
    /// <p>Number of instances to launch initially.</p>
    #[serde(rename = "InitialInstanceCount")]
    pub initial_instance_count: i64,
    /// <p>Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0. </p>
    #[serde(rename = "InitialVariantWeight")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub initial_variant_weight: Option<f32>,
    /// <p>The ML compute instance type.</p>
    #[serde(rename = "InstanceType")]
    pub instance_type: String,
    /// <p>The name of the model that you want to host. This is the name that you specified when creating the model.</p>
    #[serde(rename = "ModelName")]
    pub model_name: String,
    /// <p>The name of the production variant.</p>
    #[serde(rename = "VariantName")]
    pub variant_name: String,
}

/// <p>Specifies configuration for a core dump from the model container when the process crashes.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProductionVariantCoreDumpConfig {
    /// <p>The Amazon S3 bucket to send the core dump to.</p>
    #[serde(rename = "DestinationS3Uri")]
    pub destination_s3_uri: String,
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your master key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. Amazon SageMaker uses server-side encryption with KMS-managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> and <code>UpdateEndpoint</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
}

/// <p>Describes weight and capacities for a production variant associated with an endpoint. If you sent a request to the <code>UpdateEndpointWeightsAndCapacities</code> API and the endpoint status is <code>Updating</code>, you get different desired and current values. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProductionVariantSummary {
    /// <p>The number of instances associated with the variant.</p>
    #[serde(rename = "CurrentInstanceCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub current_instance_count: Option<i64>,
    /// <p>The weight associated with the variant.</p>
    #[serde(rename = "CurrentWeight")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub current_weight: Option<f32>,
    /// <p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this <code>ProductionVariant</code>.</p>
    #[serde(rename = "DeployedImages")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub deployed_images: Option<Vec<DeployedImage>>,
    /// <p>The number of instances requested in the <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
    #[serde(rename = "DesiredInstanceCount")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub desired_instance_count: Option<i64>,
    /// <p>The requested weight, as specified in the <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
    #[serde(rename = "DesiredWeight")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub desired_weight: Option<f32>,
    /// <p>The name of the variant.</p>
    #[serde(rename = "VariantName")]
    pub variant_name: String,
}

/// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProfilerConfig {
    /// <p>A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>
    #[serde(rename = "ProfilingIntervalInMilliseconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiling_interval_in_milliseconds: Option<i64>,
    /// <p>Configuration information for capturing framework metrics. Available key strings for different profiling options are <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>. The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about how to configure the <code>ProfilingParameters</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>
    #[serde(rename = "ProfilingParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiling_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>Path to Amazon S3 storage location for system and framework metrics.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>Configuration information for updating the Debugger profile parameters, system and framework metrics configurations, and storage paths.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ProfilerConfigForUpdate {
    /// <p>To disable Debugger monitoring and profiling, set to <code>True</code>.</p>
    #[serde(rename = "DisableProfiler")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disable_profiler: Option<bool>,
    /// <p>A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>
    #[serde(rename = "ProfilingIntervalInMilliseconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiling_interval_in_milliseconds: Option<i64>,
    /// <p>Configuration information for capturing framework metrics. Available key strings for different profiling options are <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>. The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about how to configure the <code>ProfilingParameters</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>
    #[serde(rename = "ProfilingParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiling_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>Path to Amazon S3 storage location for system and framework metrics.</p>
    #[serde(rename = "S3OutputPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_output_path: Option<String>,
}

/// <p>Configuration information for profiling rules.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProfilerRuleConfiguration {
    /// <p>The instance type to deploy a Debugger custom rule for profiling a training job.</p>
    #[serde(rename = "InstanceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    /// <p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    /// <p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>
    #[serde(rename = "RuleConfigurationName")]
    pub rule_configuration_name: String,
    /// <p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>
    #[serde(rename = "RuleEvaluatorImage")]
    pub rule_evaluator_image: String,
    /// <p>Runtime configuration for rule container.</p>
    #[serde(rename = "RuleParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>Path to Amazon S3 storage location for rules.</p>
    #[serde(rename = "S3OutputPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_output_path: Option<String>,
    /// <p>The size, in GB, of the ML storage volume attached to the processing instance.</p>
    #[serde(rename = "VolumeSizeInGB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_size_in_gb: Option<i64>,
}

/// <p>Information about the status of the rule evaluation.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProfilerRuleEvaluationStatus {
    /// <p>Timestamp when the rule evaluation status was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The name of the rule configuration.</p>
    #[serde(rename = "RuleConfigurationName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_configuration_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>
    #[serde(rename = "RuleEvaluationJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_evaluation_job_arn: Option<String>,
    /// <p>Status of the rule evaluation.</p>
    #[serde(rename = "RuleEvaluationStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub rule_evaluation_status: Option<String>,
    /// <p>Details from the rule evaluation.</p>
    #[serde(rename = "StatusDetails")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_details: Option<String>,
}

/// <p>Information about a project.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ProjectSummary {
    /// <p>The time that the project was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    #[serde(rename = "ProjectArn")]
    pub project_arn: String,
    /// <p>The description of the project.</p>
    #[serde(rename = "ProjectDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub project_description: Option<String>,
    /// <p>The ID of the project.</p>
    #[serde(rename = "ProjectId")]
    pub project_id: String,
    /// <p>The name of the project.</p>
    #[serde(rename = "ProjectName")]
    pub project_name: String,
    /// <p>The status of the project.</p>
    #[serde(rename = "ProjectStatus")]
    pub project_status: String,
}

/// <p>Part of the <code>SuggestionQuery</code> type. Specifies a hint for retrieving property names that begin with the specified text.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PropertyNameQuery {
    /// <p>Text that begins a property's name.</p>
    #[serde(rename = "PropertyNameHint")]
    pub property_name_hint: String,
}

/// <p>A property name returned from a <code>GetSearchSuggestions</code> call that specifies a value in the <code>PropertyNameQuery</code> field.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PropertyNameSuggestion {
    /// <p>A suggested property name based on what you entered in the search textbox in the Amazon SageMaker console.</p>
    #[serde(rename = "PropertyName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub property_name: Option<String>,
}

/// <p>A key value pair used when you provision a project as a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ProvisioningParameter {
    /// <p>The key that identifies a provisioning parameter.</p>
    #[serde(rename = "Key")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// <p>The value of the provisioning parameter.</p>
    #[serde(rename = "Value")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
}

/// <p><p>Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. </p> <p>Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the complexity of the task; the longer it takes in your initial testing, the more you should offer.</p> <ul> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US dollars.</p> <ul> <li> <p>0.012</p> </li> <li> <p>0.024</p> </li> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.</p> <ul> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>2.400 </p> </li> <li> <p>2.280 </p> </li> <li> <p>2.160 </p> </li> <li> <p>2.040 </p> </li> <li> <p>1.920 </p> </li> <li> <p>1.800 </p> </li> <li> <p>1.680 </p> </li> <li> <p>1.560 </p> </li> <li> <p>1.440 </p> </li> <li> <p>1.320 </p> </li> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct PublicWorkforceTaskPrice {
    /// <p>Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.</p>
    #[serde(rename = "AmountInUsd")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub amount_in_usd: Option<USD>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PutModelPackageGroupPolicyInput {
    /// <p>The name of the model group to add a resource policy to.</p>
    #[serde(rename = "ModelPackageGroupName")]
    pub model_package_group_name: String,
    /// <p>The resource policy for the model group.</p>
    #[serde(rename = "ResourcePolicy")]
    pub resource_policy: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct PutModelPackageGroupPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the model package group.</p>
    #[serde(rename = "ModelPackageGroupArn")]
    pub model_package_group_arn: String,
}

/// <p>Configuration for Redshift Dataset Definition input.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RedshiftDatasetDefinition {
    #[serde(rename = "ClusterId")]
    pub cluster_id: String,
    /// <p>The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.</p>
    #[serde(rename = "ClusterRoleArn")]
    pub cluster_role_arn: String,
    #[serde(rename = "Database")]
    pub database: String,
    #[serde(rename = "DbUser")]
    pub db_user: String,
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data from a Redshift execution.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    #[serde(rename = "OutputCompression")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_compression: Option<String>,
    #[serde(rename = "OutputFormat")]
    pub output_format: String,
    /// <p>The location in Amazon S3 where the Redshift query results are stored.</p>
    #[serde(rename = "OutputS3Uri")]
    pub output_s3_uri: String,
    #[serde(rename = "QueryString")]
    pub query_string: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RegisterDevicesRequest {
    /// <p>The name of the fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>A list of devices to register with SageMaker Edge Manager.</p>
    #[serde(rename = "Devices")]
    pub devices: Vec<Device>,
    /// <p>The tags associated with devices.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
}

/// <p>Metadata for a register model job step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RegisterModelStepMetadata {
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    #[serde(rename = "Arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RenderUiTemplateRequest {
    /// <p>The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.</p> <p>See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.</p>
    #[serde(rename = "HumanTaskUiArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_task_ui_arn: Option<String>,
    /// <p>The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.</p>
    #[serde(rename = "RoleArn")]
    pub role_arn: String,
    /// <p>A <code>RenderableTask</code> object containing a representative task to render.</p>
    #[serde(rename = "Task")]
    pub task: RenderableTask,
    /// <p>A <code>Template</code> object containing the worker UI template to render.</p>
    #[serde(rename = "UiTemplate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ui_template: Option<UiTemplate>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RenderUiTemplateResponse {
    /// <p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>
    #[serde(rename = "Errors")]
    pub errors: Vec<RenderingError>,
    /// <p>A Liquid template that renders the HTML for the worker UI.</p>
    #[serde(rename = "RenderedContent")]
    pub rendered_content: String,
}

/// <p>Contains input values for a task.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RenderableTask {
    /// <p>A JSON object that contains values for the variables defined in the template. It is made available to the template under the substitution variable <code>task.input</code>. For example, if you define a variable <code>task.input.text</code> in your template, you can supply the variable in the JSON object as <code>"text": "sample text"</code>.</p>
    #[serde(rename = "Input")]
    pub input: String,
}

/// <p>A description of an error that occurred while rendering the template.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct RenderingError {
    /// <p>A unique identifier for a specific class of errors.</p>
    #[serde(rename = "Code")]
    pub code: String,
    /// <p>A human-readable message describing the error.</p>
    #[serde(rename = "Message")]
    pub message: String,
}

/// <p>Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code> field of the <code>ImageConfig</code> object that you passed to a call to <a>CreateModel</a> and the private Docker registry where the model image is hosted requires authentication.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RepositoryAuthConfig {
    /// <p>The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a Lambda function with the console</a> in the <i>AWS Lambda Developer Guide</i>.</p>
    #[serde(rename = "RepositoryCredentialsProviderArn")]
    pub repository_credentials_provider_arn: String,
}

/// <p>The resolved attributes.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ResolvedAttributes {
    #[serde(rename = "AutoMLJobObjective")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_objective: Option<AutoMLJobObjective>,
    #[serde(rename = "CompletionCriteria")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completion_criteria: Option<AutoMLJobCompletionCriteria>,
    /// <p>The problem type.</p>
    #[serde(rename = "ProblemType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub problem_type: Option<String>,
}

/// <p>Describes the resources, including ML compute instances and ML storage volumes, to use for model training. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ResourceConfig {
    /// <p>The number of ML compute instances to use. For distributed training, provide a value greater than 1. </p>
    #[serde(rename = "InstanceCount")]
    pub instance_count: i64,
    /// <p>The ML compute instance type. </p>
    #[serde(rename = "InstanceType")]
    pub instance_type: String,
    /// <p><p>The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can&#39;t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p>The <code>VolumeKmsKeyId</code> can be in any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>&quot;1234abcd-12ab-34cd-56ef-1234567890ab&quot;</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>&quot;arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab&quot;</code> </p> </li> </ul></p>
    #[serde(rename = "VolumeKmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_kms_key_id: Option<String>,
    /// <p><p>The size of the ML storage volume that you want to provision. </p> <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML storage volume for scratch space. If you want to store the training data in the ML storage volume, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. </p> <p>You must specify sufficient ML storage for your scenario. </p> <note> <p> Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type. </p> </note> <note> <p>Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for training, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can&#39;t request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.</p> <p>For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> </note></p>
    #[serde(rename = "VolumeSizeInGB")]
    pub volume_size_in_gb: i64,
}

/// <p>Specifies the maximum number of training jobs and parallel training jobs that a hyperparameter tuning job can launch.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ResourceLimits {
    /// <p>The maximum number of training jobs that a hyperparameter tuning job can launch.</p>
    #[serde(rename = "MaxNumberOfTrainingJobs")]
    pub max_number_of_training_jobs: i64,
    /// <p>The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.</p>
    #[serde(rename = "MaxParallelTrainingJobs")]
    pub max_parallel_training_jobs: i64,
}

/// <p>Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ResourceSpec {
    /// <p>The instance type that the image version runs on.</p>
    #[serde(rename = "InstanceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    /// <p>The ARN of the SageMaker image that the image version belongs to.</p>
    #[serde(rename = "SageMakerImageArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sage_maker_image_arn: Option<String>,
    /// <p>The ARN of the image version created on the instance.</p>
    #[serde(rename = "SageMakerImageVersionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sage_maker_image_version_arn: Option<String>,
}

/// <p>The retention policy for data stored on an Amazon Elastic File System (EFS) volume.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RetentionPolicy {
    /// <p>The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p> <p>Specify <code>Delete</code> to delete the data stored on the EFS volume.</p>
    #[serde(rename = "HomeEfsFileSystem")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub home_efs_file_system: Option<String>,
}

/// <p>The retry strategy to use when a training job fails due to an <code>InternalServerError</code>. <code>RetryStrategy</code> is specified as part of the <code>CreateTrainingJob</code> and <code>CreateHyperParameterTuningJob</code> requests. You can add the <code>StoppingCondition</code> parameter to the request to limit the training time for the complete job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct RetryStrategy {
    /// <p>The number of times to retry the job. When the job is retried, it's <code>SecondaryStatus</code> is changed to <code>STARTING</code>.</p>
    #[serde(rename = "MaximumRetryAttempts")]
    pub maximum_retry_attempts: i64,
}

/// <p>Describes the S3 data source.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3DataSource {
    /// <p>A list of one or more attribute names to use that are found in a specified augmented manifest file.</p>
    #[serde(rename = "AttributeNames")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub attribute_names: Option<Vec<String>>,
    /// <p>If you want Amazon SageMaker to replicate the entire dataset on each ML compute instance that is launched for model training, specify <code>FullyReplicated</code>. </p> <p>If you want Amazon SageMaker to replicate a subset of data on each ML compute instance that is launched for model training, specify <code>ShardedByS3Key</code>. If there are <i>n</i> ML compute instances launched for a training job, each instance gets approximately 1/<i>n</i> of the number of S3 objects. In this case, model training on each machine uses only the subset of training data. </p> <p>Don't choose more ML compute instances for training than available S3 objects. If you do, some nodes won't get any data and you will pay for nodes that aren't getting any training data. This applies in both File and Pipe modes. Keep this in mind when developing algorithms. </p> <p>In distributed training, where you use multiple ML compute EC2 instances, you might choose <code>ShardedByS3Key</code>. If the algorithm requires copying training data to the ML storage volume (when <code>TrainingInputMode</code> is set to <code>File</code>), this copies 1/<i>n</i> of the number of objects. </p>
    #[serde(rename = "S3DataDistributionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_data_distribution_type: Option<String>,
    /// <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects that match the specified key name prefix for model training. </p> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for model training. </p> <p>If you choose <code>AugmentedManifestFile</code>, S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. <code>AugmentedManifestFile</code> can only be used if the Channel's input mode is <code>Pipe</code>.</p>
    #[serde(rename = "S3DataType")]
    pub s3_data_type: String,
    /// <p><p>Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a manifest. For example: </p> <ul> <li> <p> A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code> </p> </li> <li> <p> A manifest might look like this: <code>s3://bucketname/example.manifest</code> </p> <p> A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of <code>S3Uri</code>. Note that the prefix must be a valid non-empty <code>S3Uri</code> that precludes users from specifying a manifest whose individual <code>S3Uri</code> is sourced from different S3 buckets.</p> <p> The following code example shows a valid manifest format: </p> <p> <code>[ {&quot;prefix&quot;: &quot;s3://customer<em>bucket/some/prefix/&quot;},</code> </p> <p> <code> &quot;relative/path/to/custdata-1&quot;,</code> </p> <p> <code> &quot;relative/path/custdata-2&quot;,</code> </p> <p> <code> ...</code> </p> <p> <code> &quot;relative/path/custdata-N&quot;</code> </p> <p> <code>]</code> </p> <p> This JSON is equivalent to the following <code>S3Uri</code> list:</p> <p> <code>s3://customer</em>bucket/some/prefix/relative/path/to/custdata-1</code> </p> <p> <code>s3://customer<em>bucket/some/prefix/relative/path/custdata-2</code> </p> <p> <code>...</code> </p> <p> <code>s3://customer</em>bucket/some/prefix/relative/path/custdata-N</code> </p> <p>The complete set of <code>S3Uri</code> in this manifest is the input data for the channel for this data source. The object that each <code>S3Uri</code> points to must be readable by the IAM role that Amazon SageMaker uses to perform tasks on your behalf. </p> </li> </ul></p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>The Amazon Simple Storage (Amazon S3) location and and security configuration for <code>OfflineStore</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct S3StorageConfig {
    /// <p><p>The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the <code>OfflineStore</code> S3 location.</p> <p>The IAM <code>roleARN</code> that is passed as a parameter to <code>CreateFeatureGroup</code> must have below permissions to the <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>&quot;kms:GenerateDataKey&quot;</code> </p> </li> </ul></p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The S3 path where offline records are written.</p>
    #[serde(rename = "ResolvedOutputS3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resolved_output_s3_uri: Option<String>,
    /// <p>The S3 URI, or location in Amazon S3, of <code>OfflineStore</code>.</p> <p>S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code>.</p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>Configuration details about the monitoring schedule.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ScheduleConfig {
    /// <p><p>A cron expression that describes details about the monitoring schedule.</p> <p>Currently the only supported cron expressions are:</p> <ul> <li> <p>If you want to set the job to start every hour, please use the following:</p> <p> <code>Hourly: cron(0 * ? * * *)</code> </p> </li> <li> <p>If you want to start the job daily:</p> <p> <code>cron(0 [00-23] ? * * *)</code> </p> </li> </ul> <p>For example, the following are valid cron expressions:</p> <ul> <li> <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code> </p> </li> <li> <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code> </p> </li> </ul> <p>To support running every 6, 12 hours, the following are also supported:</p> <p> <code>cron(0 [00-23]/[01-24] ? * * *)</code> </p> <p>For example, the following are valid cron expressions:</p> <ul> <li> <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code> </p> </li> <li> <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code> </p> </li> </ul> <note> <ul> <li> <p>Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from the actual requested time to run the execution. </p> </li> <li> <p>We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker will pick a time for running every day.</p> </li> </ul> </note></p>
    #[serde(rename = "ScheduleExpression")]
    pub schedule_expression: String,
}

/// <p><p>A multi-expression that searches for the specified resource or resources in a search. All resource objects that satisfy the expression&#39;s condition are included in the search results. You must specify at least one subexpression, filter, or nested filter. A <code>SearchExpression</code> can contain up to twenty elements.</p> <p>A <code>SearchExpression</code> contains the following components:</p> <ul> <li> <p>A list of <code>Filter</code> objects. Each filter defines a simple Boolean expression comprised of a resource property name, Boolean operator, and value.</p> </li> <li> <p>A list of <code>NestedFilter</code> objects. Each nested filter defines a list of Boolean expressions using a list of resource properties. A nested filter is satisfied if a single object in the list satisfies all Boolean expressions.</p> </li> <li> <p>A list of <code>SearchExpression</code> objects. A search expression object can be nested in a list of search expression objects.</p> </li> <li> <p>A Boolean operator: <code>And</code> or <code>Or</code>.</p> </li> </ul></p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SearchExpression {
    /// <p>A list of filter objects.</p>
    #[serde(rename = "Filters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub filters: Option<Vec<Filter>>,
    /// <p>A list of nested filter objects.</p>
    #[serde(rename = "NestedFilters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub nested_filters: Option<Vec<NestedFilters>>,
    /// <p>A Boolean operator used to evaluate the search expression. If you want every conditional statement in all lists to be satisfied for the entire search expression to be true, specify <code>And</code>. If only a single conditional statement needs to be true for the entire search expression to be true, specify <code>Or</code>. The default value is <code>And</code>.</p>
    #[serde(rename = "Operator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub operator: Option<String>,
    /// <p>A list of search expression objects.</p>
    #[serde(rename = "SubExpressions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sub_expressions: Option<Vec<SearchExpression>>,
}

/// <p>A single resource returned as part of the <a>Search</a> API response.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SearchRecord {
    #[serde(rename = "Endpoint")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<Endpoint>,
    /// <p>The properties of an experiment.</p>
    #[serde(rename = "Experiment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment: Option<Experiment>,
    #[serde(rename = "FeatureGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub feature_group: Option<FeatureGroup>,
    #[serde(rename = "ModelPackage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package: Option<ModelPackage>,
    #[serde(rename = "ModelPackageGroup")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_package_group: Option<ModelPackageGroup>,
    #[serde(rename = "Pipeline")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline: Option<Pipeline>,
    #[serde(rename = "PipelineExecution")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution: Option<PipelineExecution>,
    /// <p>The properties of a training job.</p>
    #[serde(rename = "TrainingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job: Option<TrainingJob>,
    /// <p>The properties of a trial.</p>
    #[serde(rename = "Trial")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial: Option<Trial>,
    /// <p>The properties of a trial component.</p>
    #[serde(rename = "TrialComponent")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component: Option<TrialComponent>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SearchRequest {
    /// <p>The maximum number of results to return.</p>
    #[serde(rename = "MaxResults")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_results: Option<i64>,
    /// <p>If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next <code>SearchRequest</code> to continue retrieving results.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>The name of the Amazon SageMaker resource to search for.</p>
    #[serde(rename = "Resource")]
    pub resource: String,
    /// <p>A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a <code>SearchExpression</code> object is 50.</p>
    #[serde(rename = "SearchExpression")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub search_expression: Option<SearchExpression>,
    /// <p>The name of the resource property used to sort the <code>SearchResults</code>. The default is <code>LastModifiedTime</code>.</p>
    #[serde(rename = "SortBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_by: Option<String>,
    /// <p>How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>. The default is <code>Descending</code>.</p>
    #[serde(rename = "SortOrder")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub sort_order: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SearchResponse {
    /// <p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>
    #[serde(rename = "NextToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub next_token: Option<String>,
    /// <p>A list of <code>SearchRecord</code> objects.</p>
    #[serde(rename = "Results")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub results: Option<Vec<SearchRecord>>,
}

/// <p><p>An array element of <a>DescribeTrainingJobResponse$SecondaryStatusTransitions</a>. It provides additional details about a status that the training job has transitioned through. A training job can be in one of several states, for example, starting, downloading, training, or uploading. Within each state, there are a number of intermediate states. For example, within the starting state, Amazon SageMaker could be starting the training job or launching the ML instances. These transitional states are referred to as the job&#39;s secondary status. </p> <p/></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SecondaryStatusTransition {
    /// <p>A timestamp that shows when the training job transitioned out of this secondary status state into another secondary status state or when the training job has ended.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>A timestamp that shows when the training job transitioned to the current secondary status state.</p>
    #[serde(rename = "StartTime")]
    pub start_time: f64,
    /// <p><p>Contains a secondary status information from a training job.</p> <p>Status might be one of the following secondary statuses:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul></p>
    #[serde(rename = "Status")]
    pub status: String,
    /// <p><p>A detailed description of the progress within a secondary status. </p> <p>Amazon SageMaker provides secondary statuses and status messages that apply to each of them:</p> <dl> <dt>Starting</dt> <dd> <ul> <li> <p>Starting the training job.</p> </li> <li> <p>Launching requested ML instances.</p> </li> <li> <p>Insufficient capacity error from EC2 while launching instances, retrying!</p> </li> <li> <p>Launched instance was unhealthy, replacing it!</p> </li> <li> <p>Preparing the instances for training.</p> </li> </ul> </dd> <dt>Training</dt> <dd> <ul> <li> <p>Downloading the training image.</p> </li> <li> <p>Training image download completed. Training in progress.</p> </li> </ul> </dd> </dl> <important> <p>Status messages are subject to change. Therefore, we recommend not including them in code that programmatically initiates actions. For examples, don&#39;t use status messages in if statements.</p> </important> <p>To have an overview of your training job&#39;s progress, view <code>TrainingJobStatus</code> and <code>SecondaryStatus</code> in <a>DescribeTrainingJob</a>, and <code>StatusMessage</code> together. For example, at the start of a training job, you might see the following:</p> <ul> <li> <p> <code>TrainingJobStatus</code> - InProgress</p> </li> <li> <p> <code>SecondaryStatus</code> - Training</p> </li> <li> <p> <code>StatusMessage</code> - Downloading the training image</p> </li> </ul></p>
    #[serde(rename = "StatusMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status_message: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SendPipelineExecutionStepFailureRequest {
    /// <p>The pipeline generated token from the Amazon SQS queue.</p>
    #[serde(rename = "CallbackToken")]
    pub callback_token: String,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
    #[serde(rename = "ClientRequestToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_request_token: Option<String>,
    /// <p>A message describing why the step failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SendPipelineExecutionStepFailureResponse {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SendPipelineExecutionStepSuccessRequest {
    /// <p>The pipeline generated token from the Amazon SQS queue.</p>
    #[serde(rename = "CallbackToken")]
    pub callback_token: String,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
    #[serde(rename = "ClientRequestToken")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub client_request_token: Option<String>,
    /// <p>A list of the output parameters of the callback step.</p>
    #[serde(rename = "OutputParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_parameters: Option<Vec<OutputParameter>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SendPipelineExecutionStepSuccessResponse {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
}

/// <p>Details of a provisioned service catalog product. For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct ServiceCatalogProvisionedProductDetails {
    /// <p>The ID of the provisioned product.</p>
    #[serde(rename = "ProvisionedProductId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub provisioned_product_id: Option<String>,
    /// <p><p>The current status of the product.</p> <ul> <li> <p> <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p> </li> <li> <p> <code>UNDER<em>CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p> </li> <li> <p> <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p> </li> <li> <p> <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p> </li> <li> <p> <code>PLAN</em>IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p> </li> </ul></p>
    #[serde(rename = "ProvisionedProductStatusMessage")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub provisioned_product_status_message: Option<String>,
}

/// <p>Details that you specify to provision a service catalog product. For information about service catalog, see .<a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service Catalog</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ServiceCatalogProvisioningDetails {
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. </p>
    #[serde(rename = "PathId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub path_id: Option<String>,
    /// <p>The ID of the product to provision.</p>
    #[serde(rename = "ProductId")]
    pub product_id: String,
    /// <p>The ID of the provisioning artifact.</p>
    #[serde(rename = "ProvisioningArtifactId")]
    pub provisioning_artifact_id: String,
    /// <p>A list of key value pairs that you specify when you provision a product.</p>
    #[serde(rename = "ProvisioningParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub provisioning_parameters: Option<Vec<ProvisioningParameter>>,
}

/// <p>Specifies options for sharing SageMaker Studio notebooks. These settings are specified as part of <code>DefaultUserSettings</code> when the <code>CreateDomain</code> API is called, and as part of <code>UserSettings</code> when the <code>CreateUserProfile</code> API is called. When <code>SharingSettings</code> is not specified, notebook sharing isn't allowed.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SharingSettings {
    /// <p>Whether to include the notebook cell output when sharing the notebook. The default is <code>Disabled</code>.</p>
    #[serde(rename = "NotebookOutputOption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notebook_output_option: Option<String>,
    /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>
    #[serde(rename = "S3KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_kms_key_id: Option<String>,
    /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used to store the shared notebook snapshots.</p>
    #[serde(rename = "S3OutputPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub s3_output_path: Option<String>,
}

/// <p>A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for <code>S3DataType</code>, the results of the S3 key prefix matches are shuffled. If you use <code>ManifestFile</code>, the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is shuffled. The shuffling order is determined using the <code>Seed</code> value.</p> <p>For Pipe input mode, when <code>ShuffleConfig</code> is specified shuffling is done at the start of every epoch. With large datasets, this ensures that the order of the training data is different for each epoch, and it helps reduce bias and possible overfitting. In a multi-node training job when <code>ShuffleConfig</code> is combined with <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct ShuffleConfig {
    /// <p>Determines the shuffling order in <code>ShuffleConfig</code> value.</p>
    #[serde(rename = "Seed")]
    pub seed: i64,
}

/// <p>Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SourceAlgorithm {
    /// <p>The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.</p>
    #[serde(rename = "AlgorithmName")]
    pub algorithm_name: String,
    /// <p><p>The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p> <note> <p>The model artifacts must be in an S3 bucket that is in the same region as the algorithm.</p> </note></p>
    #[serde(rename = "ModelDataUrl")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_data_url: Option<String>,
}

/// <p>A list of algorithms that were used to create a model package.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SourceAlgorithmSpecification {
    /// <p>A list of the algorithms that were used to create a model package.</p>
    #[serde(rename = "SourceAlgorithms")]
    pub source_algorithms: Vec<SourceAlgorithm>,
}

/// <p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct SourceIpConfig {
    /// <p><p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p> <p>Maximum: Ten CIDR values</p> <note> <p>The following Length Constraints apply to individual CIDR values in the CIDR value list.</p> </note></p>
    #[serde(rename = "Cidrs")]
    pub cidrs: Vec<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartMonitoringScheduleRequest {
    /// <p>The name of the schedule to start.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartNotebookInstanceInput {
    /// <p>The name of the notebook instance to start.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StartPipelineExecutionRequest {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The description of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_description: Option<String>,
    /// <p>The display name of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_display_name: Option<String>,
    /// <p>The name of the pipeline.</p>
    #[serde(rename = "PipelineName")]
    pub pipeline_name: String,
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    #[serde(rename = "PipelineParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_parameters: Option<Vec<Parameter>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StartPipelineExecutionResponse {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopAutoMLJobRequest {
    /// <p>The name of the object you are requesting.</p>
    #[serde(rename = "AutoMLJobName")]
    pub auto_ml_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopCompilationJobRequest {
    /// <p>The name of the model compilation job to stop.</p>
    #[serde(rename = "CompilationJobName")]
    pub compilation_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopEdgePackagingJobRequest {
    /// <p>The name of the edge packaging job.</p>
    #[serde(rename = "EdgePackagingJobName")]
    pub edge_packaging_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopHyperParameterTuningJobRequest {
    /// <p>The name of the tuning job to stop.</p>
    #[serde(rename = "HyperParameterTuningJobName")]
    pub hyper_parameter_tuning_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopLabelingJobRequest {
    /// <p>The name of the labeling job to stop.</p>
    #[serde(rename = "LabelingJobName")]
    pub labeling_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopMonitoringScheduleRequest {
    /// <p>The name of the schedule to stop.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopNotebookInstanceInput {
    /// <p>The name of the notebook instance to terminate.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopPipelineExecutionRequest {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
    #[serde(rename = "ClientRequestToken")]
    pub client_request_token: String,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    pub pipeline_execution_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct StopPipelineExecutionResponse {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopProcessingJobRequest {
    /// <p>The name of the processing job to stop.</p>
    #[serde(rename = "ProcessingJobName")]
    pub processing_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopTrainingJobRequest {
    /// <p>The name of the training job to stop.</p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct StopTransformJobRequest {
    /// <p>The name of the transform job to stop.</p>
    #[serde(rename = "TransformJobName")]
    pub transform_job_name: String,
}

/// <p><p>Specifies a limit to how long a model training job, model compilation job, or hyperparameter tuning job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training or compilation job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p> <p>The training algorithms provided by Amazon SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with <code>CreateModel</code>.</p> <note> <p>The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.</p> </note></p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct StoppingCondition {
    /// <p>The maximum length of time, in seconds, that a training or compilation job can run. If the job does not complete during this time, Amazon SageMaker ends the job.</p> <p>When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt.</p> <p>The default value is 1 day. The maximum value is 28 days.</p>
    #[serde(rename = "MaxRuntimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_runtime_in_seconds: Option<i64>,
    /// <p>The maximum length of time, in seconds, that a managed Spot training job has to complete. It is the amount of time spent waiting for Spot capacity plus the amount of time the job can run. It must be equal to or greater than <code>MaxRuntimeInSeconds</code>. If the job does not complete during this time, Amazon SageMaker ends the job.</p> <p>When <code>RetryStrategy</code> is specified in the job request, <code>MaxWaitTimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt.</p>
    #[serde(rename = "MaxWaitTimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_wait_time_in_seconds: Option<i64>,
}

/// <p>Describes a work team of a vendor that does the a labelling job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct SubscribedWorkteam {
    /// <p>Marketplace product listing ID.</p>
    #[serde(rename = "ListingId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub listing_id: Option<String>,
    /// <p>The description of the vendor from the Amazon Marketplace.</p>
    #[serde(rename = "MarketplaceDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marketplace_description: Option<String>,
    /// <p>The title of the service provided by the vendor in the Amazon Marketplace.</p>
    #[serde(rename = "MarketplaceTitle")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub marketplace_title: Option<String>,
    /// <p>The name of the vendor in the Amazon Marketplace.</p>
    #[serde(rename = "SellerName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub seller_name: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the vendor that you have subscribed.</p>
    #[serde(rename = "WorkteamArn")]
    pub workteam_arn: String,
}

/// <p>Specified in the <a>GetSearchSuggestions</a> request. Limits the property names that are included in the response.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SuggestionQuery {
    /// <p>Defines a property name hint. Only property names that begin with the specified hint are included in the response.</p>
    #[serde(rename = "PropertyNameQuery")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub property_name_query: Option<PropertyNameQuery>,
}

/// <p>A tag object that consists of a key and an optional value, used to manage metadata for Amazon SageMaker AWS resources.</p> <p>You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to Amazon SageMaker resources, see <a>AddTags</a>.</p> <p>For more information on adding metadata to your AWS resources with tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a>. For advice on best practices for managing AWS resources with tagging, see <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct Tag {
    /// <p>The tag key. Tag keys must be unique per resource.</p>
    #[serde(rename = "Key")]
    pub key: String,
    /// <p>The tag value.</p>
    #[serde(rename = "Value")]
    pub value: String,
}

/// <p>Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of <code>TargetDevice</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TargetPlatform {
    /// <p><p>Specifies a target platform accelerator (optional).</p> <ul> <li> <p> <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>, <code>trt-ver</code>, <code>cuda-ver</code> compiler options</p> </li> <li> <p> <code>MALI</code>: ARM Mali graphics processor</p> </li> <li> <p> <code>INTEL_GRAPHICS</code>: Integrated Intel graphics</p> </li> </ul></p>
    #[serde(rename = "Accelerator")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accelerator: Option<String>,
    /// <p><p>Specifies a target platform architecture.</p> <ul> <li> <p> <code>X86<em>64</code>: 64-bit version of the x86 instruction set.</p> </li> <li> <p> <code>X86</code>: 32-bit version of the x86 instruction set.</p> </li> <li> <p> <code>ARM64</code>: ARMv8 64-bit CPU.</p> </li> <li> <p> <code>ARM</em>EABIHF</code>: ARMv7 32-bit, Hard Float.</p> </li> <li> <p> <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.</p> </li> </ul></p>
    #[serde(rename = "Arch")]
    pub arch: String,
    /// <p><p>Specifies a target platform OS.</p> <ul> <li> <p> <code>LINUX</code>: Linux-based operating systems.</p> </li> <li> <p> <code>ANDROID</code>: Android operating systems. Android API level can be specified using the <code>ANDROID<em>PLATFORM</code> compiler option. For example, <code>&quot;CompilerOptions&quot;: {&#39;ANDROID</em>PLATFORM&#39;: 28}</code> </p> </li> </ul></p>
    #[serde(rename = "Os")]
    pub os: String,
}

/// <p>The TensorBoard app settings.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TensorBoardAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
    #[serde(rename = "DefaultResourceSpec")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_resource_spec: Option<ResourceSpec>,
}

/// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TensorBoardOutputConfig {
    /// <p>Path to local storage location for tensorBoard output. Defaults to <code>/opt/ml/output/tensorboard</code>.</p>
    #[serde(rename = "LocalPath")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub local_path: Option<String>,
    /// <p>Path to Amazon S3 storage location for TensorBoard output.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>Currently, the <code>TrafficRoutingConfig</code> API is not supported.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TrafficRoutingConfig {
    /// <p><p/></p>
    #[serde(rename = "CanarySize")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub canary_size: Option<CapacitySize>,
    /// <p><p/></p>
    #[serde(rename = "Type")]
    pub type_: String,
    /// <p><p/></p>
    #[serde(rename = "WaitIntervalInSeconds")]
    pub wait_interval_in_seconds: i64,
}

/// <p>Contains information about a training job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrainingJob {
    /// <p>Information about the algorithm used for training, and algorithm metadata.</p>
    #[serde(rename = "AlgorithmSpecification")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub algorithm_specification: Option<AlgorithmSpecification>,
    /// <p>The Amazon Resource Name (ARN) of the job.</p>
    #[serde(rename = "AutoMLJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_arn: Option<String>,
    /// <p>The billable time in seconds.</p>
    #[serde(rename = "BillableTimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub billable_time_in_seconds: Option<i64>,
    #[serde(rename = "CheckpointConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub checkpoint_config: Option<CheckpointConfig>,
    /// <p>A timestamp that indicates when the training job was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    #[serde(rename = "DebugHookConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_hook_config: Option<DebugHookConfig>,
    /// <p>Information about the debug rule configuration.</p>
    #[serde(rename = "DebugRuleConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_rule_configurations: Option<Vec<DebugRuleConfiguration>>,
    /// <p>Information about the evaluation status of the rules for the training job.</p>
    #[serde(rename = "DebugRuleEvaluationStatuses")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub debug_rule_evaluation_statuses: Option<Vec<DebugRuleEvaluationStatus>>,
    /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>
    #[serde(rename = "EnableInterContainerTrafficEncryption")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_inter_container_traffic_encryption: Option<bool>,
    /// <p>When true, enables managed spot training using Amazon EC2 Spot instances to run training jobs instead of on-demand instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>.</p>
    #[serde(rename = "EnableManagedSpotTraining")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_managed_spot_training: Option<bool>,
    /// <p>If the <code>TrainingJob</code> was created with network isolation, the value is set to <code>true</code>. If network isolation is enabled, nodes can't communicate beyond the VPC they run in.</p>
    #[serde(rename = "EnableNetworkIsolation")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_network_isolation: Option<bool>,
    /// <p>The environment variables to set in the Docker container.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>If the training job failed, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>A list of final metric values that are set when the training job completes. Used only if the training job was configured to use metrics.</p>
    #[serde(rename = "FinalMetricDataList")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub final_metric_data_list: Option<Vec<MetricData>>,
    /// <p>Algorithm-specific parameters.</p>
    #[serde(rename = "HyperParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>An array of <code>Channel</code> objects that describes each data input channel.</p>
    #[serde(rename = "InputDataConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_data_config: Option<Vec<Channel>>,
    /// <p>The Amazon Resource Name (ARN) of the labeling job.</p>
    #[serde(rename = "LabelingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_arn: Option<String>,
    /// <p>A timestamp that indicates when the status of the training job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>Information about the Amazon S3 location that is configured for storing model artifacts.</p>
    #[serde(rename = "ModelArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_artifacts: Option<ModelArtifacts>,
    /// <p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts.</p>
    #[serde(rename = "OutputDataConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_data_config: Option<OutputDataConfig>,
    /// <p>Resources, including ML compute instances and ML storage volumes, that are configured for model training.</p>
    #[serde(rename = "ResourceConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub resource_config: Option<ResourceConfig>,
    /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
    #[serde(rename = "RetryStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retry_strategy: Option<RetryStrategy>,
    /// <p>The AWS Identity and Access Management (IAM) role configured for the training job.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p><p> Provides detailed information about the state of the training job. For detailed information about the secondary status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.</p> <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <important> <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p> </important> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul></p>
    #[serde(rename = "SecondaryStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secondary_status: Option<String>,
    /// <p>A history of all of the secondary statuses that the training job has transitioned through.</p>
    #[serde(rename = "SecondaryStatusTransitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub secondary_status_transitions: Option<Vec<SecondaryStatusTransition>>,
    /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
    #[serde(rename = "StoppingCondition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopping_condition: Option<StoppingCondition>,
    /// <p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    #[serde(rename = "TensorBoardOutputConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tensor_board_output_config: Option<TensorBoardOutputConfig>,
    /// <p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
    #[serde(rename = "TrainingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    #[serde(rename = "TrainingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_arn: Option<String>,
    /// <p>The name of the training job.</p>
    #[serde(rename = "TrainingJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_name: Option<String>,
    /// <p>The status of the training job.</p> <p>Training job statuses are:</p> <ul> <li> <p> <code>InProgress</code> - The training is in progress.</p> </li> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li> <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> <p>For more detailed information, see <code>SecondaryStatus</code>. </p>
    #[serde(rename = "TrainingJobStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job_status: Option<String>,
    /// <p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>
    #[serde(rename = "TrainingStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_start_time: Option<f64>,
    /// <p>The training time in seconds.</p>
    #[serde(rename = "TrainingTimeInSeconds")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_time_in_seconds: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>
    #[serde(rename = "TuningJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tuning_job_arn: Option<String>,
    /// <p>A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    #[serde(rename = "VpcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub vpc_config: Option<VpcConfig>,
}

/// <p>Defines the input needed to run a training job using the algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TrainingJobDefinition {
    /// <p>The hyperparameters used for the training job.</p>
    #[serde(rename = "HyperParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub hyper_parameters: Option<::std::collections::HashMap<String, String>>,
    /// <p>An array of <code>Channel</code> objects, each of which specifies an input source.</p>
    #[serde(rename = "InputDataConfig")]
    pub input_data_config: Vec<Channel>,
    /// <p>the path to the S3 bucket where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts.</p>
    #[serde(rename = "OutputDataConfig")]
    pub output_data_config: OutputDataConfig,
    /// <p>The resources, including the ML compute instances and ML storage volumes, to use for model training.</p>
    #[serde(rename = "ResourceConfig")]
    pub resource_config: ResourceConfig,
    /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts.</p>
    #[serde(rename = "StoppingCondition")]
    pub stopping_condition: StoppingCondition,
    /// <p>The input mode used by the algorithm for the training job. For the input modes that Amazon SageMaker algorithms support, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.</p> <p>If an algorithm supports the <code>File</code> input mode, Amazon SageMaker downloads the training data from S3 to the provisioned ML storage Volume, and mounts the directory to docker volume for training container. If an algorithm supports the <code>Pipe</code> input mode, Amazon SageMaker streams data directly from S3 to the container.</p>
    #[serde(rename = "TrainingInputMode")]
    pub training_input_mode: String,
}

/// <p>The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrainingJobStatusCounters {
    /// <p>The number of completed training jobs launched by the hyperparameter tuning job.</p>
    #[serde(rename = "Completed")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub completed: Option<i64>,
    /// <p>The number of in-progress training jobs launched by a hyperparameter tuning job.</p>
    #[serde(rename = "InProgress")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub in_progress: Option<i64>,
    /// <p>The number of training jobs that failed and can't be retried. A failed training job can't be retried if it failed because a client error occurred.</p>
    #[serde(rename = "NonRetryableError")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub non_retryable_error: Option<i64>,
    /// <p>The number of training jobs that failed, but can be retried. A failed training job can be retried only if it failed because an internal service error occurred.</p>
    #[serde(rename = "RetryableError")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retryable_error: Option<i64>,
    /// <p>The number of training jobs launched by a hyperparameter tuning job that were manually stopped.</p>
    #[serde(rename = "Stopped")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub stopped: Option<i64>,
}

/// <p>Metadata for a training job step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrainingJobStepMetadata {
    /// <p>The Amazon Resource Name (ARN) of the training job that was run by this step execution.</p>
    #[serde(rename = "Arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
}

/// <p>Provides summary information about a training job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrainingJobSummary {
    /// <p>A timestamp that shows when the training job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p> Timestamp when the training job was last modified. </p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>). </p>
    #[serde(rename = "TrainingEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    #[serde(rename = "TrainingJobArn")]
    pub training_job_arn: String,
    /// <p>The name of the training job that you want a summary for.</p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
    /// <p>The status of the training job.</p>
    #[serde(rename = "TrainingJobStatus")]
    pub training_job_status: String,
}

/// <p>Defines how the algorithm is used for a training job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TrainingSpecification {
    /// <p>A list of <code>MetricDefinition</code> objects, which are used for parsing metrics generated by the algorithm.</p>
    #[serde(rename = "MetricDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_definitions: Option<Vec<MetricDefinition>>,
    /// <p>A list of the <code>HyperParameterSpecification</code> objects, that define the supported hyperparameters. This is required if the algorithm supports automatic model tuning.&gt;</p>
    #[serde(rename = "SupportedHyperParameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_hyper_parameters: Option<Vec<HyperParameterSpecification>>,
    /// <p>A list of the instance types that this algorithm can use for training.</p>
    #[serde(rename = "SupportedTrainingInstanceTypes")]
    pub supported_training_instance_types: Vec<String>,
    /// <p>A list of the metrics that the algorithm emits that can be used as the objective metric in a hyperparameter tuning job.</p>
    #[serde(rename = "SupportedTuningJobObjectiveMetrics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supported_tuning_job_objective_metrics: Option<Vec<HyperParameterTuningJobObjective>>,
    /// <p>Indicates whether the algorithm supports distributed training. If set to false, buyers can't request more than one instance during training.</p>
    #[serde(rename = "SupportsDistributedTraining")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub supports_distributed_training: Option<bool>,
    /// <p>A list of <code>ChannelSpecification</code> objects, which specify the input sources to be used by the algorithm.</p>
    #[serde(rename = "TrainingChannels")]
    pub training_channels: Vec<ChannelSpecification>,
    /// <p>The Amazon ECR registry path of the Docker image that contains the training algorithm.</p>
    #[serde(rename = "TrainingImage")]
    pub training_image: String,
    /// <p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>
    #[serde(rename = "TrainingImageDigest")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_image_digest: Option<String>,
}

/// <p>Describes the location of the channel data.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TransformDataSource {
    /// <p>The S3 location of the data source that is associated with a channel.</p>
    #[serde(rename = "S3DataSource")]
    pub s3_data_source: TransformS3DataSource,
}

/// <p>Describes the input source of a transform job and the way the transform job consumes it.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TransformInput {
    /// <p>If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is <code>None</code>.</p>
    #[serde(rename = "CompressionType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub compression_type: Option<String>,
    /// <p>The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.</p>
    #[serde(rename = "ContentType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    /// <p>Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.</p>
    #[serde(rename = "DataSource")]
    pub data_source: TransformDataSource,
    /// <p><p>The method to use to split the transform job&#39;s data files into smaller batches. Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats. Currently, the supported record formats are:</p> <ul> <li> <p>RecordIO</p> </li> <li> <p>TFRecord</p> </li> </ul> <p>When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in each request.</p> <note> <p>Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to <code>MultiRecord</code>.</p> <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p> </note></p>
    #[serde(rename = "SplitType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub split_type: Option<String>,
}

/// <p>A batch transform job. For information about SageMaker batch transform, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Use Batch Transform</a>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TransformJob {
    /// <p>The Amazon Resource Name (ARN) of the AutoML job that created the transform job.</p>
    #[serde(rename = "AutoMLJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub auto_ml_job_arn: Option<String>,
    /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A record is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.</p>
    #[serde(rename = "BatchStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_strategy: Option<String>,
    /// <p>A timestamp that shows when the transform Job was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    #[serde(rename = "DataProcessing")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub data_processing: Option<DataProcessing>,
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "ExperimentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_config: Option<ExperimentConfig>,
    /// <p>If the transform job failed, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the labeling job that created the transform job.</p>
    #[serde(rename = "LabelingJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub labeling_job_arn: Option<String>,
    /// <p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to 0 or left unset, SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is 1. For built-in algorithms, you don't need to set a value for <code>MaxConcurrentTransforms</code>.</p>
    #[serde(rename = "MaxConcurrentTransforms")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_concurrent_transforms: Option<i64>,
    /// <p>The maximum allowed size of the payload, in MB. A payload is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is 6 MB. For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to 0. This feature works only in supported algorithms. Currently, SageMaker built-in algorithms do not support HTTP chunked encoding.</p>
    #[serde(rename = "MaxPayloadInMB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_payload_in_mb: Option<i64>,
    #[serde(rename = "ModelClientConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_client_config: Option<ModelClientConfig>,
    /// <p>The name of the model associated with the transform job.</p>
    #[serde(rename = "ModelName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub model_name: Option<String>,
    /// <p>A list of tags associated with the transform job.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>
    #[serde(rename = "TransformEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_end_time: Option<f64>,
    #[serde(rename = "TransformInput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_input: Option<TransformInput>,
    /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
    #[serde(rename = "TransformJobArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_job_arn: Option<String>,
    /// <p>The name of the transform job.</p>
    #[serde(rename = "TransformJobName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_job_name: Option<String>,
    /// <p><p>The status of the transform job.</p> <p>Transform job statuses are:</p> <ul> <li> <p> <code>InProgress</code> - The job is in progress.</p> </li> <li> <p> <code>Completed</code> - The job has completed.</p> </li> <li> <p> <code>Failed</code> - The transform job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTransformJob</code> call.</p> </li> <li> <p> <code>Stopping</code> - The transform job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The transform job has stopped.</p> </li> </ul></p>
    #[serde(rename = "TransformJobStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_job_status: Option<String>,
    #[serde(rename = "TransformOutput")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_output: Option<TransformOutput>,
    #[serde(rename = "TransformResources")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_resources: Option<TransformResources>,
    /// <p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>
    #[serde(rename = "TransformStartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_start_time: Option<f64>,
}

/// <p>Defines the input needed to run a transform job using the inference specification specified in the algorithm.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TransformJobDefinition {
    /// <p>A string that determines the number of records included in a single mini-batch.</p> <p> <code>SingleRecord</code> means only one record is used per mini-batch. <code>MultiRecord</code> means a mini-batch is set to contain as many records that can fit within the <code>MaxPayloadInMB</code> limit.</p>
    #[serde(rename = "BatchStrategy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub batch_strategy: Option<String>,
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
    #[serde(rename = "Environment")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub environment: Option<::std::collections::HashMap<String, String>>,
    /// <p>The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.</p>
    #[serde(rename = "MaxConcurrentTransforms")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_concurrent_transforms: Option<i64>,
    /// <p>The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).</p>
    #[serde(rename = "MaxPayloadInMB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max_payload_in_mb: Option<i64>,
    /// <p>A description of the input source and the way the transform job consumes it.</p>
    #[serde(rename = "TransformInput")]
    pub transform_input: TransformInput,
    /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>
    #[serde(rename = "TransformOutput")]
    pub transform_output: TransformOutput,
    /// <p>Identifies the ML compute instances for the transform job.</p>
    #[serde(rename = "TransformResources")]
    pub transform_resources: TransformResources,
}

/// <p>Metadata for a transform job step.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TransformJobStepMetadata {
    /// <p>The Amazon Resource Name (ARN) of the transform job that was run by this step execution.</p>
    #[serde(rename = "Arn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub arn: Option<String>,
}

/// <p>Provides a summary of a transform job. Multiple <code>TransformJobSummary</code> objects are returned as a list after in response to a <a>ListTransformJobs</a> call.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TransformJobSummary {
    /// <p>A timestamp that shows when the transform Job was created.</p>
    #[serde(rename = "CreationTime")]
    pub creation_time: f64,
    /// <p>If the transform job failed, the reason it failed.</p>
    #[serde(rename = "FailureReason")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub failure_reason: Option<String>,
    /// <p>Indicates when the transform job was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected that the job failed.</p>
    #[serde(rename = "TransformEndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_end_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
    #[serde(rename = "TransformJobArn")]
    pub transform_job_arn: String,
    /// <p>The name of the transform job.</p>
    #[serde(rename = "TransformJobName")]
    pub transform_job_name: String,
    /// <p>The status of the transform job.</p>
    #[serde(rename = "TransformJobStatus")]
    pub transform_job_status: String,
}

/// <p>Describes the results of a transform job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TransformOutput {
    /// <p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.</p>
    #[serde(rename = "Accept")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accept: Option<String>,
    /// <p>Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline character at the end of every transformed record, specify <code>Line</code>.</p>
    #[serde(rename = "AssembleWith")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub assemble_with: Option<String>,
    /// <p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
    #[serde(rename = "KmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kms_key_id: Option<String>,
    /// <p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For example, <code>s3://bucket-name/key-name-prefix</code>.</p> <p>For every S3 object used as input for the transform job, batch transform stores the transformed data with an .<code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform stores the transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>. Batch transform doesn't upload partially processed objects. For an input S3 object that contains multiple records, it creates an .<code>out</code> file only if the transform job succeeds on the entire file. When the input contains multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for successfully processed objects. If any object fails in the transform job batch transform marks the job as failed to prompt investigation.</p>
    #[serde(rename = "S3OutputPath")]
    pub s3_output_path: String,
}

/// <p>Describes the resources, including ML instance types and ML instance count, to use for transform job.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TransformResources {
    /// <p>The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a value greater than 1. The default value is <code>1</code>.</p>
    #[serde(rename = "InstanceCount")]
    pub instance_count: i64,
    /// <p>The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code>instance types.</p>
    #[serde(rename = "InstanceType")]
    pub instance_type: String,
    /// <p><p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can&#39;t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p> The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul></p>
    #[serde(rename = "VolumeKmsKeyId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_kms_key_id: Option<String>,
}

/// <p>Describes the S3 data source.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TransformS3DataSource {
    /// <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch transform. </p> <p>The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code> </p> <p>The following value is not compatible: <code>AugmentedManifestFile</code> </p>
    #[serde(rename = "S3DataType")]
    pub s3_data_type: String,
    /// <p><p>Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a manifest. For example:</p> <ul> <li> <p> A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>. </p> </li> <li> <p> A manifest might look like this: <code>s3://bucketname/example.manifest</code> </p> <p> The manifest is an S3 object which is a JSON file with the following format: </p> <p> <code>[ {&quot;prefix&quot;: &quot;s3://customer<em>bucket/some/prefix/&quot;},</code> </p> <p> <code>&quot;relative/path/to/custdata-1&quot;,</code> </p> <p> <code>&quot;relative/path/custdata-2&quot;,</code> </p> <p> <code>...</code> </p> <p> <code>&quot;relative/path/custdata-N&quot;</code> </p> <p> <code>]</code> </p> <p> The preceding JSON matches the following <code>S3Uris</code>: </p> <p> <code>s3://customer</em>bucket/some/prefix/relative/path/to/custdata-1</code> </p> <p> <code>s3://customer<em>bucket/some/prefix/relative/path/custdata-2</code> </p> <p> <code>...</code> </p> <p> <code>s3://customer</em>bucket/some/prefix/relative/path/custdata-N</code> </p> <p> The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel for this datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker uses to perform tasks on your behalf.</p> </li> </ul></p>
    #[serde(rename = "S3Uri")]
    pub s3_uri: String,
}

/// <p>The properties of a trial as returned by the <a>Search</a> API.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct Trial {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the trial was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the experiment the trial is part of.</p>
    #[serde(rename = "ExperimentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_name: Option<String>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>Who last modified the trial.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<TrialSource>,
    /// <p>The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
    /// <p>A list of the components associated with the trial. For each component, a summary of the component's properties is included.</p>
    #[serde(rename = "TrialComponentSummaries")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_summaries: Option<Vec<TrialComponentSimpleSummary>>,
    /// <p>The name of the trial.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
}

/// <p>The properties of a trial component as returned by the <a>Search</a> API.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialComponent {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the component was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When the component ended.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>The input artifacts of the component.</p>
    #[serde(rename = "InputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the component was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    #[serde(rename = "MetadataProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metadata_properties: Option<MetadataProperties>,
    /// <p>The metrics for the component.</p>
    #[serde(rename = "Metrics")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metrics: Option<Vec<TrialComponentMetricSummary>>,
    /// <p>The output artifacts of the component.</p>
    #[serde(rename = "OutputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    /// <p>The hyperparameters of the component.</p>
    #[serde(rename = "Parameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameters: Option<::std::collections::HashMap<String, TrialComponentParameterValue>>,
    /// <p>An array of the parents of the component. A parent is a trial the component is associated with and the experiment the trial is part of. A component might not have any parents.</p>
    #[serde(rename = "Parents")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parents: Option<Vec<Parent>>,
    /// <p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>
    #[serde(rename = "Source")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source: Option<TrialComponentSource>,
    /// <p>Details of the source of the component.</p>
    #[serde(rename = "SourceDetail")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_detail: Option<TrialComponentSourceDetail>,
    /// <p>When the component started.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<TrialComponentStatus>,
    /// <p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>
    #[serde(rename = "Tags")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<Tag>>,
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
    /// <p>The name of the trial component.</p>
    #[serde(rename = "TrialComponentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_name: Option<String>,
}

/// <p>Represents an input or output artifact of a trial component. You specify <code>TrialComponentArtifact</code> as part of the <code>InputArtifacts</code> and <code>OutputArtifacts</code> parameters in the <a>CreateTrialComponent</a> request.</p> <p>Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types. Examples of output artifacts are metrics, snapshots, logs, and images.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TrialComponentArtifact {
    /// <p>The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.</p>
    #[serde(rename = "MediaType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub media_type: Option<String>,
    /// <p>The location of the artifact.</p>
    #[serde(rename = "Value")]
    pub value: String,
}

/// <p>A summary of the metrics of a trial component.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialComponentMetricSummary {
    /// <p>The average value of the metric.</p>
    #[serde(rename = "Avg")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub avg: Option<f64>,
    /// <p>The number of samples used to generate the metric.</p>
    #[serde(rename = "Count")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub count: Option<i64>,
    /// <p>The most recent value of the metric.</p>
    #[serde(rename = "Last")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last: Option<f64>,
    /// <p>The maximum value of the metric.</p>
    #[serde(rename = "Max")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub max: Option<f64>,
    /// <p>The name of the metric.</p>
    #[serde(rename = "MetricName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub metric_name: Option<String>,
    /// <p>The minimum value of the metric.</p>
    #[serde(rename = "Min")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub min: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the source.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
    /// <p>The standard deviation of the metric.</p>
    #[serde(rename = "StdDev")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub std_dev: Option<f64>,
    /// <p>When the metric was last updated.</p>
    #[serde(rename = "TimeStamp")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub time_stamp: Option<f64>,
}

/// <p>The value of a hyperparameter. Only one of <code>NumberValue</code> or <code>StringValue</code> can be specified.</p> <p>This object is specified in the <a>CreateTrialComponent</a> request.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TrialComponentParameterValue {
    /// <p>The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't specify the <code>StringValue</code> parameter.</p>
    #[serde(rename = "NumberValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub number_value: Option<f64>,
    /// <p>The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't specify the <code>NumberValue</code> parameter.</p>
    #[serde(rename = "StringValue")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub string_value: Option<String>,
}

/// <p>A short summary of a trial component.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialComponentSimpleSummary {
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the component was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
    /// <p>The name of the trial component.</p>
    #[serde(rename = "TrialComponentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_name: Option<String>,
    #[serde(rename = "TrialComponentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_source: Option<TrialComponentSource>,
}

/// <p>The Amazon Resource Name (ARN) and job type of the source of a trial component.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialComponentSource {
    /// <p>The source ARN.</p>
    #[serde(rename = "SourceArn")]
    pub source_arn: String,
    /// <p>The source job type.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
}

/// <p>Detailed information about the source of a trial component. Either <code>ProcessingJob</code> or <code>TrainingJob</code> is returned.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialComponentSourceDetail {
    /// <p>Information about a processing job that's the source of a trial component.</p>
    #[serde(rename = "ProcessingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub processing_job: Option<ProcessingJob>,
    /// <p>The Amazon Resource Name (ARN) of the source.</p>
    #[serde(rename = "SourceArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_arn: Option<String>,
    /// <p>Information about a training job that's the source of a trial component.</p>
    #[serde(rename = "TrainingJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub training_job: Option<TrainingJob>,
    /// <p>Information about a transform job that's the source of a trial component.</p>
    #[serde(rename = "TransformJob")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub transform_job: Option<TransformJob>,
}

/// <p>The status of the trial component.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TrialComponentStatus {
    /// <p>If the component failed, a message describing why.</p>
    #[serde(rename = "Message")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    /// <p>The status of the trial component.</p>
    #[serde(rename = "PrimaryStatus")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub primary_status: Option<String>,
}

/// <p>A summary of the properties of a trial component. To get all the properties, call the <a>DescribeTrialComponent</a> API and provide the <code>TrialComponentName</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialComponentSummary {
    /// <p>Who created the component.</p>
    #[serde(rename = "CreatedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub created_by: Option<UserContext>,
    /// <p>When the component was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When the component ended.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>Who last modified the component.</p>
    #[serde(rename = "LastModifiedBy")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_by: Option<UserContext>,
    /// <p>When the component was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>When the component started.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p><p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul></p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<TrialComponentStatus>,
    /// <p>The ARN of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
    /// <p>The name of the trial component.</p>
    #[serde(rename = "TrialComponentName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_name: Option<String>,
    #[serde(rename = "TrialComponentSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_source: Option<TrialComponentSource>,
}

/// <p>The source of the trial.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialSource {
    /// <p>The Amazon Resource Name (ARN) of the source.</p>
    #[serde(rename = "SourceArn")]
    pub source_arn: String,
    /// <p>The source job type.</p>
    #[serde(rename = "SourceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_type: Option<String>,
}

/// <p>A summary of the properties of a trial. To get the complete set of properties, call the <a>DescribeTrial</a> API and provide the <code>TrialName</code>.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct TrialSummary {
    /// <p>When the trial was created.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When the trial was last modified.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
    /// <p>The name of the trial.</p>
    #[serde(rename = "TrialName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_name: Option<String>,
    #[serde(rename = "TrialSource")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_source: Option<TrialSource>,
}

/// <p>The job completion criteria.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct TuningJobCompletionCriteria {
    /// <p>The value of the objective metric.</p>
    #[serde(rename = "TargetObjectiveMetricValue")]
    pub target_objective_metric_value: f32,
}

/// <p>Represents an amount of money in United States dollars.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct USD {
    /// <p>The fractional portion, in cents, of the amount. </p>
    #[serde(rename = "Cents")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub cents: Option<i64>,
    /// <p>The whole number of dollars in the amount.</p>
    #[serde(rename = "Dollars")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub dollars: Option<i64>,
    /// <p>Fractions of a cent, in tenths.</p>
    #[serde(rename = "TenthFractionsOfACent")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub tenth_fractions_of_a_cent: Option<i64>,
}

/// <p>Provided configuration information for the worker UI for a labeling job. </p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq, Serialize)]
pub struct UiConfig {
    /// <p><p>The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.</p> <p>Use this parameter when you are creating a labeling job for 3D point cloud and video fram labeling jobs. Use your labeling job task type to select one of the following ARNs and use it with this parameter when you create a labeling job. Replace <code>aws-region</code> with the AWS region you are creating your labeling job in.</p> <p> <b>3D Point Cloud HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic segmentation adjustment labeling jobs.</p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code> </p> </li> </ul></p>
    #[serde(rename = "HumanTaskUiArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub human_task_ui_arn: Option<String>,
    /// <p>The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to render the worker UI and tools for labeling job tasks. For more information about the contents of a UI template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html"> Creating Your Custom Labeling Task Template</a>.</p>
    #[serde(rename = "UiTemplateS3Uri")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub ui_template_s3_uri: Option<String>,
}

/// <p>The Liquid template for the worker user interface.</p>
#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UiTemplate {
    /// <p>The content of the Liquid template for the worker user interface.</p>
    #[serde(rename = "Content")]
    pub content: String,
}

/// <p>Container for user interface template information.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UiTemplateInfo {
    /// <p>The SHA-256 digest of the contents of the template.</p>
    #[serde(rename = "ContentSha256")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub content_sha_256: Option<String>,
    /// <p>The URL for the user interface template.</p>
    #[serde(rename = "Url")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateActionRequest {
    /// <p>The name of the action to update.</p>
    #[serde(rename = "ActionName")]
    pub action_name: String,
    /// <p>The new description for the action.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The new list of properties. Overwrites the current property list.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>A list of properties to remove.</p>
    #[serde(rename = "PropertiesToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties_to_remove: Option<Vec<String>>,
    /// <p>The new status for the action.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateActionResponse {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    #[serde(rename = "ActionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub action_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateAppImageConfigRequest {
    /// <p>The name of the AppImageConfig to update.</p>
    #[serde(rename = "AppImageConfigName")]
    pub app_image_config_name: String,
    /// <p>The new KernelGateway app to run on the image.</p>
    #[serde(rename = "KernelGatewayImageConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub kernel_gateway_image_config: Option<KernelGatewayImageConfig>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateAppImageConfigResponse {
    /// <p>The Amazon Resource Name (ARN) for the AppImageConfig.</p>
    #[serde(rename = "AppImageConfigArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub app_image_config_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateArtifactRequest {
    /// <p>The Amazon Resource Name (ARN) of the artifact to update.</p>
    #[serde(rename = "ArtifactArn")]
    pub artifact_arn: String,
    /// <p>The new name for the artifact.</p>
    #[serde(rename = "ArtifactName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_name: Option<String>,
    /// <p>The new list of properties. Overwrites the current property list.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>A list of properties to remove.</p>
    #[serde(rename = "PropertiesToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties_to_remove: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateArtifactResponse {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    #[serde(rename = "ArtifactArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub artifact_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateCodeRepositoryInput {
    /// <p>The name of the Git repository to update.</p>
    #[serde(rename = "CodeRepositoryName")]
    pub code_repository_name: String,
    /// <p>The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>
    #[serde(rename = "GitConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub git_config: Option<GitConfigForUpdate>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateCodeRepositoryOutput {
    /// <p>The ARN of the Git repository.</p>
    #[serde(rename = "CodeRepositoryArn")]
    pub code_repository_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateContextRequest {
    /// <p>The name of the context to update.</p>
    #[serde(rename = "ContextName")]
    pub context_name: String,
    /// <p>The new description for the context.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The new list of properties. Overwrites the current property list.</p>
    #[serde(rename = "Properties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, String>>,
    /// <p>A list of properties to remove.</p>
    #[serde(rename = "PropertiesToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub properties_to_remove: Option<Vec<String>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateContextResponse {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    #[serde(rename = "ContextArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub context_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateDeviceFleetRequest {
    /// <p>Description of the fleet.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the fleet.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>Whether to create an AWS IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p> <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>
    #[serde(rename = "EnableIotRoleAlias")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub enable_iot_role_alias: Option<bool>,
    /// <p>Output configuration for storing sample data collected by the fleet.</p>
    #[serde(rename = "OutputConfig")]
    pub output_config: EdgeOutputConfig,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateDevicesRequest {
    /// <p>The name of the fleet the devices belong to.</p>
    #[serde(rename = "DeviceFleetName")]
    pub device_fleet_name: String,
    /// <p>List of devices to register with Edge Manager agent.</p>
    #[serde(rename = "Devices")]
    pub devices: Vec<Device>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateDomainRequest {
    /// <p>A collection of settings.</p>
    #[serde(rename = "DefaultUserSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_user_settings: Option<UserSettings>,
    /// <p>The ID of the domain to be updated.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateDomainResponse {
    /// <p>The Amazon Resource Name (ARN) of the domain.</p>
    #[serde(rename = "DomainArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateEndpointInput {
    /// <p>The deployment configuration for the endpoint to be updated.</p>
    #[serde(rename = "DeploymentConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub deployment_config: Option<DeploymentConfig>,
    /// <p>The name of the new endpoint configuration.</p>
    #[serde(rename = "EndpointConfigName")]
    pub endpoint_config_name: String,
    /// <p>The name of the endpoint whose configuration you want to update.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
    /// <p>When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don't specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden. </p>
    #[serde(rename = "ExcludeRetainedVariantProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub exclude_retained_variant_properties: Option<Vec<VariantProperty>>,
    /// <p>When updating endpoint resources, enables or disables the retention of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant properties</a>, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to <code>false</code>. The default is <code>false</code>.</p>
    #[serde(rename = "RetainAllVariantProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub retain_all_variant_properties: Option<bool>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateEndpointOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    #[serde(rename = "EndpointArn")]
    pub endpoint_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateEndpointWeightsAndCapacitiesInput {
    /// <p>An object that provides new capacity and weight values for a variant.</p>
    #[serde(rename = "DesiredWeightsAndCapacities")]
    pub desired_weights_and_capacities: Vec<DesiredWeightAndCapacity>,
    /// <p>The name of an existing Amazon SageMaker endpoint.</p>
    #[serde(rename = "EndpointName")]
    pub endpoint_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateEndpointWeightsAndCapacitiesOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated endpoint.</p>
    #[serde(rename = "EndpointArn")]
    pub endpoint_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateExperimentRequest {
    /// <p>The description of the experiment.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The name of the experiment as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the experiment to update.</p>
    #[serde(rename = "ExperimentName")]
    pub experiment_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateExperimentResponse {
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    #[serde(rename = "ExperimentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub experiment_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateImageRequest {
    /// <p>A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties can be deleted.</p>
    #[serde(rename = "DeleteProperties")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub delete_properties: Option<Vec<String>>,
    /// <p>The new description for the image.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>The new display name for the image.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the image to update.</p>
    #[serde(rename = "ImageName")]
    pub image_name: String,
    /// <p>The new Amazon Resource Name (ARN) for the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateImageResponse {
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    #[serde(rename = "ImageArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub image_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateModelPackageInput {
    /// <p>A description for the approval status of the model.</p>
    #[serde(rename = "ApprovalDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub approval_description: Option<String>,
    /// <p>The approval status of the model.</p>
    #[serde(rename = "ModelApprovalStatus")]
    pub model_approval_status: String,
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    #[serde(rename = "ModelPackageArn")]
    pub model_package_arn: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateModelPackageOutput {
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    #[serde(rename = "ModelPackageArn")]
    pub model_package_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateMonitoringScheduleRequest {
    /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
    #[serde(rename = "MonitoringScheduleConfig")]
    pub monitoring_schedule_config: MonitoringScheduleConfig,
    /// <p>The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account.</p>
    #[serde(rename = "MonitoringScheduleName")]
    pub monitoring_schedule_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateMonitoringScheduleResponse {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    #[serde(rename = "MonitoringScheduleArn")]
    pub monitoring_schedule_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateNotebookInstanceInput {
    /// <p>A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
    #[serde(rename = "AcceleratorTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub accelerator_types: Option<Vec<String>>,
    /// <p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "AdditionalCodeRepositories")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub additional_code_repositories: Option<Vec<String>>,
    /// <p>The Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    #[serde(rename = "DefaultCodeRepository")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub default_code_repository: Option<String>,
    /// <p>A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is idempotent. If you specify an accelerator type that is not associated with the notebook instance when you call this method, it does not throw an error.</p>
    #[serde(rename = "DisassociateAcceleratorTypes")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disassociate_accelerator_types: Option<bool>,
    /// <p>A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>
    #[serde(rename = "DisassociateAdditionalCodeRepositories")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disassociate_additional_code_repositories: Option<bool>,
    /// <p>The name or URL of the default Git repository to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>
    #[serde(rename = "DisassociateDefaultCodeRepository")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disassociate_default_code_repository: Option<bool>,
    /// <p>Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not associated with the notebook instance when you call this method, it does not throw an error.</p>
    #[serde(rename = "DisassociateLifecycleConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disassociate_lifecycle_config: Option<bool>,
    /// <p>The Amazon ML compute instance type.</p>
    #[serde(rename = "InstanceType")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub instance_type: Option<String>,
    /// <p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
    #[serde(rename = "LifecycleConfigName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub lifecycle_config_name: Option<String>,
    /// <p>The name of the notebook instance to update.</p>
    #[serde(rename = "NotebookInstanceName")]
    pub notebook_instance_name: String,
    /// <p><p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note></p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
    /// <p><p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note> <p>If you set this to <code>Disabled</code>, users don&#39;t have root access on the notebook instance, but lifecycle configuration scripts still run with root permissions.</p> </note></p>
    #[serde(rename = "RootAccess")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub root_access: Option<String>,
    /// <p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML storage volumes are encrypted, so Amazon SageMaker can't determine the amount of available free space on the volume. Because of this, you can increase the volume size when you update a notebook instance, but you can't decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new notebook instance with the desired size.</p>
    #[serde(rename = "VolumeSizeInGB")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub volume_size_in_gb: Option<i64>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateNotebookInstanceLifecycleConfigInput {
    /// <p>The name of the lifecycle configuration.</p>
    #[serde(rename = "NotebookInstanceLifecycleConfigName")]
    pub notebook_instance_lifecycle_config_name: String,
    /// <p>The shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>
    #[serde(rename = "OnCreate")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_create: Option<Vec<NotebookInstanceLifecycleHook>>,
    /// <p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>
    #[serde(rename = "OnStart")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub on_start: Option<Vec<NotebookInstanceLifecycleHook>>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateNotebookInstanceLifecycleConfigOutput {}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateNotebookInstanceOutput {}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdatePipelineExecutionRequest {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    pub pipeline_execution_arn: String,
    /// <p>The description of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_description: Option<String>,
    /// <p>The display name of the pipeline execution.</p>
    #[serde(rename = "PipelineExecutionDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_display_name: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdatePipelineExecutionResponse {
    /// <p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>
    #[serde(rename = "PipelineExecutionArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_execution_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdatePipelineRequest {
    /// <p>The JSON pipeline definition.</p>
    #[serde(rename = "PipelineDefinition")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_definition: Option<String>,
    /// <p>The description of the pipeline.</p>
    #[serde(rename = "PipelineDescription")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_description: Option<String>,
    /// <p>The display name of the pipeline.</p>
    #[serde(rename = "PipelineDisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_display_name: Option<String>,
    /// <p>The name of the pipeline to update.</p>
    #[serde(rename = "PipelineName")]
    pub pipeline_name: String,
    /// <p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>
    #[serde(rename = "RoleArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub role_arn: Option<String>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdatePipelineResponse {
    /// <p>The Amazon Resource Name (ARN) of the updated pipeline.</p>
    #[serde(rename = "PipelineArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub pipeline_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateTrainingJobRequest {
    /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
    #[serde(rename = "ProfilerConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_config: Option<ProfilerConfigForUpdate>,
    /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
    #[serde(rename = "ProfilerRuleConfigurations")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub profiler_rule_configurations: Option<Vec<ProfilerRuleConfiguration>>,
    /// <p>The name of a training job to update the Debugger profiling configuration.</p>
    #[serde(rename = "TrainingJobName")]
    pub training_job_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateTrainingJobResponse {
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    #[serde(rename = "TrainingJobArn")]
    pub training_job_arn: String,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateTrialComponentRequest {
    /// <p>The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>When the component ended.</p>
    #[serde(rename = "EndTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub end_time: Option<f64>,
    /// <p>Replaces all of the component's input artifacts with the specified artifacts.</p>
    #[serde(rename = "InputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    /// <p>The input artifacts to remove from the component.</p>
    #[serde(rename = "InputArtifactsToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub input_artifacts_to_remove: Option<Vec<String>>,
    /// <p>Replaces all of the component's output artifacts with the specified artifacts.</p>
    #[serde(rename = "OutputArtifacts")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_artifacts: Option<::std::collections::HashMap<String, TrialComponentArtifact>>,
    /// <p>The output artifacts to remove from the component.</p>
    #[serde(rename = "OutputArtifactsToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub output_artifacts_to_remove: Option<Vec<String>>,
    /// <p>Replaces all of the component's hyperparameters with the specified hyperparameters.</p>
    #[serde(rename = "Parameters")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameters: Option<::std::collections::HashMap<String, TrialComponentParameterValue>>,
    /// <p>The hyperparameters to remove from the component.</p>
    #[serde(rename = "ParametersToRemove")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub parameters_to_remove: Option<Vec<String>>,
    /// <p>When the component started.</p>
    #[serde(rename = "StartTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub start_time: Option<f64>,
    /// <p>The new status of the component.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<TrialComponentStatus>,
    /// <p>The name of the component to update.</p>
    #[serde(rename = "TrialComponentName")]
    pub trial_component_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateTrialComponentResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    #[serde(rename = "TrialComponentArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_component_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateTrialRequest {
    /// <p>The name of the trial as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    #[serde(rename = "DisplayName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// <p>The name of the trial to update.</p>
    #[serde(rename = "TrialName")]
    pub trial_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateTrialResponse {
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    #[serde(rename = "TrialArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub trial_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateUserProfileRequest {
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    pub domain_id: String,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    pub user_profile_name: String,
    /// <p>A collection of settings.</p>
    #[serde(rename = "UserSettings")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_settings: Option<UserSettings>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateUserProfileResponse {
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    #[serde(rename = "UserProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_arn: Option<String>,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateWorkforceRequest {
    /// <p>Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your own IdP.</p>
    #[serde(rename = "OidcConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub oidc_config: Option<OidcConfig>,
    /// <p>A list of one to ten worker IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to access tasks assigned to this workforce.</p> <p>Maximum: Ten CIDR values</p>
    #[serde(rename = "SourceIpConfig")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub source_ip_config: Option<SourceIpConfig>,
    /// <p>The name of the private workforce that you want to update. You can find your workforce name by using the operation.</p>
    #[serde(rename = "WorkforceName")]
    pub workforce_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateWorkforceResponse {
    /// <p>A single private workforce. You can create one private work force in each AWS Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
    #[serde(rename = "Workforce")]
    pub workforce: Workforce,
}

#[derive(Clone, Debug, Default, PartialEq, Serialize)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdateWorkteamRequest {
    /// <p>An updated description for the work team.</p>
    #[serde(rename = "Description")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide input for both of these parameters in a single request.</p> <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be aware that user groups that are already in the work team must also be listed in <code>Groups</code> when you make this request to remain on the work team. If you do not include these user groups, they will no longer be associated with the work team you update. </p>
    #[serde(rename = "MemberDefinitions")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub member_definitions: Option<Vec<MemberDefinition>>,
    /// <p>Configures SNS topic notifications for available or expiring work items</p>
    #[serde(rename = "NotificationConfiguration")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub notification_configuration: Option<NotificationConfiguration>,
    /// <p>The name of the work team to update.</p>
    #[serde(rename = "WorkteamName")]
    pub workteam_name: String,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UpdateWorkteamResponse {
    /// <p>A <code>Workteam</code> object that describes the updated work team.</p>
    #[serde(rename = "Workteam")]
    pub workteam: Workteam,
}

/// <p>Information about the user who created or modified an experiment, trial, or trial component.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UserContext {
    /// <p>The domain associated with the user.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the user's profile.</p>
    #[serde(rename = "UserProfileArn")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_arn: Option<String>,
    /// <p>The name of the user's profile.</p>
    #[serde(rename = "UserProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name: Option<String>,
}

/// <p>The user profile details.</p>
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
#[cfg_attr(any(test, feature = "serialize_structs"), derive(Serialize))]
pub struct UserProfileDetails {
    /// <p>The creation time.</p>
    #[serde(rename = "CreationTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f64>,
    /// <p>The domain ID.</p>
    #[serde(rename = "DomainId")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub domain_id: Option<String>,
    /// <p>The last modified time.</p>
    #[serde(rename = "LastModifiedTime")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub last_modified_time: Option<f64>,
    /// <p>The status.</p>
    #[serde(rename = "Status")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// <p>The user profile name.</p>
    #[serde(rename = "UserProfileName")]
    #[serde(skip_serializing_if = "Option::is_none")]
    pub user_profile_name: Option<String>,
}

/// <p>A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the <code>CreateUserProfile</code> API is called, and as <code>DefaultUserSettings</code> when the <code>CreateDomain</code> API is called.</p> <p> <code>SecurityGroups</code> is aggregated when s