// =================================================================
//
//                           * WARNING *
//
//                    This file is generated!
//
//  Changes made to this file will be overwritten. If changes are
//  required to the generated code, the service_crategen project
//  must be updated to generate the changes.
//
// =================================================================

use std::error::Error;
use std::fmt;

use async_trait::async_trait;
use rusoto_core::credential::ProvideAwsCredentials;
use rusoto_core::region;
use rusoto_core::request::{BufferedHttpResponse, DispatchSignedRequest};
use rusoto_core::{Client, RusotoError};

use rusoto_core::param::{Params, ServiceParams};
use rusoto_core::proto::xml::error::*;
use rusoto_core::proto::xml::util::{
    self as xml_util, deserialize_elements, find_start_element, skip_tree,
};
use rusoto_core::proto::xml::util::{Next, Peek, XmlParseError, XmlResponse};
use rusoto_core::request::HttpResponse;
use rusoto_core::signature::SignedRequest;
#[cfg(feature = "deserialize_structs")]
use serde::Deserialize;
#[cfg(feature = "serialize_structs")]
use serde::Serialize;
use serde_urlencoded;
use std::str::FromStr;
use xml::EventReader;

impl RedshiftClient {
    fn new_params(&self, operation_name: &str) -> Params {
        let mut params = Params::new();

        params.put("Action", operation_name);
        params.put("Version", "2012-12-01");

        params
    }

    async fn sign_and_dispatch<E>(
        &self,
        request: SignedRequest,
        from_response: fn(BufferedHttpResponse) -> RusotoError<E>,
    ) -> Result<HttpResponse, RusotoError<E>> {
        let mut response = self.client.sign_and_dispatch(request).await?;
        if !response.status.is_success() {
            let response = response.buffer().await.map_err(RusotoError::HttpDispatch)?;
            return Err(from_response(response));
        }

        Ok(response)
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AcceptReservedNodeExchangeInputMessage {
    /// <p>A string representing the node identifier of the DC1 Reserved Node to be exchanged.</p>
    pub reserved_node_id: String,
    /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a> </p>
    pub target_reserved_node_offering_id: String,
}

/// Serialize `AcceptReservedNodeExchangeInputMessage` contents to a `SignedRequest`.
struct AcceptReservedNodeExchangeInputMessageSerializer;
impl AcceptReservedNodeExchangeInputMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AcceptReservedNodeExchangeInputMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ReservedNodeId"),
            &obj.reserved_node_id,
        );
        params.put(
            &format!("{}{}", prefix, "TargetReservedNodeOfferingId"),
            &obj.target_reserved_node_offering_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AcceptReservedNodeExchangeOutputMessage {
    /// <p><p/></p>
    pub exchanged_reserved_node: Option<ReservedNode>,
}

#[allow(dead_code)]
struct AcceptReservedNodeExchangeOutputMessageDeserializer;
impl AcceptReservedNodeExchangeOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AcceptReservedNodeExchangeOutputMessage, XmlParseError> {
        deserialize_elements::<_, AcceptReservedNodeExchangeOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ExchangedReservedNode" => {
                        obj.exchanged_reserved_node = Some(ReservedNodeDeserializer::deserialize(
                            "ExchangedReservedNode",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>A name value pair that describes an aspect of an account. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountAttribute {
    /// <p>The name of the attribute.</p>
    pub attribute_name: Option<String>,
    /// <p>A list of attribute values.</p>
    pub attribute_values: Option<Vec<AttributeValueTarget>>,
}

#[allow(dead_code)]
struct AccountAttributeDeserializer;
impl AccountAttributeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountAttribute, XmlParseError> {
        deserialize_elements::<_, AccountAttribute, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AttributeName" => {
                    obj.attribute_name =
                        Some(StringDeserializer::deserialize("AttributeName", stack)?);
                }
                "AttributeValues" => {
                    obj.attribute_values.get_or_insert(vec![]).extend(
                        AttributeValueListDeserializer::deserialize("AttributeValues", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountAttributeList {
    /// <p>A list of attributes assigned to an account.</p>
    pub account_attributes: Option<Vec<AccountAttribute>>,
}

#[allow(dead_code)]
struct AccountAttributeListDeserializer;
impl AccountAttributeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountAttributeList, XmlParseError> {
        deserialize_elements::<_, AccountAttributeList, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AccountAttributes" => {
                    obj.account_attributes.get_or_insert(vec![]).extend(
                        AttributeListDeserializer::deserialize("AccountAttributes", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes an AWS customer account authorized to restore a snapshot.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AccountWithRestoreAccess {
    /// <p>The identifier of an AWS support account authorized to restore a snapshot. For AWS support, the identifier is <code>amazon-redshift-support</code>. </p>
    pub account_alias: Option<String>,
    /// <p>The identifier of an AWS customer account authorized to restore a snapshot.</p>
    pub account_id: Option<String>,
}

#[allow(dead_code)]
struct AccountWithRestoreAccessDeserializer;
impl AccountWithRestoreAccessDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AccountWithRestoreAccess, XmlParseError> {
        deserialize_elements::<_, AccountWithRestoreAccess, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AccountAlias" => {
                        obj.account_alias =
                            Some(StringDeserializer::deserialize("AccountAlias", stack)?);
                    }
                    "AccountId" => {
                        obj.account_id = Some(StringDeserializer::deserialize("AccountId", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct AccountsWithRestoreAccessListDeserializer;
impl AccountsWithRestoreAccessListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccountWithRestoreAccess>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AccountWithRestoreAccess" {
                obj.push(AccountWithRestoreAccessDeserializer::deserialize(
                    "AccountWithRestoreAccess",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AquaConfiguration {
    /// <p><p>The value represents how the cluster is configured to use AQUA. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don&#39;t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul></p>
    pub aqua_configuration_status: Option<String>,
    /// <p><p>The value indicates the status of AQUA on the cluster. Possible values include the following.</p> <ul> <li> <p>enabled - AQUA is enabled.</p> </li> <li> <p>disabled - AQUA is not enabled. </p> </li> <li> <p>applying - AQUA status is being applied. </p> </li> </ul></p>
    pub aqua_status: Option<String>,
}

#[allow(dead_code)]
struct AquaConfigurationDeserializer;
impl AquaConfigurationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AquaConfiguration, XmlParseError> {
        deserialize_elements::<_, AquaConfiguration, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AquaConfigurationStatus" => {
                    obj.aqua_configuration_status =
                        Some(AquaConfigurationStatusDeserializer::deserialize(
                            "AquaConfigurationStatus",
                            stack,
                        )?);
                }
                "AquaStatus" => {
                    obj.aqua_status =
                        Some(AquaStatusDeserializer::deserialize("AquaStatus", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AquaConfigurationStatusDeserializer;
impl AquaConfigurationStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AquaStatusDeserializer;
impl AquaStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct AssociatedClusterListDeserializer;
impl AssociatedClusterListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterAssociatedToSchedule>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterAssociatedToSchedule" {
                obj.push(ClusterAssociatedToScheduleDeserializer::deserialize(
                    "ClusterAssociatedToSchedule",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AttributeListDeserializer;
impl AttributeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AccountAttribute>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AccountAttribute" {
                obj.push(AccountAttributeDeserializer::deserialize(
                    "AccountAttribute",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `AttributeNameList` contents to a `SignedRequest`.
struct AttributeNameListSerializer;
impl AttributeNameListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct AttributeValueListDeserializer;
impl AttributeValueListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AttributeValueTarget>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AttributeValueTarget" {
                obj.push(AttributeValueTargetDeserializer::deserialize(
                    "AttributeValueTarget",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes an attribute value.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AttributeValueTarget {
    /// <p>The value of the attribute.</p>
    pub attribute_value: Option<String>,
}

#[allow(dead_code)]
struct AttributeValueTargetDeserializer;
impl AttributeValueTargetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AttributeValueTarget, XmlParseError> {
        deserialize_elements::<_, AttributeValueTarget, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AttributeValue" => {
                    obj.attribute_value =
                        Some(StringDeserializer::deserialize("AttributeValue", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AuthorizationStatusDeserializer;
impl AuthorizationStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeClusterSecurityGroupIngressMessage {
    /// <p>The IP range to be added the Amazon Redshift security group.</p>
    pub cidrip: Option<String>,
    /// <p>The name of the security group to which the ingress rule is added.</p>
    pub cluster_security_group_name: String,
    /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
    pub ec2_security_group_name: Option<String>,
    /// <p>The AWS account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i> parameter. The AWS Access Key ID is not an acceptable value. </p> <p>Example: <code>111122223333</code> </p>
    pub ec2_security_group_owner_id: Option<String>,
}

/// Serialize `AuthorizeClusterSecurityGroupIngressMessage` contents to a `SignedRequest`.
struct AuthorizeClusterSecurityGroupIngressMessageSerializer;
impl AuthorizeClusterSecurityGroupIngressMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &AuthorizeClusterSecurityGroupIngressMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cidrip {
            params.put(&format!("{}{}", prefix, "CIDRIP"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClusterSecurityGroupName"),
            &obj.cluster_security_group_name,
        );
        if let Some(ref field_value) = obj.ec2_security_group_name {
            params.put(
                &format!("{}{}", prefix, "EC2SecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.ec2_security_group_owner_id {
            params.put(
                &format!("{}{}", prefix, "EC2SecurityGroupOwnerId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AuthorizeClusterSecurityGroupIngressResult {
    pub cluster_security_group: Option<ClusterSecurityGroup>,
}

#[allow(dead_code)]
struct AuthorizeClusterSecurityGroupIngressResultDeserializer;
impl AuthorizeClusterSecurityGroupIngressResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AuthorizeClusterSecurityGroupIngressResult, XmlParseError> {
        deserialize_elements::<_, AuthorizeClusterSecurityGroupIngressResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSecurityGroup" => {
                        obj.cluster_security_group =
                            Some(ClusterSecurityGroupDeserializer::deserialize(
                                "ClusterSecurityGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeEndpointAccessMessage {
    /// <p>The AWS account ID to grant access to.</p>
    pub account: String,
    /// <p>The cluster identifier of the cluster to grant access to.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
    pub vpc_ids: Option<Vec<String>>,
}

/// Serialize `AuthorizeEndpointAccessMessage` contents to a `SignedRequest`.
struct AuthorizeEndpointAccessMessageSerializer;
impl AuthorizeEndpointAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AuthorizeEndpointAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Account"), &obj.account);
        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_ids {
            VpcIdentifierListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcIdentifier"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct AuthorizeSnapshotAccessMessage {
    /// <p>The identifier of the AWS customer account authorized to restore the specified snapshot.</p> <p>To share a snapshot with AWS support, specify amazon-redshift-support.</p>
    pub account_with_restore_access: String,
    /// <p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    pub snapshot_cluster_identifier: Option<String>,
    /// <p>The identifier of the snapshot the account is authorized to restore.</p>
    pub snapshot_identifier: String,
}

/// Serialize `AuthorizeSnapshotAccessMessage` contents to a `SignedRequest`.
struct AuthorizeSnapshotAccessMessageSerializer;
impl AuthorizeSnapshotAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &AuthorizeSnapshotAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AccountWithRestoreAccess"),
            &obj.account_with_restore_access,
        );
        if let Some(ref field_value) = obj.snapshot_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "SnapshotClusterIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AuthorizeSnapshotAccessResult {
    pub snapshot: Option<Snapshot>,
}

#[allow(dead_code)]
struct AuthorizeSnapshotAccessResultDeserializer;
impl AuthorizeSnapshotAccessResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AuthorizeSnapshotAccessResult, XmlParseError> {
        deserialize_elements::<_, AuthorizeSnapshotAccessResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Snapshot" => {
                        obj.snapshot = Some(SnapshotDeserializer::deserialize("Snapshot", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes an availability zone.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct AvailabilityZone {
    /// <p>The name of the availability zone.</p>
    pub name: Option<String>,
    /// <p><p/></p>
    pub supported_platforms: Option<Vec<SupportedPlatform>>,
}

#[allow(dead_code)]
struct AvailabilityZoneDeserializer;
impl AvailabilityZoneDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<AvailabilityZone, XmlParseError> {
        deserialize_elements::<_, AvailabilityZone, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Name" => {
                    obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                }
                "SupportedPlatforms" => {
                    obj.supported_platforms.get_or_insert(vec![]).extend(
                        SupportedPlatformsListDeserializer::deserialize(
                            "SupportedPlatforms",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct AvailabilityZoneListDeserializer;
impl AvailabilityZoneListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<AvailabilityZone>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "AvailabilityZone" {
                obj.push(AvailabilityZoneDeserializer::deserialize(
                    "AvailabilityZone",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchDeleteClusterSnapshotsRequest {
    /// <p>A list of identifiers for the snapshots that you want to delete.</p>
    pub identifiers: Vec<DeleteClusterSnapshotMessage>,
}

/// Serialize `BatchDeleteClusterSnapshotsRequest` contents to a `SignedRequest`.
struct BatchDeleteClusterSnapshotsRequestSerializer;
impl BatchDeleteClusterSnapshotsRequestSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &BatchDeleteClusterSnapshotsRequest) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        DeleteClusterSnapshotMessageListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "DeleteClusterSnapshotMessage"),
            &obj.identifiers,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct BatchDeleteClusterSnapshotsResult {
    /// <p>A list of any errors returned.</p>
    pub errors: Option<Vec<SnapshotErrorMessage>>,
    /// <p>A list of the snapshot identifiers that were deleted. </p>
    pub resources: Option<Vec<String>>,
}

#[allow(dead_code)]
struct BatchDeleteClusterSnapshotsResultDeserializer;
impl BatchDeleteClusterSnapshotsResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<BatchDeleteClusterSnapshotsResult, XmlParseError> {
        deserialize_elements::<_, BatchDeleteClusterSnapshotsResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Errors" => {
                        obj.errors.get_or_insert(vec![]).extend(
                            BatchSnapshotOperationErrorListDeserializer::deserialize(
                                "Errors", stack,
                            )?,
                        );
                    }
                    "Resources" => {
                        obj.resources.get_or_insert(vec![]).extend(
                            SnapshotIdentifierListDeserializer::deserialize("Resources", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct BatchModifyClusterSnapshotsMessage {
    /// <p>A boolean value indicating whether to override an exception if the retention period has passed. </p>
    pub force: Option<bool>,
    /// <p>The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is retained indefinitely.</p> <p>The number must be either -1 or an integer between 1 and 3,653.</p> <p>If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall outside of the new retention period will return an error. If you want to suppress the errors and delete the snapshots, use the force option. </p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>A list of snapshot identifiers you want to modify.</p>
    pub snapshot_identifier_list: Vec<String>,
}

/// Serialize `BatchModifyClusterSnapshotsMessage` contents to a `SignedRequest`.
struct BatchModifyClusterSnapshotsMessageSerializer;
impl BatchModifyClusterSnapshotsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &BatchModifyClusterSnapshotsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.force {
            params.put(&format!("{}{}", prefix, "Force"), &field_value);
        }
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        SnapshotIdentifierListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "String"),
            &obj.snapshot_identifier_list,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct BatchModifyClusterSnapshotsOutputMessage {
    /// <p>A list of any errors returned.</p>
    pub errors: Option<Vec<SnapshotErrorMessage>>,
    /// <p>A list of the snapshots that were modified.</p>
    pub resources: Option<Vec<String>>,
}

#[allow(dead_code)]
struct BatchModifyClusterSnapshotsOutputMessageDeserializer;
impl BatchModifyClusterSnapshotsOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<BatchModifyClusterSnapshotsOutputMessage, XmlParseError> {
        deserialize_elements::<_, BatchModifyClusterSnapshotsOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Errors" => {
                        obj.errors.get_or_insert(vec![]).extend(
                            BatchSnapshotOperationErrorsDeserializer::deserialize("Errors", stack)?,
                        );
                    }
                    "Resources" => {
                        obj.resources.get_or_insert(vec![]).extend(
                            SnapshotIdentifierListDeserializer::deserialize("Resources", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct BatchSnapshotOperationErrorListDeserializer;
impl BatchSnapshotOperationErrorListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SnapshotErrorMessage>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SnapshotErrorMessage" {
                obj.push(SnapshotErrorMessageDeserializer::deserialize(
                    "SnapshotErrorMessage",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct BatchSnapshotOperationErrorsDeserializer;
impl BatchSnapshotOperationErrorsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SnapshotErrorMessage>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SnapshotErrorMessage" {
                obj.push(SnapshotErrorMessageDeserializer::deserialize(
                    "SnapshotErrorMessage",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct BooleanDeserializer;
impl BooleanDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct BooleanOptionalDeserializer;
impl BooleanOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<bool, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(bool::from_str(&s).unwrap()))
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CancelResizeMessage {
    /// <p>The unique identifier for the cluster that you want to cancel a resize operation for.</p>
    pub cluster_identifier: String,
}

/// Serialize `CancelResizeMessage` contents to a `SignedRequest`.
struct CancelResizeMessageSerializer;
impl CancelResizeMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CancelResizeMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

/// <p>Describes a cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Cluster {
    /// <p>A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
    pub allow_version_upgrade: Option<bool>,
    /// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
    pub aqua_configuration: Option<AquaConfiguration>,
    /// <p>The number of days that automatic cluster snapshots are retained.</p>
    pub automated_snapshot_retention_period: Option<i64>,
    /// <p>The name of the Availability Zone in which the cluster is located.</p>
    pub availability_zone: Option<String>,
    /// <p>Describes the status of the Availability Zone relocation operation.</p>
    pub availability_zone_relocation_status: Option<String>,
    /// <p><p>The availability status of the cluster for queries. Possible values are the following:</p> <ul> <li> <p>Available - The cluster is available for queries. </p> </li> <li> <p>Unavailable - The cluster is not available for queries.</p> </li> <li> <p>Maintenance - The cluster is intermittently available for queries due to maintenance activities.</p> </li> <li> <p>Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li> <li> <p>Failed - The cluster failed and is not available for queries.</p> </li> </ul></p>
    pub cluster_availability_status: Option<String>,
    /// <p>The date and time that the cluster was created.</p>
    pub cluster_create_time: Option<String>,
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The namespace Amazon Resource Name (ARN) of the cluster.</p>
    pub cluster_namespace_arn: Option<String>,
    /// <p>The nodes in the cluster.</p>
    pub cluster_nodes: Option<Vec<ClusterNode>>,
    /// <p>The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.</p>
    pub cluster_parameter_groups: Option<Vec<ClusterParameterGroupStatus>>,
    /// <p>The public key for the cluster.</p>
    pub cluster_public_key: Option<String>,
    /// <p>The specific revision number of the database in the cluster.</p>
    pub cluster_revision_number: Option<String>,
    /// <p>A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code> subelements. </p> <p>Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b> parameter. </p>
    pub cluster_security_groups: Option<Vec<ClusterSecurityGroupMembership>>,
    /// <p>A value that returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
    pub cluster_snapshot_copy_status: Option<ClusterSnapshotCopyStatus>,
    /// <p><p> The current state of the cluster. Possible values are the following:</p> <ul> <li> <p> <code>available</code> </p> </li> <li> <p> <code>available, prep-for-resize</code> </p> </li> <li> <p> <code>available, resize-cleanup</code> </p> </li> <li> <p> <code>cancelling-resize</code> </p> </li> <li> <p> <code>creating</code> </p> </li> <li> <p> <code>deleting</code> </p> </li> <li> <p> <code>final-snapshot</code> </p> </li> <li> <p> <code>hardware-failure</code> </p> </li> <li> <p> <code>incompatible-hsm</code> </p> </li> <li> <p> <code>incompatible-network</code> </p> </li> <li> <p> <code>incompatible-parameters</code> </p> </li> <li> <p> <code>incompatible-restore</code> </p> </li> <li> <p> <code>modifying</code> </p> </li> <li> <p> <code>paused</code> </p> </li> <li> <p> <code>rebooting</code> </p> </li> <li> <p> <code>renaming</code> </p> </li> <li> <p> <code>resizing</code> </p> </li> <li> <p> <code>rotating-keys</code> </p> </li> <li> <p> <code>storage-full</code> </p> </li> <li> <p> <code>updating-hsm</code> </p> </li> </ul></p>
    pub cluster_status: Option<String>,
    /// <p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>
    pub cluster_subnet_group_name: Option<String>,
    /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
    pub cluster_version: Option<String>,
    /// <p>The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was created by default. </p>
    pub db_name: Option<String>,
    /// <p><p/></p>
    pub data_transfer_progress: Option<DataTransferProgress>,
    /// <p>Describes a group of <code>DeferredMaintenanceWindow</code> objects.</p>
    pub deferred_maintenance_windows: Option<Vec<DeferredMaintenanceWindow>>,
    /// <p>The status of the elastic IP (EIP) address.</p>
    pub elastic_ip_status: Option<ElasticIpStatus>,
    /// <p>The number of nodes that you can resize the cluster to with the elastic resize method. </p>
    pub elastic_resize_number_of_node_options: Option<String>,
    /// <p>A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.</p>
    pub encrypted: Option<bool>,
    /// <p>The connection endpoint.</p>
    pub endpoint: Option<Endpoint>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>
    pub enhanced_vpc_routing: Option<bool>,
    /// <p>The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled. </p>
    pub expected_next_snapshot_schedule_time: Option<String>,
    /// <p><p> The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:</p> <ul> <li> <p>OnTrack - The next snapshot is expected to be taken on time. </p> </li> <li> <p>Pending - The next snapshot is pending to be taken. </p> </li> </ul></p>
    pub expected_next_snapshot_schedule_time_status: Option<String>,
    /// <p>A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.</p> <p>Values: active, applying</p>
    pub hsm_status: Option<HsmStatus>,
    /// <p>A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services.</p>
    pub iam_roles: Option<Vec<ClusterIamRole>>,
    /// <p>The AWS Key Management Service (AWS KMS) key ID of the encryption key used to encrypt data in the cluster.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the maintenance track for the cluster.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>The master user name for the cluster. This name is used to connect to the database that is specified in the <b>DBName</b> parameter. </p>
    pub master_username: Option<String>,
    /// <p>The status of a modify operation, if any, initiated for the cluster.</p>
    pub modify_status: Option<String>,
    /// <p>The date and time in UTC when system maintenance can begin.</p>
    pub next_maintenance_window_start_time: Option<String>,
    /// <p>The node type for the nodes in the cluster.</p>
    pub node_type: Option<String>,
    /// <p>The number of compute nodes in the cluster.</p>
    pub number_of_nodes: Option<i64>,
    /// <p>Cluster operations that are waiting to be started.</p>
    pub pending_actions: Option<Vec<String>>,
    /// <p>A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.</p>
    pub pending_modified_values: Option<PendingModifiedValues>,
    /// <p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.</p>
    pub publicly_accessible: Option<bool>,
    /// <p><p>Returns the following:</p> <ul> <li> <p>AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.</p> </li> <li> <p>ResizeType: Returns ClassicResize</p> </li> </ul></p>
    pub resize_info: Option<ResizeInfo>,
    /// <p>A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.</p>
    pub restore_status: Option<RestoreStatus>,
    /// <p>A unique identifier for the cluster snapshot schedule.</p>
    pub snapshot_schedule_identifier: Option<String>,
    /// <p>The current state of the cluster snapshot schedule.</p>
    pub snapshot_schedule_state: Option<String>,
    /// <p>The list of tags for the cluster.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The total storage capacity of the cluster in megabytes. </p>
    pub total_storage_capacity_in_mega_bytes: Option<i64>,
    /// <p>The identifier of the VPC the cluster is in, if the cluster is in a VPC.</p>
    pub vpc_id: Option<String>,
    /// <p>A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.</p>
    pub vpc_security_groups: Option<Vec<VpcSecurityGroupMembership>>,
}

#[allow(dead_code)]
struct ClusterDeserializer;
impl ClusterDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Cluster, XmlParseError> {
        deserialize_elements::<_, Cluster, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowVersionUpgrade" => {
                    obj.allow_version_upgrade = Some(BooleanDeserializer::deserialize(
                        "AllowVersionUpgrade",
                        stack,
                    )?);
                }
                "AquaConfiguration" => {
                    obj.aqua_configuration = Some(AquaConfigurationDeserializer::deserialize(
                        "AquaConfiguration",
                        stack,
                    )?);
                }
                "AutomatedSnapshotRetentionPeriod" => {
                    obj.automated_snapshot_retention_period =
                        Some(IntegerDeserializer::deserialize(
                            "AutomatedSnapshotRetentionPeriod",
                            stack,
                        )?);
                }
                "AvailabilityZone" => {
                    obj.availability_zone =
                        Some(StringDeserializer::deserialize("AvailabilityZone", stack)?);
                }
                "AvailabilityZoneRelocationStatus" => {
                    obj.availability_zone_relocation_status = Some(
                        StringDeserializer::deserialize("AvailabilityZoneRelocationStatus", stack)?,
                    );
                }
                "ClusterAvailabilityStatus" => {
                    obj.cluster_availability_status = Some(StringDeserializer::deserialize(
                        "ClusterAvailabilityStatus",
                        stack,
                    )?);
                }
                "ClusterCreateTime" => {
                    obj.cluster_create_time =
                        Some(TStampDeserializer::deserialize("ClusterCreateTime", stack)?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "ClusterNamespaceArn" => {
                    obj.cluster_namespace_arn = Some(StringDeserializer::deserialize(
                        "ClusterNamespaceArn",
                        stack,
                    )?);
                }
                "ClusterNodes" => {
                    obj.cluster_nodes.get_or_insert(vec![]).extend(
                        ClusterNodesListDeserializer::deserialize("ClusterNodes", stack)?,
                    );
                }
                "ClusterParameterGroups" => {
                    obj.cluster_parameter_groups.get_or_insert(vec![]).extend(
                        ClusterParameterGroupStatusListDeserializer::deserialize(
                            "ClusterParameterGroups",
                            stack,
                        )?,
                    );
                }
                "ClusterPublicKey" => {
                    obj.cluster_public_key =
                        Some(StringDeserializer::deserialize("ClusterPublicKey", stack)?);
                }
                "ClusterRevisionNumber" => {
                    obj.cluster_revision_number = Some(StringDeserializer::deserialize(
                        "ClusterRevisionNumber",
                        stack,
                    )?);
                }
                "ClusterSecurityGroups" => {
                    obj.cluster_security_groups.get_or_insert(vec![]).extend(
                        ClusterSecurityGroupMembershipListDeserializer::deserialize(
                            "ClusterSecurityGroups",
                            stack,
                        )?,
                    );
                }
                "ClusterSnapshotCopyStatus" => {
                    obj.cluster_snapshot_copy_status =
                        Some(ClusterSnapshotCopyStatusDeserializer::deserialize(
                            "ClusterSnapshotCopyStatus",
                            stack,
                        )?);
                }
                "ClusterStatus" => {
                    obj.cluster_status =
                        Some(StringDeserializer::deserialize("ClusterStatus", stack)?);
                }
                "ClusterSubnetGroupName" => {
                    obj.cluster_subnet_group_name = Some(StringDeserializer::deserialize(
                        "ClusterSubnetGroupName",
                        stack,
                    )?);
                }
                "ClusterVersion" => {
                    obj.cluster_version =
                        Some(StringDeserializer::deserialize("ClusterVersion", stack)?);
                }
                "DBName" => {
                    obj.db_name = Some(StringDeserializer::deserialize("DBName", stack)?);
                }
                "DataTransferProgress" => {
                    obj.data_transfer_progress =
                        Some(DataTransferProgressDeserializer::deserialize(
                            "DataTransferProgress",
                            stack,
                        )?);
                }
                "DeferredMaintenanceWindows" => {
                    obj.deferred_maintenance_windows
                        .get_or_insert(vec![])
                        .extend(DeferredMaintenanceWindowsListDeserializer::deserialize(
                            "DeferredMaintenanceWindows",
                            stack,
                        )?);
                }
                "ElasticIpStatus" => {
                    obj.elastic_ip_status = Some(ElasticIpStatusDeserializer::deserialize(
                        "ElasticIpStatus",
                        stack,
                    )?);
                }
                "ElasticResizeNumberOfNodeOptions" => {
                    obj.elastic_resize_number_of_node_options = Some(
                        StringDeserializer::deserialize("ElasticResizeNumberOfNodeOptions", stack)?,
                    );
                }
                "Encrypted" => {
                    obj.encrypted = Some(BooleanDeserializer::deserialize("Encrypted", stack)?);
                }
                "Endpoint" => {
                    obj.endpoint = Some(EndpointDeserializer::deserialize("Endpoint", stack)?);
                }
                "EnhancedVpcRouting" => {
                    obj.enhanced_vpc_routing = Some(BooleanDeserializer::deserialize(
                        "EnhancedVpcRouting",
                        stack,
                    )?);
                }
                "ExpectedNextSnapshotScheduleTime" => {
                    obj.expected_next_snapshot_schedule_time = Some(
                        TStampDeserializer::deserialize("ExpectedNextSnapshotScheduleTime", stack)?,
                    );
                }
                "ExpectedNextSnapshotScheduleTimeStatus" => {
                    obj.expected_next_snapshot_schedule_time_status =
                        Some(StringDeserializer::deserialize(
                            "ExpectedNextSnapshotScheduleTimeStatus",
                            stack,
                        )?);
                }
                "HsmStatus" => {
                    obj.hsm_status = Some(HsmStatusDeserializer::deserialize("HsmStatus", stack)?);
                }
                "IamRoles" => {
                    obj.iam_roles.get_or_insert(vec![]).extend(
                        ClusterIamRoleListDeserializer::deserialize("IamRoles", stack)?,
                    );
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "MaintenanceTrackName" => {
                    obj.maintenance_track_name = Some(StringDeserializer::deserialize(
                        "MaintenanceTrackName",
                        stack,
                    )?);
                }
                "ManualSnapshotRetentionPeriod" => {
                    obj.manual_snapshot_retention_period = Some(IntegerDeserializer::deserialize(
                        "ManualSnapshotRetentionPeriod",
                        stack,
                    )?);
                }
                "MasterUsername" => {
                    obj.master_username =
                        Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                }
                "ModifyStatus" => {
                    obj.modify_status =
                        Some(StringDeserializer::deserialize("ModifyStatus", stack)?);
                }
                "NextMaintenanceWindowStartTime" => {
                    obj.next_maintenance_window_start_time = Some(TStampDeserializer::deserialize(
                        "NextMaintenanceWindowStartTime",
                        stack,
                    )?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                "NumberOfNodes" => {
                    obj.number_of_nodes =
                        Some(IntegerDeserializer::deserialize("NumberOfNodes", stack)?);
                }
                "PendingActions" => {
                    obj.pending_actions.get_or_insert(vec![]).extend(
                        PendingActionsListDeserializer::deserialize("PendingActions", stack)?,
                    );
                }
                "PendingModifiedValues" => {
                    obj.pending_modified_values =
                        Some(PendingModifiedValuesDeserializer::deserialize(
                            "PendingModifiedValues",
                            stack,
                        )?);
                }
                "PreferredMaintenanceWindow" => {
                    obj.preferred_maintenance_window = Some(StringDeserializer::deserialize(
                        "PreferredMaintenanceWindow",
                        stack,
                    )?);
                }
                "PubliclyAccessible" => {
                    obj.publicly_accessible = Some(BooleanDeserializer::deserialize(
                        "PubliclyAccessible",
                        stack,
                    )?);
                }
                "ResizeInfo" => {
                    obj.resize_info =
                        Some(ResizeInfoDeserializer::deserialize("ResizeInfo", stack)?);
                }
                "RestoreStatus" => {
                    obj.restore_status = Some(RestoreStatusDeserializer::deserialize(
                        "RestoreStatus",
                        stack,
                    )?);
                }
                "SnapshotScheduleIdentifier" => {
                    obj.snapshot_schedule_identifier = Some(StringDeserializer::deserialize(
                        "SnapshotScheduleIdentifier",
                        stack,
                    )?);
                }
                "SnapshotScheduleState" => {
                    obj.snapshot_schedule_state = Some(ScheduleStateDeserializer::deserialize(
                        "SnapshotScheduleState",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                "TotalStorageCapacityInMegaBytes" => {
                    obj.total_storage_capacity_in_mega_bytes =
                        Some(LongOptionalDeserializer::deserialize(
                            "TotalStorageCapacityInMegaBytes",
                            stack,
                        )?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                "VpcSecurityGroups" => {
                    obj.vpc_security_groups.get_or_insert(vec![]).extend(
                        VpcSecurityGroupMembershipListDeserializer::deserialize(
                            "VpcSecurityGroups",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterAssociatedToSchedule {
    /// <p><p/></p>
    pub cluster_identifier: Option<String>,
    /// <p><p/></p>
    pub schedule_association_state: Option<String>,
}

#[allow(dead_code)]
struct ClusterAssociatedToScheduleDeserializer;
impl ClusterAssociatedToScheduleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterAssociatedToSchedule, XmlParseError> {
        deserialize_elements::<_, ClusterAssociatedToSchedule, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterIdentifier" => {
                        obj.cluster_identifier =
                            Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                    }
                    "ScheduleAssociationState" => {
                        obj.schedule_association_state =
                            Some(ScheduleStateDeserializer::deserialize(
                                "ScheduleAssociationState",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Temporary credentials with authorization to log on to an Amazon Redshift database. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterCredentials {
    /// <p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>
    pub db_password: Option<String>,
    /// <p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>
    pub db_user: Option<String>,
    /// <p>The date and time the password in <code>DbPassword</code> expires.</p>
    pub expiration: Option<String>,
}

#[allow(dead_code)]
struct ClusterCredentialsDeserializer;
impl ClusterCredentialsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterCredentials, XmlParseError> {
        deserialize_elements::<_, ClusterCredentials, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DbPassword" => {
                    obj.db_password = Some(SensitiveStringDeserializer::deserialize(
                        "DbPassword",
                        stack,
                    )?);
                }
                "DbUser" => {
                    obj.db_user = Some(StringDeserializer::deserialize("DbUser", stack)?);
                }
                "Expiration" => {
                    obj.expiration = Some(TStampDeserializer::deserialize("Expiration", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a <code>ClusterDbRevision</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterDbRevision {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_identifier: Option<String>,
    /// <p>A string representing the current cluster version.</p>
    pub current_database_revision: Option<String>,
    /// <p>The date on which the database revision was released.</p>
    pub database_revision_release_date: Option<String>,
    /// <p>A list of <code>RevisionTarget</code> objects, where each object describes the database revision that a cluster can be updated to.</p>
    pub revision_targets: Option<Vec<RevisionTarget>>,
}

#[allow(dead_code)]
struct ClusterDbRevisionDeserializer;
impl ClusterDbRevisionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterDbRevision, XmlParseError> {
        deserialize_elements::<_, ClusterDbRevision, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "CurrentDatabaseRevision" => {
                    obj.current_database_revision = Some(StringDeserializer::deserialize(
                        "CurrentDatabaseRevision",
                        stack,
                    )?);
                }
                "DatabaseRevisionReleaseDate" => {
                    obj.database_revision_release_date = Some(TStampDeserializer::deserialize(
                        "DatabaseRevisionReleaseDate",
                        stack,
                    )?);
                }
                "RevisionTargets" => {
                    obj.revision_targets.get_or_insert(vec![]).extend(
                        RevisionTargetsListDeserializer::deserialize("RevisionTargets", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClusterDbRevisionsListDeserializer;
impl ClusterDbRevisionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterDbRevision>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterDbRevision" {
                obj.push(ClusterDbRevisionDeserializer::deserialize(
                    "ClusterDbRevision",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterDbRevisionsMessage {
    /// <p>A list of revisions.</p>
    pub cluster_db_revisions: Option<Vec<ClusterDbRevision>>,
    /// <p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ClusterDbRevisionsMessageDeserializer;
impl ClusterDbRevisionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterDbRevisionsMessage, XmlParseError> {
        deserialize_elements::<_, ClusterDbRevisionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterDbRevisions" => {
                        obj.cluster_db_revisions.get_or_insert(vec![]).extend(
                            ClusterDbRevisionsListDeserializer::deserialize(
                                "ClusterDbRevisions",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>An AWS Identity and Access Management (IAM) role that can be used by the associated Amazon Redshift cluster to access other AWS services.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterIamRole {
    /// <p><p>A value that describes the status of the IAM role&#39;s association with an Amazon Redshift cluster.</p> <p>The following are possible statuses and descriptions.</p> <ul> <li> <p> <code>in-sync</code>: The role is available for use by the cluster.</p> </li> <li> <p> <code>adding</code>: The role is in the process of being associated with the cluster.</p> </li> <li> <p> <code>removing</code>: The role is in the process of being disassociated with the cluster.</p> </li> </ul></p>
    pub apply_status: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role, for example, <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>. </p>
    pub iam_role_arn: Option<String>,
}

#[allow(dead_code)]
struct ClusterIamRoleDeserializer;
impl ClusterIamRoleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterIamRole, XmlParseError> {
        deserialize_elements::<_, ClusterIamRole, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ApplyStatus" => {
                    obj.apply_status = Some(StringDeserializer::deserialize("ApplyStatus", stack)?);
                }
                "IamRoleArn" => {
                    obj.iam_role_arn = Some(StringDeserializer::deserialize("IamRoleArn", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClusterIamRoleListDeserializer;
impl ClusterIamRoleListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterIamRole>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterIamRole" {
                obj.push(ClusterIamRoleDeserializer::deserialize(
                    "ClusterIamRole",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClusterListDeserializer;
impl ClusterListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Cluster>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Cluster" {
                obj.push(ClusterDeserializer::deserialize("Cluster", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>The identifier of a node in a cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterNode {
    /// <p>Whether the node is a leader node or a compute node.</p>
    pub node_role: Option<String>,
    /// <p>The private IP address of a node within a cluster.</p>
    pub private_ip_address: Option<String>,
    /// <p>The public IP address of a node within a cluster.</p>
    pub public_ip_address: Option<String>,
}

#[allow(dead_code)]
struct ClusterNodeDeserializer;
impl ClusterNodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterNode, XmlParseError> {
        deserialize_elements::<_, ClusterNode, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "NodeRole" => {
                    obj.node_role = Some(StringDeserializer::deserialize("NodeRole", stack)?);
                }
                "PrivateIPAddress" => {
                    obj.private_ip_address =
                        Some(StringDeserializer::deserialize("PrivateIPAddress", stack)?);
                }
                "PublicIPAddress" => {
                    obj.public_ip_address =
                        Some(StringDeserializer::deserialize("PublicIPAddress", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClusterNodesListDeserializer;
impl ClusterNodesListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterNode>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ClusterNodeDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a parameter group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterParameterGroup {
    /// <p>The description of the parameter group.</p>
    pub description: Option<String>,
    /// <p>The name of the cluster parameter group family that this cluster parameter group is compatible with.</p>
    pub parameter_group_family: Option<String>,
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: Option<String>,
    /// <p>The list of tags for the cluster parameter group.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct ClusterParameterGroupDeserializer;
impl ClusterParameterGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterParameterGroup, XmlParseError> {
        deserialize_elements::<_, ClusterParameterGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "ParameterGroupFamily" => {
                    obj.parameter_group_family = Some(StringDeserializer::deserialize(
                        "ParameterGroupFamily",
                        stack,
                    )?);
                }
                "ParameterGroupName" => {
                    obj.parameter_group_name = Some(StringDeserializer::deserialize(
                        "ParameterGroupName",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeClusterParameters</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterParameterGroupDetails {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>A list of <a>Parameter</a> instances. Each instance lists the parameters of one cluster parameter group. </p>
    pub parameters: Option<Vec<Parameter>>,
}

#[allow(dead_code)]
struct ClusterParameterGroupDetailsDeserializer;
impl ClusterParameterGroupDetailsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterParameterGroupDetails, XmlParseError> {
        deserialize_elements::<_, ClusterParameterGroupDetails, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "Parameters" => {
                        obj.parameters.get_or_insert(vec![]).extend(
                            ParametersListDeserializer::deserialize("Parameters", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterParameterGroupNameMessage {
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: Option<String>,
    /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    pub parameter_group_status: Option<String>,
}

#[allow(dead_code)]
struct ClusterParameterGroupNameMessageDeserializer;
impl ClusterParameterGroupNameMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterParameterGroupNameMessage, XmlParseError> {
        deserialize_elements::<_, ClusterParameterGroupNameMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ParameterGroupName" => {
                        obj.parameter_group_name = Some(StringDeserializer::deserialize(
                            "ParameterGroupName",
                            stack,
                        )?);
                    }
                    "ParameterGroupStatus" => {
                        obj.parameter_group_status = Some(StringDeserializer::deserialize(
                            "ParameterGroupStatus",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the status of a parameter group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterParameterGroupStatus {
    /// <p>The list of parameter statuses.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    pub cluster_parameter_status_list: Option<Vec<ClusterParameterStatus>>,
    /// <p>The status of parameter updates.</p>
    pub parameter_apply_status: Option<String>,
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: Option<String>,
}

#[allow(dead_code)]
struct ClusterParameterGroupStatusDeserializer;
impl ClusterParameterGroupStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterParameterGroupStatus, XmlParseError> {
        deserialize_elements::<_, ClusterParameterGroupStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterParameterStatusList" => {
                        obj.cluster_parameter_status_list
                            .get_or_insert(vec![])
                            .extend(ClusterParameterStatusListDeserializer::deserialize(
                                "ClusterParameterStatusList",
                                stack,
                            )?);
                    }
                    "ParameterApplyStatus" => {
                        obj.parameter_apply_status = Some(StringDeserializer::deserialize(
                            "ParameterApplyStatus",
                            stack,
                        )?);
                    }
                    "ParameterGroupName" => {
                        obj.parameter_group_name = Some(StringDeserializer::deserialize(
                            "ParameterGroupName",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClusterParameterGroupStatusListDeserializer;
impl ClusterParameterGroupStatusListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterParameterGroupStatus>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterParameterGroup" {
                obj.push(ClusterParameterGroupStatusDeserializer::deserialize(
                    "ClusterParameterGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeClusterParameterGroups</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterParameterGroupsMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group. </p>
    pub parameter_groups: Option<Vec<ClusterParameterGroup>>,
}

#[allow(dead_code)]
struct ClusterParameterGroupsMessageDeserializer;
impl ClusterParameterGroupsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterParameterGroupsMessage, XmlParseError> {
        deserialize_elements::<_, ClusterParameterGroupsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ParameterGroups" => {
                        obj.parameter_groups.get_or_insert(vec![]).extend(
                            ParameterGroupListDeserializer::deserialize("ParameterGroups", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the status of a parameter group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterParameterStatus {
    /// <p>The error that prevented the parameter from being applied to the database.</p>
    pub parameter_apply_error_description: Option<String>,
    /// <p><p>The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.</p> <p>The following are possible statuses and descriptions.</p> <ul> <li> <p> <code>in-sync</code>: The parameter value is in sync with the database.</p> </li> <li> <p> <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.</p> </li> <li> <p> <code>applying</code>: The parameter value is being applied to the database.</p> </li> <li> <p> <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.</p> </li> <li> <p> <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the cluster reboots.</p> </li> <li> <p> <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.</p> </li> <li> <p> <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.</p> </li> </ul></p>
    pub parameter_apply_status: Option<String>,
    /// <p>The name of the parameter.</p>
    pub parameter_name: Option<String>,
}

#[allow(dead_code)]
struct ClusterParameterStatusDeserializer;
impl ClusterParameterStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterParameterStatus, XmlParseError> {
        deserialize_elements::<_, ClusterParameterStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ParameterApplyErrorDescription" => {
                    obj.parameter_apply_error_description = Some(StringDeserializer::deserialize(
                        "ParameterApplyErrorDescription",
                        stack,
                    )?);
                }
                "ParameterApplyStatus" => {
                    obj.parameter_apply_status = Some(StringDeserializer::deserialize(
                        "ParameterApplyStatus",
                        stack,
                    )?);
                }
                "ParameterName" => {
                    obj.parameter_name =
                        Some(StringDeserializer::deserialize("ParameterName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClusterParameterStatusListDeserializer;
impl ClusterParameterStatusListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterParameterStatus>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(ClusterParameterStatusDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a security group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterSecurityGroup {
    /// <p>The name of the cluster security group to which the operation was applied.</p>
    pub cluster_security_group_name: Option<String>,
    /// <p>A description of the security group.</p>
    pub description: Option<String>,
    /// <p>A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.</p>
    pub ec2_security_groups: Option<Vec<EC2SecurityGroup>>,
    /// <p>A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security group.</p>
    pub ip_ranges: Option<Vec<IPRange>>,
    /// <p>The list of tags for the cluster security group.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct ClusterSecurityGroupDeserializer;
impl ClusterSecurityGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterSecurityGroup, XmlParseError> {
        deserialize_elements::<_, ClusterSecurityGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterSecurityGroupName" => {
                    obj.cluster_security_group_name = Some(StringDeserializer::deserialize(
                        "ClusterSecurityGroupName",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "EC2SecurityGroups" => {
                    obj.ec2_security_groups.get_or_insert(vec![]).extend(
                        EC2SecurityGroupListDeserializer::deserialize("EC2SecurityGroups", stack)?,
                    );
                }
                "IPRanges" => {
                    obj.ip_ranges
                        .get_or_insert(vec![])
                        .extend(IPRangeListDeserializer::deserialize("IPRanges", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a cluster security group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterSecurityGroupMembership {
    /// <p>The name of the cluster security group.</p>
    pub cluster_security_group_name: Option<String>,
    /// <p>The status of the cluster security group.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct ClusterSecurityGroupMembershipDeserializer;
impl ClusterSecurityGroupMembershipDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterSecurityGroupMembership, XmlParseError> {
        deserialize_elements::<_, ClusterSecurityGroupMembership, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSecurityGroupName" => {
                        obj.cluster_security_group_name = Some(StringDeserializer::deserialize(
                            "ClusterSecurityGroupName",
                            stack,
                        )?);
                    }
                    "Status" => {
                        obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClusterSecurityGroupMembershipListDeserializer;
impl ClusterSecurityGroupMembershipListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterSecurityGroupMembership>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterSecurityGroup" {
                obj.push(ClusterSecurityGroupMembershipDeserializer::deserialize(
                    "ClusterSecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterSecurityGroupMessage {
    /// <p>A list of <a>ClusterSecurityGroup</a> instances. </p>
    pub cluster_security_groups: Option<Vec<ClusterSecurityGroup>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ClusterSecurityGroupMessageDeserializer;
impl ClusterSecurityGroupMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterSecurityGroupMessage, XmlParseError> {
        deserialize_elements::<_, ClusterSecurityGroupMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSecurityGroups" => {
                        obj.cluster_security_groups.get_or_insert(vec![]).extend(
                            ClusterSecurityGroupsDeserializer::deserialize(
                                "ClusterSecurityGroups",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}

/// Serialize `ClusterSecurityGroupNameList` contents to a `SignedRequest`.
struct ClusterSecurityGroupNameListSerializer;
impl ClusterSecurityGroupNameListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ClusterSecurityGroupsDeserializer;
impl ClusterSecurityGroupsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterSecurityGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterSecurityGroup" {
                obj.push(ClusterSecurityGroupDeserializer::deserialize(
                    "ClusterSecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterSnapshotCopyStatus {
    /// <p>The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.</p>
    pub destination_region: Option<String>,
    /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region.</p>
    pub retention_period: Option<i64>,
    /// <p>The name of the snapshot copy grant.</p>
    pub snapshot_copy_grant_name: Option<String>,
}

#[allow(dead_code)]
struct ClusterSnapshotCopyStatusDeserializer;
impl ClusterSnapshotCopyStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterSnapshotCopyStatus, XmlParseError> {
        deserialize_elements::<_, ClusterSnapshotCopyStatus, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DestinationRegion" => {
                        obj.destination_region =
                            Some(StringDeserializer::deserialize("DestinationRegion", stack)?);
                    }
                    "ManualSnapshotRetentionPeriod" => {
                        obj.manual_snapshot_retention_period =
                            Some(IntegerDeserializer::deserialize(
                                "ManualSnapshotRetentionPeriod",
                                stack,
                            )?);
                    }
                    "RetentionPeriod" => {
                        obj.retention_period =
                            Some(LongDeserializer::deserialize("RetentionPeriod", stack)?);
                    }
                    "SnapshotCopyGrantName" => {
                        obj.snapshot_copy_grant_name = Some(StringDeserializer::deserialize(
                            "SnapshotCopyGrantName",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a subnet group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterSubnetGroup {
    /// <p>The name of the cluster subnet group.</p>
    pub cluster_subnet_group_name: Option<String>,
    /// <p>The description of the cluster subnet group.</p>
    pub description: Option<String>,
    /// <p>The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and <code>Invalid</code>. </p>
    pub subnet_group_status: Option<String>,
    /// <p>A list of the VPC <a>Subnet</a> elements. </p>
    pub subnets: Option<Vec<Subnet>>,
    /// <p>The list of tags for the cluster subnet group.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The VPC ID of the cluster subnet group.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct ClusterSubnetGroupDeserializer;
impl ClusterSubnetGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterSubnetGroup, XmlParseError> {
        deserialize_elements::<_, ClusterSubnetGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterSubnetGroupName" => {
                    obj.cluster_subnet_group_name = Some(StringDeserializer::deserialize(
                        "ClusterSubnetGroupName",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "SubnetGroupStatus" => {
                    obj.subnet_group_status =
                        Some(StringDeserializer::deserialize("SubnetGroupStatus", stack)?);
                }
                "Subnets" => {
                    obj.subnets
                        .get_or_insert(vec![])
                        .extend(SubnetListDeserializer::deserialize("Subnets", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeClusterSubnetGroups</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterSubnetGroupMessage {
    /// <p>A list of <a>ClusterSubnetGroup</a> instances. </p>
    pub cluster_subnet_groups: Option<Vec<ClusterSubnetGroup>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ClusterSubnetGroupMessageDeserializer;
impl ClusterSubnetGroupMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterSubnetGroupMessage, XmlParseError> {
        deserialize_elements::<_, ClusterSubnetGroupMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSubnetGroups" => {
                        obj.cluster_subnet_groups.get_or_insert(vec![]).extend(
                            ClusterSubnetGroupsDeserializer::deserialize(
                                "ClusterSubnetGroups",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ClusterSubnetGroupsDeserializer;
impl ClusterSubnetGroupsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterSubnetGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterSubnetGroup" {
                obj.push(ClusterSubnetGroupDeserializer::deserialize(
                    "ClusterSubnetGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a cluster version, including the parameter group family and description of the version.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterVersion {
    /// <p>The name of the cluster parameter group family for the cluster.</p>
    pub cluster_parameter_group_family: Option<String>,
    /// <p>The version number used by the cluster.</p>
    pub cluster_version: Option<String>,
    /// <p>The description of the cluster version.</p>
    pub description: Option<String>,
}

#[allow(dead_code)]
struct ClusterVersionDeserializer;
impl ClusterVersionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterVersion, XmlParseError> {
        deserialize_elements::<_, ClusterVersion, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterParameterGroupFamily" => {
                    obj.cluster_parameter_group_family = Some(StringDeserializer::deserialize(
                        "ClusterParameterGroupFamily",
                        stack,
                    )?);
                }
                "ClusterVersion" => {
                    obj.cluster_version =
                        Some(StringDeserializer::deserialize("ClusterVersion", stack)?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ClusterVersionListDeserializer;
impl ClusterVersionListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterVersion>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterVersion" {
                obj.push(ClusterVersionDeserializer::deserialize(
                    "ClusterVersion",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeClusterVersions</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClusterVersionsMessage {
    /// <p>A list of <code>Version</code> elements. </p>
    pub cluster_versions: Option<Vec<ClusterVersion>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ClusterVersionsMessageDeserializer;
impl ClusterVersionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClusterVersionsMessage, XmlParseError> {
        deserialize_elements::<_, ClusterVersionsMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterVersions" => {
                    obj.cluster_versions.get_or_insert(vec![]).extend(
                        ClusterVersionListDeserializer::deserialize("ClusterVersions", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeClusters</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ClustersMessage {
    /// <p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>
    pub clusters: Option<Vec<Cluster>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct ClustersMessageDeserializer;
impl ClustersMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ClustersMessage, XmlParseError> {
        deserialize_elements::<_, ClustersMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Clusters" => {
                    obj.clusters
                        .get_or_insert(vec![])
                        .extend(ClusterListDeserializer::deserialize("Clusters", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CopyClusterSnapshotMessage {
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p><p>The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier for a valid cluster.</p> </li> </ul></p>
    pub source_snapshot_cluster_identifier: Option<String>,
    /// <p><p>The identifier for the source snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier for a valid automated snapshot whose state is <code>available</code>.</p> </li> </ul></p>
    pub source_snapshot_identifier: String,
    /// <p><p>The identifier given to the new manual snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank.</p> </li> <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for the AWS account that is making the request.</p> </li> </ul></p>
    pub target_snapshot_identifier: String,
}

/// Serialize `CopyClusterSnapshotMessage` contents to a `SignedRequest`.
struct CopyClusterSnapshotMessageSerializer;
impl CopyClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CopyClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.source_snapshot_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "SourceSnapshotClusterIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SourceSnapshotIdentifier"),
            &obj.source_snapshot_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "TargetSnapshotIdentifier"),
            &obj.target_snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CopyClusterSnapshotResult {
    pub snapshot: Option<Snapshot>,
}

#[allow(dead_code)]
struct CopyClusterSnapshotResultDeserializer;
impl CopyClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CopyClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, CopyClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Snapshot" => {
                        obj.snapshot = Some(SnapshotDeserializer::deserialize("Snapshot", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClusterMessage {
    /// <p>Reserved.</p>
    pub additional_info: Option<String>,
    /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.</p> <p>When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.</p> <p>Default: <code>true</code> </p>
    pub allow_version_upgrade: Option<bool>,
    /// <p><p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don&#39;t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul></p>
    pub aqua_configuration_status: Option<String>,
    /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p> <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p> <p>Default: <code>1</code> </p> <p>Constraints: Must be a value from 0 to 35.</p>
    pub automated_snapshot_retention_period: Option<i64>,
    /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.</p> <p>Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.</p> <p>Example: <code>us-east-2d</code> </p> <p>Constraint: The specified Availability Zone must be in the same region as the current endpoint.</p>
    pub availability_zone: Option<String>,
    /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
    pub availability_zone_relocation: Option<bool>,
    /// <p>A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an AWS account.</p> </li> </ul> <p>Example: <code>myexamplecluster</code> </p>
    pub cluster_identifier: String,
    /// <p><p>The name of the parameter group to be associated with this cluster.</p> <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a> </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub cluster_parameter_group_name: Option<String>,
    /// <p>A list of security groups to be associated with this cluster.</p> <p>Default: The default cluster security group for Amazon Redshift.</p>
    pub cluster_security_groups: Option<Vec<String>>,
    /// <p>The name of a cluster subnet group to be associated with this cluster.</p> <p>If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).</p>
    pub cluster_subnet_group_name: Option<String>,
    /// <p>The type of the cluster. When cluster type is specified as</p> <ul> <li> <p> <code>single-node</code>, the <b>NumberOfNodes</b> parameter is not required.</p> </li> <li> <p> <code>multi-node</code>, the <b>NumberOfNodes</b> parameter is required.</p> </li> </ul> <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p> <p>Default: <code>multi-node</code> </p>
    pub cluster_type: Option<String>,
    /// <p>The version of the Amazon Redshift engine software that you want to deploy on the cluster.</p> <p>The version selected runs on all the nodes in the cluster.</p> <p>Constraints: Only version 1.0 is currently available.</p> <p>Example: <code>1.0</code> </p>
    pub cluster_version: Option<String>,
    /// <p><p>The name of the first database to be created when the cluster is created.</p> <p>To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide. </p> <p>Default: <code>dev</code> </p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 alphanumeric characters.</p> </li> <li> <p>Must contain only lowercase letters.</p> </li> <li> <p>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li> </ul></p>
    pub db_name: Option<String>,
    /// <p>The Elastic IP (EIP) address for the cluster.</p> <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
    pub elastic_ip: Option<String>,
    /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p> <p>Default: false</p>
    pub encrypted: Option<bool>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>
    pub enhanced_vpc_routing: Option<bool>,
    /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    pub hsm_client_certificate_identifier: Option<String>,
    /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    pub hsm_configuration_identifier: Option<String>,
    /// <p>A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles in a single request.</p> <p>A cluster can have up to 10 IAM roles associated with it at any time.</p>
    pub iam_roles: Option<Vec<String>>,
    /// <p>The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
    pub kms_key_id: Option<String>,
    /// <p>An optional parameter for the name of the maintenance track for the cluster. If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p><p>The password associated with the master user account for the cluster that is being created.</p> <p>Constraints:</p> <ul> <li> <p>Must be between 8 and 64 characters in length.</p> </li> <li> <p>Must contain at least one uppercase letter.</p> </li> <li> <p>Must contain at least one lowercase letter.</p> </li> <li> <p>Must contain one number.</p> </li> <li> <p>Can be any printable ASCII character (ASCII code 33 to 126) except &#39; (single quote), &quot; (double quote), \, /, @, or space.</p> </li> </ul></p>
    pub master_user_password: String,
    /// <p><p>The user name associated with the master user account for the cluster that is being created.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 - 128 alphanumeric characters. The user name can&#39;t be <code>PUBLIC</code>.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li> </ul></p>
    pub master_username: String,
    /// <p>The node type to be provisioned for the cluster. For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p> <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
    pub node_type: String,
    /// <p>The number of compute nodes in the cluster. This parameter is required when the <b>ClusterType</b> parameter is specified as <code>multi-node</code>. </p> <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p> <p>If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.</p> <p>Default: <code>1</code> </p> <p>Constraints: Value must be at least 1 and no more than 100.</p>
    pub number_of_nodes: Option<i64>,
    /// <p>The port number on which the cluster accepts incoming connections.</p> <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.</p> <p>Default: <code>5439</code> </p> <p>Valid Values: <code>1150-65535</code> </p>
    pub port: Option<i64>,
    /// <p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p> Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
    pub publicly_accessible: Option<bool>,
    /// <p>A unique identifier for the snapshot schedule.</p>
    pub snapshot_schedule_identifier: Option<String>,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p> <p>Default: The default VPC security group is associated with the cluster.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `CreateClusterMessage` contents to a `SignedRequest`.
struct CreateClusterMessageSerializer;
impl CreateClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.additional_info {
            params.put(&format!("{}{}", prefix, "AdditionalInfo"), &field_value);
        }
        if let Some(ref field_value) = obj.allow_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AllowVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.aqua_configuration_status {
            params.put(
                &format!("{}{}", prefix, "AquaConfigurationStatus"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.automated_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "AutomatedSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.availability_zone_relocation {
            params.put(
                &format!("{}{}", prefix, "AvailabilityZoneRelocation"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_security_groups {
            ClusterSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClusterSecurityGroupName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_subnet_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterSubnetGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_type {
            params.put(&format!("{}{}", prefix, "ClusterType"), &field_value);
        }
        if let Some(ref field_value) = obj.cluster_version {
            params.put(&format!("{}{}", prefix, "ClusterVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.db_name {
            params.put(&format!("{}{}", prefix, "DBName"), &field_value);
        }
        if let Some(ref field_value) = obj.elastic_ip {
            params.put(&format!("{}{}", prefix, "ElasticIp"), &field_value);
        }
        if let Some(ref field_value) = obj.encrypted {
            params.put(&format!("{}{}", prefix, "Encrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.enhanced_vpc_routing {
            params.put(&format!("{}{}", prefix, "EnhancedVpcRouting"), &field_value);
        }
        if let Some(ref field_value) = obj.hsm_client_certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmClientCertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.hsm_configuration_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmConfigurationIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.iam_roles {
            IamRoleArnListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "IamRoleArn"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.maintenance_track_name {
            params.put(
                &format!("{}{}", prefix, "MaintenanceTrackName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "MasterUserPassword"),
            &obj.master_user_password,
        );
        params.put(
            &format!("{}{}", prefix, "MasterUsername"),
            &obj.master_username,
        );
        params.put(&format!("{}{}", prefix, "NodeType"), &obj.node_type);
        if let Some(ref field_value) = obj.number_of_nodes {
            params.put(&format!("{}{}", prefix, "NumberOfNodes"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_schedule_identifier {
            params.put(
                &format!("{}{}", prefix, "SnapshotScheduleIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClusterParameterGroupMessage {
    /// <p>A description of the parameter group.</p>
    pub description: String,
    /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.</p> <p>To get a list of valid parameter group family names, you can call <a>DescribeClusterParameterGroups</a>. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your AWS account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0". </p>
    pub parameter_group_family: String,
    /// <p><p>The name of the cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique withing your AWS account.</p> </li> </ul> <note> <p>This value is stored as a lower-case string.</p> </note></p>
    pub parameter_group_name: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateClusterParameterGroupMessage` contents to a `SignedRequest`.
struct CreateClusterParameterGroupMessageSerializer;
impl CreateClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        params.put(
            &format!("{}{}", prefix, "ParameterGroupFamily"),
            &obj.parameter_group_family,
        );
        params.put(
            &format!("{}{}", prefix, "ParameterGroupName"),
            &obj.parameter_group_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClusterParameterGroupResult {
    pub cluster_parameter_group: Option<ClusterParameterGroup>,
}

#[allow(dead_code)]
struct CreateClusterParameterGroupResultDeserializer;
impl CreateClusterParameterGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClusterParameterGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateClusterParameterGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterParameterGroup" => {
                        obj.cluster_parameter_group =
                            Some(ClusterParameterGroupDeserializer::deserialize(
                                "ClusterParameterGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct CreateClusterResultDeserializer;
impl CreateClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClusterResult, XmlParseError> {
        deserialize_elements::<_, CreateClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClusterSecurityGroupMessage {
    /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li> <li> <p>Must not be "Default".</p> </li> <li> <p>Must be unique for all security groups that are created by your AWS account.</p> </li> </ul> <p>Example: <code>examplesecuritygroup</code> </p>
    pub cluster_security_group_name: String,
    /// <p>A description for the security group.</p>
    pub description: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateClusterSecurityGroupMessage` contents to a `SignedRequest`.
struct CreateClusterSecurityGroupMessageSerializer;
impl CreateClusterSecurityGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClusterSecurityGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterSecurityGroupName"),
            &obj.cluster_security_group_name,
        );
        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClusterSecurityGroupResult {
    pub cluster_security_group: Option<ClusterSecurityGroup>,
}

#[allow(dead_code)]
struct CreateClusterSecurityGroupResultDeserializer;
impl CreateClusterSecurityGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClusterSecurityGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateClusterSecurityGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSecurityGroup" => {
                        obj.cluster_security_group =
                            Some(ClusterSecurityGroupDeserializer::deserialize(
                                "ClusterSecurityGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClusterSnapshotMessage {
    /// <p>The cluster identifier for which you want a snapshot.</p>
    pub cluster_identifier: String,
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the AWS account.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>
    pub snapshot_identifier: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateClusterSnapshotMessage` contents to a `SignedRequest`.
struct CreateClusterSnapshotMessageSerializer;
impl CreateClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClusterSnapshotResult {
    pub snapshot: Option<Snapshot>,
}

#[allow(dead_code)]
struct CreateClusterSnapshotResultDeserializer;
impl CreateClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, CreateClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Snapshot" => {
                        obj.snapshot = Some(SnapshotDeserializer::deserialize("Snapshot", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateClusterSubnetGroupMessage {
    /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li> <li> <p>Must not be "Default".</p> </li> <li> <p>Must be unique for all subnet groups that are created by your AWS account.</p> </li> </ul> <p>Example: <code>examplesubnetgroup</code> </p>
    pub cluster_subnet_group_name: String,
    /// <p>A description for the subnet group.</p>
    pub description: String,
    /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
    pub subnet_ids: Vec<String>,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateClusterSubnetGroupMessage` contents to a `SignedRequest`.
struct CreateClusterSubnetGroupMessageSerializer;
impl CreateClusterSubnetGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateClusterSubnetGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterSubnetGroupName"),
            &obj.cluster_subnet_group_name,
        );
        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        SubnetIdentifierListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SubnetIdentifier"),
            &obj.subnet_ids,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateClusterSubnetGroupResult {
    pub cluster_subnet_group: Option<ClusterSubnetGroup>,
}

#[allow(dead_code)]
struct CreateClusterSubnetGroupResultDeserializer;
impl CreateClusterSubnetGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateClusterSubnetGroupResult, XmlParseError> {
        deserialize_elements::<_, CreateClusterSubnetGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSubnetGroup" => {
                        obj.cluster_subnet_group =
                            Some(ClusterSubnetGroupDeserializer::deserialize(
                                "ClusterSubnetGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEndpointAccessMessage {
    /// <p>The cluster identifier of the cluster to access.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The Redshift-managed VPC endpoint name.</p> <p>An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.</p>
    pub endpoint_name: String,
    /// <p>The AWS account ID of the owner of the cluster. This is only required if the cluster is in another AWS account.</p>
    pub resource_owner: Option<String>,
    /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
    pub subnet_group_name: String,
    /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `CreateEndpointAccessMessage` contents to a `SignedRequest`.
struct CreateEndpointAccessMessageSerializer;
impl CreateEndpointAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateEndpointAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "EndpointName"), &obj.endpoint_name);
        if let Some(ref field_value) = obj.resource_owner {
            params.put(&format!("{}{}", prefix, "ResourceOwner"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SubnetGroupName"),
            &obj.subnet_group_name,
        );
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateEventSubscriptionMessage {
    /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it. </p>
    pub enabled: Option<bool>,
    /// <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p> <p>Values: configuration, management, monitoring, security</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p> <p>Values: ERROR, INFO</p>
    pub severity: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: String,
    /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p> <p>Example: my-cluster-1, my-cluster-2</p> <p>Example: my-snapshot-20131010</p>
    pub source_ids: Option<Vec<String>>,
    /// <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your AWS account. You must specify a source type in order to specify source IDs.</p> <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
    pub source_type: Option<String>,
    /// <p><p>The name of the event subscription to be created.</p> <p>Constraints:</p> <ul> <li> <p>Cannot be null, empty, or blank.</p> </li> <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub subscription_name: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateEventSubscriptionMessage` contents to a `SignedRequest`.
struct CreateEventSubscriptionMessageSerializer;
impl CreateEventSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateEventSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enabled {
            params.put(&format!("{}{}", prefix, "Enabled"), &field_value);
        }
        if let Some(ref field_value) = obj.event_categories {
            EventCategoriesListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EventCategory"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.severity {
            params.put(&format!("{}{}", prefix, "Severity"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "SnsTopicArn"), &obj.sns_topic_arn);
        if let Some(ref field_value) = obj.source_ids {
            SourceIdsListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SourceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateEventSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct CreateEventSubscriptionResultDeserializer;
impl CreateEventSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateEventSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, CreateEventSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateHsmClientCertificateMessage {
    /// <p>The identifier to be assigned to the new HSM client certificate that the cluster will use to connect to the HSM to use the database encryption keys.</p>
    pub hsm_client_certificate_identifier: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateHsmClientCertificateMessage` contents to a `SignedRequest`.
struct CreateHsmClientCertificateMessageSerializer;
impl CreateHsmClientCertificateMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateHsmClientCertificateMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "HsmClientCertificateIdentifier"),
            &obj.hsm_client_certificate_identifier,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateHsmClientCertificateResult {
    pub hsm_client_certificate: Option<HsmClientCertificate>,
}

#[allow(dead_code)]
struct CreateHsmClientCertificateResultDeserializer;
impl CreateHsmClientCertificateResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateHsmClientCertificateResult, XmlParseError> {
        deserialize_elements::<_, CreateHsmClientCertificateResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "HsmClientCertificate" => {
                        obj.hsm_client_certificate =
                            Some(HsmClientCertificateDeserializer::deserialize(
                                "HsmClientCertificate",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateHsmConfigurationMessage {
    /// <p>A text description of the HSM configuration to be created.</p>
    pub description: String,
    /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
    pub hsm_configuration_identifier: String,
    /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
    pub hsm_ip_address: String,
    /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
    pub hsm_partition_name: String,
    /// <p>The password required to access the HSM partition.</p>
    pub hsm_partition_password: String,
    /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.</p>
    pub hsm_server_public_certificate: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateHsmConfigurationMessage` contents to a `SignedRequest`.
struct CreateHsmConfigurationMessageSerializer;
impl CreateHsmConfigurationMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateHsmConfigurationMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Description"), &obj.description);
        params.put(
            &format!("{}{}", prefix, "HsmConfigurationIdentifier"),
            &obj.hsm_configuration_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "HsmIpAddress"),
            &obj.hsm_ip_address,
        );
        params.put(
            &format!("{}{}", prefix, "HsmPartitionName"),
            &obj.hsm_partition_name,
        );
        params.put(
            &format!("{}{}", prefix, "HsmPartitionPassword"),
            &obj.hsm_partition_password,
        );
        params.put(
            &format!("{}{}", prefix, "HsmServerPublicCertificate"),
            &obj.hsm_server_public_certificate,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateHsmConfigurationResult {
    pub hsm_configuration: Option<HsmConfiguration>,
}

#[allow(dead_code)]
struct CreateHsmConfigurationResultDeserializer;
impl CreateHsmConfigurationResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateHsmConfigurationResult, XmlParseError> {
        deserialize_elements::<_, CreateHsmConfigurationResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "HsmConfiguration" => {
                        obj.hsm_configuration = Some(HsmConfigurationDeserializer::deserialize(
                            "HsmConfiguration",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateScheduledActionMessage {
    /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <a>ScheduledAction</a>. </p>
    pub enable: Option<bool>,
    /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub end_time: Option<String>,
    /// <p>The IAM role to assume to run the target action. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub iam_role: String,
    /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <a>ScheduledAction</a>.</p>
    pub schedule: String,
    /// <p>The description of the scheduled action. </p>
    pub scheduled_action_description: Option<String>,
    /// <p>The name of the scheduled action. The name must be unique within an account. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub scheduled_action_name: String,
    /// <p>The start time in UTC of the scheduled action. Before this time, the scheduled action does not trigger. For more information about this parameter, see <a>ScheduledAction</a>.</p>
    pub start_time: Option<String>,
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub target_action: ScheduledActionType,
}

/// Serialize `CreateScheduledActionMessage` contents to a `SignedRequest`.
struct CreateScheduledActionMessageSerializer;
impl CreateScheduledActionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateScheduledActionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enable {
            params.put(&format!("{}{}", prefix, "Enable"), &field_value);
        }
        if let Some(ref field_value) = obj.end_time {
            params.put(&format!("{}{}", prefix, "EndTime"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "IamRole"), &obj.iam_role);
        params.put(&format!("{}{}", prefix, "Schedule"), &obj.schedule);
        if let Some(ref field_value) = obj.scheduled_action_description {
            params.put(
                &format!("{}{}", prefix, "ScheduledActionDescription"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ScheduledActionName"),
            &obj.scheduled_action_name,
        );
        if let Some(ref field_value) = obj.start_time {
            params.put(&format!("{}{}", prefix, "StartTime"), &field_value);
        }
        ScheduledActionTypeSerializer::serialize(
            params,
            &format!("{}{}", prefix, "TargetAction"),
            &obj.target_action,
        );
    }
}

/// <p>The result of the <code>CreateSnapshotCopyGrant</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSnapshotCopyGrantMessage {
    /// <p>The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift permission. If no key is specified, the default key is used.</p>
    pub kms_key_id: Option<String>,
    /// <p><p>The name of the snapshot copy grant. This name must be unique in the region for the AWS account.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an AWS account.</p> </li> </ul></p>
    pub snapshot_copy_grant_name: String,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateSnapshotCopyGrantMessage` contents to a `SignedRequest`.
struct CreateSnapshotCopyGrantMessageSerializer;
impl CreateSnapshotCopyGrantMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSnapshotCopyGrantMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotCopyGrantName"),
            &obj.snapshot_copy_grant_name,
        );
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CreateSnapshotCopyGrantResult {
    pub snapshot_copy_grant: Option<SnapshotCopyGrant>,
}

#[allow(dead_code)]
struct CreateSnapshotCopyGrantResultDeserializer;
impl CreateSnapshotCopyGrantResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CreateSnapshotCopyGrantResult, XmlParseError> {
        deserialize_elements::<_, CreateSnapshotCopyGrantResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "SnapshotCopyGrant" => {
                        obj.snapshot_copy_grant = Some(SnapshotCopyGrantDeserializer::deserialize(
                            "SnapshotCopyGrant",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateSnapshotScheduleMessage {
    /// <p><p/></p>
    pub dry_run: Option<bool>,
    /// <p><p/></p>
    pub next_invocations: Option<i64>,
    /// <p>The definition of the snapshot schedule. The definition is made up of schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
    pub schedule_definitions: Option<Vec<String>>,
    /// <p>The description of the snapshot schedule.</p>
    pub schedule_description: Option<String>,
    /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.</p>
    pub schedule_identifier: Option<String>,
    /// <p>An optional set of tags you can use to search for the schedule.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateSnapshotScheduleMessage` contents to a `SignedRequest`.
struct CreateSnapshotScheduleMessageSerializer;
impl CreateSnapshotScheduleMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateSnapshotScheduleMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.dry_run {
            params.put(&format!("{}{}", prefix, "DryRun"), &field_value);
        }
        if let Some(ref field_value) = obj.next_invocations {
            params.put(&format!("{}{}", prefix, "NextInvocations"), &field_value);
        }
        if let Some(ref field_value) = obj.schedule_definitions {
            ScheduleDefinitionListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ScheduleDefinition"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.schedule_description {
            params.put(
                &format!("{}{}", prefix, "ScheduleDescription"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.schedule_identifier {
            params.put(&format!("{}{}", prefix, "ScheduleIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

/// <p>Contains the output from the <code>CreateTags</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateTagsMessage {
    /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
    pub resource_name: String,
    /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag name is passed in with the parameter <code>Key</code> and the corresponding value is passed in with the parameter <code>Value</code>. The <code>Key</code> and <code>Value</code> parameters are separated by a comma (,). Separate multiple tags with a space. For example, <code>--tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
    pub tags: Vec<Tag>,
}

/// Serialize `CreateTagsMessage` contents to a `SignedRequest`.
struct CreateTagsMessageSerializer;
impl CreateTagsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateTagsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ResourceName"), &obj.resource_name);
        TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), &obj.tags);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct CreateUsageLimitMessage {
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number. </p>
    pub amount: i64,
    /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see <a>UsageLimit</a>.</p>
    pub breach_action: Option<String>,
    /// <p>The identifier of the cluster that you want to limit usage.</p>
    pub cluster_identifier: String,
    /// <p>The Amazon Redshift feature that you want to limit.</p>
    pub feature_type: String,
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size. If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>. If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>. </p>
    pub limit_type: String,
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub period: Option<String>,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

/// Serialize `CreateUsageLimitMessage` contents to a `SignedRequest`.
struct CreateUsageLimitMessageSerializer;
impl CreateUsageLimitMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &CreateUsageLimitMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Amount"), &obj.amount);
        if let Some(ref field_value) = obj.breach_action {
            params.put(&format!("{}{}", prefix, "BreachAction"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        params.put(&format!("{}{}", prefix, "FeatureType"), &obj.feature_type);
        params.put(&format!("{}{}", prefix, "LimitType"), &obj.limit_type);
        if let Some(ref field_value) = obj.period {
            params.put(&format!("{}{}", prefix, "Period"), &field_value);
        }
        if let Some(ref field_value) = obj.tags {
            TagListSerializer::serialize(params, &format!("{}{}", prefix, "Tag"), field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct CustomerStorageMessage {
    /// <p>The total amount of storage currently used for snapshots.</p>
    pub total_backup_size_in_mega_bytes: Option<f64>,
    /// <p>The total amount of storage currently provisioned.</p>
    pub total_provisioned_storage_in_mega_bytes: Option<f64>,
}

#[allow(dead_code)]
struct CustomerStorageMessageDeserializer;
impl CustomerStorageMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<CustomerStorageMessage, XmlParseError> {
        deserialize_elements::<_, CustomerStorageMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "TotalBackupSizeInMegaBytes" => {
                    obj.total_backup_size_in_mega_bytes = Some(DoubleDeserializer::deserialize(
                        "TotalBackupSizeInMegaBytes",
                        stack,
                    )?);
                }
                "TotalProvisionedStorageInMegaBytes" => {
                    obj.total_provisioned_storage_in_mega_bytes =
                        Some(DoubleDeserializer::deserialize(
                            "TotalProvisionedStorageInMegaBytes",
                            stack,
                        )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes the status of a cluster while it is in the process of resizing with an incremental resize.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DataTransferProgress {
    /// <p>Describes the data transfer rate in MB's per second.</p>
    pub current_rate_in_mega_bytes_per_second: Option<f64>,
    /// <p>Describes the total amount of data that has been transfered in MB's.</p>
    pub data_transferred_in_mega_bytes: Option<i64>,
    /// <p>Describes the number of seconds that have elapsed during the data transfer.</p>
    pub elapsed_time_in_seconds: Option<i64>,
    /// <p>Describes the estimated number of seconds remaining to complete the transfer.</p>
    pub estimated_time_to_completion_in_seconds: Option<i64>,
    /// <p>Describes the status of the cluster. While the transfer is in progress the status is <code>transferringdata</code>.</p>
    pub status: Option<String>,
    /// <p>Describes the total amount of data to be transfered in megabytes.</p>
    pub total_data_in_mega_bytes: Option<i64>,
}

#[allow(dead_code)]
struct DataTransferProgressDeserializer;
impl DataTransferProgressDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DataTransferProgress, XmlParseError> {
        deserialize_elements::<_, DataTransferProgress, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CurrentRateInMegaBytesPerSecond" => {
                    obj.current_rate_in_mega_bytes_per_second =
                        Some(DoubleOptionalDeserializer::deserialize(
                            "CurrentRateInMegaBytesPerSecond",
                            stack,
                        )?);
                }
                "DataTransferredInMegaBytes" => {
                    obj.data_transferred_in_mega_bytes = Some(LongDeserializer::deserialize(
                        "DataTransferredInMegaBytes",
                        stack,
                    )?);
                }
                "ElapsedTimeInSeconds" => {
                    obj.elapsed_time_in_seconds = Some(LongOptionalDeserializer::deserialize(
                        "ElapsedTimeInSeconds",
                        stack,
                    )?);
                }
                "EstimatedTimeToCompletionInSeconds" => {
                    obj.estimated_time_to_completion_in_seconds =
                        Some(LongOptionalDeserializer::deserialize(
                            "EstimatedTimeToCompletionInSeconds",
                            stack,
                        )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "TotalDataInMegaBytes" => {
                    obj.total_data_in_mega_bytes = Some(LongDeserializer::deserialize(
                        "TotalDataInMegaBytes",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `DbGroupList` contents to a `SignedRequest`.
struct DbGroupListSerializer;
impl DbGroupListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes the default cluster parameters for a parameter group family.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DefaultClusterParameters {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>The name of the cluster parameter group family to which the engine default parameters apply.</p>
    pub parameter_group_family: Option<String>,
    /// <p>The list of cluster default parameters.</p>
    pub parameters: Option<Vec<Parameter>>,
}

#[allow(dead_code)]
struct DefaultClusterParametersDeserializer;
impl DefaultClusterParametersDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DefaultClusterParameters, XmlParseError> {
        deserialize_elements::<_, DefaultClusterParameters, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ParameterGroupFamily" => {
                        obj.parameter_group_family = Some(StringDeserializer::deserialize(
                            "ParameterGroupFamily",
                            stack,
                        )?);
                    }
                    "Parameters" => {
                        obj.parameters.get_or_insert(vec![]).extend(
                            ParametersListDeserializer::deserialize("Parameters", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a deferred maintenance window</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeferredMaintenanceWindow {
    /// <p> A timestamp for the end of the time period when we defer maintenance.</p>
    pub defer_maintenance_end_time: Option<String>,
    /// <p>A unique identifier for the maintenance window.</p>
    pub defer_maintenance_identifier: Option<String>,
    /// <p> A timestamp for the beginning of the time period when we defer maintenance.</p>
    pub defer_maintenance_start_time: Option<String>,
}

#[allow(dead_code)]
struct DeferredMaintenanceWindowDeserializer;
impl DeferredMaintenanceWindowDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeferredMaintenanceWindow, XmlParseError> {
        deserialize_elements::<_, DeferredMaintenanceWindow, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DeferMaintenanceEndTime" => {
                        obj.defer_maintenance_end_time = Some(TStampDeserializer::deserialize(
                            "DeferMaintenanceEndTime",
                            stack,
                        )?);
                    }
                    "DeferMaintenanceIdentifier" => {
                        obj.defer_maintenance_identifier = Some(StringDeserializer::deserialize(
                            "DeferMaintenanceIdentifier",
                            stack,
                        )?);
                    }
                    "DeferMaintenanceStartTime" => {
                        obj.defer_maintenance_start_time = Some(TStampDeserializer::deserialize(
                            "DeferMaintenanceStartTime",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DeferredMaintenanceWindowsListDeserializer;
impl DeferredMaintenanceWindowsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<DeferredMaintenanceWindow>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "DeferredMaintenanceWindow" {
                obj.push(DeferredMaintenanceWindowDeserializer::deserialize(
                    "DeferredMaintenanceWindow",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClusterMessage {
    /// <p><p>The identifier of the cluster to be deleted.</p> <p>Constraints:</p> <ul> <li> <p>Must contain lowercase characters.</p> </li> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub cluster_identifier: String,
    /// <p><p>The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub final_cluster_snapshot_identifier: Option<String>,
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>
    pub final_cluster_snapshot_retention_period: Option<i64>,
    /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot is created before the cluster is deleted. </p> <note> <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is <code>false</code>.</p> </note> <p>Default: <code>false</code> </p>
    pub skip_final_cluster_snapshot: Option<bool>,
}

/// Serialize `DeleteClusterMessage` contents to a `SignedRequest`.
struct DeleteClusterMessageSerializer;
impl DeleteClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.final_cluster_snapshot_identifier {
            params.put(
                &format!("{}{}", prefix, "FinalClusterSnapshotIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.final_cluster_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "FinalClusterSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.skip_final_cluster_snapshot {
            params.put(
                &format!("{}{}", prefix, "SkipFinalClusterSnapshot"),
                &field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClusterParameterGroupMessage {
    /// <p><p>The name of the parameter group to be deleted.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing cluster parameter group.</p> </li> <li> <p>Cannot delete a default cluster parameter group.</p> </li> </ul></p>
    pub parameter_group_name: String,
}

/// Serialize `DeleteClusterParameterGroupMessage` contents to a `SignedRequest`.
struct DeleteClusterParameterGroupMessageSerializer;
impl DeleteClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ParameterGroupName"),
            &obj.parameter_group_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct DeleteClusterResultDeserializer;
impl DeleteClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteClusterResult, XmlParseError> {
        deserialize_elements::<_, DeleteClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClusterSecurityGroupMessage {
    /// <p>The name of the cluster security group to be deleted.</p>
    pub cluster_security_group_name: String,
}

/// Serialize `DeleteClusterSecurityGroupMessage` contents to a `SignedRequest`.
struct DeleteClusterSecurityGroupMessageSerializer;
impl DeleteClusterSecurityGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClusterSecurityGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterSecurityGroupName"),
            &obj.cluster_security_group_name,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClusterSnapshotMessage {
    /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p> <p>Constraints: Must be the name of valid cluster.</p>
    pub snapshot_cluster_identifier: Option<String>,
    /// <p>The unique identifier of the manual snapshot to be deleted.</p> <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
    pub snapshot_identifier: String,
}

/// Serialize `DeleteClusterSnapshotMessage` contents to a `SignedRequest`.
struct DeleteClusterSnapshotMessageSerializer;
impl DeleteClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.snapshot_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "SnapshotClusterIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
    }
}

/// Serialize `DeleteClusterSnapshotMessageList` contents to a `SignedRequest`.
struct DeleteClusterSnapshotMessageListSerializer;
impl DeleteClusterSnapshotMessageListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<DeleteClusterSnapshotMessage>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            DeleteClusterSnapshotMessageSerializer::serialize(params, &key, obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DeleteClusterSnapshotResult {
    pub snapshot: Option<Snapshot>,
}

#[allow(dead_code)]
struct DeleteClusterSnapshotResultDeserializer;
impl DeleteClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DeleteClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, DeleteClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Snapshot" => {
                        obj.snapshot = Some(SnapshotDeserializer::deserialize("Snapshot", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteClusterSubnetGroupMessage {
    /// <p>The name of the cluster subnet group name to be deleted.</p>
    pub cluster_subnet_group_name: String,
}

/// Serialize `DeleteClusterSubnetGroupMessage` contents to a `SignedRequest`.
struct DeleteClusterSubnetGroupMessageSerializer;
impl DeleteClusterSubnetGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteClusterSubnetGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterSubnetGroupName"),
            &obj.cluster_subnet_group_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEndpointAccessMessage {
    /// <p>The Redshift-managed VPC endpoint to delete.</p>
    pub endpoint_name: String,
}

/// Serialize `DeleteEndpointAccessMessage` contents to a `SignedRequest`.
struct DeleteEndpointAccessMessageSerializer;
impl DeleteEndpointAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteEndpointAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "EndpointName"), &obj.endpoint_name);
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteEventSubscriptionMessage {
    /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
    pub subscription_name: String,
}

/// Serialize `DeleteEventSubscriptionMessage` contents to a `SignedRequest`.
struct DeleteEventSubscriptionMessageSerializer;
impl DeleteEventSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteEventSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteHsmClientCertificateMessage {
    /// <p>The identifier of the HSM client certificate to be deleted.</p>
    pub hsm_client_certificate_identifier: String,
}

/// Serialize `DeleteHsmClientCertificateMessage` contents to a `SignedRequest`.
struct DeleteHsmClientCertificateMessageSerializer;
impl DeleteHsmClientCertificateMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteHsmClientCertificateMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "HsmClientCertificateIdentifier"),
            &obj.hsm_client_certificate_identifier,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteHsmConfigurationMessage {
    /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
    pub hsm_configuration_identifier: String,
}

/// Serialize `DeleteHsmConfigurationMessage` contents to a `SignedRequest`.
struct DeleteHsmConfigurationMessageSerializer;
impl DeleteHsmConfigurationMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteHsmConfigurationMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "HsmConfigurationIdentifier"),
            &obj.hsm_configuration_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteScheduledActionMessage {
    /// <p>The name of the scheduled action to delete. </p>
    pub scheduled_action_name: String,
}

/// Serialize `DeleteScheduledActionMessage` contents to a `SignedRequest`.
struct DeleteScheduledActionMessageSerializer;
impl DeleteScheduledActionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteScheduledActionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ScheduledActionName"),
            &obj.scheduled_action_name,
        );
    }
}

/// <p>The result of the <code>DeleteSnapshotCopyGrant</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSnapshotCopyGrantMessage {
    /// <p>The name of the snapshot copy grant to delete.</p>
    pub snapshot_copy_grant_name: String,
}

/// Serialize `DeleteSnapshotCopyGrantMessage` contents to a `SignedRequest`.
struct DeleteSnapshotCopyGrantMessageSerializer;
impl DeleteSnapshotCopyGrantMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSnapshotCopyGrantMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "SnapshotCopyGrantName"),
            &obj.snapshot_copy_grant_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteSnapshotScheduleMessage {
    /// <p>A unique identifier of the snapshot schedule to delete.</p>
    pub schedule_identifier: String,
}

/// Serialize `DeleteSnapshotScheduleMessage` contents to a `SignedRequest`.
struct DeleteSnapshotScheduleMessageSerializer;
impl DeleteSnapshotScheduleMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteSnapshotScheduleMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ScheduleIdentifier"),
            &obj.schedule_identifier,
        );
    }
}

/// <p>Contains the output from the <code>DeleteTags</code> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteTagsMessage {
    /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
    pub resource_name: String,
    /// <p>The tag key that you want to delete.</p>
    pub tag_keys: Vec<String>,
}

/// Serialize `DeleteTagsMessage` contents to a `SignedRequest`.
struct DeleteTagsMessageSerializer;
impl DeleteTagsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteTagsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ResourceName"), &obj.resource_name);
        TagKeyListSerializer::serialize(params, &format!("{}{}", prefix, "TagKey"), &obj.tag_keys);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DeleteUsageLimitMessage {
    /// <p>The identifier of the usage limit to delete.</p>
    pub usage_limit_id: String,
}

/// Serialize `DeleteUsageLimitMessage` contents to a `SignedRequest`.
struct DeleteUsageLimitMessageSerializer;
impl DeleteUsageLimitMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DeleteUsageLimitMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "UsageLimitId"),
            &obj.usage_limit_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeAccountAttributesMessage {
    /// <p>A list of attribute names.</p>
    pub attribute_names: Option<Vec<String>>,
}

/// Serialize `DescribeAccountAttributesMessage` contents to a `SignedRequest`.
struct DescribeAccountAttributesMessageSerializer;
impl DescribeAccountAttributesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeAccountAttributesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.attribute_names {
            AttributeNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "AttributeName"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterDbRevisionsMessage {
    /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is case sensitive. All clusters defined for an account are returned by default.</p>
    pub cluster_identifier: Option<String>,
    /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code> parameter, but not both.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p> <p>Default: 100</p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeClusterDbRevisionsMessage` contents to a `SignedRequest`.
struct DescribeClusterDbRevisionsMessageSerializer;
impl DescribeClusterDbRevisionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterDbRevisionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterParameterGroupsMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterParameterGroups</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of a specific parameter group for which to return details. By default, details about all parameter groups and the default parameter group are returned.</p>
    pub parameter_group_name: Option<String>,
    /// <p>A tag key or keys for which you want to return all matching cluster parameter groups that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching cluster parameter groups that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeClusterParameterGroupsMessage` contents to a `SignedRequest`.
struct DescribeClusterParameterGroupsMessageSerializer;
impl DescribeClusterParameterGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterParameterGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.parameter_group_name {
            params.put(&format!("{}{}", prefix, "ParameterGroupName"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterParametersMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterParameters</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of a cluster parameter group for which to return details.</p>
    pub parameter_group_name: String,
    /// <p>The parameter types to return. Specify <code>user</code> to show parameters that are different form the default. Similarly, specify <code>engine-default</code> to show parameters that are the same as the default parameter group. </p> <p>Default: All parameter types returned.</p> <p>Valid Values: <code>user</code> | <code>engine-default</code> </p>
    pub source: Option<String>,
}

/// Serialize `DescribeClusterParametersMessage` contents to a `SignedRequest`.
struct DescribeClusterParametersMessageSerializer;
impl DescribeClusterParametersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterParametersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ParameterGroupName"),
            &obj.parameter_group_name,
        );
        if let Some(ref field_value) = obj.source {
            params.put(&format!("{}{}", prefix, "Source"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterSecurityGroupsMessage {
    /// <p>The name of a cluster security group for which you are requesting details. You can specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p> <p> Example: <code>securitygroup1</code> </p>
    pub cluster_security_group_name: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterSecurityGroups</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeClusterSecurityGroupsMessage` contents to a `SignedRequest`.
struct DescribeClusterSecurityGroupsMessageSerializer;
impl DescribeClusterSecurityGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterSecurityGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_security_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterSecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterSnapshotsMessage {
    /// <p><p>A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows: </p> <ul> <li> <p>If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.</p> </li> <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn&#39;t specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned. </p> </li> <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots associated with that cluster are returned.</p> </li> <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for an existing cluster, no snapshots are returned. </p> </li> </ul></p>
    pub cluster_exists: Option<bool>,
    /// <p>The identifier of the cluster which generated the requested snapshots.</p>
    pub cluster_identifier: Option<String>,
    /// <p>A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
    pub end_time: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterSnapshots</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The AWS customer account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your AWS customer account, or do not specify the parameter.</p>
    pub owner_account: Option<String>,
    /// <p>The snapshot identifier of the snapshot about which to return information.</p>
    pub snapshot_identifier: Option<String>,
    /// <p>The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.</p> <p>Valid Values: <code>automated</code> | <code>manual</code> </p>
    pub snapshot_type: Option<String>,
    /// <p><p/></p>
    pub sorting_entities: Option<Vec<SnapshotSortingEntity>>,
    /// <p>A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
    pub start_time: Option<String>,
    /// <p>A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeClusterSnapshotsMessage` contents to a `SignedRequest`.
struct DescribeClusterSnapshotsMessageSerializer;
impl DescribeClusterSnapshotsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterSnapshotsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_exists {
            params.put(&format!("{}{}", prefix, "ClusterExists"), &field_value);
        }
        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.end_time {
            params.put(&format!("{}{}", prefix, "EndTime"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.owner_account {
            params.put(&format!("{}{}", prefix, "OwnerAccount"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_identifier {
            params.put(&format!("{}{}", prefix, "SnapshotIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_type {
            params.put(&format!("{}{}", prefix, "SnapshotType"), &field_value);
        }
        if let Some(ref field_value) = obj.sorting_entities {
            SnapshotSortingEntityListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SnapshotSortingEntity"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.start_time {
            params.put(&format!("{}{}", prefix, "StartTime"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterSubnetGroupsMessage {
    /// <p>The name of the cluster subnet group for which information is requested.</p>
    pub cluster_subnet_group_name: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterSubnetGroups</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A tag key or keys for which you want to return all matching cluster subnet groups that are associated with the specified key or keys. For example, suppose that you have subnet groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching cluster subnet groups that are associated with the specified tag value or values. For example, suppose that you have subnet groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeClusterSubnetGroupsMessage` contents to a `SignedRequest`.
struct DescribeClusterSubnetGroupsMessageSerializer;
impl DescribeClusterSubnetGroupsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterSubnetGroupsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_subnet_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterSubnetGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterTracksMessage {
    /// <p>The name of the maintenance track. </p>
    pub maintenance_track_name: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterTracks</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeClusterTracksMessage` contents to a `SignedRequest`.
struct DescribeClusterTracksMessageSerializer;
impl DescribeClusterTracksMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterTracksMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.maintenance_track_name {
            params.put(
                &format!("{}{}", prefix, "MaintenanceTrackName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClusterVersionsMessage {
    /// <p><p>The name of a specific cluster parameter group family to return details for.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul></p>
    pub cluster_parameter_group_family: Option<String>,
    /// <p>The specific cluster version to return.</p> <p>Example: <code>1.0</code> </p>
    pub cluster_version: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusterVersions</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeClusterVersionsMessage` contents to a `SignedRequest`.
struct DescribeClusterVersionsMessageSerializer;
impl DescribeClusterVersionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClusterVersionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_parameter_group_family {
            params.put(
                &format!("{}{}", prefix, "ClusterParameterGroupFamily"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_version {
            params.put(&format!("{}{}", prefix, "ClusterVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeClustersMessage {
    /// <p>The unique identifier of a cluster whose properties you are requesting. This parameter is case sensitive.</p> <p>The default is that all clusters defined for an account are returned.</p>
    pub cluster_identifier: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeClusters</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A tag key or keys for which you want to return all matching clusters that are associated with the specified key or keys. For example, suppose that you have clusters that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching clusters that are associated with the specified tag value or values. For example, suppose that you have clusters that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeClustersMessage` contents to a `SignedRequest`.
struct DescribeClustersMessageSerializer;
impl DescribeClustersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeClustersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeDefaultClusterParametersMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDefaultClusterParameters</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of the cluster parameter group family.</p>
    pub parameter_group_family: String,
}

/// Serialize `DescribeDefaultClusterParametersMessage` contents to a `SignedRequest`.
struct DescribeDefaultClusterParametersMessageSerializer;
impl DescribeDefaultClusterParametersMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeDefaultClusterParametersMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ParameterGroupFamily"),
            &obj.parameter_group_family,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeDefaultClusterParametersResult {
    pub default_cluster_parameters: Option<DefaultClusterParameters>,
}

#[allow(dead_code)]
struct DescribeDefaultClusterParametersResultDeserializer;
impl DescribeDefaultClusterParametersResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeDefaultClusterParametersResult, XmlParseError> {
        deserialize_elements::<_, DescribeDefaultClusterParametersResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DefaultClusterParameters" => {
                        obj.default_cluster_parameters =
                            Some(DefaultClusterParametersDeserializer::deserialize(
                                "DefaultClusterParameters",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEndpointAccessMessage {
    /// <p>The cluster identifier associated with the described endpoint.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The name of the endpoint to be described.</p>
    pub endpoint_name: Option<String>,
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
    pub max_records: Option<i64>,
    /// <p>The AWS account ID of the owner of the cluster.</p>
    pub resource_owner: Option<String>,
    /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
    pub vpc_id: Option<String>,
}

/// Serialize `DescribeEndpointAccessMessage` contents to a `SignedRequest`.
struct DescribeEndpointAccessMessageSerializer;
impl DescribeEndpointAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEndpointAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.endpoint_name {
            params.put(&format!("{}{}", prefix, "EndpointName"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.resource_owner {
            params.put(&format!("{}{}", prefix, "ResourceOwner"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_id {
            params.put(&format!("{}{}", prefix, "VpcId"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEndpointAuthorizationMessage {
    /// <p>The AWS account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
    pub account: Option<String>,
    /// <p>The cluster identifier of the cluster to access.</p>
    pub cluster_identifier: Option<String>,
    /// <p>Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift returns endpoint authorizations that you've been granted. If false (default), checks authorization from a grantor point of view.</p>
    pub grantee: Option<bool>,
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
    pub max_records: Option<i64>,
}

/// Serialize `DescribeEndpointAuthorizationMessage` contents to a `SignedRequest`.
struct DescribeEndpointAuthorizationMessageSerializer;
impl DescribeEndpointAuthorizationMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEndpointAuthorizationMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.account {
            params.put(&format!("{}{}", prefix, "Account"), &field_value);
        }
        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.grantee {
            params.put(&format!("{}{}", prefix, "Grantee"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventCategoriesMessage {
    /// <p>The source type, such as cluster or parameter group, to which the described event categories apply.</p> <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
    pub source_type: Option<String>,
}

/// Serialize `DescribeEventCategoriesMessage` contents to a `SignedRequest`.
struct DescribeEventCategoriesMessageSerializer;
impl DescribeEventCategoriesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEventCategoriesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventSubscriptionsMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of the Amazon Redshift event notification subscription to be described.</p>
    pub subscription_name: Option<String>,
    /// <p>A tag key or keys for which you want to return all matching event notification subscriptions that are associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching event notification subscriptions that are associated with the specified tag value or values. For example, suppose that you have subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeEventSubscriptionsMessage` contents to a `SignedRequest`.
struct DescribeEventSubscriptionsMessageSerializer;
impl DescribeEventSubscriptionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEventSubscriptionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.subscription_name {
            params.put(&format!("{}{}", prefix, "SubscriptionName"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeEventsMessage {
    /// <p>The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.</p> <p>Default: <code>60</code> </p>
    pub duration: Option<i64>,
    /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2009-07-08T18:00Z</code> </p>
    pub end_time: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeEvents</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p><p>The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.</p> <p>Constraints:</p> <p>If <i>SourceIdentifier</i> is supplied, <i>SourceType</i> must also be provided.</p> <ul> <li> <p>Specify a cluster identifier when <i>SourceType</i> is <code>cluster</code>.</p> </li> <li> <p>Specify a cluster security group name when <i>SourceType</i> is <code>cluster-security-group</code>.</p> </li> <li> <p>Specify a cluster parameter group name when <i>SourceType</i> is <code>cluster-parameter-group</code>.</p> </li> <li> <p>Specify a cluster snapshot identifier when <i>SourceType</i> is <code>cluster-snapshot</code>.</p> </li> </ul></p>
    pub source_identifier: Option<String>,
    /// <p><p>The event source to retrieve events for. If no value is specified, all events are returned.</p> <p>Constraints:</p> <p>If <i>SourceType</i> is supplied, <i>SourceIdentifier</i> must also be provided.</p> <ul> <li> <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is a cluster identifier.</p> </li> <li> <p>Specify <code>cluster-security-group</code> when <i>SourceIdentifier</i> is a cluster security group name.</p> </li> <li> <p>Specify <code>cluster-parameter-group</code> when <i>SourceIdentifier</i> is a cluster parameter group name.</p> </li> <li> <p>Specify <code>cluster-snapshot</code> when <i>SourceIdentifier</i> is a cluster snapshot identifier.</p> </li> </ul></p>
    pub source_type: Option<String>,
    /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: <code>2009-07-08T18:00Z</code> </p>
    pub start_time: Option<String>,
}

/// Serialize `DescribeEventsMessage` contents to a `SignedRequest`.
struct DescribeEventsMessageSerializer;
impl DescribeEventsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeEventsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.duration {
            params.put(&format!("{}{}", prefix, "Duration"), &field_value);
        }
        if let Some(ref field_value) = obj.end_time {
            params.put(&format!("{}{}", prefix, "EndTime"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.source_identifier {
            params.put(&format!("{}{}", prefix, "SourceIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
        if let Some(ref field_value) = obj.start_time {
            params.put(&format!("{}{}", prefix, "StartTime"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHsmClientCertificatesMessage {
    /// <p>The identifier of a specific HSM client certificate for which you want information. If no identifier is specified, information is returned for all HSM client certificates owned by your AWS customer account.</p>
    pub hsm_client_certificate_identifier: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeHsmClientCertificates</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A tag key or keys for which you want to return all matching HSM client certificates that are associated with the specified key or keys. For example, suppose that you have HSM client certificates that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching HSM client certificates that are associated with the specified tag value or values. For example, suppose that you have HSM client certificates that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeHsmClientCertificatesMessage` contents to a `SignedRequest`.
struct DescribeHsmClientCertificatesMessageSerializer;
impl DescribeHsmClientCertificatesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeHsmClientCertificatesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.hsm_client_certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmClientCertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeHsmConfigurationsMessage {
    /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no identifier is specified, information is returned for all HSM configurations owned by your AWS customer account.</p>
    pub hsm_configuration_identifier: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeHsmConfigurations</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A tag key or keys for which you want to return all matching HSM configurations that are associated with the specified key or keys. For example, suppose that you have HSM configurations that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching HSM configurations that are associated with the specified tag value or values. For example, suppose that you have HSM configurations that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeHsmConfigurationsMessage` contents to a `SignedRequest`.
struct DescribeHsmConfigurationsMessageSerializer;
impl DescribeHsmConfigurationsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeHsmConfigurationsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.hsm_configuration_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmConfigurationIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeLoggingStatusMessage {
    /// <p>The identifier of the cluster from which to get the logging status.</p> <p>Example: <code>examplecluster</code> </p>
    pub cluster_identifier: String,
}

/// Serialize `DescribeLoggingStatusMessage` contents to a `SignedRequest`.
struct DescribeLoggingStatusMessageSerializer;
impl DescribeLoggingStatusMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeLoggingStatusMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeNodeConfigurationOptionsMessage {
    /// <p>The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster. </p>
    pub action_type: String,
    /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
    pub cluster_identifier: Option<String>,
    /// <p>A set of name, operator, and value items to filter the results.</p>
    pub filters: Option<Vec<NodeConfigurationOptionsFilter>>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>500</code> </p> <p>Constraints: minimum 100, maximum 500.</p>
    pub max_records: Option<i64>,
    /// <p>The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>
    pub owner_account: Option<String>,
    /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
    pub snapshot_identifier: Option<String>,
}

/// Serialize `DescribeNodeConfigurationOptionsMessage` contents to a `SignedRequest`.
struct DescribeNodeConfigurationOptionsMessageSerializer;
impl DescribeNodeConfigurationOptionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeNodeConfigurationOptionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "ActionType"), &obj.action_type);
        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            NodeConfigurationOptionsFilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "NodeConfigurationOptionsFilter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.owner_account {
            params.put(&format!("{}{}", prefix, "OwnerAccount"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_identifier {
            params.put(&format!("{}{}", prefix, "SnapshotIdentifier"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeOrderableClusterOptionsMessage {
    /// <p>The version filter value. Specify this parameter to show only the available offerings matching the specified version.</p> <p>Default: All versions.</p> <p>Constraints: Must be one of the version returned from <a>DescribeClusterVersions</a>.</p>
    pub cluster_version: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeOrderableClusterOptions</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The node type filter value. Specify this parameter to show only the available offerings matching the specified node type.</p>
    pub node_type: Option<String>,
}

/// Serialize `DescribeOrderableClusterOptionsMessage` contents to a `SignedRequest`.
struct DescribeOrderableClusterOptionsMessageSerializer;
impl DescribeOrderableClusterOptionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeOrderableClusterOptionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_version {
            params.put(&format!("{}{}", prefix, "ClusterVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.node_type {
            params.put(&format!("{}{}", prefix, "NodeType"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribePartnersInputMessage {
    /// <p>The AWS account ID that owns the cluster.</p>
    pub account_id: String,
    /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
    pub cluster_identifier: String,
    /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
    pub database_name: Option<String>,
    /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
    pub partner_name: Option<String>,
}

/// Serialize `DescribePartnersInputMessage` contents to a `SignedRequest`.
struct DescribePartnersInputMessageSerializer;
impl DescribePartnersInputMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribePartnersInputMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccountId"), &obj.account_id);
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.database_name {
            params.put(&format!("{}{}", prefix, "DatabaseName"), &field_value);
        }
        if let Some(ref field_value) = obj.partner_name {
            params.put(&format!("{}{}", prefix, "PartnerName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribePartnersOutputMessage {
    /// <p>A list of partner integrations.</p>
    pub partner_integration_info_list: Option<Vec<PartnerIntegrationInfo>>,
}

#[allow(dead_code)]
struct DescribePartnersOutputMessageDeserializer;
impl DescribePartnersOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribePartnersOutputMessage, XmlParseError> {
        deserialize_elements::<_, DescribePartnersOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "PartnerIntegrationInfoList" => {
                        obj.partner_integration_info_list
                            .get_or_insert(vec![])
                            .extend(PartnerIntegrationInfoListDeserializer::deserialize(
                                "PartnerIntegrationInfoList",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeReservedNodeOfferingsMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeReservedNodeOfferings</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The unique identifier for the offering.</p>
    pub reserved_node_offering_id: Option<String>,
}

/// Serialize `DescribeReservedNodeOfferingsMessage` contents to a `SignedRequest`.
struct DescribeReservedNodeOfferingsMessageSerializer;
impl DescribeReservedNodeOfferingsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeReservedNodeOfferingsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.reserved_node_offering_id {
            params.put(
                &format!("{}{}", prefix, "ReservedNodeOfferingId"),
                &field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeReservedNodesMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeReservedNodes</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>Identifier for the node reservation.</p>
    pub reserved_node_id: Option<String>,
}

/// Serialize `DescribeReservedNodesMessage` contents to a `SignedRequest`.
struct DescribeReservedNodesMessageSerializer;
impl DescribeReservedNodesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeReservedNodesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.reserved_node_id {
            params.put(&format!("{}{}", prefix, "ReservedNodeId"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeResizeMessage {
    /// <p>The unique identifier of a cluster whose resize progress you are requesting. This parameter is case-sensitive.</p> <p>By default, resize operations for all clusters defined for an AWS account are returned.</p>
    pub cluster_identifier: String,
}

/// Serialize `DescribeResizeMessage` contents to a `SignedRequest`.
struct DescribeResizeMessageSerializer;
impl DescribeResizeMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeResizeMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeScheduledActionsMessage {
    /// <p>If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions. </p>
    pub active: Option<bool>,
    /// <p>The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations before this time are retrieved.</p>
    pub end_time: Option<String>,
    /// <p>List of scheduled action filters. </p>
    pub filters: Option<Vec<ScheduledActionFilter>>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of the scheduled action to retrieve. </p>
    pub scheduled_action_name: Option<String>,
    /// <p>The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations after this time are retrieved.</p>
    pub start_time: Option<String>,
    /// <p>The type of the scheduled actions to retrieve. </p>
    pub target_action_type: Option<String>,
}

/// Serialize `DescribeScheduledActionsMessage` contents to a `SignedRequest`.
struct DescribeScheduledActionsMessageSerializer;
impl DescribeScheduledActionsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeScheduledActionsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.active {
            params.put(&format!("{}{}", prefix, "Active"), &field_value);
        }
        if let Some(ref field_value) = obj.end_time {
            params.put(&format!("{}{}", prefix, "EndTime"), &field_value);
        }
        if let Some(ref field_value) = obj.filters {
            ScheduledActionFilterListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ScheduledActionFilter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.scheduled_action_name {
            params.put(
                &format!("{}{}", prefix, "ScheduledActionName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.start_time {
            params.put(&format!("{}{}", prefix, "StartTime"), &field_value);
        }
        if let Some(ref field_value) = obj.target_action_type {
            params.put(&format!("{}{}", prefix, "TargetActionType"), &field_value);
        }
    }
}

/// <p>The result of the <code>DescribeSnapshotCopyGrants</code> action.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeSnapshotCopyGrantsMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>The name of the snapshot copy grant.</p>
    pub snapshot_copy_grant_name: Option<String>,
    /// <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeSnapshotCopyGrantsMessage` contents to a `SignedRequest`.
struct DescribeSnapshotCopyGrantsMessageSerializer;
impl DescribeSnapshotCopyGrantsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeSnapshotCopyGrantsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_copy_grant_name {
            params.put(
                &format!("{}{}", prefix, "SnapshotCopyGrantName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeSnapshotSchedulesMessage {
    /// <p>The unique identifier for the cluster whose snapshot schedules you want to view.</p>
    pub cluster_identifier: Option<String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
    pub marker: Option<String>,
    /// <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value.</p>
    pub max_records: Option<i64>,
    /// <p>A unique identifier for a snapshot schedule.</p>
    pub schedule_identifier: Option<String>,
    /// <p>The key value for a snapshot schedule tag.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeSnapshotSchedulesMessage` contents to a `SignedRequest`.
struct DescribeSnapshotSchedulesMessageSerializer;
impl DescribeSnapshotSchedulesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeSnapshotSchedulesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.schedule_identifier {
            params.put(&format!("{}{}", prefix, "ScheduleIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DescribeSnapshotSchedulesOutputMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
    pub marker: Option<String>,
    /// <p>A list of SnapshotSchedules.</p>
    pub snapshot_schedules: Option<Vec<SnapshotSchedule>>,
}

#[allow(dead_code)]
struct DescribeSnapshotSchedulesOutputMessageDeserializer;
impl DescribeSnapshotSchedulesOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DescribeSnapshotSchedulesOutputMessage, XmlParseError> {
        deserialize_elements::<_, DescribeSnapshotSchedulesOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "SnapshotSchedules" => {
                        obj.snapshot_schedules.get_or_insert(vec![]).extend(
                            SnapshotScheduleListDeserializer::deserialize(
                                "SnapshotSchedules",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeTableRestoreStatusMessage {
    /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
    pub cluster_identifier: Option<String>,
    /// <p>An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: Option<String>,
    /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    pub max_records: Option<i64>,
    /// <p>The identifier of the table restore request to return status for. If you don't specify a <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table restore requests.</p>
    pub table_restore_request_id: Option<String>,
}

/// Serialize `DescribeTableRestoreStatusMessage` contents to a `SignedRequest`.
struct DescribeTableRestoreStatusMessageSerializer;
impl DescribeTableRestoreStatusMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeTableRestoreStatusMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.table_restore_request_id {
            params.put(
                &format!("{}{}", prefix, "TableRestoreRequestId"),
                &field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeTagsMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value. </p>
    pub max_records: Option<i64>,
    /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
    pub resource_name: Option<String>,
    /// <p>The type of resource with which you want to view tags. Valid resource types are: </p> <ul> <li> <p>Cluster</p> </li> <li> <p>CIDR/IP</p> </li> <li> <p>EC2 security group</p> </li> <li> <p>Snapshot</p> </li> <li> <p>Cluster security group</p> </li> <li> <p>Subnet group</p> </li> <li> <p>HSM connection</p> </li> <li> <p>HSM certificate</p> </li> <li> <p>Parameter group</p> </li> <li> <p>Snapshot copy grant</p> </li> </ul> <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in the Amazon Redshift Cluster Management Guide. </p>
    pub resource_type: Option<String>,
    /// <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
}

/// Serialize `DescribeTagsMessage` contents to a `SignedRequest`.
struct DescribeTagsMessageSerializer;
impl DescribeTagsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeTagsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.resource_name {
            params.put(&format!("{}{}", prefix, "ResourceName"), &field_value);
        }
        if let Some(ref field_value) = obj.resource_type {
            params.put(&format!("{}{}", prefix, "ResourceType"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DescribeUsageLimitsMessage {
    /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The feature type for which you want to describe usage limits.</p>
    pub feature_type: Option<String>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeUsageLimits</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p> <p>Default: <code>100</code> </p> <p>Constraints: minimum 20, maximum 100.</p>
    pub max_records: Option<i64>,
    /// <p>A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.</p>
    pub tag_keys: Option<Vec<String>>,
    /// <p>A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.</p>
    pub tag_values: Option<Vec<String>>,
    /// <p>The identifier of the usage limit to describe.</p>
    pub usage_limit_id: Option<String>,
}

/// Serialize `DescribeUsageLimitsMessage` contents to a `SignedRequest`.
struct DescribeUsageLimitsMessageSerializer;
impl DescribeUsageLimitsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DescribeUsageLimitsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.feature_type {
            params.put(&format!("{}{}", prefix, "FeatureType"), &field_value);
        }
        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        if let Some(ref field_value) = obj.tag_keys {
            TagKeyListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagKey"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.tag_values {
            TagValueListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TagValue"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.usage_limit_id {
            params.put(&format!("{}{}", prefix, "UsageLimitId"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisableLoggingMessage {
    /// <p>The identifier of the cluster on which logging is to be stopped.</p> <p>Example: <code>examplecluster</code> </p>
    pub cluster_identifier: String,
}

/// Serialize `DisableLoggingMessage` contents to a `SignedRequest`.
struct DisableLoggingMessageSerializer;
impl DisableLoggingMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DisableLoggingMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct DisableSnapshotCopyMessage {
    /// <p>The unique identifier of the source cluster that you want to disable copying of snapshots to a destination region.</p> <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>
    pub cluster_identifier: String,
}

/// Serialize `DisableSnapshotCopyMessage` contents to a `SignedRequest`.
struct DisableSnapshotCopyMessageSerializer;
impl DisableSnapshotCopyMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &DisableSnapshotCopyMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct DisableSnapshotCopyResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct DisableSnapshotCopyResultDeserializer;
impl DisableSnapshotCopyResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<DisableSnapshotCopyResult, XmlParseError> {
        deserialize_elements::<_, DisableSnapshotCopyResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct DoubleDeserializer;
impl DoubleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<f64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(f64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct DoubleOptionalDeserializer;
impl DoubleOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<f64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(f64::from_str(&s).unwrap()))
    }
}
/// <p>Describes an Amazon EC2 security group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EC2SecurityGroup {
    /// <p>The name of the EC2 Security Group.</p>
    pub ec2_security_group_name: Option<String>,
    /// <p>The AWS ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
    pub ec2_security_group_owner_id: Option<String>,
    /// <p>The status of the EC2 security group.</p>
    pub status: Option<String>,
    /// <p>The list of tags for the EC2 security group.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct EC2SecurityGroupDeserializer;
impl EC2SecurityGroupDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EC2SecurityGroup, XmlParseError> {
        deserialize_elements::<_, EC2SecurityGroup, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EC2SecurityGroupName" => {
                    obj.ec2_security_group_name = Some(StringDeserializer::deserialize(
                        "EC2SecurityGroupName",
                        stack,
                    )?);
                }
                "EC2SecurityGroupOwnerId" => {
                    obj.ec2_security_group_owner_id = Some(StringDeserializer::deserialize(
                        "EC2SecurityGroupOwnerId",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EC2SecurityGroupListDeserializer;
impl EC2SecurityGroupListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EC2SecurityGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EC2SecurityGroup" {
                obj.push(EC2SecurityGroupDeserializer::deserialize(
                    "EC2SecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the status of the elastic IP (EIP) address.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ElasticIpStatus {
    /// <p>The elastic IP (EIP) address for the cluster.</p>
    pub elastic_ip: Option<String>,
    /// <p>The status of the elastic IP (EIP) address.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct ElasticIpStatusDeserializer;
impl ElasticIpStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ElasticIpStatus, XmlParseError> {
        deserialize_elements::<_, ElasticIpStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ElasticIp" => {
                    obj.elastic_ip = Some(StringDeserializer::deserialize("ElasticIp", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EligibleTracksToUpdateListDeserializer;
impl EligibleTracksToUpdateListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<UpdateTarget>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "UpdateTarget" {
                obj.push(UpdateTargetDeserializer::deserialize(
                    "UpdateTarget",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct EnableLoggingMessage {
    /// <p><p>The name of an existing S3 bucket where the log files are to be stored.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the same region as the cluster</p> </li> <li> <p>The cluster must have read bucket and put object permissions</p> </li> </ul></p>
    pub bucket_name: String,
    /// <p>The identifier of the cluster on which logging is to be started.</p> <p>Example: <code>examplecluster</code> </p>
    pub cluster_identifier: String,
    /// <p><p>The prefix applied to the log file names.</p> <p>Constraints:</p> <ul> <li> <p>Cannot exceed 512 characters</p> </li> <li> <p>Cannot contain spaces( ), double quotes (&quot;), single quotes (&#39;), a backslash (), or control characters. The hexadecimal codes for invalid characters are: </p> <ul> <li> <p>x00 to x20</p> </li> <li> <p>x22</p> </li> <li> <p>x27</p> </li> <li> <p>x5c</p> </li> <li> <p>x7f or larger</p> </li> </ul> </li> </ul></p>
    pub s3_key_prefix: Option<String>,
}

/// Serialize `EnableLoggingMessage` contents to a `SignedRequest`.
struct EnableLoggingMessageSerializer;
impl EnableLoggingMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &EnableLoggingMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "BucketName"), &obj.bucket_name);
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.s3_key_prefix {
            params.put(&format!("{}{}", prefix, "S3KeyPrefix"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct EnableSnapshotCopyMessage {
    /// <p>The unique identifier of the source cluster to copy snapshots from.</p> <p>Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.</p>
    pub cluster_identifier: String,
    /// <p>The destination AWS Region that you want to copy snapshots to.</p> <p>Constraints: Must be the name of a valid AWS Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference. </p>
    pub destination_region: String,
    /// <p>The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>The number of days to retain automated snapshots in the destination region after they are copied from the source region.</p> <p>Default: 7.</p> <p>Constraints: Must be at least 1 and no more than 35.</p>
    pub retention_period: Option<i64>,
    /// <p>The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.</p>
    pub snapshot_copy_grant_name: Option<String>,
}

/// Serialize `EnableSnapshotCopyMessage` contents to a `SignedRequest`.
struct EnableSnapshotCopyMessageSerializer;
impl EnableSnapshotCopyMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &EnableSnapshotCopyMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "DestinationRegion"),
            &obj.destination_region,
        );
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.retention_period {
            params.put(&format!("{}{}", prefix, "RetentionPeriod"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_copy_grant_name {
            params.put(
                &format!("{}{}", prefix, "SnapshotCopyGrantName"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EnableSnapshotCopyResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct EnableSnapshotCopyResultDeserializer;
impl EnableSnapshotCopyResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EnableSnapshotCopyResult, XmlParseError> {
        deserialize_elements::<_, EnableSnapshotCopyResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a connection endpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Endpoint {
    /// <p>The DNS address of the Cluster.</p>
    pub address: Option<String>,
    /// <p>The port that the database engine is listening on.</p>
    pub port: Option<i64>,
    /// <p>Describes a connection endpoint.</p>
    pub vpc_endpoints: Option<Vec<VpcEndpoint>>,
}

#[allow(dead_code)]
struct EndpointDeserializer;
impl EndpointDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Endpoint, XmlParseError> {
        deserialize_elements::<_, Endpoint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Address" => {
                    obj.address = Some(StringDeserializer::deserialize("Address", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                "VpcEndpoints" => {
                    obj.vpc_endpoints.get_or_insert(vec![]).extend(
                        VpcEndpointsListDeserializer::deserialize("VpcEndpoints", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a Redshift-managed VPC endpoint.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EndpointAccess {
    /// <p>The DNS address of the endpoint.</p>
    pub address: Option<String>,
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub endpoint_create_time: Option<String>,
    /// <p>The name of the endpoint.</p>
    pub endpoint_name: Option<String>,
    /// <p>The status of the endpoint.</p>
    pub endpoint_status: Option<String>,
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub port: Option<i64>,
    /// <p>The AWS account ID of the owner of the cluster.</p>
    pub resource_owner: Option<String>,
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub subnet_group_name: Option<String>,
    pub vpc_endpoint: Option<VpcEndpoint>,
    /// <p>The security groups associated with the endpoint.</p>
    pub vpc_security_groups: Option<Vec<VpcSecurityGroupMembership>>,
}

#[allow(dead_code)]
struct EndpointAccessDeserializer;
impl EndpointAccessDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EndpointAccess, XmlParseError> {
        deserialize_elements::<_, EndpointAccess, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Address" => {
                    obj.address = Some(StringDeserializer::deserialize("Address", stack)?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "EndpointCreateTime" => {
                    obj.endpoint_create_time = Some(TStampDeserializer::deserialize(
                        "EndpointCreateTime",
                        stack,
                    )?);
                }
                "EndpointName" => {
                    obj.endpoint_name =
                        Some(StringDeserializer::deserialize("EndpointName", stack)?);
                }
                "EndpointStatus" => {
                    obj.endpoint_status =
                        Some(StringDeserializer::deserialize("EndpointStatus", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                "ResourceOwner" => {
                    obj.resource_owner =
                        Some(StringDeserializer::deserialize("ResourceOwner", stack)?);
                }
                "SubnetGroupName" => {
                    obj.subnet_group_name =
                        Some(StringDeserializer::deserialize("SubnetGroupName", stack)?);
                }
                "VpcEndpoint" => {
                    obj.vpc_endpoint =
                        Some(VpcEndpointDeserializer::deserialize("VpcEndpoint", stack)?);
                }
                "VpcSecurityGroups" => {
                    obj.vpc_security_groups.get_or_insert(vec![]).extend(
                        VpcSecurityGroupMembershipListDeserializer::deserialize(
                            "VpcSecurityGroups",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EndpointAccessList {
    /// <p>The list of endpoints with access to the cluster.</p>
    pub endpoint_access_list: Option<Vec<EndpointAccess>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct EndpointAccessListDeserializer;
impl EndpointAccessListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EndpointAccessList, XmlParseError> {
        deserialize_elements::<_, EndpointAccessList, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EndpointAccessList" => {
                    obj.endpoint_access_list.get_or_insert(vec![]).extend(
                        EndpointAccessesDeserializer::deserialize("EndpointAccessList", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EndpointAccessesDeserializer;
impl EndpointAccessesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EndpointAccess>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(EndpointAccessDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across AWS accounts.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EndpointAuthorization {
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub allowed_all_vp_cs: Option<bool>,
    /// <p>The VPCs allowed access to the cluster.</p>
    pub allowed_vp_cs: Option<Vec<String>>,
    /// <p>The time (UTC) when the authorization was created.</p>
    pub authorize_time: Option<String>,
    /// <p>The cluster identifier.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The status of the cluster.</p>
    pub cluster_status: Option<String>,
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub endpoint_count: Option<i64>,
    /// <p>The AWS account ID of the grantee of the cluster.</p>
    pub grantee: Option<String>,
    /// <p>The AWS account ID of the cluster owner.</p>
    pub grantor: Option<String>,
    /// <p>The status of the authorization action.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct EndpointAuthorizationDeserializer;
impl EndpointAuthorizationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EndpointAuthorization, XmlParseError> {
        deserialize_elements::<_, EndpointAuthorization, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowedAllVPCs" => {
                    obj.allowed_all_vp_cs =
                        Some(BooleanDeserializer::deserialize("AllowedAllVPCs", stack)?);
                }
                "AllowedVPCs" => {
                    obj.allowed_vp_cs.get_or_insert(vec![]).extend(
                        VpcIdentifierListDeserializer::deserialize("AllowedVPCs", stack)?,
                    );
                }
                "AuthorizeTime" => {
                    obj.authorize_time =
                        Some(TStampDeserializer::deserialize("AuthorizeTime", stack)?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "ClusterStatus" => {
                    obj.cluster_status =
                        Some(StringDeserializer::deserialize("ClusterStatus", stack)?);
                }
                "EndpointCount" => {
                    obj.endpoint_count =
                        Some(IntegerDeserializer::deserialize("EndpointCount", stack)?);
                }
                "Grantee" => {
                    obj.grantee = Some(StringDeserializer::deserialize("Grantee", stack)?);
                }
                "Grantor" => {
                    obj.grantor = Some(StringDeserializer::deserialize("Grantor", stack)?);
                }
                "Status" => {
                    obj.status = Some(AuthorizationStatusDeserializer::deserialize(
                        "Status", stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EndpointAuthorizationList {
    /// <p>The authorizations to an endpoint.</p>
    pub endpoint_authorization_list: Option<Vec<EndpointAuthorization>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct EndpointAuthorizationListDeserializer;
impl EndpointAuthorizationListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EndpointAuthorizationList, XmlParseError> {
        deserialize_elements::<_, EndpointAuthorizationList, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EndpointAuthorizationList" => {
                        obj.endpoint_authorization_list
                            .get_or_insert(vec![])
                            .extend(EndpointAuthorizationsDeserializer::deserialize(
                                "EndpointAuthorizationList",
                                stack,
                            )?);
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct EndpointAuthorizationsDeserializer;
impl EndpointAuthorizationsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EndpointAuthorization>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(EndpointAuthorizationDeserializer::deserialize(
                    "member", stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes an event.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Event {
    /// <p>The date and time of the event.</p>
    pub date: Option<String>,
    /// <p>A list of the event categories.</p> <p>Values: Configuration, Management, Monitoring, Security</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>The identifier of the event.</p>
    pub event_id: Option<String>,
    /// <p>The text of this event.</p>
    pub message: Option<String>,
    /// <p>The severity of the event.</p> <p>Values: ERROR, INFO</p>
    pub severity: Option<String>,
    /// <p>The identifier for the source of the event.</p>
    pub source_identifier: Option<String>,
    /// <p>The source type for this event.</p>
    pub source_type: Option<String>,
}

#[allow(dead_code)]
struct EventDeserializer;
impl EventDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Event, XmlParseError> {
        deserialize_elements::<_, Event, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Date" => {
                    obj.date = Some(TStampDeserializer::deserialize("Date", stack)?);
                }
                "EventCategories" => {
                    obj.event_categories.get_or_insert(vec![]).extend(
                        EventCategoriesListDeserializer::deserialize("EventCategories", stack)?,
                    );
                }
                "EventId" => {
                    obj.event_id = Some(StringDeserializer::deserialize("EventId", stack)?);
                }
                "Message" => {
                    obj.message = Some(StringDeserializer::deserialize("Message", stack)?);
                }
                "Severity" => {
                    obj.severity = Some(StringDeserializer::deserialize("Severity", stack)?);
                }
                "SourceIdentifier" => {
                    obj.source_identifier =
                        Some(StringDeserializer::deserialize("SourceIdentifier", stack)?);
                }
                "SourceType" => {
                    obj.source_type =
                        Some(SourceTypeDeserializer::deserialize("SourceType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventCategoriesListDeserializer;
impl EventCategoriesListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventCategory" {
                obj.push(StringDeserializer::deserialize("EventCategory", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `EventCategoriesList` contents to a `SignedRequest`.
struct EventCategoriesListSerializer;
impl EventCategoriesListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes event categories.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventCategoriesMap {
    /// <p>The events in the event category.</p>
    pub events: Option<Vec<EventInfoMap>>,
    /// <p>The source type, such as cluster or cluster-snapshot, that the returned categories belong to.</p>
    pub source_type: Option<String>,
}

#[allow(dead_code)]
struct EventCategoriesMapDeserializer;
impl EventCategoriesMapDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventCategoriesMap, XmlParseError> {
        deserialize_elements::<_, EventCategoriesMap, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Events" => {
                    obj.events
                        .get_or_insert(vec![])
                        .extend(EventInfoMapListDeserializer::deserialize("Events", stack)?);
                }
                "SourceType" => {
                    obj.source_type = Some(StringDeserializer::deserialize("SourceType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventCategoriesMapListDeserializer;
impl EventCategoriesMapListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EventCategoriesMap>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventCategoriesMap" {
                obj.push(EventCategoriesMapDeserializer::deserialize(
                    "EventCategoriesMap",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventCategoriesMessage {
    /// <p>A list of event categories descriptions.</p>
    pub event_categories_map_list: Option<Vec<EventCategoriesMap>>,
}

#[allow(dead_code)]
struct EventCategoriesMessageDeserializer;
impl EventCategoriesMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventCategoriesMessage, XmlParseError> {
        deserialize_elements::<_, EventCategoriesMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EventCategoriesMapList" => {
                    obj.event_categories_map_list.get_or_insert(vec![]).extend(
                        EventCategoriesMapListDeserializer::deserialize(
                            "EventCategoriesMapList",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes event information.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventInfoMap {
    /// <p>The category of an Amazon Redshift event.</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>The description of an Amazon Redshift event.</p>
    pub event_description: Option<String>,
    /// <p>The identifier of an Amazon Redshift event.</p>
    pub event_id: Option<String>,
    /// <p>The severity of the event.</p> <p>Values: ERROR, INFO</p>
    pub severity: Option<String>,
}

#[allow(dead_code)]
struct EventInfoMapDeserializer;
impl EventInfoMapDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventInfoMap, XmlParseError> {
        deserialize_elements::<_, EventInfoMap, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EventCategories" => {
                    obj.event_categories.get_or_insert(vec![]).extend(
                        EventCategoriesListDeserializer::deserialize("EventCategories", stack)?,
                    );
                }
                "EventDescription" => {
                    obj.event_description =
                        Some(StringDeserializer::deserialize("EventDescription", stack)?);
                }
                "EventId" => {
                    obj.event_id = Some(StringDeserializer::deserialize("EventId", stack)?);
                }
                "Severity" => {
                    obj.severity = Some(StringDeserializer::deserialize("Severity", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventInfoMapListDeserializer;
impl EventInfoMapListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EventInfoMap>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventInfoMap" {
                obj.push(EventInfoMapDeserializer::deserialize(
                    "EventInfoMap",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventListDeserializer;
impl EventListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Event>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Event" {
                obj.push(EventDeserializer::deserialize("Event", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes event subscriptions.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventSubscription {
    /// <p>The name of the Amazon Redshift event notification subscription.</p>
    pub cust_subscription_id: Option<String>,
    /// <p>The AWS customer account associated with the Amazon Redshift event notification subscription.</p>
    pub customer_aws_id: Option<String>,
    /// <p>A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription is enabled.</p>
    pub enabled: Option<bool>,
    /// <p>The list of Amazon Redshift event categories specified in the event notification subscription.</p> <p>Values: Configuration, Management, Monitoring, Security</p>
    pub event_categories_list: Option<Vec<String>>,
    /// <p>The event severity specified in the Amazon Redshift event notification subscription.</p> <p>Values: ERROR, INFO</p>
    pub severity: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.</p>
    pub sns_topic_arn: Option<String>,
    /// <p>A list of the sources that publish events to the Amazon Redshift event notification subscription.</p>
    pub source_ids_list: Option<Vec<String>>,
    /// <p>The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action. </p>
    pub source_type: Option<String>,
    /// <p><p>The status of the Amazon Redshift event notification subscription.</p> <p>Constraints:</p> <ul> <li> <p>Can be one of the following: active | no-permission | topic-not-exist</p> </li> <li> <p>The status &quot;no-permission&quot; indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status &quot;topic-not-exist&quot; indicates that the topic was deleted after the subscription was created.</p> </li> </ul></p>
    pub status: Option<String>,
    /// <p>The date and time the Amazon Redshift event notification subscription was created.</p>
    pub subscription_creation_time: Option<String>,
    /// <p>The list of tags for the event subscription.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct EventSubscriptionDeserializer;
impl EventSubscriptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventSubscription, XmlParseError> {
        deserialize_elements::<_, EventSubscription, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CustSubscriptionId" => {
                    obj.cust_subscription_id = Some(StringDeserializer::deserialize(
                        "CustSubscriptionId",
                        stack,
                    )?);
                }
                "CustomerAwsId" => {
                    obj.customer_aws_id =
                        Some(StringDeserializer::deserialize("CustomerAwsId", stack)?);
                }
                "Enabled" => {
                    obj.enabled = Some(BooleanDeserializer::deserialize("Enabled", stack)?);
                }
                "EventCategoriesList" => {
                    obj.event_categories_list.get_or_insert(vec![]).extend(
                        EventCategoriesListDeserializer::deserialize("EventCategoriesList", stack)?,
                    );
                }
                "Severity" => {
                    obj.severity = Some(StringDeserializer::deserialize("Severity", stack)?);
                }
                "SnsTopicArn" => {
                    obj.sns_topic_arn =
                        Some(StringDeserializer::deserialize("SnsTopicArn", stack)?);
                }
                "SourceIdsList" => {
                    obj.source_ids_list.get_or_insert(vec![]).extend(
                        SourceIdsListDeserializer::deserialize("SourceIdsList", stack)?,
                    );
                }
                "SourceType" => {
                    obj.source_type = Some(StringDeserializer::deserialize("SourceType", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "SubscriptionCreationTime" => {
                    obj.subscription_creation_time = Some(TStampDeserializer::deserialize(
                        "SubscriptionCreationTime",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct EventSubscriptionsListDeserializer;
impl EventSubscriptionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<EventSubscription>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "EventSubscription" {
                obj.push(EventSubscriptionDeserializer::deserialize(
                    "EventSubscription",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventSubscriptionsMessage {
    /// <p>A list of event subscriptions.</p>
    pub event_subscriptions_list: Option<Vec<EventSubscription>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct EventSubscriptionsMessageDeserializer;
impl EventSubscriptionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventSubscriptionsMessage, XmlParseError> {
        deserialize_elements::<_, EventSubscriptionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscriptionsList" => {
                        obj.event_subscriptions_list.get_or_insert(vec![]).extend(
                            EventSubscriptionsListDeserializer::deserialize(
                                "EventSubscriptionsList",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct EventsMessage {
    /// <p>A list of <code>Event</code> instances. </p>
    pub events: Option<Vec<Event>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct EventsMessageDeserializer;
impl EventsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<EventsMessage, XmlParseError> {
        deserialize_elements::<_, EventsMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Events" => {
                    obj.events
                        .get_or_insert(vec![])
                        .extend(EventListDeserializer::deserialize("Events", stack)?);
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The request parameters to get cluster credentials.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetClusterCredentialsMessage {
    /// <p>Create a database user with the name specified for the user named in <code>DbUser</code> if one does not exist.</p>
    pub auto_create: Option<bool>,
    /// <p>The unique identifier of the cluster that contains the database for which your are requesting credentials. This parameter is case sensitive.</p>
    pub cluster_identifier: String,
    /// <p><p>A list of the names of existing database groups that the user named in <code>DbUser</code> will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.</p> <p>Database group name constraints</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li> </ul></p>
    pub db_groups: Option<Vec<String>>,
    /// <p><p>The name of a database that <code>DbUser</code> is authorized to log on to. If <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing database.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li> </ul></p>
    pub db_name: Option<String>,
    /// <p><p>The name of a database user. If a user name matching <code>DbUser</code> exists in the database, the temporary user credentials have the same permissions as the existing user. If <code>DbUser</code> doesn&#39;t exist in the database and <code>Autocreate</code> is <code>True</code>, a new user is created using the value for <code>DbUser</code> with PUBLIC permissions. If a database user matching the value for <code>DbUser</code> doesn&#39;t exist and <code>Autocreate</code> is <code>False</code>, then the command succeeds but the connection attempt will fail because the user doesn&#39;t exist in the database.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon Redshift Database Developer Guide. </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can&#39;t be <code>PUBLIC</code>.</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li> </ul></p>
    pub db_user: String,
    /// <p>The number of seconds until the returned temporary password expires.</p> <p>Constraint: minimum 900, maximum 3600.</p> <p>Default: 900</p>
    pub duration_seconds: Option<i64>,
}

/// Serialize `GetClusterCredentialsMessage` contents to a `SignedRequest`.
struct GetClusterCredentialsMessageSerializer;
impl GetClusterCredentialsMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &GetClusterCredentialsMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.auto_create {
            params.put(&format!("{}{}", prefix, "AutoCreate"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.db_groups {
            DbGroupListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "DbGroup"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.db_name {
            params.put(&format!("{}{}", prefix, "DbName"), &field_value);
        }
        params.put(&format!("{}{}", prefix, "DbUser"), &obj.db_user);
        if let Some(ref field_value) = obj.duration_seconds {
            params.put(&format!("{}{}", prefix, "DurationSeconds"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct GetReservedNodeExchangeOfferingsInputMessage {
    /// <p>A value that indicates the starting point for the next set of ReservedNodeOfferings.</p>
    pub marker: Option<String>,
    /// <p>An integer setting the maximum number of ReservedNodeOfferings to retrieve.</p>
    pub max_records: Option<i64>,
    /// <p>A string representing the node identifier for the DC1 Reserved Node to be exchanged.</p>
    pub reserved_node_id: String,
}

/// Serialize `GetReservedNodeExchangeOfferingsInputMessage` contents to a `SignedRequest`.
struct GetReservedNodeExchangeOfferingsInputMessageSerializer;
impl GetReservedNodeExchangeOfferingsInputMessageSerializer {
    fn serialize(
        params: &mut Params,
        name: &str,
        obj: &GetReservedNodeExchangeOfferingsInputMessage,
    ) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.marker {
            params.put(&format!("{}{}", prefix, "Marker"), &field_value);
        }
        if let Some(ref field_value) = obj.max_records {
            params.put(&format!("{}{}", prefix, "MaxRecords"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ReservedNodeId"),
            &obj.reserved_node_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct GetReservedNodeExchangeOfferingsOutputMessage {
    /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>Returns an array of <a>ReservedNodeOffering</a> objects.</p>
    pub reserved_node_offerings: Option<Vec<ReservedNodeOffering>>,
}

#[allow(dead_code)]
struct GetReservedNodeExchangeOfferingsOutputMessageDeserializer;
impl GetReservedNodeExchangeOfferingsOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<GetReservedNodeExchangeOfferingsOutputMessage, XmlParseError> {
        deserialize_elements::<_, GetReservedNodeExchangeOfferingsOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ReservedNodeOfferings" => {
                        obj.reserved_node_offerings.get_or_insert(vec![]).extend(
                            ReservedNodeOfferingListDeserializer::deserialize(
                                "ReservedNodeOfferings",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct HsmClientCertificate {
    /// <p>The identifier of the HSM client certificate.</p>
    pub hsm_client_certificate_identifier: Option<String>,
    /// <p>The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.</p>
    pub hsm_client_certificate_public_key: Option<String>,
    /// <p>The list of tags for the HSM client certificate.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct HsmClientCertificateDeserializer;
impl HsmClientCertificateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<HsmClientCertificate, XmlParseError> {
        deserialize_elements::<_, HsmClientCertificate, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "HsmClientCertificateIdentifier" => {
                    obj.hsm_client_certificate_identifier = Some(StringDeserializer::deserialize(
                        "HsmClientCertificateIdentifier",
                        stack,
                    )?);
                }
                "HsmClientCertificatePublicKey" => {
                    obj.hsm_client_certificate_public_key = Some(StringDeserializer::deserialize(
                        "HsmClientCertificatePublicKey",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct HsmClientCertificateListDeserializer;
impl HsmClientCertificateListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<HsmClientCertificate>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "HsmClientCertificate" {
                obj.push(HsmClientCertificateDeserializer::deserialize(
                    "HsmClientCertificate",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct HsmClientCertificateMessage {
    /// <p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>
    pub hsm_client_certificates: Option<Vec<HsmClientCertificate>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct HsmClientCertificateMessageDeserializer;
impl HsmClientCertificateMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<HsmClientCertificateMessage, XmlParseError> {
        deserialize_elements::<_, HsmClientCertificateMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "HsmClientCertificates" => {
                        obj.hsm_client_certificates.get_or_insert(vec![]).extend(
                            HsmClientCertificateListDeserializer::deserialize(
                                "HsmClientCertificates",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct HsmConfiguration {
    /// <p>A text description of the HSM configuration.</p>
    pub description: Option<String>,
    /// <p>The name of the Amazon Redshift HSM configuration.</p>
    pub hsm_configuration_identifier: Option<String>,
    /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
    pub hsm_ip_address: Option<String>,
    /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
    pub hsm_partition_name: Option<String>,
    /// <p>The list of tags for the HSM configuration.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct HsmConfigurationDeserializer;
impl HsmConfigurationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<HsmConfiguration, XmlParseError> {
        deserialize_elements::<_, HsmConfiguration, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "HsmConfigurationIdentifier" => {
                    obj.hsm_configuration_identifier = Some(StringDeserializer::deserialize(
                        "HsmConfigurationIdentifier",
                        stack,
                    )?);
                }
                "HsmIpAddress" => {
                    obj.hsm_ip_address =
                        Some(StringDeserializer::deserialize("HsmIpAddress", stack)?);
                }
                "HsmPartitionName" => {
                    obj.hsm_partition_name =
                        Some(StringDeserializer::deserialize("HsmPartitionName", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct HsmConfigurationListDeserializer;
impl HsmConfigurationListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<HsmConfiguration>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "HsmConfiguration" {
                obj.push(HsmConfigurationDeserializer::deserialize(
                    "HsmConfiguration",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct HsmConfigurationMessage {
    /// <p>A list of <code>HsmConfiguration</code> objects.</p>
    pub hsm_configurations: Option<Vec<HsmConfiguration>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct HsmConfigurationMessageDeserializer;
impl HsmConfigurationMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<HsmConfigurationMessage, XmlParseError> {
        deserialize_elements::<_, HsmConfigurationMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "HsmConfigurations" => {
                        obj.hsm_configurations.get_or_insert(vec![]).extend(
                            HsmConfigurationListDeserializer::deserialize(
                                "HsmConfigurations",
                                stack,
                            )?,
                        );
                    }
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the status of changes to HSM settings.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct HsmStatus {
    /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    pub hsm_client_certificate_identifier: Option<String>,
    /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    pub hsm_configuration_identifier: Option<String>,
    /// <p>Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p> <p>Values: active, applying</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct HsmStatusDeserializer;
impl HsmStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<HsmStatus, XmlParseError> {
        deserialize_elements::<_, HsmStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "HsmClientCertificateIdentifier" => {
                    obj.hsm_client_certificate_identifier = Some(StringDeserializer::deserialize(
                        "HsmClientCertificateIdentifier",
                        stack,
                    )?);
                }
                "HsmConfigurationIdentifier" => {
                    obj.hsm_configuration_identifier = Some(StringDeserializer::deserialize(
                        "HsmConfigurationIdentifier",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes an IP range used in a security group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct IPRange {
    /// <p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>
    pub cidrip: Option<String>,
    /// <p>The status of the IP range, for example, "authorized".</p>
    pub status: Option<String>,
    /// <p>The list of tags for the IP range.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct IPRangeDeserializer;
impl IPRangeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<IPRange, XmlParseError> {
        deserialize_elements::<_, IPRange, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CIDRIP" => {
                    obj.cidrip = Some(StringDeserializer::deserialize("CIDRIP", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct IPRangeListDeserializer;
impl IPRangeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<IPRange>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "IPRange" {
                obj.push(IPRangeDeserializer::deserialize("IPRange", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `IamRoleArnList` contents to a `SignedRequest`.
struct IamRoleArnListSerializer;
impl IamRoleArnListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ImportTablesCompletedDeserializer;
impl ImportTablesCompletedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ImportTablesInProgressDeserializer;
impl ImportTablesInProgressDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ImportTablesNotStartedDeserializer;
impl ImportTablesNotStartedDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct IntegerDeserializer;
impl IntegerDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct IntegerOptionalDeserializer;
impl IntegerOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
/// <p>Describes the status of logging for a cluster.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct LoggingStatus {
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub bucket_name: Option<String>,
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub last_failure_message: Option<String>,
    /// <p>The last time when logs failed to be delivered.</p>
    pub last_failure_time: Option<String>,
    /// <p>The last time that logs were delivered.</p>
    pub last_successful_delivery_time: Option<String>,
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub logging_enabled: Option<bool>,
    /// <p>The prefix applied to the log file names.</p>
    pub s3_key_prefix: Option<String>,
}

#[allow(dead_code)]
struct LoggingStatusDeserializer;
impl LoggingStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<LoggingStatus, XmlParseError> {
        deserialize_elements::<_, LoggingStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "BucketName" => {
                    obj.bucket_name = Some(StringDeserializer::deserialize("BucketName", stack)?);
                }
                "LastFailureMessage" => {
                    obj.last_failure_message = Some(StringDeserializer::deserialize(
                        "LastFailureMessage",
                        stack,
                    )?);
                }
                "LastFailureTime" => {
                    obj.last_failure_time =
                        Some(TStampDeserializer::deserialize("LastFailureTime", stack)?);
                }
                "LastSuccessfulDeliveryTime" => {
                    obj.last_successful_delivery_time = Some(TStampDeserializer::deserialize(
                        "LastSuccessfulDeliveryTime",
                        stack,
                    )?);
                }
                "LoggingEnabled" => {
                    obj.logging_enabled =
                        Some(BooleanDeserializer::deserialize("LoggingEnabled", stack)?);
                }
                "S3KeyPrefix" => {
                    obj.s3_key_prefix =
                        Some(StringDeserializer::deserialize("S3KeyPrefix", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct LongDeserializer;
impl LongDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
#[allow(dead_code)]
struct LongOptionalDeserializer;
impl LongOptionalDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<i64, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, |s| Ok(i64::from_str(&s).unwrap()))
    }
}
/// <p>Defines a maintenance track that determines which Amazon Redshift version to apply during a maintenance window. If the value for <code>MaintenanceTrack</code> is <code>current</code>, the cluster is updated to the most recently certified maintenance release. If the value is <code>trailing</code>, the cluster is updated to the previously certified maintenance release. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct MaintenanceTrack {
    /// <p>The version number for the cluster release.</p>
    pub database_version: Option<String>,
    /// <p>The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>An array of <a>UpdateTarget</a> objects to update with the maintenance track. </p>
    pub update_targets: Option<Vec<UpdateTarget>>,
}

#[allow(dead_code)]
struct MaintenanceTrackDeserializer;
impl MaintenanceTrackDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<MaintenanceTrack, XmlParseError> {
        deserialize_elements::<_, MaintenanceTrack, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DatabaseVersion" => {
                    obj.database_version =
                        Some(StringDeserializer::deserialize("DatabaseVersion", stack)?);
                }
                "MaintenanceTrackName" => {
                    obj.maintenance_track_name = Some(StringDeserializer::deserialize(
                        "MaintenanceTrackName",
                        stack,
                    )?);
                }
                "UpdateTargets" => {
                    obj.update_targets.get_or_insert(vec![]).extend(
                        EligibleTracksToUpdateListDeserializer::deserialize(
                            "UpdateTargets",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ModeDeserializer;
impl ModeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyAquaInputMessage {
    /// <p><p>The new value of AQUA configuration status. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don&#39;t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul></p>
    pub aqua_configuration_status: Option<String>,
    /// <p>The identifier of the cluster to be modified.</p>
    pub cluster_identifier: String,
}

/// Serialize `ModifyAquaInputMessage` contents to a `SignedRequest`.
struct ModifyAquaInputMessageSerializer;
impl ModifyAquaInputMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyAquaInputMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.aqua_configuration_status {
            params.put(
                &format!("{}{}", prefix, "AquaConfigurationStatus"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyAquaOutputMessage {
    /// <p>The updated AQUA configuration of the cluster. </p>
    pub aqua_configuration: Option<AquaConfiguration>,
}

#[allow(dead_code)]
struct ModifyAquaOutputMessageDeserializer;
impl ModifyAquaOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyAquaOutputMessage, XmlParseError> {
        deserialize_elements::<_, ModifyAquaOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "AquaConfiguration" => {
                        obj.aqua_configuration = Some(AquaConfigurationDeserializer::deserialize(
                            "AquaConfiguration",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterDbRevisionMessage {
    /// <p>The unique identifier of a cluster whose database revision you want to modify. </p> <p>Example: <code>examplecluster</code> </p>
    pub cluster_identifier: String,
    /// <p>The identifier of the database revision. You can retrieve this value from the response to the <a>DescribeClusterDbRevisions</a> request.</p>
    pub revision_target: String,
}

/// Serialize `ModifyClusterDbRevisionMessage` contents to a `SignedRequest`.
struct ModifyClusterDbRevisionMessageSerializer;
impl ModifyClusterDbRevisionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterDbRevisionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "RevisionTarget"),
            &obj.revision_target,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyClusterDbRevisionResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ModifyClusterDbRevisionResultDeserializer;
impl ModifyClusterDbRevisionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyClusterDbRevisionResult, XmlParseError> {
        deserialize_elements::<_, ModifyClusterDbRevisionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterIamRolesMessage {
    /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles with a single cluster in a single request.</p>
    pub add_iam_roles: Option<Vec<String>>,
    /// <p>The unique identifier of the cluster for which you want to associate or disassociate IAM roles.</p>
    pub cluster_identifier: String,
    /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. You can disassociate up to 10 IAM roles from a single cluster in a single request.</p>
    pub remove_iam_roles: Option<Vec<String>>,
}

/// Serialize `ModifyClusterIamRolesMessage` contents to a `SignedRequest`.
struct ModifyClusterIamRolesMessageSerializer;
impl ModifyClusterIamRolesMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterIamRolesMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.add_iam_roles {
            IamRoleArnListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "IamRoleArn"),
                field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.remove_iam_roles {
            IamRoleArnListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "IamRoleArn"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyClusterIamRolesResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ModifyClusterIamRolesResultDeserializer;
impl ModifyClusterIamRolesResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyClusterIamRolesResult, XmlParseError> {
        deserialize_elements::<_, ModifyClusterIamRolesResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterMaintenanceMessage {
    /// <p>A unique identifier for the cluster.</p>
    pub cluster_identifier: String,
    /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
    pub defer_maintenance: Option<bool>,
    /// <p>An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.</p>
    pub defer_maintenance_duration: Option<i64>,
    /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.</p>
    pub defer_maintenance_end_time: Option<String>,
    /// <p>A unique identifier for the deferred maintenance window.</p>
    pub defer_maintenance_identifier: Option<String>,
    /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
    pub defer_maintenance_start_time: Option<String>,
}

/// Serialize `ModifyClusterMaintenanceMessage` contents to a `SignedRequest`.
struct ModifyClusterMaintenanceMessageSerializer;
impl ModifyClusterMaintenanceMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterMaintenanceMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.defer_maintenance {
            params.put(&format!("{}{}", prefix, "DeferMaintenance"), &field_value);
        }
        if let Some(ref field_value) = obj.defer_maintenance_duration {
            params.put(
                &format!("{}{}", prefix, "DeferMaintenanceDuration"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.defer_maintenance_end_time {
            params.put(
                &format!("{}{}", prefix, "DeferMaintenanceEndTime"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.defer_maintenance_identifier {
            params.put(
                &format!("{}{}", prefix, "DeferMaintenanceIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.defer_maintenance_start_time {
            params.put(
                &format!("{}{}", prefix, "DeferMaintenanceStartTime"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyClusterMaintenanceResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ModifyClusterMaintenanceResultDeserializer;
impl ModifyClusterMaintenanceResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyClusterMaintenanceResult, XmlParseError> {
        deserialize_elements::<_, ModifyClusterMaintenanceResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterMessage {
    /// <p>If <code>true</code>, major version upgrades will be applied automatically to the cluster during the maintenance window. </p> <p>Default: <code>false</code> </p>
    pub allow_version_upgrade: Option<bool>,
    /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p> <p>If you decrease the automated snapshot retention period from its current value, existing automated snapshots that fall outside of the new retention period will be immediately deleted.</p> <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p> <p>Default: Uses existing setting.</p> <p>Constraints: Must be a value from 0 to 35.</p>
    pub automated_snapshot_retention_period: Option<i64>,
    /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
    pub availability_zone: Option<String>,
    /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
    pub availability_zone_relocation: Option<bool>,
    /// <p>The unique identifier of the cluster to be modified.</p> <p>Example: <code>examplecluster</code> </p>
    pub cluster_identifier: String,
    /// <p>The name of the cluster parameter group to apply to this cluster. This change is applied only after the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p> <p>Default: Uses existing setting.</p> <p>Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster version.</p>
    pub cluster_parameter_group_name: Option<String>,
    /// <p><p>A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as soon as possible.</p> <p>Security groups currently associated with the cluster, and not in the list of groups to apply, will be revoked from the cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul></p>
    pub cluster_security_groups: Option<Vec<String>>,
    /// <p>The new cluster type.</p> <p>When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while the old cluster is deleted and your connection is switched to the new cluster. You can use <a>DescribeResize</a> to track the progress of the resize request. </p> <p>Valid Values: <code> multi-node | single-node </code> </p>
    pub cluster_type: Option<String>,
    /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p> <p>For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster parameter group in the cluster parameter group family for the new version must be specified. The new cluster parameter group can be the default for that cluster parameter group family. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>Example: <code>1.0</code> </p>
    pub cluster_version: Option<String>,
    /// <p>The Elastic IP (EIP) address for the cluster.</p> <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
    pub elastic_ip: Option<String>,
    /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>, we encrypt with the default key. </p> <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
    pub encrypted: Option<bool>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>
    pub enhanced_vpc_routing: Option<bool>,
    /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    pub hsm_client_certificate_identifier: Option<String>,
    /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    pub hsm_configuration_identifier: Option<String>,
    /// <p>The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>The default for number of days that a newly created manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. This value doesn't retroactively change the retention periods of existing manual snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p> <p>The default value is -1.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p><p>The new password for the cluster master user. This change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <note> <p>Operations never return the password, so this operation provides a way to regain access to the master user account for a cluster if the password is lost.</p> </note> <p>Default: Uses existing setting.</p> <p>Constraints:</p> <ul> <li> <p>Must be between 8 and 64 characters in length.</p> </li> <li> <p>Must contain at least one uppercase letter.</p> </li> <li> <p>Must contain at least one lowercase letter.</p> </li> <li> <p>Must contain one number.</p> </li> <li> <p>Can be any printable ASCII character (ASCII code 33 to 126) except &#39; (single quote), &quot; (double quote), \, /, @, or space.</p> </li> </ul></p>
    pub master_user_password: Option<String>,
    /// <p>The new identifier for the cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an AWS account.</p> </li> </ul> <p>Example: <code>examplecluster</code> </p>
    pub new_cluster_identifier: Option<String>,
    /// <p>The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes parameter.</p> <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
    pub node_type: Option<String>,
    /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node type parameter.</p> <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>Valid Values: Integer greater than <code>0</code>.</p>
    pub number_of_nodes: Option<i64>,
    /// <p>The option to change the port of an Amazon Redshift cluster.</p>
    pub port: Option<i64>,
    /// <p>The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance is necessary during the window, it may result in an outage.</p> <p>This maintenance window change is made immediately. If the new maintenance window indicates the current time, there must be at least 120 minutes between the current time and end of the window in order to ensure that pending changes are applied.</p> <p>Default: Uses existing setting.</p> <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Must be at least 30 minutes.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to be publicly available.</p>
    pub publicly_accessible: Option<bool>,
    /// <p>A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is asynchronously applied as soon as possible.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `ModifyClusterMessage` contents to a `SignedRequest`.
struct ModifyClusterMessageSerializer;
impl ModifyClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allow_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AllowVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.automated_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "AutomatedSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.availability_zone_relocation {
            params.put(
                &format!("{}{}", prefix, "AvailabilityZoneRelocation"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_security_groups {
            ClusterSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClusterSecurityGroupName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_type {
            params.put(&format!("{}{}", prefix, "ClusterType"), &field_value);
        }
        if let Some(ref field_value) = obj.cluster_version {
            params.put(&format!("{}{}", prefix, "ClusterVersion"), &field_value);
        }
        if let Some(ref field_value) = obj.elastic_ip {
            params.put(&format!("{}{}", prefix, "ElasticIp"), &field_value);
        }
        if let Some(ref field_value) = obj.encrypted {
            params.put(&format!("{}{}", prefix, "Encrypted"), &field_value);
        }
        if let Some(ref field_value) = obj.enhanced_vpc_routing {
            params.put(&format!("{}{}", prefix, "EnhancedVpcRouting"), &field_value);
        }
        if let Some(ref field_value) = obj.hsm_client_certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmClientCertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.hsm_configuration_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmConfigurationIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.maintenance_track_name {
            params.put(
                &format!("{}{}", prefix, "MaintenanceTrackName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.master_user_password {
            params.put(&format!("{}{}", prefix, "MasterUserPassword"), &field_value);
        }
        if let Some(ref field_value) = obj.new_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "NewClusterIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.node_type {
            params.put(&format!("{}{}", prefix, "NodeType"), &field_value);
        }
        if let Some(ref field_value) = obj.number_of_nodes {
            params.put(&format!("{}{}", prefix, "NumberOfNodes"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// <p>Describes a modify cluster parameter group operation. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterParameterGroupMessage {
    /// <p>The name of the parameter group to be modified.</p>
    pub parameter_group_name: String,
    /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified in a single request.</p> <p>For each parameter to be modified, you must supply at least the parameter name and parameter value; other name-value pairs of the parameter are optional.</p> <p>For the workload management (WLM) configuration, you must supply all the name-value pairs in the wlm_json_configuration parameter.</p>
    pub parameters: Vec<Parameter>,
}

/// Serialize `ModifyClusterParameterGroupMessage` contents to a `SignedRequest`.
struct ModifyClusterParameterGroupMessageSerializer;
impl ModifyClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ParameterGroupName"),
            &obj.parameter_group_name,
        );
        ParametersListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "Parameter"),
            &obj.parameters,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ModifyClusterResultDeserializer;
impl ModifyClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyClusterResult, XmlParseError> {
        deserialize_elements::<_, ModifyClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterSnapshotMessage {
    /// <p>A Boolean option to override an exception if the retention period has already passed.</p>
    pub force: Option<bool>,
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p> <p>If the manual snapshot falls outside of the new retention period, you can specify the force option to immediately delete the snapshot.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>The identifier of the snapshot whose setting you want to modify.</p>
    pub snapshot_identifier: String,
}

/// Serialize `ModifyClusterSnapshotMessage` contents to a `SignedRequest`.
struct ModifyClusterSnapshotMessageSerializer;
impl ModifyClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.force {
            params.put(&format!("{}{}", prefix, "Force"), &field_value);
        }
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyClusterSnapshotResult {
    pub snapshot: Option<Snapshot>,
}

#[allow(dead_code)]
struct ModifyClusterSnapshotResultDeserializer;
impl ModifyClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, ModifyClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Snapshot" => {
                        obj.snapshot = Some(SnapshotDeserializer::deserialize("Snapshot", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterSnapshotScheduleMessage {
    /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify. </p>
    pub cluster_identifier: String,
    /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.</p>
    pub disassociate_schedule: Option<bool>,
    /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the cluster.</p>
    pub schedule_identifier: Option<String>,
}

/// Serialize `ModifyClusterSnapshotScheduleMessage` contents to a `SignedRequest`.
struct ModifyClusterSnapshotScheduleMessageSerializer;
impl ModifyClusterSnapshotScheduleMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterSnapshotScheduleMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.disassociate_schedule {
            params.put(
                &format!("{}{}", prefix, "DisassociateSchedule"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.schedule_identifier {
            params.put(&format!("{}{}", prefix, "ScheduleIdentifier"), &field_value);
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyClusterSubnetGroupMessage {
    /// <p>The name of the subnet group to be modified.</p>
    pub cluster_subnet_group_name: String,
    /// <p>A text description of the subnet group to be modified.</p>
    pub description: Option<String>,
    /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
    pub subnet_ids: Vec<String>,
}

/// Serialize `ModifyClusterSubnetGroupMessage` contents to a `SignedRequest`.
struct ModifyClusterSubnetGroupMessageSerializer;
impl ModifyClusterSubnetGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyClusterSubnetGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterSubnetGroupName"),
            &obj.cluster_subnet_group_name,
        );
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        SubnetIdentifierListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "SubnetIdentifier"),
            &obj.subnet_ids,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyClusterSubnetGroupResult {
    pub cluster_subnet_group: Option<ClusterSubnetGroup>,
}

#[allow(dead_code)]
struct ModifyClusterSubnetGroupResultDeserializer;
impl ModifyClusterSubnetGroupResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyClusterSubnetGroupResult, XmlParseError> {
        deserialize_elements::<_, ModifyClusterSubnetGroupResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSubnetGroup" => {
                        obj.cluster_subnet_group =
                            Some(ClusterSubnetGroupDeserializer::deserialize(
                                "ClusterSubnetGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyEndpointAccessMessage {
    /// <p>The endpoint to be modified.</p>
    pub endpoint_name: String,
    /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `ModifyEndpointAccessMessage` contents to a `SignedRequest`.
struct ModifyEndpointAccessMessageSerializer;
impl ModifyEndpointAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyEndpointAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "EndpointName"), &obj.endpoint_name);
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyEventSubscriptionMessage {
    /// <p>A Boolean value indicating if the subscription is enabled. <code>true</code> indicates the subscription is enabled </p>
    pub enabled: Option<bool>,
    /// <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p> <p>Values: configuration, management, monitoring, security</p>
    pub event_categories: Option<Vec<String>>,
    /// <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p> <p>Values: ERROR, INFO</p>
    pub severity: Option<String>,
    /// <p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification subscription.</p>
    pub sns_topic_arn: Option<String>,
    /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p> <p>Example: my-cluster-1, my-cluster-2</p> <p>Example: my-snapshot-20131010</p>
    pub source_ids: Option<Vec<String>>,
    /// <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your AWS account. You must specify a source type in order to specify source IDs.</p> <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
    pub source_type: Option<String>,
    /// <p>The name of the modified Amazon Redshift event notification subscription.</p>
    pub subscription_name: String,
}

/// Serialize `ModifyEventSubscriptionMessage` contents to a `SignedRequest`.
struct ModifyEventSubscriptionMessageSerializer;
impl ModifyEventSubscriptionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyEventSubscriptionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enabled {
            params.put(&format!("{}{}", prefix, "Enabled"), &field_value);
        }
        if let Some(ref field_value) = obj.event_categories {
            EventCategoriesListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "EventCategory"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.severity {
            params.put(&format!("{}{}", prefix, "Severity"), &field_value);
        }
        if let Some(ref field_value) = obj.sns_topic_arn {
            params.put(&format!("{}{}", prefix, "SnsTopicArn"), &field_value);
        }
        if let Some(ref field_value) = obj.source_ids {
            SourceIdsListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "SourceId"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.source_type {
            params.put(&format!("{}{}", prefix, "SourceType"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SubscriptionName"),
            &obj.subscription_name,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifyEventSubscriptionResult {
    pub event_subscription: Option<EventSubscription>,
}

#[allow(dead_code)]
struct ModifyEventSubscriptionResultDeserializer;
impl ModifyEventSubscriptionResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifyEventSubscriptionResult, XmlParseError> {
        deserialize_elements::<_, ModifyEventSubscriptionResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EventSubscription" => {
                        obj.event_subscription = Some(EventSubscriptionDeserializer::deserialize(
                            "EventSubscription",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyScheduledActionMessage {
    /// <p>A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled action is disabled. </p>
    pub enable: Option<bool>,
    /// <p>A modified end time of the scheduled action. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub end_time: Option<String>,
    /// <p>A different IAM role to assume to run the target action. For more information about this parameter, see <a>ScheduledAction</a>.</p>
    pub iam_role: Option<String>,
    /// <p>A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <a>ScheduledAction</a>.</p>
    pub schedule: Option<String>,
    /// <p>A modified description of the scheduled action. </p>
    pub scheduled_action_description: Option<String>,
    /// <p>The name of the scheduled action to modify. </p>
    pub scheduled_action_name: String,
    /// <p>A modified start time of the scheduled action. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub start_time: Option<String>,
    /// <p>A modified JSON format of the scheduled action. For more information about this parameter, see <a>ScheduledAction</a>. </p>
    pub target_action: Option<ScheduledActionType>,
}

/// Serialize `ModifyScheduledActionMessage` contents to a `SignedRequest`.
struct ModifyScheduledActionMessageSerializer;
impl ModifyScheduledActionMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyScheduledActionMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.enable {
            params.put(&format!("{}{}", prefix, "Enable"), &field_value);
        }
        if let Some(ref field_value) = obj.end_time {
            params.put(&format!("{}{}", prefix, "EndTime"), &field_value);
        }
        if let Some(ref field_value) = obj.iam_role {
            params.put(&format!("{}{}", prefix, "IamRole"), &field_value);
        }
        if let Some(ref field_value) = obj.schedule {
            params.put(&format!("{}{}", prefix, "Schedule"), &field_value);
        }
        if let Some(ref field_value) = obj.scheduled_action_description {
            params.put(
                &format!("{}{}", prefix, "ScheduledActionDescription"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ScheduledActionName"),
            &obj.scheduled_action_name,
        );
        if let Some(ref field_value) = obj.start_time {
            params.put(&format!("{}{}", prefix, "StartTime"), &field_value);
        }
        if let Some(ref field_value) = obj.target_action {
            ScheduledActionTypeSerializer::serialize(
                params,
                &format!("{}{}", prefix, "TargetAction"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifySnapshotCopyRetentionPeriodMessage {
    /// <p>The unique identifier of the cluster for which you want to change the retention period for either automated or manual snapshots that are copied to a destination AWS Region.</p> <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>
    pub cluster_identifier: String,
    /// <p>Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.</p>
    pub manual: Option<bool>,
    /// <p>The number of days to retain automated snapshots in the destination AWS Region after they are copied from the source AWS Region.</p> <p>By default, this only changes the retention period of copied automated snapshots. </p> <p>If you decrease the retention period for automated snapshots that are copied to a destination AWS Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination AWS Region and that fall outside of the new retention period.</p> <p>Constraints: Must be at least 1 and no more than 35 for automated snapshots. </p> <p>If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period. </p> <p>If you specify the value of -1 newly copied manual snapshots are retained indefinitely.</p> <p>Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.</p>
    pub retention_period: i64,
}

/// Serialize `ModifySnapshotCopyRetentionPeriodMessage` contents to a `SignedRequest`.
struct ModifySnapshotCopyRetentionPeriodMessageSerializer;
impl ModifySnapshotCopyRetentionPeriodMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifySnapshotCopyRetentionPeriodMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.manual {
            params.put(&format!("{}{}", prefix, "Manual"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "RetentionPeriod"),
            &obj.retention_period,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ModifySnapshotCopyRetentionPeriodResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ModifySnapshotCopyRetentionPeriodResultDeserializer;
impl ModifySnapshotCopyRetentionPeriodResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ModifySnapshotCopyRetentionPeriodResult, XmlParseError> {
        deserialize_elements::<_, ModifySnapshotCopyRetentionPeriodResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifySnapshotScheduleMessage {
    /// <p>An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for example, "cron(30 12 *)" or "rate(12 hours)".</p>
    pub schedule_definitions: Vec<String>,
    /// <p>A unique alphanumeric identifier of the schedule to modify.</p>
    pub schedule_identifier: String,
}

/// Serialize `ModifySnapshotScheduleMessage` contents to a `SignedRequest`.
struct ModifySnapshotScheduleMessageSerializer;
impl ModifySnapshotScheduleMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifySnapshotScheduleMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        ScheduleDefinitionListSerializer::serialize(
            params,
            &format!("{}{}", prefix, "ScheduleDefinition"),
            &obj.schedule_definitions,
        );
        params.put(
            &format!("{}{}", prefix, "ScheduleIdentifier"),
            &obj.schedule_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ModifyUsageLimitMessage {
    /// <p>The new limit amount. For more information about this parameter, see <a>UsageLimit</a>. </p>
    pub amount: Option<i64>,
    /// <p>The new action that Amazon Redshift takes when the limit is reached. For more information about this parameter, see <a>UsageLimit</a>. </p>
    pub breach_action: Option<String>,
    /// <p>The identifier of the usage limit to modify.</p>
    pub usage_limit_id: String,
}

/// Serialize `ModifyUsageLimitMessage` contents to a `SignedRequest`.
struct ModifyUsageLimitMessageSerializer;
impl ModifyUsageLimitMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ModifyUsageLimitMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.amount {
            params.put(&format!("{}{}", prefix, "Amount"), &field_value);
        }
        if let Some(ref field_value) = obj.breach_action {
            params.put(&format!("{}{}", prefix, "BreachAction"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "UsageLimitId"),
            &obj.usage_limit_id,
        );
    }
}

/// <p>Describes a network interface. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct NetworkInterface {
    /// <p>The Availability Zone. </p>
    pub availability_zone: Option<String>,
    /// <p>The network interface identifier. </p>
    pub network_interface_id: Option<String>,
    /// <p>The IPv4 address of the network interface within the subnet. </p>
    pub private_ip_address: Option<String>,
    /// <p>The subnet identifier. </p>
    pub subnet_id: Option<String>,
}

#[allow(dead_code)]
struct NetworkInterfaceDeserializer;
impl NetworkInterfaceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<NetworkInterface, XmlParseError> {
        deserialize_elements::<_, NetworkInterface, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AvailabilityZone" => {
                    obj.availability_zone =
                        Some(StringDeserializer::deserialize("AvailabilityZone", stack)?);
                }
                "NetworkInterfaceId" => {
                    obj.network_interface_id = Some(StringDeserializer::deserialize(
                        "NetworkInterfaceId",
                        stack,
                    )?);
                }
                "PrivateIpAddress" => {
                    obj.private_ip_address =
                        Some(StringDeserializer::deserialize("PrivateIpAddress", stack)?);
                }
                "SubnetId" => {
                    obj.subnet_id = Some(StringDeserializer::deserialize("SubnetId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct NetworkInterfaceListDeserializer;
impl NetworkInterfaceListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<NetworkInterface>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "NetworkInterface" {
                obj.push(NetworkInterfaceDeserializer::deserialize(
                    "NetworkInterface",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>A list of node configurations.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct NodeConfigurationOption {
    /// <p>The estimated disk utilizaton percentage.</p>
    pub estimated_disk_utilization_percent: Option<f64>,
    /// <p>The category of the node configuration recommendation.</p>
    pub mode: Option<String>,
    /// <p>The node type, such as, "ds2.8xlarge".</p>
    pub node_type: Option<String>,
    /// <p>The number of nodes.</p>
    pub number_of_nodes: Option<i64>,
}

#[allow(dead_code)]
struct NodeConfigurationOptionDeserializer;
impl NodeConfigurationOptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<NodeConfigurationOption, XmlParseError> {
        deserialize_elements::<_, NodeConfigurationOption, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "EstimatedDiskUtilizationPercent" => {
                        obj.estimated_disk_utilization_percent =
                            Some(DoubleOptionalDeserializer::deserialize(
                                "EstimatedDiskUtilizationPercent",
                                stack,
                            )?);
                    }
                    "Mode" => {
                        obj.mode = Some(ModeDeserializer::deserialize("Mode", stack)?);
                    }
                    "NodeType" => {
                        obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                    }
                    "NumberOfNodes" => {
                        obj.number_of_nodes =
                            Some(IntegerDeserializer::deserialize("NumberOfNodes", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct NodeConfigurationOptionListDeserializer;
impl NodeConfigurationOptionListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<NodeConfigurationOption>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "NodeConfigurationOption" {
                obj.push(NodeConfigurationOptionDeserializer::deserialize(
                    "NodeConfigurationOption",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>A set of elements to filter the returned node configurations.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct NodeConfigurationOptionsFilter {
    /// <p>The name of the element to filter.</p>
    pub name: Option<String>,
    /// <p>The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of values for 'in'.</p>
    pub operator: Option<String>,
    /// <p>List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).</p>
    pub values: Option<Vec<String>>,
}

/// Serialize `NodeConfigurationOptionsFilter` contents to a `SignedRequest`.
struct NodeConfigurationOptionsFilterSerializer;
impl NodeConfigurationOptionsFilterSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &NodeConfigurationOptionsFilter) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.name {
            params.put(&format!("{}{}", prefix, "Name"), &field_value);
        }
        if let Some(ref field_value) = obj.operator {
            params.put(&format!("{}{}", prefix, "Operator"), &field_value);
        }
        if let Some(ref field_value) = obj.values {
            ValueStringListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "item"),
                field_value,
            );
        }
    }
}

/// Serialize `NodeConfigurationOptionsFilterList` contents to a `SignedRequest`.
struct NodeConfigurationOptionsFilterListSerializer;
impl NodeConfigurationOptionsFilterListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<NodeConfigurationOptionsFilter>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            NodeConfigurationOptionsFilterSerializer::serialize(params, &key, obj);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct NodeConfigurationOptionsMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>A list of valid node configurations.</p>
    pub node_configuration_option_list: Option<Vec<NodeConfigurationOption>>,
}

#[allow(dead_code)]
struct NodeConfigurationOptionsMessageDeserializer;
impl NodeConfigurationOptionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<NodeConfigurationOptionsMessage, XmlParseError> {
        deserialize_elements::<_, NodeConfigurationOptionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "NodeConfigurationOptionList" => {
                        obj.node_configuration_option_list
                            .get_or_insert(vec![])
                            .extend(NodeConfigurationOptionListDeserializer::deserialize(
                                "NodeConfigurationOptionList",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes an orderable cluster option.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OrderableClusterOption {
    /// <p>A list of availability zones for the orderable cluster.</p>
    pub availability_zones: Option<Vec<AvailabilityZone>>,
    /// <p>The cluster type, for example <code>multi-node</code>. </p>
    pub cluster_type: Option<String>,
    /// <p>The version of the orderable cluster.</p>
    pub cluster_version: Option<String>,
    /// <p>The node type for the orderable cluster.</p>
    pub node_type: Option<String>,
}

#[allow(dead_code)]
struct OrderableClusterOptionDeserializer;
impl OrderableClusterOptionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OrderableClusterOption, XmlParseError> {
        deserialize_elements::<_, OrderableClusterOption, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AvailabilityZones" => {
                    obj.availability_zones.get_or_insert(vec![]).extend(
                        AvailabilityZoneListDeserializer::deserialize("AvailabilityZones", stack)?,
                    );
                }
                "ClusterType" => {
                    obj.cluster_type = Some(StringDeserializer::deserialize("ClusterType", stack)?);
                }
                "ClusterVersion" => {
                    obj.cluster_version =
                        Some(StringDeserializer::deserialize("ClusterVersion", stack)?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct OrderableClusterOptionsListDeserializer;
impl OrderableClusterOptionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<OrderableClusterOption>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "OrderableClusterOption" {
                obj.push(OrderableClusterOptionDeserializer::deserialize(
                    "OrderableClusterOption",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeOrderableClusterOptions</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct OrderableClusterOptionsMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>
    pub orderable_cluster_options: Option<Vec<OrderableClusterOption>>,
}

#[allow(dead_code)]
struct OrderableClusterOptionsMessageDeserializer;
impl OrderableClusterOptionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<OrderableClusterOptionsMessage, XmlParseError> {
        deserialize_elements::<_, OrderableClusterOptionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "OrderableClusterOptions" => {
                        obj.orderable_cluster_options.get_or_insert(vec![]).extend(
                            OrderableClusterOptionsListDeserializer::deserialize(
                                "OrderableClusterOptions",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a parameter in a cluster parameter group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Parameter {
    /// <p>The valid range of values for the parameter.</p>
    pub allowed_values: Option<String>,
    /// <p>Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    pub apply_type: Option<String>,
    /// <p>The data type of the parameter.</p>
    pub data_type: Option<String>,
    /// <p>A description of the parameter.</p>
    pub description: Option<String>,
    /// <p>If <code>true</code>, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
    pub is_modifiable: Option<bool>,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: Option<String>,
    /// <p>The name of the parameter.</p>
    pub parameter_name: Option<String>,
    /// <p>The value of the parameter. If <code>ParameterName</code> is <code>wlm_json_configuration</code>, then the maximum size of <code>ParameterValue</code> is 8000 characters.</p>
    pub parameter_value: Option<String>,
    /// <p>The source of the parameter value, such as "engine-default" or "user".</p>
    pub source: Option<String>,
}

#[allow(dead_code)]
struct ParameterDeserializer;
impl ParameterDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Parameter, XmlParseError> {
        deserialize_elements::<_, Parameter, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowedValues" => {
                    obj.allowed_values =
                        Some(StringDeserializer::deserialize("AllowedValues", stack)?);
                }
                "ApplyType" => {
                    obj.apply_type = Some(ParameterApplyTypeDeserializer::deserialize(
                        "ApplyType",
                        stack,
                    )?);
                }
                "DataType" => {
                    obj.data_type = Some(StringDeserializer::deserialize("DataType", stack)?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                "IsModifiable" => {
                    obj.is_modifiable =
                        Some(BooleanDeserializer::deserialize("IsModifiable", stack)?);
                }
                "MinimumEngineVersion" => {
                    obj.minimum_engine_version = Some(StringDeserializer::deserialize(
                        "MinimumEngineVersion",
                        stack,
                    )?);
                }
                "ParameterName" => {
                    obj.parameter_name =
                        Some(StringDeserializer::deserialize("ParameterName", stack)?);
                }
                "ParameterValue" => {
                    obj.parameter_value =
                        Some(StringDeserializer::deserialize("ParameterValue", stack)?);
                }
                "Source" => {
                    obj.source = Some(StringDeserializer::deserialize("Source", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `Parameter` contents to a `SignedRequest`.
struct ParameterSerializer;
impl ParameterSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Parameter) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.allowed_values {
            params.put(&format!("{}{}", prefix, "AllowedValues"), &field_value);
        }
        if let Some(ref field_value) = obj.apply_type {
            params.put(&format!("{}{}", prefix, "ApplyType"), &field_value);
        }
        if let Some(ref field_value) = obj.data_type {
            params.put(&format!("{}{}", prefix, "DataType"), &field_value);
        }
        if let Some(ref field_value) = obj.description {
            params.put(&format!("{}{}", prefix, "Description"), &field_value);
        }
        if let Some(ref field_value) = obj.is_modifiable {
            params.put(&format!("{}{}", prefix, "IsModifiable"), &field_value);
        }
        if let Some(ref field_value) = obj.minimum_engine_version {
            params.put(
                &format!("{}{}", prefix, "MinimumEngineVersion"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.parameter_name {
            params.put(&format!("{}{}", prefix, "ParameterName"), &field_value);
        }
        if let Some(ref field_value) = obj.parameter_value {
            params.put(&format!("{}{}", prefix, "ParameterValue"), &field_value);
        }
        if let Some(ref field_value) = obj.source {
            params.put(&format!("{}{}", prefix, "Source"), &field_value);
        }
    }
}

#[allow(dead_code)]
struct ParameterApplyTypeDeserializer;
impl ParameterApplyTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ParameterGroupListDeserializer;
impl ParameterGroupListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ClusterParameterGroup>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ClusterParameterGroup" {
                obj.push(ClusterParameterGroupDeserializer::deserialize(
                    "ClusterParameterGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ParametersListDeserializer;
impl ParametersListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Parameter>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Parameter" {
                obj.push(ParameterDeserializer::deserialize("Parameter", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ParametersList` contents to a `SignedRequest`.
struct ParametersListSerializer;
impl ParametersListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<Parameter>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            ParameterSerializer::serialize(params, &key, obj);
        }
    }
}

#[allow(dead_code)]
struct PartnerIntegrationDatabaseNameDeserializer;
impl PartnerIntegrationDatabaseNameDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a partner integration.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PartnerIntegrationInfo {
    /// <p>The date (UTC) that the partner integration was created.</p>
    pub created_at: Option<String>,
    /// <p>The name of the database that receives data from a partner.</p>
    pub database_name: Option<String>,
    /// <p>The name of the partner.</p>
    pub partner_name: Option<String>,
    /// <p>The partner integration status.</p>
    pub status: Option<String>,
    /// <p>The status message provided by the partner.</p>
    pub status_message: Option<String>,
    /// <p>The date (UTC) that the partner integration status was last updated by the partner.</p>
    pub updated_at: Option<String>,
}

#[allow(dead_code)]
struct PartnerIntegrationInfoDeserializer;
impl PartnerIntegrationInfoDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PartnerIntegrationInfo, XmlParseError> {
        deserialize_elements::<_, PartnerIntegrationInfo, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CreatedAt" => {
                    obj.created_at = Some(TStampDeserializer::deserialize("CreatedAt", stack)?);
                }
                "DatabaseName" => {
                    obj.database_name =
                        Some(PartnerIntegrationDatabaseNameDeserializer::deserialize(
                            "DatabaseName",
                            stack,
                        )?);
                }
                "PartnerName" => {
                    obj.partner_name =
                        Some(PartnerIntegrationPartnerNameDeserializer::deserialize(
                            "PartnerName",
                            stack,
                        )?);
                }
                "Status" => {
                    obj.status = Some(PartnerIntegrationStatusDeserializer::deserialize(
                        "Status", stack,
                    )?);
                }
                "StatusMessage" => {
                    obj.status_message =
                        Some(PartnerIntegrationStatusMessageDeserializer::deserialize(
                            "StatusMessage",
                            stack,
                        )?);
                }
                "UpdatedAt" => {
                    obj.updated_at = Some(TStampDeserializer::deserialize("UpdatedAt", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PartnerIntegrationInfoListDeserializer;
impl PartnerIntegrationInfoListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<PartnerIntegrationInfo>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "PartnerIntegrationInfo" {
                obj.push(PartnerIntegrationInfoDeserializer::deserialize(
                    "PartnerIntegrationInfo",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PartnerIntegrationInputMessage {
    /// <p>The AWS account ID that owns the cluster.</p>
    pub account_id: String,
    /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
    pub cluster_identifier: String,
    /// <p>The name of the database that receives data from the partner.</p>
    pub database_name: String,
    /// <p>The name of the partner that is authorized to send data.</p>
    pub partner_name: String,
}

/// Serialize `PartnerIntegrationInputMessage` contents to a `SignedRequest`.
struct PartnerIntegrationInputMessageSerializer;
impl PartnerIntegrationInputMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PartnerIntegrationInputMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccountId"), &obj.account_id);
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        params.put(&format!("{}{}", prefix, "DatabaseName"), &obj.database_name);
        params.put(&format!("{}{}", prefix, "PartnerName"), &obj.partner_name);
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PartnerIntegrationOutputMessage {
    /// <p>The name of the database that receives data from the partner.</p>
    pub database_name: Option<String>,
    /// <p>The name of the partner that is authorized to send data.</p>
    pub partner_name: Option<String>,
}

#[allow(dead_code)]
struct PartnerIntegrationOutputMessageDeserializer;
impl PartnerIntegrationOutputMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PartnerIntegrationOutputMessage, XmlParseError> {
        deserialize_elements::<_, PartnerIntegrationOutputMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "DatabaseName" => {
                        obj.database_name =
                            Some(PartnerIntegrationDatabaseNameDeserializer::deserialize(
                                "DatabaseName",
                                stack,
                            )?);
                    }
                    "PartnerName" => {
                        obj.partner_name =
                            Some(PartnerIntegrationPartnerNameDeserializer::deserialize(
                                "PartnerName",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct PartnerIntegrationPartnerNameDeserializer;
impl PartnerIntegrationPartnerNameDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PartnerIntegrationStatusDeserializer;
impl PartnerIntegrationStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct PartnerIntegrationStatusMessageDeserializer;
impl PartnerIntegrationStatusMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a pause cluster operation. For example, a scheduled action to run the <code>PauseCluster</code> API operation. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PauseClusterMessage {
    /// <p>The identifier of the cluster to be paused.</p>
    pub cluster_identifier: String,
}

#[allow(dead_code)]
struct PauseClusterMessageDeserializer;
impl PauseClusterMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PauseClusterMessage, XmlParseError> {
        deserialize_elements::<_, PauseClusterMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        StringDeserializer::deserialize("ClusterIdentifier", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `PauseClusterMessage` contents to a `SignedRequest`.
struct PauseClusterMessageSerializer;
impl PauseClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PauseClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PauseClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct PauseClusterResultDeserializer;
impl PauseClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PauseClusterResult, XmlParseError> {
        deserialize_elements::<_, PauseClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct PendingActionsListDeserializer;
impl PendingActionsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(StringDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes cluster attributes that are in a pending state. A change to one or more the attributes was requested and is in progress or will be applied.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PendingModifiedValues {
    /// <p>The pending or in-progress change of the automated snapshot retention period.</p>
    pub automated_snapshot_retention_period: Option<i64>,
    /// <p>The pending or in-progress change of the new identifier for the cluster.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The pending or in-progress change of the cluster type.</p>
    pub cluster_type: Option<String>,
    /// <p>The pending or in-progress change of the service version.</p>
    pub cluster_version: Option<String>,
    /// <p>The encryption type for a cluster. Possible values are: KMS and None. </p>
    pub encryption_type: Option<String>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>
    pub enhanced_vpc_routing: Option<bool>,
    /// <p>The name of the maintenance track that the cluster will change to during the next maintenance window.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>The pending or in-progress change of the master user password for the cluster.</p>
    pub master_user_password: Option<String>,
    /// <p>The pending or in-progress change of the cluster's node type.</p>
    pub node_type: Option<String>,
    /// <p>The pending or in-progress change of the number of nodes in the cluster.</p>
    pub number_of_nodes: Option<i64>,
    /// <p>The pending or in-progress change of the ability to connect to the cluster from the public network.</p>
    pub publicly_accessible: Option<bool>,
}

#[allow(dead_code)]
struct PendingModifiedValuesDeserializer;
impl PendingModifiedValuesDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PendingModifiedValues, XmlParseError> {
        deserialize_elements::<_, PendingModifiedValues, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AutomatedSnapshotRetentionPeriod" => {
                    obj.automated_snapshot_retention_period =
                        Some(IntegerOptionalDeserializer::deserialize(
                            "AutomatedSnapshotRetentionPeriod",
                            stack,
                        )?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "ClusterType" => {
                    obj.cluster_type = Some(StringDeserializer::deserialize("ClusterType", stack)?);
                }
                "ClusterVersion" => {
                    obj.cluster_version =
                        Some(StringDeserializer::deserialize("ClusterVersion", stack)?);
                }
                "EncryptionType" => {
                    obj.encryption_type =
                        Some(StringDeserializer::deserialize("EncryptionType", stack)?);
                }
                "EnhancedVpcRouting" => {
                    obj.enhanced_vpc_routing = Some(BooleanOptionalDeserializer::deserialize(
                        "EnhancedVpcRouting",
                        stack,
                    )?);
                }
                "MaintenanceTrackName" => {
                    obj.maintenance_track_name = Some(StringDeserializer::deserialize(
                        "MaintenanceTrackName",
                        stack,
                    )?);
                }
                "MasterUserPassword" => {
                    obj.master_user_password = Some(StringDeserializer::deserialize(
                        "MasterUserPassword",
                        stack,
                    )?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                "NumberOfNodes" => {
                    obj.number_of_nodes = Some(IntegerOptionalDeserializer::deserialize(
                        "NumberOfNodes",
                        stack,
                    )?);
                }
                "PubliclyAccessible" => {
                    obj.publicly_accessible = Some(BooleanOptionalDeserializer::deserialize(
                        "PubliclyAccessible",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct PurchaseReservedNodeOfferingMessage {
    /// <p>The number of reserved nodes that you want to purchase.</p> <p>Default: <code>1</code> </p>
    pub node_count: Option<i64>,
    /// <p>The unique identifier of the reserved node offering you want to purchase.</p>
    pub reserved_node_offering_id: String,
}

/// Serialize `PurchaseReservedNodeOfferingMessage` contents to a `SignedRequest`.
struct PurchaseReservedNodeOfferingMessageSerializer;
impl PurchaseReservedNodeOfferingMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &PurchaseReservedNodeOfferingMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.node_count {
            params.put(&format!("{}{}", prefix, "NodeCount"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ReservedNodeOfferingId"),
            &obj.reserved_node_offering_id,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct PurchaseReservedNodeOfferingResult {
    pub reserved_node: Option<ReservedNode>,
}

#[allow(dead_code)]
struct PurchaseReservedNodeOfferingResultDeserializer;
impl PurchaseReservedNodeOfferingResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<PurchaseReservedNodeOfferingResult, XmlParseError> {
        deserialize_elements::<_, PurchaseReservedNodeOfferingResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ReservedNode" => {
                        obj.reserved_node = Some(ReservedNodeDeserializer::deserialize(
                            "ReservedNode",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RebootClusterMessage {
    /// <p>The cluster identifier.</p>
    pub cluster_identifier: String,
}

/// Serialize `RebootClusterMessage` contents to a `SignedRequest`.
struct RebootClusterMessageSerializer;
impl RebootClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RebootClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RebootClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct RebootClusterResultDeserializer;
impl RebootClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RebootClusterResult, XmlParseError> {
        deserialize_elements::<_, RebootClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a recurring charge.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RecurringCharge {
    /// <p>The amount charged per the period of time specified by the recurring charge frequency.</p>
    pub recurring_charge_amount: Option<f64>,
    /// <p>The frequency at which the recurring charge amount is applied.</p>
    pub recurring_charge_frequency: Option<String>,
}

#[allow(dead_code)]
struct RecurringChargeDeserializer;
impl RecurringChargeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RecurringCharge, XmlParseError> {
        deserialize_elements::<_, RecurringCharge, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "RecurringChargeAmount" => {
                    obj.recurring_charge_amount = Some(DoubleDeserializer::deserialize(
                        "RecurringChargeAmount",
                        stack,
                    )?);
                }
                "RecurringChargeFrequency" => {
                    obj.recurring_charge_frequency = Some(StringDeserializer::deserialize(
                        "RecurringChargeFrequency",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RecurringChargeListDeserializer;
impl RecurringChargeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<RecurringCharge>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "RecurringCharge" {
                obj.push(RecurringChargeDeserializer::deserialize(
                    "RecurringCharge",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a reserved node. You can call the <a>DescribeReservedNodeOfferings</a> API to obtain the available reserved node offerings. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedNode {
    /// <p>The currency code for the reserved cluster.</p>
    pub currency_code: Option<String>,
    /// <p>The duration of the node reservation in seconds.</p>
    pub duration: Option<i64>,
    /// <p>The fixed cost Amazon Redshift charges you for this reserved node.</p>
    pub fixed_price: Option<f64>,
    /// <p>The number of reserved compute nodes.</p>
    pub node_count: Option<i64>,
    /// <p>The node type of the reserved node.</p>
    pub node_type: Option<String>,
    /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
    pub offering_type: Option<String>,
    /// <p>The recurring charges for the reserved node.</p>
    pub recurring_charges: Option<Vec<RecurringCharge>>,
    /// <p>The unique identifier for the reservation.</p>
    pub reserved_node_id: Option<String>,
    /// <p>The identifier for the reserved node offering.</p>
    pub reserved_node_offering_id: Option<String>,
    /// <p><p/></p>
    pub reserved_node_offering_type: Option<String>,
    /// <p>The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.</p>
    pub start_time: Option<String>,
    /// <p><p>The state of the reserved compute node.</p> <p>Possible Values:</p> <ul> <li> <p>pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.</p> </li> <li> <p>active-This reserved node is owned by the caller and is available for use.</p> </li> <li> <p>payment-failed-Payment failed for the purchase attempt.</p> </li> <li> <p>retired-The reserved node is no longer available. </p> </li> <li> <p>exchanging-The owner is exchanging the reserved node for another reserved node.</p> </li> </ul></p>
    pub state: Option<String>,
    /// <p>The hourly rate Amazon Redshift charges you for this reserved node.</p>
    pub usage_price: Option<f64>,
}

#[allow(dead_code)]
struct ReservedNodeDeserializer;
impl ReservedNodeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedNode, XmlParseError> {
        deserialize_elements::<_, ReservedNode, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CurrencyCode" => {
                    obj.currency_code =
                        Some(StringDeserializer::deserialize("CurrencyCode", stack)?);
                }
                "Duration" => {
                    obj.duration = Some(IntegerDeserializer::deserialize("Duration", stack)?);
                }
                "FixedPrice" => {
                    obj.fixed_price = Some(DoubleDeserializer::deserialize("FixedPrice", stack)?);
                }
                "NodeCount" => {
                    obj.node_count = Some(IntegerDeserializer::deserialize("NodeCount", stack)?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                "OfferingType" => {
                    obj.offering_type =
                        Some(StringDeserializer::deserialize("OfferingType", stack)?);
                }
                "RecurringCharges" => {
                    obj.recurring_charges.get_or_insert(vec![]).extend(
                        RecurringChargeListDeserializer::deserialize("RecurringCharges", stack)?,
                    );
                }
                "ReservedNodeId" => {
                    obj.reserved_node_id =
                        Some(StringDeserializer::deserialize("ReservedNodeId", stack)?);
                }
                "ReservedNodeOfferingId" => {
                    obj.reserved_node_offering_id = Some(StringDeserializer::deserialize(
                        "ReservedNodeOfferingId",
                        stack,
                    )?);
                }
                "ReservedNodeOfferingType" => {
                    obj.reserved_node_offering_type =
                        Some(ReservedNodeOfferingTypeDeserializer::deserialize(
                            "ReservedNodeOfferingType",
                            stack,
                        )?);
                }
                "StartTime" => {
                    obj.start_time = Some(TStampDeserializer::deserialize("StartTime", stack)?);
                }
                "State" => {
                    obj.state = Some(StringDeserializer::deserialize("State", stack)?);
                }
                "UsagePrice" => {
                    obj.usage_price = Some(DoubleDeserializer::deserialize("UsagePrice", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReservedNodeListDeserializer;
impl ReservedNodeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ReservedNode>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReservedNode" {
                obj.push(ReservedNodeDeserializer::deserialize(
                    "ReservedNode",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a reserved node offering.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedNodeOffering {
    /// <p>The currency code for the compute nodes offering.</p>
    pub currency_code: Option<String>,
    /// <p>The duration, in seconds, for which the offering will reserve the node.</p>
    pub duration: Option<i64>,
    /// <p>The upfront fixed charge you will pay to purchase the specific reserved node offering.</p>
    pub fixed_price: Option<f64>,
    /// <p>The node type offered by the reserved node offering.</p>
    pub node_type: Option<String>,
    /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
    pub offering_type: Option<String>,
    /// <p>The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring charges are only in effect for heavy-utilization reserved nodes.</p>
    pub recurring_charges: Option<Vec<RecurringCharge>>,
    /// <p>The offering identifier.</p>
    pub reserved_node_offering_id: Option<String>,
    /// <p><p/></p>
    pub reserved_node_offering_type: Option<String>,
    /// <p>The rate you are charged for each hour the cluster that is using the offering is running.</p>
    pub usage_price: Option<f64>,
}

#[allow(dead_code)]
struct ReservedNodeOfferingDeserializer;
impl ReservedNodeOfferingDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedNodeOffering, XmlParseError> {
        deserialize_elements::<_, ReservedNodeOffering, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CurrencyCode" => {
                    obj.currency_code =
                        Some(StringDeserializer::deserialize("CurrencyCode", stack)?);
                }
                "Duration" => {
                    obj.duration = Some(IntegerDeserializer::deserialize("Duration", stack)?);
                }
                "FixedPrice" => {
                    obj.fixed_price = Some(DoubleDeserializer::deserialize("FixedPrice", stack)?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                "OfferingType" => {
                    obj.offering_type =
                        Some(StringDeserializer::deserialize("OfferingType", stack)?);
                }
                "RecurringCharges" => {
                    obj.recurring_charges.get_or_insert(vec![]).extend(
                        RecurringChargeListDeserializer::deserialize("RecurringCharges", stack)?,
                    );
                }
                "ReservedNodeOfferingId" => {
                    obj.reserved_node_offering_id = Some(StringDeserializer::deserialize(
                        "ReservedNodeOfferingId",
                        stack,
                    )?);
                }
                "ReservedNodeOfferingType" => {
                    obj.reserved_node_offering_type =
                        Some(ReservedNodeOfferingTypeDeserializer::deserialize(
                            "ReservedNodeOfferingType",
                            stack,
                        )?);
                }
                "UsagePrice" => {
                    obj.usage_price = Some(DoubleDeserializer::deserialize("UsagePrice", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReservedNodeOfferingListDeserializer;
impl ReservedNodeOfferingListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ReservedNodeOffering>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ReservedNodeOffering" {
                obj.push(ReservedNodeOfferingDeserializer::deserialize(
                    "ReservedNodeOffering",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ReservedNodeOfferingTypeDeserializer;
impl ReservedNodeOfferingTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedNodeOfferingsMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>A list of <code>ReservedNodeOffering</code> objects.</p>
    pub reserved_node_offerings: Option<Vec<ReservedNodeOffering>>,
}

#[allow(dead_code)]
struct ReservedNodeOfferingsMessageDeserializer;
impl ReservedNodeOfferingsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedNodeOfferingsMessage, XmlParseError> {
        deserialize_elements::<_, ReservedNodeOfferingsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ReservedNodeOfferings" => {
                        obj.reserved_node_offerings.get_or_insert(vec![]).extend(
                            ReservedNodeOfferingListDeserializer::deserialize(
                                "ReservedNodeOfferings",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ReservedNodesMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>The list of <code>ReservedNode</code> objects.</p>
    pub reserved_nodes: Option<Vec<ReservedNode>>,
}

#[allow(dead_code)]
struct ReservedNodesMessageDeserializer;
impl ReservedNodesMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ReservedNodesMessage, XmlParseError> {
        deserialize_elements::<_, ReservedNodesMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                "ReservedNodes" => {
                    obj.reserved_nodes.get_or_insert(vec![]).extend(
                        ReservedNodeListDeserializer::deserialize("ReservedNodes", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResetClusterParameterGroupMessage {
    /// <p>The name of the cluster parameter group to be reset.</p>
    pub parameter_group_name: String,
    /// <p>An array of names of parameters to be reset. If <i>ResetAllParameters</i> option is not used, then at least one parameter name must be supplied. </p> <p>Constraints: A maximum of 20 parameters can be reset in a single request.</p>
    pub parameters: Option<Vec<Parameter>>,
    /// <p>If <code>true</code>, all parameters in the specified parameter group will be reset to their default values. </p> <p>Default: <code>true</code> </p>
    pub reset_all_parameters: Option<bool>,
}

/// Serialize `ResetClusterParameterGroupMessage` contents to a `SignedRequest`.
struct ResetClusterParameterGroupMessageSerializer;
impl ResetClusterParameterGroupMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResetClusterParameterGroupMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ParameterGroupName"),
            &obj.parameter_group_name,
        );
        if let Some(ref field_value) = obj.parameters {
            ParametersListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "Parameter"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.reset_all_parameters {
            params.put(&format!("{}{}", prefix, "ResetAllParameters"), &field_value);
        }
    }
}

/// <p>Describes a resize cluster operation. For example, a scheduled action to run the <code>ResizeCluster</code> API operation. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResizeClusterMessage {
    /// <p>A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>
    pub classic: Option<bool>,
    /// <p>The unique identifier for the cluster to resize.</p>
    pub cluster_identifier: String,
    /// <p>The new cluster type for the specified cluster.</p>
    pub cluster_type: Option<String>,
    /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
    pub node_type: Option<String>,
    /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
    pub number_of_nodes: Option<i64>,
}

#[allow(dead_code)]
struct ResizeClusterMessageDeserializer;
impl ResizeClusterMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResizeClusterMessage, XmlParseError> {
        deserialize_elements::<_, ResizeClusterMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Classic" => {
                    obj.classic = Some(BooleanOptionalDeserializer::deserialize("Classic", stack)?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        StringDeserializer::deserialize("ClusterIdentifier", stack)?;
                }
                "ClusterType" => {
                    obj.cluster_type = Some(StringDeserializer::deserialize("ClusterType", stack)?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                "NumberOfNodes" => {
                    obj.number_of_nodes = Some(IntegerOptionalDeserializer::deserialize(
                        "NumberOfNodes",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `ResizeClusterMessage` contents to a `SignedRequest`.
struct ResizeClusterMessageSerializer;
impl ResizeClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResizeClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.classic {
            params.put(&format!("{}{}", prefix, "Classic"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.cluster_type {
            params.put(&format!("{}{}", prefix, "ClusterType"), &field_value);
        }
        if let Some(ref field_value) = obj.node_type {
            params.put(&format!("{}{}", prefix, "NodeType"), &field_value);
        }
        if let Some(ref field_value) = obj.number_of_nodes {
            params.put(&format!("{}{}", prefix, "NumberOfNodes"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResizeClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ResizeClusterResultDeserializer;
impl ResizeClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResizeClusterResult, XmlParseError> {
        deserialize_elements::<_, ResizeClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a resize operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResizeInfo {
    /// <p>A boolean value indicating if the resize operation can be cancelled.</p>
    pub allow_cancel_resize: Option<bool>,
    /// <p>Returns the value <code>ClassicResize</code>.</p>
    pub resize_type: Option<String>,
}

#[allow(dead_code)]
struct ResizeInfoDeserializer;
impl ResizeInfoDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResizeInfo, XmlParseError> {
        deserialize_elements::<_, ResizeInfo, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AllowCancelResize" => {
                    obj.allow_cancel_resize = Some(BooleanDeserializer::deserialize(
                        "AllowCancelResize",
                        stack,
                    )?);
                }
                "ResizeType" => {
                    obj.resize_type = Some(StringDeserializer::deserialize("ResizeType", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes the result of a cluster resize operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResizeProgressMessage {
    /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    pub avg_resize_rate_in_mega_bytes_per_second: Option<f64>,
    /// <p>The percent of data transferred from source cluster to target cluster.</p>
    pub data_transfer_progress_percent: Option<f64>,
    /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    pub elapsed_time_in_seconds: Option<i64>,
    /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    pub estimated_time_to_completion_in_seconds: Option<i64>,
    /// <p>The names of tables that have been completely imported .</p> <p>Valid Values: List of table names.</p>
    pub import_tables_completed: Option<Vec<String>>,
    /// <p>The names of tables that are being currently imported.</p> <p>Valid Values: List of table names.</p>
    pub import_tables_in_progress: Option<Vec<String>>,
    /// <p>The names of tables that have not been yet imported.</p> <p>Valid Values: List of table names</p>
    pub import_tables_not_started: Option<Vec<String>>,
    /// <p>An optional string to provide additional details about the resize action.</p>
    pub message: Option<String>,
    /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    pub progress_in_mega_bytes: Option<i64>,
    /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    pub resize_type: Option<String>,
    /// <p>The status of the resize operation.</p> <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    pub status: Option<String>,
    /// <p>The cluster type after the resize operation is complete.</p> <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    pub target_cluster_type: Option<String>,
    /// <p>The type of encryption for the cluster after the resize is complete.</p> <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    pub target_encryption_type: Option<String>,
    /// <p>The node type that the cluster will have after the resize operation is complete.</p>
    pub target_node_type: Option<String>,
    /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    pub target_number_of_nodes: Option<i64>,
    /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    pub total_resize_data_in_mega_bytes: Option<i64>,
}

#[allow(dead_code)]
struct ResizeProgressMessageDeserializer;
impl ResizeProgressMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResizeProgressMessage, XmlParseError> {
        deserialize_elements::<_, ResizeProgressMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AvgResizeRateInMegaBytesPerSecond" => {
                    obj.avg_resize_rate_in_mega_bytes_per_second =
                        Some(DoubleOptionalDeserializer::deserialize(
                            "AvgResizeRateInMegaBytesPerSecond",
                            stack,
                        )?);
                }
                "DataTransferProgressPercent" => {
                    obj.data_transfer_progress_percent =
                        Some(DoubleOptionalDeserializer::deserialize(
                            "DataTransferProgressPercent",
                            stack,
                        )?);
                }
                "ElapsedTimeInSeconds" => {
                    obj.elapsed_time_in_seconds = Some(LongOptionalDeserializer::deserialize(
                        "ElapsedTimeInSeconds",
                        stack,
                    )?);
                }
                "EstimatedTimeToCompletionInSeconds" => {
                    obj.estimated_time_to_completion_in_seconds =
                        Some(LongOptionalDeserializer::deserialize(
                            "EstimatedTimeToCompletionInSeconds",
                            stack,
                        )?);
                }
                "ImportTablesCompleted" => {
                    obj.import_tables_completed.get_or_insert(vec![]).extend(
                        ImportTablesCompletedDeserializer::deserialize(
                            "ImportTablesCompleted",
                            stack,
                        )?,
                    );
                }
                "ImportTablesInProgress" => {
                    obj.import_tables_in_progress.get_or_insert(vec![]).extend(
                        ImportTablesInProgressDeserializer::deserialize(
                            "ImportTablesInProgress",
                            stack,
                        )?,
                    );
                }
                "ImportTablesNotStarted" => {
                    obj.import_tables_not_started.get_or_insert(vec![]).extend(
                        ImportTablesNotStartedDeserializer::deserialize(
                            "ImportTablesNotStarted",
                            stack,
                        )?,
                    );
                }
                "Message" => {
                    obj.message = Some(StringDeserializer::deserialize("Message", stack)?);
                }
                "ProgressInMegaBytes" => {
                    obj.progress_in_mega_bytes = Some(LongOptionalDeserializer::deserialize(
                        "ProgressInMegaBytes",
                        stack,
                    )?);
                }
                "ResizeType" => {
                    obj.resize_type = Some(StringDeserializer::deserialize("ResizeType", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "TargetClusterType" => {
                    obj.target_cluster_type =
                        Some(StringDeserializer::deserialize("TargetClusterType", stack)?);
                }
                "TargetEncryptionType" => {
                    obj.target_encryption_type = Some(StringDeserializer::deserialize(
                        "TargetEncryptionType",
                        stack,
                    )?);
                }
                "TargetNodeType" => {
                    obj.target_node_type =
                        Some(StringDeserializer::deserialize("TargetNodeType", stack)?);
                }
                "TargetNumberOfNodes" => {
                    obj.target_number_of_nodes = Some(IntegerOptionalDeserializer::deserialize(
                        "TargetNumberOfNodes",
                        stack,
                    )?);
                }
                "TotalResizeDataInMegaBytes" => {
                    obj.total_resize_data_in_mega_bytes = Some(
                        LongOptionalDeserializer::deserialize("TotalResizeDataInMegaBytes", stack)?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RestorableNodeTypeListDeserializer;
impl RestorableNodeTypeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "NodeType" {
                obj.push(StringDeserializer::deserialize("NodeType", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreFromClusterSnapshotMessage {
    /// <p>Reserved.</p>
    pub additional_info: Option<String>,
    /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. </p> <p>Default: <code>true</code> </p>
    pub allow_version_upgrade: Option<bool>,
    /// <p><p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.</p> <ul> <li> <p>enabled - Use AQUA if it is available for the current AWS Region and Amazon Redshift node type.</p> </li> <li> <p>disabled - Don&#39;t use AQUA. </p> </li> <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li> </ul></p>
    pub aqua_configuration_status: Option<String>,
    /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p> <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p> <p>Default: The value selected for the cluster from which the snapshot was taken.</p> <p>Constraints: Must be a value from 0 to 35.</p>
    pub automated_snapshot_retention_period: Option<i64>,
    /// <p>The Amazon EC2 Availability Zone in which to restore the cluster.</p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Example: <code>us-east-2a</code> </p>
    pub availability_zone: Option<String>,
    /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.</p>
    pub availability_zone_relocation: Option<bool>,
    /// <p><p>The identifier of the cluster that will be created from restoring the snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>Alphabetic characters must be lowercase.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Must be unique for all clusters within an AWS account.</p> </li> </ul></p>
    pub cluster_identifier: String,
    /// <p><p>The name of the parameter group to be associated with this cluster.</p> <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul></p>
    pub cluster_parameter_group_name: Option<String>,
    /// <p>A list of security groups to be associated with this cluster.</p> <p>Default: The default cluster security group for Amazon Redshift.</p> <p>Cluster security groups only apply to clusters outside of VPCs.</p>
    pub cluster_security_groups: Option<Vec<String>>,
    /// <p>The name of the subnet group where you want to cluster restored.</p> <p>A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you want the cluster restored.</p>
    pub cluster_subnet_group_name: Option<String>,
    /// <p>The elastic IP (EIP) address for the cluster.</p>
    pub elastic_ip: Option<String>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>
    pub enhanced_vpc_routing: Option<bool>,
    /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    pub hsm_client_certificate_identifier: Option<String>,
    /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    pub hsm_configuration_identifier: Option<String>,
    /// <p>A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles in a single request.</p> <p>A cluster can have up to 10 IAM roles associated at any time.</p>
    pub iam_roles: Option<Vec<String>>,
    /// <p>The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster that you restore from a shared snapshot.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>The node type that the restored cluster will be provisioned with.</p> <p>Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are using any DS node type. In that case, you can choose to restore into another DS node type of the same size. For example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you must restore into that same instance type and size. In other words, you can only restore a dc1.large instance type into another dc1.large instance type or dc2.large instance type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a dc2.8large cluster. For more information about node types, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"> About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub node_type: Option<String>,
    /// <p>The number of nodes specified when provisioning the restored cluster.</p>
    pub number_of_nodes: Option<i64>,
    /// <p>The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>
    pub owner_account: Option<String>,
    /// <p>The port number on which the cluster accepts connections.</p> <p>Default: The same port as the original cluster.</p> <p>Constraints: Must be between <code>1115</code> and <code>65535</code>.</p>
    pub port: Option<i64>,
    /// <p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p> Default: The value selected for the cluster from which the snapshot was taken. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide. </p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: Option<String>,
    /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
    pub publicly_accessible: Option<bool>,
    /// <p>The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    pub snapshot_cluster_identifier: Option<String>,
    /// <p>The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.</p> <p>Example: <code>my-snapshot-id</code> </p>
    pub snapshot_identifier: String,
    /// <p>A unique identifier for the snapshot schedule.</p>
    pub snapshot_schedule_identifier: Option<String>,
    /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p> <p>Default: The default VPC security group is associated with the cluster.</p> <p>VPC security groups only apply to clusters in VPCs.</p>
    pub vpc_security_group_ids: Option<Vec<String>>,
}

/// Serialize `RestoreFromClusterSnapshotMessage` contents to a `SignedRequest`.
struct RestoreFromClusterSnapshotMessageSerializer;
impl RestoreFromClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreFromClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.additional_info {
            params.put(&format!("{}{}", prefix, "AdditionalInfo"), &field_value);
        }
        if let Some(ref field_value) = obj.allow_version_upgrade {
            params.put(
                &format!("{}{}", prefix, "AllowVersionUpgrade"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.aqua_configuration_status {
            params.put(
                &format!("{}{}", prefix, "AquaConfigurationStatus"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.automated_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "AutomatedSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.availability_zone {
            params.put(&format!("{}{}", prefix, "AvailabilityZone"), &field_value);
        }
        if let Some(ref field_value) = obj.availability_zone_relocation {
            params.put(
                &format!("{}{}", prefix, "AvailabilityZoneRelocation"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.cluster_parameter_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterParameterGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_security_groups {
            ClusterSecurityGroupNameListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ClusterSecurityGroupName"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.cluster_subnet_group_name {
            params.put(
                &format!("{}{}", prefix, "ClusterSubnetGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.elastic_ip {
            params.put(&format!("{}{}", prefix, "ElasticIp"), &field_value);
        }
        if let Some(ref field_value) = obj.enhanced_vpc_routing {
            params.put(&format!("{}{}", prefix, "EnhancedVpcRouting"), &field_value);
        }
        if let Some(ref field_value) = obj.hsm_client_certificate_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmClientCertificateIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.hsm_configuration_identifier {
            params.put(
                &format!("{}{}", prefix, "HsmConfigurationIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.iam_roles {
            IamRoleArnListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "IamRoleArn"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.kms_key_id {
            params.put(&format!("{}{}", prefix, "KmsKeyId"), &field_value);
        }
        if let Some(ref field_value) = obj.maintenance_track_name {
            params.put(
                &format!("{}{}", prefix, "MaintenanceTrackName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.manual_snapshot_retention_period {
            params.put(
                &format!("{}{}", prefix, "ManualSnapshotRetentionPeriod"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.node_type {
            params.put(&format!("{}{}", prefix, "NodeType"), &field_value);
        }
        if let Some(ref field_value) = obj.number_of_nodes {
            params.put(&format!("{}{}", prefix, "NumberOfNodes"), &field_value);
        }
        if let Some(ref field_value) = obj.owner_account {
            params.put(&format!("{}{}", prefix, "OwnerAccount"), &field_value);
        }
        if let Some(ref field_value) = obj.port {
            params.put(&format!("{}{}", prefix, "Port"), &field_value);
        }
        if let Some(ref field_value) = obj.preferred_maintenance_window {
            params.put(
                &format!("{}{}", prefix, "PreferredMaintenanceWindow"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.publicly_accessible {
            params.put(&format!("{}{}", prefix, "PubliclyAccessible"), &field_value);
        }
        if let Some(ref field_value) = obj.snapshot_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "SnapshotClusterIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
        if let Some(ref field_value) = obj.snapshot_schedule_identifier {
            params.put(
                &format!("{}{}", prefix, "SnapshotScheduleIdentifier"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.vpc_security_group_ids {
            VpcSecurityGroupIdListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcSecurityGroupId"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreFromClusterSnapshotResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct RestoreFromClusterSnapshotResultDeserializer;
impl RestoreFromClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreFromClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, RestoreFromClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the status of a cluster restore action. Returns null if the cluster was not created by restoring a snapshot.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreStatus {
    /// <p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub current_restore_rate_in_mega_bytes_per_second: Option<f64>,
    /// <p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub elapsed_time_in_seconds: Option<i64>,
    /// <p>The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub estimated_time_to_completion_in_seconds: Option<i64>,
    /// <p>The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub progress_in_mega_bytes: Option<i64>,
    /// <p>The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub snapshot_size_in_mega_bytes: Option<i64>,
    /// <p>The status of the restore action. Returns starting, restoring, completed, or failed.</p>
    pub status: Option<String>,
}

#[allow(dead_code)]
struct RestoreStatusDeserializer;
impl RestoreStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreStatus, XmlParseError> {
        deserialize_elements::<_, RestoreStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "CurrentRestoreRateInMegaBytesPerSecond" => {
                    obj.current_restore_rate_in_mega_bytes_per_second =
                        Some(DoubleDeserializer::deserialize(
                            "CurrentRestoreRateInMegaBytesPerSecond",
                            stack,
                        )?);
                }
                "ElapsedTimeInSeconds" => {
                    obj.elapsed_time_in_seconds = Some(LongDeserializer::deserialize(
                        "ElapsedTimeInSeconds",
                        stack,
                    )?);
                }
                "EstimatedTimeToCompletionInSeconds" => {
                    obj.estimated_time_to_completion_in_seconds = Some(
                        LongDeserializer::deserialize("EstimatedTimeToCompletionInSeconds", stack)?,
                    );
                }
                "ProgressInMegaBytes" => {
                    obj.progress_in_mega_bytes =
                        Some(LongDeserializer::deserialize("ProgressInMegaBytes", stack)?);
                }
                "SnapshotSizeInMegaBytes" => {
                    obj.snapshot_size_in_mega_bytes = Some(LongDeserializer::deserialize(
                        "SnapshotSizeInMegaBytes",
                        stack,
                    )?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RestoreTableFromClusterSnapshotMessage {
    /// <p>The identifier of the Amazon Redshift cluster to restore the table to.</p>
    pub cluster_identifier: String,
    /// <p>Indicates whether name identifiers for database, schema, and table are case sensitive. If <code>true</code>, the names are case sensitive. If <code>false</code> (default), the names are not case sensitive.</p>
    pub enable_case_sensitive_identifier: Option<bool>,
    /// <p>The name of the table to create as a result of the current request.</p>
    pub new_table_name: String,
    /// <p>The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.</p>
    pub snapshot_identifier: String,
    /// <p>The name of the source database that contains the table to restore from.</p>
    pub source_database_name: String,
    /// <p>The name of the source schema that contains the table to restore from. If you do not specify a <code>SourceSchemaName</code> value, the default is <code>public</code>.</p>
    pub source_schema_name: Option<String>,
    /// <p>The name of the source table to restore from.</p>
    pub source_table_name: String,
    /// <p>The name of the database to restore the table to.</p>
    pub target_database_name: Option<String>,
    /// <p>The name of the schema to restore the table to.</p>
    pub target_schema_name: Option<String>,
}

/// Serialize `RestoreTableFromClusterSnapshotMessage` contents to a `SignedRequest`.
struct RestoreTableFromClusterSnapshotMessageSerializer;
impl RestoreTableFromClusterSnapshotMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RestoreTableFromClusterSnapshotMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        if let Some(ref field_value) = obj.enable_case_sensitive_identifier {
            params.put(
                &format!("{}{}", prefix, "EnableCaseSensitiveIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "NewTableName"),
            &obj.new_table_name,
        );
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
        params.put(
            &format!("{}{}", prefix, "SourceDatabaseName"),
            &obj.source_database_name,
        );
        if let Some(ref field_value) = obj.source_schema_name {
            params.put(&format!("{}{}", prefix, "SourceSchemaName"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "SourceTableName"),
            &obj.source_table_name,
        );
        if let Some(ref field_value) = obj.target_database_name {
            params.put(&format!("{}{}", prefix, "TargetDatabaseName"), &field_value);
        }
        if let Some(ref field_value) = obj.target_schema_name {
            params.put(&format!("{}{}", prefix, "TargetSchemaName"), &field_value);
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RestoreTableFromClusterSnapshotResult {
    pub table_restore_status: Option<TableRestoreStatus>,
}

#[allow(dead_code)]
struct RestoreTableFromClusterSnapshotResultDeserializer;
impl RestoreTableFromClusterSnapshotResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RestoreTableFromClusterSnapshotResult, XmlParseError> {
        deserialize_elements::<_, RestoreTableFromClusterSnapshotResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "TableRestoreStatus" => {
                        obj.table_restore_status =
                            Some(TableRestoreStatusDeserializer::deserialize(
                                "TableRestoreStatus",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes a resume cluster operation. For example, a scheduled action to run the <code>ResumeCluster</code> API operation. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ResumeClusterMessage {
    /// <p>The identifier of the cluster to be resumed.</p>
    pub cluster_identifier: String,
}

#[allow(dead_code)]
struct ResumeClusterMessageDeserializer;
impl ResumeClusterMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResumeClusterMessage, XmlParseError> {
        deserialize_elements::<_, ResumeClusterMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        StringDeserializer::deserialize("ClusterIdentifier", stack)?;
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `ResumeClusterMessage` contents to a `SignedRequest`.
struct ResumeClusterMessageSerializer;
impl ResumeClusterMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ResumeClusterMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ResumeClusterResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct ResumeClusterResultDeserializer;
impl ResumeClusterResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ResumeClusterResult, XmlParseError> {
        deserialize_elements::<_, ResumeClusterResult, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Cluster" => {
                    obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a <code>RevisionTarget</code>.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RevisionTarget {
    /// <p>A unique string that identifies the version to update the cluster to. You can use this value in <a>ModifyClusterDbRevision</a>.</p>
    pub database_revision: Option<String>,
    /// <p>The date on which the database revision was released.</p>
    pub database_revision_release_date: Option<String>,
    /// <p>A string that describes the changes and features that will be applied to the cluster when it is updated to the corresponding <a>ClusterDbRevision</a>.</p>
    pub description: Option<String>,
}

#[allow(dead_code)]
struct RevisionTargetDeserializer;
impl RevisionTargetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RevisionTarget, XmlParseError> {
        deserialize_elements::<_, RevisionTarget, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DatabaseRevision" => {
                    obj.database_revision =
                        Some(StringDeserializer::deserialize("DatabaseRevision", stack)?);
                }
                "DatabaseRevisionReleaseDate" => {
                    obj.database_revision_release_date = Some(TStampDeserializer::deserialize(
                        "DatabaseRevisionReleaseDate",
                        stack,
                    )?);
                }
                "Description" => {
                    obj.description = Some(StringDeserializer::deserialize("Description", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct RevisionTargetsListDeserializer;
impl RevisionTargetsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<RevisionTarget>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "RevisionTarget" {
                obj.push(RevisionTargetDeserializer::deserialize(
                    "RevisionTarget",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RevokeClusterSecurityGroupIngressMessage {
    /// <p>The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR) block of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code> and <code>EC2SecurityGroupOwnerId</code> cannot be provided. </p>
    pub cidrip: Option<String>,
    /// <p>The name of the security Group from which to revoke the ingress rule.</p>
    pub cluster_security_group_name: String,
    /// <p>The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code> is specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code> cannot be provided. </p>
    pub ec2_security_group_name: Option<String>,
    /// <p>The AWS account number of the owner of the security group specified in the <code>EC2SecurityGroupName</code> parameter. The AWS access key ID is not an acceptable value. If <code>EC2SecurityGroupOwnerId</code> is specified, <code>EC2SecurityGroupName</code> must also be provided. and <code>CIDRIP</code> cannot be provided. </p> <p>Example: <code>111122223333</code> </p>
    pub ec2_security_group_owner_id: Option<String>,
}

/// Serialize `RevokeClusterSecurityGroupIngressMessage` contents to a `SignedRequest`.
struct RevokeClusterSecurityGroupIngressMessageSerializer;
impl RevokeClusterSecurityGroupIngressMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RevokeClusterSecurityGroupIngressMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.cidrip {
            params.put(&format!("{}{}", prefix, "CIDRIP"), &field_value);
        }
        params.put(
            &format!("{}{}", prefix, "ClusterSecurityGroupName"),
            &obj.cluster_security_group_name,
        );
        if let Some(ref field_value) = obj.ec2_security_group_name {
            params.put(
                &format!("{}{}", prefix, "EC2SecurityGroupName"),
                &field_value,
            );
        }
        if let Some(ref field_value) = obj.ec2_security_group_owner_id {
            params.put(
                &format!("{}{}", prefix, "EC2SecurityGroupOwnerId"),
                &field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RevokeClusterSecurityGroupIngressResult {
    pub cluster_security_group: Option<ClusterSecurityGroup>,
}

#[allow(dead_code)]
struct RevokeClusterSecurityGroupIngressResultDeserializer;
impl RevokeClusterSecurityGroupIngressResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RevokeClusterSecurityGroupIngressResult, XmlParseError> {
        deserialize_elements::<_, RevokeClusterSecurityGroupIngressResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "ClusterSecurityGroup" => {
                        obj.cluster_security_group =
                            Some(ClusterSecurityGroupDeserializer::deserialize(
                                "ClusterSecurityGroup",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RevokeEndpointAccessMessage {
    /// <p>The AWS account ID whose access is to be revoked.</p>
    pub account: Option<String>,
    /// <p>The cluster to revoke access from.</p>
    pub cluster_identifier: Option<String>,
    /// <p>Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.</p>
    pub force: Option<bool>,
    /// <p>The virtual private cloud (VPC) identifiers for which access is to be revoked.</p>
    pub vpc_ids: Option<Vec<String>>,
}

/// Serialize `RevokeEndpointAccessMessage` contents to a `SignedRequest`.
struct RevokeEndpointAccessMessageSerializer;
impl RevokeEndpointAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RevokeEndpointAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.account {
            params.put(&format!("{}{}", prefix, "Account"), &field_value);
        }
        if let Some(ref field_value) = obj.cluster_identifier {
            params.put(&format!("{}{}", prefix, "ClusterIdentifier"), &field_value);
        }
        if let Some(ref field_value) = obj.force {
            params.put(&format!("{}{}", prefix, "Force"), &field_value);
        }
        if let Some(ref field_value) = obj.vpc_ids {
            VpcIdentifierListSerializer::serialize(
                params,
                &format!("{}{}", prefix, "VpcIdentifier"),
                field_value,
            );
        }
    }
}

/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RevokeSnapshotAccessMessage {
    /// <p>The identifier of the AWS customer account that can no longer restore the specified snapshot.</p>
    pub account_with_restore_access: String,
    /// <p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    pub snapshot_cluster_identifier: Option<String>,
    /// <p>The identifier of the snapshot that the account can no longer access.</p>
    pub snapshot_identifier: String,
}

/// Serialize `RevokeSnapshotAccessMessage` contents to a `SignedRequest`.
struct RevokeSnapshotAccessMessageSerializer;
impl RevokeSnapshotAccessMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RevokeSnapshotAccessMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "AccountWithRestoreAccess"),
            &obj.account_with_restore_access,
        );
        if let Some(ref field_value) = obj.snapshot_cluster_identifier {
            params.put(
                &format!("{}{}", prefix, "SnapshotClusterIdentifier"),
                &field_value,
            );
        }
        params.put(
            &format!("{}{}", prefix, "SnapshotIdentifier"),
            &obj.snapshot_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RevokeSnapshotAccessResult {
    pub snapshot: Option<Snapshot>,
}

#[allow(dead_code)]
struct RevokeSnapshotAccessResultDeserializer;
impl RevokeSnapshotAccessResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RevokeSnapshotAccessResult, XmlParseError> {
        deserialize_elements::<_, RevokeSnapshotAccessResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Snapshot" => {
                        obj.snapshot = Some(SnapshotDeserializer::deserialize("Snapshot", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct RotateEncryptionKeyMessage {
    /// <p>The unique identifier of the cluster that you want to rotate the encryption keys for.</p> <p>Constraints: Must be the name of valid cluster that has encryption enabled.</p>
    pub cluster_identifier: String,
}

/// Serialize `RotateEncryptionKeyMessage` contents to a `SignedRequest`.
struct RotateEncryptionKeyMessageSerializer;
impl RotateEncryptionKeyMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &RotateEncryptionKeyMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct RotateEncryptionKeyResult {
    pub cluster: Option<Cluster>,
}

#[allow(dead_code)]
struct RotateEncryptionKeyResultDeserializer;
impl RotateEncryptionKeyResultDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<RotateEncryptionKeyResult, XmlParseError> {
        deserialize_elements::<_, RotateEncryptionKeyResult, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Cluster" => {
                        obj.cluster = Some(ClusterDeserializer::deserialize("Cluster", stack)?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ScheduleDefinitionListDeserializer;
impl ScheduleDefinitionListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ScheduleDefinition" {
                obj.push(StringDeserializer::deserialize(
                    "ScheduleDefinition",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ScheduleDefinitionList` contents to a `SignedRequest`.
struct ScheduleDefinitionListSerializer;
impl ScheduleDefinitionListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct ScheduleStateDeserializer;
impl ScheduleStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule. For information about which API operations can be scheduled, see <a>ScheduledActionType</a>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ScheduledAction {
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub end_time: Option<String>,
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub iam_role: Option<String>,
    /// <p>List of times when the scheduled action will run. </p>
    pub next_invocations: Option<Vec<String>>,
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p> <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p> <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub schedule: Option<String>,
    /// <p>The description of the scheduled action. </p>
    pub scheduled_action_description: Option<String>,
    /// <p>The name of the scheduled action. </p>
    pub scheduled_action_name: Option<String>,
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub start_time: Option<String>,
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub state: Option<String>,
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p> <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub target_action: Option<ScheduledActionType>,
}

#[allow(dead_code)]
struct ScheduledActionDeserializer;
impl ScheduledActionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ScheduledAction, XmlParseError> {
        deserialize_elements::<_, ScheduledAction, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "EndTime" => {
                    obj.end_time = Some(TStampDeserializer::deserialize("EndTime", stack)?);
                }
                "IamRole" => {
                    obj.iam_role = Some(StringDeserializer::deserialize("IamRole", stack)?);
                }
                "NextInvocations" => {
                    obj.next_invocations.get_or_insert(vec![]).extend(
                        ScheduledActionTimeListDeserializer::deserialize("NextInvocations", stack)?,
                    );
                }
                "Schedule" => {
                    obj.schedule = Some(StringDeserializer::deserialize("Schedule", stack)?);
                }
                "ScheduledActionDescription" => {
                    obj.scheduled_action_description = Some(StringDeserializer::deserialize(
                        "ScheduledActionDescription",
                        stack,
                    )?);
                }
                "ScheduledActionName" => {
                    obj.scheduled_action_name = Some(StringDeserializer::deserialize(
                        "ScheduledActionName",
                        stack,
                    )?);
                }
                "StartTime" => {
                    obj.start_time = Some(TStampDeserializer::deserialize("StartTime", stack)?);
                }
                "State" => {
                    obj.state = Some(ScheduledActionStateDeserializer::deserialize(
                        "State", stack,
                    )?);
                }
                "TargetAction" => {
                    obj.target_action = Some(ScheduledActionTypeDeserializer::deserialize(
                        "TargetAction",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>A set of elements to filter the returned scheduled actions. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ScheduledActionFilter {
    /// <p>The type of element to filter. </p>
    pub name: String,
    /// <p>List of values. Compare if the value (of type defined by <code>Name</code>) equals an item in the list of scheduled actions. </p>
    pub values: Vec<String>,
}

/// Serialize `ScheduledActionFilter` contents to a `SignedRequest`.
struct ScheduledActionFilterSerializer;
impl ScheduledActionFilterSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ScheduledActionFilter) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Name"), &obj.name);
        ValueStringListSerializer::serialize(params, &format!("{}{}", prefix, "item"), &obj.values);
    }
}

/// Serialize `ScheduledActionFilterList` contents to a `SignedRequest`.
struct ScheduledActionFilterListSerializer;
impl ScheduledActionFilterListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<ScheduledActionFilter>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            ScheduledActionFilterSerializer::serialize(params, &key, obj);
        }
    }
}

#[allow(dead_code)]
struct ScheduledActionListDeserializer;
impl ScheduledActionListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<ScheduledAction>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ScheduledAction" {
                obj.push(ScheduledActionDeserializer::deserialize(
                    "ScheduledAction",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct ScheduledActionStateDeserializer;
impl ScheduledActionStateDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct ScheduledActionTimeListDeserializer;
impl ScheduledActionTimeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "ScheduledActionTime" {
                obj.push(TStampDeserializer::deserialize(
                    "ScheduledActionTime",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>The action type that specifies an Amazon Redshift API operation that is supported by the Amazon Redshift scheduler. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct ScheduledActionType {
    /// <p>An action that runs a <code>PauseCluster</code> API operation. </p>
    pub pause_cluster: Option<PauseClusterMessage>,
    /// <p>An action that runs a <code>ResizeCluster</code> API operation. </p>
    pub resize_cluster: Option<ResizeClusterMessage>,
    /// <p>An action that runs a <code>ResumeCluster</code> API operation. </p>
    pub resume_cluster: Option<ResumeClusterMessage>,
}

#[allow(dead_code)]
struct ScheduledActionTypeDeserializer;
impl ScheduledActionTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ScheduledActionType, XmlParseError> {
        deserialize_elements::<_, ScheduledActionType, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "PauseCluster" => {
                    obj.pause_cluster = Some(PauseClusterMessageDeserializer::deserialize(
                        "PauseCluster",
                        stack,
                    )?);
                }
                "ResizeCluster" => {
                    obj.resize_cluster = Some(ResizeClusterMessageDeserializer::deserialize(
                        "ResizeCluster",
                        stack,
                    )?);
                }
                "ResumeCluster" => {
                    obj.resume_cluster = Some(ResumeClusterMessageDeserializer::deserialize(
                        "ResumeCluster",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `ScheduledActionType` contents to a `SignedRequest`.
struct ScheduledActionTypeSerializer;
impl ScheduledActionTypeSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &ScheduledActionType) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.pause_cluster {
            PauseClusterMessageSerializer::serialize(
                params,
                &format!("{}{}", prefix, "PauseCluster"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.resize_cluster {
            ResizeClusterMessageSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ResizeCluster"),
                field_value,
            );
        }
        if let Some(ref field_value) = obj.resume_cluster {
            ResumeClusterMessageSerializer::serialize(
                params,
                &format!("{}{}", prefix, "ResumeCluster"),
                field_value,
            );
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct ScheduledActionsMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: Option<String>,
    /// <p>List of retrieved scheduled actions. </p>
    pub scheduled_actions: Option<Vec<ScheduledAction>>,
}

#[allow(dead_code)]
struct ScheduledActionsMessageDeserializer;
impl ScheduledActionsMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<ScheduledActionsMessage, XmlParseError> {
        deserialize_elements::<_, ScheduledActionsMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "ScheduledActions" => {
                        obj.scheduled_actions.get_or_insert(vec![]).extend(
                            ScheduledActionListDeserializer::deserialize(
                                "ScheduledActions",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct ScheduledSnapshotTimeListDeserializer;
impl ScheduledSnapshotTimeListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SnapshotTime" {
                obj.push(TStampDeserializer::deserialize("SnapshotTime", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SensitiveStringDeserializer;
impl SensitiveStringDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a snapshot.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Snapshot {
    /// <p>A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts are authorized. Visible only to the snapshot owner. </p>
    pub accounts_with_restore_access: Option<Vec<AccountWithRestoreAccess>>,
    /// <p>The size of the incremental backup.</p>
    pub actual_incremental_backup_size_in_mega_bytes: Option<f64>,
    /// <p>The Availability Zone in which the cluster was created.</p>
    pub availability_zone: Option<String>,
    /// <p>The number of megabytes that have been transferred to the snapshot backup.</p>
    pub backup_progress_in_mega_bytes: Option<f64>,
    /// <p>The time (UTC) when the cluster was originally created.</p>
    pub cluster_create_time: Option<String>,
    /// <p>The identifier of the cluster for which the snapshot was taken.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
    pub cluster_version: Option<String>,
    /// <p>The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a completed backup. </p>
    pub current_backup_rate_in_mega_bytes_per_second: Option<f64>,
    /// <p>The name of the database that was created when the cluster was created.</p>
    pub db_name: Option<String>,
    /// <p>The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.</p>
    pub elapsed_time_in_seconds: Option<i64>,
    /// <p>If <code>true</code>, the data in the snapshot is encrypted at rest.</p>
    pub encrypted: Option<bool>,
    /// <p>A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. <code>true</code> indicates that the data is encrypted using HSM keys.</p>
    pub encrypted_with_hsm: Option<bool>,
    /// <p>The cluster version of the cluster used to create the snapshot. For example, 1.0.15503. </p>
    pub engine_full_version: Option<String>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p> <p>Default: false</p>
    pub enhanced_vpc_routing: Option<bool>,
    /// <p>The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a completed backup. </p>
    pub estimated_seconds_to_completion: Option<i64>,
    /// <p>The AWS Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the maintenance track for the snapshot.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>The number of days until a manual snapshot will pass its retention period.</p>
    pub manual_snapshot_remaining_days: Option<i64>,
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: Option<i64>,
    /// <p>The master user name for the cluster.</p>
    pub master_username: Option<String>,
    /// <p>The node type of the nodes in the cluster.</p>
    pub node_type: Option<String>,
    /// <p>The number of nodes in the cluster.</p>
    pub number_of_nodes: Option<i64>,
    /// <p>For manual snapshots, the AWS customer account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.</p>
    pub owner_account: Option<String>,
    /// <p>The port that the cluster is listening on.</p>
    pub port: Option<i64>,
    /// <p>The list of node types that this cluster snapshot is able to restore into.</p>
    pub restorable_node_types: Option<Vec<String>>,
    /// <p>The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.</p>
    pub snapshot_create_time: Option<String>,
    /// <p>The snapshot identifier that is provided in the request.</p>
    pub snapshot_identifier: Option<String>,
    /// <p>A timestamp representing the start of the retention period for the snapshot.</p>
    pub snapshot_retention_start_time: Option<String>,
    /// <p>The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> are of type "manual". </p>
    pub snapshot_type: Option<String>,
    /// <p>The source region from which the snapshot was copied.</p>
    pub source_region: Option<String>,
    /// <p><p>The snapshot status. The value of the status depends on the API operation used: </p> <ul> <li> <p> <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as &quot;creating&quot;. </p> </li> <li> <p> <a>DescribeClusterSnapshots</a> returns status as &quot;creating&quot;, &quot;available&quot;, &quot;final snapshot&quot;, or &quot;failed&quot;.</p> </li> <li> <p> <a>DeleteClusterSnapshot</a> returns status as &quot;deleted&quot;.</p> </li> </ul></p>
    pub status: Option<String>,
    /// <p>The list of tags for the cluster snapshot.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The size of the complete set of backup data that would be used to restore the cluster.</p>
    pub total_backup_size_in_mega_bytes: Option<f64>,
    /// <p>The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.</p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct SnapshotDeserializer;
impl SnapshotDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Snapshot, XmlParseError> {
        deserialize_elements::<_, Snapshot, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AccountsWithRestoreAccess" => {
                    obj.accounts_with_restore_access
                        .get_or_insert(vec![])
                        .extend(AccountsWithRestoreAccessListDeserializer::deserialize(
                            "AccountsWithRestoreAccess",
                            stack,
                        )?);
                }
                "ActualIncrementalBackupSizeInMegaBytes" => {
                    obj.actual_incremental_backup_size_in_mega_bytes =
                        Some(DoubleDeserializer::deserialize(
                            "ActualIncrementalBackupSizeInMegaBytes",
                            stack,
                        )?);
                }
                "AvailabilityZone" => {
                    obj.availability_zone =
                        Some(StringDeserializer::deserialize("AvailabilityZone", stack)?);
                }
                "BackupProgressInMegaBytes" => {
                    obj.backup_progress_in_mega_bytes = Some(DoubleDeserializer::deserialize(
                        "BackupProgressInMegaBytes",
                        stack,
                    )?);
                }
                "ClusterCreateTime" => {
                    obj.cluster_create_time =
                        Some(TStampDeserializer::deserialize("ClusterCreateTime", stack)?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "ClusterVersion" => {
                    obj.cluster_version =
                        Some(StringDeserializer::deserialize("ClusterVersion", stack)?);
                }
                "CurrentBackupRateInMegaBytesPerSecond" => {
                    obj.current_backup_rate_in_mega_bytes_per_second =
                        Some(DoubleDeserializer::deserialize(
                            "CurrentBackupRateInMegaBytesPerSecond",
                            stack,
                        )?);
                }
                "DBName" => {
                    obj.db_name = Some(StringDeserializer::deserialize("DBName", stack)?);
                }
                "ElapsedTimeInSeconds" => {
                    obj.elapsed_time_in_seconds = Some(LongDeserializer::deserialize(
                        "ElapsedTimeInSeconds",
                        stack,
                    )?);
                }
                "Encrypted" => {
                    obj.encrypted = Some(BooleanDeserializer::deserialize("Encrypted", stack)?);
                }
                "EncryptedWithHSM" => {
                    obj.encrypted_with_hsm =
                        Some(BooleanDeserializer::deserialize("EncryptedWithHSM", stack)?);
                }
                "EngineFullVersion" => {
                    obj.engine_full_version =
                        Some(StringDeserializer::deserialize("EngineFullVersion", stack)?);
                }
                "EnhancedVpcRouting" => {
                    obj.enhanced_vpc_routing = Some(BooleanDeserializer::deserialize(
                        "EnhancedVpcRouting",
                        stack,
                    )?);
                }
                "EstimatedSecondsToCompletion" => {
                    obj.estimated_seconds_to_completion = Some(LongDeserializer::deserialize(
                        "EstimatedSecondsToCompletion",
                        stack,
                    )?);
                }
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "MaintenanceTrackName" => {
                    obj.maintenance_track_name = Some(StringDeserializer::deserialize(
                        "MaintenanceTrackName",
                        stack,
                    )?);
                }
                "ManualSnapshotRemainingDays" => {
                    obj.manual_snapshot_remaining_days =
                        Some(IntegerOptionalDeserializer::deserialize(
                            "ManualSnapshotRemainingDays",
                            stack,
                        )?);
                }
                "ManualSnapshotRetentionPeriod" => {
                    obj.manual_snapshot_retention_period =
                        Some(IntegerOptionalDeserializer::deserialize(
                            "ManualSnapshotRetentionPeriod",
                            stack,
                        )?);
                }
                "MasterUsername" => {
                    obj.master_username =
                        Some(StringDeserializer::deserialize("MasterUsername", stack)?);
                }
                "NodeType" => {
                    obj.node_type = Some(StringDeserializer::deserialize("NodeType", stack)?);
                }
                "NumberOfNodes" => {
                    obj.number_of_nodes =
                        Some(IntegerDeserializer::deserialize("NumberOfNodes", stack)?);
                }
                "OwnerAccount" => {
                    obj.owner_account =
                        Some(StringDeserializer::deserialize("OwnerAccount", stack)?);
                }
                "Port" => {
                    obj.port = Some(IntegerDeserializer::deserialize("Port", stack)?);
                }
                "RestorableNodeTypes" => {
                    obj.restorable_node_types.get_or_insert(vec![]).extend(
                        RestorableNodeTypeListDeserializer::deserialize(
                            "RestorableNodeTypes",
                            stack,
                        )?,
                    );
                }
                "SnapshotCreateTime" => {
                    obj.snapshot_create_time = Some(TStampDeserializer::deserialize(
                        "SnapshotCreateTime",
                        stack,
                    )?);
                }
                "SnapshotIdentifier" => {
                    obj.snapshot_identifier = Some(StringDeserializer::deserialize(
                        "SnapshotIdentifier",
                        stack,
                    )?);
                }
                "SnapshotRetentionStartTime" => {
                    obj.snapshot_retention_start_time = Some(TStampDeserializer::deserialize(
                        "SnapshotRetentionStartTime",
                        stack,
                    )?);
                }
                "SnapshotType" => {
                    obj.snapshot_type =
                        Some(StringDeserializer::deserialize("SnapshotType", stack)?);
                }
                "SourceRegion" => {
                    obj.source_region =
                        Some(StringDeserializer::deserialize("SourceRegion", stack)?);
                }
                "Status" => {
                    obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                "TotalBackupSizeInMegaBytes" => {
                    obj.total_backup_size_in_mega_bytes = Some(DoubleDeserializer::deserialize(
                        "TotalBackupSizeInMegaBytes",
                        stack,
                    )?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified customer master key (CMK) from AWS KMS in the destination region.</p> <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SnapshotCopyGrant {
    /// <p>The unique identifier of the customer master key (CMK) in AWS KMS to which Amazon Redshift is granted permission.</p>
    pub kms_key_id: Option<String>,
    /// <p>The name of the snapshot copy grant.</p>
    pub snapshot_copy_grant_name: Option<String>,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct SnapshotCopyGrantDeserializer;
impl SnapshotCopyGrantDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SnapshotCopyGrant, XmlParseError> {
        deserialize_elements::<_, SnapshotCopyGrant, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "KmsKeyId" => {
                    obj.kms_key_id = Some(StringDeserializer::deserialize("KmsKeyId", stack)?);
                }
                "SnapshotCopyGrantName" => {
                    obj.snapshot_copy_grant_name = Some(StringDeserializer::deserialize(
                        "SnapshotCopyGrantName",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SnapshotCopyGrantListDeserializer;
impl SnapshotCopyGrantListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SnapshotCopyGrant>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SnapshotCopyGrant" {
                obj.push(SnapshotCopyGrantDeserializer::deserialize(
                    "SnapshotCopyGrant",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SnapshotCopyGrantMessage {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p> <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    pub marker: Option<String>,
    /// <p>The list of <code>SnapshotCopyGrant</code> objects.</p>
    pub snapshot_copy_grants: Option<Vec<SnapshotCopyGrant>>,
}

#[allow(dead_code)]
struct SnapshotCopyGrantMessageDeserializer;
impl SnapshotCopyGrantMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SnapshotCopyGrantMessage, XmlParseError> {
        deserialize_elements::<_, SnapshotCopyGrantMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "SnapshotCopyGrants" => {
                        obj.snapshot_copy_grants.get_or_insert(vec![]).extend(
                            SnapshotCopyGrantListDeserializer::deserialize(
                                "SnapshotCopyGrants",
                                stack,
                            )?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
/// <p>Describes the errors returned by a snapshot.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SnapshotErrorMessage {
    /// <p>The failure code for the error.</p>
    pub failure_code: Option<String>,
    /// <p>The text message describing the error.</p>
    pub failure_reason: Option<String>,
    /// <p>A unique identifier for the cluster.</p>
    pub snapshot_cluster_identifier: Option<String>,
    /// <p>A unique identifier for the snapshot returning the error.</p>
    pub snapshot_identifier: Option<String>,
}

#[allow(dead_code)]
struct SnapshotErrorMessageDeserializer;
impl SnapshotErrorMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SnapshotErrorMessage, XmlParseError> {
        deserialize_elements::<_, SnapshotErrorMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "FailureCode" => {
                    obj.failure_code = Some(StringDeserializer::deserialize("FailureCode", stack)?);
                }
                "FailureReason" => {
                    obj.failure_reason =
                        Some(StringDeserializer::deserialize("FailureReason", stack)?);
                }
                "SnapshotClusterIdentifier" => {
                    obj.snapshot_cluster_identifier = Some(StringDeserializer::deserialize(
                        "SnapshotClusterIdentifier",
                        stack,
                    )?);
                }
                "SnapshotIdentifier" => {
                    obj.snapshot_identifier = Some(StringDeserializer::deserialize(
                        "SnapshotIdentifier",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SnapshotIdentifierListDeserializer;
impl SnapshotIdentifierListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "String" {
                obj.push(StringDeserializer::deserialize("String", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `SnapshotIdentifierList` contents to a `SignedRequest`.
struct SnapshotIdentifierListSerializer;
impl SnapshotIdentifierListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct SnapshotListDeserializer;
impl SnapshotListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Snapshot>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Snapshot" {
                obj.push(SnapshotDeserializer::deserialize("Snapshot", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Contains the output from the <a>DescribeClusterSnapshots</a> action. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SnapshotMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>A list of <a>Snapshot</a> instances. </p>
    pub snapshots: Option<Vec<Snapshot>>,
}

#[allow(dead_code)]
struct SnapshotMessageDeserializer;
impl SnapshotMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SnapshotMessage, XmlParseError> {
        deserialize_elements::<_, SnapshotMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                "Snapshots" => {
                    obj.snapshots
                        .get_or_insert(vec![])
                        .extend(SnapshotListDeserializer::deserialize("Snapshots", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also schedule snapshots for specific dates. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SnapshotSchedule {
    /// <p>The number of clusters associated with the schedule.</p>
    pub associated_cluster_count: Option<i64>,
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub associated_clusters: Option<Vec<ClusterAssociatedToSchedule>>,
    /// <p><p/></p>
    pub next_invocations: Option<Vec<String>>,
    /// <p>A list of ScheduleDefinitions.</p>
    pub schedule_definitions: Option<Vec<String>>,
    /// <p>The description of the schedule.</p>
    pub schedule_description: Option<String>,
    /// <p>A unique identifier for the schedule.</p>
    pub schedule_identifier: Option<String>,
    /// <p>An optional set of tags describing the schedule.</p>
    pub tags: Option<Vec<Tag>>,
}

#[allow(dead_code)]
struct SnapshotScheduleDeserializer;
impl SnapshotScheduleDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SnapshotSchedule, XmlParseError> {
        deserialize_elements::<_, SnapshotSchedule, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "AssociatedClusterCount" => {
                    obj.associated_cluster_count = Some(IntegerOptionalDeserializer::deserialize(
                        "AssociatedClusterCount",
                        stack,
                    )?);
                }
                "AssociatedClusters" => {
                    obj.associated_clusters.get_or_insert(vec![]).extend(
                        AssociatedClusterListDeserializer::deserialize(
                            "AssociatedClusters",
                            stack,
                        )?,
                    );
                }
                "NextInvocations" => {
                    obj.next_invocations.get_or_insert(vec![]).extend(
                        ScheduledSnapshotTimeListDeserializer::deserialize(
                            "NextInvocations",
                            stack,
                        )?,
                    );
                }
                "ScheduleDefinitions" => {
                    obj.schedule_definitions.get_or_insert(vec![]).extend(
                        ScheduleDefinitionListDeserializer::deserialize(
                            "ScheduleDefinitions",
                            stack,
                        )?,
                    );
                }
                "ScheduleDescription" => {
                    obj.schedule_description = Some(StringDeserializer::deserialize(
                        "ScheduleDescription",
                        stack,
                    )?);
                }
                "ScheduleIdentifier" => {
                    obj.schedule_identifier = Some(StringDeserializer::deserialize(
                        "ScheduleIdentifier",
                        stack,
                    )?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SnapshotScheduleListDeserializer;
impl SnapshotScheduleListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SnapshotSchedule>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SnapshotSchedule" {
                obj.push(SnapshotScheduleDeserializer::deserialize(
                    "SnapshotSchedule",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes a sorting entity</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct SnapshotSortingEntity {
    /// <p>The category for sorting the snapshots.</p>
    pub attribute: String,
    /// <p>The order for listing the attributes.</p>
    pub sort_order: Option<String>,
}

/// Serialize `SnapshotSortingEntity` contents to a `SignedRequest`.
struct SnapshotSortingEntitySerializer;
impl SnapshotSortingEntitySerializer {
    fn serialize(params: &mut Params, name: &str, obj: &SnapshotSortingEntity) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "Attribute"), &obj.attribute);
        if let Some(ref field_value) = obj.sort_order {
            params.put(&format!("{}{}", prefix, "SortOrder"), &field_value);
        }
    }
}

/// Serialize `SnapshotSortingEntityList` contents to a `SignedRequest`.
struct SnapshotSortingEntityListSerializer;
impl SnapshotSortingEntityListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<SnapshotSortingEntity>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            SnapshotSortingEntitySerializer::serialize(params, &key, obj);
        }
    }
}

#[allow(dead_code)]
struct SourceIdsListDeserializer;
impl SourceIdsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SourceId" {
                obj.push(StringDeserializer::deserialize("SourceId", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `SourceIdsList` contents to a `SignedRequest`.
struct SourceIdsListSerializer;
impl SourceIdsListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct SourceTypeDeserializer;
impl SourceTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct StringDeserializer;
impl StringDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes a subnet.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct Subnet {
    /// <p><p/></p>
    pub subnet_availability_zone: Option<AvailabilityZone>,
    /// <p>The identifier of the subnet.</p>
    pub subnet_identifier: Option<String>,
    /// <p>The status of the subnet.</p>
    pub subnet_status: Option<String>,
}

#[allow(dead_code)]
struct SubnetDeserializer;
impl SubnetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Subnet, XmlParseError> {
        deserialize_elements::<_, Subnet, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "SubnetAvailabilityZone" => {
                    obj.subnet_availability_zone = Some(AvailabilityZoneDeserializer::deserialize(
                        "SubnetAvailabilityZone",
                        stack,
                    )?);
                }
                "SubnetIdentifier" => {
                    obj.subnet_identifier =
                        Some(StringDeserializer::deserialize("SubnetIdentifier", stack)?);
                }
                "SubnetStatus" => {
                    obj.subnet_status =
                        Some(StringDeserializer::deserialize("SubnetStatus", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `SubnetIdentifierList` contents to a `SignedRequest`.
struct SubnetIdentifierListSerializer;
impl SubnetIdentifierListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct SubnetListDeserializer;
impl SubnetListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Subnet>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Subnet" {
                obj.push(SubnetDeserializer::deserialize("Subnet", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>Describes the operations that are allowed on a maintenance track.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SupportedOperation {
    /// <p>A list of the supported operations.</p>
    pub operation_name: Option<String>,
}

#[allow(dead_code)]
struct SupportedOperationDeserializer;
impl SupportedOperationDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SupportedOperation, XmlParseError> {
        deserialize_elements::<_, SupportedOperation, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "OperationName" => {
                    obj.operation_name =
                        Some(StringDeserializer::deserialize("OperationName", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SupportedOperationListDeserializer;
impl SupportedOperationListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SupportedOperation>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SupportedOperation" {
                obj.push(SupportedOperationDeserializer::deserialize(
                    "SupportedOperation",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p>A list of supported platforms for orderable clusters.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct SupportedPlatform {
    /// <p><p/></p>
    pub name: Option<String>,
}

#[allow(dead_code)]
struct SupportedPlatformDeserializer;
impl SupportedPlatformDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<SupportedPlatform, XmlParseError> {
        deserialize_elements::<_, SupportedPlatform, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Name" => {
                    obj.name = Some(StringDeserializer::deserialize("Name", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct SupportedPlatformsListDeserializer;
impl SupportedPlatformsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<SupportedPlatform>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "SupportedPlatform" {
                obj.push(SupportedPlatformDeserializer::deserialize(
                    "SupportedPlatform",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct TStampDeserializer;
impl TStampDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>Describes the status of a <a>RestoreTableFromClusterSnapshot</a> operation.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct TableRestoreStatus {
    /// <p>The identifier of the Amazon Redshift cluster that the table is being restored to.</p>
    pub cluster_identifier: Option<String>,
    /// <p>A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.</p>
    pub message: Option<String>,
    /// <p>The name of the table to create as a result of the table restore request.</p>
    pub new_table_name: Option<String>,
    /// <p>The amount of data restored to the new table so far, in megabytes (MB).</p>
    pub progress_in_mega_bytes: Option<i64>,
    /// <p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>
    pub request_time: Option<String>,
    /// <p>The identifier of the snapshot that the table is being restored from.</p>
    pub snapshot_identifier: Option<String>,
    /// <p>The name of the source database that contains the table being restored.</p>
    pub source_database_name: Option<String>,
    /// <p>The name of the source schema that contains the table being restored.</p>
    pub source_schema_name: Option<String>,
    /// <p>The name of the source table being restored.</p>
    pub source_table_name: Option<String>,
    /// <p>A value that describes the current state of the table restore request.</p> <p>Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code> </p>
    pub status: Option<String>,
    /// <p>The unique identifier for the table restore request.</p>
    pub table_restore_request_id: Option<String>,
    /// <p>The name of the database to restore the table to.</p>
    pub target_database_name: Option<String>,
    /// <p>The name of the schema to restore the table to.</p>
    pub target_schema_name: Option<String>,
    /// <p>The total amount of data to restore to the new table, in megabytes (MB).</p>
    pub total_data_in_mega_bytes: Option<i64>,
}

#[allow(dead_code)]
struct TableRestoreStatusDeserializer;
impl TableRestoreStatusDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<TableRestoreStatus, XmlParseError> {
        deserialize_elements::<_, TableRestoreStatus, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "Message" => {
                    obj.message = Some(StringDeserializer::deserialize("Message", stack)?);
                }
                "NewTableName" => {
                    obj.new_table_name =
                        Some(StringDeserializer::deserialize("NewTableName", stack)?);
                }
                "ProgressInMegaBytes" => {
                    obj.progress_in_mega_bytes = Some(LongOptionalDeserializer::deserialize(
                        "ProgressInMegaBytes",
                        stack,
                    )?);
                }
                "RequestTime" => {
                    obj.request_time = Some(TStampDeserializer::deserialize("RequestTime", stack)?);
                }
                "SnapshotIdentifier" => {
                    obj.snapshot_identifier = Some(StringDeserializer::deserialize(
                        "SnapshotIdentifier",
                        stack,
                    )?);
                }
                "SourceDatabaseName" => {
                    obj.source_database_name = Some(StringDeserializer::deserialize(
                        "SourceDatabaseName",
                        stack,
                    )?);
                }
                "SourceSchemaName" => {
                    obj.source_schema_name =
                        Some(StringDeserializer::deserialize("SourceSchemaName", stack)?);
                }
                "SourceTableName" => {
                    obj.source_table_name =
                        Some(StringDeserializer::deserialize("SourceTableName", stack)?);
                }
                "Status" => {
                    obj.status = Some(TableRestoreStatusTypeDeserializer::deserialize(
                        "Status", stack,
                    )?);
                }
                "TableRestoreRequestId" => {
                    obj.table_restore_request_id = Some(StringDeserializer::deserialize(
                        "TableRestoreRequestId",
                        stack,
                    )?);
                }
                "TargetDatabaseName" => {
                    obj.target_database_name = Some(StringDeserializer::deserialize(
                        "TargetDatabaseName",
                        stack,
                    )?);
                }
                "TargetSchemaName" => {
                    obj.target_schema_name =
                        Some(StringDeserializer::deserialize("TargetSchemaName", stack)?);
                }
                "TotalDataInMegaBytes" => {
                    obj.total_data_in_mega_bytes = Some(LongOptionalDeserializer::deserialize(
                        "TotalDataInMegaBytes",
                        stack,
                    )?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct TableRestoreStatusListDeserializer;
impl TableRestoreStatusListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<TableRestoreStatus>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "TableRestoreStatus" {
                obj.push(TableRestoreStatusDeserializer::deserialize(
                    "TableRestoreStatus",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct TableRestoreStatusMessage {
    /// <p>A pagination token that can be used in a subsequent <a>DescribeTableRestoreStatus</a> request.</p>
    pub marker: Option<String>,
    /// <p>A list of status details for one or more table restore requests.</p>
    pub table_restore_status_details: Option<Vec<TableRestoreStatus>>,
}

#[allow(dead_code)]
struct TableRestoreStatusMessageDeserializer;
impl TableRestoreStatusMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<TableRestoreStatusMessage, XmlParseError> {
        deserialize_elements::<_, TableRestoreStatusMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "TableRestoreStatusDetails" => {
                        obj.table_restore_status_details
                            .get_or_insert(vec![])
                            .extend(TableRestoreStatusListDeserializer::deserialize(
                                "TableRestoreStatusDetails",
                                stack,
                            )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct TableRestoreStatusTypeDeserializer;
impl TableRestoreStatusTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
/// <p>A tag consisting of a name/value pair for a resource.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct Tag {
    /// <p>The key, or name, for the resource tag.</p>
    pub key: Option<String>,
    /// <p>The value for the resource tag.</p>
    pub value: Option<String>,
}

#[allow(dead_code)]
struct TagDeserializer;
impl TagDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<Tag, XmlParseError> {
        deserialize_elements::<_, Tag, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Key" => {
                    obj.key = Some(StringDeserializer::deserialize("Key", stack)?);
                }
                "Value" => {
                    obj.value = Some(StringDeserializer::deserialize("Value", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}

/// Serialize `Tag` contents to a `SignedRequest`.
struct TagSerializer;
impl TagSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Tag) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        if let Some(ref field_value) = obj.key {
            params.put(&format!("{}{}", prefix, "Key"), &field_value);
        }
        if let Some(ref field_value) = obj.value {
            params.put(&format!("{}{}", prefix, "Value"), &field_value);
        }
    }
}

/// Serialize `TagKeyList` contents to a `SignedRequest`.
struct TagKeyListSerializer;
impl TagKeyListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

#[allow(dead_code)]
struct TagListDeserializer;
impl TagListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<Tag>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "Tag" {
                obj.push(TagDeserializer::deserialize("Tag", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `TagList` contents to a `SignedRequest`.
struct TagListSerializer;
impl TagListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<Tag>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            TagSerializer::serialize(params, &key, obj);
        }
    }
}

/// Serialize `TagValueList` contents to a `SignedRequest`.
struct TagValueListSerializer;
impl TagValueListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>A tag and its associated resource.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct TaggedResource {
    /// <p>The Amazon Resource Name (ARN) with which the tag is associated, for example: <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.</p>
    pub resource_name: Option<String>,
    /// <p>The type of resource with which the tag is associated. Valid resource types are: </p> <ul> <li> <p>Cluster</p> </li> <li> <p>CIDR/IP</p> </li> <li> <p>EC2 security group</p> </li> <li> <p>Snapshot</p> </li> <li> <p>Cluster security group</p> </li> <li> <p>Subnet group</p> </li> <li> <p>HSM connection</p> </li> <li> <p>HSM certificate</p> </li> <li> <p>Parameter group</p> </li> </ul> <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide. </p>
    pub resource_type: Option<String>,
    /// <p>The tag for the resource.</p>
    pub tag: Option<Tag>,
}

#[allow(dead_code)]
struct TaggedResourceDeserializer;
impl TaggedResourceDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<TaggedResource, XmlParseError> {
        deserialize_elements::<_, TaggedResource, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "ResourceName" => {
                    obj.resource_name =
                        Some(StringDeserializer::deserialize("ResourceName", stack)?);
                }
                "ResourceType" => {
                    obj.resource_type =
                        Some(StringDeserializer::deserialize("ResourceType", stack)?);
                }
                "Tag" => {
                    obj.tag = Some(TagDeserializer::deserialize("Tag", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct TaggedResourceListDeserializer;
impl TaggedResourceListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<TaggedResource>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "TaggedResource" {
                obj.push(TaggedResourceDeserializer::deserialize(
                    "TaggedResource",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// <p><p/></p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct TaggedResourceListMessage {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>A list of tags with their associated resources.</p>
    pub tagged_resources: Option<Vec<TaggedResource>>,
}

#[allow(dead_code)]
struct TaggedResourceListMessageDeserializer;
impl TaggedResourceListMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<TaggedResourceListMessage, XmlParseError> {
        deserialize_elements::<_, TaggedResourceListMessage, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Marker" => {
                        obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                    }
                    "TaggedResources" => {
                        obj.tagged_resources.get_or_insert(vec![]).extend(
                            TaggedResourceListDeserializer::deserialize("TaggedResources", stack)?,
                        );
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct TrackListDeserializer;
impl TrackListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<MaintenanceTrack>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "MaintenanceTrack" {
                obj.push(MaintenanceTrackDeserializer::deserialize(
                    "MaintenanceTrack",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct TrackListMessage {
    /// <p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>
    pub maintenance_tracks: Option<Vec<MaintenanceTrack>>,
    /// <p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
    pub marker: Option<String>,
}

#[allow(dead_code)]
struct TrackListMessageDeserializer;
impl TrackListMessageDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<TrackListMessage, XmlParseError> {
        deserialize_elements::<_, TrackListMessage, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "MaintenanceTracks" => {
                    obj.maintenance_tracks.get_or_insert(vec![]).extend(
                        TrackListDeserializer::deserialize("MaintenanceTracks", stack)?,
                    );
                }
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "deserialize_structs", derive(Deserialize))]
pub struct UpdatePartnerStatusInputMessage {
    /// <p>The AWS account ID that owns the cluster.</p>
    pub account_id: String,
    /// <p>The cluster identifier of the cluster whose partner integration status is being updated.</p>
    pub cluster_identifier: String,
    /// <p>The name of the database whose partner integration status is being updated.</p>
    pub database_name: String,
    /// <p>The name of the partner whose integration status is being updated.</p>
    pub partner_name: String,
    /// <p>The value of the updated status.</p>
    pub status: String,
    /// <p>The status message provided by the partner.</p>
    pub status_message: Option<String>,
}

/// Serialize `UpdatePartnerStatusInputMessage` contents to a `SignedRequest`.
struct UpdatePartnerStatusInputMessageSerializer;
impl UpdatePartnerStatusInputMessageSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &UpdatePartnerStatusInputMessage) {
        let mut prefix = name.to_string();
        if prefix != "" {
            prefix.push_str(".");
        }

        params.put(&format!("{}{}", prefix, "AccountId"), &obj.account_id);
        params.put(
            &format!("{}{}", prefix, "ClusterIdentifier"),
            &obj.cluster_identifier,
        );
        params.put(&format!("{}{}", prefix, "DatabaseName"), &obj.database_name);
        params.put(&format!("{}{}", prefix, "PartnerName"), &obj.partner_name);
        params.put(&format!("{}{}", prefix, "Status"), &obj.status);
        if let Some(ref field_value) = obj.status_message {
            params.put(&format!("{}{}", prefix, "StatusMessage"), &field_value);
        }
    }
}

/// <p>A maintenance track that you can switch the current track to.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UpdateTarget {
    /// <p>The cluster version for the new maintenance track.</p>
    pub database_version: Option<String>,
    /// <p>The name of the new maintenance track.</p>
    pub maintenance_track_name: Option<String>,
    /// <p>A list of operations supported by the maintenance track.</p>
    pub supported_operations: Option<Vec<SupportedOperation>>,
}

#[allow(dead_code)]
struct UpdateTargetDeserializer;
impl UpdateTargetDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UpdateTarget, XmlParseError> {
        deserialize_elements::<_, UpdateTarget, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "DatabaseVersion" => {
                    obj.database_version =
                        Some(StringDeserializer::deserialize("DatabaseVersion", stack)?);
                }
                "MaintenanceTrackName" => {
                    obj.maintenance_track_name = Some(StringDeserializer::deserialize(
                        "MaintenanceTrackName",
                        stack,
                    )?);
                }
                "SupportedOperations" => {
                    obj.supported_operations.get_or_insert(vec![]).extend(
                        SupportedOperationListDeserializer::deserialize(
                            "SupportedOperations",
                            stack,
                        )?,
                    );
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
/// <p>Describes a usage limit object for a cluster. </p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UsageLimit {
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub amount: Option<i64>,
    /// <p><p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p> <ul> <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li> <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li> <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li> </ul></p>
    pub breach_action: Option<String>,
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub cluster_identifier: Option<String>,
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub feature_type: Option<String>,
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub limit_type: Option<String>,
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub period: Option<String>,
    /// <p>A list of tag instances.</p>
    pub tags: Option<Vec<Tag>>,
    /// <p>The identifier of the usage limit.</p>
    pub usage_limit_id: Option<String>,
}

#[allow(dead_code)]
struct UsageLimitDeserializer;
impl UsageLimitDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UsageLimit, XmlParseError> {
        deserialize_elements::<_, UsageLimit, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Amount" => {
                    obj.amount = Some(LongDeserializer::deserialize("Amount", stack)?);
                }
                "BreachAction" => {
                    obj.breach_action = Some(UsageLimitBreachActionDeserializer::deserialize(
                        "BreachAction",
                        stack,
                    )?);
                }
                "ClusterIdentifier" => {
                    obj.cluster_identifier =
                        Some(StringDeserializer::deserialize("ClusterIdentifier", stack)?);
                }
                "FeatureType" => {
                    obj.feature_type = Some(UsageLimitFeatureTypeDeserializer::deserialize(
                        "FeatureType",
                        stack,
                    )?);
                }
                "LimitType" => {
                    obj.limit_type = Some(UsageLimitLimitTypeDeserializer::deserialize(
                        "LimitType",
                        stack,
                    )?);
                }
                "Period" => {
                    obj.period = Some(UsageLimitPeriodDeserializer::deserialize("Period", stack)?);
                }
                "Tags" => {
                    obj.tags
                        .get_or_insert(vec![])
                        .extend(TagListDeserializer::deserialize("Tags", stack)?);
                }
                "UsageLimitId" => {
                    obj.usage_limit_id =
                        Some(StringDeserializer::deserialize("UsageLimitId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct UsageLimitBreachActionDeserializer;
impl UsageLimitBreachActionDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct UsageLimitFeatureTypeDeserializer;
impl UsageLimitFeatureTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct UsageLimitLimitTypeDeserializer;
impl UsageLimitLimitTypeDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct UsageLimitList {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: Option<String>,
    /// <p>Contains the output from the <a>DescribeUsageLimits</a> action. </p>
    pub usage_limits: Option<Vec<UsageLimit>>,
}

#[allow(dead_code)]
struct UsageLimitListDeserializer;
impl UsageLimitListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<UsageLimitList, XmlParseError> {
        deserialize_elements::<_, UsageLimitList, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "Marker" => {
                    obj.marker = Some(StringDeserializer::deserialize("Marker", stack)?);
                }
                "UsageLimits" => {
                    obj.usage_limits
                        .get_or_insert(vec![])
                        .extend(UsageLimitsDeserializer::deserialize("UsageLimits", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct UsageLimitPeriodDeserializer;
impl UsageLimitPeriodDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(tag_name: &str, stack: &mut T) -> Result<String, XmlParseError> {
        xml_util::deserialize_primitive(tag_name, stack, Ok)
    }
}
#[allow(dead_code)]
struct UsageLimitsDeserializer;
impl UsageLimitsDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<UsageLimit>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "member" {
                obj.push(UsageLimitDeserializer::deserialize("member", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `ValueStringList` contents to a `SignedRequest`.
struct ValueStringListSerializer;
impl ValueStringListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct VpcEndpoint {
    /// <p>One or more network interfaces of the endpoint. Also known as an interface endpoint. </p>
    pub network_interfaces: Option<Vec<NetworkInterface>>,
    /// <p>The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.</p>
    pub vpc_endpoint_id: Option<String>,
    /// <p>The VPC identifier that the endpoint is associated. </p>
    pub vpc_id: Option<String>,
}

#[allow(dead_code)]
struct VpcEndpointDeserializer;
impl VpcEndpointDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<VpcEndpoint, XmlParseError> {
        deserialize_elements::<_, VpcEndpoint, _>(tag_name, stack, |name, stack, obj| {
            match name {
                "NetworkInterfaces" => {
                    obj.network_interfaces.get_or_insert(vec![]).extend(
                        NetworkInterfaceListDeserializer::deserialize("NetworkInterfaces", stack)?,
                    );
                }
                "VpcEndpointId" => {
                    obj.vpc_endpoint_id =
                        Some(StringDeserializer::deserialize("VpcEndpointId", stack)?);
                }
                "VpcId" => {
                    obj.vpc_id = Some(StringDeserializer::deserialize("VpcId", stack)?);
                }
                _ => skip_tree(stack),
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct VpcEndpointsListDeserializer;
impl VpcEndpointsListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<VpcEndpoint>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "VpcEndpoint" {
                obj.push(VpcEndpointDeserializer::deserialize("VpcEndpoint", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
#[allow(dead_code)]
struct VpcIdentifierListDeserializer;
impl VpcIdentifierListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<String>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "VpcIdentifier" {
                obj.push(StringDeserializer::deserialize("VpcIdentifier", stack)?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}

/// Serialize `VpcIdentifierList` contents to a `SignedRequest`.
struct VpcIdentifierListSerializer;
impl VpcIdentifierListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// Serialize `VpcSecurityGroupIdList` contents to a `SignedRequest`.
struct VpcSecurityGroupIdListSerializer;
impl VpcSecurityGroupIdListSerializer {
    fn serialize(params: &mut Params, name: &str, obj: &Vec<String>) {
        for (index, obj) in obj.iter().enumerate() {
            let key = format!("{}.member.{}", name, index + 1);
            params.put(&key, &obj);
        }
    }
}

/// <p>Describes the members of a VPC security group.</p>
#[derive(Clone, Debug, Default, PartialEq)]
#[cfg_attr(feature = "serialize_structs", derive(Serialize))]
pub struct VpcSecurityGroupMembership {
    /// <p>The status of the VPC security group.</p>
    pub status: Option<String>,
    /// <p>The identifier of the VPC security group.</p>
    pub vpc_security_group_id: Option<String>,
}

#[allow(dead_code)]
struct VpcSecurityGroupMembershipDeserializer;
impl VpcSecurityGroupMembershipDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<VpcSecurityGroupMembership, XmlParseError> {
        deserialize_elements::<_, VpcSecurityGroupMembership, _>(
            tag_name,
            stack,
            |name, stack, obj| {
                match name {
                    "Status" => {
                        obj.status = Some(StringDeserializer::deserialize("Status", stack)?);
                    }
                    "VpcSecurityGroupId" => {
                        obj.vpc_security_group_id = Some(StringDeserializer::deserialize(
                            "VpcSecurityGroupId",
                            stack,
                        )?);
                    }
                    _ => skip_tree(stack),
                }
                Ok(())
            },
        )
    }
}
#[allow(dead_code)]
struct VpcSecurityGroupMembershipListDeserializer;
impl VpcSecurityGroupMembershipListDeserializer {
    #[allow(dead_code, unused_variables)]
    fn deserialize<T: Peek + Next>(
        tag_name: &str,
        stack: &mut T,
    ) -> Result<Vec<VpcSecurityGroupMembership>, XmlParseError> {
        deserialize_elements::<_, Vec<_>, _>(tag_name, stack, |name, stack, obj| {
            if name == "VpcSecurityGroup" {
                obj.push(VpcSecurityGroupMembershipDeserializer::deserialize(
                    "VpcSecurityGroup",
                    stack,
                )?);
            } else {
                skip_tree(stack);
            }
            Ok(())
        })
    }
}
/// Errors returned by AcceptReservedNodeExchange
#[derive(Debug, PartialEq)]
pub enum AcceptReservedNodeExchangeError {
    /// <p>Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(String),
    /// <p>Indicates that the Reserved Node being exchanged is not in an active state.</p>
    InvalidReservedNodeStateFault(String),
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedNodeAlreadyExistsFault(String),
    /// <p>Indicates that the reserved node has already been exchanged.</p>
    ReservedNodeAlreadyMigratedFault(String),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(String),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl AcceptReservedNodeExchangeError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AcceptReservedNodeExchangeError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DependentServiceUnavailableFault" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::DependentServiceUnavailableFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidReservedNodeState" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::InvalidReservedNodeStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeAlreadyExists" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::ReservedNodeAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeAlreadyMigrated" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::ReservedNodeAlreadyMigratedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeNotFound" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::ReservedNodeNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeOfferingNotFound" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::ReservedNodeOfferingNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            AcceptReservedNodeExchangeError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AcceptReservedNodeExchangeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AcceptReservedNodeExchangeError::DependentServiceUnavailableFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptReservedNodeExchangeError::InvalidReservedNodeStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptReservedNodeExchangeError::ReservedNodeAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptReservedNodeExchangeError::ReservedNodeAlreadyMigratedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptReservedNodeExchangeError::ReservedNodeNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptReservedNodeExchangeError::ReservedNodeOfferingNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AcceptReservedNodeExchangeError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AcceptReservedNodeExchangeError {}
/// Errors returned by AddPartner
#[derive(Debug, PartialEq)]
pub enum AddPartnerError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(String),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(String),
}

impl AddPartnerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AddPartnerError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(AddPartnerError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "PartnerNotFound" => {
                        return RusotoError::Service(AddPartnerError::PartnerNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "UnauthorizedPartnerIntegration" => {
                        return RusotoError::Service(
                            AddPartnerError::UnauthorizedPartnerIntegrationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AddPartnerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AddPartnerError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            AddPartnerError::PartnerNotFoundFault(ref cause) => write!(f, "{}", cause),
            AddPartnerError::UnauthorizedPartnerIntegrationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AddPartnerError {}
/// Errors returned by AuthorizeClusterSecurityGroupIngress
#[derive(Debug, PartialEq)]
pub enum AuthorizeClusterSecurityGroupIngressError {
    /// <p>The specified CIDR block or EC2 security group is already authorized for the specified cluster security group.</p>
    AuthorizationAlreadyExistsFault(String),
    /// <p>The authorization quota for the cluster security group has been reached.</p>
    AuthorizationQuotaExceededFault(String),
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
}

impl AuthorizeClusterSecurityGroupIngressError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<AuthorizeClusterSecurityGroupIngressError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                                    "AuthorizationAlreadyExists" => return RusotoError::Service(AuthorizeClusterSecurityGroupIngressError::AuthorizationAlreadyExistsFault(parsed_error.message)),"AuthorizationQuotaExceeded" => return RusotoError::Service(AuthorizeClusterSecurityGroupIngressError::AuthorizationQuotaExceededFault(parsed_error.message)),"ClusterSecurityGroupNotFound" => return RusotoError::Service(AuthorizeClusterSecurityGroupIngressError::ClusterSecurityGroupNotFoundFault(parsed_error.message)),"InvalidClusterSecurityGroupState" => return RusotoError::Service(AuthorizeClusterSecurityGroupIngressError::InvalidClusterSecurityGroupStateFault(parsed_error.message)),_ => {}
                                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AuthorizeClusterSecurityGroupIngressError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AuthorizeClusterSecurityGroupIngressError::AuthorizationAlreadyExistsFault(
                ref cause,
            ) => write!(f, "{}", cause),
            AuthorizeClusterSecurityGroupIngressError::AuthorizationQuotaExceededFault(
                ref cause,
            ) => write!(f, "{}", cause),
            AuthorizeClusterSecurityGroupIngressError::ClusterSecurityGroupNotFoundFault(
                ref cause,
            ) => write!(f, "{}", cause),
            AuthorizeClusterSecurityGroupIngressError::InvalidClusterSecurityGroupStateFault(
                ref cause,
            ) => write!(f, "{}", cause),
        }
    }
}
impl Error for AuthorizeClusterSecurityGroupIngressError {}
/// Errors returned by AuthorizeEndpointAccess
#[derive(Debug, PartialEq)]
pub enum AuthorizeEndpointAccessError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The authorization already exists for this endpoint.</p>
    EndpointAuthorizationAlreadyExistsFault(String),
    /// <p>The number of endpoint authorizations per cluster has exceeded its limit.</p>
    EndpointAuthorizationsPerClusterLimitExceededFault(String),
    /// <p>The status of the authorization is not valid.</p>
    InvalidAuthorizationStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl AuthorizeEndpointAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AuthorizeEndpointAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                                    "ClusterNotFound" => return RusotoError::Service(AuthorizeEndpointAccessError::ClusterNotFoundFault(parsed_error.message)),"EndpointAuthorizationAlreadyExists" => return RusotoError::Service(AuthorizeEndpointAccessError::EndpointAuthorizationAlreadyExistsFault(parsed_error.message)),"EndpointAuthorizationsPerClusterLimitExceeded" => return RusotoError::Service(AuthorizeEndpointAccessError::EndpointAuthorizationsPerClusterLimitExceededFault(parsed_error.message)),"InvalidAuthorizationState" => return RusotoError::Service(AuthorizeEndpointAccessError::InvalidAuthorizationStateFault(parsed_error.message)),"InvalidClusterState" => return RusotoError::Service(AuthorizeEndpointAccessError::InvalidClusterStateFault(parsed_error.message)),"UnsupportedOperation" => return RusotoError::Service(AuthorizeEndpointAccessError::UnsupportedOperationFault(parsed_error.message)),_ => {}
                                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AuthorizeEndpointAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AuthorizeEndpointAccessError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            AuthorizeEndpointAccessError::EndpointAuthorizationAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeEndpointAccessError::EndpointAuthorizationsPerClusterLimitExceededFault(
                ref cause,
            ) => write!(f, "{}", cause),
            AuthorizeEndpointAccessError::InvalidAuthorizationStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeEndpointAccessError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeEndpointAccessError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for AuthorizeEndpointAccessError {}
/// Errors returned by AuthorizeSnapshotAccess
#[derive(Debug, PartialEq)]
pub enum AuthorizeSnapshotAccessError {
    /// <p>The specified CIDR block or EC2 security group is already authorized for the specified cluster security group.</p>
    AuthorizationAlreadyExistsFault(String),
    /// <p>The authorization quota for the cluster security group has been reached.</p>
    AuthorizationQuotaExceededFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
}

impl AuthorizeSnapshotAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<AuthorizeSnapshotAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "AuthorizationAlreadyExists" => {
                        return RusotoError::Service(
                            AuthorizeSnapshotAccessError::AuthorizationAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "AuthorizationQuotaExceeded" => {
                        return RusotoError::Service(
                            AuthorizeSnapshotAccessError::AuthorizationQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            AuthorizeSnapshotAccessError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            AuthorizeSnapshotAccessError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSnapshotState" => {
                        return RusotoError::Service(
                            AuthorizeSnapshotAccessError::InvalidClusterSnapshotStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(
                            AuthorizeSnapshotAccessError::LimitExceededFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for AuthorizeSnapshotAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            AuthorizeSnapshotAccessError::AuthorizationAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeSnapshotAccessError::AuthorizationQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeSnapshotAccessError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeSnapshotAccessError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeSnapshotAccessError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            AuthorizeSnapshotAccessError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for AuthorizeSnapshotAccessError {}
/// Errors returned by BatchDeleteClusterSnapshots
#[derive(Debug, PartialEq)]
pub enum BatchDeleteClusterSnapshotsError {
    /// <p>The maximum number for a batch delete of snapshots has been reached. The limit is 100. </p>
    BatchDeleteRequestSizeExceededFault(String),
}

impl BatchDeleteClusterSnapshotsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<BatchDeleteClusterSnapshotsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "BatchDeleteRequestSizeExceeded" => {
                        return RusotoError::Service(
                            BatchDeleteClusterSnapshotsError::BatchDeleteRequestSizeExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for BatchDeleteClusterSnapshotsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchDeleteClusterSnapshotsError::BatchDeleteRequestSizeExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for BatchDeleteClusterSnapshotsError {}
/// Errors returned by BatchModifyClusterSnapshots
#[derive(Debug, PartialEq)]
pub enum BatchModifyClusterSnapshotsError {
    /// <p>The maximum number for snapshot identifiers has been reached. The limit is 100. </p>
    BatchModifyClusterSnapshotsLimitExceededFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
}

impl BatchModifyClusterSnapshotsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<BatchModifyClusterSnapshotsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                                    "BatchModifyClusterSnapshotsLimitExceededFault" => return RusotoError::Service(BatchModifyClusterSnapshotsError::BatchModifyClusterSnapshotsLimitExceededFault(parsed_error.message)),"InvalidRetentionPeriodFault" => return RusotoError::Service(BatchModifyClusterSnapshotsError::InvalidRetentionPeriodFault(parsed_error.message)),_ => {}
                                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for BatchModifyClusterSnapshotsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            BatchModifyClusterSnapshotsError::BatchModifyClusterSnapshotsLimitExceededFault(
                ref cause,
            ) => write!(f, "{}", cause),
            BatchModifyClusterSnapshotsError::InvalidRetentionPeriodFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for BatchModifyClusterSnapshotsError {}
/// Errors returned by CancelResize
#[derive(Debug, PartialEq)]
pub enum CancelResizeError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>A resize operation for the specified cluster is not found.</p>
    ResizeNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl CancelResizeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CancelResizeError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(CancelResizeError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(CancelResizeError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    "ResizeNotFound" => {
                        return RusotoError::Service(CancelResizeError::ResizeNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(CancelResizeError::UnsupportedOperationFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CancelResizeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CancelResizeError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            CancelResizeError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            CancelResizeError::ResizeNotFoundFault(ref cause) => write!(f, "{}", cause),
            CancelResizeError::UnsupportedOperationFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CancelResizeError {}
/// Errors returned by CopyClusterSnapshot
#[derive(Debug, PartialEq)]
pub enum CopyClusterSnapshotError {
    /// <p>The value specified as a snapshot identifier is already used by an existing snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The request would result in the user exceeding the allowed number of cluster snapshots.</p>
    ClusterSnapshotQuotaExceededFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
}

impl CopyClusterSnapshotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CopyClusterSnapshotError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSnapshotAlreadyExists" => {
                        return RusotoError::Service(
                            CopyClusterSnapshotError::ClusterSnapshotAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            CopyClusterSnapshotError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotQuotaExceeded" => {
                        return RusotoError::Service(
                            CopyClusterSnapshotError::ClusterSnapshotQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSnapshotState" => {
                        return RusotoError::Service(
                            CopyClusterSnapshotError::InvalidClusterSnapshotStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            CopyClusterSnapshotError::InvalidRetentionPeriodFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CopyClusterSnapshotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CopyClusterSnapshotError::ClusterSnapshotAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CopyClusterSnapshotError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CopyClusterSnapshotError::ClusterSnapshotQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CopyClusterSnapshotError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CopyClusterSnapshotError::InvalidRetentionPeriodFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CopyClusterSnapshotError {}
/// Errors returned by CreateCluster
#[derive(Debug, PartialEq)]
pub enum CreateClusterError {
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(String),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The request would exceed the allowed number of cluster instances for this account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterQuotaExceededFault(String),
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>
    ClusterSubnetGroupNotFoundFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified identifier.</p>
    HsmClientCertificateNotFoundFault(String),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(String),
    /// <p>The number of nodes specified exceeds the allotted capacity of the cluster.</p>
    InsufficientClusterCapacityFault(String),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(String),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(String),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same VPC.</p>
    InvalidSubnet(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The cluster subnet group does not cover all Availability Zones.</p>
    InvalidVPCNetworkStateFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allotted to the account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    NumberOfNodesQuotaExceededFault(String),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl CreateClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterAlreadyExists" => {
                        return RusotoError::Service(CreateClusterError::ClusterAlreadyExistsFault(
                            parsed_error.message,
                        ))
                    }
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            CreateClusterError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterQuotaExceeded" => {
                        return RusotoError::Service(CreateClusterError::ClusterQuotaExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "ClusterSecurityGroupNotFound" => {
                        return RusotoError::Service(
                            CreateClusterError::ClusterSecurityGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSubnetGroupNotFoundFault" => {
                        return RusotoError::Service(
                            CreateClusterError::ClusterSubnetGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            CreateClusterError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmClientCertificateNotFoundFault" => {
                        return RusotoError::Service(
                            CreateClusterError::HsmClientCertificateNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmConfigurationNotFoundFault" => {
                        return RusotoError::Service(
                            CreateClusterError::HsmConfigurationNotFoundFault(parsed_error.message),
                        )
                    }
                    "InsufficientClusterCapacity" => {
                        return RusotoError::Service(
                            CreateClusterError::InsufficientClusterCapacityFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSubnetGroupStateFault" => {
                        return RusotoError::Service(
                            CreateClusterError::InvalidClusterSubnetGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterTrack" => {
                        return RusotoError::Service(CreateClusterError::InvalidClusterTrackFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidElasticIpFault" => {
                        return RusotoError::Service(CreateClusterError::InvalidElasticIpFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            CreateClusterError::InvalidRetentionPeriodFault(parsed_error.message),
                        )
                    }
                    "InvalidSubnet" => {
                        return RusotoError::Service(CreateClusterError::InvalidSubnet(
                            parsed_error.message,
                        ))
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateClusterError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidVPCNetworkStateFault" => {
                        return RusotoError::Service(
                            CreateClusterError::InvalidVPCNetworkStateFault(parsed_error.message),
                        )
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(CreateClusterError::LimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "NumberOfNodesPerClusterLimitExceeded" => {
                        return RusotoError::Service(
                            CreateClusterError::NumberOfNodesPerClusterLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NumberOfNodesQuotaExceeded" => {
                        return RusotoError::Service(
                            CreateClusterError::NumberOfNodesQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotScheduleNotFound" => {
                        return RusotoError::Service(
                            CreateClusterError::SnapshotScheduleNotFoundFault(parsed_error.message),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(CreateClusterError::TagLimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(CreateClusterError::UnauthorizedOperation(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateClusterError::ClusterAlreadyExistsFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::ClusterQuotaExceededFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::ClusterSecurityGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::ClusterSubnetGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::HsmClientCertificateNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::HsmConfigurationNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::InsufficientClusterCapacityFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::InvalidClusterSubnetGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::InvalidClusterTrackFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::InvalidElasticIpFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::InvalidRetentionPeriodFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::InvalidSubnet(ref cause) => write!(f, "{}", cause),
            CreateClusterError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::InvalidVPCNetworkStateFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::NumberOfNodesPerClusterLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::NumberOfNodesQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterError::SnapshotScheduleNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::TagLimitExceededFault(ref cause) => write!(f, "{}", cause),
            CreateClusterError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateClusterError {}
/// Errors returned by CreateClusterParameterGroup
#[derive(Debug, PartialEq)]
pub enum CreateClusterParameterGroupError {
    /// <p>A cluster parameter group with the same name already exists.</p>
    ClusterParameterGroupAlreadyExistsFault(String),
    /// <p>The request would result in the user exceeding the allowed number of cluster parameter groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterParameterGroupQuotaExceededFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateClusterParameterGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateClusterParameterGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterParameterGroupAlreadyExists" => return RusotoError::Service(
                        CreateClusterParameterGroupError::ClusterParameterGroupAlreadyExistsFault(
                            parsed_error.message,
                        ),
                    ),
                    "ClusterParameterGroupQuotaExceeded" => return RusotoError::Service(
                        CreateClusterParameterGroupError::ClusterParameterGroupQuotaExceededFault(
                            parsed_error.message,
                        ),
                    ),
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            CreateClusterParameterGroupError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateClusterParameterGroupError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateClusterParameterGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateClusterParameterGroupError::ClusterParameterGroupAlreadyExistsFault(
                ref cause,
            ) => write!(f, "{}", cause),
            CreateClusterParameterGroupError::ClusterParameterGroupQuotaExceededFault(
                ref cause,
            ) => write!(f, "{}", cause),
            CreateClusterParameterGroupError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateClusterParameterGroupError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateClusterParameterGroupError {}
/// Errors returned by CreateClusterSecurityGroup
#[derive(Debug, PartialEq)]
pub enum CreateClusterSecurityGroupError {
    /// <p>A cluster security group with the same name already exists.</p>
    ClusterSecurityGroupAlreadyExistsFault(String),
    /// <p>The request would result in the user exceeding the allowed number of cluster security groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterSecurityGroupQuotaExceededFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateClusterSecurityGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateClusterSecurityGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSecurityGroupAlreadyExists" => {
                        return RusotoError::Service(
                            CreateClusterSecurityGroupError::ClusterSecurityGroupAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "QuotaExceeded.ClusterSecurityGroup" => {
                        return RusotoError::Service(
                            CreateClusterSecurityGroupError::ClusterSecurityGroupQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            CreateClusterSecurityGroupError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateClusterSecurityGroupError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateClusterSecurityGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateClusterSecurityGroupError::ClusterSecurityGroupAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSecurityGroupError::ClusterSecurityGroupQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSecurityGroupError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateClusterSecurityGroupError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateClusterSecurityGroupError {}
/// Errors returned by CreateClusterSnapshot
#[derive(Debug, PartialEq)]
pub enum CreateClusterSnapshotError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The value specified as a snapshot identifier is already used by an existing snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(String),
    /// <p>The request would result in the user exceeding the allowed number of cluster snapshots.</p>
    ClusterSnapshotQuotaExceededFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateClusterSnapshotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateClusterSnapshotError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            CreateClusterSnapshotError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "ClusterSnapshotAlreadyExists" => {
                        return RusotoError::Service(
                            CreateClusterSnapshotError::ClusterSnapshotAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotQuotaExceeded" => {
                        return RusotoError::Service(
                            CreateClusterSnapshotError::ClusterSnapshotQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            CreateClusterSnapshotError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            CreateClusterSnapshotError::InvalidRetentionPeriodFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateClusterSnapshotError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateClusterSnapshotError::TagLimitExceededFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateClusterSnapshotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateClusterSnapshotError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateClusterSnapshotError::ClusterSnapshotAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSnapshotError::ClusterSnapshotQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSnapshotError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSnapshotError::InvalidRetentionPeriodFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSnapshotError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateClusterSnapshotError::TagLimitExceededFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateClusterSnapshotError {}
/// Errors returned by CreateClusterSubnetGroup
#[derive(Debug, PartialEq)]
pub enum CreateClusterSubnetGroupError {
    /// <p>A <i>ClusterSubnetGroupName</i> is already used by an existing cluster subnet group. </p>
    ClusterSubnetGroupAlreadyExistsFault(String),
    /// <p>The request would result in user exceeding the allowed number of cluster subnet groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterSubnetGroupQuotaExceededFault(String),
    /// <p>The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterSubnetQuotaExceededFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same VPC.</p>
    InvalidSubnet(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl CreateClusterSubnetGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateClusterSubnetGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSubnetGroupAlreadyExists" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::ClusterSubnetGroupAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSubnetGroupQuotaExceeded" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::ClusterSubnetGroupQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSubnetQuotaExceededFault" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::ClusterSubnetQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidSubnet" => {
                        return RusotoError::Service(CreateClusterSubnetGroupError::InvalidSubnet(
                            parsed_error.message,
                        ))
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            CreateClusterSubnetGroupError::UnauthorizedOperation(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateClusterSubnetGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateClusterSubnetGroupError::ClusterSubnetGroupAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSubnetGroupError::ClusterSubnetGroupQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSubnetGroupError::ClusterSubnetQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSubnetGroupError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSubnetGroupError::InvalidSubnet(ref cause) => write!(f, "{}", cause),
            CreateClusterSubnetGroupError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateClusterSubnetGroupError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateClusterSubnetGroupError::UnauthorizedOperation(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateClusterSubnetGroupError {}
/// Errors returned by CreateEndpointAccess
#[derive(Debug, PartialEq)]
pub enum CreateEndpointAccessError {
    /// <p>You are not authorized to access the cluster.</p>
    AccessToClusterDeniedFault(String),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>
    ClusterSubnetGroupNotFoundFault(String),
    /// <p>The account already has a Redshift-managed VPC endpoint with the given identifier.</p>
    EndpointAlreadyExistsFault(String),
    /// <p>The number of Redshift-managed VPC endpoints per authorization has exceeded its limit.</p>
    EndpointsPerAuthorizationLimitExceededFault(String),
    /// <p>The number of Redshift-managed VPC endpoints per cluster has exceeded its limit.</p>
    EndpointsPerClusterLimitExceededFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl CreateEndpointAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateEndpointAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "AccessToClusterDenied" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::AccessToClusterDeniedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "ClusterSubnetGroupNotFoundFault" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::ClusterSubnetGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EndpointAlreadyExists" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::EndpointAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EndpointsPerAuthorizationLimitExceeded" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::EndpointsPerAuthorizationLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EndpointsPerClusterLimitExceeded" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::EndpointsPerClusterLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSecurityGroupState" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::InvalidClusterSecurityGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            CreateEndpointAccessError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateEndpointAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateEndpointAccessError::AccessToClusterDeniedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateEndpointAccessError::ClusterSubnetGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::EndpointAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::EndpointsPerAuthorizationLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::EndpointsPerClusterLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::InvalidClusterSecurityGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEndpointAccessError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
            CreateEndpointAccessError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateEndpointAccessError {}
/// Errors returned by CreateEventSubscription
#[derive(Debug, PartialEq)]
pub enum CreateEventSubscriptionError {
    /// <p>The request would exceed the allowed number of event subscriptions for this account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    EventSubscriptionQuotaExceededFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.</p>
    SNSInvalidTopicFault(String),
    /// <p>You do not have permission to publish to the specified Amazon SNS topic.</p>
    SNSNoAuthorizationFault(String),
    /// <p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.</p>
    SNSTopicArnNotFoundFault(String),
    /// <p>The specified Amazon Redshift event source could not be found.</p>
    SourceNotFoundFault(String),
    /// <p>There is already an existing event notification subscription with the specified name.</p>
    SubscriptionAlreadyExistFault(String),
    /// <p>The value specified for the event category was not one of the allowed values, or it specified a category that does not apply to the specified source type. The allowed values are Configuration, Management, Monitoring, and Security.</p>
    SubscriptionCategoryNotFoundFault(String),
    /// <p>An Amazon Redshift event with the specified event ID does not exist.</p>
    SubscriptionEventIdNotFoundFault(String),
    /// <p>The value specified for the event severity was not one of the allowed values, or it specified a severity that does not apply to the specified source type. The allowed values are ERROR and INFO.</p>
    SubscriptionSeverityNotFoundFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateEventSubscriptionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateEventSubscriptionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "EventSubscriptionQuotaExceeded" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::EventSubscriptionQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateEventSubscriptionError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "SNSInvalidTopic" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SNSInvalidTopicFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SNSNoAuthorization" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SNSNoAuthorizationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SNSTopicArnNotFound" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SNSTopicArnNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SourceNotFound" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SourceNotFoundFault(parsed_error.message),
                        )
                    }
                    "SubscriptionAlreadyExist" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SubscriptionAlreadyExistFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionCategoryNotFound" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SubscriptionCategoryNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionEventIdNotFound" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SubscriptionEventIdNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionSeverityNotFound" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::SubscriptionSeverityNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateEventSubscriptionError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateEventSubscriptionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateEventSubscriptionError::EventSubscriptionQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateEventSubscriptionError::SNSInvalidTopicFault(ref cause) => write!(f, "{}", cause),
            CreateEventSubscriptionError::SNSNoAuthorizationFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::SNSTopicArnNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::SourceNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateEventSubscriptionError::SubscriptionAlreadyExistFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::SubscriptionCategoryNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::SubscriptionEventIdNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::SubscriptionSeverityNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateEventSubscriptionError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateEventSubscriptionError {}
/// Errors returned by CreateHsmClientCertificate
#[derive(Debug, PartialEq)]
pub enum CreateHsmClientCertificateError {
    /// <p>There is already an existing Amazon Redshift HSM client certificate with the specified identifier.</p>
    HsmClientCertificateAlreadyExistsFault(String),
    /// <p>The quota for HSM client certificates has been reached. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    HsmClientCertificateQuotaExceededFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateHsmClientCertificateError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<CreateHsmClientCertificateError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "HsmClientCertificateAlreadyExistsFault" => {
                        return RusotoError::Service(
                            CreateHsmClientCertificateError::HsmClientCertificateAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmClientCertificateQuotaExceededFault" => {
                        return RusotoError::Service(
                            CreateHsmClientCertificateError::HsmClientCertificateQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            CreateHsmClientCertificateError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateHsmClientCertificateError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateHsmClientCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateHsmClientCertificateError::HsmClientCertificateAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateHsmClientCertificateError::HsmClientCertificateQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateHsmClientCertificateError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateHsmClientCertificateError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateHsmClientCertificateError {}
/// Errors returned by CreateHsmConfiguration
#[derive(Debug, PartialEq)]
pub enum CreateHsmConfigurationError {
    /// <p>There is already an existing Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationAlreadyExistsFault(String),
    /// <p>The quota for HSM configurations has been reached. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    HsmConfigurationQuotaExceededFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateHsmConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateHsmConfigurationError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "HsmConfigurationAlreadyExistsFault" => {
                        return RusotoError::Service(
                            CreateHsmConfigurationError::HsmConfigurationAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmConfigurationQuotaExceededFault" => {
                        return RusotoError::Service(
                            CreateHsmConfigurationError::HsmConfigurationQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateHsmConfigurationError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateHsmConfigurationError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateHsmConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateHsmConfigurationError::HsmConfigurationAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateHsmConfigurationError::HsmConfigurationQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateHsmConfigurationError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateHsmConfigurationError::TagLimitExceededFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateHsmConfigurationError {}
/// Errors returned by CreateScheduledAction
#[derive(Debug, PartialEq)]
pub enum CreateScheduledActionError {
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(String),
    /// <p>The scheduled action is not valid. </p>
    InvalidScheduledActionFault(String),
    /// <p>The scheduled action already exists. </p>
    ScheduledActionAlreadyExistsFault(String),
    /// <p>The quota for scheduled actions exceeded. </p>
    ScheduledActionQuotaExceededFault(String),
    /// <p>The action type specified for a scheduled action is not supported. </p>
    ScheduledActionTypeUnsupportedFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl CreateScheduledActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateScheduledActionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSchedule" => {
                        return RusotoError::Service(
                            CreateScheduledActionError::InvalidScheduleFault(parsed_error.message),
                        )
                    }
                    "InvalidScheduledAction" => {
                        return RusotoError::Service(
                            CreateScheduledActionError::InvalidScheduledActionFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ScheduledActionAlreadyExists" => {
                        return RusotoError::Service(
                            CreateScheduledActionError::ScheduledActionAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ScheduledActionQuotaExceeded" => {
                        return RusotoError::Service(
                            CreateScheduledActionError::ScheduledActionQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ScheduledActionTypeUnsupported" => {
                        return RusotoError::Service(
                            CreateScheduledActionError::ScheduledActionTypeUnsupportedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            CreateScheduledActionError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateScheduledActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateScheduledActionError::InvalidScheduleFault(ref cause) => write!(f, "{}", cause),
            CreateScheduledActionError::InvalidScheduledActionFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateScheduledActionError::ScheduledActionAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateScheduledActionError::ScheduledActionQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateScheduledActionError::ScheduledActionTypeUnsupportedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateScheduledActionError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateScheduledActionError {}
/// Errors returned by CreateSnapshotCopyGrant
#[derive(Debug, PartialEq)]
pub enum CreateSnapshotCopyGrantError {
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>The snapshot copy grant can't be created because a grant with the same name already exists.</p>
    SnapshotCopyGrantAlreadyExistsFault(String),
    /// <p>The AWS account has exceeded the maximum number of snapshot copy grants in this region.</p>
    SnapshotCopyGrantQuotaExceededFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateSnapshotCopyGrantError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSnapshotCopyGrantError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            CreateSnapshotCopyGrantError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateSnapshotCopyGrantError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(
                            CreateSnapshotCopyGrantError::LimitExceededFault(parsed_error.message),
                        )
                    }
                    "SnapshotCopyGrantAlreadyExistsFault" => {
                        return RusotoError::Service(
                            CreateSnapshotCopyGrantError::SnapshotCopyGrantAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotCopyGrantQuotaExceededFault" => {
                        return RusotoError::Service(
                            CreateSnapshotCopyGrantError::SnapshotCopyGrantQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateSnapshotCopyGrantError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateSnapshotCopyGrantError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSnapshotCopyGrantError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSnapshotCopyGrantError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateSnapshotCopyGrantError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
            CreateSnapshotCopyGrantError::SnapshotCopyGrantAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSnapshotCopyGrantError::SnapshotCopyGrantQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSnapshotCopyGrantError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateSnapshotCopyGrantError {}
/// Errors returned by CreateSnapshotSchedule
#[derive(Debug, PartialEq)]
pub enum CreateSnapshotScheduleError {
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The definition you submitted is not supported.</p>
    ScheduleDefinitionTypeUnsupportedFault(String),
    /// <p>The specified snapshot schedule already exists. </p>
    SnapshotScheduleAlreadyExistsFault(String),
    /// <p>You have exceeded the quota of snapshot schedules. </p>
    SnapshotScheduleQuotaExceededFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateSnapshotScheduleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateSnapshotScheduleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSchedule" => {
                        return RusotoError::Service(
                            CreateSnapshotScheduleError::InvalidScheduleFault(parsed_error.message),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateSnapshotScheduleError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "ScheduleDefinitionTypeUnsupported" => {
                        return RusotoError::Service(
                            CreateSnapshotScheduleError::ScheduleDefinitionTypeUnsupportedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotScheduleAlreadyExists" => {
                        return RusotoError::Service(
                            CreateSnapshotScheduleError::SnapshotScheduleAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotScheduleQuotaExceeded" => {
                        return RusotoError::Service(
                            CreateSnapshotScheduleError::SnapshotScheduleQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            CreateSnapshotScheduleError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateSnapshotScheduleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateSnapshotScheduleError::InvalidScheduleFault(ref cause) => write!(f, "{}", cause),
            CreateSnapshotScheduleError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateSnapshotScheduleError::ScheduleDefinitionTypeUnsupportedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSnapshotScheduleError::SnapshotScheduleAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSnapshotScheduleError::SnapshotScheduleQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            CreateSnapshotScheduleError::TagLimitExceededFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateSnapshotScheduleError {}
/// Errors returned by CreateTags
#[derive(Debug, PartialEq)]
pub enum CreateTagsError {
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
}

impl CreateTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidClusterState" => {
                        return RusotoError::Service(CreateTagsError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(CreateTagsError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "ResourceNotFoundFault" => {
                        return RusotoError::Service(CreateTagsError::ResourceNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(CreateTagsError::TagLimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateTagsError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            CreateTagsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            CreateTagsError::ResourceNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateTagsError::TagLimitExceededFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for CreateTagsError {}
/// Errors returned by CreateUsageLimit
#[derive(Debug, PartialEq)]
pub enum CreateUsageLimitError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The usage limit is not valid.</p>
    InvalidUsageLimitFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
    /// <p>The usage limit already exists. </p>
    UsageLimitAlreadyExistsFault(String),
}

impl CreateUsageLimitError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<CreateUsageLimitError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(CreateUsageLimitError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            CreateUsageLimitError::InvalidClusterStateFault(parsed_error.message),
                        )
                    }
                    "InvalidUsageLimit" => {
                        return RusotoError::Service(CreateUsageLimitError::InvalidUsageLimitFault(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(CreateUsageLimitError::LimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(CreateUsageLimitError::TagLimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            CreateUsageLimitError::UnsupportedOperationFault(parsed_error.message),
                        )
                    }
                    "UsageLimitAlreadyExists" => {
                        return RusotoError::Service(
                            CreateUsageLimitError::UsageLimitAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for CreateUsageLimitError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            CreateUsageLimitError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            CreateUsageLimitError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            CreateUsageLimitError::InvalidUsageLimitFault(ref cause) => write!(f, "{}", cause),
            CreateUsageLimitError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
            CreateUsageLimitError::TagLimitExceededFault(ref cause) => write!(f, "{}", cause),
            CreateUsageLimitError::UnsupportedOperationFault(ref cause) => write!(f, "{}", cause),
            CreateUsageLimitError::UsageLimitAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for CreateUsageLimitError {}
/// Errors returned by DeleteCluster
#[derive(Debug, PartialEq)]
pub enum DeleteClusterError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The value specified as a snapshot identifier is already used by an existing snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(String),
    /// <p>The request would result in the user exceeding the allowed number of cluster snapshots.</p>
    ClusterSnapshotQuotaExceededFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
}

impl DeleteClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(DeleteClusterError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "ClusterSnapshotAlreadyExists" => {
                        return RusotoError::Service(
                            DeleteClusterError::ClusterSnapshotAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotQuotaExceeded" => {
                        return RusotoError::Service(
                            DeleteClusterError::ClusterSnapshotQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(DeleteClusterError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            DeleteClusterError::InvalidRetentionPeriodFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteClusterError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DeleteClusterError::ClusterSnapshotAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterError::ClusterSnapshotQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            DeleteClusterError::InvalidRetentionPeriodFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteClusterError {}
/// Errors returned by DeleteClusterParameterGroup
#[derive(Debug, PartialEq)]
pub enum DeleteClusterParameterGroupError {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The cluster parameter group action can not be completed because another task is in progress that involves the parameter group. Wait a few moments and try the operation again.</p>
    InvalidClusterParameterGroupStateFault(String),
}

impl DeleteClusterParameterGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteClusterParameterGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            DeleteClusterParameterGroupError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterParameterGroupState" => return RusotoError::Service(
                        DeleteClusterParameterGroupError::InvalidClusterParameterGroupStateFault(
                            parsed_error.message,
                        ),
                    ),
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteClusterParameterGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteClusterParameterGroupError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterParameterGroupError::InvalidClusterParameterGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteClusterParameterGroupError {}
/// Errors returned by DeleteClusterSecurityGroup
#[derive(Debug, PartialEq)]
pub enum DeleteClusterSecurityGroupError {
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
}

impl DeleteClusterSecurityGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteClusterSecurityGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSecurityGroupNotFound" => {
                        return RusotoError::Service(
                            DeleteClusterSecurityGroupError::ClusterSecurityGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSecurityGroupState" => {
                        return RusotoError::Service(
                            DeleteClusterSecurityGroupError::InvalidClusterSecurityGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteClusterSecurityGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteClusterSecurityGroupError::ClusterSecurityGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterSecurityGroupError::InvalidClusterSecurityGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteClusterSecurityGroupError {}
/// Errors returned by DeleteClusterSnapshot
#[derive(Debug, PartialEq)]
pub enum DeleteClusterSnapshotError {
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
}

impl DeleteClusterSnapshotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteClusterSnapshotError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            DeleteClusterSnapshotError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSnapshotState" => {
                        return RusotoError::Service(
                            DeleteClusterSnapshotError::InvalidClusterSnapshotStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteClusterSnapshotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteClusterSnapshotError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterSnapshotError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteClusterSnapshotError {}
/// Errors returned by DeleteClusterSubnetGroup
#[derive(Debug, PartialEq)]
pub enum DeleteClusterSubnetGroupError {
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>
    ClusterSubnetGroupNotFoundFault(String),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(String),
    /// <p>The state of the subnet is invalid.</p>
    InvalidClusterSubnetStateFault(String),
}

impl DeleteClusterSubnetGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteClusterSubnetGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSubnetGroupNotFoundFault" => {
                        return RusotoError::Service(
                            DeleteClusterSubnetGroupError::ClusterSubnetGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSubnetGroupStateFault" => {
                        return RusotoError::Service(
                            DeleteClusterSubnetGroupError::InvalidClusterSubnetGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSubnetStateFault" => {
                        return RusotoError::Service(
                            DeleteClusterSubnetGroupError::InvalidClusterSubnetStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteClusterSubnetGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteClusterSubnetGroupError::ClusterSubnetGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterSubnetGroupError::InvalidClusterSubnetGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteClusterSubnetGroupError::InvalidClusterSubnetStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteClusterSubnetGroupError {}
/// Errors returned by DeleteEndpointAccess
#[derive(Debug, PartialEq)]
pub enum DeleteEndpointAccessError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(String),
}

impl DeleteEndpointAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteEndpointAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DeleteEndpointAccessError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "EndpointNotFound" => {
                        return RusotoError::Service(
                            DeleteEndpointAccessError::EndpointNotFoundFault(parsed_error.message),
                        )
                    }
                    "InvalidClusterSecurityGroupState" => {
                        return RusotoError::Service(
                            DeleteEndpointAccessError::InvalidClusterSecurityGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            DeleteEndpointAccessError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidEndpointState" => {
                        return RusotoError::Service(
                            DeleteEndpointAccessError::InvalidEndpointStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteEndpointAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteEndpointAccessError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DeleteEndpointAccessError::EndpointNotFoundFault(ref cause) => write!(f, "{}", cause),
            DeleteEndpointAccessError::InvalidClusterSecurityGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteEndpointAccessError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteEndpointAccessError::InvalidEndpointStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteEndpointAccessError {}
/// Errors returned by DeleteEventSubscription
#[derive(Debug, PartialEq)]
pub enum DeleteEventSubscriptionError {
    /// <p>The subscription request is invalid because it is a duplicate request. This subscription request is already in progress.</p>
    InvalidSubscriptionStateFault(String),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not exist.</p>
    SubscriptionNotFoundFault(String),
}

impl DeleteEventSubscriptionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteEventSubscriptionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSubscriptionStateFault" => {
                        return RusotoError::Service(
                            DeleteEventSubscriptionError::InvalidSubscriptionStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionNotFound" => {
                        return RusotoError::Service(
                            DeleteEventSubscriptionError::SubscriptionNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteEventSubscriptionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteEventSubscriptionError::InvalidSubscriptionStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteEventSubscriptionError::SubscriptionNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteEventSubscriptionError {}
/// Errors returned by DeleteHsmClientCertificate
#[derive(Debug, PartialEq)]
pub enum DeleteHsmClientCertificateError {
    /// <p>There is no Amazon Redshift HSM client certificate with the specified identifier.</p>
    HsmClientCertificateNotFoundFault(String),
    /// <p>The specified HSM client certificate is not in the <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</p>
    InvalidHsmClientCertificateStateFault(String),
}

impl DeleteHsmClientCertificateError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DeleteHsmClientCertificateError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "HsmClientCertificateNotFoundFault" => {
                        return RusotoError::Service(
                            DeleteHsmClientCertificateError::HsmClientCertificateNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidHsmClientCertificateStateFault" => {
                        return RusotoError::Service(
                            DeleteHsmClientCertificateError::InvalidHsmClientCertificateStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteHsmClientCertificateError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteHsmClientCertificateError::HsmClientCertificateNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteHsmClientCertificateError::InvalidHsmClientCertificateStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteHsmClientCertificateError {}
/// Errors returned by DeleteHsmConfiguration
#[derive(Debug, PartialEq)]
pub enum DeleteHsmConfigurationError {
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(String),
    /// <p>The specified HSM configuration is not in the <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</p>
    InvalidHsmConfigurationStateFault(String),
}

impl DeleteHsmConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteHsmConfigurationError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "HsmConfigurationNotFoundFault" => {
                        return RusotoError::Service(
                            DeleteHsmConfigurationError::HsmConfigurationNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidHsmConfigurationStateFault" => {
                        return RusotoError::Service(
                            DeleteHsmConfigurationError::InvalidHsmConfigurationStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteHsmConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteHsmConfigurationError::HsmConfigurationNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteHsmConfigurationError::InvalidHsmConfigurationStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteHsmConfigurationError {}
/// Errors returned by DeletePartner
#[derive(Debug, PartialEq)]
pub enum DeletePartnerError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(String),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(String),
}

impl DeletePartnerError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeletePartnerError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(DeletePartnerError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "PartnerNotFound" => {
                        return RusotoError::Service(DeletePartnerError::PartnerNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "UnauthorizedPartnerIntegration" => {
                        return RusotoError::Service(
                            DeletePartnerError::UnauthorizedPartnerIntegrationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeletePartnerError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeletePartnerError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DeletePartnerError::PartnerNotFoundFault(ref cause) => write!(f, "{}", cause),
            DeletePartnerError::UnauthorizedPartnerIntegrationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeletePartnerError {}
/// Errors returned by DeleteScheduledAction
#[derive(Debug, PartialEq)]
pub enum DeleteScheduledActionError {
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl DeleteScheduledActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteScheduledActionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ScheduledActionNotFound" => {
                        return RusotoError::Service(
                            DeleteScheduledActionError::ScheduledActionNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            DeleteScheduledActionError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteScheduledActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteScheduledActionError::ScheduledActionNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteScheduledActionError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteScheduledActionError {}
/// Errors returned by DeleteSnapshotCopyGrant
#[derive(Debug, PartialEq)]
pub enum DeleteSnapshotCopyGrantError {
    /// <p>The snapshot copy grant can't be deleted because it is used by one or more clusters.</p>
    InvalidSnapshotCopyGrantStateFault(String),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(String),
}

impl DeleteSnapshotCopyGrantError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSnapshotCopyGrantError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSnapshotCopyGrantStateFault" => {
                        return RusotoError::Service(
                            DeleteSnapshotCopyGrantError::InvalidSnapshotCopyGrantStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotCopyGrantNotFoundFault" => {
                        return RusotoError::Service(
                            DeleteSnapshotCopyGrantError::SnapshotCopyGrantNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteSnapshotCopyGrantError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSnapshotCopyGrantError::InvalidSnapshotCopyGrantStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteSnapshotCopyGrantError::SnapshotCopyGrantNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteSnapshotCopyGrantError {}
/// Errors returned by DeleteSnapshotSchedule
#[derive(Debug, PartialEq)]
pub enum DeleteSnapshotScheduleError {
    /// <p>The cluster snapshot schedule state is not valid.</p>
    InvalidClusterSnapshotScheduleStateFault(String),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(String),
}

impl DeleteSnapshotScheduleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteSnapshotScheduleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidClusterSnapshotScheduleState" => {
                        return RusotoError::Service(
                            DeleteSnapshotScheduleError::InvalidClusterSnapshotScheduleStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotScheduleNotFound" => {
                        return RusotoError::Service(
                            DeleteSnapshotScheduleError::SnapshotScheduleNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteSnapshotScheduleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteSnapshotScheduleError::InvalidClusterSnapshotScheduleStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DeleteSnapshotScheduleError::SnapshotScheduleNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DeleteSnapshotScheduleError {}
/// Errors returned by DeleteTags
#[derive(Debug, PartialEq)]
pub enum DeleteTagsError {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(String),
}

impl DeleteTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidTagFault" => {
                        return RusotoError::Service(DeleteTagsError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "ResourceNotFoundFault" => {
                        return RusotoError::Service(DeleteTagsError::ResourceNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteTagsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            DeleteTagsError::ResourceNotFoundFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteTagsError {}
/// Errors returned by DeleteUsageLimit
#[derive(Debug, PartialEq)]
pub enum DeleteUsageLimitError {
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
    /// <p>The usage limit identifier can't be found.</p>
    UsageLimitNotFoundFault(String),
}

impl DeleteUsageLimitError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DeleteUsageLimitError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            DeleteUsageLimitError::UnsupportedOperationFault(parsed_error.message),
                        )
                    }
                    "UsageLimitNotFound" => {
                        return RusotoError::Service(
                            DeleteUsageLimitError::UsageLimitNotFoundFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DeleteUsageLimitError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DeleteUsageLimitError::UnsupportedOperationFault(ref cause) => write!(f, "{}", cause),
            DeleteUsageLimitError::UsageLimitNotFoundFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DeleteUsageLimitError {}
/// Errors returned by DescribeAccountAttributes
#[derive(Debug, PartialEq)]
pub enum DescribeAccountAttributesError {}

impl DescribeAccountAttributesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeAccountAttributesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeAccountAttributesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeAccountAttributesError {}
/// Errors returned by DescribeClusterDbRevisions
#[derive(Debug, PartialEq)]
pub enum DescribeClusterDbRevisionsError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl DescribeClusterDbRevisionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeClusterDbRevisionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeClusterDbRevisionsError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            DescribeClusterDbRevisionsError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterDbRevisionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterDbRevisionsError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterDbRevisionsError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeClusterDbRevisionsError {}
/// Errors returned by DescribeClusterParameterGroups
#[derive(Debug, PartialEq)]
pub enum DescribeClusterParameterGroupsError {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeClusterParameterGroupsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeClusterParameterGroupsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            DescribeClusterParameterGroupsError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeClusterParameterGroupsError::InvalidTagFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterParameterGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterParameterGroupsError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterParameterGroupsError::InvalidTagFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeClusterParameterGroupsError {}
/// Errors returned by DescribeClusterParameters
#[derive(Debug, PartialEq)]
pub enum DescribeClusterParametersError {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
}

impl DescribeClusterParametersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeClusterParametersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            DescribeClusterParametersError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterParametersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterParametersError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeClusterParametersError {}
/// Errors returned by DescribeClusterSecurityGroups
#[derive(Debug, PartialEq)]
pub enum DescribeClusterSecurityGroupsError {
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeClusterSecurityGroupsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeClusterSecurityGroupsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSecurityGroupNotFound" => {
                        return RusotoError::Service(
                            DescribeClusterSecurityGroupsError::ClusterSecurityGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeClusterSecurityGroupsError::InvalidTagFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterSecurityGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterSecurityGroupsError::ClusterSecurityGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterSecurityGroupsError::InvalidTagFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeClusterSecurityGroupsError {}
/// Errors returned by DescribeClusterSnapshots
#[derive(Debug, PartialEq)]
pub enum DescribeClusterSnapshotsError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeClusterSnapshotsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeClusterSnapshotsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeClusterSnapshotsError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            DescribeClusterSnapshotsError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeClusterSnapshotsError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterSnapshotsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterSnapshotsError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterSnapshotsError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterSnapshotsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeClusterSnapshotsError {}
/// Errors returned by DescribeClusterSubnetGroups
#[derive(Debug, PartialEq)]
pub enum DescribeClusterSubnetGroupsError {
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>
    ClusterSubnetGroupNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeClusterSubnetGroupsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeClusterSubnetGroupsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSubnetGroupNotFoundFault" => {
                        return RusotoError::Service(
                            DescribeClusterSubnetGroupsError::ClusterSubnetGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeClusterSubnetGroupsError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterSubnetGroupsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterSubnetGroupsError::ClusterSubnetGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterSubnetGroupsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeClusterSubnetGroupsError {}
/// Errors returned by DescribeClusterTracks
#[derive(Debug, PartialEq)]
pub enum DescribeClusterTracksError {
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl DescribeClusterTracksError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeClusterTracksError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidClusterTrack" => {
                        return RusotoError::Service(
                            DescribeClusterTracksError::InvalidClusterTrackFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            DescribeClusterTracksError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterTracksError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClusterTracksError::InvalidClusterTrackFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeClusterTracksError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeClusterTracksError {}
/// Errors returned by DescribeClusterVersions
#[derive(Debug, PartialEq)]
pub enum DescribeClusterVersionsError {}

impl DescribeClusterVersionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeClusterVersionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClusterVersionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeClusterVersionsError {}
/// Errors returned by DescribeClusters
#[derive(Debug, PartialEq)]
pub enum DescribeClustersError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeClustersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeClustersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(DescribeClustersError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(DescribeClustersError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeClustersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeClustersError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DescribeClustersError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeClustersError {}
/// Errors returned by DescribeDefaultClusterParameters
#[derive(Debug, PartialEq)]
pub enum DescribeDefaultClusterParametersError {}

impl DescribeDefaultClusterParametersError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeDefaultClusterParametersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeDefaultClusterParametersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeDefaultClusterParametersError {}
/// Errors returned by DescribeEndpointAccess
#[derive(Debug, PartialEq)]
pub enum DescribeEndpointAccessError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl DescribeEndpointAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeEndpointAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeEndpointAccessError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "EndpointNotFound" => {
                        return RusotoError::Service(
                            DescribeEndpointAccessError::EndpointNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            DescribeEndpointAccessError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeEndpointAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeEndpointAccessError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DescribeEndpointAccessError::EndpointNotFoundFault(ref cause) => write!(f, "{}", cause),
            DescribeEndpointAccessError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeEndpointAccessError {}
/// Errors returned by DescribeEndpointAuthorization
#[derive(Debug, PartialEq)]
pub enum DescribeEndpointAuthorizationError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl DescribeEndpointAuthorizationError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeEndpointAuthorizationError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeEndpointAuthorizationError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            DescribeEndpointAuthorizationError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeEndpointAuthorizationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeEndpointAuthorizationError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeEndpointAuthorizationError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeEndpointAuthorizationError {}
/// Errors returned by DescribeEventCategories
#[derive(Debug, PartialEq)]
pub enum DescribeEventCategoriesError {}

impl DescribeEventCategoriesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeEventCategoriesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeEventCategoriesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeEventCategoriesError {}
/// Errors returned by DescribeEventSubscriptions
#[derive(Debug, PartialEq)]
pub enum DescribeEventSubscriptionsError {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not exist.</p>
    SubscriptionNotFoundFault(String),
}

impl DescribeEventSubscriptionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeEventSubscriptionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeEventSubscriptionsError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "SubscriptionNotFound" => {
                        return RusotoError::Service(
                            DescribeEventSubscriptionsError::SubscriptionNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeEventSubscriptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeEventSubscriptionsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            DescribeEventSubscriptionsError::SubscriptionNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeEventSubscriptionsError {}
/// Errors returned by DescribeEvents
#[derive(Debug, PartialEq)]
pub enum DescribeEventsError {}

impl DescribeEventsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeEventsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeEventsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeEventsError {}
/// Errors returned by DescribeHsmClientCertificates
#[derive(Debug, PartialEq)]
pub enum DescribeHsmClientCertificatesError {
    /// <p>There is no Amazon Redshift HSM client certificate with the specified identifier.</p>
    HsmClientCertificateNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeHsmClientCertificatesError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeHsmClientCertificatesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "HsmClientCertificateNotFoundFault" => {
                        return RusotoError::Service(
                            DescribeHsmClientCertificatesError::HsmClientCertificateNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeHsmClientCertificatesError::InvalidTagFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeHsmClientCertificatesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeHsmClientCertificatesError::HsmClientCertificateNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeHsmClientCertificatesError::InvalidTagFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeHsmClientCertificatesError {}
/// Errors returned by DescribeHsmConfigurations
#[derive(Debug, PartialEq)]
pub enum DescribeHsmConfigurationsError {
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
}

impl DescribeHsmConfigurationsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeHsmConfigurationsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "HsmConfigurationNotFoundFault" => {
                        return RusotoError::Service(
                            DescribeHsmConfigurationsError::HsmConfigurationNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeHsmConfigurationsError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeHsmConfigurationsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeHsmConfigurationsError::HsmConfigurationNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeHsmConfigurationsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeHsmConfigurationsError {}
/// Errors returned by DescribeLoggingStatus
#[derive(Debug, PartialEq)]
pub enum DescribeLoggingStatusError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
}

impl DescribeLoggingStatusError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeLoggingStatusError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeLoggingStatusError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeLoggingStatusError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeLoggingStatusError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeLoggingStatusError {}
/// Errors returned by DescribeNodeConfigurationOptions
#[derive(Debug, PartialEq)]
pub enum DescribeNodeConfigurationOptionsError {
    /// <p>The owner of the specified snapshot has not authorized your account to access the snapshot.</p>
    AccessToSnapshotDeniedFault(String),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
}

impl DescribeNodeConfigurationOptionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeNodeConfigurationOptionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "AccessToSnapshotDenied" => {
                        return RusotoError::Service(
                            DescribeNodeConfigurationOptionsError::AccessToSnapshotDeniedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeNodeConfigurationOptionsError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            DescribeNodeConfigurationOptionsError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSnapshotState" => {
                        return RusotoError::Service(
                            DescribeNodeConfigurationOptionsError::InvalidClusterSnapshotStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeNodeConfigurationOptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeNodeConfigurationOptionsError::AccessToSnapshotDeniedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeNodeConfigurationOptionsError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeNodeConfigurationOptionsError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeNodeConfigurationOptionsError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeNodeConfigurationOptionsError {}
/// Errors returned by DescribeOrderableClusterOptions
#[derive(Debug, PartialEq)]
pub enum DescribeOrderableClusterOptionsError {}

impl DescribeOrderableClusterOptionsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeOrderableClusterOptionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeOrderableClusterOptionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeOrderableClusterOptionsError {}
/// Errors returned by DescribePartners
#[derive(Debug, PartialEq)]
pub enum DescribePartnersError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(String),
}

impl DescribePartnersError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribePartnersError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(DescribePartnersError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "UnauthorizedPartnerIntegration" => {
                        return RusotoError::Service(
                            DescribePartnersError::UnauthorizedPartnerIntegrationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribePartnersError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribePartnersError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DescribePartnersError::UnauthorizedPartnerIntegrationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribePartnersError {}
/// Errors returned by DescribeReservedNodeOfferings
#[derive(Debug, PartialEq)]
pub enum DescribeReservedNodeOfferingsError {
    /// <p>Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(String),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl DescribeReservedNodeOfferingsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeReservedNodeOfferingsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DependentServiceUnavailableFault" => {
                        return RusotoError::Service(
                            DescribeReservedNodeOfferingsError::DependentServiceUnavailableFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeOfferingNotFound" => {
                        return RusotoError::Service(
                            DescribeReservedNodeOfferingsError::ReservedNodeOfferingNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            DescribeReservedNodeOfferingsError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeReservedNodeOfferingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeReservedNodeOfferingsError::DependentServiceUnavailableFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeReservedNodeOfferingsError::ReservedNodeOfferingNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeReservedNodeOfferingsError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeReservedNodeOfferingsError {}
/// Errors returned by DescribeReservedNodes
#[derive(Debug, PartialEq)]
pub enum DescribeReservedNodesError {
    /// <p>Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(String),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(String),
}

impl DescribeReservedNodesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeReservedNodesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DependentServiceUnavailableFault" => {
                        return RusotoError::Service(
                            DescribeReservedNodesError::DependentServiceUnavailableFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeNotFound" => {
                        return RusotoError::Service(
                            DescribeReservedNodesError::ReservedNodeNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeReservedNodesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeReservedNodesError::DependentServiceUnavailableFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeReservedNodesError::ReservedNodeNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeReservedNodesError {}
/// Errors returned by DescribeResize
#[derive(Debug, PartialEq)]
pub enum DescribeResizeError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>A resize operation for the specified cluster is not found.</p>
    ResizeNotFoundFault(String),
}

impl DescribeResizeError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeResizeError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(DescribeResizeError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "ResizeNotFound" => {
                        return RusotoError::Service(DescribeResizeError::ResizeNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeResizeError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeResizeError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DescribeResizeError::ResizeNotFoundFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeResizeError {}
/// Errors returned by DescribeScheduledActions
#[derive(Debug, PartialEq)]
pub enum DescribeScheduledActionsError {
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl DescribeScheduledActionsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeScheduledActionsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ScheduledActionNotFound" => {
                        return RusotoError::Service(
                            DescribeScheduledActionsError::ScheduledActionNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            DescribeScheduledActionsError::UnauthorizedOperation(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeScheduledActionsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeScheduledActionsError::ScheduledActionNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeScheduledActionsError::UnauthorizedOperation(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeScheduledActionsError {}
/// Errors returned by DescribeSnapshotCopyGrants
#[derive(Debug, PartialEq)]
pub enum DescribeSnapshotCopyGrantsError {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(String),
}

impl DescribeSnapshotCopyGrantsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeSnapshotCopyGrantsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            DescribeSnapshotCopyGrantsError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "SnapshotCopyGrantNotFoundFault" => {
                        return RusotoError::Service(
                            DescribeSnapshotCopyGrantsError::SnapshotCopyGrantNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeSnapshotCopyGrantsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeSnapshotCopyGrantsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            DescribeSnapshotCopyGrantsError::SnapshotCopyGrantNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeSnapshotCopyGrantsError {}
/// Errors returned by DescribeSnapshotSchedules
#[derive(Debug, PartialEq)]
pub enum DescribeSnapshotSchedulesError {}

impl DescribeSnapshotSchedulesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeSnapshotSchedulesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeSnapshotSchedulesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeSnapshotSchedulesError {}
/// Errors returned by DescribeStorage
#[derive(Debug, PartialEq)]
pub enum DescribeStorageError {}

impl DescribeStorageError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeStorageError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeStorageError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {}
    }
}
impl Error for DescribeStorageError {}
/// Errors returned by DescribeTableRestoreStatus
#[derive(Debug, PartialEq)]
pub enum DescribeTableRestoreStatusError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified <code>TableRestoreRequestId</code> value was not found.</p>
    TableRestoreNotFoundFault(String),
}

impl DescribeTableRestoreStatusError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<DescribeTableRestoreStatusError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeTableRestoreStatusError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "TableRestoreNotFoundFault" => {
                        return RusotoError::Service(
                            DescribeTableRestoreStatusError::TableRestoreNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeTableRestoreStatusError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeTableRestoreStatusError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DescribeTableRestoreStatusError::TableRestoreNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeTableRestoreStatusError {}
/// Errors returned by DescribeTags
#[derive(Debug, PartialEq)]
pub enum DescribeTagsError {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(String),
}

impl DescribeTagsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeTagsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidTagFault" => {
                        return RusotoError::Service(DescribeTagsError::InvalidTagFault(
                            parsed_error.message,
                        ))
                    }
                    "ResourceNotFoundFault" => {
                        return RusotoError::Service(DescribeTagsError::ResourceNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeTagsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeTagsError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            DescribeTagsError::ResourceNotFoundFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DescribeTagsError {}
/// Errors returned by DescribeUsageLimits
#[derive(Debug, PartialEq)]
pub enum DescribeUsageLimitsError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl DescribeUsageLimitsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DescribeUsageLimitsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DescribeUsageLimitsError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            DescribeUsageLimitsError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DescribeUsageLimitsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DescribeUsageLimitsError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DescribeUsageLimitsError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for DescribeUsageLimitsError {}
/// Errors returned by DisableLogging
#[derive(Debug, PartialEq)]
pub enum DisableLoggingError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl DisableLoggingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DisableLoggingError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(DisableLoggingError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(DisableLoggingError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DisableLoggingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisableLoggingError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DisableLoggingError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DisableLoggingError {}
/// Errors returned by DisableSnapshotCopy
#[derive(Debug, PartialEq)]
pub enum DisableSnapshotCopyError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The cluster already has cross-region snapshot copy disabled.</p>
    SnapshotCopyAlreadyDisabledFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl DisableSnapshotCopyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<DisableSnapshotCopyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            DisableSnapshotCopyError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            DisableSnapshotCopyError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotCopyAlreadyDisabledFault" => {
                        return RusotoError::Service(
                            DisableSnapshotCopyError::SnapshotCopyAlreadyDisabledFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            DisableSnapshotCopyError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for DisableSnapshotCopyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            DisableSnapshotCopyError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            DisableSnapshotCopyError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            DisableSnapshotCopyError::SnapshotCopyAlreadyDisabledFault(ref cause) => {
                write!(f, "{}", cause)
            }
            DisableSnapshotCopyError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for DisableSnapshotCopyError {}
/// Errors returned by EnableLogging
#[derive(Debug, PartialEq)]
pub enum EnableLoggingError {
    /// <p>Could not find the specified S3 bucket.</p>
    BucketNotFoundFault(String),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The cluster does not have read bucket or put object permissions on the S3 bucket specified when enabling logging.</p>
    InsufficientS3BucketPolicyFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The S3 bucket name is invalid. For more information about naming rules, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.</p>
    InvalidS3BucketNameFault(String),
    /// <p>The string specified for the logging S3 key prefix does not comply with the documented constraints.</p>
    InvalidS3KeyPrefixFault(String),
}

impl EnableLoggingError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<EnableLoggingError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "BucketNotFoundFault" => {
                        return RusotoError::Service(EnableLoggingError::BucketNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "ClusterNotFound" => {
                        return RusotoError::Service(EnableLoggingError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InsufficientS3BucketPolicyFault" => {
                        return RusotoError::Service(
                            EnableLoggingError::InsufficientS3BucketPolicyFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(EnableLoggingError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidS3BucketNameFault" => {
                        return RusotoError::Service(EnableLoggingError::InvalidS3BucketNameFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidS3KeyPrefixFault" => {
                        return RusotoError::Service(EnableLoggingError::InvalidS3KeyPrefixFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for EnableLoggingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            EnableLoggingError::BucketNotFoundFault(ref cause) => write!(f, "{}", cause),
            EnableLoggingError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            EnableLoggingError::InsufficientS3BucketPolicyFault(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableLoggingError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            EnableLoggingError::InvalidS3BucketNameFault(ref cause) => write!(f, "{}", cause),
            EnableLoggingError::InvalidS3KeyPrefixFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for EnableLoggingError {}
/// Errors returned by EnableSnapshotCopy
#[derive(Debug, PartialEq)]
pub enum EnableSnapshotCopyError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>Cross-region snapshot copy was temporarily disabled. Try your request again.</p>
    CopyToRegionDisabledFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>The specified options are incompatible.</p>
    IncompatibleOrderableOptions(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>The cluster already has cross-region snapshot copy enabled.</p>
    SnapshotCopyAlreadyEnabledFault(String),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
    /// <p>The specified region is incorrect or does not exist.</p>
    UnknownSnapshotCopyRegionFault(String),
}

impl EnableSnapshotCopyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<EnableSnapshotCopyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(EnableSnapshotCopyError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "CopyToRegionDisabledFault" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::CopyToRegionDisabledFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "IncompatibleOrderableOptions" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::IncompatibleOrderableOptions(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::InvalidClusterStateFault(parsed_error.message),
                        )
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::InvalidRetentionPeriodFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(EnableSnapshotCopyError::LimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "SnapshotCopyAlreadyEnabledFault" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::SnapshotCopyAlreadyEnabledFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotCopyGrantNotFoundFault" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::SnapshotCopyGrantNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    "UnknownSnapshotCopyRegionFault" => {
                        return RusotoError::Service(
                            EnableSnapshotCopyError::UnknownSnapshotCopyRegionFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for EnableSnapshotCopyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            EnableSnapshotCopyError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            EnableSnapshotCopyError::CopyToRegionDisabledFault(ref cause) => write!(f, "{}", cause),
            EnableSnapshotCopyError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableSnapshotCopyError::IncompatibleOrderableOptions(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableSnapshotCopyError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            EnableSnapshotCopyError::InvalidRetentionPeriodFault(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableSnapshotCopyError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
            EnableSnapshotCopyError::SnapshotCopyAlreadyEnabledFault(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableSnapshotCopyError::SnapshotCopyGrantNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            EnableSnapshotCopyError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
            EnableSnapshotCopyError::UnknownSnapshotCopyRegionFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for EnableSnapshotCopyError {}
/// Errors returned by GetClusterCredentials
#[derive(Debug, PartialEq)]
pub enum GetClusterCredentialsError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl GetClusterCredentialsError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<GetClusterCredentialsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            GetClusterCredentialsError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            GetClusterCredentialsError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetClusterCredentialsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetClusterCredentialsError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            GetClusterCredentialsError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetClusterCredentialsError {}
/// Errors returned by GetReservedNodeExchangeOfferings
#[derive(Debug, PartialEq)]
pub enum GetReservedNodeExchangeOfferingsError {
    /// <p>Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(String),
    /// <p>Indicates that the Reserved Node being exchanged is not in an active state.</p>
    InvalidReservedNodeStateFault(String),
    /// <p>Indicates that the reserved node has already been exchanged.</p>
    ReservedNodeAlreadyMigratedFault(String),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(String),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl GetReservedNodeExchangeOfferingsError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<GetReservedNodeExchangeOfferingsError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "DependentServiceUnavailableFault" => {
                        return RusotoError::Service(
                            GetReservedNodeExchangeOfferingsError::DependentServiceUnavailableFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidReservedNodeState" => {
                        return RusotoError::Service(
                            GetReservedNodeExchangeOfferingsError::InvalidReservedNodeStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeAlreadyMigrated" => {
                        return RusotoError::Service(
                            GetReservedNodeExchangeOfferingsError::ReservedNodeAlreadyMigratedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeNotFound" => {
                        return RusotoError::Service(
                            GetReservedNodeExchangeOfferingsError::ReservedNodeNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeOfferingNotFound" => return RusotoError::Service(
                        GetReservedNodeExchangeOfferingsError::ReservedNodeOfferingNotFoundFault(
                            parsed_error.message,
                        ),
                    ),
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            GetReservedNodeExchangeOfferingsError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for GetReservedNodeExchangeOfferingsError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            GetReservedNodeExchangeOfferingsError::DependentServiceUnavailableFault(ref cause) => {
                write!(f, "{}", cause)
            }
            GetReservedNodeExchangeOfferingsError::InvalidReservedNodeStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            GetReservedNodeExchangeOfferingsError::ReservedNodeAlreadyMigratedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            GetReservedNodeExchangeOfferingsError::ReservedNodeNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            GetReservedNodeExchangeOfferingsError::ReservedNodeOfferingNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            GetReservedNodeExchangeOfferingsError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for GetReservedNodeExchangeOfferingsError {}
/// Errors returned by ModifyAquaConfiguration
#[derive(Debug, PartialEq)]
pub enum ModifyAquaConfigurationError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl ModifyAquaConfigurationError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyAquaConfigurationError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            ModifyAquaConfigurationError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            ModifyAquaConfigurationError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            ModifyAquaConfigurationError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyAquaConfigurationError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyAquaConfigurationError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyAquaConfigurationError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyAquaConfigurationError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyAquaConfigurationError {}
/// Errors returned by ModifyCluster
#[derive(Debug, PartialEq)]
pub enum ModifyClusterError {
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(String),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified identifier.</p>
    HsmClientCertificateNotFoundFault(String),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(String),
    /// <p>The number of nodes specified exceeds the allotted capacity of the cluster.</p>
    InsufficientClusterCapacityFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(String),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allotted to the account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    NumberOfNodesQuotaExceededFault(String),
    /// <p>The number of tables in the cluster exceeds the limit for the requested new cluster node type. </p>
    TableLimitExceededFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
    /// <p>A request option was specified that is not supported.</p>
    UnsupportedOptionFault(String),
}

impl ModifyClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterAlreadyExists" => {
                        return RusotoError::Service(ModifyClusterError::ClusterAlreadyExistsFault(
                            parsed_error.message,
                        ))
                    }
                    "ClusterNotFound" => {
                        return RusotoError::Service(ModifyClusterError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSecurityGroupNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterError::ClusterSecurityGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            ModifyClusterError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmClientCertificateNotFoundFault" => {
                        return RusotoError::Service(
                            ModifyClusterError::HsmClientCertificateNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmConfigurationNotFoundFault" => {
                        return RusotoError::Service(
                            ModifyClusterError::HsmConfigurationNotFoundFault(parsed_error.message),
                        )
                    }
                    "InsufficientClusterCapacity" => {
                        return RusotoError::Service(
                            ModifyClusterError::InsufficientClusterCapacityFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSecurityGroupState" => {
                        return RusotoError::Service(
                            ModifyClusterError::InvalidClusterSecurityGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(ModifyClusterError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidClusterTrack" => {
                        return RusotoError::Service(ModifyClusterError::InvalidClusterTrackFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidElasticIpFault" => {
                        return RusotoError::Service(ModifyClusterError::InvalidElasticIpFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            ModifyClusterError::InvalidRetentionPeriodFault(parsed_error.message),
                        )
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(ModifyClusterError::LimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "NumberOfNodesPerClusterLimitExceeded" => {
                        return RusotoError::Service(
                            ModifyClusterError::NumberOfNodesPerClusterLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NumberOfNodesQuotaExceeded" => {
                        return RusotoError::Service(
                            ModifyClusterError::NumberOfNodesQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "TableLimitExceeded" => {
                        return RusotoError::Service(ModifyClusterError::TableLimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(ModifyClusterError::UnauthorizedOperation(
                            parsed_error.message,
                        ))
                    }
                    "UnsupportedOptionFault" => {
                        return RusotoError::Service(ModifyClusterError::UnsupportedOptionFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterError::ClusterAlreadyExistsFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::ClusterSecurityGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::HsmClientCertificateNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::HsmConfigurationNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::InsufficientClusterCapacityFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::InvalidClusterSecurityGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::InvalidClusterTrackFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::InvalidElasticIpFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::InvalidRetentionPeriodFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::NumberOfNodesPerClusterLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::NumberOfNodesQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterError::TableLimitExceededFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
            ModifyClusterError::UnsupportedOptionFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ModifyClusterError {}
/// Errors returned by ModifyClusterDbRevision
#[derive(Debug, PartialEq)]
pub enum ModifyClusterDbRevisionError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>Cluster is already on the latest database revision.</p>
    ClusterOnLatestRevisionFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl ModifyClusterDbRevisionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyClusterDbRevisionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterDbRevisionError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterOnLatestRevision" => {
                        return RusotoError::Service(
                            ModifyClusterDbRevisionError::ClusterOnLatestRevisionFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            ModifyClusterDbRevisionError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterDbRevisionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterDbRevisionError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterDbRevisionError::ClusterOnLatestRevisionFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterDbRevisionError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterDbRevisionError {}
/// Errors returned by ModifyClusterIamRoles
#[derive(Debug, PartialEq)]
pub enum ModifyClusterIamRolesError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl ModifyClusterIamRolesError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyClusterIamRolesError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterIamRolesError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            ModifyClusterIamRolesError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterIamRolesError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterIamRolesError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyClusterIamRolesError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterIamRolesError {}
/// Errors returned by ModifyClusterMaintenance
#[derive(Debug, PartialEq)]
pub enum ModifyClusterMaintenanceError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl ModifyClusterMaintenanceError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyClusterMaintenanceError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterMaintenanceError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            ModifyClusterMaintenanceError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterMaintenanceError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterMaintenanceError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterMaintenanceError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterMaintenanceError {}
/// Errors returned by ModifyClusterParameterGroup
#[derive(Debug, PartialEq)]
pub enum ModifyClusterParameterGroupError {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The cluster parameter group action can not be completed because another task is in progress that involves the parameter group. Wait a few moments and try the operation again.</p>
    InvalidClusterParameterGroupStateFault(String),
}

impl ModifyClusterParameterGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ModifyClusterParameterGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterParameterGroupError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterParameterGroupState" => return RusotoError::Service(
                        ModifyClusterParameterGroupError::InvalidClusterParameterGroupStateFault(
                            parsed_error.message,
                        ),
                    ),
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterParameterGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterParameterGroupError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterParameterGroupError::InvalidClusterParameterGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterParameterGroupError {}
/// Errors returned by ModifyClusterSnapshot
#[derive(Debug, PartialEq)]
pub enum ModifyClusterSnapshotError {
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
}

impl ModifyClusterSnapshotError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyClusterSnapshotError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            ModifyClusterSnapshotError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSnapshotState" => {
                        return RusotoError::Service(
                            ModifyClusterSnapshotError::InvalidClusterSnapshotStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            ModifyClusterSnapshotError::InvalidRetentionPeriodFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterSnapshotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterSnapshotError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterSnapshotError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterSnapshotError::InvalidRetentionPeriodFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterSnapshotError {}
/// Errors returned by ModifyClusterSnapshotSchedule
#[derive(Debug, PartialEq)]
pub enum ModifyClusterSnapshotScheduleError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The cluster snapshot schedule state is not valid.</p>
    InvalidClusterSnapshotScheduleStateFault(String),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(String),
}

impl ModifyClusterSnapshotScheduleError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ModifyClusterSnapshotScheduleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                                    "ClusterNotFound" => return RusotoError::Service(ModifyClusterSnapshotScheduleError::ClusterNotFoundFault(parsed_error.message)),"InvalidClusterSnapshotScheduleState" => return RusotoError::Service(ModifyClusterSnapshotScheduleError::InvalidClusterSnapshotScheduleStateFault(parsed_error.message)),"SnapshotScheduleNotFound" => return RusotoError::Service(ModifyClusterSnapshotScheduleError::SnapshotScheduleNotFoundFault(parsed_error.message)),_ => {}
                                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterSnapshotScheduleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterSnapshotScheduleError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterSnapshotScheduleError::InvalidClusterSnapshotScheduleStateFault(
                ref cause,
            ) => write!(f, "{}", cause),
            ModifyClusterSnapshotScheduleError::SnapshotScheduleNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterSnapshotScheduleError {}
/// Errors returned by ModifyClusterSubnetGroup
#[derive(Debug, PartialEq)]
pub enum ModifyClusterSubnetGroupError {
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>
    ClusterSubnetGroupNotFoundFault(String),
    /// <p>The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterSubnetQuotaExceededFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same VPC.</p>
    InvalidSubnet(String),
    /// <p>A specified subnet is already in use by another cluster.</p>
    SubnetAlreadyInUse(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl ModifyClusterSubnetGroupError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyClusterSubnetGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterSubnetGroupNotFoundFault" => {
                        return RusotoError::Service(
                            ModifyClusterSubnetGroupError::ClusterSubnetGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSubnetQuotaExceededFault" => {
                        return RusotoError::Service(
                            ModifyClusterSubnetGroupError::ClusterSubnetQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            ModifyClusterSubnetGroupError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidSubnet" => {
                        return RusotoError::Service(ModifyClusterSubnetGroupError::InvalidSubnet(
                            parsed_error.message,
                        ))
                    }
                    "SubnetAlreadyInUse" => {
                        return RusotoError::Service(
                            ModifyClusterSubnetGroupError::SubnetAlreadyInUse(parsed_error.message),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            ModifyClusterSubnetGroupError::UnauthorizedOperation(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyClusterSubnetGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyClusterSubnetGroupError::ClusterSubnetGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterSubnetGroupError::ClusterSubnetQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterSubnetGroupError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyClusterSubnetGroupError::InvalidSubnet(ref cause) => write!(f, "{}", cause),
            ModifyClusterSubnetGroupError::SubnetAlreadyInUse(ref cause) => write!(f, "{}", cause),
            ModifyClusterSubnetGroupError::UnauthorizedOperation(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyClusterSubnetGroupError {}
/// Errors returned by ModifyEndpointAccess
#[derive(Debug, PartialEq)]
pub enum ModifyEndpointAccessError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl ModifyEndpointAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyEndpointAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            ModifyEndpointAccessError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "EndpointNotFound" => {
                        return RusotoError::Service(
                            ModifyEndpointAccessError::EndpointNotFoundFault(parsed_error.message),
                        )
                    }
                    "InvalidClusterSecurityGroupState" => {
                        return RusotoError::Service(
                            ModifyEndpointAccessError::InvalidClusterSecurityGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            ModifyEndpointAccessError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidEndpointState" => {
                        return RusotoError::Service(
                            ModifyEndpointAccessError::InvalidEndpointStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            ModifyEndpointAccessError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyEndpointAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyEndpointAccessError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyEndpointAccessError::EndpointNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyEndpointAccessError::InvalidClusterSecurityGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEndpointAccessError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEndpointAccessError::InvalidEndpointStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEndpointAccessError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ModifyEndpointAccessError {}
/// Errors returned by ModifyEventSubscription
#[derive(Debug, PartialEq)]
pub enum ModifyEventSubscriptionError {
    /// <p>The subscription request is invalid because it is a duplicate request. This subscription request is already in progress.</p>
    InvalidSubscriptionStateFault(String),
    /// <p>Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.</p>
    SNSInvalidTopicFault(String),
    /// <p>You do not have permission to publish to the specified Amazon SNS topic.</p>
    SNSNoAuthorizationFault(String),
    /// <p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.</p>
    SNSTopicArnNotFoundFault(String),
    /// <p>The specified Amazon Redshift event source could not be found.</p>
    SourceNotFoundFault(String),
    /// <p>The value specified for the event category was not one of the allowed values, or it specified a category that does not apply to the specified source type. The allowed values are Configuration, Management, Monitoring, and Security.</p>
    SubscriptionCategoryNotFoundFault(String),
    /// <p>An Amazon Redshift event with the specified event ID does not exist.</p>
    SubscriptionEventIdNotFoundFault(String),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not exist.</p>
    SubscriptionNotFoundFault(String),
    /// <p>The value specified for the event severity was not one of the allowed values, or it specified a severity that does not apply to the specified source type. The allowed values are ERROR and INFO.</p>
    SubscriptionSeverityNotFoundFault(String),
}

impl ModifyEventSubscriptionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyEventSubscriptionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSubscriptionStateFault" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::InvalidSubscriptionStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SNSInvalidTopic" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SNSInvalidTopicFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SNSNoAuthorization" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SNSNoAuthorizationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SNSTopicArnNotFound" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SNSTopicArnNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SourceNotFound" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SourceNotFoundFault(parsed_error.message),
                        )
                    }
                    "SubscriptionCategoryNotFound" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SubscriptionCategoryNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionEventIdNotFound" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SubscriptionEventIdNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionNotFound" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SubscriptionNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SubscriptionSeverityNotFound" => {
                        return RusotoError::Service(
                            ModifyEventSubscriptionError::SubscriptionSeverityNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyEventSubscriptionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyEventSubscriptionError::InvalidSubscriptionStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEventSubscriptionError::SNSInvalidTopicFault(ref cause) => write!(f, "{}", cause),
            ModifyEventSubscriptionError::SNSNoAuthorizationFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEventSubscriptionError::SNSTopicArnNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEventSubscriptionError::SourceNotFoundFault(ref cause) => write!(f, "{}", cause),
            ModifyEventSubscriptionError::SubscriptionCategoryNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEventSubscriptionError::SubscriptionEventIdNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEventSubscriptionError::SubscriptionNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyEventSubscriptionError::SubscriptionSeverityNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifyEventSubscriptionError {}
/// Errors returned by ModifyScheduledAction
#[derive(Debug, PartialEq)]
pub enum ModifyScheduledActionError {
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(String),
    /// <p>The scheduled action is not valid. </p>
    InvalidScheduledActionFault(String),
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(String),
    /// <p>The action type specified for a scheduled action is not supported. </p>
    ScheduledActionTypeUnsupportedFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl ModifyScheduledActionError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyScheduledActionError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSchedule" => {
                        return RusotoError::Service(
                            ModifyScheduledActionError::InvalidScheduleFault(parsed_error.message),
                        )
                    }
                    "InvalidScheduledAction" => {
                        return RusotoError::Service(
                            ModifyScheduledActionError::InvalidScheduledActionFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ScheduledActionNotFound" => {
                        return RusotoError::Service(
                            ModifyScheduledActionError::ScheduledActionNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ScheduledActionTypeUnsupported" => {
                        return RusotoError::Service(
                            ModifyScheduledActionError::ScheduledActionTypeUnsupportedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            ModifyScheduledActionError::UnauthorizedOperation(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyScheduledActionError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyScheduledActionError::InvalidScheduleFault(ref cause) => write!(f, "{}", cause),
            ModifyScheduledActionError::InvalidScheduledActionFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyScheduledActionError::ScheduledActionNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyScheduledActionError::ScheduledActionTypeUnsupportedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifyScheduledActionError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ModifyScheduledActionError {}
/// Errors returned by ModifySnapshotCopyRetentionPeriod
#[derive(Debug, PartialEq)]
pub enum ModifySnapshotCopyRetentionPeriodError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The retention period specified is either in the past or is not a valid value.</p> <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(String),
    /// <p>Cross-region snapshot copy was temporarily disabled. Try your request again.</p>
    SnapshotCopyDisabledFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl ModifySnapshotCopyRetentionPeriodError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ModifySnapshotCopyRetentionPeriodError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            ModifySnapshotCopyRetentionPeriodError::ClusterNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            ModifySnapshotCopyRetentionPeriodError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidRetentionPeriodFault" => {
                        return RusotoError::Service(
                            ModifySnapshotCopyRetentionPeriodError::InvalidRetentionPeriodFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotCopyDisabledFault" => {
                        return RusotoError::Service(
                            ModifySnapshotCopyRetentionPeriodError::SnapshotCopyDisabledFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            ModifySnapshotCopyRetentionPeriodError::UnauthorizedOperation(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifySnapshotCopyRetentionPeriodError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifySnapshotCopyRetentionPeriodError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifySnapshotCopyRetentionPeriodError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifySnapshotCopyRetentionPeriodError::InvalidRetentionPeriodFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifySnapshotCopyRetentionPeriodError::SnapshotCopyDisabledFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifySnapshotCopyRetentionPeriodError::UnauthorizedOperation(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifySnapshotCopyRetentionPeriodError {}
/// Errors returned by ModifySnapshotSchedule
#[derive(Debug, PartialEq)]
pub enum ModifySnapshotScheduleError {
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(String),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(String),
    /// <p>The specified snapshot schedule is already being updated.</p>
    SnapshotScheduleUpdateInProgressFault(String),
}

impl ModifySnapshotScheduleError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifySnapshotScheduleError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidSchedule" => {
                        return RusotoError::Service(
                            ModifySnapshotScheduleError::InvalidScheduleFault(parsed_error.message),
                        )
                    }
                    "SnapshotScheduleNotFound" => {
                        return RusotoError::Service(
                            ModifySnapshotScheduleError::SnapshotScheduleNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotScheduleUpdateInProgress" => {
                        return RusotoError::Service(
                            ModifySnapshotScheduleError::SnapshotScheduleUpdateInProgressFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifySnapshotScheduleError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifySnapshotScheduleError::InvalidScheduleFault(ref cause) => write!(f, "{}", cause),
            ModifySnapshotScheduleError::SnapshotScheduleNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ModifySnapshotScheduleError::SnapshotScheduleUpdateInProgressFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ModifySnapshotScheduleError {}
/// Errors returned by ModifyUsageLimit
#[derive(Debug, PartialEq)]
pub enum ModifyUsageLimitError {
    /// <p>The usage limit is not valid.</p>
    InvalidUsageLimitFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
    /// <p>The usage limit identifier can't be found.</p>
    UsageLimitNotFoundFault(String),
}

impl ModifyUsageLimitError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ModifyUsageLimitError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "InvalidUsageLimit" => {
                        return RusotoError::Service(ModifyUsageLimitError::InvalidUsageLimitFault(
                            parsed_error.message,
                        ))
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            ModifyUsageLimitError::UnsupportedOperationFault(parsed_error.message),
                        )
                    }
                    "UsageLimitNotFound" => {
                        return RusotoError::Service(
                            ModifyUsageLimitError::UsageLimitNotFoundFault(parsed_error.message),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ModifyUsageLimitError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ModifyUsageLimitError::InvalidUsageLimitFault(ref cause) => write!(f, "{}", cause),
            ModifyUsageLimitError::UnsupportedOperationFault(ref cause) => write!(f, "{}", cause),
            ModifyUsageLimitError::UsageLimitNotFoundFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ModifyUsageLimitError {}
/// Errors returned by PauseCluster
#[derive(Debug, PartialEq)]
pub enum PauseClusterError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl PauseClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<PauseClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(PauseClusterError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(PauseClusterError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PauseClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PauseClusterError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            PauseClusterError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for PauseClusterError {}
/// Errors returned by PurchaseReservedNodeOffering
#[derive(Debug, PartialEq)]
pub enum PurchaseReservedNodeOfferingError {
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedNodeAlreadyExistsFault(String),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(String),
    /// <p>Request would exceed the user's compute node quota. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ReservedNodeQuotaExceededFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl PurchaseReservedNodeOfferingError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<PurchaseReservedNodeOfferingError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ReservedNodeAlreadyExists" => {
                        return RusotoError::Service(
                            PurchaseReservedNodeOfferingError::ReservedNodeAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeOfferingNotFound" => {
                        return RusotoError::Service(
                            PurchaseReservedNodeOfferingError::ReservedNodeOfferingNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ReservedNodeQuotaExceeded" => {
                        return RusotoError::Service(
                            PurchaseReservedNodeOfferingError::ReservedNodeQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(
                            PurchaseReservedNodeOfferingError::UnsupportedOperationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for PurchaseReservedNodeOfferingError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            PurchaseReservedNodeOfferingError::ReservedNodeAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            PurchaseReservedNodeOfferingError::ReservedNodeOfferingNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            PurchaseReservedNodeOfferingError::ReservedNodeQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            PurchaseReservedNodeOfferingError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for PurchaseReservedNodeOfferingError {}
/// Errors returned by RebootCluster
#[derive(Debug, PartialEq)]
pub enum RebootClusterError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl RebootClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RebootClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(RebootClusterError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(RebootClusterError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RebootClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RebootClusterError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            RebootClusterError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RebootClusterError {}
/// Errors returned by ResetClusterParameterGroup
#[derive(Debug, PartialEq)]
pub enum ResetClusterParameterGroupError {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The cluster parameter group action can not be completed because another task is in progress that involves the parameter group. Wait a few moments and try the operation again.</p>
    InvalidClusterParameterGroupStateFault(String),
}

impl ResetClusterParameterGroupError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<ResetClusterParameterGroupError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            ResetClusterParameterGroupError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterParameterGroupState" => {
                        return RusotoError::Service(
                            ResetClusterParameterGroupError::InvalidClusterParameterGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ResetClusterParameterGroupError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ResetClusterParameterGroupError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ResetClusterParameterGroupError::InvalidClusterParameterGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for ResetClusterParameterGroupError {}
/// Errors returned by ResizeCluster
#[derive(Debug, PartialEq)]
pub enum ResizeClusterError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The number of nodes specified exceeds the allotted capacity of the cluster.</p>
    InsufficientClusterCapacityFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allotted to the account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    NumberOfNodesQuotaExceededFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
    /// <p>A request option was specified that is not supported.</p>
    UnsupportedOptionFault(String),
}

impl ResizeClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ResizeClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(ResizeClusterError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InsufficientClusterCapacity" => {
                        return RusotoError::Service(
                            ResizeClusterError::InsufficientClusterCapacityFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(ResizeClusterError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(ResizeClusterError::LimitExceededFault(
                            parsed_error.message,
                        ))
                    }
                    "NumberOfNodesPerClusterLimitExceeded" => {
                        return RusotoError::Service(
                            ResizeClusterError::NumberOfNodesPerClusterLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NumberOfNodesQuotaExceeded" => {
                        return RusotoError::Service(
                            ResizeClusterError::NumberOfNodesQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(ResizeClusterError::UnauthorizedOperation(
                            parsed_error.message,
                        ))
                    }
                    "UnsupportedOperation" => {
                        return RusotoError::Service(ResizeClusterError::UnsupportedOperationFault(
                            parsed_error.message,
                        ))
                    }
                    "UnsupportedOptionFault" => {
                        return RusotoError::Service(ResizeClusterError::UnsupportedOptionFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ResizeClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ResizeClusterError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ResizeClusterError::InsufficientClusterCapacityFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ResizeClusterError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
            ResizeClusterError::LimitExceededFault(ref cause) => write!(f, "{}", cause),
            ResizeClusterError::NumberOfNodesPerClusterLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ResizeClusterError::NumberOfNodesQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ResizeClusterError::UnauthorizedOperation(ref cause) => write!(f, "{}", cause),
            ResizeClusterError::UnsupportedOperationFault(ref cause) => write!(f, "{}", cause),
            ResizeClusterError::UnsupportedOptionFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ResizeClusterError {}
/// Errors returned by RestoreFromClusterSnapshot
#[derive(Debug, PartialEq)]
pub enum RestoreFromClusterSnapshotError {
    /// <p>The owner of the specified snapshot has not authorized your account to access the snapshot.</p>
    AccessToSnapshotDeniedFault(String),
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(String),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(String),
    /// <p>The request would exceed the allowed number of cluster instances for this account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ClusterQuotaExceededFault(String),
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet group.</p>
    ClusterSubnetGroupNotFoundFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified identifier.</p>
    HsmClientCertificateNotFoundFault(String),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(String),
    /// <p>The number of nodes specified exceeds the allotted capacity of the cluster.</p>
    InsufficientClusterCapacityFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(String),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(String),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(String),
    /// <p>The restore is invalid.</p>
    InvalidRestoreFault(String),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same VPC.</p>
    InvalidSubnet(String),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(String),
    /// <p>The cluster subnet group does not cover all Availability Zones.</p>
    InvalidVPCNetworkStateFault(String),
    /// <p>The encryption key has exceeded its grant limit in AWS KMS.</p>
    LimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(String),
    /// <p>The operation would exceed the number of nodes allotted to the account. For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    NumberOfNodesQuotaExceededFault(String),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(String),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(String),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(String),
}

impl RestoreFromClusterSnapshotError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RestoreFromClusterSnapshotError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "AccessToSnapshotDenied" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::AccessToSnapshotDeniedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterAlreadyExists" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::ClusterAlreadyExistsFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterParameterGroupNotFound" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::ClusterParameterGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterQuotaExceeded" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::ClusterQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSecurityGroupNotFound" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::ClusterSecurityGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSubnetGroupNotFoundFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::ClusterSubnetGroupNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmClientCertificateNotFoundFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::HsmClientCertificateNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "HsmConfigurationNotFoundFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::HsmConfigurationNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InsufficientClusterCapacity" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InsufficientClusterCapacityFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSnapshotState" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidClusterSnapshotStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSubnetGroupStateFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidClusterSubnetGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterTrack" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidClusterTrackFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidElasticIpFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidElasticIpFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidRestore" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidRestoreFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidSubnet" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidSubnet(parsed_error.message),
                        )
                    }
                    "InvalidTagFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidTagFault(parsed_error.message),
                        )
                    }
                    "InvalidVPCNetworkStateFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::InvalidVPCNetworkStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "LimitExceededFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::LimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "NumberOfNodesPerClusterLimitExceeded" => return RusotoError::Service(
                        RestoreFromClusterSnapshotError::NumberOfNodesPerClusterLimitExceededFault(
                            parsed_error.message,
                        ),
                    ),
                    "NumberOfNodesQuotaExceeded" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::NumberOfNodesQuotaExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "SnapshotScheduleNotFound" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::SnapshotScheduleNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "TagLimitExceededFault" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::TagLimitExceededFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "UnauthorizedOperation" => {
                        return RusotoError::Service(
                            RestoreFromClusterSnapshotError::UnauthorizedOperation(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RestoreFromClusterSnapshotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RestoreFromClusterSnapshotError::AccessToSnapshotDeniedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::ClusterAlreadyExistsFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::ClusterParameterGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::ClusterQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::ClusterSecurityGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::ClusterSubnetGroupNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::HsmClientCertificateNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::HsmConfigurationNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InsufficientClusterCapacityFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InvalidClusterSubnetGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InvalidClusterTrackFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InvalidElasticIpFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InvalidRestoreFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::InvalidSubnet(ref cause) => write!(f, "{}", cause),
            RestoreFromClusterSnapshotError::InvalidTagFault(ref cause) => write!(f, "{}", cause),
            RestoreFromClusterSnapshotError::InvalidVPCNetworkStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::LimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::NumberOfNodesPerClusterLimitExceededFault(
                ref cause,
            ) => write!(f, "{}", cause),
            RestoreFromClusterSnapshotError::NumberOfNodesQuotaExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::SnapshotScheduleNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::TagLimitExceededFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreFromClusterSnapshotError::UnauthorizedOperation(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for RestoreFromClusterSnapshotError {}
/// Errors returned by RestoreTableFromClusterSnapshot
#[derive(Debug, PartialEq)]
pub enum RestoreTableFromClusterSnapshotError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
    /// <p>You have exceeded the allowed number of table restore requests. Wait for your current table restore requests to complete before making a new request.</p>
    InProgressTableRestoreQuotaExceededFault(String),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The value specified for the <code>sourceDatabaseName</code>, <code>sourceSchemaName</code>, or <code>sourceTableName</code> parameter, or a combination of these, doesn't exist in the snapshot.</p>
    InvalidTableRestoreArgumentFault(String),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(String),
}

impl RestoreTableFromClusterSnapshotError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RestoreTableFromClusterSnapshotError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                                    "ClusterNotFound" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::ClusterNotFoundFault(parsed_error.message)),"ClusterSnapshotNotFound" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::ClusterSnapshotNotFoundFault(parsed_error.message)),"InProgressTableRestoreQuotaExceededFault" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::InProgressTableRestoreQuotaExceededFault(parsed_error.message)),"InvalidClusterSnapshotState" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::InvalidClusterSnapshotStateFault(parsed_error.message)),"InvalidClusterState" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::InvalidClusterStateFault(parsed_error.message)),"InvalidTableRestoreArgument" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::InvalidTableRestoreArgumentFault(parsed_error.message)),"UnsupportedOperation" => return RusotoError::Service(RestoreTableFromClusterSnapshotError::UnsupportedOperationFault(parsed_error.message)),_ => {}
                                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RestoreTableFromClusterSnapshotError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RestoreTableFromClusterSnapshotError::ClusterNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreTableFromClusterSnapshotError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreTableFromClusterSnapshotError::InProgressTableRestoreQuotaExceededFault(
                ref cause,
            ) => write!(f, "{}", cause),
            RestoreTableFromClusterSnapshotError::InvalidClusterSnapshotStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreTableFromClusterSnapshotError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreTableFromClusterSnapshotError::InvalidTableRestoreArgumentFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RestoreTableFromClusterSnapshotError::UnsupportedOperationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for RestoreTableFromClusterSnapshotError {}
/// Errors returned by ResumeCluster
#[derive(Debug, PartialEq)]
pub enum ResumeClusterError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The number of nodes specified exceeds the allotted capacity of the cluster.</p>
    InsufficientClusterCapacityFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl ResumeClusterError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<ResumeClusterError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(ResumeClusterError::ClusterNotFoundFault(
                            parsed_error.message,
                        ))
                    }
                    "InsufficientClusterCapacity" => {
                        return RusotoError::Service(
                            ResumeClusterError::InsufficientClusterCapacityFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(ResumeClusterError::InvalidClusterStateFault(
                            parsed_error.message,
                        ))
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for ResumeClusterError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            ResumeClusterError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            ResumeClusterError::InsufficientClusterCapacityFault(ref cause) => {
                write!(f, "{}", cause)
            }
            ResumeClusterError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for ResumeClusterError {}
/// Errors returned by RevokeClusterSecurityGroupIngress
#[derive(Debug, PartialEq)]
pub enum RevokeClusterSecurityGroupIngressError {
    /// <p>The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security group.</p>
    AuthorizationNotFoundFault(String),
    /// <p>The cluster security group name does not refer to an existing cluster security group.</p>
    ClusterSecurityGroupNotFoundFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
}

impl RevokeClusterSecurityGroupIngressError {
    pub fn from_response(
        res: BufferedHttpResponse,
    ) -> RusotoError<RevokeClusterSecurityGroupIngressError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                                    "AuthorizationNotFound" => return RusotoError::Service(RevokeClusterSecurityGroupIngressError::AuthorizationNotFoundFault(parsed_error.message)),"ClusterSecurityGroupNotFound" => return RusotoError::Service(RevokeClusterSecurityGroupIngressError::ClusterSecurityGroupNotFoundFault(parsed_error.message)),"InvalidClusterSecurityGroupState" => return RusotoError::Service(RevokeClusterSecurityGroupIngressError::InvalidClusterSecurityGroupStateFault(parsed_error.message)),_ => {}
                                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RevokeClusterSecurityGroupIngressError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RevokeClusterSecurityGroupIngressError::AuthorizationNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeClusterSecurityGroupIngressError::ClusterSecurityGroupNotFoundFault(
                ref cause,
            ) => write!(f, "{}", cause),
            RevokeClusterSecurityGroupIngressError::InvalidClusterSecurityGroupStateFault(
                ref cause,
            ) => write!(f, "{}", cause),
        }
    }
}
impl Error for RevokeClusterSecurityGroupIngressError {}
/// Errors returned by RevokeEndpointAccess
#[derive(Debug, PartialEq)]
pub enum RevokeEndpointAccessError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The authorization for this endpoint can't be found.</p>
    EndpointAuthorizationNotFoundFault(String),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(String),
    /// <p>The status of the authorization is not valid.</p>
    InvalidAuthorizationStateFault(String),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(String),
}

impl RevokeEndpointAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RevokeEndpointAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "EndpointAuthorizationNotFound" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::EndpointAuthorizationNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "EndpointNotFound" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::EndpointNotFoundFault(parsed_error.message),
                        )
                    }
                    "InvalidAuthorizationState" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::InvalidAuthorizationStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterSecurityGroupState" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::InvalidClusterSecurityGroupStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidEndpointState" => {
                        return RusotoError::Service(
                            RevokeEndpointAccessError::InvalidEndpointStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RevokeEndpointAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RevokeEndpointAccessError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            RevokeEndpointAccessError::EndpointAuthorizationNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeEndpointAccessError::EndpointNotFoundFault(ref cause) => write!(f, "{}", cause),
            RevokeEndpointAccessError::InvalidAuthorizationStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeEndpointAccessError::InvalidClusterSecurityGroupStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeEndpointAccessError::InvalidClusterStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeEndpointAccessError::InvalidEndpointStateFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for RevokeEndpointAccessError {}
/// Errors returned by RevokeSnapshotAccess
#[derive(Debug, PartialEq)]
pub enum RevokeSnapshotAccessError {
    /// <p>The owner of the specified snapshot has not authorized your account to access the snapshot.</p>
    AccessToSnapshotDeniedFault(String),
    /// <p>The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security group.</p>
    AuthorizationNotFoundFault(String),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(String),
}

impl RevokeSnapshotAccessError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RevokeSnapshotAccessError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "AccessToSnapshotDenied" => {
                        return RusotoError::Service(
                            RevokeSnapshotAccessError::AccessToSnapshotDeniedFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "AuthorizationNotFound" => {
                        return RusotoError::Service(
                            RevokeSnapshotAccessError::AuthorizationNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "ClusterSnapshotNotFound" => {
                        return RusotoError::Service(
                            RevokeSnapshotAccessError::ClusterSnapshotNotFoundFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RevokeSnapshotAccessError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RevokeSnapshotAccessError::AccessToSnapshotDeniedFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeSnapshotAccessError::AuthorizationNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RevokeSnapshotAccessError::ClusterSnapshotNotFoundFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for RevokeSnapshotAccessError {}
/// Errors returned by RotateEncryptionKey
#[derive(Debug, PartialEq)]
pub enum RotateEncryptionKeyError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The request cannot be completed because a dependent service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(String),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(String),
}

impl RotateEncryptionKeyError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<RotateEncryptionKeyError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            RotateEncryptionKeyError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "DependentServiceRequestThrottlingFault" => {
                        return RusotoError::Service(
                            RotateEncryptionKeyError::DependentServiceRequestThrottlingFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    "InvalidClusterState" => {
                        return RusotoError::Service(
                            RotateEncryptionKeyError::InvalidClusterStateFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for RotateEncryptionKeyError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            RotateEncryptionKeyError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            RotateEncryptionKeyError::DependentServiceRequestThrottlingFault(ref cause) => {
                write!(f, "{}", cause)
            }
            RotateEncryptionKeyError::InvalidClusterStateFault(ref cause) => write!(f, "{}", cause),
        }
    }
}
impl Error for RotateEncryptionKeyError {}
/// Errors returned by UpdatePartnerStatus
#[derive(Debug, PartialEq)]
pub enum UpdatePartnerStatusError {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster. </p>
    ClusterNotFoundFault(String),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(String),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(String),
}

impl UpdatePartnerStatusError {
    pub fn from_response(res: BufferedHttpResponse) -> RusotoError<UpdatePartnerStatusError> {
        {
            let reader = EventReader::new(res.body.as_ref());
            let mut stack = XmlResponse::new(reader.into_iter().peekable());
            find_start_element(&mut stack);
            if let Ok(parsed_error) = Self::deserialize(&mut stack) {
                match &parsed_error.code[..] {
                    "ClusterNotFound" => {
                        return RusotoError::Service(
                            UpdatePartnerStatusError::ClusterNotFoundFault(parsed_error.message),
                        )
                    }
                    "PartnerNotFound" => {
                        return RusotoError::Service(
                            UpdatePartnerStatusError::PartnerNotFoundFault(parsed_error.message),
                        )
                    }
                    "UnauthorizedPartnerIntegration" => {
                        return RusotoError::Service(
                            UpdatePartnerStatusError::UnauthorizedPartnerIntegrationFault(
                                parsed_error.message,
                            ),
                        )
                    }
                    _ => {}
                }
            }
        }
        RusotoError::Unknown(res)
    }

    fn deserialize<T>(stack: &mut T) -> Result<XmlError, XmlParseError>
    where
        T: Peek + Next,
    {
        xml_util::start_element("ErrorResponse", stack)?;
        XmlErrorDeserializer::deserialize("Error", stack)
    }
}
impl fmt::Display for UpdatePartnerStatusError {
    #[allow(unused_variables)]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            UpdatePartnerStatusError::ClusterNotFoundFault(ref cause) => write!(f, "{}", cause),
            UpdatePartnerStatusError::PartnerNotFoundFault(ref cause) => write!(f, "{}", cause),
            UpdatePartnerStatusError::UnauthorizedPartnerIntegrationFault(ref cause) => {
                write!(f, "{}", cause)
            }
        }
    }
}
impl Error for UpdatePartnerStatusError {}
/// Trait representing the capabilities of the Amazon Redshift API. Amazon Redshift clients implement this trait.
#[async_trait]
pub trait Redshift {
    /// <p>Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs. </p>
    async fn accept_reserved_node_exchange(
        &self,
        input: AcceptReservedNodeExchangeInputMessage,
    ) -> Result<AcceptReservedNodeExchangeOutputMessage, RusotoError<AcceptReservedNodeExchangeError>>;

    /// <p>Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.</p>
    async fn add_partner(
        &self,
        input: PartnerIntegrationInputMessage,
    ) -> Result<PartnerIntegrationOutputMessage, RusotoError<AddPartnerError>>;

    /// <p>Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.</p> <p>If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same AWS Region. </p> <p>If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p> <p>You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn authorize_cluster_security_group_ingress(
        &self,
        input: AuthorizeClusterSecurityGroupIngressMessage,
    ) -> Result<
        AuthorizeClusterSecurityGroupIngressResult,
        RusotoError<AuthorizeClusterSecurityGroupIngressError>,
    >;

    /// <p>Grants access to a cluster.</p>
    async fn authorize_endpoint_access(
        &self,
        input: AuthorizeEndpointAccessMessage,
    ) -> Result<EndpointAuthorization, RusotoError<AuthorizeEndpointAccessError>>;

    /// <p>Authorizes the specified AWS customer account to restore the specified snapshot.</p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn authorize_snapshot_access(
        &self,
        input: AuthorizeSnapshotAccessMessage,
    ) -> Result<AuthorizeSnapshotAccessResult, RusotoError<AuthorizeSnapshotAccessError>>;

    /// <p>Deletes a set of cluster snapshots.</p>
    async fn batch_delete_cluster_snapshots(
        &self,
        input: BatchDeleteClusterSnapshotsRequest,
    ) -> Result<BatchDeleteClusterSnapshotsResult, RusotoError<BatchDeleteClusterSnapshotsError>>;

    /// <p>Modifies the settings for a set of cluster snapshots.</p>
    async fn batch_modify_cluster_snapshots(
        &self,
        input: BatchModifyClusterSnapshotsMessage,
    ) -> Result<
        BatchModifyClusterSnapshotsOutputMessage,
        RusotoError<BatchModifyClusterSnapshotsError>,
    >;

    /// <p>Cancels a resize operation for a cluster.</p>
    async fn cancel_resize(
        &self,
        input: CancelResizeMessage,
    ) -> Result<ResizeProgressMessage, RusotoError<CancelResizeError>>;

    /// <p>Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.</p> <p>When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.</p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn copy_cluster_snapshot(
        &self,
        input: CopyClusterSnapshotMessage,
    ) -> Result<CopyClusterSnapshotResult, RusotoError<CopyClusterSnapshotError>>;

    /// <p>Creates a new cluster with the specified parameters.</p> <p>To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn create_cluster(
        &self,
        input: CreateClusterMessage,
    ) -> Result<CreateClusterResult, RusotoError<CreateClusterError>>;

    /// <p>Creates an Amazon Redshift parameter group.</p> <p>Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using <a>ModifyCluster</a>. </p> <p>Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn create_cluster_parameter_group(
        &self,
        input: CreateClusterParameterGroupMessage,
    ) -> Result<CreateClusterParameterGroupResult, RusotoError<CreateClusterParameterGroupError>>;

    /// <p>Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.</p> <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn create_cluster_security_group(
        &self,
        input: CreateClusterSecurityGroupMessage,
    ) -> Result<CreateClusterSecurityGroupResult, RusotoError<CreateClusterSecurityGroupError>>;

    /// <p>Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state. </p> <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn create_cluster_snapshot(
        &self,
        input: CreateClusterSnapshotMessage,
    ) -> Result<CreateClusterSnapshotResult, RusotoError<CreateClusterSnapshotError>>;

    /// <p>Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.</p> <p> For information about subnet groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn create_cluster_subnet_group(
        &self,
        input: CreateClusterSubnetGroupMessage,
    ) -> Result<CreateClusterSubnetGroupResult, RusotoError<CreateClusterSubnetGroupError>>;

    /// <p>Creates a Redshift-managed VPC endpoint.</p>
    async fn create_endpoint_access(
        &self,
        input: CreateEndpointAccessMessage,
    ) -> Result<EndpointAccess, RusotoError<CreateEndpointAccessError>>;

    /// <p>Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p> <p>You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.</p> <p>If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your AWS account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your AWS account. You must specify a source type if you specify a source ID.</p>
    async fn create_event_subscription(
        &self,
        input: CreateEventSubscriptionMessage,
    ) -> Result<CreateEventSubscriptionResult, RusotoError<CreateEventSubscriptionError>>;

    /// <p>Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.</p> <p>The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware Security Modules</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn create_hsm_client_certificate(
        &self,
        input: CreateHsmClientCertificateMessage,
    ) -> Result<CreateHsmClientCertificateResult, RusotoError<CreateHsmClientCertificateError>>;

    /// <p>Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.</p> <p>In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware Security Modules</a> in the Amazon Redshift Cluster Management Guide.</p>
    async fn create_hsm_configuration(
        &self,
        input: CreateHsmConfigurationMessage,
    ) -> Result<CreateHsmConfigurationResult, RusotoError<CreateHsmConfigurationError>>;

    /// <p>Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation. </p>
    async fn create_scheduled_action(
        &self,
        input: CreateScheduledActionMessage,
    ) -> Result<ScheduledAction, RusotoError<CreateScheduledActionError>>;

    /// <p>Creates a snapshot copy grant that permits Amazon Redshift to use a customer master key (CMK) from AWS Key Management Service (AWS KMS) to encrypt copied snapshots in a destination region.</p> <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    async fn create_snapshot_copy_grant(
        &self,
        input: CreateSnapshotCopyGrantMessage,
    ) -> Result<CreateSnapshotCopyGrantResult, RusotoError<CreateSnapshotCopyGrantError>>;

    /// <p>Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule. </p>
    async fn create_snapshot_schedule(
        &self,
        input: CreateSnapshotScheduleMessage,
    ) -> Result<SnapshotSchedule, RusotoError<CreateSnapshotScheduleError>>;

    /// <p>Adds tags to a cluster.</p> <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.</p> <p>If you specify a key that already exists for the resource, the value for that key will be updated with the new value.</p>
    async fn create_tags(
        &self,
        input: CreateTagsMessage,
    ) -> Result<(), RusotoError<CreateTagsError>>;

    /// <p>Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.</p>
    async fn create_usage_limit(
        &self,
        input: CreateUsageLimitMessage,
    ) -> Result<UsageLimit, RusotoError<CreateUsageLimitError>>;

    /// <p>Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use <a>DescribeClusters</a> to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster. </p> <p> For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn delete_cluster(
        &self,
        input: DeleteClusterMessage,
    ) -> Result<DeleteClusterResult, RusotoError<DeleteClusterError>>;

    /// <p><p>Deletes a specified Amazon Redshift parameter group.</p> <note> <p>You cannot delete a parameter group if it is associated with a cluster.</p> </note></p>
    async fn delete_cluster_parameter_group(
        &self,
        input: DeleteClusterParameterGroupMessage,
    ) -> Result<(), RusotoError<DeleteClusterParameterGroupError>>;

    /// <p>Deletes an Amazon Redshift security group.</p> <note> <p>You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.</p> </note> <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn delete_cluster_security_group(
        &self,
        input: DeleteClusterSecurityGroupMessage,
    ) -> Result<(), RusotoError<DeleteClusterSecurityGroupError>>;

    /// <p>Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other users authorized to access the snapshot. </p> <p>Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.</p>
    async fn delete_cluster_snapshot(
        &self,
        input: DeleteClusterSnapshotMessage,
    ) -> Result<DeleteClusterSnapshotResult, RusotoError<DeleteClusterSnapshotError>>;

    /// <p>Deletes the specified cluster subnet group.</p>
    async fn delete_cluster_subnet_group(
        &self,
        input: DeleteClusterSubnetGroupMessage,
    ) -> Result<(), RusotoError<DeleteClusterSubnetGroupError>>;

    /// <p>Deletes a Redshift-managed VPC endpoint.</p>
    async fn delete_endpoint_access(
        &self,
        input: DeleteEndpointAccessMessage,
    ) -> Result<EndpointAccess, RusotoError<DeleteEndpointAccessError>>;

    /// <p>Deletes an Amazon Redshift event notification subscription.</p>
    async fn delete_event_subscription(
        &self,
        input: DeleteEventSubscriptionMessage,
    ) -> Result<(), RusotoError<DeleteEventSubscriptionError>>;

    /// <p>Deletes the specified HSM client certificate.</p>
    async fn delete_hsm_client_certificate(
        &self,
        input: DeleteHsmClientCertificateMessage,
    ) -> Result<(), RusotoError<DeleteHsmClientCertificateError>>;

    /// <p>Deletes the specified Amazon Redshift HSM configuration.</p>
    async fn delete_hsm_configuration(
        &self,
        input: DeleteHsmConfigurationMessage,
    ) -> Result<(), RusotoError<DeleteHsmConfigurationError>>;

    /// <p>Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.</p>
    async fn delete_partner(
        &self,
        input: PartnerIntegrationInputMessage,
    ) -> Result<PartnerIntegrationOutputMessage, RusotoError<DeletePartnerError>>;

    /// <p>Deletes a scheduled action. </p>
    async fn delete_scheduled_action(
        &self,
        input: DeleteScheduledActionMessage,
    ) -> Result<(), RusotoError<DeleteScheduledActionError>>;

    /// <p>Deletes the specified snapshot copy grant.</p>
    async fn delete_snapshot_copy_grant(
        &self,
        input: DeleteSnapshotCopyGrantMessage,
    ) -> Result<(), RusotoError<DeleteSnapshotCopyGrantError>>;

    /// <p>Deletes a snapshot schedule.</p>
    async fn delete_snapshot_schedule(
        &self,
        input: DeleteSnapshotScheduleMessage,
    ) -> Result<(), RusotoError<DeleteSnapshotScheduleError>>;

    /// <p>Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.</p>
    async fn delete_tags(
        &self,
        input: DeleteTagsMessage,
    ) -> Result<(), RusotoError<DeleteTagsError>>;

    /// <p>Deletes a usage limit from a cluster.</p>
    async fn delete_usage_limit(
        &self,
        input: DeleteUsageLimitMessage,
    ) -> Result<(), RusotoError<DeleteUsageLimitError>>;

    /// <p>Returns a list of attributes attached to an account</p>
    async fn describe_account_attributes(
        &self,
        input: DescribeAccountAttributesMessage,
    ) -> Result<AccountAttributeList, RusotoError<DescribeAccountAttributesError>>;

    /// <p>Returns an array of <code>ClusterDbRevision</code> objects.</p>
    async fn describe_cluster_db_revisions(
        &self,
        input: DescribeClusterDbRevisionsMessage,
    ) -> Result<ClusterDbRevisionsMessage, RusotoError<DescribeClusterDbRevisionsError>>;

    /// <p>Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter groups that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_cluster_parameter_groups(
        &self,
        input: DescribeClusterParameterGroupsMessage,
    ) -> Result<ClusterParameterGroupsMessage, RusotoError<DescribeClusterParameterGroupsError>>;

    /// <p>Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.</p> <p>You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify <i>source</i> equal to <i>user</i>.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn describe_cluster_parameters(
        &self,
        input: DescribeClusterParametersMessage,
    ) -> Result<ClusterParameterGroupDetails, RusotoError<DescribeClusterParametersError>>;

    /// <p>Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.</p> <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security groups that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_cluster_security_groups(
        &self,
        input: DescribeClusterSecurityGroupsMessage,
    ) -> Result<ClusterSecurityGroupMessage, RusotoError<DescribeClusterSecurityGroupsError>>;

    /// <p>Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No information is returned for snapshots owned by inactive AWS customer accounts.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.</p> <p>If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_cluster_snapshots(
        &self,
        input: DescribeClusterSnapshotsMessage,
    ) -> Result<SnapshotMessage, RusotoError<DescribeClusterSnapshotsError>>;

    /// <p>Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in you AWS account.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet groups that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_cluster_subnet_groups(
        &self,
        input: DescribeClusterSubnetGroupsMessage,
    ) -> Result<ClusterSubnetGroupMessage, RusotoError<DescribeClusterSubnetGroupsError>>;

    /// <p>Returns a list of all the available maintenance tracks.</p>
    async fn describe_cluster_tracks(
        &self,
        input: DescribeClusterTracksMessage,
    ) -> Result<TrackListMessage, RusotoError<DescribeClusterTracksError>>;

    /// <p>Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn describe_cluster_versions(
        &self,
        input: DescribeClusterVersionsMessage,
    ) -> Result<ClusterVersionsMessage, RusotoError<DescribeClusterVersionsError>>;

    /// <p>Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_clusters(
        &self,
        input: DescribeClustersMessage,
    ) -> Result<ClustersMessage, RusotoError<DescribeClustersError>>;

    /// <p>Returns a list of parameter settings for the specified parameter group family.</p> <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn describe_default_cluster_parameters(
        &self,
        input: DescribeDefaultClusterParametersMessage,
    ) -> Result<
        DescribeDefaultClusterParametersResult,
        RusotoError<DescribeDefaultClusterParametersError>,
    >;

    /// <p>Describes a Redshift-managed VPC endpoint.</p>
    async fn describe_endpoint_access(
        &self,
        input: DescribeEndpointAccessMessage,
    ) -> Result<EndpointAccessList, RusotoError<DescribeEndpointAccessError>>;

    /// <p>Describes an endpoint authorization.</p>
    async fn describe_endpoint_authorization(
        &self,
        input: DescribeEndpointAuthorizationMessage,
    ) -> Result<EndpointAuthorizationList, RusotoError<DescribeEndpointAuthorizationError>>;

    /// <p>Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift Event Notifications</a>.</p>
    async fn describe_event_categories(
        &self,
        input: DescribeEventCategoriesMessage,
    ) -> Result<EventCategoriesMessage, RusotoError<DescribeEventCategoriesError>>;

    /// <p>Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subscriptions that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_event_subscriptions(
        &self,
        input: DescribeEventSubscriptionsMessage,
    ) -> Result<EventSubscriptionsMessage, RusotoError<DescribeEventSubscriptionsError>>;

    /// <p>Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.</p>
    async fn describe_events(
        &self,
        input: DescribeEventsMessage,
    ) -> Result<EventsMessage, RusotoError<DescribeEventsError>>;

    /// <p>Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your AWS customer account.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM client certificates that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_hsm_client_certificates(
        &self,
        input: DescribeHsmClientCertificatesMessage,
    ) -> Result<HsmClientCertificateMessage, RusotoError<DescribeHsmClientCertificatesError>>;

    /// <p>Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your AWS customer account.</p> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM connections that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_hsm_configurations(
        &self,
        input: DescribeHsmConfigurationsMessage,
    ) -> Result<HsmConfigurationMessage, RusotoError<DescribeHsmConfigurationsError>>;

    /// <p>Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.</p>
    async fn describe_logging_status(
        &self,
        input: DescribeLoggingStatusMessage,
    ) -> Result<LoggingStatus, RusotoError<DescribeLoggingStatusError>>;

    /// <p>Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.</p>
    async fn describe_node_configuration_options(
        &self,
        input: DescribeNodeConfigurationOptionsMessage,
    ) -> Result<NodeConfigurationOptionsMessage, RusotoError<DescribeNodeConfigurationOptionsError>>;

    /// <p>Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn describe_orderable_cluster_options(
        &self,
        input: DescribeOrderableClusterOptionsMessage,
    ) -> Result<OrderableClusterOptionsMessage, RusotoError<DescribeOrderableClusterOptionsError>>;

    /// <p>Returns information about the partner integrations defined for a cluster.</p>
    async fn describe_partners(
        &self,
        input: DescribePartnersInputMessage,
    ) -> Result<DescribePartnersOutputMessage, RusotoError<DescribePartnersError>>;

    /// <p>Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon Redshift cluster. </p> <p> For more information about reserved node offerings, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    async fn describe_reserved_node_offerings(
        &self,
        input: DescribeReservedNodeOfferingsMessage,
    ) -> Result<ReservedNodeOfferingsMessage, RusotoError<DescribeReservedNodeOfferingsError>>;

    /// <p>Returns the descriptions of the reserved nodes.</p>
    async fn describe_reserved_nodes(
        &self,
        input: DescribeReservedNodesMessage,
    ) -> Result<ReservedNodesMessage, RusotoError<DescribeReservedNodesError>>;

    /// <p>Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize. </p> <p>A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes for the cluster. </p>
    async fn describe_resize(
        &self,
        input: DescribeResizeMessage,
    ) -> Result<ResizeProgressMessage, RusotoError<DescribeResizeError>>;

    /// <p>Describes properties of scheduled actions. </p>
    async fn describe_scheduled_actions(
        &self,
        input: DescribeScheduledActionsMessage,
    ) -> Result<ScheduledActionsMessage, RusotoError<DescribeScheduledActionsError>>;

    /// <p>Returns a list of snapshot copy grants owned by the AWS account in the destination region.</p> <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    async fn describe_snapshot_copy_grants(
        &self,
        input: DescribeSnapshotCopyGrantsMessage,
    ) -> Result<SnapshotCopyGrantMessage, RusotoError<DescribeSnapshotCopyGrantsError>>;

    /// <p>Returns a list of snapshot schedules. </p>
    async fn describe_snapshot_schedules(
        &self,
        input: DescribeSnapshotSchedulesMessage,
    ) -> Result<DescribeSnapshotSchedulesOutputMessage, RusotoError<DescribeSnapshotSchedulesError>>;

    /// <p>Returns account level backups storage size and provisional storage.</p>
    async fn describe_storage(
        &self,
    ) -> Result<CustomerStorageMessage, RusotoError<DescribeStorageError>>;

    /// <p>Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of the table specified by <code>TableRestoreRequestId</code>.</p>
    async fn describe_table_restore_status(
        &self,
        input: DescribeTableRestoreStatusMessage,
    ) -> Result<TableRestoreStatusMessage, RusotoError<DescribeTableRestoreStatusError>>;

    /// <p>Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.</p> <p>The following are limitations for <code>DescribeTags</code>: </p> <ul> <li> <p>You cannot specify an ARN and a resource-type value together in the same request.</p> </li> <li> <p>You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.</p> </li> <li> <p>The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.</p> </li> </ul> <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources that have any combination of those values are returned.</p> <p>If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.</p>
    async fn describe_tags(
        &self,
        input: DescribeTagsMessage,
    ) -> Result<TaggedResourceListMessage, RusotoError<DescribeTagsError>>;

    /// <p><p>Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:</p> <ul> <li> <p>If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.</p> </li> <li> <p>If usage limit identifier is provided, then the corresponding usage limit object is returned.</p> </li> <li> <p>If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.</p> </li> <li> <p>If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.</p> </li> </ul></p>
    async fn describe_usage_limits(
        &self,
        input: DescribeUsageLimitsMessage,
    ) -> Result<UsageLimitList, RusotoError<DescribeUsageLimitsError>>;

    /// <p>Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.</p>
    async fn disable_logging(
        &self,
        input: DisableLoggingMessage,
    ) -> Result<LoggingStatus, RusotoError<DisableLoggingError>>;

    /// <p>Disables the automatic copying of snapshots from one region to another region for a specified cluster.</p> <p>If your cluster and its snapshots are encrypted using a customer master key (CMK) from AWS KMS, use <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the CMK in the destination region. </p>
    async fn disable_snapshot_copy(
        &self,
        input: DisableSnapshotCopyMessage,
    ) -> Result<DisableSnapshotCopyResult, RusotoError<DisableSnapshotCopyError>>;

    /// <p>Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.</p>
    async fn enable_logging(
        &self,
        input: EnableLoggingMessage,
    ) -> Result<LoggingStatus, RusotoError<EnableLoggingError>>;

    /// <p>Enables the automatic copy of snapshots from one region to another region for a specified cluster.</p>
    async fn enable_snapshot_copy(
        &self,
        input: EnableSnapshotCopyMessage,
    ) -> Result<EnableSnapshotCopyResult, RusotoError<EnableSnapshotCopyError>>;

    /// <p>Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.</p> <p>The AWS Identity and Access Management (IAM)user or role that executes GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources">Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.</p> <p>If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>. </p> <p>In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include the <code>redshift:CreateClusterUser</code> privilege.</p> <p>If the <code>DbName</code> parameter is specified, the IAM pol